/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.ebaiyihui.common.vo.role.SaveRoleAuthParamVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.server.exception.BusinessException;
import com.ebaiyihui.server.mapper.AuthMapper;
import com.ebaiyihui.server.mapper.RoleAuthMapper;
import com.ebaiyihui.server.mapper.RoleMapper;
import com.ebaiyihui.server.pojo.entity.RoleEntity;
import com.ebaiyihui.server.service.RoleAuthService;
import com.ebaiyihui.server.service.impl.AuthUrlToRedisService;
import com.ebaiyihui.server.utils.StringUtil;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RoleAuthServiceImpl
implements RoleAuthService {
    private static final Logger log = LoggerFactory.getLogger(RoleAuthServiceImpl.class);
    @Autowired
    private RoleAuthMapper roleAuthMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private AuthMapper authMapper;
    @Autowired
    private AuthUrlToRedisService authUrlToRedisService;

    public BaseResponse<Object> saveRoleAuth(SaveRoleAuthParamVO param) {
        String authIds = String.join((CharSequence)",", param.getAuthIds());
        String noAuthIds = String.join((CharSequence)",", param.getNoAuthIds());
        if (StringUtil.isNotBlank((String)authIds)) {
            this.roleAuthMapper.uodateBindingInRoleIds(Long.valueOf(StringUtil.toLongValue((Object)param.getRoleId())), authIds, Integer.valueOf(1));
        }
        if (StringUtil.isNotBlank((String)noAuthIds)) {
            this.roleAuthMapper.uodateBindingInRoleIds(Long.valueOf(StringUtil.toLongValue((Object)param.getRoleId())), noAuthIds, Integer.valueOf(0));
        }
        RoleEntity roleEntity = this.roleMapper.findByRoleId(param.getRoleId());
        String[] roleIdArray = new String[]{param.getRoleId()};
        this.authUrlToRedisService.redisDelete(roleEntity.getAppCode(), roleIdArray);
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        List urlList = this.roleAuthMapper.selectUrlByRole(roleEntity.getId().toString());
        String[] urlArray = urlList.toArray(new String[0]);
        if (urlList.size() > 0) {
            map.put(roleEntity.getId().toString(), urlArray);
            this.authUrlToRedisService.redisSet(roleEntity.getAppCode(), map);
        }
        return BaseResponse.success();
    }

    private void setAuthForRole(List<String> authIds, RoleEntity roleEntity) throws BusinessException {
        List authEntities = this.authMapper.findAllByAuthIdIn(authIds);
        if (authEntities.size() != authIds.size()) {
            log.error("\u6743\u9650\u6570\u636e\u5f02\u5e38 -> auth_ids:{},auth_entities:{}", authIds, (Object)authEntities);
            throw new BusinessException((IError)IError.DATA_ERROR);
        }
        roleEntity.setAuthEntities(authEntities);
    }
}

