/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.ebaiyihui.common.vo.role.DeleteRoleParamVO;
import com.ebaiyihui.common.vo.role.FetchListParamVO;
import com.ebaiyihui.common.vo.role.RoleInfoVO;
import com.ebaiyihui.common.vo.role.SaveRoleParamVO;
import com.ebaiyihui.common.vo.role.UpdateRoleParamVO;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.server.exception.BusinessException;
import com.ebaiyihui.server.mapper.AuthMapper;
import com.ebaiyihui.server.mapper.RoleAuthMapper;
import com.ebaiyihui.server.mapper.RoleMapper;
import com.ebaiyihui.server.mapper.UserRoleMapper;
import com.ebaiyihui.server.pojo.entity.AuthEntity;
import com.ebaiyihui.server.pojo.entity.RoleAuthEntity;
import com.ebaiyihui.server.pojo.entity.RoleEntity;
import com.ebaiyihui.server.pojo.entity.UserRoleEntity;
import com.ebaiyihui.server.service.DataScopeService;
import com.ebaiyihui.server.service.RoleService;
import com.ebaiyihui.server.service.impl.AuthUrlToRedisService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleServiceImpl
implements RoleService {
    private static final Logger log = LoggerFactory.getLogger(RoleServiceImpl.class);
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private AuthMapper authMapper;
    @Autowired
    private RoleAuthMapper roleAuthMapper;
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private DataScopeService dataScopeService;
    @Autowired
    private AuthUrlToRedisService authUrlToRedisService;

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> saveRole(SaveRoleParamVO param) {
        log.info("\u8f93\u5165\u7684\u89d2\u8272\u540d\u79f0:{}", (Object)param.getRoleName());
        RoleEntity roleEntityDb = this.roleMapper.findByRoleName(param.getRoleName(), param.getAppCode());
        if (roleEntityDb != null) {
            return BaseResponse.error((String)"\u8be5\u89d2\u8272\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        RoleEntity roleEntity = new RoleEntity();
        roleEntity.setIsDefault(Integer.valueOf(3));
        BeanUtils.copyProperties((Object)param, (Object)roleEntity);
        this.roleMapper.save(roleEntity);
        RoleEntity roleEntitydb = this.roleMapper.findByViewId(roleEntity.getViewId());
        List authIds = this.authMapper.findAllId(param.getAppCode());
        for (Long authId : authIds) {
            RoleAuthEntity roleAuthEntity = new RoleAuthEntity();
            roleAuthEntity.setAuthId(authId);
            roleAuthEntity.setRoleId(roleEntity.getId());
            this.roleAuthMapper.batchSave(roleAuthEntity);
        }
        this.dataScopeService.addDataScopeDefault(roleEntitydb.getId());
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        List urlList = this.roleAuthMapper.selectUrlByRole(roleEntitydb.getId().toString());
        String[] urlArray = urlList.toArray(new String[urlList.size()]);
        if (urlList.size() > 0) {
            map.put(roleEntitydb.getId().toString(), urlArray);
            this.authUrlToRedisService.redisSet(roleEntitydb.getAppCode(), map);
        }
        return BaseResponse.success();
    }

    public BaseResponse<Object> updateRole(UpdateRoleParamVO param) {
        RoleEntity roleEntitydb;
        log.info("\u9700\u8981\u4fee\u6539\u7684\u89d2\u8272ID:{},\u89d2\u8272\u540d\u79f0:{},\u62e5\u6709\u7684\u6743\u9650\u7684ID\u96c6\u5408:{}", new Object[]{param.getRoleId(), param.getRoleName(), param.getAuthIds()});
        RoleEntity roleEntity = this.roleMapper.findByRoleId(param.getRoleId());
        if (roleEntity == null) {
            log.info("\u6839\u636e\u89d2\u8272ID\u67e5\u8be2\u5230\u7684\u89d2\u8272:{}", (Object)roleEntity);
            return BaseResponse.error((IError)IError.DATA_NOT_EXIST);
        }
        if (param.getAuthIds() != null && !param.getAuthIds().isEmpty()) {
            this.setAuthForRole(param.getAuthIds(), roleEntity);
            List authEntityList = roleEntity.getAuthEntities();
            List roleAuthEntityList = this.convertAuthEntityListToRoleAuthEntityList(authEntityList, roleEntity.getId());
            this.roleAuthMapper.deleteByRoleId(roleEntity.getId());
            for (RoleAuthEntity roleAuthEntity : roleAuthEntityList) {
                this.roleAuthMapper.batchSave(roleAuthEntity);
            }
        }
        if ((roleEntitydb = this.roleMapper.findByRoleName(param.getRoleName(), param.getAppCode())) != null) {
            return BaseResponse.error((String)"\u8be5\u89d2\u8272\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        roleEntity.setRoleName(param.getRoleName());
        this.roleMapper.update(roleEntity);
        return BaseResponse.success();
    }

    public BaseResponse<Object> deleteRole(DeleteRoleParamVO param) {
        List userRoleEntities = this.userRoleMapper.findByRoleId(param.getRoleId());
        RoleEntity roleEntity = this.roleMapper.findByIsDefault(2, param.getAppCode());
        for (UserRoleEntity userRoleEntity : userRoleEntities) {
            this.userRoleMapper.delete(userRoleEntity.getId().toString());
            List roleIdList = this.userRoleMapper.findRoleIdsByUserId(userRoleEntity.getUserId());
            if (roleIdList.size() >= 1) continue;
            UserRoleEntity userRoleEntitydb = new UserRoleEntity();
            userRoleEntitydb.setRoleId(roleEntity.getId());
            userRoleEntitydb.setUserId(userRoleEntity.getUserId());
            this.userRoleMapper.insert(userRoleEntitydb);
        }
        RoleEntity sourceRole = this.roleMapper.findByRoleId(param.getRoleId());
        if (sourceRole == null) {
            return BaseResponse.error((IError)IError.DATA_NOT_EXIST);
        }
        this.roleMapper.delete(sourceRole.getId());
        String[] roleIdArray = new String[]{param.getRoleId()};
        this.authUrlToRedisService.redisDelete(param.getAppCode(), roleIdArray);
        return BaseResponse.success();
    }

    public BaseResponse<PageResult<RoleInfoVO>> fetchList(PageRequest<FetchListParamVO> param) {
        return null;
    }

    public BaseResponse<List<RoleInfoVO>> findAll(String appCode) {
        List roleEntityList = this.roleMapper.findAll(appCode);
        ArrayList<RoleInfoVO> roleInfoVOList = new ArrayList<RoleInfoVO>();
        for (RoleEntity roleEntity : roleEntityList) {
            RoleInfoVO roleInfoVO = new RoleInfoVO();
            BeanUtils.copyProperties((Object)roleEntity, (Object)roleInfoVO);
            roleInfoVOList.add(roleInfoVO);
        }
        log.info("\u67e5\u8be2\u5230\u7684\u89d2\u8272\u96c6\u5408\u6570\u636e:{}", roleInfoVOList);
        return BaseResponse.success(roleInfoVOList);
    }

    public BaseResponse<List<RoleInfoVO>> findByUserId(String userId) {
        List stringList = this.userRoleMapper.findRoleIdsByUserId(userId);
        log.info("\u67e5\u8be2\u5230\u7528\u6237\u7684\u89d2\u8272id\u96c6\u5408,\u7528\u6237id\u4e3a:{},\u89d2\u8272id\u96c6\u5408\u4e3a:{}", (Object)userId, (Object)stringList);
        ArrayList<RoleInfoVO> roleInfoVOList = new ArrayList<RoleInfoVO>();
        if (stringList == null || stringList.size() < 1) {
            return BaseResponse.success(roleInfoVOList);
        }
        String roleIds = String.join((CharSequence)",", stringList);
        List roleEntityList = this.roleMapper.findAllByRoleIds(roleIds);
        for (RoleEntity roleEntity : roleEntityList) {
            RoleInfoVO roleInfoVO = new RoleInfoVO();
            BeanUtils.copyProperties((Object)roleEntity, (Object)roleInfoVO);
            roleInfoVOList.add(roleInfoVO);
        }
        return BaseResponse.success(roleInfoVOList);
    }

    public BaseResponse<List<RoleInfoVO>> findLikeRoleName(String roleName, String appCode) {
        List roleEntityList = this.roleMapper.findLikeRoleName(roleName, appCode);
        ArrayList<RoleInfoVO> roleInfoVOList = new ArrayList<RoleInfoVO>();
        for (RoleEntity roleEntity : roleEntityList) {
            RoleInfoVO roleInfoVO = new RoleInfoVO();
            BeanUtils.copyProperties((Object)roleEntity, (Object)roleInfoVO);
            roleInfoVOList.add(roleInfoVO);
        }
        return BaseResponse.success(roleInfoVOList);
    }

    public RoleEntity getRoleByName(String name) {
        return this.roleMapper.getRoleByName(name);
    }

    private void setAuthForRole(List<String> authIds, RoleEntity roleEntity) throws BusinessException {
        List authEntities = this.authMapper.findAllByAuthIdIn(authIds);
        if (authEntities.size() != authIds.size()) {
            log.error("\u6743\u9650\u6570\u636e\u5f02\u5e38 -> auth_ids:{},auth_entities:{}", authIds, (Object)authEntities);
            throw new BusinessException((IError)IError.DATA_ERROR);
        }
        roleEntity.setAuthEntities(authEntities);
    }

    private List<RoleAuthEntity> convertAuthEntityListToRoleAuthEntityList(List<AuthEntity> authEntityList, Long roleId) {
        return authEntityList.stream().map(authEntity -> {
            RoleAuthEntity roleAuthEntity = new RoleAuthEntity();
            roleAuthEntity.setAuthId(authEntity.getId());
            roleAuthEntity.setRoleId(roleId);
            return roleAuthEntity;
        }).collect(Collectors.toList());
    }

    public BaseResponse<List<RoleInfoVO>> findAll() {
        List roleEntityList = this.roleMapper.findAllRole();
        ArrayList<RoleInfoVO> roleInfoVOList = new ArrayList<RoleInfoVO>();
        for (RoleEntity roleEntity : roleEntityList) {
            RoleInfoVO roleInfoVO = new RoleInfoVO();
            BeanUtils.copyProperties((Object)roleEntity, (Object)roleInfoVO);
            roleInfoVOList.add(roleInfoVO);
        }
        log.info("\u67e5\u8be2\u5230\u7684\u89d2\u8272\u96c6\u5408\u6570\u636e:{}", roleInfoVOList);
        return BaseResponse.success(roleInfoVOList);
    }
}

