/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.ebaiyihui.common.UserOrganInfoVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.server.mapper.UserOrganMapper;
import com.ebaiyihui.server.pojo.entity.UserOrganEntity;
import com.ebaiyihui.server.service.DataScopeService;
import com.ebaiyihui.server.service.UserOrganService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserOrganServiceImpl
implements UserOrganService {
    private static final Logger log = LoggerFactory.getLogger(UserOrganServiceImpl.class);
    @Autowired
    private UserOrganMapper userOrganMapper;
    @Autowired
    private DataScopeService dataScopeService;

    public BaseResponse<Object> save(List<UserOrganInfoVO> userOrganInfoVOList) {
        if (userOrganInfoVOList == null || userOrganInfoVOList.size() < 1) {
            log.error("\u4f20\u5165\u7684\u53c2\u6570\u4e3a:{}", userOrganInfoVOList);
            return BaseResponse.error((String)"\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!!!");
        }
        String userId = userOrganInfoVOList.get(0).getUserId();
        this.userOrganMapper.deleteByUserId(userId);
        for (UserOrganInfoVO userOrganInfoVO : userOrganInfoVOList) {
            UserOrganEntity userOrganEntity = new UserOrganEntity();
            userOrganEntity.setOrganId(userOrganInfoVO.getOrganId());
            userOrganEntity.setOrganName(userOrganInfoVO.getOrganName());
            userOrganEntity.setUserId(userOrganInfoVO.getUserId());
            this.userOrganMapper.insert(userOrganEntity);
        }
        return BaseResponse.success();
    }

    public BaseResponse<Object> deleteByUserIdAndOrganIds(List<String> organIds, String userId) {
        log.info("\u8981\u5220\u9664\u7684\u7528\u6237\u7ed1\u5b9a\u7684\u533b\u9662\u7684\u7528\u6237id\u4e3a:{},\u533b\u9662id\u4e3a:{}", (Object)userId, organIds);
        for (String organId : organIds) {
            this.userOrganMapper.deleteByOrganIdAndUserId(organId, userId);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(userId);
        this.dataScopeService.updateUserScopeOrganByUserIdList(list);
        return BaseResponse.success();
    }

    public BaseResponse<List<UserOrganInfoVO>> selectByUserId(String userId) {
        List userOrganEntityList = this.userOrganMapper.findByUserId(userId);
        ArrayList<UserOrganInfoVO> userOrganInfoVOList = new ArrayList<UserOrganInfoVO>();
        for (UserOrganEntity userOrganEntity : userOrganEntityList) {
            UserOrganInfoVO userOrganInfoVO = new UserOrganInfoVO();
            userOrganInfoVO.setOrganId(userOrganEntity.getOrganId());
            userOrganInfoVO.setOrganName(userOrganEntity.getOrganName());
            userOrganInfoVO.setUserId(userOrganEntity.getUserId());
            userOrganInfoVOList.add(userOrganInfoVO);
        }
        log.info("\u67e5\u8be2\u5230\u7528\u6237\u7ed1\u5b9a\u7684\u533b\u9662\u4e3a:{}", (Object)userOrganEntityList);
        return BaseResponse.success(userOrganInfoVOList);
    }
}

