/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.ebaiyihui.common.pojo.query.UcAccountQuery;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.server.mapper.RoleMapper;
import com.ebaiyihui.server.mapper.UserRoleMapper;
import com.ebaiyihui.server.pojo.entity.RoleEntity;
import com.ebaiyihui.server.pojo.entity.UserRoleEntity;
import com.ebaiyihui.server.service.DataScopeService;
import com.ebaiyihui.server.service.UserRoleService;
import com.ebaiyihui.server.utils.StringUtil;
import com.ebaiyihui.usercenter.client.ManagerAuthClient;
import com.ebaiyihui.usercenter.client.UserClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserRoleServiceImpl
implements UserRoleService {
    private static final Logger log = LoggerFactory.getLogger(UserRoleServiceImpl.class);
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private ManagerAuthClient managerAuthClient;
    @Autowired
    private UserClient userClient;
    @Autowired
    private DataScopeService dataScopeService;

    public BaseResponse<Object> updateByUserIds(List<String> userIds, String roleId) {
        RoleEntity roleEntitydb = this.roleMapper.findByRoleId(roleId);
        RoleEntity roleEntity = this.roleMapper.findByIsDefault(2, roleEntitydb.getAppCode());
        log.info("\u9700\u8981\u4fee\u6539\u89d2\u8272\u7684\u7528\u6237\u7684ID\u4e3a:{}", userIds);
        for (String userId : userIds) {
            UserRoleEntity userRoleEntity = this.userRoleMapper.findByUserIdAndRoleId(userId, roleId);
            UserRoleEntity userRoleEntityDb = this.userRoleMapper.findByUserIdAndRoleId(userId, roleEntity.getId().toString());
            if (userRoleEntity != null) {
                this.userRoleMapper.delete(userRoleEntity.getId().toString());
            }
            if (userRoleEntityDb != null) continue;
            UserRoleEntity userRoleEntityHb = new UserRoleEntity();
            userRoleEntityHb.setRoleId(roleEntity.getId());
            userRoleEntityHb.setUserId(userId);
            this.userRoleMapper.insert(userRoleEntityHb);
        }
        this.dataScopeService.updateUserScopeOrganByUserIdList(userIds);
        return BaseResponse.success();
    }

    public BaseResponse<Object> saveByUserIds(List<String> userIds, String roleId) {
        log.info("\u9700\u8981\u7ed1\u5b9a\u89d2\u8272\u7684\u7528\u6237\u7684ID\u4e3a:{}", userIds);
        for (String userId : userIds) {
            UserRoleEntity userRoleEntity = new UserRoleEntity();
            userRoleEntity.setRoleId(Long.valueOf(StringUtil.toLongValue((Object)roleId)));
            userRoleEntity.setUserId(userId);
            this.userRoleMapper.insert(userRoleEntity);
        }
        this.dataScopeService.updateUserScopeOrganByUserIdList(userIds);
        return BaseResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> save(List<String> roleIds, String userId) {
        log.info("\u4f20\u5165\u7684\u53c2\u6570\u4e3a:{}", roleIds);
        RoleEntity roleEntitydb = this.roleMapper.findByRoleId(roleIds.get(0));
        if (roleIds == null || roleIds.size() < 1) {
            RoleEntity roleEntity = this.roleMapper.findByIsDefault(2, roleEntitydb.getAppCode());
            roleIds.add(roleEntity.getId().toString());
        }
        this.userRoleMapper.deleteByUserId(userId);
        for (String roleId : roleIds) {
            UserRoleEntity userRoleEntity = new UserRoleEntity();
            userRoleEntity.setRoleId(Long.valueOf(StringUtil.toLongValue((Object)roleId)));
            userRoleEntity.setUserId(userId);
            this.userRoleMapper.insert(userRoleEntity);
        }
        try {
            this.dataScopeService.addUserScopeOrgan(userId);
        }
        catch (Exception e) {
            log.info(e.getMessage());
            return BaseResponse.error((String)"\u7ed1\u5b9a\u6570\u636e\u8303\u56f4\u6743\u9650\u5931\u8d25");
        }
        return BaseResponse.success();
    }

    public BaseResponse<Object> findByRoleId(Long roleId, Integer pageNum, Integer pageSize) {
        log.info("\u9700\u8981\u67e5\u8be2\u6210\u5458ID\u96c6\u5408\u7684\u89d2\u8272ID\u4e3a:{}", (Object)roleId);
        List stringList = this.userRoleMapper.findUserIdsByRoleId(roleId);
        log.info("\u67e5\u8be2\u5230\u7684\u6210\u5458\u7684id\u96c6\u5408\u4e3a:{}", (Object)stringList);
        if (stringList.size() < 1) {
            PageResult pageResult = new PageResult();
            pageResult.setPageNum(pageNum.intValue());
            pageResult.setPageSize(pageSize.intValue());
            return BaseResponse.success((Object)BaseResponse.success((Object)pageResult));
        }
        UcAccountQuery ucAccountQuery = new UcAccountQuery();
        if (pageNum != 0 && pageSize != 0) {
            ucAccountQuery.setPageNum(pageNum);
            ucAccountQuery.setPageSize(pageSize);
        }
        ucAccountQuery.setUserIds(stringList);
        BaseResponse resultBaseResponse = this.managerAuthClient.getMemberList(ucAccountQuery);
        log.info("\u8c03\u7528\u7528\u6237\u670d\u52a1\u67e5\u8be2\u5230\u7684\u7ed3\u679c\u4e3a:{}", (Object)resultBaseResponse);
        return BaseResponse.success((Object)resultBaseResponse);
    }

    public BaseResponse<List<String>> findAllAdminUserId(String appCode) {
        List userIdList = this.userRoleMapper.findAllAdminUserId(appCode);
        return BaseResponse.success((Object)userIdList);
    }

    public List<UserRoleEntity> getListByRole(Long roleId) {
        return this.userRoleMapper.getListByRole(roleId);
    }
}

