/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.physical.dto.CombinationDTO;
import com.ebaiyihui.physical.dto.CombinationDetailsDTO;
import com.ebaiyihui.physical.entity.CombinationEntity;
import com.ebaiyihui.physical.entity.CombinationProjectEntity;
import com.ebaiyihui.physical.entity.DictionaryEntity;
import com.ebaiyihui.physical.entity.ProjectItemEntity;
import com.ebaiyihui.physical.mapper.CombinationMapper;
import com.ebaiyihui.physical.mapper.CombinationProjectMapper;
import com.ebaiyihui.physical.mapper.CombinationTypeMapper;
import com.ebaiyihui.physical.mapper.DictionaryMapper;
import com.ebaiyihui.physical.mapper.ProjectItemMapper;
import com.ebaiyihui.physical.service.CombinationService;
import com.ebaiyihui.physical.service.CombinationTypeService;
import com.ebaiyihui.physical.service.ProjectItemService;
import com.ebaiyihui.physical.service.TagService;
import com.ebaiyihui.physical.vo.ChangeSort;
import com.ebaiyihui.physical.vo.CombinationOnlineVO;
import com.ebaiyihui.physical.vo.CombinationProjectVO;
import com.ebaiyihui.physical.vo.CombinationVO;
import com.ebaiyihui.physical.vo.SortList;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CombinationServiceImpl
extends ServiceImpl<CombinationMapper, CombinationEntity>
implements CombinationService {
    private static final Logger log = LoggerFactory.getLogger(CombinationServiceImpl.class);
    @Autowired
    CombinationTypeService combinationTypeService;
    @Autowired
    CombinationMapper combinationMapper;
    @Autowired
    CombinationProjectMapper combinationProjectMapper;
    @Autowired
    CombinationTypeMapper combinationTypeMapper;
    @Autowired
    ProjectItemMapper projectItemMapper;
    @Autowired
    DictionaryMapper dictionaryMapper;
    @Autowired
    ProjectItemService projectItemService;
    @Autowired
    TagService tagService;

    public CombinationDTO getCombinationList(CombinationVO vo) {
        log.info("\u67e5\u8be2\u5957\u9910\u5206\u7c7b,\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)vo));
        CombinationDTO result = new CombinationDTO();
        List combinationList = ((CombinationMapper)this.baseMapper).selectCombination(vo);
        combinationList.stream().forEach(item -> {
            if (Objects.isNull(item.getSalePrice())) {
                item.setSalePrice(item.getTotalPrice());
            }
        });
        List ids = combinationList.stream().map(item -> item.getId()).collect(Collectors.toList());
        log.info(JSON.toJSONString(ids));
        List projectCountList = new ArrayList();
        if (Objects.nonNull(ids) && ids.size() > 0) {
            projectCountList = ((CombinationMapper)this.baseMapper).getProjectCount(ids);
        }
        if (Objects.nonNull(combinationList) && combinationList.size() > 0 && projectCountList.size() > 0) {
            for (CombinationEntity combination : combinationList) {
                for (CombinationEntity project : projectCountList) {
                    if (!Objects.equals(combination.getId(), project.getId())) continue;
                    combination.setProjectCount(project.getProjectCount());
                }
            }
        }
        combinationList = combinationList.stream().map(item -> {
            if (Objects.isNull(item.getProjectCount())) {
                item.setProjectCount(Integer.valueOf(0));
            }
            List tagListRes = this.tagService.getTagListByCombinationId(item.getId());
            item.setTagList(tagListRes);
            return item;
        }).collect(Collectors.toList());
        combinationList.sort(Comparator.comparing(CombinationEntity::getSort));
        int count = this.count((Wrapper)new QueryWrapper().eq((Object)"combination_type_id", (Object)vo.getCombinationTypeId()));
        List dic = this.dictionaryMapper.getDicByCode("address");
        result.setAddress(((DictionaryEntity)dic.get(0)).getDicName());
        result.setCombinationCount(Integer.valueOf(count));
        result.setCombinationEntities(combinationList);
        log.info("\u67e5\u8be2\u5957\u9910\u5206\u7c7b,\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)result));
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BaseResponse<CombinationEntity> saveOrUpdateCombination(CombinationEntity combinationEntity) {
        log.info("\u5b58\u50a8\u5957\u9910,\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)combinationEntity));
        try {
            if (Objects.isNull(combinationEntity.getId())) {
                CombinationEntity combination = (CombinationEntity)this.getOne((Wrapper)new QueryWrapper().eq((Object)"combination_name", (Object)combinationEntity.getCombinationName()));
                if (!Objects.isNull(combination)) return BaseResponse.error((String)"\u5957\u9910\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa");
                ((CombinationMapper)this.baseMapper).insert((Object)combinationEntity);
                this.tagService.saveTagRel(combinationEntity.getTagIds(), combinationEntity.getId());
                return BaseResponse.success((Object)combinationEntity);
            } else {
                List combinationListByProjectName = this.combinationMapper.getCombinationListByProjectName(combinationEntity.getCombinationName());
                combinationListByProjectName.removeIf(o -> o.getId() == combinationEntity.getId());
                if (combinationListByProjectName.size() > 0) {
                    return BaseResponse.error((String)"\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
                }
                this.updateById((Object)combinationEntity);
                this.tagService.saveTagRel(combinationEntity.getTagIds(), combinationEntity.getId());
            }
            return BaseResponse.success((Object)combinationEntity);
        }
        catch (Exception e) {
            log.info("\u63d0\u4ea4\u8ba2\u5355\u5f02\u5e38{}", (Throwable)e);
            return BaseResponse.error((String)"\u5b58\u50a8\u5957\u9910\u5f02\u5e38");
        }
    }

    public void onlineStatusCombination(CombinationOnlineVO vo) {
        log.info("\u4fee\u6539\u4e0a\u67b6\u72b6\u6001,\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)vo));
        List ids = vo.getCombinationList().stream().map(item -> item.getId()).collect(Collectors.toList());
        List combinationEntities = this.list((Wrapper)new QueryWrapper().in((Object)"id", ids));
        for (CombinationEntity combinationEntity : combinationEntities) {
            combinationEntity.setOnlineStatus(vo.getOnlineStatus());
        }
        this.updateBatchById((Collection)combinationEntities);
    }

    public void addProjectToCombination(CombinationProjectVO vo) {
        log.info("\u5957\u9910\u4e2d\u589e\u52a0\u9879\u76ee,\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)vo));
        List combinationProjectEntities = vo.getProjectItemList().stream().map(item -> {
            CombinationProjectEntity combinationProject = new CombinationProjectEntity();
            combinationProject.setCombinationId(vo.getCombinationId());
            combinationProject.setProjectId(item.getId());
            return combinationProject;
        }).collect(Collectors.toList());
        this.combinationProjectMapper.delBatchProjectByCombinationId(vo.getCombinationId());
        if (Objects.nonNull(combinationProjectEntities) && combinationProjectEntities.size() > 0) {
            combinationProjectEntities.stream().forEach(item -> this.combinationProjectMapper.insert(item));
        }
    }

    public CombinationDetailsDTO getCombinationDetails(CombinationEntity combination) {
        log.info("\u5957\u9910\u8be6\u7ec6\u4fe1\u606f,\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)combination));
        CombinationDetailsDTO detailsDTO = new CombinationDetailsDTO();
        BigDecimal totalPrice = new BigDecimal("0");
        List projectIds = this.combinationProjectMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"combination_id", (Object)combination.getId())).stream().map(item -> item.getProjectId()).collect(Collectors.toList());
        List itemEntities = new ArrayList();
        if (Objects.nonNull(projectIds) && projectIds.size() > 0) {
            itemEntities = this.projectItemMapper.selectList((Wrapper)new QueryWrapper().in((Object)"id", projectIds));
        }
        List baseItem = this.projectItemMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"base", (Object)1));
        itemEntities.addAll(baseItem);
        HashMap map = new HashMap();
        itemEntities.stream().forEach(item -> map.put(item.getId(), item));
        for (Map.Entry entry : map.entrySet()) {
            totalPrice = totalPrice.add(((ProjectItemEntity)entry.getValue()).getProjectPrice());
        }
        CombinationEntity combinationEntity = (CombinationEntity)this.getById((Serializable)combination);
        combinationEntity.setProjectCount(Integer.valueOf(map.size()));
        combinationEntity.setTotalPrice(totalPrice);
        if (Objects.isNull(combinationEntity.getSalePrice())) {
            combinationEntity.setSalePrice(totalPrice);
        }
        detailsDTO.setProjectItemList(this.projectItemMapper.getItemByCombinationId(combination.getId()));
        detailsDTO.setCombination(combinationEntity);
        List dic = this.dictionaryMapper.getDicByCode("address");
        detailsDTO.setAddress(((DictionaryEntity)dic.get(0)).getDicName());
        log.info("\u5957\u9910\u8be6\u7ec6\u4fe1\u606f,\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)detailsDTO));
        List tagListRes = this.tagService.getTagListByCombinationId(combination.getId());
        detailsDTO.getCombination().setTagList(tagListRes);
        return detailsDTO;
    }

    public BaseResponse delCombination(Integer id) {
        log.info("\u5220\u9664\u5957\u9910,\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)id));
        List ids = this.combinationProjectMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(CombinationProjectEntity::getCombinationId, (Object)id)).stream().map(item -> item.getId()).collect(Collectors.toList());
        this.removeById((Serializable)id);
        if (!CollectionUtils.isEmpty(ids)) {
            this.combinationProjectMapper.deleteBatchIds(ids);
        }
        this.tagService.delTagRelByCombinationId(id);
        return BaseResponse.success();
    }

    public CombinationDTO getCombinationByProjectId(CombinationVO vo) {
        log.info("\u9879\u76ee\u53cd\u67e5\u5957\u9910,\u5165\u53c2:{}", (Object)vo);
        CombinationDTO combinationDTO = new CombinationDTO();
        ProjectItemEntity projectItemEntity = (ProjectItemEntity)this.projectItemService.getById((Serializable)vo.getProjectId());
        if (Objects.equals(0, projectItemEntity.getBase())) {
            List combinationIds = ((CombinationMapper)this.baseMapper).getCombinationIdsByProjectId(vo.getProjectId());
            if (Objects.nonNull(combinationIds) && combinationIds.size() > 0) {
                vo = new CombinationVO();
                vo.setCombinationIds(combinationIds);
                combinationDTO = this.getCombinationList(vo);
            }
        } else {
            combinationDTO = this.getCombinationList(vo);
        }
        log.info("\u9879\u76ee\u53cd\u67e5\u5957\u9910,\u7ed3\u679c:{}", (Object)combinationDTO.getCombinationEntities());
        return combinationDTO;
    }

    public BaseResponse<String> changeSortCombination(ChangeSort vo) {
        log.info("\u5220\u9664\u5957\u9910,\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)vo));
        List list = vo.getList();
        try {
            for (SortList sortList : list) {
                Integer i = 0;
                if (vo.getType() == 2) {
                    i = ((CombinationMapper)this.baseMapper).updateSortById(sortList.getSort(), sortList.getId());
                } else if (vo.getType() == 1) {
                    i = this.combinationTypeMapper.updateTypeSortById(sortList.getSort(), sortList.getId());
                }
                if (i > 0) continue;
                return BaseResponse.error((String)("\u66f4\u65b0\u5931\u8d25==>" + sortList.getId()));
            }
        }
        catch (Exception e) {
            return BaseResponse.error((String)"\u66f4\u65b0\u5f02\u5e38");
        }
        return BaseResponse.success();
    }
}

