/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.controller;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.push.pojo.umeng.QueryPushUmengRecordReqVO;
import com.ebaiyihui.push.pojo.umeng.UmAddApplicationReqVO;
import com.ebaiyihui.push.pojo.umeng.UmListCastReqVO;
import com.ebaiyihui.push.pojo.umeng.UmPushMsgToAllReqVO;
import com.ebaiyihui.push.pojo.umeng.android.AndroidBroadcastReqVO;
import com.ebaiyihui.push.pojo.umeng.android.AndroidUnicastReqVO;
import com.ebaiyihui.push.pojo.umeng.ios.IOSBroadcastReqVO;
import com.ebaiyihui.push.pojo.umeng.ios.IOSUnicastReqVO;
import com.ebaiyihui.push.umeng.pojo.bo.ValidationResultBO;
import com.ebaiyihui.push.umeng.service.IUmengService;
import com.ebaiyihui.push.utils.ParamsValidationUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/umapi"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"Umeng\u63a8\u9001"})
public class UmengController {
    private static final Logger log = LoggerFactory.getLogger(UmengController.class);
    @Autowired
    private IUmengService iUmengService;

    @ApiOperation(value="\u6dfb\u52a0\u53cb\u76df\u5e94\u7528\u914d\u7f6e", httpMethod="POST", notes="\u6dfb\u52a0\u53cb\u76df\u5e94\u7528\u914d\u7f6e")
    @ApiImplicitParam(name="reqVO", value="\u6dfb\u52a0\u53cb\u76df\u5e94\u7528\u914d\u7f6e", required=true, dataType="UmAddApplicationReqVO")
    @RequestMapping(value={"/addumapp"}, method={RequestMethod.POST})
    public BaseResponse<?> addUmengApp(@RequestBody UmAddApplicationReqVO reqVO) {
        log.info("addUmengApp param =" + JSON.toJSONString((Object)reqVO));
        ValidationResultBO validateResult = ParamsValidationUtils.validateEntity((Object)reqVO);
        if (validateResult.isHasErrors()) {
            return BaseResponse.error((String)validateResult.getErrorMsg().toString());
        }
        return this.iUmengService.addUmengApplication(reqVO);
    }

    @ApiOperation(value="umeng\u3010\u5b89\u5353\u3011\u3010\u6307\u5b9a\u8bbe\u5907\u53f7\u3011\u7aef\u3010\u5355\u64ad\u3011\u63a8\u9001\u63a5\u53e3", httpMethod="POST", notes="umeng\u3010\u5b89\u5353\u3011\u3010\u6307\u5b9a\u8bbe\u5907\u53f7\u3011\u7aef\u3010\u5355\u64ad\u3011\u63a8\u9001\u63a5\u53e3")
    @ApiImplicitParam(name="reqVO", value="umeng\u3010\u5b89\u5353\u3011\u3010\u6307\u5b9a\u8bbe\u5907\u53f7\u3011\u7aef\u3010\u5355\u64ad\u3011\u63a8\u9001\u63a5\u53e3", required=true, dataType="AndroidUnicastReqVO")
    @RequestMapping(value={"/pushandroidunicast"}, method={RequestMethod.POST})
    public BaseResponse<?> pushUmAndroidUnicast(@RequestBody AndroidUnicastReqVO reqVO) {
        log.info("pushUmAndroidUnicast param =" + JSON.toJSONString((Object)reqVO));
        return this.iUmengService.pushUmAndroidUnicast(reqVO);
    }

    @ApiOperation(value="umeng\u3010\u5b89\u5353\u3011\u3010\u65e0\u9700\u8bbe\u5907\u53f7\u3011\u7aef\u3010\u5e7f\u64ad\u3011\u63a8\u9001\u63a5\u53e3", httpMethod="POST", notes="umeng\u3010\u5b89\u5353\u3011\u3010\u65e0\u9700\u8bbe\u5907\u53f7\u3011\u7aef\u3010\u5e7f\u64ad\u3011\u63a8\u9001\u63a5\u53e3")
    @ApiImplicitParam(name="reqVO", value="umeng\u3010\u5b89\u5353\u3011\u3010\u65e0\u9700\u8bbe\u5907\u53f7\u3011\u7aef\u3010\u5e7f\u64ad\u3011\u63a8\u9001\u63a5\u53e3", required=true, dataType="AndroidBroadcastReqVO")
    @RequestMapping(value={"/pushandroidbroadcast"}, method={RequestMethod.POST})
    public BaseResponse<?> pushUmAndroidBroadcast(@RequestBody AndroidBroadcastReqVO reqVO) {
        log.info("pushUmAndroidBroadcast param =" + JSON.toJSONString((Object)reqVO));
        return this.iUmengService.pushUmAndroidBroadcast(reqVO);
    }

    @ApiOperation(value="umeng\u3010IOS\u3011\u3010\u6307\u5b9a\u8bbe\u5907\u53f7\u3011\u7aef\u3010\u5355\u64ad\u3011\u63a8\u9001\u63a5\u53e3", httpMethod="POST", notes="umeng\u3010IOS\u3011\u3010\u6307\u5b9a\u8bbe\u5907\u53f7\u3011\u7aef\u3010\u5355\u64ad\u3011\u63a8\u9001\u63a5\u53e3")
    @ApiImplicitParam(name="reqVO", value="umeng\u3010IOS\u3011\u3010\u6307\u5b9a\u8bbe\u5907\u53f7\u3011\u7aef\u3010\u5355\u64ad\u3011\u63a8\u9001\u63a5\u53e3", required=true, dataType="IOSUnicastReqVO")
    @RequestMapping(value={"/pushiosunicast"}, method={RequestMethod.POST})
    public BaseResponse<?> pushUmIosUnicast(@RequestBody IOSUnicastReqVO reqVO) {
        log.info("pushUmIosUnicast param =" + JSON.toJSONString((Object)reqVO));
        return this.iUmengService.pushUmIosUnicast(reqVO);
    }

    @ApiOperation(value="umeng\u3010IOS\u3011\u3010\u65e0\u9700\u8bbe\u5907\u53f7\u3011\u7aef\u3010\u5e7f\u64ad\u3011\u63a8\u9001\u63a5\u53e3", httpMethod="POST", notes="umeng\u3010IOS\u3011\u3010\u65e0\u9700\u8bbe\u5907\u53f7\u3011\u7aef\u3010\u5e7f\u64ad\u3011\u63a8\u9001\u63a5\u53e3")
    @ApiImplicitParam(name="reqVO", value="umeng\u3010IOS\u3011\u3010\u65e0\u9700\u8bbe\u5907\u53f7\u3011\u7aef\u3010\u5e7f\u64ad\u3011\u63a8\u9001\u63a5\u53e3", required=true, dataType="IOSBroadcastReqVO")
    @RequestMapping(value={"/pushiosbroadcast"}, method={RequestMethod.POST})
    public BaseResponse<?> pushUmIosBroadcast(@RequestBody IOSBroadcastReqVO reqVO) {
        log.info("pushUmIosBroadcast param =" + JSON.toJSONString((Object)reqVO));
        return this.iUmengService.pushUmIosBroadcast(reqVO);
    }

    @ApiOperation(value="umeng\u63a8\u9001\u6d88\u606f\u5230\u6240\u6709\u5ba2\u6237\u7aef", httpMethod="POST", notes="umeng\u63a8\u9001\u6d88\u606f\u5230\u6240\u6709\u5ba2\u6237\u7aef")
    @ApiImplicitParam(name="reqVO", value="umeng\u63a8\u9001\u6d88\u606f\u5230\u6240\u6709\u5ba2\u6237\u7aef", required=true, dataType="UmPushMsgToAllReqVO")
    @RequestMapping(value={"/pushumall"}, method={RequestMethod.POST})
    public BaseResponse<?> pushUmMsg2AllClient(@RequestBody UmPushMsgToAllReqVO reqVO) {
        log.info("pushUmMsg2AllClient param =" + JSON.toJSONString((Object)reqVO));
        return this.iUmengService.pushUmMsg2AllClient(reqVO);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2uemng\u63a8\u9001\u8bb0\u5f55", httpMethod="POST", notes="\u5206\u9875\u67e5\u8be2uemng\u63a8\u9001\u8bb0\u5f55")
    @ApiImplicitParam(name="reqVO", value="\u5206\u9875\u67e5\u8be2uemng\u63a8\u9001\u8bb0\u5f55", required=true, dataType="QueryPushUmengRecordReqVO")
    @RequestMapping(value={"/getumrecord"}, method={RequestMethod.POST})
    public BaseResponse<?> getPushUmengRecord(@RequestBody QueryPushUmengRecordReqVO reqVO) {
        log.info("getPushUmengRecord param =" + JSON.toJSONString((Object)reqVO));
        return this.iUmengService.getPushUmengRecord(reqVO);
    }

    @ApiOperation(value="umeng\u6279\u91cf\u63a8\u9001\u63a5\u53e3", httpMethod="POST", notes="umeng\u6279\u91cf\u63a8\u9001\u63a5\u53e3")
    @ApiImplicitParam(name="reqVO", value="umeng\u6279\u91cf\u63a8\u9001\u63a5\u53e3", required=true, dataType="UmListCastReqVO")
    @RequestMapping(value={"/push_cast_list"})
    public BaseResponse<?> pushUmCastList(@RequestBody UmListCastReqVO reqVO) {
        log.info("pushUmCastList param =" + JSON.toJSONString((Object)reqVO));
        return this.iUmengService.pushUmCastList(reqVO);
    }
}

