/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.controller;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.push.pojo.wechat.GetTokenReqVO;
import com.ebaiyihui.push.pojo.wechat.PushSubscribeMessageReqVO;
import com.ebaiyihui.push.pojo.wechat.PushTemplateMessageReqVO;
import com.ebaiyihui.push.pojo.wechat.PushUserReqVO;
import com.ebaiyihui.push.wechat.service.WechatMessageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wechat_message"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"\u5fae\u4fe1\u63a8\u9001"})
public class WechatMessageController {
    private static final Logger log = LoggerFactory.getLogger(WechatMessageController.class);
    @Autowired
    private WechatMessageService wechatMessageService;

    @ApiOperation(value="\u83b7\u53d6\u5fae\u4fe1AccessToken", httpMethod="POST", notes="\u83b7\u53d6\u5fae\u4fe1AccessToken")
    @ApiImplicitParam(name="reqVO", value="\u83b7\u53d6\u5fae\u4fe1AccessToken", required=true, dataType="GetTokenReqVO")
    @PostMapping(value={"/get_access_token"})
    public BaseResponse<?> getAccessToken(@RequestBody GetTokenReqVO reqVO) {
        log.info("getAccessToken param = {}", (Object)JSONObject.toJSONString((Object)reqVO));
        return this.wechatMessageService.getAccessToken(reqVO);
    }

    @ApiOperation(value="\u5fae\u4fe1\u6d88\u606f\u63a8\u9001\uff0c\u4fdd\u5b58\u7528\u6237\u4fe1\u606f", httpMethod="POST", notes="\u5fae\u4fe1\u6d88\u606f\u63a8\u9001\uff0c\u4fdd\u5b58\u7528\u6237\u4fe1\u606f")
    @ApiImplicitParam(name="reqVO", value="\u5fae\u4fe1\u6d88\u606f\u63a8\u9001\uff0c\u4fdd\u5b58\u7528\u6237\u4fe1\u606f", required=true, dataType="PushUserReqVO")
    @PostMapping(value={"/save_push_user"})
    public BaseResponse<?> savePushUser(@RequestBody PushUserReqVO reqVO) {
        log.info("savePushUser param = {}", (Object)JSONObject.toJSONString((Object)reqVO));
        return this.wechatMessageService.savePushUser(reqVO);
    }

    @ApiOperation(value="\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\u63a8\u9001\u63a5\u53e3", httpMethod="POST", notes="\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\u63a8\u9001\u63a5\u53e3")
    @ApiImplicitParam(name="reqVO", value="\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\u63a8\u9001\u63a5\u53e3", required=true, dataType="PushTemplateMessageReqVO")
    @PostMapping(value={"/push"})
    public BaseResponse<?> push(@RequestBody PushTemplateMessageReqVO reqVO) {
        log.info("savePushUser param = {}", (Object)JSONObject.toJSONString((Object)reqVO));
        return this.wechatMessageService.push(reqVO);
    }

    @ApiOperation(value="\u5fae\u4fe1\u8ba2\u9605\u6d88\u606f\u63a8\u9001\u63a5\u53e3", httpMethod="POST", notes="\u5fae\u4fe1\u8ba2\u9605\u6d88\u606f\u63a8\u9001\u63a5\u53e3")
    @ApiImplicitParam(name="reqVO", value="\u5fae\u4fe1\u8ba2\u9605\u6d88\u606f\u63a8\u9001\u63a5\u53e3", required=true, dataType="PushSubscribeMessageReqVO")
    @PostMapping(value={"/subscribe_push"})
    public BaseResponse<?> pushSubscribeMessage(@RequestBody PushSubscribeMessageReqVO reqVO) {
        log.info("pushSubscribeMessage param = {}", (Object)JSONObject.toJSONString((Object)reqVO));
        return this.wechatMessageService.pushSubscribeMessage(reqVO);
    }

    @PostMapping(value={"/subscribe_template_get"})
    public BaseResponse<?> getSubscribeTemplate(@RequestBody GetTokenReqVO reqVO) {
        log.info("getSubscribeTemplate param = {}", (Object)JSONObject.toJSONString((Object)reqVO));
        return this.wechatMessageService.getSubscribeTemplate(reqVO.getClientCode());
    }

    @GetMapping(value={"/check_health"})
    public BaseResponse<?> checkHealth() {
        return this.wechatMessageService.checkHealth();
    }
}

