/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.goeasy.business;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.push.goeasy.service.impl.IGoeasyServiceImpl;
import com.ebaiyihui.push.pojo.goeasy.GoeasyPushMsgWithUserIdReqVO;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListCastPush {
    private static final Logger log = LoggerFactory.getLogger(ListCastPush.class);
    private static final int threadNum = 10;
    private static ExecutorService service = new ThreadPoolExecutor(10, 10, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private static LinkedBlockingQueue<GoeasyPushMsgWithUserIdReqVO> queue = new LinkedBlockingQueue(2000);

    public ListCastPush() {
        this.launchPush();
    }

    public void addTask(GoeasyPushMsgWithUserIdReqVO reqVO) {
        queue.add(reqVO);
    }

    private void launchPush() {
        for (int i = 0; i < 10; ++i) {
            service.submit(() -> {
                try {
                    log.info("goeasy push thread begin take data!!");
                    GoeasyPushMsgWithUserIdReqVO reqVO = (GoeasyPushMsgWithUserIdReqVO)queue.take();
                    log.info("cast list push GoeasyPushMsgWithUserIdReqVO= " + JSONObject.toJSONString((Object)reqVO));
                    new IGoeasyServiceImpl().sendPush(reqVO);
                }
                catch (Exception e) {
                    log.error("take queue error,e=", (Throwable)e);
                }
            });
        }
    }
}

