/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.image.service.impl;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.push.common.ImageConstants;
import com.ebaiyihui.push.image.service.ImageService;
import com.ebaiyihui.push.pojo.image.GetImageCodeReqVO;
import com.ebaiyihui.push.pojo.image.ImageCodeRspVO;
import com.ebaiyihui.push.pojo.image.VerifiImageCodeReqVO;
import com.ebaiyihui.push.sms.enums.SmsNotificationEnum;
import com.ebaiyihui.push.utils.ImageBase64Utils;
import com.ebaiyihui.push.utils.MessageUtils;
import com.ebaiyihui.push.utils.RandomUtils;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class ImageServiceImpl
implements ImageService {
    private static final Logger log = LoggerFactory.getLogger(ImageServiceImpl.class);
    @Autowired
    private RedisTemplate redisTemplate;

    public BaseResponse<?> getImageCode(GetImageCodeReqVO reqVo) {
        String type = reqVo.getType();
        if (!ImageConstants.IMAGE_TYPE.contains(type)) {
            return BaseResponse.error((String)"\u7c7b\u578b\u672a\u5b9a\u4e49!");
        }
        String imageCodeStr = RandomUtils.getStringRandom((int)4);
        String base64 = "";
        try {
            base64 = ImageBase64Utils.imageToBase64((int)120, (int)40, (String)imageCodeStr);
        }
        catch (Exception e) {
            log.error("\u56fe\u5f62\u9a8c\u8bc1\u7801\u8f6c\u6362\u6210Base64\u5f02\u5e38:{}", (Throwable)e);
        }
        if (StringUtils.isBlank((CharSequence)base64)) {
            return BaseResponse.error((String)MessageUtils.get((String)SmsNotificationEnum.IMAGE_VERIFICATION_FAIL.name()));
        }
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String randomStr = RandomUtils.getRandom8Length();
        String id = "".concat(timeStamp).concat(randomStr);
        String key = "ehos_imagecode_".concat(type).concat("_").concat(id);
        this.redisTemplate.opsForValue().set((Object)key, (Object)imageCodeStr, 600000L, TimeUnit.MILLISECONDS);
        ImageCodeRspVO rsp = new ImageCodeRspVO(id, base64, type);
        log.info("\u8be5\u6e20\u9053\uff1a{}\u83b7\u53d6\u56fe\u7247\u9a8c\u8bc1\u7801\u4e3a:{}", (Object)type, (Object)imageCodeStr);
        return BaseResponse.success((Object)rsp);
    }

    public BaseResponse<?> verifyImageCode(VerifiImageCodeReqVO reqVO) {
        String key = "ehos_imagecode_".concat(reqVO.getType()).concat("_").concat(reqVO.getImageId());
        Object imageCode = this.redisTemplate.opsForValue().get((Object)key);
        if (imageCode == null) {
            return BaseResponse.error((String)MessageUtils.get((String)SmsNotificationEnum.IMAGE_VERIFICATION_CODE_HAS_EXPIRED.name()));
        }
        if (!String.valueOf(imageCode).equalsIgnoreCase(reqVO.getImageCode())) {
            return BaseResponse.error((String)MessageUtils.get((String)SmsNotificationEnum.IMAGE_NOT_MATCH.name()));
        }
        return BaseResponse.success();
    }
}

