/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.umeng.business;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.push.pojo.umeng.UmListCastReqVO;
import com.ebaiyihui.push.umeng.business.AndroidCastList;
import com.ebaiyihui.push.umeng.business.IosCastList;
import com.ebaiyihui.push.umeng.dao.UmSendHistoryMapper;
import com.ebaiyihui.push.umeng.enums.SystemEnum;
import com.ebaiyihui.push.umeng.pojo.bo.PushClient;
import com.ebaiyihui.push.umeng.pojo.bo.UmengNotification;
import com.ebaiyihui.push.umeng.pojo.entity.UmApplicationEntity;
import com.ebaiyihui.push.umeng.pojo.entity.UmSendHistoryEntityWithBLOBs;
import com.ebaiyihui.push.utils.ListUtils;
import com.ebaiyihui.push.utils.SpringContextHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public abstract class APushUmCastList {
    private static final Logger log = LoggerFactory.getLogger(APushUmCastList.class);
    private static final int threadNum = 10;
    private static LinkedBlockingQueue<UmengNotification> queue = new LinkedBlockingQueue(2000);
    private static ExecutorService service = new ThreadPoolExecutor(10, 10, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private static PushClient pushClient = new PushClient();

    public APushUmCastList() {
        this.launchPush();
    }

    public static void push(UmListCastReqVO reqVO, Map<String, UmApplicationEntity> umApplicationEntityMap) {
        for (Map.Entry<String, UmApplicationEntity> entry : umApplicationEntityMap.entrySet()) {
            AndroidCastList aPushUmCastList;
            Map deviceMap;
            if (entry.getKey().equals(SystemEnum.Android.toString())) {
                deviceMap = reqVO.getAndroidDeviceNum();
                aPushUmCastList = new AndroidCastList();
            } else {
                deviceMap = reqVO.getIosDeviceNum();
                aPushUmCastList = new IosCastList();
            }
            APushUmCastList.build((APushUmCastList)aPushUmCastList, (UmListCastReqVO)reqVO, (UmApplicationEntity)entry.getValue(), (Map)deviceMap);
        }
    }

    private static void build(APushUmCastList aPushUmCastList, UmListCastReqVO reqVO, UmApplicationEntity umApplicationEntity, Map<String, String> deviceMap) {
        try {
            APushUmCastList.buildPushParam((APushUmCastList)aPushUmCastList, (UmListCastReqVO)reqVO, (UmApplicationEntity)umApplicationEntity, deviceMap);
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u53cb\u76df\u5b89\u5353\u63a8\u9001\u6570\u636e\u5931\u8d25,e=", (Throwable)e);
        }
    }

    private static void buildPushParam(APushUmCastList aPushUmCastList, UmListCastReqVO reqVO, UmApplicationEntity umApplicationEntity, Map<String, String> deviceMap) {
        ListUtils listUtils = new ListUtils();
        listUtils.convertMapToList(deviceMap);
        List valueList = listUtils.getValueList();
        List keyList = listUtils.getKeyList();
        if (listUtils.getValueList().size() >= 500) {
            List resultUserIdList = ListUtils.createList((List)keyList, (int)500);
            List resultDeviceIdList = ListUtils.createList((List)valueList, (int)500);
            for (int i = 0; i < resultUserIdList.size(); ++i) {
                APushUmCastList.buildDeviceId((APushUmCastList)aPushUmCastList, (UmListCastReqVO)reqVO, (UmApplicationEntity)umApplicationEntity, (List)((List)resultUserIdList.get(i)), (List)((List)resultDeviceIdList.get(i)));
            }
        } else {
            APushUmCastList.buildDeviceId((APushUmCastList)aPushUmCastList, (UmListCastReqVO)reqVO, (UmApplicationEntity)umApplicationEntity, (List)keyList, (List)valueList);
        }
    }

    private static void buildDeviceId(APushUmCastList aPushUmCastList, UmListCastReqVO reqVO, UmApplicationEntity umApplicationEntity, List<String> userIdList, List<String> deviceIdList) {
        ArrayList recordList = new ArrayList();
        UmengNotification msg = aPushUmCastList.initParam(reqVO, umApplicationEntity, deviceIdList, userIdList, recordList);
        queue.add(msg);
    }

    abstract UmengNotification initParam(UmListCastReqVO var1, UmApplicationEntity var2, List<String> var3, List<String> var4, List<UmSendHistoryEntityWithBLOBs> var5);

    private void launchPush() {
        for (int i = 0; i < 10; ++i) {
            service.submit(() -> {
                try {
                    log.info("thread begin take data!!");
                    UmengNotification umengNotification = (UmengNotification)queue.take();
                    log.info("cast list push UmengNotification= " + JSONObject.toJSONString((Object)umengNotification));
                    String result = pushClient.send(umengNotification);
                    log.info("\u53cb\u76df\u6279\u91cf\u63a8\u9001result=" + result);
                    UmSendHistoryMapper umSendHistoryMapper = (UmSendHistoryMapper)SpringContextHolder.getBean(UmSendHistoryMapper.class);
                    umSendHistoryMapper.insertAll(umengNotification.getUmSendHistoryEntityWithBLOBs());
                    log.info("save umeng record finished!!!");
                }
                catch (Exception e) {
                    log.error("take queue error,e=", (Throwable)e);
                }
            });
        }
    }
}

