/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.umeng.business;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.push.pojo.umeng.UmListCastReqVO;
import com.ebaiyihui.push.umeng.business.APushUmCastList;
import com.ebaiyihui.push.umeng.pojo.bo.AndroidNotification;
import com.ebaiyihui.push.umeng.pojo.bo.UmengNotification;
import com.ebaiyihui.push.umeng.pojo.bo.android.AndroidUnicast;
import com.ebaiyihui.push.umeng.pojo.entity.UmApplicationEntity;
import com.ebaiyihui.push.umeng.pojo.entity.UmSendHistoryEntityWithBLOBs;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidCastList
extends APushUmCastList {
    private static final Logger log = LoggerFactory.getLogger(AndroidCastList.class);

    UmengNotification initParam(UmListCastReqVO reqVO, UmApplicationEntity umApplicationEntity, List<String> deviceIdList, List<String> userIdList, List<UmSendHistoryEntityWithBLOBs> recordList) {
        AndroidUnicast msg = null;
        try {
            msg = new AndroidUnicast(umApplicationEntity.getAppSdkId(), umApplicationEntity.getAppMasterSecret());
            String timestamp = Integer.toString((int)(System.currentTimeMillis() / 1000L));
            msg.setTicker(reqVO.getTicker());
            String deviceId = StringUtils.join(deviceIdList, (String)",");
            msg.setDeviceToken(deviceId);
            msg.setTitle(reqVO.getTitle());
            msg.setText(reqVO.getText());
            msg.setPredefinedKeyValue("type", (Object)"listcast");
            msg.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);
            msg.setTestMode();
            msg.setPredefinedKeyValue("timestamp", (Object)timestamp);
            Map extraMap = reqVO.getExtra();
            for (int i = 0; i < userIdList.size(); ++i) {
                UmSendHistoryEntityWithBLOBs record = new UmSendHistoryEntityWithBLOBs();
                if (extraMap != null && !extraMap.isEmpty()) {
                    Set keyset = extraMap.keySet();
                    for (String key : keyset) {
                        msg.setExtraField(key, (String)extraMap.get(key));
                    }
                    record.setExtraStr(JSON.toJSONString((Object)extraMap));
                }
                msg.setDescription("\u5217\u64ad\u901a\u77e5");
                record.setUmMsgType("unicast");
                record.setBusiCode(reqVO.getBusiCode());
                record.setBusiStyle(reqVO.getText());
                record.setTitle(reqVO.getTitle());
                record.setUmDeviceToken(deviceIdList.get(i));
                record.setTempFkId(umApplicationEntity.getId().toString());
                String umOrigMsg = JSON.toJSONString((Object)reqVO);
                record.setUmOrigMsg(umOrigMsg);
                record.setUmTargetClient("Android");
                record.setProStep("send_end");
                record.setUserId(userIdList.get(i));
                recordList.add(record);
            }
            msg.setUmSendHistoryEntityWithBLOBs(recordList);
        }
        catch (Exception e) {
            log.error("init android push param error,e=", (Throwable)e);
        }
        return msg;
    }
}

