/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.umeng.business;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.push.pojo.umeng.UmListCastReqVO;
import com.ebaiyihui.push.umeng.business.APushUmCastList;
import com.ebaiyihui.push.umeng.business.IosCastList;
import com.ebaiyihui.push.umeng.pojo.bo.UmengNotification;
import com.ebaiyihui.push.umeng.pojo.bo.ios.IOSUnicast;
import com.ebaiyihui.push.umeng.pojo.entity.UmApplicationEntity;
import com.ebaiyihui.push.umeng.pojo.entity.UmSendHistoryEntityWithBLOBs;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IosCastList
extends APushUmCastList {
    private static final Logger log = LoggerFactory.getLogger(IosCastList.class);

    UmengNotification initParam(UmListCastReqVO reqVO, UmApplicationEntity umApplicationEntity, List<String> deviceIdList, List<String> userIdList, List<UmSendHistoryEntityWithBLOBs> recordList) {
        IOSUnicast msg = null;
        try {
            msg = new IOSUnicast(umApplicationEntity.getAppSdkId(), umApplicationEntity.getAppMasterSecret());
            int environment = umApplicationEntity.getEnvironment();
            if (2 == environment) {
                msg.setTestMode();
            } else {
                msg.setProductionMode();
            }
            msg.setPredefinedKeyValue("type", (Object)"listcast");
            String deviceId = StringUtils.join(deviceIdList, (String)",");
            msg.setDeviceToken(deviceId);
            msg.setBadge(Integer.valueOf(0));
            msg.setSound("default");
            msg.setPredefinedKeyValue("alert", (Object)this.createIOSAlert("", reqVO.getTitle(), reqVO.getText()));
            for (int i = 0; i < userIdList.size(); ++i) {
                UmSendHistoryEntityWithBLOBs record = new UmSendHistoryEntityWithBLOBs();
                Map extra = reqVO.getExtra();
                if (extra != null && !extra.isEmpty()) {
                    Set keyset = extra.keySet();
                    for (String key : keyset) {
                        msg.setCustomizedField(key, (String)extra.get(key));
                    }
                    record.setExtraStr(JSON.toJSONString((Object)extra));
                }
                record.setUmMsgType("unicast");
                record.setBusiCode(reqVO.getBusiCode());
                record.setTempFkId(umApplicationEntity.getId().toString());
                record.setBusiStyle(reqVO.getText());
                record.setTitle(reqVO.getTitle());
                record.setUmDeviceToken(deviceIdList.get(i));
                record.setUserId(userIdList.get(i));
                String umOrigMsg = JSON.toJSONString((Object)reqVO);
                record.setUmOrigMsg(umOrigMsg);
                record.setUmTargetClient("iOS");
                record.setProStep("send_end");
                recordList.add(record);
            }
            msg.setUmSendHistoryEntityWithBLOBs(recordList);
        }
        catch (Exception e) {
            log.error("init ios push param error,e=", (Throwable)e);
        }
        return msg;
    }

    private JSONObject createIOSAlert(String title, String subTitle, String body) {
        1 prams = new /* Unavailable Anonymous Inner Class!! */;
        return prams;
    }
}

