/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.umeng.pojo.bo;

import com.ebaiyihui.push.umeng.pojo.bo.UmengNotification;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class PushClient {
    protected final String USER_AGENT = "Mozilla/5.0";
    protected HttpClient client = HttpClientBuilder.create().build();
    protected static final String host = "http://msg.umeng.com";
    protected static final String uploadPath = "/upload";
    protected static final String postPath = "/api/send";

    public String send(UmengNotification msg) throws Exception {
        String timestamp = Integer.toString((int)(System.currentTimeMillis() / 1000L));
        msg.setPredefinedKeyValue("timestamp", (Object)timestamp);
        String url = "http://msg.umeng.com/api/send";
        String postBody = msg.getPostBody();
        String sign = DigestUtils.md5Hex((byte[])("POST" + url + postBody + msg.getAppMasterSecret()).getBytes("utf8"));
        url = url + "?sign=" + sign;
        HttpPost post = new HttpPost(url);
        post.setHeader("User-Agent", "Mozilla/5.0");
        StringEntity se = new StringEntity(postBody, "UTF-8");
        post.setEntity((HttpEntity)se);
        HttpResponse response = this.client.execute((HttpUriRequest)post);
        StringBuilder result = new StringBuilder();
        try {
            int status = response.getStatusLine().getStatusCode();
            System.out.println("Response Code : " + status);
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            String line = "";
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            System.out.println(result.toString());
            if (status == 200) {
                System.out.println("Notification sent successfully.");
            } else {
                System.out.println("Failed to send the notification!");
            }
        }
        catch (Exception e) {
            System.out.println("Failed to send the notification!");
            e.printStackTrace();
        }
        return result.toString();
    }

    public String uploadContents(String appkey, String appMasterSecret, String contents) throws Exception {
        JSONObject uploadJson = new JSONObject();
        uploadJson.put("appkey", (Object)appkey);
        String timestamp = Integer.toString((int)(System.currentTimeMillis() / 1000L));
        uploadJson.put("timestamp", (Object)timestamp);
        uploadJson.put("content", (Object)contents);
        String url = "http://msg.umeng.com/upload";
        String postBody = uploadJson.toString();
        String sign = DigestUtils.md5Hex((byte[])("POST" + url + postBody + appMasterSecret).getBytes("utf8"));
        url = url + "?sign=" + sign;
        HttpPost post = new HttpPost(url);
        post.setHeader("User-Agent", "Mozilla/5.0");
        StringEntity se = new StringEntity(postBody, "UTF-8");
        post.setEntity((HttpEntity)se);
        HttpResponse response = this.client.execute((HttpUriRequest)post);
        System.out.println("Response Code : " + response.getStatusLine().getStatusCode());
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuffer result = new StringBuffer();
        String line = "";
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        System.out.println(result.toString());
        JSONObject respJson = new JSONObject(result.toString());
        String ret = respJson.getString("ret");
        if (!ret.equals("SUCCESS")) {
            throw new Exception("Failed to upload file");
        }
        JSONObject data = respJson.getJSONObject("data");
        String fileId = data.getString("file_id");
        return fileId;
    }
}

