/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.umeng.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.push.pojo.umeng.QueryPushUmengRecordReqVO;
import com.ebaiyihui.push.pojo.umeng.QueryPushUmengRecordRspVO;
import com.ebaiyihui.push.pojo.umeng.UmAddApplicationReqVO;
import com.ebaiyihui.push.pojo.umeng.UmGetMsgRspVO;
import com.ebaiyihui.push.pojo.umeng.UmListCastReqVO;
import com.ebaiyihui.push.pojo.umeng.UmPushMsgToAllReqVO;
import com.ebaiyihui.push.pojo.umeng.UmPushRecordVo;
import com.ebaiyihui.push.pojo.umeng.UmQueryMsgReqVO;
import com.ebaiyihui.push.pojo.umeng.android.AndroidBroadcastReqVO;
import com.ebaiyihui.push.pojo.umeng.android.AndroidUnicastReqVO;
import com.ebaiyihui.push.pojo.umeng.ios.IOSBroadcastReqVO;
import com.ebaiyihui.push.pojo.umeng.ios.IOSUnicastReqVO;
import com.ebaiyihui.push.umeng.business.APushUmCastList;
import com.ebaiyihui.push.umeng.dao.UmApplicationMapper;
import com.ebaiyihui.push.umeng.dao.UmBusiMsgRelationMapper;
import com.ebaiyihui.push.umeng.dao.UmSendHistoryMapper;
import com.ebaiyihui.push.umeng.enums.UmNotificationEnum;
import com.ebaiyihui.push.umeng.pojo.bo.AndroidNotification;
import com.ebaiyihui.push.umeng.pojo.bo.PushClient;
import com.ebaiyihui.push.umeng.pojo.bo.UmengNotification;
import com.ebaiyihui.push.umeng.pojo.bo.UmengPushRspBO;
import com.ebaiyihui.push.umeng.pojo.bo.UmengPushRspDataBO;
import com.ebaiyihui.push.umeng.pojo.bo.android.AndroidBroadcast;
import com.ebaiyihui.push.umeng.pojo.bo.android.AndroidUnicast;
import com.ebaiyihui.push.umeng.pojo.bo.ios.IOSBroadcast;
import com.ebaiyihui.push.umeng.pojo.bo.ios.IOSUnicast;
import com.ebaiyihui.push.umeng.pojo.entity.BaseEntity;
import com.ebaiyihui.push.umeng.pojo.entity.UmApplicationEntity;
import com.ebaiyihui.push.umeng.pojo.entity.UmBusiMsgRelationEntity;
import com.ebaiyihui.push.umeng.pojo.entity.UmSendHistoryEntity;
import com.ebaiyihui.push.umeng.pojo.entity.UmSendHistoryEntityWithBLOBs;
import com.ebaiyihui.push.umeng.service.IUmengService;
import com.ebaiyihui.push.umeng.service.impl.IUmengServiceImpl;
import com.ebaiyihui.push.utils.DateUtils;
import com.ebaiyihui.push.utils.MessageUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class IUmengServiceImpl
implements IUmengService {
    private static final Logger log = LoggerFactory.getLogger(IUmengServiceImpl.class);
    @Autowired
    private PushClient pushClient;
    @Autowired
    private UmApplicationMapper umApplicationMapper;
    @Autowired
    private UmSendHistoryMapper umSendHistoryMapper;
    @Autowired
    private UmBusiMsgRelationMapper umBusiMsgRelationMapper;
    @Resource(name="fixedThreadPool")
    private ExecutorService fixedThread;

    public BaseResponse<?> addUmengApplication(UmAddApplicationReqVO reqVO) {
        String appDeviceType;
        String clientCode = reqVO.getClientCode();
        long exsisted = this.umApplicationMapper.countByClientCodeAndAppDeviceType(clientCode, appDeviceType = reqVO.getAppDeviceType());
        if (exsisted > 0L) {
            return BaseResponse.error((String)(clientCode + "\u4e0e" + appDeviceType + "\u5df2\u5b58\u5728\uff0c\u4fee\u6539\u76f8\u5173\u53c2\u6570\u518d\u63d0\u4ea4!"));
        }
        UmApplicationEntity entity = new UmApplicationEntity();
        entity.setAppDeviceType(appDeviceType);
        entity.setAppMasterSecret(reqVO.getAppMasterSecret());
        entity.setAppMsgSecret(reqVO.getAppMsgSecret());
        entity.setAppSdkId(reqVO.getAppSdkId());
        entity.setClientCode(clientCode);
        entity.setClientName(reqVO.getClientName());
        this.umApplicationMapper.insertSelective(entity);
        return BaseResponse.success();
    }

    public BaseResponse<?> pushUmAndroidUnicast(AndroidUnicastReqVO reqVO) {
        String clientCode = reqVO.getClientCode();
        UmApplicationEntity umApp = this.umApplicationMapper.findByClientCodeAndAppDeviceType(clientCode);
        if (umApp == null) {
            return BaseResponse.error((String)MessageUtils.get((String)UmNotificationEnum.NO_RELATED_CONFIG.name()));
        }
        UmSendHistoryEntityWithBLOBs history = new UmSendHistoryEntityWithBLOBs();
        history.setUmMsgType("unicast");
        history.setBusiCode(reqVO.getBusiCode());
        history.setBusiStyle(reqVO.getText());
        history.setTitle(reqVO.getTitle());
        history.setUmDeviceToken(reqVO.getDeviceTokens());
        history.setTempFkId(umApp.getId().toString());
        String umOrigMsg = JSON.toJSONString((Object)reqVO);
        history.setUmOrigMsg(umOrigMsg);
        history.setUmTargetClient("Android");
        String timestamp = Integer.toString((int)(System.currentTimeMillis() / 1000L));
        try {
            history.setProStep("send_assembling");
            history.setUserId(reqVO.getUserId());
            AndroidUnicast msg = new AndroidUnicast(umApp.getAppSdkId(), umApp.getAppMasterSecret());
            msg.setDeviceToken(reqVO.getDeviceTokens());
            msg.setTicker(reqVO.getTitle());
            msg.setTitle(reqVO.getTitle());
            msg.setText(reqVO.getText());
            msg.setCustomField(reqVO.getCustom());
            msg.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);
            msg.setMinPush(Boolean.TRUE);
            msg.setMiActivity("info/cd120/module_push/uMeng/push/OfflinePushUniteActivity");
            int environment = umApp.getEnvironment();
            if (2 == environment) {
                msg.setTestMode();
            } else {
                msg.setProductionMode();
            }
            msg.setPredefinedKeyValue("timestamp", (Object)timestamp);
            Map extraMap = reqVO.getExtra();
            if (extraMap != null && !extraMap.isEmpty()) {
                Set keyset = extraMap.keySet();
                for (String key : keyset) {
                    msg.setExtraField(key, (String)extraMap.get(key));
                }
                history.setExtraStr(JSON.toJSONString((Object)extraMap));
            }
            history.setProStep("send_ing");
            String result = this.pushClient.send((UmengNotification)msg);
            log.info("\u53cb\u76df\u63a8\u9001 - Android\u63a8\u9001\u54cd\u5e94 - [result: {} ]", (Object)result);
            UmengPushRspBO rspBO = (UmengPushRspBO)JSON.parseObject((String)result, UmengPushRspBO.class);
            history.setProStep("send_end");
            if ("FAIL".equals(rspBO.getRet())) {
                log.warn("\u53cb\u76df\u5355\u64ad\u63a8\u9001 - Android\u5355\u6761\u63a8\u9001\u5931\u8d25 ---- >{}", (Object)result);
                this.umSendHistoryMapper.insertSelective(history);
                return BaseResponse.error((String)MessageUtils.get((String)UmNotificationEnum.UM_RETURN_FAIL.name()));
            }
            UmengPushRspDataBO rspDataBO = rspBO.getData();
            history.setUmMsgId(rspDataBO.getMsgId());
            history.setUmTaskId(rspDataBO.getTaskId());
            log.info("\u63a8\u9001\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)history));
            this.umSendHistoryMapper.insertSelective(history);
        }
        catch (Exception e) {
            log.error("\u53cb\u76df\u5355\u64ad\u63a8\u9001 - Android\u5355\u6761\u63a8\u9001\u5f02\u5e38----> ", (Throwable)e);
            history.setProStep("exception");
            this.umSendHistoryMapper.insertSelective(history);
            return BaseResponse.error((String)MessageUtils.get((String)UmNotificationEnum.UM_RETURN_FAIL.name()));
        }
        return BaseResponse.success();
    }

    public BaseResponse<?> pushUmAndroidBroadcast(AndroidBroadcastReqVO reqVO) {
        String clientCode = reqVO.getClientCode();
        UmApplicationEntity umApp = this.umApplicationMapper.findByClientCodeAndAppDeviceType(clientCode);
        if (umApp == null) {
            return BaseResponse.error((String)MessageUtils.get((String)UmNotificationEnum.NO_RELATED_CONFIG.name()));
        }
        UmSendHistoryEntityWithBLOBs history = new UmSendHistoryEntityWithBLOBs();
        history.setUmMsgType("broadcast");
        history.setBusiCode(reqVO.getBusiCode());
        history.setTitle(reqVO.getTitle());
        history.setBusiStyle(reqVO.getText());
        history.setTempFkId(umApp.getId().toString());
        String umOrigMsg = JSON.toJSONString((Object)reqVO);
        history.setUmOrigMsg(umOrigMsg);
        history.setUmTargetClient("Android");
        String timestamp = Integer.toString((int)(System.currentTimeMillis() / 1000L));
        try {
            AndroidBroadcast msg = new AndroidBroadcast(umApp.getAppSdkId(), umApp.getAppMasterSecret());
            msg.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);
            msg.setTicker(reqVO.getTitle());
            msg.setTitle(reqVO.getTitle());
            msg.setText(reqVO.getText());
            msg.setPredefinedKeyValue("timestamp", (Object)timestamp);
            msg.setDescription("\u5e7f\u64ad\u901a\u77e5");
            history.setProStep("send_ing");
            String result = this.pushClient.send((UmengNotification)msg);
            log.info("\u53cb\u76df\u5e7f\u64ad\u63a8\u9001 - Android\u63a8\u9001\u54cd\u5e94 - [result: {} ]", (Object)result);
            UmengPushRspBO rspBO = (UmengPushRspBO)JSON.parseObject((String)result, UmengPushRspBO.class);
            history.setProStep("send_end");
            if ("FAIL".equals(rspBO.getRet())) {
                log.warn("\u53cb\u76df\u5e7f\u64ad\u63a8\u9001 - Android\u5e7f\u64ad\u63a8\u9001\u5931\u8d25 ---- >{}", (Object)result);
                history.setProStep("send_fail");
                this.umSendHistoryMapper.insertSelective(history);
                return BaseResponse.error((String)MessageUtils.get((String)UmNotificationEnum.UM_BROADCAST_RETURN_FAIL.name()));
            }
            UmengPushRspDataBO rspDataBO = rspBO.getData();
            history.setUmMsgId(rspDataBO.getMsgId());
            history.setUmTaskId(rspDataBO.getTaskId());
            history.setProStep("send_success");
            this.umSendHistoryMapper.insertSelective(history);
        }
        catch (Exception e) {
            log.error("\u53cb\u76df\u5e7f\u64ad\u63a8\u9001 - Android\u5e7f\u64ad\u63a8\u9001\u5f02\u5e38----> ", (Throwable)e);
            history.setProStep("exception");
            this.umSendHistoryMapper.insertSelective(history);
            return BaseResponse.error((String)MessageUtils.get((String)UmNotificationEnum.SYSTEM_ABNORMALITY.name()));
        }
        return BaseResponse.success();
    }

    public BaseResponse<?> pushUmIosUnicast(IOSUnicastReqVO reqVO) {
        String clientCode = reqVO.getClientCode();
        UmApplicationEntity umApp = this.umApplicationMapper.findByClientCodeAndAppDeviceType(clientCode);
        if (umApp == null) {
            return BaseResponse.error((String)MessageUtils.get((String)UmNotificationEnum.NO_RELATED_CONFIG.name()));
        }
        UmSendHistoryEntityWithBLOBs history = new UmSendHistoryEntityWithBLOBs();
        history.setUmMsgType("unicast");
        history.setBusiCode(reqVO.getBusiCode());
        history.setTempFkId(umApp.getId().toString());
        if (reqVO.getBody() == null) {
            history.setBusiStyle(reqVO.getBusiStyle());
        } else {
            history.setBusiStyle(reqVO.getBody());
        }
        history.setTitle(reqVO.getTitle());
        history.setUmDeviceToken(reqVO.getDeviceTokens());
        history.setUserId(reqVO.getUserId());
        String umOrigMsg = JSON.toJSONString((Object)reqVO);
        history.setUmOrigMsg(umOrigMsg);
        history.setUmTargetClient("iOS");
        try {
            history.setProStep("send_assembling");
            IOSUnicast msg = new IOSUnicast(umApp.getAppSdkId(), umApp.getAppMasterSecret());
            int environment = umApp.getEnvironment();
            if (2 == environment) {
                msg.setTestMode();
            } else {
                msg.setProductionMode();
            }
            msg.setDeviceToken(reqVO.getDeviceTokens());
            msg.setBadge(Integer.valueOf(0));
            msg.setSound("default");
            msg.setPredefinedKeyValue("alert", (Object)this.createIOSAlert("", reqVO.getSubTitle(), reqVO.getBody()));
            Map extra = reqVO.getExtra();
            if (extra != null && !extra.isEmpty()) {
                Set keyset = extra.keySet();
                for (String key : keyset) {
                    msg.setCustomizedField(key, (String)extra.get(key));
                }
                history.setExtraStr(JSON.toJSONString((Object)extra));
            }
            history.setProStep("send_ing");
            String result = this.pushClient.send((UmengNotification)msg);
            log.info("\u53cb\u76df\u63a8\u9001 - IOS\u63a8\u9001\u54cd\u5e94 - [result:{}]", (Object)result);
            history.setProStep("send_end");
            UmengPushRspBO rspBO = (UmengPushRspBO)JSON.parseObject((String)result, UmengPushRspBO.class);
            UmengPushRspDataBO rspDataBO = rspBO.getData();
            if ("FAIL".equals(rspBO.getRet())) {
                history.setProStep("send_fail");
                this.umSendHistoryMapper.insertSelective(history);
                return BaseResponse.error((String)rspDataBO.getErrorMsg());
            }
            history.setProStep("send_success");
            history.setUmMsgId(rspDataBO.getMsgId());
            history.setUmTaskId(rspDataBO.getTaskId());
            this.umSendHistoryMapper.insertSelective(history);
        }
        catch (Exception e) {
            history.setProStep("exception");
            this.umSendHistoryMapper.insertSelective(history);
            log.error("\u53cb\u76df\u5355\u64ad\u63a8\u9001 - IOS\u5355\u64ad\u63a8\u9001\u5f02\u5e38----> {}", (Throwable)e);
            return BaseResponse.error((String)MessageUtils.get((String)UmNotificationEnum.PUSH_ABNORMALITY.name()));
        }
        return BaseResponse.success();
    }

    public BaseResponse<?> pushUmIosBroadcast(IOSBroadcastReqVO reqVO) {
        String clientCode = reqVO.getClientCode();
        UmApplicationEntity umApp = this.umApplicationMapper.findByClientCodeAndAppDeviceType(clientCode);
        if (umApp == null) {
            return BaseResponse.error((String)MessageUtils.get((String)UmNotificationEnum.NO_RELATED_CONFIG.name()));
        }
        UmSendHistoryEntityWithBLOBs history = new UmSendHistoryEntityWithBLOBs();
        history.setUmMsgType("broadcast");
        history.setBusiCode(reqVO.getBusiCode());
        history.setTitle(reqVO.getTitle());
        history.setTempFkId(umApp.getId().toString());
        history.setBusiStyle(reqVO.getBody());
        String umOrigMsg = JSON.toJSONString((Object)reqVO);
        history.setUmOrigMsg(umOrigMsg);
        history.setUmTargetClient("iOS");
        try {
            IOSBroadcast msg = new IOSBroadcast(umApp.getAppSdkId(), umApp.getAppMasterSecret());
            history.setProStep("send_assembling");
            int environment = umApp.getEnvironment();
            if (2 == environment) {
                msg.setTestMode();
            } else {
                msg.setProductionMode();
            }
            msg.setBadge(Integer.valueOf(0));
            msg.setSound("default");
            msg.setPredefinedKeyValue("alert", (Object)this.createIOSAlert(reqVO.getTitle(), reqVO.getSubTitle(), reqVO.getBody()));
            Map extra = reqVO.getExtra();
            if (extra != null && !extra.isEmpty()) {
                Set keyset = extra.keySet();
                for (String key : keyset) {
                    msg.setCustomizedField(key, (String)extra.get(key));
                }
                history.setExtraStr(JSON.toJSONString((Object)extra));
            }
            history.setProStep("send_ing");
            String result = this.pushClient.send((UmengNotification)msg);
            log.info("\u53cb\u76df\u5e7f\u64ad\u63a8\u9001 - IOS\u5e7f\u64ad\u63a8\u9001\u54cd\u5e94 - [result:{}]", (Object)result);
            history.setProStep("send_end");
            UmengPushRspBO rspBO = (UmengPushRspBO)JSON.parseObject((String)result, UmengPushRspBO.class);
            UmengPushRspDataBO rspDataBO = rspBO.getData();
            if ("FAIL".equals(rspBO.getRet())) {
                history.setProStep("send_fail");
                this.umSendHistoryMapper.insertSelective(history);
                return BaseResponse.error((String)rspDataBO.getErrorMsg());
            }
            history.setProStep("send_success");
            history.setUmMsgId(rspDataBO.getMsgId());
            history.setUmTaskId(rspDataBO.getTaskId());
            this.umSendHistoryMapper.insertSelective(history);
        }
        catch (Exception e) {
            history.setProStep("exception");
            this.umSendHistoryMapper.insertSelective(history);
            log.error("\u53cb\u76df\u5e7f\u64ad\u63a8\u9001 - IOS\u5e7f\u64ad\u63a8\u9001\u5f02\u5e38----> {}", (Throwable)e);
            return BaseResponse.error((String)MessageUtils.get((String)UmNotificationEnum.PUSH_ABNORMALITY.name()));
        }
        return BaseResponse.success();
    }

    public BaseResponse<?> pushUmMsg2AllClient(UmPushMsgToAllReqVO reqVO) {
        String targetApp = reqVO.getUmAppCode();
        List app = StringUtils.isBlank((CharSequence)targetApp) ? this.umApplicationMapper.findAll() : this.umApplicationMapper.findByClientCode(targetApp);
        if (app == null || app.isEmpty()) {
            return BaseResponse.error((String)MessageUtils.get((String)UmNotificationEnum.NO_APPLICATION_CONFIGURATION.name()));
        }
        Map extraMap = reqVO.getExtra();
        String umOrigMsg = JSON.toJSONString((Object)reqVO);
        ArrayList historyList = new ArrayList();
        app.stream().forEach(um -> {
            UmengPushRspDataBO bo;
            UmengPushRspBO rspBO;
            String umResult;
            Set keySet;
            UmSendHistoryEntityWithBLOBs historyEntity = new UmSendHistoryEntityWithBLOBs();
            historyEntity.setTempFkId(um.getId().toString());
            historyEntity.setUmMsgType("broadcast");
            historyEntity.setBusiCode(reqVO.getBusiCode());
            historyEntity.setBusiStyle(reqVO.getBody());
            historyEntity.setUmOrigMsg(umOrigMsg);
            int environment = um.getEnvironment();
            String appDeviceType = um.getAppDeviceType();
            historyEntity.setUmTargetClient(appDeviceType);
            if ("Android".equals(appDeviceType)) {
                try {
                    historyEntity.setProStep("send_assembling");
                    AndroidBroadcast androidBroadcast = new AndroidBroadcast(um.getAppSdkId(), um.getAppMasterSecret());
                    if (2 == environment) {
                        androidBroadcast.setTestMode();
                    } else {
                        androidBroadcast.setProductionMode();
                    }
                    androidBroadcast.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);
                    androidBroadcast.setPredefinedKeyValue("ticker", (Object)reqVO.getTitle());
                    androidBroadcast.setPredefinedKeyValue("title", (Object)reqVO.getSubTitle());
                    androidBroadcast.setPredefinedKeyValue("text", (Object)reqVO.getBody());
                    if (extraMap != null && !extraMap.isEmpty()) {
                        keySet = extraMap.keySet();
                        for (String key : keySet) {
                            androidBroadcast.setExtraField(key, (String)extraMap.get(key));
                        }
                        historyEntity.setExtraStr(JSON.toJSONString((Object)extraMap));
                    }
                    androidBroadcast.setDescription(reqVO.getDescription());
                    historyEntity.setProStep("send_ing");
                    umResult = this.pushClient.send((UmengNotification)androidBroadcast);
                    if (StringUtils.isBlank((CharSequence)umResult)) {
                        historyEntity.setProStep("send_fail");
                    } else {
                        rspBO = (UmengPushRspBO)JSON.parseObject((String)umResult, UmengPushRspBO.class);
                        if ("FAIL".equals(rspBO.getRet())) {
                            historyEntity.setProStep("send_fail");
                        } else {
                            bo = rspBO.getData();
                            historyEntity.setUmMsgId(bo.getMsgId());
                        }
                    }
                }
                catch (Exception e) {
                    log.error("\u53cb\u76df--\u5168\u5458\u63a8\u9001--\u5b89\u5353--\u5f02\u5e38---{}", (Throwable)e);
                    historyEntity.setProStep("exception");
                }
                historyList.add(historyEntity);
            }
            if ("iOS".equals(appDeviceType)) {
                try {
                    historyEntity.setProStep("send_assembling");
                    IOSBroadcast iosBroadcast = new IOSBroadcast(um.getAppSdkId(), um.getAppMasterSecret());
                    if (2 == environment) {
                        iosBroadcast.setTestMode();
                    } else {
                        iosBroadcast.setProductionMode();
                    }
                    iosBroadcast.setBadge(Integer.valueOf(0));
                    iosBroadcast.setSound("default");
                    iosBroadcast.setPredefinedKeyValue("alert", (Object)this.createIOSAlert(reqVO.getTitle(), reqVO.getSubTitle(), reqVO.getBody()));
                    if (extraMap != null && !extraMap.isEmpty()) {
                        keySet = extraMap.keySet();
                        for (String key : keySet) {
                            iosBroadcast.setCustomizedField(key, (String)extraMap.get(key));
                        }
                        historyEntity.setExtraStr(JSON.toJSONString((Object)extraMap));
                    }
                    iosBroadcast.setDescription(reqVO.getDescription());
                    historyEntity.setProStep("send_ing");
                    umResult = this.pushClient.send((UmengNotification)iosBroadcast);
                    if (StringUtils.isBlank((CharSequence)umResult)) {
                        historyEntity.setProStep("send_fail");
                    } else {
                        rspBO = (UmengPushRspBO)JSON.parseObject((String)umResult, UmengPushRspBO.class);
                        if ("FAIL".equals(rspBO.getRet())) {
                            historyEntity.setProStep("send_fail");
                        } else {
                            bo = rspBO.getData();
                            historyEntity.setUmMsgId(bo.getMsgId());
                        }
                    }
                }
                catch (Exception e) {
                    log.error("\u53cb\u76df--\u5168\u5458\u63a8\u9001--\u82f9\u679c--\u5f02\u5e38---{}", (Throwable)e);
                    historyEntity.setProStep("exception");
                }
                historyList.add(historyEntity);
            }
        });
        if (!historyList.isEmpty()) {
            this.umSendHistoryMapper.insertAll(historyList);
        }
        return BaseResponse.success();
    }

    public BaseResponse<?> getPushUmengRecord(QueryPushUmengRecordReqVO reqVO) {
        PageHelper.startPage((int)reqVO.getPage(), (int)reqVO.getSize());
        Page page = this.umSendHistoryMapper.queryMsgHistoryPage(reqVO.getUserId(), Integer.valueOf(0));
        if (page == null) {
            return BaseResponse.error((String)"\u6682\u65e0\u6d88\u606f!");
        }
        List historyList = page.getResult();
        List rspVOs = this.convertUmengMsg(historyList, "", "", null);
        PageResult pageData = new PageResult();
        pageData.setContent(rspVOs);
        pageData.setOrderBy("createDate");
        pageData.setPageNum(page.getPageNum());
        pageData.setPageSize(page.getPageSize());
        pageData.setTotalPages(page.getPages());
        ArrayList msgIdList = new ArrayList();
        pageData.getContent().forEach(content -> msgIdList.add(content.getMsgId()));
        return BaseResponse.success((Object)pageData);
    }

    public BaseResponse<List<UmGetMsgRspVO>> getPushUmengMsg(UmQueryMsgReqVO reqVO) {
        String sectionCode = reqVO.getClientCode();
        UmBusiMsgRelationEntity relationEntity = this.umBusiMsgRelationMapper.findBySectionCode(sectionCode);
        ArrayList rspVos = new ArrayList();
        if (relationEntity != null) {
            String userId = reqVO.getUserId();
            String accountId = reqVO.getAccountId();
            String pageCode = reqVO.getSectionCode();
            Long id = relationEntity.getId();
            List childBusi = StringUtils.isNotBlank((CharSequence)pageCode) ? this.umBusiMsgRelationMapper.findByParentIdAndSectionCode(id, pageCode) : this.umBusiMsgRelationMapper.findByParentId(id);
            childBusi.forEach(child -> {
                Long childId = child.getId();
                List childBusi1 = this.umBusiMsgRelationMapper.findByParentId(childId);
                if (childBusi1.isEmpty()) {
                    UmGetMsgRspVO rspVO = new UmGetMsgRspVO();
                    rspVO.setSectionCode(child.getSectionCode());
                    rspVO.setSectionName(child.getSectionName());
                    PageHelper.startPage((int)reqVO.getPageNum(), (int)reqVO.getPageSize());
                    Page msgs = accountId != null && accountId != "" ? this.umSendHistoryMapper.findMsgHistoryAccountPage(userId, accountId, child.getSectionCode()) : this.umSendHistoryMapper.findMsgHistoryPage(userId, child.getSectionCode());
                    rspVO.setMsgList(this.convertUmengMsg(msgs.getResult(), reqVO.getDeviceNum(), sectionCode, null));
                    rspVos.add(rspVO);
                } else {
                    Map<String, UmBusiMsgRelationEntity> map = childBusi1.stream().collect(Collectors.toMap(UmBusiMsgRelationEntity::getSectionCode, a -> a, (k1, k2) -> k1));
                    UmGetMsgRspVO rspVO = new UmGetMsgRspVO();
                    rspVO.setSectionCode(child.getSectionCode());
                    rspVO.setSectionName(child.getSectionName());
                    String sectionCodes = childBusi1.stream().map(UmBusiMsgRelationEntity::getSectionCode).collect(Collectors.joining("','", "'", "'"));
                    PageHelper.startPage((int)reqVO.getPageNum(), (int)reqVO.getPageSize());
                    Page msgs = accountId != null && accountId != "" ? this.umSendHistoryMapper.findMsgHistoryAccountPage(userId, accountId, sectionCodes) : this.umSendHistoryMapper.findMsgHistoryPage(userId, sectionCodes);
                    rspVO.setMsgList(this.convertUmengMsg(msgs.getResult(), reqVO.getDeviceNum(), sectionCode, map));
                    rspVos.add(rspVO);
                }
            });
            return BaseResponse.success(rspVos);
        }
        return BaseResponse.error((String)MessageUtils.get((String)UmNotificationEnum.UN_RECOGNIZED_CLIENT_CODE.name()));
    }

    private JSONObject createIOSAlert(String title, String subTitle, String body) {
        1 prams = new /* Unavailable Anonymous Inner Class!! */;
        return prams;
    }

    private List<QueryPushUmengRecordRspVO> convertUmengMsg(List<UmSendHistoryEntityWithBLOBs> data, String deviceNum, String clientCode, Map<String, UmBusiMsgRelationEntity> map) {
        ArrayList<QueryPushUmengRecordRspVO> rsp = new ArrayList<QueryPushUmengRecordRspVO>();
        if (data == null || data.isEmpty()) {
            return rsp;
        }
        data.forEach(dataPo -> {
            UmBusiMsgRelationEntity ur;
            QueryPushUmengRecordRspVO rspVO = new QueryPushUmengRecordRspVO();
            rspVO.setContent(dataPo.getBusiStyle() == null ? "" : dataPo.getBusiStyle());
            rspVO.setTitle(dataPo.getTitle() == null ? "" : dataPo.getTitle());
            String createDate = dataPo.getCreateDate();
            String createTime = dataPo.getCreateTime();
            rspVO.setMsgId(dataPo.getUmMsgId() == null ? "" : dataPo.getUmMsgId());
            rspVO.setSendTime(DateUtils.dateToStamp((String)(createDate + " " + createTime)));
            rspVO.setExtraStr(dataPo.getExtraStr() == null ? "" : dataPo.getExtraStr());
            String busiCode = dataPo.getBusiCode();
            if (map != null && (ur = (UmBusiMsgRelationEntity)map.get(busiCode)) != null) {
                rspVO.setByhEnumCode(ur.getByhEnumCode());
            }
            rspVO.setByhEnumCode(Optional.ofNullable(rspVO.getByhEnumCode()).orElse(""));
            rspVO.setBusiCode(busiCode == null ? "" : busiCode);
            dataPo.setReadStatus(Integer.valueOf(1));
            String orgiDeviceNum = dataPo.getDeviceNum();
            if (StringUtils.isEmpty((CharSequence)orgiDeviceNum)) {
                dataPo.setDeviceNum(deviceNum);
            } else {
                if (orgiDeviceNum.equals(deviceNum) && "EHOS_PATINET".equals(clientCode)) {
                    return;
                }
                dataPo.setDeviceNum(deviceNum);
            }
            rsp.add(rspVO);
        });
        this.umSendHistoryMapper.updateAllWithBLOBs(data);
        return rsp;
    }

    public BaseResponse<PageResult<UmPushRecordVo>> getDoctorUmengMsgRecord(String doctorId, String accountId, int pageNum, int pageSize) {
        Page page;
        List busiMsgRelations = this.umBusiMsgRelationMapper.getClientRelation((short)0, "EHOS_DOCTOR");
        String ids = busiMsgRelations.stream().map(BaseEntity::getId).map(String::valueOf).collect(Collectors.joining(","));
        List firstChildRelations = this.umBusiMsgRelationMapper.getChildRelation((short)0, ids);
        String firstIds = firstChildRelations.stream().map(BaseEntity::getId).map(String::valueOf).collect(Collectors.joining(","));
        List secondChildRelation = this.umBusiMsgRelationMapper.getChildRelation((short)0, firstIds);
        Map<String, UmBusiMsgRelationEntity> relationsMap = secondChildRelation.stream().collect(Collectors.toMap(UmBusiMsgRelationEntity::getSectionCode, item -> item, (v1, v2) -> v1));
        String sectionCodes = secondChildRelation.stream().map(UmBusiMsgRelationEntity::getSectionCode).collect(Collectors.joining("','", "'", "'"));
        if (doctorId != null && doctorId != "") {
            PageHelper.startPage((int)pageNum, (int)pageSize);
            page = this.umSendHistoryMapper.getMsgRecordByUserId(doctorId, sectionCodes);
        } else {
            PageHelper.startPage((int)pageNum, (int)pageSize);
            page = this.umSendHistoryMapper.getMsgRecordByAccountId(accountId, sectionCodes);
        }
        List pageInfo = page.getResult();
        List list = IUmengServiceImpl.convertToUmPushRecordVo((List)pageInfo, relationsMap);
        this.fixedThread.execute(() -> this.umSendHistoryMapper.updateAll(pageInfo));
        PageResult pageResult = new PageResult();
        pageResult.setTotalPages(page.getPages());
        pageResult.setTotal((int)page.getTotal());
        pageResult.setPageSize(page.getPageSize());
        pageResult.setPageNum(page.getPageNum());
        pageResult.setContent(list);
        return BaseResponse.success((Object)pageResult);
    }

    public BaseResponse<PageResult<UmPushRecordVo>> getPatientUmengMsgRecord(String patientId, int pageNum, int pageSize) {
        List busiMsgRelations = this.umBusiMsgRelationMapper.getClientRelation((short)0, "EHOS_PATINET");
        String ids = busiMsgRelations.stream().map(BaseEntity::getId).map(String::valueOf).collect(Collectors.joining(","));
        List firstChildRelations = this.umBusiMsgRelationMapper.getChildRelation((short)0, ids);
        String firstIds = firstChildRelations.stream().map(BaseEntity::getId).map(String::valueOf).collect(Collectors.joining(","));
        List secondChildRelation = this.umBusiMsgRelationMapper.getChildRelation((short)0, firstIds);
        Map<String, UmBusiMsgRelationEntity> relationsMap = secondChildRelation.stream().collect(Collectors.toMap(UmBusiMsgRelationEntity::getSectionCode, item -> item, (v1, v2) -> v1));
        String sectionCodes = secondChildRelation.stream().map(UmBusiMsgRelationEntity::getSectionCode).collect(Collectors.joining("','", "'", "'"));
        PageHelper.startPage((int)pageNum, (int)pageSize);
        Page page = this.umSendHistoryMapper.getMsgRecordByUserId(patientId, sectionCodes);
        List pageInfo = page.getResult();
        List list = IUmengServiceImpl.convertToUmPushRecordVo((List)pageInfo, relationsMap);
        this.fixedThread.execute(() -> this.umSendHistoryMapper.updateAll(pageInfo));
        PageResult pageResult = new PageResult();
        pageResult.setTotalPages(page.getPages());
        pageResult.setTotal((int)page.getTotal());
        pageResult.setPageSize(page.getPageSize());
        pageResult.setPageNum(page.getPageNum());
        pageResult.setContent(list);
        return BaseResponse.success((Object)pageResult);
    }

    private static List<UmPushRecordVo> convertToUmPushRecordVo(List<UmSendHistoryEntity> pageInfo, Map<String, UmBusiMsgRelationEntity> relationsMap) {
        ArrayList<UmPushRecordVo> list = new ArrayList<UmPushRecordVo>();
        pageInfo.forEach(msgRecord -> {
            UmPushRecordVo umPushRecordVo = UmPushRecordVo.builder().build();
            BeanUtils.copyProperties((Object)msgRecord, (Object)umPushRecordVo);
            String createDate = msgRecord.getCreateDate();
            String createTime = msgRecord.getCreateTime();
            if (createDate != null && createDate != "" && createTime != null && createTime != "") {
                StringBuilder date = new StringBuilder(createDate);
                String sendTime = date.append(" ").append(createTime).toString();
                umPushRecordVo.setSendTime(sendTime);
            }
            String busiCode = msgRecord.getBusiCode();
            msgRecord.setReadStatus(Integer.valueOf(1));
            UmBusiMsgRelationEntity umBusiMsgRelationEntity = (UmBusiMsgRelationEntity)relationsMap.get(busiCode);
            umPushRecordVo.setBusiName(umBusiMsgRelationEntity.getSectionName());
            umPushRecordVo.setByhEnumCode(umBusiMsgRelationEntity.getByhEnumCode());
            list.add(umPushRecordVo);
        });
        return list;
    }

    public BaseResponse<UmGetMsgRspVO> getUmMsgRecord(UmQueryMsgReqVO reqVO) {
        String sectionCode = reqVO.getClientCode();
        UmBusiMsgRelationEntity relationEntity = this.umBusiMsgRelationMapper.findBySectionCode(sectionCode);
        UmGetMsgRspVO rspVO = new UmGetMsgRspVO();
        if (relationEntity != null) {
            String userId = reqVO.getUserId();
            String pageCode = reqVO.getSectionCode();
            Long id = relationEntity.getId();
            List childBusi = this.umBusiMsgRelationMapper.findByParentIdAndSectionCode(id, pageCode);
            String firstIds = childBusi.stream().map(BaseEntity::getId).map(String::valueOf).collect(Collectors.joining(","));
            Map<String, UmBusiMsgRelationEntity> map = childBusi.stream().collect(Collectors.toMap(UmBusiMsgRelationEntity::getSectionCode, a -> a, (k1, k2) -> k1));
            List secondChildRelation = this.umBusiMsgRelationMapper.getChildRelation((short)0, firstIds);
            String sectionCodes = secondChildRelation.stream().map(UmBusiMsgRelationEntity::getSectionCode).collect(Collectors.joining("','", "'", "'"));
            PageHelper.startPage((int)reqVO.getPageNum(), (int)reqVO.getPageSize());
            Page msgs = this.umSendHistoryMapper.findMsgHistoryPage(userId, sectionCodes);
            rspVO.setMsgList(this.convertUmengMsg(msgs.getResult(), reqVO.getDeviceNum(), sectionCode, map));
            rspVO.setSectionCode(reqVO.getSectionCode());
            rspVO.setSectionName(map.get(reqVO.getSectionCode()).getSectionName());
            return BaseResponse.success((Object)rspVO);
        }
        return BaseResponse.error((IError)IError.DATA_ERROR, (String)MessageUtils.get((String)UmNotificationEnum.UN_RECOGNIZED_CLIENT_CODE.name()));
    }

    public BaseResponse<?> pushUmCastList(UmListCastReqVO reqVO) {
        Map map = this.checkCastListParam(reqVO);
        if (map.isEmpty()) {
            return BaseResponse.error((String)MessageUtils.get((String)UmNotificationEnum.APPLICATION_NOT_EXISTS.name()));
        }
        APushUmCastList.push((UmListCastReqVO)reqVO, (Map)map);
        return BaseResponse.success();
    }

    private Map<String, UmApplicationEntity> checkCastListParam(UmListCastReqVO reqVO) {
        String umAppCode = reqVO.getClientCode();
        HashMap<String, UmApplicationEntity> umApplicationMap = new HashMap<String, UmApplicationEntity>();
        UmApplicationEntity umAndroid = this.checkApplication(umAppCode, reqVO.getAndroidDeviceNum());
        this.initApplication(reqVO, umAppCode, umApplicationMap, umAndroid);
        return umApplicationMap;
    }

    private void initApplication(UmListCastReqVO reqVO, String umAppCode, Map<String, UmApplicationEntity> umApplicationMap, UmApplicationEntity umAndroid) {
        UmApplicationEntity umIos;
        if (umAndroid != null) {
            umApplicationMap.put(umAndroid.getAppDeviceType(), umAndroid);
        }
        if ((umIos = this.checkApplication(umAppCode, reqVO.getIosDeviceNum())) != null) {
            umApplicationMap.put(umIos.getAppDeviceType(), umIos);
        }
    }

    private UmApplicationEntity checkApplication(String umAppCode, Map<String, String> deviceNum) {
        if (!CollectionUtils.isEmpty(deviceNum)) {
            UmApplicationEntity umApp = this.umApplicationMapper.findByClientCodeAndAppDeviceType(umAppCode);
            if (umApp == null) {
                log.error("\u5e94\u7528\u672a\u914d\u7f6e,umAppCode=" + umAppCode);
            } else {
                return umApp;
            }
        }
        return null;
    }
}

