/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.utils;

import com.alibaba.fastjson.JSON;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.ebaiyihui.push.sms.pojo.bo.AliSmsSendResponseBO;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliSmsSendUtils {
    private static final Logger log = LoggerFactory.getLogger(AliSmsSendUtils.class);
    private static final String PRODUCT = "Dysmsapi";
    private static final String SMS_DOMAIN = "dysmsapi.aliyuncs.com";
    private static final String REGION_ID = "cn-hangzhou";
    private static final String SMS_ACTION = "SendSms";
    private static final String VERSION = "2017-05-25";

    public static AliSmsSendResponseBO sendSms(String accessKeyId, String secret, String signName, Map<String, String> params, String tempCode, String phoneNumbers) {
        DefaultProfile profile = DefaultProfile.getProfile((String)REGION_ID, (String)accessKeyId, (String)secret);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.POST);
        request.setDomain(SMS_DOMAIN);
        request.setAction(SMS_ACTION);
        request.setConnectTimeout(Integer.valueOf(5000));
        request.setReadTimeout(Integer.valueOf(5000));
        request.setProduct(PRODUCT);
        request.setVersion(VERSION);
        request.putQueryParameter("RegionId", REGION_ID);
        request.putQueryParameter("SignName", signName);
        request.putQueryParameter("TemplateCode", tempCode);
        request.putQueryParameter("TemplateParam", JSON.toJSONString(params));
        request.putQueryParameter("PhoneNumbers", phoneNumbers);
        log.info("init sms push param end!!");
        try {
            CommonResponse response = client.getCommonResponse(request);
            String rspData = response.getData();
            log.info("ali\u5de5\u5177\u7c7b\u54cd\u5e94\u53c2\u6570rspData:" + rspData);
            if (StringUtils.isEmpty((CharSequence)rspData)) {
                return null;
            }
            return (AliSmsSendResponseBO)JSON.parseObject((String)rspData, AliSmsSendResponseBO.class);
        }
        catch (ServerException se) {
            se.printStackTrace();
            log.error("ServerException,e=", (Throwable)se);
        }
        catch (ClientException ce) {
            ce.printStackTrace();
            log.error("ClientException,e=", (Throwable)ce);
        }
        return null;
    }
}

