/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.wechat.service;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.push.pojo.wechat.GetTokenReqVO;
import com.ebaiyihui.push.pojo.wechat.PushSubscribeMessageReqVO;
import com.ebaiyihui.push.pojo.wechat.PushTemplateMessageReqVO;
import com.ebaiyihui.push.pojo.wechat.PushUserReqVO;
import com.ebaiyihui.push.utils.MessageUtils;
import com.ebaiyihui.push.wechat.dao.WxPushApplicationMapper;
import com.ebaiyihui.push.wechat.dao.WxPushHistoryMapper;
import com.ebaiyihui.push.wechat.dao.WxPushTemplateMapper;
import com.ebaiyihui.push.wechat.dao.WxPushUserMapper;
import com.ebaiyihui.push.wechat.enums.PushDataKeyEnum;
import com.ebaiyihui.push.wechat.enums.ResultEnum;
import com.ebaiyihui.push.wechat.enums.WxNotificationEnum;
import com.ebaiyihui.push.wechat.manager.WechatMessage;
import com.ebaiyihui.push.wechat.pojo.bo.BaseResBO;
import com.ebaiyihui.push.wechat.pojo.bo.GetTokenResBO;
import com.ebaiyihui.push.wechat.pojo.bo.TemplateMessageBO;
import com.ebaiyihui.push.wechat.pojo.entity.WxPushApplicationEntity;
import com.ebaiyihui.push.wechat.pojo.entity.WxPushHistory;
import com.ebaiyihui.push.wechat.pojo.entity.WxPushTemplate;
import com.ebaiyihui.push.wechat.pojo.entity.WxPushUser;
import com.ebaiyihui.push.wechat.service.WechatMessageService;
import com.ebaiyihui.push.wechat.utils.RedisUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisCluster;

@Service
public class WechatMessageServiceImpl
implements WechatMessageService {
    private static final Logger log = LoggerFactory.getLogger(WechatMessageServiceImpl.class);
    @Autowired
    private WxPushApplicationMapper wxPushApplicationMapper;
    @Autowired
    private WxPushUserMapper wxPushUserMapper;
    @Autowired
    private WxPushTemplateMapper wxPushTemplateMapper;
    @Autowired
    private WxPushHistoryMapper wxPushHistoryMapper;

    public BaseResponse<?> getAccessToken(GetTokenReqVO getTokenReqVO) {
        GetTokenResBO getTokenResBO = this.getGetTokenResBO(getTokenReqVO.getClientCode());
        if (getTokenResBO.getErrcode() == null) {
            return BaseResponse.success((Object)getTokenResBO.getAccessToken());
        }
        return BaseResponse.error((String)JSONObject.toJSONString((Object)getTokenResBO));
    }

    public BaseResponse<?> savePushUser(PushUserReqVO pushUserReqVO) {
        JedisCluster jedisCluster = RedisUtil.getJedis();
        WxPushUser wxPushUser = new WxPushUser();
        try {
            BeanUtils.copyProperties((Object)pushUserReqVO, (Object)wxPushUser);
            this.wxPushUserMapper.insertOne(wxPushUser);
            String redisKey = pushUserReqVO.getUserId() + "_" + "wechat_push_user";
            boolean flag = jedisCluster.exists(redisKey);
            if (!flag) {
                RedisUtil.setDataAndExpired((String)redisKey, (String)JSONObject.toJSONString((Object)pushUserReqVO), (int)3600);
            }
            return BaseResponse.success();
        }
        catch (Exception e) {
            log.error("savePusher error,e=", (Throwable)e);
            return BaseResponse.error((String)MessageUtils.get((String)WxNotificationEnum.SAVE_PUSH_ERROR.name()));
        }
    }

    public BaseResponse<?> push(PushTemplateMessageReqVO pushTemplateMessageReqVO) {
        JedisCluster jedisCluster = RedisUtil.getJedis();
        try {
            String clientCode = pushTemplateMessageReqVO.getClientCode();
            GetTokenResBO getTokenResBO = this.getMsgAccessToken(clientCode);
            WxPushApplicationEntity wxPushApplicationEntity = this.wxPushApplicationMapper.selectByClientCode(clientCode);
            WxPushTemplate wxPushTemplate = this.wxPushTemplateMapper.selectOne(pushTemplateMessageReqVO.getTemplateCode(), wxPushApplicationEntity.getId());
            TemplateMessageBO templateMessageBO = new TemplateMessageBO();
            String accessToken = getTokenResBO.getAccessToken();
            String redisKey = pushTemplateMessageReqVO.getUserId() + "_" + "wechat_push_user";
            this.initPushParams(templateMessageBO, pushTemplateMessageReqVO);
            boolean flag = this.initTemplateMessageBO(pushTemplateMessageReqVO, templateMessageBO, wxPushTemplate, redisKey);
            BaseResBO baseResBO = WechatMessage.push((Object)templateMessageBO, (String)accessToken, (String)"https://api.weixin.qq.com/cgi-bin/message/wxopen/template/send?access_token=");
            this.wxPushUserMapper.updateStatus(pushTemplateMessageReqVO.getUserId());
            log.info("wx push errCode =" + baseResBO.getErrcode() + ",errMsg=" + baseResBO.getErrmsg());
            if (flag) {
                jedisCluster.del(redisKey);
            }
            WxPushHistory wxPushHistory = this.buildMsgHistory((Object)pushTemplateMessageReqVO, templateMessageBO, wxPushTemplate, baseResBO);
            this.wxPushHistoryMapper.insertOne(wxPushHistory);
            return BaseResponse.success();
        }
        catch (Exception e) {
            log.info("wx push error,e=", (Throwable)e);
            return BaseResponse.error((String)MessageUtils.get((String)WxNotificationEnum.WX_PUSH_ERROR.name()));
        }
    }

    public BaseResponse<?> pushSubscribeMessage(PushSubscribeMessageReqVO pushSubscribeMessageReqVO) {
        BaseResBO baseResBO = new BaseResBO();
        try {
            String clientCode = pushSubscribeMessageReqVO.getClientCode();
            log.info("pushSubscribeMessage clientCode=" + clientCode);
            WxPushApplicationEntity wxPushApplicationEntity = this.wxPushApplicationMapper.selectByClientCode(clientCode);
            GetTokenResBO getTokenResBO = this.getGetTokenResBO(clientCode);
            WxPushTemplate wxPushTemplate = this.wxPushTemplateMapper.selectOne(pushSubscribeMessageReqVO.getTemplateCode(), wxPushApplicationEntity.getId());
            log.info("user template =" + JSONObject.toJSONString((Object)wxPushTemplate));
            this.transformData(wxPushTemplate, pushSubscribeMessageReqVO);
            TemplateMessageBO templateMessageBO = this.initSubscribeParam(pushSubscribeMessageReqVO, wxPushTemplate.getTempId());
            baseResBO = WechatMessage.push((Object)templateMessageBO, (String)getTokenResBO.getAccessToken(), (String)"https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token=");
            log.info("pushSubscribeMessage result =" + JSONObject.toJSONString((Object)baseResBO));
            WxPushHistory wxPushHistory = this.buildMsgHistory((Object)pushSubscribeMessageReqVO, templateMessageBO, wxPushTemplate, baseResBO);
            this.wxPushHistoryMapper.insertOne(wxPushHistory);
            if (baseResBO.getErrcode() == 0) {
                return BaseResponse.success((Object)baseResBO);
            }
        }
        catch (Exception e) {
            log.error("pushSubscribeMessage error,e=", (Throwable)e);
        }
        return BaseResponse.error((String)baseResBO.getErrmsg());
    }

    public BaseResponse<?> getSubscribeTemplate(String clientCode) {
        try {
            WxPushApplicationEntity wxPushApplicationEntity = this.wxPushApplicationMapper.selectByClientCode(clientCode);
            if (wxPushApplicationEntity == null) {
                return BaseResponse.error((String)("this application is not exists,clientCode=" + clientCode));
            }
            return BaseResponse.success((Object)this.wxPushTemplateMapper.selectList(wxPushApplicationEntity.getId()));
        }
        catch (Exception e) {
            log.error("getSubscribeTemplate error,e=", (Throwable)e);
            return BaseResponse.error((String)MessageUtils.get((String)WxNotificationEnum.GET_PUSH_TEMPLATE_ERROR.name()));
        }
    }

    public BaseResponse<?> checkHealth() {
        try {
            WxPushApplicationEntity wxPushApplicationEntity = this.wxPushApplicationMapper.selectByClientCode("server_finished_notify");
            if (wxPushApplicationEntity == null) {
                return BaseResponse.error((String)"this application is not exists,clientCode=server_finished_notify");
            }
            return BaseResponse.success((Object)this.wxPushTemplateMapper.selectList(wxPushApplicationEntity.getId()));
        }
        catch (Exception e) {
            log.error("getSubscribeTemplate error,e=", (Throwable)e);
            return BaseResponse.error((String)MessageUtils.get((String)WxNotificationEnum.GET_PUSH_TEMPLATE_ERROR.name()));
        }
    }

    private void transformData(WxPushTemplate wxPushTemplate, PushSubscribeMessageReqVO pushSubscribeMessageReqVO) {
        LinkedHashMap resultMap = new LinkedHashMap();
        ArrayList<String> templateParamList = new ArrayList<String>(Arrays.asList(wxPushTemplate.getTempContent().split(",")));
        Map dataMap = pushSubscribeMessageReqVO.getData();
        for (int i = 0; i < templateParamList.size(); ++i) {
            Iterator iterator = dataMap.entrySet().iterator();
            if (!iterator.hasNext()) continue;
            Map.Entry entry = iterator.next();
            resultMap.put(templateParamList.get(i), entry.getValue());
            dataMap.remove(entry.getKey());
        }
        pushSubscribeMessageReqVO.setData(resultMap);
        log.info("subscribe data =" + JSONObject.toJSONString(resultMap));
    }

    private TemplateMessageBO initSubscribeParam(PushSubscribeMessageReqVO reqVO, String templateId) {
        TemplateMessageBO templateMessageBO = new TemplateMessageBO();
        templateMessageBO.setTouser(reqVO.getOpenId());
        templateMessageBO.setData(reqVO.getData());
        templateMessageBO.setPage(reqVO.getPage());
        templateMessageBO.setTemplate_id(templateId);
        templateMessageBO.setLang(reqVO.getLang());
        return templateMessageBO;
    }

    private GetTokenResBO getMsgAccessToken(String clientCode) {
        String accessToken = WechatMessage.getAccessTokenFromCache((String)clientCode);
        if (accessToken != null) {
            return new GetTokenResBO(accessToken);
        }
        return this.getGetTokenResBO(clientCode);
    }

    private GetTokenResBO getGetTokenResBO(String clientCode) {
        WxPushApplicationEntity wxPushApplicationEntity = this.wxPushApplicationMapper.selectByClientCode(clientCode);
        return WechatMessage.getAccessTokenFromDB((String)wxPushApplicationEntity.getAppId(), (String)wxPushApplicationEntity.getSecret(), (String)clientCode);
    }

    private <T> WxPushHistory buildMsgHistory(T t, TemplateMessageBO templateMessageBO, WxPushTemplate wxPushTemplate, BaseResBO baseResBO) {
        WxPushHistory wxPushHistory = new WxPushHistory();
        wxPushHistory.setOpenId(templateMessageBO.getTouser());
        wxPushHistory.setTempFkId(wxPushTemplate.getId());
        wxPushHistory.setWxPushParam(JSONObject.toJSONString(t));
        Integer errCode = baseResBO.getErrcode();
        if (errCode == 0) {
            wxPushHistory.setWxPushStatus(ResultEnum.SUCCESS.toString().toLowerCase());
        } else {
            wxPushHistory.setWxPushStatus(ResultEnum.ERROR.toString().toLowerCase());
        }
        wxPushHistory.setWxErrcode(baseResBO.getErrcode().toString());
        wxPushHistory.setWxErrmsg(baseResBO.getErrmsg());
        return wxPushHistory;
    }

    private void initPushParams(TemplateMessageBO templateMessageBO, PushTemplateMessageReqVO templateMessageReqVO) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(templateMessageReqVO.getParams().split(",")));
        LinkedHashMap map = new LinkedHashMap();
        for (int i = 0; i < list.size(); ++i) {
            HashMap valueMap = new HashMap();
            valueMap.put(PushDataKeyEnum.VALUE.getName(), list.get(i));
            int num = i + 1;
            map.put("keyword" + num, valueMap);
        }
        templateMessageBO.setData(map);
    }

    private boolean initTemplateMessageBO(PushTemplateMessageReqVO pushTemplateMessageReqVO, TemplateMessageBO templateMessageBO, WxPushTemplate wxPushTemplate, String redisKey) {
        JedisCluster jedisCluster = RedisUtil.getJedis();
        boolean flag = jedisCluster.exists(redisKey);
        WxPushUser wxPushUser = flag ? (WxPushUser)JSONObject.parseObject((String)jedisCluster.get(redisKey), WxPushUser.class) : this.wxPushUserMapper.selectOne(pushTemplateMessageReqVO.getUserId());
        templateMessageBO.setForm_id(wxPushUser.getFormId());
        templateMessageBO.setTouser(wxPushUser.getOpenId());
        templateMessageBO.setEmphasis_keyword(wxPushTemplate.getEmphasisKeyword());
        templateMessageBO.setPage(pushTemplateMessageReqVO.getPage());
        templateMessageBO.setTemplate_id(wxPushTemplate.getTempId());
        return flag;
    }
}

