/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.goeasy.service.impl;

import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.push.goeasy.business.ListCastPush;
import com.ebaiyihui.push.goeasy.dao.GeSendHistoryMapper;
import com.ebaiyihui.push.goeasy.enums.GoeasyNotificationEnum;
import com.ebaiyihui.push.goeasy.pojo.bo.GoEasyBo;
import com.ebaiyihui.push.goeasy.pojo.entity.GeSendHistoryEntity;
import com.ebaiyihui.push.goeasy.service.IGoeasyService;
import com.ebaiyihui.push.pojo.goeasy.GoeasyPushMsgWithUserIdReqVO;
import com.ebaiyihui.push.pojo.goeasy.GoeasyQueryMsgReqVO;
import com.ebaiyihui.push.pojo.goeasy.GoeasyQueryMsgRspVO;
import com.ebaiyihui.push.umeng.dao.UmBusiMsgRelationMapper;
import com.ebaiyihui.push.umeng.pojo.entity.UmBusiMsgRelationEntity;
import com.ebaiyihui.push.utils.GoEasyUtil;
import com.ebaiyihui.push.utils.MessageUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IGoeasyServiceImpl
implements IGoeasyService {
    private static final Logger log = LoggerFactory.getLogger(IGoeasyServiceImpl.class);
    @Autowired
    private GeSendHistoryMapper geSendHistoryMapper;
    @Autowired
    private UmBusiMsgRelationMapper umBusiMsgRelationMapper;
    private ListCastPush listCastPush = new ListCastPush();

    public BaseResponse<?> pushGoeasyMsgByUserId(GoeasyPushMsgWithUserIdReqVO reqVO) {
        String userId = reqVO.getUserId();
        if (StringUtils.isEmpty((CharSequence)userId)) {
            return BaseResponse.error((String)MessageUtils.get((String)GoeasyNotificationEnum.USER_ID_NOT_EMPTY.getName()));
        }
        if (!userId.contains(",")) {
            return this.sendPush(reqVO);
        }
        this.splitId(userId, reqVO);
        return BaseResponse.success();
    }

    public BaseResponse<?> pushGoeasyMsgByBroadcast(GoeasyPushMsgWithUserIdReqVO reqVO) {
        reqVO.setUserId("GO_EASY_PUSH_TO_ALL");
        return this.sendPush(reqVO);
    }

    public BaseResponse<?> getGoeasyMsgRecords(GoeasyQueryMsgReqVO reqVO) {
        ArrayList rspVOs = new ArrayList();
        String userId = reqVO.getUserId();
        String startDate = reqVO.getStartDate();
        String endDate = reqVO.getEndDate();
        PageHelper.startPage((int)reqVO.getPageNum(), (int)reqVO.getPageSize());
        Page pageData = this.geSendHistoryMapper.queryMsgRecordPage(userId, startDate, endDate);
        pageData.getResult().forEach(msg -> {
            GoeasyQueryMsgRspVO msgRsp = new GoeasyQueryMsgRspVO();
            msgRsp.setBusiCode(msg.getBusiCode());
            msgRsp.setMsgBody(msg.getGeOrigMsg());
            UmBusiMsgRelationEntity umBusiMsgRelationEntity = this.getByhEnumCodeBySectionCode(msg.getBusiCode());
            msgRsp.setByhEnumCode(umBusiMsgRelationEntity.getByhEnumCode());
            msgRsp.setSendTime(msg.getCreateDate() + " " + msg.getCreateTime());
            msgRsp.setBusiName(umBusiMsgRelationEntity.getSectionName());
            rspVOs.add(msgRsp);
        });
        PageResult pageResult = new PageResult();
        pageResult.setContent(rspVOs);
        pageResult.setTotal((int)pageData.getTotal());
        pageResult.setPageNum(pageData.getPageNum());
        pageResult.setPageSize(pageData.getPageSize());
        return BaseResponse.success((Object)pageResult);
    }

    private UmBusiMsgRelationEntity getByhEnumCodeBySectionCode(String busiCode) {
        if (StringUtils.isEmpty((CharSequence)busiCode)) {
            return new UmBusiMsgRelationEntity();
        }
        Optional busiRelationOptional = this.umBusiMsgRelationMapper.findOpBySectionCode(busiCode);
        UmBusiMsgRelationEntity busiMsgRelation = busiRelationOptional.orElseGet(() -> {
            UmBusiMsgRelationEntity busiMsgRelationEntity = new UmBusiMsgRelationEntity();
            busiMsgRelationEntity.setByhEnumCode("");
            return busiMsgRelationEntity;
        });
        return busiMsgRelation;
    }

    public BaseResponse<?> sendPush(GoeasyPushMsgWithUserIdReqVO reqVO) {
        try {
            GoEasyBo goEasyVO = GoEasyUtil.PushMessage((String)reqVO.getUserId(), (String)reqVO.getBody());
            GeSendHistoryEntity entity = new GeSendHistoryEntity();
            entity.setGeOrigMsg(reqVO.getBody());
            entity.setUserId(reqVO.getUserId());
            entity.setBusiCode(reqVO.getBusiCode());
            entity.setGeCode(Integer.valueOf(goEasyVO.getCode()));
            entity.setGeMsg(goEasyVO.getMsg());
            this.geSendHistoryMapper.insertSelective(entity);
            if (2015 == goEasyVO.getCode()) {
                return BaseResponse.success((Object)goEasyVO.getMsg());
            }
            return BaseResponse.error((String)("goeasy\u9519\u8bef\u7801\uff1a" + goEasyVO.getCode() + "\uff0c\u9519\u8bef\u6d88\u606f\uff1a" + goEasyVO.getMsg()));
        }
        catch (Exception e) {
            return BaseResponse.error((String)MessageUtils.get((String)GoeasyNotificationEnum.PUSH_FAILED.name()));
        }
    }

    private void splitId(String userId, GoeasyPushMsgWithUserIdReqVO reqVO) {
        ArrayList<String> userIdList = new ArrayList<String>(Arrays.asList(userId.split(",")));
        userIdList.forEach(id -> {
            GoeasyPushMsgWithUserIdReqVO target = this.initBean(reqVO);
            target.setUserId(id);
            this.listCastPush.addTask(target);
        });
    }

    private GoeasyPushMsgWithUserIdReqVO initBean(GoeasyPushMsgWithUserIdReqVO source) {
        GoeasyPushMsgWithUserIdReqVO target = new GoeasyPushMsgWithUserIdReqVO();
        BeanUtils.copyProperties((Object)source, (Object)target);
        return target;
    }
}

