/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.miniapp.alipay.service;

import com.alibaba.fastjson.JSON;
import com.alipay.api.domain.AlipayOpenAppMiniTemplatemessageSendModel;
import com.alipay.api.response.AlipayOpenAppMiniTemplatemessageSendResponse;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.push.miniapp.alipay.bo.AliAppMiniMsg;
import com.ebaiyihui.push.miniapp.alipay.service.AliMiniService;
import com.ebaiyihui.push.miniapp.pojo.MiniAppInfo;
import com.ebaiyihui.push.miniapp.pojo.MiniAppMsgRecord;
import com.ebaiyihui.push.miniapp.pojo.MiniAppMsgTmp;
import com.ebaiyihui.push.miniapp.service.MiniAppInfoService;
import com.ebaiyihui.push.miniapp.service.MiniAppMsgRecordService;
import com.ebaiyihui.push.miniapp.service.MiniAppMsgTmpService;
import com.ebaiyihui.push.pojo.miniapp.MiniappTmpMsgReqVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliMiniServiceImpl
implements AliMiniService {
    private static final Logger log = LoggerFactory.getLogger(AliMiniServiceImpl.class);
    private final MiniAppMsgTmpService miniAppMsgTmpServiceImpl;
    private final MiniAppMsgRecordService miniAppMsgRecordServiceImpl;
    private final MiniAppInfoService miniAppInfoServiceImp;

    public BaseResponse<?> pushSubscribeMessage(MiniappTmpMsgReqVO reqVO) {
        log.info("pushSubscribeMessage param ={}", (Object)reqVO);
        String clientCode = reqVO.getGetTokenReqVO().getClientCode();
        MiniAppInfo appInfo = this.miniAppInfoServiceImp.getByAppCode(clientCode);
        String appId = appInfo.getAppid();
        String[] keys = appInfo.getSecret().split("###");
        MiniAppMsgTmp tmp = this.miniAppMsgTmpServiceImpl.getOneByTmpCodeAndAppId(reqVO.getTemplateCode(), appInfo.getId());
        AlipayOpenAppMiniTemplatemessageSendModel model = new AlipayOpenAppMiniTemplatemessageSendModel();
        model.setFormId("");
        model.setPage(reqVO.getPage());
        model.setToUserId(reqVO.getOpenId());
        model.setUserTemplateId(tmp.getTmpId());
        model.setData(JSON.toJSONString((Object)this.transformData(tmp.getTmpContent(), reqVO.getData())));
        log.info("alipay miniapp subscribeMessage request param ={}", (Object)JSON.toJSONString((Object)model));
        AlipayOpenAppMiniTemplatemessageSendResponse response = AliAppMiniMsg.pushMsg((String)appId, (String)keys[0], (String)keys[1], (AlipayOpenAppMiniTemplatemessageSendModel)model);
        log.info("alipay miniapp subscribeMessage request param ={}", (Object)JSON.toJSONString((Object)model));
        MiniAppMsgRecord a = new MiniAppMsgRecord();
        a.setAppId(appInfo.getId());
        a.setTmpId(tmp.getId());
        a.setToUserId(reqVO.getOpenId());
        a.setPushParams(JSON.toJSONString((Object)reqVO));
        a.setPushRes(JSON.toJSONString((Object)response));
        this.miniAppMsgRecordServiceImpl.save(a);
        return response.isSuccess() ? BaseResponse.success() : BaseResponse.error((String)("\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f[" + appInfo.getAppName() + "]\u6a21\u677f\u8ba2\u9605\u6d88\u606f\u63a8\u9001\u5931\u8d25"));
    }

    private Map<String, Map<String, Object>> transformData(String tempContent, Map<String, Map<String, Object>> dataMap) {
        LinkedHashMap<String, Map<String, Object>> res = new LinkedHashMap<String, Map<String, Object>>();
        ArrayList<String> templateParamList = new ArrayList<String>(Arrays.asList(tempContent.split(",")));
        for (int i = 0; i < templateParamList.size(); ++i) {
            Iterator<Map.Entry<String, Map<String, Object>>> iterator = dataMap.entrySet().iterator();
            if (!iterator.hasNext()) continue;
            Map.Entry<String, Map<String, Object>> entry = iterator.next();
            res.put((String)templateParamList.get(i), entry.getValue());
            dataMap.remove(entry.getKey());
        }
        log.info("subscribe msg data ={}", res);
        return res;
    }

    public AliMiniServiceImpl(MiniAppMsgTmpService miniAppMsgTmpServiceImpl, MiniAppMsgRecordService miniAppMsgRecordServiceImpl, MiniAppInfoService miniAppInfoServiceImp) {
        this.miniAppMsgTmpServiceImpl = miniAppMsgTmpServiceImpl;
        this.miniAppMsgRecordServiceImpl = miniAppMsgRecordServiceImpl;
        this.miniAppInfoServiceImp = miniAppInfoServiceImp;
    }
}

