/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.sms.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.push.pojo.alisms.AliSmsSendAuthCodeReqPhoneVO;
import com.ebaiyihui.push.pojo.sms.SmsSendAuthCodeRsp;
import com.ebaiyihui.push.sms.dao.SmsApplicationMapper;
import com.ebaiyihui.push.sms.dao.SmsBlackPhoneListMapper;
import com.ebaiyihui.push.sms.dao.SmsSendHistoryMapper;
import com.ebaiyihui.push.sms.dao.SmsSignMapper;
import com.ebaiyihui.push.sms.dao.SmsTemplateMapper;
import com.ebaiyihui.push.sms.enums.SmsNotificationEnum;
import com.ebaiyihui.push.sms.pojo.bo.AliSmsSendResponseBO;
import com.ebaiyihui.push.sms.pojo.entity.SmsApplicationEntity;
import com.ebaiyihui.push.sms.pojo.entity.SmsSendHistoryEntity;
import com.ebaiyihui.push.sms.service.IAliSmsService;
import com.ebaiyihui.push.utils.AliSmsSendUtils;
import com.ebaiyihui.push.utils.DateUtils;
import com.ebaiyihui.push.utils.MessageUtils;
import com.ebaiyihui.push.utils.RandomUtils;
import com.ebaiyihui.push.utils.StringUtil;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class IAliSmsServiceImpl
implements IAliSmsService {
    private static final Logger log = LoggerFactory.getLogger(IAliSmsServiceImpl.class);
    @Autowired
    private SmsApplicationMapper smsApplicationMapper;
    @Autowired
    private SmsTemplateMapper smsTemplateMapper;
    @Autowired
    private SmsSendHistoryMapper smsSendHistoryMapper;
    @Autowired
    private SmsSignMapper smsSignMapper;
    @Autowired
    private SmsBlackPhoneListMapper smsBlackPhoneListMapper;
    @Autowired
    private RedisTemplate redisTemplate;
    private String DEFAULT_LANGUAGE_TYPE = "CN";

    public BaseResponse<SmsSendAuthCodeRsp> sendAuthCodeWithPhone(AliSmsSendAuthCodeReqPhoneVO reqVO) {
        if ("SMS_112470358".equals(reqVO.getTemplateCode())) {
            log.info("\u65e0\u6548\u8bf7\u6c42,\u5df2\u4e22\u5f03!");
            return BaseResponse.success();
        }
        return this.sendCommonSms(reqVO);
    }

    private BaseResponse<SmsSendAuthCodeRsp> sendCommonSms(AliSmsSendAuthCodeReqPhoneVO reqVO) {
        String templateId;
        String appSdkType = reqVO.getAppSdkType();
        String smsAppCode = reqVO.getSmsAppCode();
        String signCode = reqVO.getSignCode();
        String userPhoneNum = reqVO.getPhone();
        log.info("\u7528\u6237\u624b\u673a\u53f7\u4e3a = {}", (Object)userPhoneNum);
        if (StringUtils.isBlank((CharSequence)userPhoneNum)) {
            return BaseResponse.error((String)MessageUtils.get((String)SmsNotificationEnum.PHONE_NUMBER_IS_EMPTY.name()));
        }
        SmsApplicationEntity smsApp = null;
        smsApp = StringUtil.isBlank((String)smsAppCode) ? this.smsApplicationMapper.selectOneByAppcode(reqVO.getAppCode()) : this.smsApplicationMapper.findByClientCodeAndAppSdkType(smsAppCode, appSdkType);
        if (smsApp == null) {
            return BaseResponse.error((String)MessageUtils.get((String)SmsNotificationEnum.NO_SMS_APPLICATION.name()));
        }
        String signName = this.smsSignMapper.selectSignName(signCode);
        if (signName == null) {
            return BaseResponse.error((String)MessageUtils.get((String)SmsNotificationEnum.SIGNATURE_DOES_NO_EXIST.name()));
        }
        String templateCode = reqVO.getTemplateCode();
        String languageType = reqVO.getLanguageType();
        if (StringUtil.isBlank((String)languageType)) {
            languageType = this.DEFAULT_LANGUAGE_TYPE;
        }
        if ((templateId = this.smsTemplateMapper.findByTempCodeAndAppFkId(templateCode, smsApp.getId(), languageType)) == null) {
            return BaseResponse.error((String)MessageUtils.get((String)SmsNotificationEnum.NO_TEMPLATE.name()));
        }
        SmsSendHistoryEntity sendHistory = new SmsSendHistoryEntity();
        sendHistory.setSendStatus("ing");
        sendHistory.setSendDate(DateUtils.getCurrentDateSimpleToString());
        sendHistory.setSendTime(DateUtils.getCurrentTimeToString());
        sendHistory.setSmsType("T");
        sendHistory.setTargetPhone(userPhoneNum);
        sendHistory.setTempFkId(smsApp.getId());
        sendHistory.setUserId("");
        HashMap<String, String> params2 = reqVO.getParams();
        if (params2 == null) {
            params2 = new HashMap<String, String>();
        }
        String authCode = RandomUtils.getRandom6Length();
        params2.put("code", authCode);
        params2.put("authCode", authCode);
        reqVO.setParams(params2);
        String reqParams = JSON.toJSONString((Object)reqVO);
        sendHistory.setSendParams(reqParams);
        BaseResponse rspBlackList = this.smsBlackListHandle(reqVO, sendHistory, authCode);
        if (rspBlackList != null) {
            return rspBlackList;
        }
        log.info("send sms param =" + smsApp.getAppSdkId() + "," + smsApp.getAppKey() + "," + signName + "," + params2 + "," + templateId + "," + userPhoneNum);
        AliSmsSendResponseBO aliRspBO = AliSmsSendUtils.sendSms((String)smsApp.getAppSdkId(), (String)smsApp.getAppKey(), (String)signName, params2, (String)templateId, (String)userPhoneNum);
        if (aliRspBO != null) {
            boolean flag = "OK".equals(aliRspBO.getCode());
            if (flag) {
                sendHistory.setSendStatus("SUCCESS");
                log.info("getEffTime\u503c\uff1a{}", (Object)reqVO.getEffTime());
                this.redisTemplate.opsForValue().set((Object)aliRspBO.getBizId(), (Object)authCode, reqVO.getEffTime(), TimeUnit.MILLISECONDS);
                log.info("save redis expired time =" + reqVO.getEffTime());
            } else {
                sendHistory.setSendStatus("FAIL");
            }
            sendHistory.setTxErrCode(aliRspBO.getCode());
            sendHistory.setTxErrMsg(aliRspBO.getMessage());
            sendHistory.setAliBizId(aliRspBO.getBizId());
            sendHistory.setTxSid(aliRspBO.getBizId());
            sendHistory.setAliRequestId(aliRspBO.getRequestId());
            if (!flag) {
                if ("isv.BUSINESS_LIMIT_CONTROL".equals(aliRspBO.getCode())) {
                    return BaseResponse.error((String)MessageUtils.get((String)SmsNotificationEnum.MORE_SMS_VERIFICATION_TIME.name()));
                }
                return BaseResponse.error((String)aliRspBO.getMessage());
            }
            this.smsSendHistoryMapper.insertSelective(sendHistory);
            SmsSendAuthCodeRsp rsp = new SmsSendAuthCodeRsp();
            rsp.setAuthKey(aliRspBO.getBizId());
            rsp.setEffTime(reqVO.getEffTime());
            return BaseResponse.success((Object)rsp);
        }
        sendHistory.setSendStatus("EXCEPTION");
        this.smsSendHistoryMapper.insertSelective(sendHistory);
        return BaseResponse.error((String)MessageUtils.get((String)SmsNotificationEnum.INTERNAL_ERROR.name()));
    }

    public BaseResponse<SmsSendAuthCodeRsp> sendAuthCodeWithPhoneV2(AliSmsSendAuthCodeReqPhoneVO reqVO) {
        return this.sendCommonSms(reqVO);
    }

    private BaseResponse<SmsSendAuthCodeRsp> smsBlackListHandle(AliSmsSendAuthCodeReqPhoneVO reqVO, SmsSendHistoryEntity sendHistory, String authCode) {
        String phone = this.smsBlackPhoneListMapper.selectOne(reqVO.getPhone());
        if (phone != null) {
            String bizId = UUIDUtils.getUUID();
            this.redisTemplate.opsForValue().set((Object)bizId, (Object)authCode, reqVO.getEffTime(), TimeUnit.MILLISECONDS);
            sendHistory.setAliBizId(bizId);
            sendHistory.setTxSid(bizId);
            this.smsSendHistoryMapper.insertSelective(sendHistory);
            SmsSendAuthCodeRsp rsp = new SmsSendAuthCodeRsp();
            rsp.setAuthKey(bizId);
            rsp.setEffTime(reqVO.getEffTime());
            return BaseResponse.success((Object)rsp);
        }
        return null;
    }
}

