/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.sms.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.push.miniapp.wechat.dao.WxPushApplicationMapper;
import com.ebaiyihui.push.miniapp.wechat.pojo.entity.SubMsgApp;
import com.ebaiyihui.push.pojo.sms.SmsVerifiAuthCodeReqVO;
import com.ebaiyihui.push.sms.dao.SmsApplicationMapper;
import com.ebaiyihui.push.sms.dao.SmsApplicationSmsTemplateMergeMapper;
import com.ebaiyihui.push.sms.dao.SmsBlackPhoneListMapper;
import com.ebaiyihui.push.sms.dao.SmsSendHistoryMapper;
import com.ebaiyihui.push.sms.dao.SmsTemplateMapper;
import com.ebaiyihui.push.sms.enums.SmsNotificationEnum;
import com.ebaiyihui.push.sms.pojo.BlackListTypeEnum;
import com.ebaiyihui.push.sms.pojo.entity.SmsApplicationEntity;
import com.ebaiyihui.push.sms.pojo.entity.SmsApplicationSmsTemplateMerge;
import com.ebaiyihui.push.sms.pojo.entity.SmsSendHistoryEntity;
import com.ebaiyihui.push.sms.service.ISmsService;
import com.ebaiyihui.push.utils.MessageUtils;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ISmsServiceImpl
implements ISmsService {
    private static final Logger log = LoggerFactory.getLogger(ISmsServiceImpl.class);
    @Autowired
    private SmsSendHistoryMapper smsSendHistoryMapper;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private SmsBlackPhoneListMapper smsBlackPhoneListMapper;
    @Autowired
    private SmsApplicationMapper smsApplicationMapper;
    @Autowired
    private SmsTemplateMapper smsTemplateMapper;
    @Autowired
    private SmsApplicationSmsTemplateMergeMapper smsApplicationSmsTemplateMergeMapper;
    @Autowired
    private WxPushApplicationMapper wxPushApplicationMapper;

    public BaseResponse<?> verifySmsAuthCode(SmsVerifiAuthCodeReqVO reqVO) {
        SmsSendHistoryEntity historyEntity;
        String authCode = reqVO.getAuthCode();
        String authKey = reqVO.getAuthKey();
        if (StringUtils.isBlank((CharSequence)authKey)) {
            return BaseResponse.error((String)MessageUtils.get((String)SmsNotificationEnum.SMS_KEY_MUST.name()));
        }
        if (StringUtils.isBlank((CharSequence)authCode)) {
            return BaseResponse.error((String)MessageUtils.get((String)SmsNotificationEnum.SMS_VERIFICATION_MUST.name()));
        }
        Object redisAuthCode = this.redisTemplate.opsForValue().get((Object)authKey);
        if (redisAuthCode == null) {
            return BaseResponse.error((String)MessageUtils.get((String)SmsNotificationEnum.SMS_VERIFICATION_CODE_INVALID.name()));
        }
        String redisAuthCodeStr = String.valueOf(redisAuthCode);
        String phoneNum = reqVO.getPhoneNum();
        log.info("\u9a8c\u8bc1\u77ed\u4fe1\u9a8c\u8bc1\u7801\u65f6\u7684\u6570\u636e\u4e3a: \u9a8c\u8bc1\u7801key= {}, \u9a8c\u8bc1\u7801\u503c= {}", (Object)authKey, (Object)authCode);
        if (StringUtils.isNotBlank((CharSequence)phoneNum) && !phoneNum.equals((historyEntity = this.smsSendHistoryMapper.findByTxSid(authKey)).getTargetPhone())) {
            return BaseResponse.error((String)MessageUtils.get((String)SmsNotificationEnum.SMS_ERROR_VERIFICATION_CODE.name()));
        }
        if (!redisAuthCodeStr.equalsIgnoreCase(authCode)) {
            return BaseResponse.error((String)MessageUtils.get((String)SmsNotificationEnum.ENTER_CORRECT_VERIFICATION_CODE.name()));
        }
        String operate = reqVO.getOperate();
        if (StringUtils.isNotBlank((CharSequence)operate) && "D".equals(operate)) {
            this.redisTemplate.delete((Object)authKey);
        }
        return BaseResponse.success();
    }

    public BaseResponse<?> getAuthKey(String phone) {
        String result = this.smsSendHistoryMapper.selectAuthCodeByPhone(phone);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        String authCode = jsonObject.getJSONObject("params").getString("authCode");
        return BaseResponse.success((Object)authCode);
    }

    public BaseResponse<?> editBlackList(String phone, String type) {
        try {
            if (BlackListTypeEnum.ADD.getName().equals(type)) {
                this.smsBlackPhoneListMapper.insertOne(phone);
                return BaseResponse.success((Object)MessageUtils.get((String)SmsNotificationEnum.ADD_TO_BLACKLIST.name()));
            }
            if (BlackListTypeEnum.DELETE.getName().equals(type)) {
                this.smsBlackPhoneListMapper.deleteOne(phone);
                return BaseResponse.success((Object)MessageUtils.get((String)SmsNotificationEnum.REMOVE_BLACKLIST.name()));
            }
            if (BlackListTypeEnum.SELECT.getName().equals(type)) {
                String s = this.smsBlackPhoneListMapper.selectOne(phone);
                if (s == null) {
                    return BaseResponse.success((Object)MessageUtils.get((String)SmsNotificationEnum.NOT_ADD_BLACKLIST.name()));
                }
                return BaseResponse.success((Object)MessageUtils.get((String)SmsNotificationEnum.FINISH_ADD_BLACKLIST.name()));
            }
        }
        catch (Exception e) {
            log.error("edit blackList error,e=", (Throwable)e);
        }
        return BaseResponse.error((String)MessageUtils.get((String)SmsNotificationEnum.OPERATION_FAILED.name()));
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public BaseResponse<?> configSms(String appCode, String name, String appid, String secret) {
        log.info("\u65b0\u589e\u5e73\u53f0\u7684appCode = {},\u5e73\u53f0\u540d= {}", (Object)appCode, (Object)name);
        SmsApplicationEntity smsApplicationEntity = new SmsApplicationEntity();
        smsApplicationEntity.setAppKey("GTKrBOaSbIEaaPBEJU94ETltZ08YuX");
        smsApplicationEntity.setAppSdkId("LTAI4FwMYWcJsdYRTJEuSbya");
        smsApplicationEntity.setAppSdkType("ali");
        smsApplicationEntity.setClientCode("EHOS_" + appCode);
        smsApplicationEntity.setClientName(name);
        smsApplicationEntity.setAppCode(appCode);
        this.smsApplicationMapper.insert(smsApplicationEntity);
        SmsApplicationEntity smsApplication = this.smsApplicationMapper.selectByPrimaryKey(smsApplicationEntity.getId());
        log.info("\u63d2\u5165\u5e73\u53f0\u7684\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)smsApplicationEntity));
        List smsTemplateEntities = this.smsTemplateMapper.queryAll();
        List smsApplicationSmsTemplateMergeList = smsTemplateEntities.stream().map(smsTemplateEntity -> {
            SmsApplicationSmsTemplateMerge smsApplicationSmsTemplateMerge = new SmsApplicationSmsTemplateMerge();
            smsApplicationSmsTemplateMerge.setApplicationId(smsApplication.getId());
            smsApplicationSmsTemplateMerge.setLanguageType("CN");
            smsApplicationSmsTemplateMerge.setTemplateCode(smsTemplateEntity.getTempCode());
            smsApplicationSmsTemplateMerge.setTemplateFkId(smsTemplateEntity.getId());
            return smsApplicationSmsTemplateMerge;
        }).collect(Collectors.toList());
        this.smsApplicationSmsTemplateMergeMapper.insertBatch(smsApplicationSmsTemplateMergeList);
        SubMsgApp subMsgApp = new SubMsgApp();
        subMsgApp.setEnabled(Short.valueOf((short)1));
        subMsgApp.setGrantType("client_credential");
        subMsgApp.setAppId(appid);
        subMsgApp.setSecret(secret);
        subMsgApp.setClientCode("WX_" + appCode);
        subMsgApp.setClientName(name);
        this.wxPushApplicationMapper.insert(subMsgApp);
        return BaseResponse.success();
    }

    public BaseResponse<?> deleteAppCode(String appCode) {
        log.info("\u5220\u9664\u5e73\u53f0\u7684appcode\uff1a{}", (Object)appCode);
        SmsApplicationEntity smsApplicationEntity = this.smsApplicationMapper.selectOneByAppcode(appCode);
        if (Objects.nonNull(smsApplicationEntity)) {
            this.smsApplicationMapper.deleteById(smsApplicationEntity.getId());
            this.smsApplicationSmsTemplateMergeMapper.deleteByApplicationId(smsApplicationEntity.getId());
        }
        return BaseResponse.success();
    }
}

