/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.framework.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TimeUtil {
    public static LinkedHashMap<String, Object> getDatesBetweenTwoDate(Date startDate, Date endDate, Object value) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        LinkedHashMap<String, Object> dateMap = new LinkedHashMap<String, Object>();
        dateMap.put(sdf.format(startDate), value);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        while (true) {
            calendar.add(5, 1);
            if (!endDate.after(calendar.getTime())) break;
            dateMap.put(sdf.format(calendar.getTime()), value);
        }
        dateMap.put(sdf.format(endDate), value);
        return dateMap;
    }

    public static List<Map<String, Object>> getDateBetweenTwoDate(String key, Date startDate, Date endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<Map<String, Object>> dateList = new ArrayList<Map<String, Object>>();
        HashMap<String, String> startMap = new HashMap<String, String>();
        startMap.put(key, sdf.format(startDate));
        dateList.add(startMap);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        while (true) {
            calendar.add(5, 1);
            if (!endDate.after(calendar.getTime())) break;
            HashMap<String, String> dateMap = new HashMap<String, String>();
            dateMap.put(key, sdf.format(calendar.getTime()));
            dateList.add(dateMap);
        }
        HashMap<String, String> endMap = new HashMap<String, String>();
        endMap.put(key, sdf.format(endDate));
        dateList.add(endMap);
        return dateList;
    }

    public static LocalDate DateToLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate localDate = instant.atZone(zoneId).toLocalDate();
        return localDate;
    }

    public static Date LocalDateToDate(LocalDate localDate) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDate.atStartOfDay(zoneId);
        Date date = Date.from(zdt.toInstant());
        return date;
    }

    public static LocalDate stringToLocalDate(String str) {
        LocalDate localDate = LocalDate.parse(str, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        return localDate;
    }

    public static Date stringToDate(String string) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = null;
        try {
            date = sdf.parse(string);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String dateToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String str = sdf.format(date);
        return str;
    }

    public static String dateToString(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String str = sdf.format(date);
        return str;
    }

    public static Date formartStringToDate(String format, String dateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String getTwoDay(String dateString, String TwoDay) {
        SimpleDateFormat myFormatter = new SimpleDateFormat("yyyy-MM-dd");
        long day = 0L;
        try {
            Date date = myFormatter.parse(TwoDay);
            Date mydate = myFormatter.parse(dateString);
            day = (date.getTime() - mydate.getTime()) / 86400000L;
        }
        catch (Exception e) {
            return "";
        }
        return day + "";
    }

    public static Integer dateToWeek(String datetime) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        Integer[] weekDays = new Integer[]{0, 1, 2, 3, 4, 5, 6};
        Calendar cal = Calendar.getInstance();
        Date datet = null;
        try {
            datet = f.parse(datetime);
            cal.setTime(datet);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static boolean inSameDay(Date date1, Date Date2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date1);
        int year1 = calendar.get(1);
        int day1 = calendar.get(6);
        calendar.setTime(Date2);
        int year2 = calendar.get(1);
        int day2 = calendar.get(6);
        return year1 == year2 && day1 == day2;
    }

    public static String translateScheduleStr(String str) {
        StringBuilder stringBuilder = new StringBuilder();
        if (str.equals("")) {
            return "";
        }
        String[] spl = str.split(",");
        for (int i = 0; i < spl.length; ++i) {
            String[] split = spl[i].split("#");
            if (split[0].equals("0")) continue;
            switch (split[0]) {
                case "1": {
                    stringBuilder.append("\u5468\u4e00");
                    break;
                }
                case "2": {
                    stringBuilder.append("\u5468\u4e8c");
                    break;
                }
                case "3": {
                    stringBuilder.append("\u5468\u4e09");
                    break;
                }
                case "4": {
                    stringBuilder.append("\u5468\u56db");
                    break;
                }
                case "5": {
                    stringBuilder.append("\u5468\u4e94");
                    break;
                }
                case "6": {
                    stringBuilder.append("\u5468\u516d");
                    break;
                }
                case "7": {
                    stringBuilder.append("\u5468\u65e5");
                    break;
                }
                default: {
                    stringBuilder.append("");
                }
            }
            switch (split[1]) {
                case "1": {
                    stringBuilder.append("\u4e0a\u5348");
                    break;
                }
                case "2": {
                    stringBuilder.append("\u4e0b\u5348");
                    break;
                }
                default: {
                    stringBuilder.append("");
                }
            }
            if (i >= spl.length - 1) continue;
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }

    public static long getCurrentTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long getCurrentTimestampMs() {
        return System.currentTimeMillis();
    }
}

