/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.api;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.entity.NodeConfigurationEntity;
import com.ebaiyihui.service.entity.PlatformInfoEntity;
import com.ebaiyihui.service.service.PlatformInfoService;
import com.ebaiyihui.service.vo.ConfigurationFileVo;
import com.ebaiyihui.service.vo.ConfigurationSealingPlateVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/preparation"})
@Api(tags={"\u63d0\u4f9b\u6570\u636e\u641c\u7d22API"})
public class PreparationController {
    private static final Logger log = LoggerFactory.getLogger(PreparationController.class);
    @Autowired
    private PlatformInfoService platformInfoService;

    @ApiOperation(value="\u5e73\u53f0\u4fe1\u606f\u641c\u7d22")
    @RequestMapping(value={"/getListByPlatform"}, method={RequestMethod.GET})
    public BaseResponse<List<PlatformInfoEntity>> getListByPlatform() {
        return this.platformInfoService.getListByPlatform();
    }

    @ApiOperation(value="\u8282\u70b9\u4fe1\u606f\u641c\u7d22")
    @RequestMapping(value={"/getListByNodeConfiguration"}, method={RequestMethod.GET})
    public BaseResponse<List<NodeConfigurationEntity>> getListByNodeConfiguration() {
        return this.platformInfoService.getListByNodeConfiguration();
    }

    @ApiOperation(value="\u6240\u9700\u8981\u4e91\u7aef+\u8282\u70b9\u670d\u52a1\u4fe1\u606f\u641c\u7d22")
    @RequestMapping(value={"/getListConfiguration"}, method={RequestMethod.GET})
    public BaseResponse<List<ConfigurationFileVo>> getListConfiguration(@RequestParam Long nodeId, Long platformId) {
        return this.platformInfoService.getListConfiguration(nodeId, platformId);
    }

    @ApiOperation(value="\u6240\u9700\u8981\u4e91\u7aef\u670d\u52a1\u4fe1\u606f\u641c\u7d22")
    @RequestMapping(value={"/getListNodeByConfiguration"}, method={RequestMethod.GET})
    public BaseResponse<List<ConfigurationFileVo>> getListNodeByConfiguration(@RequestParam Long nodeId) {
        return this.platformInfoService.getListNodeByConfiguration(nodeId);
    }

    @ApiOperation(value="\u67e5\u8be2\u540e\u7aef\u670d\u52a1\u6570\u636e")
    @RequestMapping(value={"/getListConfigurationFile"}, method={RequestMethod.GET})
    public BaseResponse<List<ConfigurationSealingPlateVo>> getListConfigurationFile(@RequestParam Integer status) {
        return this.platformInfoService.getListConfigurationFile(status);
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u5c5e\u5e73\u53f0\u4fe1\u606f")
    @RequestMapping(value={"/informationPlatform"}, method={RequestMethod.GET})
    public BaseResponse<Object> informationPlatform(@RequestParam String vueType, String appCode) {
        return this.platformInfoService.informationPlatform(vueType, appCode);
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u5c5e\u8282\u70b9\u4fe1\u606f")
    @RequestMapping(value={"/subordinateNode"}, method={RequestMethod.GET})
    public BaseResponse<List<NodeConfigurationEntity>> subordinateNode(@RequestParam String vueType) {
        return this.platformInfoService.subordinateNode(vueType);
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u5c5e\u5e73\u53f0\u4e0b\u533b\u9662\u4fe1\u606f")
    @RequestMapping(value={"/subordinateOrganName"}, method={RequestMethod.GET})
    public BaseResponse<Object> subordinateOrganName(@RequestParam String organName, @RequestParam Integer type) {
        return this.platformInfoService.subordinateOrganName(organName, type);
    }
}

