/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.constant.ConfigurationConstant;
import com.ebaiyihui.service.constant.enums.DomainNameEnum;
import com.ebaiyihui.service.entity.ConfigurationFileEntity;
import com.ebaiyihui.service.entity.JobServerIpEntity;
import com.ebaiyihui.service.entity.NodeConfigurationEntity;
import com.ebaiyihui.service.entity.PlatformInfoEntity;
import com.ebaiyihui.service.entity.PlatformOutreachEntity;
import com.ebaiyihui.service.entity.VersionHistoryEntity;
import com.ebaiyihui.service.mapper.ConfigurationFileMapper;
import com.ebaiyihui.service.mapper.JobServerIpMapper;
import com.ebaiyihui.service.mapper.NodeConfigurationMapper;
import com.ebaiyihui.service.mapper.PlatformInfoMapper;
import com.ebaiyihui.service.mapper.PlatformOutreachMapper;
import com.ebaiyihui.service.mapper.VersionHistoryMapper;
import com.ebaiyihui.service.service.FrontEndService;
import com.ebaiyihui.service.service.JobService;
import com.ebaiyihui.service.vo.AddFrontEndVo;
import com.ebaiyihui.service.vo.GetListBySearchAndFrontEndVo;
import com.ebaiyihui.service.vo.VersionHistoryVO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FrontEndServiceImpl
implements FrontEndService {
    private static final Logger log = LoggerFactory.getLogger(FrontEndServiceImpl.class);
    @Autowired
    private ConfigurationFileMapper configurationFileMapper;
    @Autowired
    private JobServerIpMapper jobServerIpMapper;
    @Autowired
    private VersionHistoryMapper versionHistoryMapper;
    @Autowired
    private NodeConfigurationMapper nodeConfigurationMapper;
    @Autowired
    private PlatformOutreachMapper platformOutreachMapper;
    @Autowired
    private PlatformInfoMapper platformInfoMapper;
    @Autowired
    private JobService jobService;

    public BaseResponse<List<GetListBySearchAndFrontEndVo>> getListBySearch(String searchParam) {
        ArrayList<GetListBySearchAndFrontEndVo> getListBySearchAndFrontEndVos = new ArrayList<GetListBySearchAndFrontEndVo>();
        List ConfigurationFileVo2 = this.configurationFileMapper.getListByStatus(ConfigurationConstant.TYPE_TEN, searchParam);
        for (ConfigurationFileEntity ConfigurationFile : ConfigurationFileVo2) {
            JobServerIpEntity byNodeIdAndFileId = this.jobServerIpMapper.getByNodeIdAndFileId(Long.valueOf(ConfigurationConstant.TYPE_TEN.intValue()), ConfigurationFile.getId());
            GetListBySearchAndFrontEndVo getListBySearchAndFrontEndVo = new GetListBySearchAndFrontEndVo();
            getListBySearchAndFrontEndVo.setCreateTime(byNodeIdAndFileId.getCreateTime());
            getListBySearchAndFrontEndVo.setUpdateTime(byNodeIdAndFileId.getUpdateTime());
            getListBySearchAndFrontEndVo.setChineseNameService(ConfigurationFile.getChineseNameService());
            getListBySearchAndFrontEndVo.setServiceName(ConfigurationFile.getProjectName());
            getListBySearchAndFrontEndVo.setServerIp(byNodeIdAndFileId.getServerIp());
            getListBySearchAndFrontEndVo.setTagsNumber(byNodeIdAndFileId.getTagsNumber());
            getListBySearchAndFrontEndVo.setPackagingOrders(ConfigurationFile.getBuildConfigurationPro());
            getListBySearchAndFrontEndVo.setJobServerId(byNodeIdAndFileId.getId());
            getListBySearchAndFrontEndVo.setStatus(byNodeIdAndFileId.getStatus());
            getListBySearchAndFrontEndVo.setFileId(ConfigurationFile.getId());
            getListBySearchAndFrontEndVo.setGitAddress(ConfigurationFile.getGitAddress());
            getListBySearchAndFrontEndVo.setVueType(ConfigurationFile.getDockerFilePro());
            PlatformOutreachEntity nodeIdAndFileId = this.platformOutreachMapper.getNodeIdAndFileId(Long.valueOf(ConfigurationConstant.TYPE_TEN.intValue()), ConfigurationFile.getId(), null);
            if (nodeIdAndFileId != null) {
                getListBySearchAndFrontEndVo.setPlatformId(nodeIdAndFileId.getPlatformId());
            }
            getListBySearchAndFrontEndVos.add(getListBySearchAndFrontEndVo);
        }
        return BaseResponse.success(getListBySearchAndFrontEndVos);
    }

    public BaseResponse<String> add(AddFrontEndVo addFrontEndVo) {
        ConfigurationFileEntity configurationFileEntity = new ConfigurationFileEntity();
        configurationFileEntity.setGitAddress(addFrontEndVo.getGitAddress());
        configurationFileEntity.setChineseNameService(addFrontEndVo.getChineseNameService());
        configurationFileEntity.setServiceName(addFrontEndVo.getServiceName());
        configurationFileEntity.setBuildConfigurationPro(addFrontEndVo.getPackagingOrders());
        configurationFileEntity.setStatus(ConfigurationConstant.TYPE_TEN);
        configurationFileEntity.setProjectName(addFrontEndVo.getServiceName());
        configurationFileEntity.setDockerFilePro(addFrontEndVo.getVueType());
        log.info(" \u6dfb\u52a0===>{}", (Object)JSON.toJSONString((Object)configurationFileEntity));
        this.configurationFileMapper.insert(configurationFileEntity);
        Long fileId = configurationFileEntity.getId();
        JobServerIpEntity jobServerIpEntity = new JobServerIpEntity();
        jobServerIpEntity.setChineseNameService(addFrontEndVo.getChineseNameService());
        jobServerIpEntity.setServiceName(addFrontEndVo.getServiceName());
        jobServerIpEntity.setNodeId(Long.valueOf(ConfigurationConstant.TYPE_TEN.intValue()));
        jobServerIpEntity.setNodeName("\u524d\u7aef");
        jobServerIpEntity.setFileId(fileId);
        jobServerIpEntity.setServerIp(addFrontEndVo.getServerIp());
        jobServerIpEntity.setTagsNumber(addFrontEndVo.getTagsNumber());
        jobServerIpEntity.setStatus(ConfigurationConstant.STATUS_INVALID);
        log.info(" \u6dfb\u52a0===>{}", (Object)JSON.toJSONString((Object)jobServerIpEntity));
        this.jobServerIpMapper.insert(jobServerIpEntity);
        Integer nameValueEnum = DomainNameEnum.domainNameValueEnum((String)addFrontEndVo.getVueType());
        PlatformInfoEntity codeAndType = this.platformInfoMapper.getByCodeAndType(addFrontEndVo.getAppCode(), nameValueEnum);
        PlatformInfoEntity platformInfoEntity = new PlatformInfoEntity();
        if (codeAndType == null) {
            platformInfoEntity.setNodeId(addFrontEndVo.getNodeId());
            platformInfoEntity.setPlatformCode(addFrontEndVo.getAppCode());
            platformInfoEntity.setPlatformName(addFrontEndVo.getHospitalName());
            platformInfoEntity.setType(nameValueEnum);
            this.platformInfoMapper.insert(platformInfoEntity);
        }
        PlatformOutreachEntity platformOutreachEntity = new PlatformOutreachEntity();
        platformOutreachEntity.setNodeId(Long.valueOf(ConfigurationConstant.TYPE_TEN.intValue()));
        platformOutreachEntity.setNodeName("\u524d\u7aef");
        platformOutreachEntity.setPlatformName(platformInfoEntity.getPlatformName());
        platformOutreachEntity.setPlatformId(platformInfoEntity.getId());
        platformOutreachEntity.setFileId(configurationFileEntity.getId());
        platformOutreachEntity.setChineseNameService(addFrontEndVo.getChineseNameService());
        platformOutreachEntity.setServiceName(addFrontEndVo.getServiceName());
        platformOutreachEntity.setStatus(ConfigurationConstant.STATUS_VALID);
        this.platformOutreachMapper.insert(platformOutreachEntity);
        VersionHistoryEntity versionHistoryEntity = new VersionHistoryEntity();
        versionHistoryEntity.setChineseNameService(addFrontEndVo.getChineseNameService());
        versionHistoryEntity.setServiceName(addFrontEndVo.getServiceName());
        versionHistoryEntity.setFileId(fileId);
        versionHistoryEntity.setTagsNumber(addFrontEndVo.getTagsNumber());
        List byPlatformIdAndNodeId = this.jobServerIpMapper.getByPlatformIdAndNodeId(addFrontEndVo.getNodeId());
        String jsonString = JSON.toJSONString((Object)byPlatformIdAndNodeId);
        versionHistoryEntity.setVersionHistoryJson(jsonString);
        versionHistoryEntity.setNodeId(addFrontEndVo.getNodeId());
        log.info(" \u6dfb\u52a0===>{}", (Object)JSON.toJSONString((Object)versionHistoryEntity));
        this.versionHistoryMapper.insert(versionHistoryEntity);
        BaseResponse jobFrontEnd = this.jobService.saveJobFrontEnd(jobServerIpEntity, fileId);
        if (jobFrontEnd.getCode().equals(0)) {
            return BaseResponse.error((String)"job\u4efb\u52a1\u521b\u5efa\u5931\u8d25");
        }
        return BaseResponse.success((Object)fileId.toString());
    }

    public BaseResponse<String> update(AddFrontEndVo addFrontEndVo) {
        ConfigurationFileEntity configurationFileEntity = new ConfigurationFileEntity();
        configurationFileEntity.setGitAddress(addFrontEndVo.getGitAddress());
        configurationFileEntity.setChineseNameService(addFrontEndVo.getChineseNameService());
        configurationFileEntity.setBuildConfigurationPro(addFrontEndVo.getPackagingOrders());
        configurationFileEntity.setProjectName(addFrontEndVo.getServiceName());
        log.info(" \u4fee\u6539===>{}", (Object)JSON.toJSONString((Object)configurationFileEntity));
        configurationFileEntity.setId(addFrontEndVo.getFileId());
        int insert = this.configurationFileMapper.update(configurationFileEntity);
        JobServerIpEntity byPlatformIdAndNodeIdAndFileId = this.jobServerIpMapper.getById(addFrontEndVo.getJobServerId());
        byPlatformIdAndNodeIdAndFileId.setChineseNameService(addFrontEndVo.getChineseNameService());
        byPlatformIdAndNodeIdAndFileId.setServerIp(addFrontEndVo.getServerIp());
        byPlatformIdAndNodeIdAndFileId.setTagsNumber(addFrontEndVo.getTagsNumber());
        byPlatformIdAndNodeIdAndFileId.setId(byPlatformIdAndNodeIdAndFileId.getId());
        log.info(" \u4fee\u6539===>{}", (Object)JSON.toJSONString((Object)byPlatformIdAndNodeIdAndFileId));
        this.jobServerIpMapper.update(byPlatformIdAndNodeIdAndFileId);
        PlatformOutreachEntity nodeIdAndFileId = this.platformOutreachMapper.getNodeIdAndFileId(Long.valueOf(ConfigurationConstant.TYPE_TEN.intValue()), addFrontEndVo.getFileId(), addFrontEndVo.getPlatformId());
        PlatformOutreachEntity platformOutreachEntity = new PlatformOutreachEntity();
        platformOutreachEntity.setId(nodeIdAndFileId.getId());
        platformOutreachEntity.setChineseNameService(addFrontEndVo.getChineseNameService());
        platformOutreachEntity.setServiceName(addFrontEndVo.getServiceName());
        this.platformOutreachMapper.update(platformOutreachEntity);
        VersionHistoryEntity versionHistoryEntity = new VersionHistoryEntity();
        versionHistoryEntity.setServiceName(addFrontEndVo.getServiceName());
        versionHistoryEntity.setChineseNameService(addFrontEndVo.getChineseNameService());
        log.info(" \u4fee\u6539===>{}", (Object)JSON.toJSONString((Object)versionHistoryEntity));
        this.versionHistoryMapper.update(versionHistoryEntity);
        BaseResponse jobFrontEnd = this.jobService.saveJobFrontEnd(byPlatformIdAndNodeIdAndFileId, addFrontEndVo.getFileId());
        if (jobFrontEnd.getCode().equals(0)) {
            return BaseResponse.error((String)"job\u4efb\u52a1\u4fee\u6539\u5931\u8d25");
        }
        return BaseResponse.success();
    }

    public BaseResponse<String> deployment(Long jobServerId) {
        ConfigurationFileEntity configurationFileEntity;
        NodeConfigurationEntity nodeConfigurationEntity;
        JobServerIpEntity jobServerIpEntity = this.jobServerIpMapper.getById(jobServerId);
        BaseResponse stringBaseResponse = this.jobService.deploymentFrontEnd(jobServerIpEntity, nodeConfigurationEntity = this.nodeConfigurationMapper.getById(jobServerIpEntity.getNodeId()), configurationFileEntity = this.configurationFileMapper.getById(jobServerIpEntity.getFileId()));
        if (stringBaseResponse.getCode().equals(0)) {
            return BaseResponse.error((String)"job\u4efb\u52a1\u90e8\u7f72\u5931\u8d25");
        }
        this.jobServerIpMapper.updateByIdAndStatus(jobServerId, ConfigurationConstant.STATUS_VALID);
        return BaseResponse.success();
    }

    public BaseResponse<List<VersionHistoryEntity>> getListByVersionHistory(Long fileId) {
        List historyEntities = this.versionHistoryMapper.getByFileId(fileId);
        log.info(" ===\u67e5\u8be2\u5386\u53f2\u7248\u672c===>{}", (Object)JSON.toJSONString((Object)historyEntities));
        return BaseResponse.success((Object)historyEntities);
    }

    public BaseResponse<String> addVersionHistory(VersionHistoryVO addVersionHistoryVO) {
        JobServerIpEntity jobServerIpEntity = this.jobServerIpMapper.getById(addVersionHistoryVO.getJobServerId());
        jobServerIpEntity.setTagsNumber(addVersionHistoryVO.getTagsNumber());
        jobServerIpEntity.setStatus(ConfigurationConstant.STATUS_INVALID);
        log.info("====\u4fee\u6539jobServerIpMapper===>{}", (Object)JSON.toJSONString((Object)jobServerIpEntity));
        this.jobServerIpMapper.update(jobServerIpEntity);
        VersionHistoryEntity versionHistoryEntity = new VersionHistoryEntity();
        List byPlatformId = this.platformOutreachMapper.getByPlatformId(addVersionHistoryVO.getPlatformId());
        Integer nodeId = 0;
        for (PlatformOutreachEntity platformOutreach : byPlatformId) {
            if (platformOutreach.getNodeId().intValue() == ConfigurationConstant.TYPE_TEN.intValue()) continue;
            nodeId = platformOutreach.getNodeId().intValue();
        }
        List byPlatformIdAndNodeId = this.jobServerIpMapper.getByPlatformIdAndNodeId(Long.valueOf(nodeId.longValue()));
        versionHistoryEntity.setVersionHistoryJson(JSON.toJSONString((Object)byPlatformIdAndNodeId));
        versionHistoryEntity.setTagsNumber(addVersionHistoryVO.getTagsNumber());
        versionHistoryEntity.setChineseNameService(addVersionHistoryVO.getChineseNameService());
        versionHistoryEntity.setServiceName(addVersionHistoryVO.getServiceName());
        versionHistoryEntity.setFileId(addVersionHistoryVO.getFileId());
        log.info(" \u6dfb\u52a0===>{}", (Object)JSON.toJSONString((Object)versionHistoryEntity));
        this.versionHistoryMapper.insert(versionHistoryEntity);
        return BaseResponse.success();
    }
}

