/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.constant.ConfigurationConstant;
import com.ebaiyihui.service.constant.JenkinsConnect;
import com.ebaiyihui.service.entity.ConfigurationFileEntity;
import com.ebaiyihui.service.entity.InitializeInfoEntity;
import com.ebaiyihui.service.entity.JobServerIpEntity;
import com.ebaiyihui.service.entity.NodeConfigurationEntity;
import com.ebaiyihui.service.mapper.ConfigurationFileMapper;
import com.ebaiyihui.service.mapper.JobServerIpMapper;
import com.ebaiyihui.service.mapper.NodeConfigurationMapper;
import com.ebaiyihui.service.service.JobService;
import com.ebaiyihui.service.utils.XmlTemplateKit;
import com.ebaiyihui.service.vo.ConfigXmlVo;
import com.ebaiyihui.service.vo.TemplateVo;
import com.offbytwo.jenkins.JenkinsServer;
import com.offbytwo.jenkins.model.BuildWithDetails;
import com.offbytwo.jenkins.model.Job;
import com.offbytwo.jenkins.model.JobWithDetails;
import com.offbytwo.jenkins.model.MavenJobWithDetails;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JobServiceImpl
implements JobService {
    private static final Logger log = LoggerFactory.getLogger(JobServiceImpl.class);
    @Autowired
    private NodeConfigurationMapper nodeConfigurationMapper;
    @Autowired
    private JobServerIpMapper jobServerIpMapper;
    @Autowired
    private ConfigurationFileMapper configurationFileMapper;
    private JenkinsServer jenkinsServer;

    public BaseResponse<String> saveJobFrontEnd(JobServerIpEntity jobServerIpEntity, Long fileId) {
        NodeConfigurationEntity nodeConfigurationEntity = this.nodeConfigurationMapper.getById(Long.valueOf(ConfigurationConstant.TYPE_TEN.longValue()));
        ConfigurationFileEntity configurationFileEntity = this.configurationFileMapper.getById(fileId);
        this.JenkinsConnect(nodeConfigurationEntity.getDeploymentType(), configurationFileEntity.getDockerFilePro());
        HashMap<String, ConfigXmlVo> map = new HashMap<String, ConfigXmlVo>();
        ConfigXmlVo configXmlVo = new ConfigXmlVo();
        configXmlVo.setGitAddress(configurationFileEntity.getGitAddress());
        configXmlVo.setChineseNameService(configurationFileEntity.getChineseNameService() + "\u5e73\u53f0" + "\n" + configurationFileEntity.getProjectName() + ".chinachdu.com");
        configXmlVo.setServerIp(jobServerIpEntity.getServerIp());
        configXmlVo.setBuildConfiguration(configurationFileEntity.getBuildConfigurationPro());
        configXmlVo.setPlatformCode(configurationFileEntity.getProjectName());
        configXmlVo.setProjectName("admin_" + configurationFileEntity.getProjectName() + "_" + configurationFileEntity.getDockerFilePro());
        log.info("ConfigXmlVo==>{}", (Object)JSON.toJSONString((Object)configXmlVo));
        map.put("configXmlVo", configXmlVo);
        String vueProXml = XmlTemplateKit.process((String)"vue_pro", map);
        if (StringUtils.isEmpty((CharSequence)vueProXml)) {
            return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        String mavenJobName = this.getMavenJob(configXmlVo.getProjectName());
        if (null == mavenJobName) {
            this.ceateJob(configXmlVo.getProjectName(), vueProXml);
        }
        if (null != mavenJobName) {
            this.updateJob(configXmlVo.getProjectName(), vueProXml);
        }
        return BaseResponse.success();
    }

    public BaseResponse<String> deploymentFrontEnd(JobServerIpEntity jobServerIpEntity, NodeConfigurationEntity nodeConfigurationEntity, ConfigurationFileEntity configurationFileEntity) {
        this.JenkinsConnect(nodeConfigurationEntity.getDeploymentType(), configurationFileEntity.getDockerFilePro());
        this.buildParamJob("admin_" + configurationFileEntity.getProjectName() + "_" + configurationFileEntity.getDockerFilePro(), "origin/" + jobServerIpEntity.getTagsNumber());
        return BaseResponse.success();
    }

    public BaseResponse<String> insertJobNode(NodeConfigurationEntity nodeConfigurationEntity, List<ConfigurationFileEntity> configurationFileEntity) {
        this.JenkinsConnect(nodeConfigurationEntity.getDeploymentType(), nodeConfigurationEntity.getViewName());
        for (ConfigurationFileEntity configurationFile : configurationFileEntity) {
            String mavenJobName;
            JobServerIpEntity byNodeIdAndFileId = this.jobServerIpMapper.getByNodeIdAndFileId(nodeConfigurationEntity.getId(), configurationFile.getId());
            if (byNodeIdAndFileId == null) continue;
            HashMap<String, ConfigXmlVo> map = new HashMap<String, ConfigXmlVo>();
            ConfigXmlVo configXmlVo = new ConfigXmlVo();
            configXmlVo.setGitAddress(configurationFile.getGitAddress());
            if (nodeConfigurationEntity.getStatus().toString().equals(ConfigurationConstant.TYPE_ONE.toString()) || nodeConfigurationEntity.getStatus().toString().equals(ConfigurationConstant.TYPE_TWO.toString())) {
                configXmlVo.setBuildConfiguration(configurationFile.getBuildConfigurationTest());
                configXmlVo.setDockerFile(configurationFile.getDockerFileTest());
                configXmlVo.setLocation("home");
            }
            if (nodeConfigurationEntity.getStatus().toString().equals(ConfigurationConstant.TYPE_THREE.toString()) || nodeConfigurationEntity.getStatus().toString().equals(ConfigurationConstant.TYPE_FOUR.toString())) {
                configXmlVo.setBuildConfiguration(configurationFile.getBuildConfigurationPro());
                configXmlVo.setDockerFile(configurationFile.getDockerFilePro());
                configXmlVo.setLocation("root");
            }
            configXmlVo.setProfile(nodeConfigurationEntity.getProfile());
            configXmlVo.setServerIp(byNodeIdAndFileId.getServerIp());
            configXmlVo.setExtraHosts(nodeConfigurationEntity.getExtraHosts());
            configXmlVo.setLabel(nodeConfigurationEntity.getLabel());
            configXmlVo.setPort(configurationFile.getPort());
            configXmlVo.setProjectName(configurationFile.getProjectName() + nodeConfigurationEntity.getView());
            configXmlVo.setServiceName(configurationFile.getServiceName());
            log.info("ConfigXmlVo==>{}", (Object)JSON.toJSONString((Object)configXmlVo));
            map.put("configXmlVo", configXmlVo);
            BaseResponse template = this.template(map, nodeConfigurationEntity.getDeploymentType(), nodeConfigurationEntity.getStatus(), configurationFile.getProjectName());
            TemplateVo templateData = (TemplateVo)template.getData();
            if (configurationFile.getProjectName().equals("byh-eureka-server")) {
                mavenJobName = this.getMavenJob(configXmlVo.getProjectName());
                if (null != mavenJobName) continue;
                this.ceateJob(configXmlVo.getProjectName(), templateData.getEurekaXml());
                continue;
            }
            if (configurationFile.getProjectName().equals("byh-config-service")) {
                mavenJobName = this.getMavenJob(configXmlVo.getProjectName());
                if (null != mavenJobName) continue;
                this.ceateJob(configXmlVo.getProjectName(), templateData.getConfigServiceXml());
                continue;
            }
            mavenJobName = this.getMavenJob(configXmlVo.getProjectName());
            if (null != mavenJobName) continue;
            this.ceateJob(configXmlVo.getProjectName(), templateData.getRequestHisXml());
        }
        return BaseResponse.success();
    }

    public BaseResponse<String> uodateJobNode(NodeConfigurationEntity nodeConfigurationEntity) {
        NodeConfigurationEntity configurationMapperById = this.nodeConfigurationMapper.getById(nodeConfigurationEntity.getId());
        this.JenkinsConnect(configurationMapperById.getDeploymentType(), configurationMapperById.getViewName());
        Integer status = 0;
        status = configurationMapperById.getStatus().toString().equals(ConfigurationConstant.TYPE_ONE.toString()) ? ConfigurationConstant.TYPE_THREE : (configurationMapperById.getStatus().toString().equals(ConfigurationConstant.TYPE_TWO.toString()) ? ConfigurationConstant.TYPE_FOUR : configurationMapperById.getStatus());
        List listByStatus = this.configurationFileMapper.getListByStatus(status, null);
        List listByType = this.configurationFileMapper.getListByType(Integer.valueOf(nodeConfigurationEntity.getId().intValue()));
        listByStatus.addAll(listByType);
        for (ConfigurationFileEntity configurationFile : listByStatus) {
            JobServerIpEntity byNodeIdAndFileId = this.jobServerIpMapper.getByNodeIdAndFileId(nodeConfigurationEntity.getId(), configurationFile.getId());
            if (byNodeIdAndFileId == null) continue;
            HashMap<String, ConfigXmlVo> map = new HashMap<String, ConfigXmlVo>();
            ConfigXmlVo configXmlVo = new ConfigXmlVo();
            configXmlVo.setExtraHosts(nodeConfigurationEntity.getExtraHosts());
            configXmlVo.setLabel(nodeConfigurationEntity.getLabel());
            configXmlVo.setPort(configurationFile.getPort());
            configXmlVo.setGitAddress(configurationFile.getGitAddress());
            configXmlVo.setProfile(configurationMapperById.getProfile());
            if (configurationMapperById.getStatus().toString().equals(ConfigurationConstant.TYPE_THREE.toString()) || configurationMapperById.getStatus().toString().equals(ConfigurationConstant.TYPE_FOUR.toString())) {
                configXmlVo.setBuildConfiguration(configurationFile.getBuildConfigurationPro());
                configXmlVo.setDockerFile(configurationFile.getDockerFilePro());
                configXmlVo.setLocation("root");
            }
            if (configurationMapperById.getStatus().toString().equals(ConfigurationConstant.TYPE_ONE.toString()) || configurationMapperById.getStatus().toString().equals(ConfigurationConstant.TYPE_TWO.toString())) {
                configXmlVo.setBuildConfiguration(configurationFile.getBuildConfigurationTest());
                configXmlVo.setDockerFile(configurationFile.getDockerFileTest());
                configXmlVo.setLocation("home");
            }
            configXmlVo.setServerIp(byNodeIdAndFileId.getServerIp());
            configXmlVo.setProjectName(configurationFile.getProjectName() + nodeConfigurationEntity.getView());
            configXmlVo.setServiceName(configurationFile.getServiceName());
            log.info("ConfigXmlVo==>{}", (Object)JSON.toJSONString((Object)configXmlVo));
            map.put("configXmlVo", configXmlVo);
            BaseResponse template = this.template(map, configurationMapperById.getDeploymentType(), configurationMapperById.getStatus(), configurationFile.getProjectName());
            TemplateVo templateData = (TemplateVo)template.getData();
            String mavenJobName = this.getMavenJob(configXmlVo.getProjectName());
            if (mavenJobName != null) {
                if (configurationFile.getProjectName().equals("byh-eureka-server")) {
                    this.updateJob(configXmlVo.getProjectName(), templateData.getEurekaXml());
                    continue;
                }
                if (configurationFile.getProjectName().equals("byh-config-service")) {
                    this.updateJob(configXmlVo.getProjectName(), templateData.getConfigServiceXml());
                    continue;
                }
                this.updateJob(configXmlVo.getProjectName(), templateData.getRequestHisXml());
                continue;
            }
            if (configurationFile.getProjectName().equals("byh-eureka-server")) {
                this.ceateJob(configXmlVo.getProjectName(), templateData.getEurekaXml());
                continue;
            }
            if (configurationFile.getProjectName().equals("byh-config-service")) {
                this.ceateJob(configXmlVo.getProjectName(), templateData.getConfigServiceXml());
                continue;
            }
            this.ceateJob(configXmlVo.getProjectName(), templateData.getRequestHisXml());
        }
        return BaseResponse.success();
    }

    public BaseResponse<String> deploymentNode(String view, String viewName, String tagsNumber, String projectName, Integer deploymentType) {
        this.JenkinsConnect(deploymentType, viewName);
        String substring = tagsNumber.substring(0, 1);
        if (substring.equals("v")) {
            this.buildParamJob(projectName + view, tagsNumber);
        } else {
            this.buildParamJob(projectName + view, "origin/" + tagsNumber);
        }
        return BaseResponse.success();
    }

    public BaseResponse<String> saveJobConfiguration(JobServerIpEntity jobServerIpEntity) {
        ConfigurationFileEntity configurationFileEntity = this.configurationFileMapper.getById(jobServerIpEntity.getFileId());
        NodeConfigurationEntity nodeConfigurationEntity = this.nodeConfigurationMapper.getById(jobServerIpEntity.getNodeId());
        this.JenkinsConnect(nodeConfigurationEntity.getDeploymentType(), nodeConfigurationEntity.getViewName());
        HashMap<String, ConfigXmlVo> map = new HashMap<String, ConfigXmlVo>();
        ConfigXmlVo configXmlVo = new ConfigXmlVo();
        configXmlVo.setExtraHosts(nodeConfigurationEntity.getExtraHosts());
        configXmlVo.setLabel(nodeConfigurationEntity.getLabel());
        configXmlVo.setPort(configurationFileEntity.getPort());
        configXmlVo.setGitAddress(configurationFileEntity.getGitAddress());
        if (nodeConfigurationEntity.getStatus().toString().equals(ConfigurationConstant.TYPE_ONE.toString()) || nodeConfigurationEntity.getStatus().toString().equals(ConfigurationConstant.TYPE_TWO.toString())) {
            configXmlVo.setBuildConfiguration(configurationFileEntity.getBuildConfigurationTest());
            configXmlVo.setDockerFile(configurationFileEntity.getDockerFileTest());
            configXmlVo.setLocation("home");
        }
        if (nodeConfigurationEntity.getStatus().toString().equals(ConfigurationConstant.TYPE_THREE.toString()) || nodeConfigurationEntity.getStatus().toString().equals(ConfigurationConstant.TYPE_FOUR.toString())) {
            configXmlVo.setDockerFile(configurationFileEntity.getDockerFilePro());
            configXmlVo.setBuildConfiguration(configurationFileEntity.getBuildConfigurationPro());
            configXmlVo.setLocation("root");
        }
        configXmlVo.setProfile(nodeConfigurationEntity.getProfile());
        configXmlVo.setServerIp(jobServerIpEntity.getServerIp());
        configXmlVo.setProjectName(configurationFileEntity.getProjectName() + nodeConfigurationEntity.getView());
        configXmlVo.setServiceName(configurationFileEntity.getServiceName());
        log.info("ConfigXmlVo==>{}", (Object)JSON.toJSONString((Object)configXmlVo));
        map.put("configXmlVo", configXmlVo);
        BaseResponse template = this.template(map, nodeConfigurationEntity.getDeploymentType(), nodeConfigurationEntity.getStatus(), configurationFileEntity.getProjectName());
        TemplateVo templateData = (TemplateVo)template.getData();
        String mavenJobName = this.getMavenJob(configXmlVo.getProjectName());
        log.info("mavenJobName===>{}", (Object)JSON.toJSONString((Object)mavenJobName));
        if (null == mavenJobName) {
            if (configurationFileEntity.getProjectName().equals("byh-eureka-server")) {
                this.ceateJob(configXmlVo.getProjectName(), templateData.getEurekaXml());
            } else if (configurationFileEntity.getProjectName().equals("byh-config-service")) {
                this.ceateJob(configXmlVo.getProjectName(), templateData.getConfigServiceXml());
            } else {
                this.ceateJob(configXmlVo.getProjectName(), templateData.getRequestHisXml());
            }
        }
        if (null != mavenJobName) {
            if (configurationFileEntity.getProjectName().equals("byh-eureka-server")) {
                this.updateJob(configXmlVo.getProjectName(), templateData.getEurekaXml());
            } else if (configurationFileEntity.getProjectName().equals("byh-config-service")) {
                this.updateJob(configXmlVo.getProjectName(), templateData.getConfigServiceXml());
            } else {
                this.updateJob(configXmlVo.getProjectName(), templateData.getRequestHisXml());
            }
        }
        return BaseResponse.success();
    }

    private BaseResponse<TemplateVo> template(Map map, Integer type, Integer status, String projectName) {
        String requestHisXml;
        String configServiceXml;
        String eurekaXml;
        TemplateVo templateVo = new TemplateVo();
        Integer i = 0;
        i = status.toString().equals(ConfigurationConstant.TYPE_ONE.toString()) ? ConfigurationConstant.STATUS_INVALID : (status.toString().equals(ConfigurationConstant.TYPE_TWO.toString()) ? ConfigurationConstant.STATUS_INVALID : ConfigurationConstant.STATUS_VALID);
        log.info("i==>{}==status==>{}", (Object)JSON.toJSONString((Object)i), (Object)JSON.toJSONString((Object)status));
        if (type == 3) {
            eurekaXml = XmlTemplateKit.process((String)"config_eureka_server", (Map)map);
            if (StringUtils.isEmpty((CharSequence)eurekaXml)) {
                return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            templateVo.setEurekaXml(eurekaXml);
            configServiceXml = XmlTemplateKit.process((String)"config_config_service", (Map)map);
            if (StringUtils.isEmpty((CharSequence)configServiceXml)) {
                return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            templateVo.setConfigServiceXml(configServiceXml);
            if (i.toString().equals(ConfigurationConstant.STATUS_INVALID.toString())) {
                if (projectName.equals("byh-node-gateway")) {
                    requestHisXml = XmlTemplateKit.process((String)"config_general", (Map)map);
                    if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
                        return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
                    }
                    templateVo.setRequestHisXml(requestHisXml);
                } else {
                    requestHisXml = XmlTemplateKit.process((String)"config_general_test", (Map)map);
                    if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
                        return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
                    }
                    templateVo.setRequestHisXml(requestHisXml);
                }
            }
            if (i.toString().equals(ConfigurationConstant.STATUS_VALID.toString())) {
                requestHisXml = XmlTemplateKit.process((String)"config_general", (Map)map);
                if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
                    return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
                }
                templateVo.setRequestHisXml(requestHisXml);
            }
        }
        if (type == 2) {
            eurekaXml = XmlTemplateKit.process((String)"config_eureka_server_old_al", (Map)map);
            if (StringUtils.isEmpty((CharSequence)eurekaXml)) {
                return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            templateVo.setEurekaXml(eurekaXml);
            configServiceXml = XmlTemplateKit.process((String)"config_config_service_old_al", (Map)map);
            if (StringUtils.isEmpty((CharSequence)configServiceXml)) {
                return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            templateVo.setConfigServiceXml(configServiceXml);
            if (i.toString().equals(ConfigurationConstant.STATUS_INVALID.toString())) {
                if (projectName.equals("byh-node-gateway")) {
                    requestHisXml = XmlTemplateKit.process((String)"config_general_old_al", (Map)map);
                    if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
                        return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
                    }
                    templateVo.setRequestHisXml(requestHisXml);
                } else {
                    requestHisXml = XmlTemplateKit.process((String)"config_general_old_al_test", (Map)map);
                    if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
                        return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
                    }
                    templateVo.setRequestHisXml(requestHisXml);
                }
            }
            if (i.toString().equals(ConfigurationConstant.STATUS_VALID.toString())) {
                requestHisXml = XmlTemplateKit.process((String)"config_general_old_al", (Map)map);
                if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
                    return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
                }
                templateVo.setRequestHisXml(requestHisXml);
            }
        }
        return BaseResponse.success((Object)templateVo);
    }

    public BaseResponse<String> uodateJobNodeInitialize(InitializeInfoEntity initializeInfoEntity, Integer middlewareType) {
        String mysqlXml;
        this.JenkinsConnect(Integer.valueOf(3), "Middleware");
        NodeConfigurationEntity mapperByAppCode = this.nodeConfigurationMapper.getByAppCode(initializeInfoEntity.getAppCode(), initializeInfoEntity.getType());
        initializeInfoEntity.setName(mapperByAppCode.getView());
        log.info("initializeInfoEntity==>{}", (Object)JSON.toJSONString((Object)initializeInfoEntity));
        HashMap<String, InitializeInfoEntity> map = new HashMap<String, InitializeInfoEntity>();
        map.put("initializeInfoEntity", initializeInfoEntity);
        if (middlewareType.toString().equals(ConfigurationConstant.TYPE_ONE.toString())) {
            mysqlXml = XmlTemplateKit.process((String)"mysql_pro", map);
            if (StringUtils.isEmpty((CharSequence)mysqlXml)) {
                return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            this.updateJob("byh_mysql_pro", mysqlXml);
            String rabbitmqXml = XmlTemplateKit.process((String)"rabbitmq_pro", map);
            if (StringUtils.isEmpty((CharSequence)rabbitmqXml)) {
                return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            this.updateJob("byh_rabbitmq_pro", rabbitmqXml);
            String redisXml = XmlTemplateKit.process((String)"redis_pro", map);
            if (StringUtils.isEmpty((CharSequence)redisXml)) {
                return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            this.updateJob("byh_redis_pro", redisXml);
        }
        if (middlewareType.toString().equals(ConfigurationConstant.TYPE_TWO.toString())) {
            mysqlXml = XmlTemplateKit.process((String)"mysql_pro", map);
            if (StringUtils.isEmpty((CharSequence)mysqlXml)) {
                return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            this.updateJob("byh_mysql_pro", mysqlXml);
        }
        if (middlewareType.toString().equals(ConfigurationConstant.TYPE_THREE.toString())) {
            String redisXml = XmlTemplateKit.process((String)"redis_pro", map);
            if (StringUtils.isEmpty((CharSequence)redisXml)) {
                return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            this.updateJob("byh_redis_pro", redisXml);
        }
        if (middlewareType.toString().equals(ConfigurationConstant.TYPE_FOUR.toString())) {
            String rabbitmqXml = XmlTemplateKit.process((String)"rabbitmq_pro", map);
            if (StringUtils.isEmpty((CharSequence)rabbitmqXml)) {
                return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            this.updateJob("byh_rabbitmq_pro", rabbitmqXml);
        }
        return BaseResponse.success();
    }

    public BaseResponse<String> deploymentInitialize(Integer middlewareType) {
        this.JenkinsConnect(Integer.valueOf(3), "Middleware");
        if (middlewareType.toString().equals(ConfigurationConstant.TYPE_ONE.toString())) {
            this.buildParamJob("byh_mysql_pro");
            this.buildParamJob("byh_rabbitmq_pro");
            this.buildParamJob("byh_redis_pro");
        }
        if (middlewareType.toString().equals(ConfigurationConstant.TYPE_TWO.toString())) {
            this.buildParamJob("byh_mysql_pro");
        }
        if (middlewareType.toString().equals(ConfigurationConstant.TYPE_THREE.toString())) {
            this.buildParamJob("byh_redis_pro");
        }
        if (middlewareType.toString().equals(ConfigurationConstant.TYPE_FOUR.toString())) {
            this.buildParamJob("byh_rabbitmq_pro");
        }
        return BaseResponse.success();
    }

    public BaseResponse<BuildWithDetails> getJobBuild(Long nodeId, String projectName) {
        NodeConfigurationEntity nodeConfigurationEntity = this.nodeConfigurationMapper.getById(nodeId);
        this.JenkinsConnect(nodeConfigurationEntity.getDeploymentType(), nodeConfigurationEntity.getViewName());
        BaseResponse jobLastBuild = this.getJobLastBuild(projectName + nodeConfigurationEntity.getView());
        return jobLastBuild;
    }

    public BaseResponse<String> callJmeter() {
        this.JenkinsConnect(ConfigurationConstant.TYPE_THREE, "Autotest_all_YJBS");
        this.buildParamJob("Autotest_all_YJBS_TT");
        return BaseResponse.success();
    }

    public BaseResponse<String> deleteJob(Long nodeId) {
        NodeConfigurationEntity nodeConfigurationEntity = this.nodeConfigurationMapper.getById(nodeId);
        this.JenkinsConnect(nodeConfigurationEntity.getDeploymentType(), nodeConfigurationEntity.getViewName());
        this.deleteJobByView(nodeConfigurationEntity.getViewName());
        return null;
    }

    public String getMavenJob(String jobName) {
        MavenJobWithDetails job = null;
        try {
            job = this.jenkinsServer.getMavenJob(jobName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (null == job) {
            return null;
        }
        return job.getName();
    }

    public void ceateJob(String jobName, String jobXml) {
        try {
            log.info("===\u521b\u5efajob\u4efb\u52a1===>>jobName>{},>>jobXml>>{}", (Object)JSON.toJSONString((Object)jobName), (Object)JSON.toJSONString((Object)jobXml));
            this.jenkinsServer.createJob(jobName, jobXml);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updateJob(String jobName, String jobXml) {
        try {
            log.info("===\u4fee\u6539job\u4efb\u52a1===>>jobName>{},>>jobXml>>{}", (Object)JSON.toJSONString((Object)jobName), (Object)JSON.toJSONString((Object)jobXml));
            this.jenkinsServer.updateJob(jobName, jobXml);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void buildParamJob(String jobName, String buildName) {
        try {
            log.info("===\u90e8\u7f72job\u4efb\u52a1===>>jobName>{},>>buildName>>{}", (Object)JSON.toJSONString((Object)jobName), (Object)JSON.toJSONString((Object)buildName));
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("branch", buildName);
            this.jenkinsServer.getJob(jobName).build(param, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void buildParamJob(String jobName) {
        try {
            log.info("===\u90e8\u7f72job\u4efb\u52a1===>>jobName>{}", (Object)JSON.toJSONString((Object)jobName));
            this.jenkinsServer.getJob(jobName).build();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BaseResponse deleteJobByView(String viewName) {
        try {
            Map jobs = this.jenkinsServer.getJobs();
            for (Job job : jobs.values()) {
                System.out.println(job.getName());
                this.jenkinsServer.deleteJob(job.getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return BaseResponse.success();
    }

    public BaseResponse<BuildWithDetails> getJobLastBuild(String jobName) {
        BuildWithDetails build = null;
        try {
            log.info("==jobName==>{}", (Object)JSON.toJSONString((Object)jobName));
            JobWithDetails job = this.jenkinsServer.getJob(jobName);
            build = job.getLastBuild().details();
            log.info("==getNumber==>{}", (Object)JSON.toJSONString((Object)build.getNumber()));
            log.info("==getResult==>{}", (Object)JSON.toJSONString((Object)build.getResult()));
            log.info("==estimatedDuration==>{}", (Object)JSON.toJSONString((Object)build.getEstimatedDuration()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return BaseResponse.success(build);
    }

    public void JenkinsConnect(Integer deploymentType, String viewName) {
        String jenkinsUrl;
        if (deploymentType == 2) {
            jenkinsUrl = "https://huabei2.chinachdu.com/view/" + viewName;
            this.jenkinsServer = JenkinsConnect.connection((String)jenkinsUrl, (String)"byh@12321...");
        }
        if (deploymentType == 1) {
            jenkinsUrl = "http://120.220.207.89:10000/view/" + viewName;
            this.jenkinsServer = JenkinsConnect.connection((String)jenkinsUrl, (String)"byh@12321");
        }
        if (deploymentType == 3) {
            jenkinsUrl = "http://192.168.0.92:9090/view/" + viewName;
            this.jenkinsServer = JenkinsConnect.connection((String)jenkinsUrl, (String)"Baiyihui###000..");
        }
    }

    static {
        XmlTemplateKit.init();
    }
}

