/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.service.impl;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.entity.LoginEntity;
import com.ebaiyihui.service.mapper.LoginMapper;
import com.ebaiyihui.service.service.LoginService;
import com.ebaiyihui.service.utils.UUIDUtil;
import com.ebaiyihui.service.vo.login.LoginDto;
import com.ebaiyihui.service.vo.login.LoginVo;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements LoginService {
    private static final Logger log = LoggerFactory.getLogger(LoginServiceImpl.class);
    @Autowired
    private LoginMapper loginMapper;

    public BaseResponse<LoginDto> login(LoginVo loginVo, HttpServletResponse response) {
        String md5Password = DigestUtils.md5Hex((String)loginVo.getPassword());
        LoginEntity byLoginNameAndPassword = this.loginMapper.getByLoginNameAndPassword(loginVo.getUsername(), md5Password);
        String token = null;
        if (byLoginNameAndPassword != null) {
            token = UUIDUtil.getUUID();
            byLoginNameAndPassword.setToken(token);
            this.loginMapper.update(byLoginNameAndPassword);
        }
        if (byLoginNameAndPassword == null) {
            return BaseResponse.error((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef!");
        }
        LoginDto loginDto = new LoginDto();
        loginDto.setMd5Password(byLoginNameAndPassword.getMd5Password());
        if (token == null) {
            loginDto.setToken(byLoginNameAndPassword.getToken());
        }
        if (token != null) {
            loginDto.setToken(token);
        }
        loginDto.setUserName(byLoginNameAndPassword.getUserName());
        loginDto.setViewId(byLoginNameAndPassword.getViewId());
        Cookie viewIdCookie = new Cookie("userRegisterViewId", byLoginNameAndPassword.getViewId());
        viewIdCookie.setMaxAge(Integer.MAX_VALUE);
        viewIdCookie.setPath("/");
        response.addCookie(viewIdCookie);
        Cookie tokenCookie = new Cookie("userRegisterToken", byLoginNameAndPassword.getToken());
        tokenCookie.setMaxAge(Integer.MAX_VALUE);
        tokenCookie.setPath("/");
        response.addCookie(tokenCookie);
        return BaseResponse.success((Object)loginDto);
    }

    public BaseResponse<String> registered(LoginVo loginVo) {
        String md5Password = DigestUtils.md5Hex((String)loginVo.getPassword());
        LoginEntity byLoginName = this.loginMapper.getByLoginName(loginVo.getUsername());
        if (byLoginName != null) {
            return BaseResponse.error((String)"\u7528\u6237\u5df2\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0!");
        }
        LoginEntity loginEntity = new LoginEntity();
        loginEntity.setViewId(UUIDUtil.getUUID());
        loginEntity.setUserName(loginVo.getUsername());
        loginEntity.setPassword(loginVo.getPassword());
        loginEntity.setMd5Password(md5Password);
        loginEntity.setToken(UUIDUtil.getUUID());
        this.loginMapper.insert(loginEntity);
        return BaseResponse.success();
    }
}

