/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.config.RestConfiguration;
import com.ebaiyihui.service.constant.ConfigurationConstant;
import com.ebaiyihui.service.constant.enums.ActivationEnum;
import com.ebaiyihui.service.constant.enums.DomainEnum;
import com.ebaiyihui.service.constant.enums.NodeEnum;
import com.ebaiyihui.service.constant.enums.OrganEnum;
import com.ebaiyihui.service.entity.ConfigurationFileEntity;
import com.ebaiyihui.service.entity.ConfigurationSealingPlateEntity;
import com.ebaiyihui.service.entity.DependencyManagementInfoEntity;
import com.ebaiyihui.service.entity.InitializeInfoEntity;
import com.ebaiyihui.service.entity.JobServerIpEntity;
import com.ebaiyihui.service.entity.NodeConfigurationEntity;
import com.ebaiyihui.service.entity.OrganInfoEntity;
import com.ebaiyihui.service.entity.PlatformInfoEntity;
import com.ebaiyihui.service.entity.PlatformOutreachEntity;
import com.ebaiyihui.service.entity.VersionHistoryEntity;
import com.ebaiyihui.service.mapper.ConfigurationFileMapper;
import com.ebaiyihui.service.mapper.ConfigurationSealingPlateMapper;
import com.ebaiyihui.service.mapper.InitializeInfoMapper;
import com.ebaiyihui.service.mapper.JobServerIpMapper;
import com.ebaiyihui.service.mapper.NodeConfigurationMapper;
import com.ebaiyihui.service.mapper.OrganInfoMapper;
import com.ebaiyihui.service.mapper.PlatformInfoMapper;
import com.ebaiyihui.service.mapper.PlatformOutreachMapper;
import com.ebaiyihui.service.mapper.VersionHistoryMapper;
import com.ebaiyihui.service.service.DeploymentSituationService;
import com.ebaiyihui.service.service.FrontEndService;
import com.ebaiyihui.service.service.JobService;
import com.ebaiyihui.service.service.NodeVersioningService;
import com.ebaiyihui.service.service.ServiceVersioningService;
import com.ebaiyihui.service.service.ViewService;
import com.ebaiyihui.service.utils.PreparationUtils;
import com.ebaiyihui.service.utils.StrinUtils;
import com.ebaiyihui.service.vo.AddFrontEndVo;
import com.ebaiyihui.service.vo.AddPlatformAndServiceVo;
import com.ebaiyihui.service.vo.IterationVO;
import com.ebaiyihui.service.vo.IterationVersionHistoryVO;
import com.ebaiyihui.service.vo.NodeConfigurationVo;
import com.ebaiyihui.service.vo.NodeVersioningVo;
import com.ebaiyihui.service.vo.PlatformFileVo;
import com.ebaiyihui.service.vo.PlatformInfoVo;
import com.ebaiyihui.service.vo.SearchVO;
import com.ebaiyihui.service.vo.ServiceVersioningDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class NodeVersioningServiceImpl
implements NodeVersioningService {
    private static final Logger log = LoggerFactory.getLogger(NodeVersioningServiceImpl.class);
    @Autowired
    private NodeConfigurationMapper nodeConfigurationMapper;
    @Autowired
    private JobServerIpMapper jobServerIpMapper;
    @Autowired
    private ConfigurationFileMapper configurationFileMapper;
    @Autowired
    private PlatformOutreachMapper platformOutreachMapper;
    @Autowired
    private PlatformInfoMapper platformInfoMapper;
    @Autowired
    private ServiceVersioningService serviceVersioningService;
    @Autowired
    private FrontEndService frontEndService;
    @Autowired
    private VersionHistoryMapper versionHistoryMapper;
    @Autowired
    private ViewService viewService;
    @Autowired
    private JobService jobService;
    @Autowired
    private DeploymentSituationService deploymentSituationService;
    @Autowired
    private OrganInfoMapper organInfoMapper;
    @Autowired
    private ConfigurationSealingPlateMapper configurationSealingPlateMapper;
    @Autowired
    private InitializeInfoMapper initializeInfoMapper;

    public BaseResponse<List<NodeConfigurationVo>> getListBySearch(String searchParam, Integer searchType) {
        List listByStatus = this.nodeConfigurationMapper.getListByStatus(searchParam, searchType);
        List nodeConfigurationEntities = listByStatus.stream().filter(ele -> !ele.getLabel().equals("web")).collect(Collectors.toList());
        ArrayList nodeConfigurationVoList = new ArrayList();
        nodeConfigurationEntities.stream().forEach(ele -> {
            NodeConfigurationVo nodeConfigurationVo = new NodeConfigurationVo();
            BeanUtils.copyProperties((Object)ele, (Object)nodeConfigurationVo);
            Integer count = this.jobServerIpMapper.countByNodeId(ele.getId());
            nodeConfigurationVo.setCount(count);
            nodeConfigurationVo.setBelong(OrganEnum.organCodeEnum((Integer)ele.getBelongs()));
            nodeConfigurationVo.setViewName(StringUtils.substringBefore((String)ele.getViewName(), (String)"-"));
            Integer countByStatus = this.jobServerIpMapper.countByStatus(ele.getId());
            if (countByStatus.toString().equals(ConfigurationConstant.STATUS_INVALID.toString())) {
                nodeConfigurationVo.setStatus(ConfigurationConstant.STATUS_VALID);
            }
            if (countByStatus > ConfigurationConstant.STATUS_INVALID) {
                nodeConfigurationVo.setStatus(ConfigurationConstant.STATUS_INVALID);
            }
            nodeConfigurationVoList.add(nodeConfigurationVo);
        });
        return BaseResponse.success(nodeConfigurationVoList);
    }

    public BaseResponse<String> addNodeVersioning(NodeVersioningVo nodeVersioningVo) {
        Integer testMethod;
        NodeConfigurationEntity nodeConfigurationEntity = new NodeConfigurationEntity();
        BeanUtils.copyProperties((Object)nodeVersioningVo, (Object)nodeConfigurationEntity);
        nodeConfigurationEntity.setViewName(nodeVersioningVo.getViewName() + NodeEnum.getNodeCode((Integer)nodeVersioningVo.getBelongs()));
        nodeConfigurationEntity.setView("_" + nodeVersioningVo.getViewName() + NodeEnum.getNodeCode((Integer)nodeVersioningVo.getBelongs()));
        nodeConfigurationEntity.setLabel(nodeVersioningVo.getViewName());
        nodeConfigurationEntity.setProfile(NodeEnum.getNodeDesc((Integer)nodeVersioningVo.getBelongs()));
        String serverIp = nodeVersioningVo.getServerIp();
        List<Object> stringList = new ArrayList();
        if (3 == nodeVersioningVo.getStatus()) {
            stringList = Arrays.asList(nodeVersioningVo.getServerIp().split(",")).stream().map(String::toString).collect(Collectors.toList());
            if (stringList.size() == 1) {
                serverIp = (String)stringList.get(0);
            } else if (stringList.size() > 1) {
                serverIp = (String)stringList.get(0);
            }
        }
        if ((testMethod = StrinUtils.testMethod((String)serverIp)) != 0) {
            String method = StrinUtils.method((String)serverIp);
            nodeConfigurationEntity.setExtraHosts(NodeEnum.getExtraHosts((String)method, null, null, null));
        } else {
            nodeConfigurationEntity.setExtraHosts(NodeEnum.getExtraHosts((String)serverIp, null, null, null));
        }
        this.nodeConfigurationMapper.insert(nodeConfigurationEntity);
        nodeConfigurationEntity.setType(Integer.valueOf(nodeConfigurationEntity.getId().intValue()));
        this.nodeConfigurationMapper.update(nodeConfigurationEntity);
        List listByStatus = this.configurationFileMapper.getListByIds(nodeVersioningVo.getIdLists());
        for (ConfigurationFileEntity configurationFileEntity : listByStatus) {
            JobServerIpEntity jobServerIpEntity = new JobServerIpEntity();
            jobServerIpEntity.setChineseNameService(configurationFileEntity.getChineseNameService());
            jobServerIpEntity.setServiceName(configurationFileEntity.getProjectName());
            jobServerIpEntity.setNodeId(nodeConfigurationEntity.getId());
            jobServerIpEntity.setNodeName(nodeConfigurationEntity.getNodeName());
            jobServerIpEntity.setFileId(configurationFileEntity.getId());
            if (3 == nodeVersioningVo.getStatus() && 1 < stringList.size() && 21L < configurationFileEntity.getId()) {
                jobServerIpEntity.setServerIp((String)stringList.get(1));
            } else {
                jobServerIpEntity.setServerIp(serverIp);
            }
            jobServerIpEntity.setStatus(ConfigurationConstant.STATUS_INVALID);
            if (4 == nodeVersioningVo.getBelongs()) {
                ConfigurationSealingPlateEntity plateEntity = this.configurationSealingPlateMapper.getByFileId(configurationFileEntity.getId());
                jobServerIpEntity.setTagsNumber(plateEntity == null ? null : plateEntity.getProfile());
            } else {
                jobServerIpEntity.setTagsNumber(nodeVersioningVo.getTagsNumber());
            }
            this.jobServerIpMapper.insert(jobServerIpEntity);
            VersionHistoryEntity versionHistoryEntity = new VersionHistoryEntity();
            versionHistoryEntity.setChineseNameService(configurationFileEntity.getChineseNameService());
            versionHistoryEntity.setServiceName(configurationFileEntity.getProjectName());
            versionHistoryEntity.setFileId(configurationFileEntity.getId());
            versionHistoryEntity.setNodeId(nodeConfigurationEntity.getId());
            versionHistoryEntity.setTagsNumber(jobServerIpEntity.getTagsNumber());
            this.versionHistoryMapper.insert(versionHistoryEntity);
        }
        this.viewService.insertView(nodeConfigurationEntity.getViewName(), nodeConfigurationEntity.getNodeName(), nodeConfigurationEntity.getDeploymentType());
        this.jobService.insertJobNode(nodeConfigurationEntity, listByStatus);
        return BaseResponse.success();
    }

    public BaseResponse<String> updateNodeVersioning(NodeVersioningVo nodeVersioningVo) {
        NodeConfigurationEntity nodeConfigurationEntity = new NodeConfigurationEntity();
        BeanUtils.copyProperties((Object)nodeVersioningVo, (Object)nodeConfigurationEntity);
        nodeConfigurationEntity.setStatus(null);
        nodeConfigurationEntity.setId(nodeVersioningVo.getNodeId());
        nodeConfigurationEntity.setViewName(nodeVersioningVo.getViewName() + NodeEnum.getNodeCode((Integer)nodeVersioningVo.getBelongs()));
        nodeConfigurationEntity.setView("_" + nodeVersioningVo.getViewName() + NodeEnum.getNodeCode((Integer)nodeVersioningVo.getBelongs()));
        nodeConfigurationEntity.setLabel(nodeVersioningVo.getViewName());
        nodeConfigurationEntity.setProfile(NodeEnum.getNodeDesc((Integer)nodeVersioningVo.getBelongs()));
        this.nodeConfigurationMapper.update(nodeConfigurationEntity);
        this.jobService.uodateJobNode(nodeConfigurationEntity);
        return BaseResponse.success();
    }

    public BaseResponse<String> nodeVersioningAndDeployment(Long nodeId) {
        List listByFileIdAndNodeId = this.jobServerIpMapper.getListByFileIdAndNodeId(null, nodeId);
        for (JobServerIpEntity jobServerIpEntity : listByFileIdAndNodeId) {
            if (jobServerIpEntity.getStatus().toString().equals(ConfigurationConstant.STATUS_VALID.toString())) continue;
            NodeConfigurationEntity nodeConfigurationEntity = this.nodeConfigurationMapper.getById(jobServerIpEntity.getNodeId());
            ConfigurationFileEntity configurationFileEntity = this.configurationFileMapper.getById(jobServerIpEntity.getFileId());
            if (configurationFileEntity.getProjectName().equals("byh-eureka-server")) {
                this.jobService.deploymentNode(nodeConfigurationEntity.getView(), nodeConfigurationEntity.getViewName(), jobServerIpEntity.getTagsNumber(), configurationFileEntity.getProjectName(), nodeConfigurationEntity.getDeploymentType());
                this.deploymentSituationService.saveDeploymentSituation(nodeConfigurationEntity, configurationFileEntity);
                this.jobServerIpMapper.updateByIdAndStatus(jobServerIpEntity.getId(), ConfigurationConstant.STATUS_VALID);
                continue;
            }
            if (configurationFileEntity.getProjectName().equals("byh-config-service")) {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.jobService.deploymentNode(nodeConfigurationEntity.getView(), nodeConfigurationEntity.getViewName(), jobServerIpEntity.getTagsNumber(), configurationFileEntity.getProjectName(), nodeConfigurationEntity.getDeploymentType());
                this.deploymentSituationService.saveDeploymentSituation(nodeConfigurationEntity, configurationFileEntity);
                this.jobServerIpMapper.updateByIdAndStatus(jobServerIpEntity.getId(), ConfigurationConstant.STATUS_VALID);
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.jobService.deploymentNode(nodeConfigurationEntity.getView(), nodeConfigurationEntity.getViewName(), jobServerIpEntity.getTagsNumber(), configurationFileEntity.getProjectName(), nodeConfigurationEntity.getDeploymentType());
            this.deploymentSituationService.saveDeploymentSituation(nodeConfigurationEntity, configurationFileEntity);
            this.jobServerIpMapper.updateByIdAndStatus(jobServerIpEntity.getId(), ConfigurationConstant.STATUS_VALID);
        }
        return BaseResponse.success();
    }

    public BaseResponse<List<PlatformInfoVo>> getListByPlatformSearch(String searchParam, Long nodeId) {
        List listByNodeId = this.platformInfoMapper.getListByNodeId(nodeId, searchParam);
        ArrayList platformInfoVoList = new ArrayList();
        listByNodeId.stream().forEach(platformInfoEntity -> {
            PlatformInfoVo platformInfoVo = new PlatformInfoVo();
            BeanUtils.copyProperties((Object)platformInfoEntity, (Object)platformInfoVo);
            Map map = this.getDomainNameEnum(platformInfoEntity.getType(), platformInfoEntity.getPlatformCode());
            log.info("map--->{}", (Object)JSON.toJSONString((Object)map));
            if (!map.isEmpty()) {
                Integer status = (Integer)map.get("status");
                Long id = (long)((Integer)map.get("id"));
                platformInfoVo.setActivation(status);
                platformInfoVo.setPlatformTypeId(id);
            }
            platformInfoVoList.add(platformInfoVo);
        });
        return BaseResponse.success(platformInfoVoList);
    }

    public Map getDomainNameEnum(Integer value, String appCode) {
        InitializeInfoEntity mapperByAppCode = this.initializeInfoMapper.getByAppCode(appCode, value);
        String domainDesc = "https://" + mapperByAppCode.getDomainName() + "/cloud/doctorbasedata/hospital_info/select_list";
        RestTemplate restTemplate = new RestConfiguration().restTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)("{\"hospitalIdOrName\":\"" + appCode + "\",\"pageNum\":1,\"pageSize\":100,\"statusArr\":[\"1\",\"2\",\"8\"]}"), (MultiValueMap)headers);
        log.info("request===>{}", (Object)JSON.toJSONString((Object)request));
        BaseResponse baseResponse = (BaseResponse)restTemplate.postForObject(domainDesc, (Object)request, BaseResponse.class, new Object[0]);
        log.info("informationPlatform==>{}", (Object)JSON.toJSONString((Object)baseResponse));
        Object data = baseResponse.getData();
        Object hospitalPage = ((Map)JSON.parseObject((String)JSON.toJSONString((Object)data), Map.class)).get("hospitalPage");
        Object content = ((Map)JSON.parseObject((String)JSON.toJSONString(hospitalPage), Map.class)).get("content");
        log.info("content==>{}", (Object)JSON.toJSONString(content));
        List stringList = JSONArray.parseArray((String)JSON.toJSON(content).toString(), String.class);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String s : stringList) {
            Map parseObject = (Map)JSON.parseObject((String)s, Map.class);
            Integer status = (Integer)parseObject.get("status");
            Integer id = (Integer)parseObject.get("id");
            map.put("status", status);
            map.put("id", id);
        }
        return map;
    }

    public BaseResponse<String> addPlatform(PlatformInfoEntity platformInfoEntity) {
        log.info("===\u5165\u53c2===>{}", (Object)JSON.toJSONString((Object)platformInfoEntity));
        this.platformInfoMapper.insert(platformInfoEntity);
        NodeConfigurationEntity nodeConfigurationEntity = this.nodeConfigurationMapper.getById(platformInfoEntity.getNodeId());
        List fileMapperByList = this.configurationFileMapper.getListByStatus(ConfigurationConstant.TYPE_FOUR, null);
        List fileMapperListByType = this.configurationFileMapper.getListByType(Integer.valueOf(platformInfoEntity.getId().intValue()));
        fileMapperByList.addAll(fileMapperListByType);
        fileMapperByList.stream().forEach(fileEntity -> {
            PlatformOutreachEntity platformOutreachEntity = new PlatformOutreachEntity();
            platformOutreachEntity.setNodeId(platformInfoEntity.getNodeId());
            platformOutreachEntity.setNodeName(nodeConfigurationEntity.getNodeName());
            platformOutreachEntity.setPlatformName(platformInfoEntity.getPlatformName());
            platformOutreachEntity.setPlatformId(platformInfoEntity.getId());
            platformOutreachEntity.setFileId(fileEntity.getId());
            platformOutreachEntity.setChineseNameService(fileEntity.getChineseNameService());
            platformOutreachEntity.setServiceName(fileEntity.getServiceName());
            platformOutreachEntity.setStatus(ConfigurationConstant.STATUS_VALID);
            this.platformOutreachMapper.insert(platformOutreachEntity);
        });
        return BaseResponse.success();
    }

    public BaseResponse<String> updatePlatform(PlatformInfoEntity platformInfoEntity) {
        PlatformInfoEntity mapperById = this.platformInfoMapper.getById(platformInfoEntity.getId());
        if (!mapperById.getNodeId().toString().equals(platformInfoEntity.getNodeId().toString())) {
            List byPlatformId = this.platformOutreachMapper.getByPlatformId(platformInfoEntity.getId());
            byPlatformId.stream().forEach(platformOutreachEntity -> {
                NodeConfigurationEntity nodeConfigurationEntity = this.nodeConfigurationMapper.getById(platformInfoEntity.getNodeId());
                platformOutreachEntity.setNodeId(platformInfoEntity.getNodeId());
                platformOutreachEntity.setNodeName(nodeConfigurationEntity.getNodeName());
                this.platformOutreachMapper.update(platformOutreachEntity);
            });
        }
        log.info("===\u5165\u53c2===>{}", (Object)JSON.toJSONString((Object)platformInfoEntity));
        this.platformInfoMapper.update(platformInfoEntity);
        return BaseResponse.success();
    }

    public BaseResponse<List<PlatformFileVo>> getListByPlatformAndServiceSearch(String searchParam, Long nodeId) {
        ArrayList platformFileVoList = new ArrayList();
        BaseResponse listByServiceSearch = this.getListByServiceSearch(searchParam, nodeId, ConfigurationConstant.TYPE_FOUR);
        ((List)listByServiceSearch.getData()).stream().forEach(searchVO -> {
            PlatformFileVo platformFile = new PlatformFileVo();
            platformFile.setChineseNameService(searchVO.getChineseNameService());
            platformFile.setServiceName(searchVO.getServiceName());
            platformFile.setServerIp(searchVO.getServerIp());
            platformFile.setTagsNumber(searchVO.getTagsNumber());
            platformFile.setNodeId(searchVO.getNodeId());
            platformFile.setFileId(searchVO.getFileId());
            platformFile.setCreateTime(searchVO.getCreateTime());
            platformFileVoList.add(platformFile);
        });
        return BaseResponse.success(platformFileVoList);
    }

    public BaseResponse<String> addPlatformAndService(AddPlatformAndServiceVo addPlatformAndServiceVo) {
        AddFrontEndVo addFrontEndVo;
        ServiceVersioningDTO serviceVersioningDTO = addPlatformAndServiceVo.getServiceVersioningDTO();
        if (Objects.nonNull(serviceVersioningDTO) && StringUtils.isNotBlank((CharSequence)serviceVersioningDTO.getServiceName())) {
            BaseResponse add = this.serviceVersioningService.add(serviceVersioningDTO);
            Long fileId = Long.valueOf((String)add.getData());
            if (null != serviceVersioningDTO.getNodeId()) {
                PlatformOutreachEntity platformOutreachEntity = new PlatformOutreachEntity();
                platformOutreachEntity.setNodeId(serviceVersioningDTO.getNodeId());
                NodeConfigurationEntity nodeConfigurationEntity = this.nodeConfigurationMapper.getById(serviceVersioningDTO.getNodeId());
                platformOutreachEntity.setNodeName(nodeConfigurationEntity.getNodeName());
                platformOutreachEntity.setPlatformId(serviceVersioningDTO.getPlatformId());
                PlatformInfoEntity platformInfoEntity = this.platformInfoMapper.getById(serviceVersioningDTO.getPlatformId());
                platformOutreachEntity.setPlatformName(platformInfoEntity.getPlatformName());
                platformOutreachEntity.setChineseNameService(serviceVersioningDTO.getChineseNameService());
                platformOutreachEntity.setServiceName(serviceVersioningDTO.getServiceName());
                platformOutreachEntity.setFileId(fileId);
                platformOutreachEntity.setStatus(ConfigurationConstant.STATUS_VALID);
                this.platformOutreachMapper.insert(platformOutreachEntity);
            }
        }
        if (Objects.nonNull(addFrontEndVo = addPlatformAndServiceVo.getAddFrontEndVo()) && StringUtils.isNotBlank((CharSequence)addFrontEndVo.getServiceName())) {
            BaseResponse baseResponse = this.frontEndService.add(addFrontEndVo);
        }
        return BaseResponse.success();
    }

    public BaseResponse<List<VersionHistoryEntity>> getListByPlatformVersionHistory(Long nodeId, Long fileId) {
        List historyEntities = this.versionHistoryMapper.getByNodeIdAndFileId(nodeId, fileId);
        log.info(" ===\u67e5\u8be2\u5386\u53f2\u7248\u672c===>{}", (Object)JSON.toJSONString((Object)historyEntities));
        return BaseResponse.success((Object)historyEntities);
    }

    public BaseResponse<String> iterationVersionHistory(IterationVO iterationVO) {
        this.serviceVersioningService.addIteration(iterationVO);
        return BaseResponse.success();
    }

    public BaseResponse<List<SearchVO>> getListByServiceSearch(String searchParam, Long nodeId, Integer type) {
        NodeConfigurationEntity nodeConfigurationEntity = this.nodeConfigurationMapper.getById(nodeId);
        List ConfigurationFileVo2 = this.configurationFileMapper.getListByStatus(type, searchParam);
        List listByType = this.configurationFileMapper.getListByType(Integer.valueOf(nodeId.intValue()));
        ConfigurationFileVo2.addAll(listByType);
        ArrayList<SearchVO> searchVOS = new ArrayList<SearchVO>();
        for (ConfigurationFileEntity configurationFileEntity : ConfigurationFileVo2) {
            SearchVO searchVO = new SearchVO();
            searchVO.setProjectName(configurationFileEntity.getProjectName());
            searchVO.setServiceName(configurationFileEntity.getServiceName());
            searchVO.setProfile(nodeConfigurationEntity.getProfile());
            searchVO.setFileId(configurationFileEntity.getId());
            searchVO.setGitAddress(configurationFileEntity.getGitAddress());
            searchVO.setPort(configurationFileEntity.getPort().substring(2, 6));
            JobServerIpEntity listByFileIdAndNodeId = this.jobServerIpMapper.getByNodeIdAndFileId(nodeId, configurationFileEntity.getId());
            if (null == listByFileIdAndNodeId) continue;
            searchVO.setJobServerId(listByFileIdAndNodeId.getId());
            searchVO.setServerIp(listByFileIdAndNodeId.getServerIp());
            searchVO.setTagsNumber(listByFileIdAndNodeId.getTagsNumber());
            searchVO.setCreateTime(listByFileIdAndNodeId.getCreateTime());
            searchVO.setUpdateTime(listByFileIdAndNodeId.getUpdateTime());
            searchVO.setChineseNameService(configurationFileEntity.getChineseNameService());
            searchVO.setStatus(listByFileIdAndNodeId.getStatus());
            searchVOS.add(searchVO);
        }
        return BaseResponse.success(searchVOS);
    }

    public BaseResponse<String> addNodeVersioningAndService(ServiceVersioningDTO serviceVersioningDTO) {
        serviceVersioningDTO.setType(ConfigurationConstant.TYPE_TWO);
        BaseResponse add = this.serviceVersioningService.add(serviceVersioningDTO);
        Long fileId = Long.valueOf((String)add.getData());
        List listByNodeId = this.platformInfoMapper.getListByNodeId(serviceVersioningDTO.getNodeId(), null);
        NodeConfigurationEntity nodeConfigurationEntity = this.nodeConfigurationMapper.getById(serviceVersioningDTO.getNodeId());
        listByNodeId.stream().forEach(platformInfoEntity -> {
            PlatformOutreachEntity platformOutreachEntity = new PlatformOutreachEntity();
            platformOutreachEntity.setNodeId(serviceVersioningDTO.getNodeId());
            platformOutreachEntity.setNodeName(nodeConfigurationEntity.getNodeName());
            platformOutreachEntity.setPlatformId(platformInfoEntity.getId());
            platformOutreachEntity.setPlatformName(platformInfoEntity.getPlatformName());
            platformOutreachEntity.setChineseNameService(serviceVersioningDTO.getChineseNameService());
            platformOutreachEntity.setServiceName(serviceVersioningDTO.getServiceName());
            platformOutreachEntity.setFileId(fileId);
            platformOutreachEntity.setStatus(ConfigurationConstant.STATUS_VALID);
            this.platformOutreachMapper.insert(platformOutreachEntity);
        });
        JobServerIpEntity jobServerIpEntity = new JobServerIpEntity();
        jobServerIpEntity.setChineseNameService(serviceVersioningDTO.getChineseNameService());
        jobServerIpEntity.setServiceName(serviceVersioningDTO.getProjectName());
        jobServerIpEntity.setNodeId(serviceVersioningDTO.getNodeId());
        jobServerIpEntity.setNodeName(nodeConfigurationEntity.getNodeName());
        jobServerIpEntity.setFileId(fileId);
        jobServerIpEntity.setServerIp(serviceVersioningDTO.getServerIp());
        jobServerIpEntity.setStatus(ConfigurationConstant.STATUS_INVALID);
        jobServerIpEntity.setTagsNumber(serviceVersioningDTO.getTagsNumber());
        this.jobServerIpMapper.insert(jobServerIpEntity);
        this.jobService.saveJobConfiguration(jobServerIpEntity);
        return BaseResponse.success();
    }

    public BaseResponse<String> updateNodeVersioningAndService(ServiceVersioningDTO serviceVersioningDTO) {
        this.serviceVersioningService.update(serviceVersioningDTO);
        JobServerIpEntity byNodeIdAndFileId = this.jobServerIpMapper.getByNodeIdAndFileId(serviceVersioningDTO.getNodeId(), serviceVersioningDTO.getFileId());
        this.jobService.saveJobConfiguration(byNodeIdAndFileId);
        return BaseResponse.success();
    }

    public BaseResponse<String> ServiceAndDeployment(Long jobServerId, String tagsNumber) {
        return this.serviceVersioningService.deployment(jobServerId, tagsNumber);
    }

    public BaseResponse<List<VersionHistoryEntity>> getListByServiceVersionHistory(Long fileId) {
        List historyEntities = this.versionHistoryMapper.getByFileId(fileId);
        log.info(" ===\u67e5\u8be2\u5386\u53f2\u7248\u672c===>{}", (Object)JSON.toJSONString((Object)historyEntities));
        return BaseResponse.success((Object)historyEntities);
    }

    public BaseResponse<String> addByServiceVersionHistory(IterationVO iterationVO) {
        this.serviceVersioningService.addIteration(iterationVO);
        return BaseResponse.success();
    }

    public BaseResponse<String> addByServiceRely(List<DependencyManagementInfoEntity> dependencyManagementInfoEntities) {
        this.serviceVersioningService.addRely(dependencyManagementInfoEntities);
        return BaseResponse.success();
    }

    public BaseResponse<List<IterationVersionHistoryVO>> getListDependencyManagement(Long fileId) {
        return this.serviceVersioningService.getListDependencyManagement(fileId);
    }

    public BaseResponse<String> getActivation(PlatformInfoVo platformInfoVo) {
        InitializeInfoEntity mapperByAppCode = this.initializeInfoMapper.getByAppCode(platformInfoVo.getPlatformCode(), platformInfoVo.getType());
        String domainName = mapperByAppCode.getDomainName();
        String activation = ActivationEnum.getDomainValue((Integer)ConfigurationConstant.TYPE_FIVE);
        PreparationUtils.getActivation((String)domainName, (String)activation);
        PreparationUtils.dealWhite((String)domainName, (String)platformInfoVo.getPlatformCode());
        log.info("==\u5904\u7406/\u6dfb\u52a0\u767d\u540d\u5355===");
        BaseResponse baseResponse = PreparationUtils.addActivation((String)domainName, (Long)platformInfoVo.getPlatformTypeId());
        log.info("==baseResponse===>{}", (Object)JSON.toJSONString((Object)baseResponse));
        if (baseResponse.getErrCode().equals(ConfigurationConstant.STATUS_FAILURE.toString())) {
            return BaseResponse.error((String)baseResponse.getMsg());
        }
        PreparationUtils.delectActivation((String)domainName, (String)activation);
        PreparationUtils.deleteWhite((String)domainName, (String)platformInfoVo.getPlatformCode());
        log.info("==\u5220\u9664\u767d\u540d\u5355===");
        return BaseResponse.success();
    }

    public BaseResponse<String> getAssociated(PlatformInfoVo platformInfoVo) {
        OrganInfoEntity organInfoEntity = this.organInfoMapper.getListByAppCode(platformInfoVo.getPlatformCode(), platformInfoVo.getType());
        if (organInfoEntity == null) {
            return BaseResponse.error((String)"\u4e2d\u95f4\u4ef6\u533b\u9662\u6570\u636e\u672a\u627e\u5230,\u8bf7\u914d\u5236\u533b\u9662\u6570\u636e");
        }
        Long organId = organInfoEntity.getOrganId();
        String domainValue = DomainEnum.getDomainValue((Integer)platformInfoVo.getType());
        InitializeInfoEntity mapperByAppCode = this.initializeInfoMapper.getByAppCode(platformInfoVo.getPlatformCode(), platformInfoVo.getType());
        String domainName = mapperByAppCode.getDomainName();
        String organDetail = ActivationEnum.getDomainValue((Integer)ConfigurationConstant.TYPE_SIX);
        String associated = ActivationEnum.getDomainValue((Integer)ConfigurationConstant.TYPE_SEVEN);
        PreparationUtils.getActivation((String)domainName, (String)organDetail);
        PreparationUtils.getActivation((String)domainName, (String)associated);
        log.info("==\u5904\u7406/\u6dfb\u52a0\u767d\u540d\u5355===");
        PreparationUtils.addAssociated((String)domainName, (String)organDetail, (String)associated, (Long)organId, (String)platformInfoVo.getPlatformCode());
        PreparationUtils.delectActivation((String)domainName, (String)organDetail);
        PreparationUtils.delectActivation((String)domainName, (String)associated);
        log.info("==\u5220\u9664\u767d\u540d\u5355===");
        return BaseResponse.success();
    }
}

