/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.config.RestConfiguration;
import com.ebaiyihui.service.constant.ConfigurationConstant;
import com.ebaiyihui.service.constant.Constants;
import com.ebaiyihui.service.entity.DeploymentSituationEntity;
import com.ebaiyihui.service.entity.GitlabLogEntity;
import com.ebaiyihui.service.mapper.DeploymentSituationMapper;
import com.ebaiyihui.service.mapper.GitlabLogHappyMapper;
import com.ebaiyihui.service.mapper.GitlabLogMapper;
import com.ebaiyihui.service.service.JobService;
import com.ebaiyihui.service.utils.DateUtils;
import com.ebaiyihui.service.utils.ExcelUtils;
import com.offbytwo.jenkins.model.BuildWithDetails;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

@Component
public class TimingTask {
    private static final Logger log = LoggerFactory.getLogger(TimingTask.class);
    @Autowired
    private DeploymentSituationMapper deploymentSituationMapper;
    @Autowired
    private JobService jobService;
    @Autowired
    private GitlabLogMapper gitlabLogMapper;
    @Autowired
    private GitlabLogHappyMapper gitlabLogHappyMapper;
    @Autowired
    JavaMailSender javaMailSender;

    @Scheduled(fixedRate=60000L)
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void expiredUnpaidOrder() {
        List mapperListByStatus = this.deploymentSituationMapper.getListByStatus(ConfigurationConstant.STATUS_INVALID);
        for (DeploymentSituationEntity deploymentSituationEntity : mapperListByStatus) {
            BaseResponse jobServiceJobBuild = this.jobService.getJobBuild(deploymentSituationEntity.getNodeId(), deploymentSituationEntity.getServiceName());
            if (((BuildWithDetails)jobServiceJobBuild.getData()).getNumber() <= deploymentSituationEntity.getStatus() || ((BuildWithDetails)jobServiceJobBuild.getData()).getResult() == null) continue;
            if ("SUCCESS".equals(((BuildWithDetails)jobServiceJobBuild.getData()).getResult().toString())) {
                if (((BuildWithDetails)jobServiceJobBuild.getData()).getEstimatedDuration() == -1L) continue;
                if (deploymentSituationEntity.getInterfaceUrl() == null) {
                    deploymentSituationEntity.setJobNumber(Integer.valueOf(((BuildWithDetails)jobServiceJobBuild.getData()).getNumber()));
                    deploymentSituationEntity.setStatus(ConfigurationConstant.STATUS_VALID);
                    this.deploymentSituationMapper.update(deploymentSituationEntity);
                    continue;
                }
                if (deploymentSituationEntity.getInterfaceUrl() != null) {
                    BaseResponse checkHealth = this.getCheckHealth(deploymentSituationEntity);
                    log.info("===checkHealth===>{}", (Object)JSON.toJSONString((Object)checkHealth));
                    if (!checkHealth.getCode().equals("1")) continue;
                    deploymentSituationEntity.setJobNumber(Integer.valueOf(((BuildWithDetails)jobServiceJobBuild.getData()).getNumber()));
                    deploymentSituationEntity.setStatus(ConfigurationConstant.STATUS_VALID);
                    this.deploymentSituationMapper.update(deploymentSituationEntity);
                    continue;
                }
            }
            if (!"FAILURE".equals(((BuildWithDetails)jobServiceJobBuild.getData()).getResult().toString())) continue;
            deploymentSituationEntity.setJobNumber(Integer.valueOf(((BuildWithDetails)jobServiceJobBuild.getData()).getNumber()));
            deploymentSituationEntity.setStatus(ConfigurationConstant.STATUS_FAILURE);
            this.deploymentSituationMapper.update(deploymentSituationEntity);
        }
    }

    private BaseResponse getCheckHealth(DeploymentSituationEntity deploymentSituationEntity) {
        RestTemplate restTemplate = new RestConfiguration().restTemplate();
        String url = "https://" + deploymentSituationEntity.getDomainName() + "/" + deploymentSituationEntity.getAppCode() + "/" + deploymentSituationEntity.getInterfaceUrl();
        log.info("url :{}", (Object)JSON.toJSONString((Object)url));
        try {
            String response = (String)restTemplate.getForObject(url, String.class, new Object[0]);
            log.info("===response====>{}", (Object)JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.info("===e===>{}", (Object)JSON.toJSONString((Object)e));
            return BaseResponse.error((String)"FAILURE");
        }
        return BaseResponse.success((Object)"SUCCESS");
    }

    @Scheduled(cron="0 30 21 * * ?")
    public void getGitlabLogList() {
        this.getGitlabLogList(Constants.GROUPS_HIS_FRONT_ID, ConfigurationConstant.STATUS_INVALID);
        this.getGitlabLogList(Constants.GROUPS_BYH_EHOS_ID, ConfigurationConstant.STATUS_INVALID);
        this.getGitlabLogList(Constants.GROUPS_IHOSPITAL_WEB_ID, ConfigurationConstant.STATUS_INVALID);
        this.getGitlabLogList(Constants.GROUPS_IHOSPITAL_WEB_SERVICE, ConfigurationConstant.STATUS_INVALID);
        this.getGitlabLogList(Constants.GROUPS_IHOSPITAL_APP_ID, ConfigurationConstant.STATUS_INVALID);
    }

    @Scheduled(cron="0 10 21 * * ?")
    public void getGitlabLogHappyList() {
        this.getGitlabLogList(Constants.GROUPS_MEIHAO_WEB, ConfigurationConstant.STATUS_VALID);
        this.getGitlabLogList(Constants.GROUPS_MEIHAO_SERVICE, ConfigurationConstant.STATUS_VALID);
        this.getGitlabLogList(Constants.GROUPS_OUTSOURCE_DONGHUAN, ConfigurationConstant.STATUS_VALID);
        this.getGitlabLogList(Constants.GROUPS_OUTSOURCE_SHANHAIDA, ConfigurationConstant.STATUS_VALID);
        this.getGitlabLogList(Constants.GROUPS_OUTSOURCE_QINGCHUANGTOU, ConfigurationConstant.STATUS_VALID);
        this.getGitlabLogList(Constants.GROUPS_OUTSOURCE_YUESHISAN, ConfigurationConstant.STATUS_VALID);
        this.getGitlabLogList(Constants.GROUPS_OUTSOURCE_QIANGMULIAN, ConfigurationConstant.STATUS_VALID);
        this.getGitlabLogList(Constants.GROUPS_OUTSOURCE_DGUANGSHE, ConfigurationConstant.STATUS_VALID);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void getGitlabLogList(Integer groupId, Integer type) {
        RestTemplate restTemplate = new RestConfiguration().restTemplate();
        String nodeUrl = "https://git.chinachdu.com/api/v4/groups/" + groupId + "/projects?private_token=pQMBMmurRkVH6zFs6Rxv";
        String response = (String)restTemplate.getForObject(nodeUrl, String.class, new Object[0]);
        List stringList = JSONArray.parseArray((String)response, String.class);
        for (String flie : stringList) {
            Map mapFile = (Map)JSON.parseObject((String)flie, Map.class);
            Integer id = (Integer)mapFile.get("id");
            String branchesUrl = "https://git.chinachdu.com/api/v4/projects/" + id + "/repository/branches?private_token=pQMBMmurRkVH6zFs6Rxv";
            String branchesResponse = (String)restTemplate.getForObject(branchesUrl, String.class, new Object[0]);
            List parseArray = JSONArray.parseArray((String)branchesResponse, String.class);
            for (String parse : parseArray) {
                Map parseMap = (Map)JSON.parseObject((String)parse, Map.class);
                String name = (String)parseMap.get("name");
                String messageUrl = "https://git.chinachdu.com/api/v4/projects/" + id + "/repository/commits?ref_name=" + name + "&private_token=pQMBMmurRkVH6zFs6Rxv";
                String messageResponse = (String)restTemplate.getForObject(messageUrl, String.class, new Object[0]);
                List arrayList = JSONArray.parseArray((String)messageResponse, String.class);
                for (String array : arrayList) {
                    GitlabLogEntity gitlabLog;
                    String currentDateSimpleToString;
                    Date endTime;
                    Date beginTime;
                    Map totalMap = (Map)JSON.parseObject((String)array, Map.class);
                    String createdAt = totalMap.get("created_at").toString().substring(0, 10) + " " + totalMap.get("created_at").toString().substring(11, 19);
                    Date fullDate = DateUtils.stringToFullDate((String)createdAt);
                    boolean calendar = DateUtils.belongCalendar((Date)fullDate, (Date)(beginTime = DateUtils.getDateBefore((Date)(endTime = DateUtils.stringToFullDate((String)((currentDateSimpleToString = DateUtils.getCurrentDateSimpleToString()) + " 21:30:00"))), (int)1)), (Date)endTime);
                    if (!calendar) continue;
                    String commitsId = (String)totalMap.get("id");
                    String commitsResponse = null;
                    String commitsUrl = "https://git.chinachdu.com/api/v4/projects/" + id + "/repository/commits/" + commitsId + "?private_token=pQMBMmurRkVH6zFs6Rxv";
                    try {
                        commitsResponse = (String)restTemplate.getForObject(commitsUrl, String.class, new Object[0]);
                        log.info(id + "==commits==>{}", (Object)commitsResponse);
                    }
                    catch (Exception e) {
                        commitsResponse = (String)restTemplate.getForObject(commitsUrl, String.class, new Object[0]);
                        log.info(id + "==commits==>{}", (Object)commitsResponse);
                    }
                    Map commitsMaps = (Map)JSON.parse((String)commitsResponse);
                    String stats = JSON.toJSONString(commitsMaps.get("stats"));
                    Map statsParse = (Map)JSON.parse((String)stats);
                    if (type.toString().equals(ConfigurationConstant.STATUS_INVALID.toString()) && null != (gitlabLog = this.gitlabLogMapper.selectByProjectId(commitsId)) || type.toString().equals(ConfigurationConstant.STATUS_VALID.toString()) && null != (gitlabLog = this.gitlabLogHappyMapper.selectByProjectId(commitsId))) continue;
                    GitlabLogEntity gitlabLogEntity = new GitlabLogEntity();
                    gitlabLogEntity.setProjectId(commitsId);
                    gitlabLogEntity.setProjectName(mapFile.get("description") + "/" + mapFile.get("name"));
                    gitlabLogEntity.setBranch(name);
                    gitlabLogEntity.setPersonnel((String)totalMap.get("author_name"));
                    gitlabLogEntity.setUploadName((String)totalMap.get("title"));
                    gitlabLogEntity.setSubmitAmount(Long.valueOf(((Integer)statsParse.get("total")).intValue()));
                    log.info("created_at==>{}", (Object)JSON.toJSONString(commitsMaps.get("created_at")));
                    String substring = commitsMaps.get("created_at").toString().substring(0, 10) + " " + commitsMaps.get("created_at").toString().substring(11, 19);
                    gitlabLogEntity.setTime(DateUtils.dateAddHours((Date)DateUtils.stringToFullDate((String)substring), (int)8));
                    if (type.toString().equals(ConfigurationConstant.STATUS_INVALID.toString())) {
                        this.gitlabLogMapper.insert(gitlabLogEntity);
                    }
                    if (!type.toString().equals(ConfigurationConstant.STATUS_VALID.toString())) continue;
                    this.gitlabLogHappyMapper.insert(gitlabLogEntity);
                }
            }
        }
    }

    @Scheduled(cron="0 0 22 * * ?")
    public void sendMail() throws MessagingException {
        this.sendEmail("\u4f70\u533b\u6c47", ConfigurationConstant.STATUS_INVALID);
        this.sendEmail("\u7f8e\u597d\u53ca\u5916\u5305", ConfigurationConstant.STATUS_VALID);
    }

    public void sendEmail(String name, Integer type) throws MessagingException {
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true);
        String currentDateSimple = DateUtils.getCurrentDateSimple();
        helper.setSubject(name + currentDateSimple + "\u63d0\u4ea4\u4ee3\u7801\u7edf\u8ba1");
        helper.setFrom("1043400691@qq.com");
        if (type.toString().equals(ConfigurationConstant.STATUS_INVALID.toString())) {
            helper.setTo("devtl@ebaiyihui.com");
        }
        if (type.toString().equals(ConfigurationConstant.STATUS_VALID.toString())) {
            String[] to = new String[]{"hanxw@ebaiyihui.com", "hefei@ebaiyihui.com"};
            helper.setTo(to);
        }
        helper.setSentDate(new Date());
        helper.setText("\u60a8\u597d\uff0c\u9644\u4ef6\u662fgitLab\u6bcf\u65e5\u63d0\u4ea4\u91cf\u7edf\u8ba1\uff0c\u8bf7\u67e5\u6536\u3002");
        String pash = this.getList(currentDateSimple, name, type);
        helper.addAttachment(name + currentDateSimple + "git\u63d0\u4ea4\u4ee3\u7801\u7edf\u8ba1.xlsx", new File(pash));
        this.javaMailSender.send(mimeMessage);
    }

    private String getList(String currentDateSimple, String name, Integer type) {
        String currentDateSimpleToString = DateUtils.getCurrentDateSimpleToString();
        Date endTime = DateUtils.stringToFullDate((String)(currentDateSimpleToString + " 21:30:00"));
        Date beginTime = DateUtils.getDateBefore((Date)endTime, (int)1);
        String timeStart = DateUtils.dateToSimpleString((Date)beginTime);
        String timeEnd = DateUtils.dateToSimpleString((Date)endTime);
        List byTime = null;
        if (type.toString().equals(ConfigurationConstant.STATUS_INVALID.toString())) {
            byTime = this.gitlabLogMapper.getByTime(timeStart, timeEnd);
        }
        if (type.toString().equals(ConfigurationConstant.STATUS_VALID.toString())) {
            byTime = this.gitlabLogHappyMapper.getByTime(timeStart, timeEnd);
        }
        String studentResourcePath = ExcelUtils.exportExcel((List)byTime, null, null, GitlabLogEntity.class, (String)(name + currentDateSimple + "git\u63d0\u4ea4\u4ee3\u7801\u7edf\u8ba1.xlsx"), (boolean)true);
        log.info("studentResourcePath==>{}", (Object)studentResourcePath);
        return studentResourcePath;
    }
}

