/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.utils;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateNotFoundException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class XmlTemplateKit {
    private static final Logger log = LoggerFactory.getLogger(XmlTemplateKit.class);
    private static final transient Configuration config = new Configuration(Configuration.getVersion());

    public static void init() {
        try {
            String path = XmlTemplateKit.class.getClassLoader().getResource("").getPath();
            log.info("----------------------path->{}", (Object)path);
            config.setClassForTemplateLoading(XmlTemplateKit.class, "/config_xml/");
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u6a21\u677f\u5931\u8d25->{}", (Throwable)e);
        }
        config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        config.setDefaultEncoding("UTF-8");
        config.setOutputEncoding("UTF-8");
        config.setLocale(Locale.CHINA);
        config.setLocalizedLookup(false);
        config.setNumberFormat("#0.#####");
        config.setClassicCompatible(true);
    }

    public static void initTwo() {
        try {
            String path = XmlTemplateKit.class.getClassLoader().getResource("").getPath();
            log.info("----------------------path->{}", (Object)path);
            config.setClassForTemplateLoading(XmlTemplateKit.class, "/config_xml/");
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u6a21\u677f\u5931\u8d25->{}", (Throwable)e);
        }
        config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        config.setDefaultEncoding("UTF-8");
        config.setOutputEncoding("UTF-8");
        config.setLocale(Locale.CHINA);
        config.setLocalizedLookup(false);
        config.setNumberFormat("#0.#####");
        config.setClassicCompatible(true);
    }

    public static String replaceContent(String fileName, String method, LinkedHashMap<String, String> lhp) {
        StringBuffer sb = new StringBuffer();
        String content = "";
        try (BufferedReader br = new BufferedReader(new FileReader("/" + fileName + "/" + method));){
            String line = "";
            while ((line = br.readLine()) != null) {
                content = content + line;
            }
            for (String key : lhp.keySet()) {
                sb.append("{").append(key).append("}");
                content = content.replace(sb.toString(), lhp.get(key));
                sb.delete(0, sb.length());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }

    public static String process(String method, Map rootMap) {
        Writer out = null;
        try {
            String string;
            Template temp = config.getTemplate(method + ".xml");
            out = new StringWriter();
            temp.process((Object)rootMap, out);
            String string2 = string = out.toString();
            return string2;
        }
        catch (TemplateNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String processSql(String method, Map rootMap) {
        Writer out = null;
        try {
            String string;
            Template temp = config.getTemplate("/sql/" + method + ".sql");
            out = new StringWriter();
            temp.process((Object)rootMap, out);
            String string2 = string = out.toString();
            return string2;
        }
        catch (TemplateNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String processFile(String method, Map rootMap) {
        Writer out = null;
        try {
            String string;
            Template temp = config.getTemplate(method);
            out = new StringWriter();
            temp.process((Object)rootMap, out);
            String string2 = string = out.toString();
            return string2;
        }
        catch (TemplateNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String autoReplace(String filePath, LinkedHashMap<String, String> lhp) {
        File file = new File(filePath);
        Long fileLength = file.length();
        byte[] fileContext = new byte[fileLength.intValue()];
        FileInputStream in = null;
        PrintWriter out = null;
        StringBuffer sb = new StringBuffer();
        String str = null;
        try {
            in = new FileInputStream(filePath);
            in.read(fileContext);
            str = new String(fileContext, "utf-8");
            for (String key : lhp.keySet()) {
                sb.append("{").append(key).append("}");
                str = str.replace(sb.toString(), lhp.get(key));
                sb.delete(0, sb.length());
            }
            out = new PrintWriter(filePath);
            out.write(str);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.flush();
                out.close();
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return str;
    }
}

