

CREATE DATABASE `byh-article-service` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;


-- ----------------------------
-- Table structure for area
-- ----------------------------
DROP TABLE IF EXISTS `byh-article-service`.`area`;
CREATE TABLE `byh-article-service`.`area` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `view_id` varchar(64) NOT NULL DEFAULT '',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `area_code` varchar(32) NOT NULL DEFAULT '' COMMENT '区域code',
  `area_name` varchar(32) NOT NULL DEFAULT '' COMMENT '区域名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='区域表';

-- ----------------------------
-- Table structure for article
-- ----------------------------
DROP TABLE IF EXISTS `byh-article-service`.`article`;
CREATE TABLE `byh-article-service`.`article` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `view_id` varchar(64) NOT NULL DEFAULT '',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `title` varchar(256) NOT NULL COMMENT '标题',
  `content` mediumtext CHARACTER SET utf8mb4 NOT NULL COMMENT '文章内容',
  `type` tinyint(4) NOT NULL COMMENT '文章类型 1 新闻资讯 2 消息通知 3 医院头条 4 宣教指导',
  `article_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '文章状态 1待发布 2已发布 3已撤回 4草稿',
  `classify` tinyint(4) NOT NULL DEFAULT '0' COMMENT '文章类型 1 图文 2 视频',
  `author` varchar(32) NOT NULL DEFAULT '' COMMENT '作者',
  `is_top` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否置顶0:否1:是',
  `is_top_time` varchar(256) NOT NULL DEFAULT '' COMMENT '更新置顶状态时间',
  `title_img_url` varchar(256) NOT NULL DEFAULT '' COMMENT '文章封面链接',
  `reading` bigint(20) NOT NULL DEFAULT '0' COMMENT '阅读量',
  `release_time` varchar(32) NOT NULL DEFAULT '' COMMENT '文章发布时间',
  `source` varchar(32) NOT NULL DEFAULT '' COMMENT '来源',
  `source_url` varchar(256) NOT NULL DEFAULT '' COMMENT '来源链接',
  `scheduled_release_time` varchar(32) NOT NULL DEFAULT '' COMMENT '预约发布时间',
  `content_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '内容类型 1 文章 ',
  `like_count` bigint(20) NOT NULL DEFAULT '0' COMMENT '点赞量',
  `content_url` varchar(256) NOT NULL DEFAULT '' COMMENT '文章链接',
  `video_ntroduction` text COMMENT '视频简介',
  `label_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '标签ID',
  `label_name` varchar(32) NOT NULL DEFAULT '' COMMENT '标签名称',
  `area_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '地区ID',
  `area_name` varchar(64) NOT NULL DEFAULT '' COMMENT '地区名称',
  `show_time` varchar(32) NOT NULL DEFAULT '' COMMENT '展示时间',
  `area_level` tinyint(3) NOT NULL DEFAULT '0' COMMENT '地区级别 1 省 2 市  3 区',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='文章表';

-- ----------------------------
-- Table structure for article_accessory
-- ----------------------------
DROP TABLE IF EXISTS `byh-article-service`.`article_accessory`;
CREATE TABLE `byh-article-service`.`article_accessory` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `accessory` varchar(256) NOT NULL DEFAULT '' COMMENT '附件地址',
  `accessory_name` varchar(64) NOT NULL COMMENT '文件名称',
  `article_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '文章ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='文章附件表';

-- ----------------------------
-- Table structure for article_type
-- ----------------------------
DROP TABLE IF EXISTS `byh-article-service`.`article_type`;
CREATE TABLE `byh-article-service`.`article_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `type_name` varchar(32) NOT NULL DEFAULT '' COMMENT '类型名称',
  `port` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='文章类型表';

-- ----------------------------
-- Table structure for comment
-- ----------------------------
DROP TABLE IF EXISTS `byh-article-service`.`comment`;
CREATE TABLE `byh-article-service`.`comment` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '-1:无效1:有效',
  `app_code` varchar(32) DEFAULT NULL,
  `organ_code` varchar(32) DEFAULT NULL,
  `service_id` int(10) DEFAULT '0' COMMENT '所属服务id',
  `article_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '文章id',
  `user_id` varchar(32) NOT NULL DEFAULT '0' COMMENT '用户id',
  `user_name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名称',
  `content` text CHARACTER SET utf8mb4 NOT NULL COMMENT '内容',
  `like_count` int(11) unsigned DEFAULT '0' COMMENT '点赞数',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='评论表';

-- ----------------------------
-- Table structure for comment_reply
-- ----------------------------
DROP TABLE IF EXISTS `byh-article-service`.`comment_reply`;
CREATE TABLE `byh-article-service`.`comment_reply` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '-1:无效1:有效',
  `comment_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '评论id',
  `reply_id` bigint(11) DEFAULT '0' COMMENT '所回复评论id',
  `reply_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '回复类型1-针对评论回复；2-针对回复回复',
  `user_id` varchar(32) NOT NULL DEFAULT '0' COMMENT '用户id',
  `user_name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名称',
  `to_user_id` varchar(32) DEFAULT '0' COMMENT '目标用户id',
  `to_user_name` varchar(50) DEFAULT '' COMMENT '目标用户名称',
  `content` text CHARACTER SET utf8mb4 NOT NULL COMMENT '内容',
  `like_count` int(11) unsigned DEFAULT '0' COMMENT '点赞数',
  `app_code` varchar(32) DEFAULT NULL,
  `organ_code` varchar(32) DEFAULT NULL,
  `service_id` int(10) DEFAULT NULL COMMENT '所属服务id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='评论回复表';

-- ----------------------------
-- Table structure for label
-- ----------------------------
DROP TABLE IF EXISTS `byh-article-service`.`label`;
CREATE TABLE `byh-article-service`.`label` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `label_name` varchar(32) NOT NULL DEFAULT '' COMMENT '标签名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='标签表';

-- ----------------------------
-- Table structure for like_record
-- ----------------------------
DROP TABLE IF EXISTS `byh-article-service`.`like_record`;
CREATE TABLE `byh-article-service`.`like_record` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '-1:无效1:有效',
  `type_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '对应的文章或者评论的id',
  `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '1-文章点赞2-评论点赞3-回复点赞',
  `user_id` varchar(32) NOT NULL DEFAULT '0' COMMENT '用户id',
  `app_code` varchar(32) DEFAULT NULL,
  `organ_code` varchar(32) DEFAULT NULL,
  `service_id` int(10) DEFAULT NULL COMMENT '所属服务id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='点赞记录表';

-- ----------------------------
-- Table structure for port_hos_article
-- ----------------------------
DROP TABLE IF EXISTS `byh-article-service`.`port_hos_article`;
CREATE TABLE `byh-article-service`.`port_hos_article` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `view_id` varchar(64) NOT NULL DEFAULT '',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `port_code` varchar(64) NOT NULL COMMENT '平台code',
  `port_name` varchar(256) NOT NULL COMMENT '平台名称',
  `hos_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '医院ID',
  `hos_name` varchar(256) NOT NULL COMMENT '医院',
  `article_id` bigint(11) NOT NULL COMMENT '文章ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='节点医院文章关联表';

-- ----------------------------
-- Table structure for release_port
-- ----------------------------
DROP TABLE IF EXISTS `byh-article-service`.`release_port`;
CREATE TABLE `byh-article-service`.`release_port` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `view_id` varchar(64) NOT NULL DEFAULT '',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `release_port_code` varchar(32) NOT NULL DEFAULT '' COMMENT '发布端口code',
  `release_port_name` varchar(32) NOT NULL DEFAULT '' COMMENT '发布端口名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='端口表';

-- ----------------------------
-- Table structure for service_info
-- ----------------------------
DROP TABLE IF EXISTS `byh-article-service`.`service_info`;
CREATE TABLE `byh-article-service`.`service_info` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` tinyint(3) NOT NULL DEFAULT '1' COMMENT '状态 1-有效 -1-无效',
  `service_code` varchar(32) NOT NULL DEFAULT '' COMMENT '服务id',
  `gateway_url` varchar(50) NOT NULL DEFAULT '' COMMENT '网关url',
  `service_name` varchar(32) DEFAULT NULL COMMENT '服务名称',
  `app_code` varchar(32) DEFAULT NULL COMMENT '节点名',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='服务枚举表';


CREATE DATABASE `byh-data-statistics` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- ----------------------------
-- Table structure for d_user
-- ----------------------------
DROP TABLE IF EXISTS  `byh-data-statistics`.`d_user`;
CREATE TABLE  `byh-data-statistics`.`d_user` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `hos_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '医院ID',
  `hos_name` varchar(256) NOT NULL COMMENT '医院名称',
  `user_name` varchar(32) NOT NULL DEFAULT '' COMMENT '用户名称',
  `phone` varchar(11) NOT NULL DEFAULT '' COMMENT '用户电话',
  `qr_code_url` varchar(255) NOT NULL DEFAULT '' COMMENT '二维码路径',
  `app_code` varchar(32) NOT NULL DEFAULT '' COMMENT '节点code',
  `type` tinyint(4) NOT NULL COMMENT '类型1:医生 2:运营 3:自然流量',
  `departments` varchar(64) NOT NULL DEFAULT '' COMMENT '所属部门',
  `leader` varchar(32) NOT NULL DEFAULT '' COMMENT '上级领导',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='分销用户表';

-- ----------------------------
-- Table structure for d_user_doc
-- ----------------------------
DROP TABLE IF EXISTS  `byh-data-statistics`.`d_user_doc`;
CREATE TABLE  `byh-data-statistics`.`d_user_doc` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `doc_name` varchar(256) NOT NULL COMMENT '医生名称',
  `doc_id` varchar(32) NOT NULL DEFAULT '0' COMMENT '医生ID',
  `d_user_id` varchar(11) NOT NULL DEFAULT '0' COMMENT '分销用户id',
  `organ_code` varchar(32) NOT NULL DEFAULT '' COMMENT '地区code',
  `app_code` varchar(32) NOT NULL DEFAULT '' COMMENT '节点code',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='分销用户医生关联表';

-- ----------------------------
-- Table structure for d_user_hos
-- ----------------------------
DROP TABLE IF EXISTS  `byh-data-statistics`.`d_user_hos`;
CREATE TABLE  `byh-data-statistics`.`d_user_hos` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `hos_name` varchar(256) NOT NULL COMMENT '医院名称',
  `hos_id` varchar(32) NOT NULL DEFAULT '0' COMMENT '医院ID',
  `d_user_id` varchar(11) NOT NULL DEFAULT '0' COMMENT '分销用户id',
  `organ_code` varchar(255) NOT NULL DEFAULT '' COMMENT '地区code',
  `app_code` varchar(32) NOT NULL DEFAULT '' COMMENT '节点code',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='分销用户医院关联表';

-- ----------------------------
-- Table structure for ewm_log
-- ----------------------------
DROP TABLE IF EXISTS  `byh-data-statistics`.`ewm_log`;
CREATE TABLE  `byh-data-statistics`.`ewm_log` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `open_id` varchar(64) NOT NULL DEFAULT '' COMMENT '微信用户的openId',
  `d_user_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '分销用户的id',
  `app_code` varchar(32) NOT NULL DEFAULT '' COMMENT '节点code',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='微信用户扫码记录表';

-- ----------------------------
-- Table structure for operation
-- ----------------------------
DROP TABLE IF EXISTS  `byh-data-statistics`.`operation`;
CREATE TABLE  `byh-data-statistics`.`operation` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `view_id` varchar(64) NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `operation_name` varchar(64) NOT NULL DEFAULT '' COMMENT '操作名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='操作分类表';

-- ----------------------------
-- Table structure for operation_log
-- ----------------------------
DROP TABLE IF EXISTS  `byh-data-statistics`.`operation_log`;
CREATE TABLE  `byh-data-statistics`.`operation_log` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `open_id` varchar(64) NOT NULL DEFAULT '' COMMENT '微信用户的openId',
  `patient_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '患者ID',
  `patient_name` varchar(32) NOT NULL DEFAULT '' COMMENT '患者名称',
  `patient_phone` varchar(11) NOT NULL DEFAULT '' COMMENT '患者手机号',
  `patient_id_card` varchar(32) NOT NULL DEFAULT '' COMMENT '患者身份证号',
  `operation_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '操作功能ID',
  `operation_name` varchar(64) NOT NULL DEFAULT '' COMMENT '操作路径名称',
  `service_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '服务ID',
  `service_name` varchar(64) NOT NULL COMMENT '服务名称',
  `app_code` varchar(32) NOT NULL DEFAULT '' COMMENT '节点code',
  `d_user_name` varchar(32) NOT NULL DEFAULT '' COMMENT '分销用户名字',
  `d_user_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '分销用户id',
  `d_user_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '分销用户类型',
  `user_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '生成的微信用户的id',
  `order_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '订单id',
  `organ_code` varchar(32) NOT NULL DEFAULT '',
  `order_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单金额',
  `tag` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `appcode_operid_critime` (`app_code`,`operation_id`,`create_time`,`open_id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='操作路径记录表';

-- ----------------------------
-- Table structure for patient_user
-- ----------------------------
DROP TABLE IF EXISTS  `byh-data-statistics`.`patient_user`;
CREATE TABLE  `byh-data-statistics`.`patient_user` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `id_card` varchar(256) NOT NULL COMMENT '身份证号',
  `open_id` varchar(64) NOT NULL DEFAULT '' COMMENT '微信用户openID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='患者用户表';

-- ----------------------------
-- Table structure for service
-- ----------------------------
DROP TABLE IF EXISTS  `byh-data-statistics`.`service`;
CREATE TABLE  `byh-data-statistics`.`service` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `view_id` varchar(64) NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `service_name` varchar(64) NOT NULL DEFAULT '' COMMENT '服务名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='服务分类表';

-- ----------------------------
-- Table structure for wx_user
-- ----------------------------
DROP TABLE IF EXISTS  `byh-data-statistics`.`wx_user`;
CREATE TABLE  `byh-data-statistics`.`wx_user` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `view_id` varchar(64) NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `wx_user_name` varchar(32) NOT NULL DEFAULT '' COMMENT '微信用户名称',
  `wx_user_phone` varchar(11) NOT NULL DEFAULT '' COMMENT '微信用户电话',
  `open_id` varchar(64) NOT NULL DEFAULT '' COMMENT '微信用户的openId',
  `d_user_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '分销用户的id',
  `app_code` varchar(32) NOT NULL DEFAULT '' COMMENT '节点code',
  `user_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '注册生成的用户ID',
  PRIMARY KEY (`id`),
  KEY `open_id` (`open_id`),
  KEY `appcode_creatime` (`app_code`,`create_time`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='微信用户表';


CREATE DATABASE `byh-referral-service` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- ----------------------------
-- Table structure for referral_order
-- ----------------------------
DROP TABLE IF EXISTS  `byh-referral-service`.`referral_order`;
CREATE TABLE  `byh-referral-service`.`referral_order` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '转诊单主键id',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建转诊单时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `order_seq` varchar(32) DEFAULT NULL COMMENT '转诊订单号',
  `launch_hospital_id` varchar(32) DEFAULT NULL COMMENT '发起方医院的编号',
  `launch_hospital_name` varchar(32) DEFAULT NULL COMMENT '发起方医院的名字',
  `launch_hospital_mark` int(2) DEFAULT NULL COMMENT '发起方医院的标识（1.县级医院、2.乡镇级医院）',
  `receive_hospital_id` varchar(32) DEFAULT NULL COMMENT '接收方医院的编号',
  `receive_hospital_name` varchar(32) DEFAULT NULL COMMENT '接收方医院的名字',
  `receive_hospital_mark` int(2) DEFAULT NULL COMMENT '接收医院的标识（1.县级医院、2.乡镇级医院）',
  `receive_department_id` varchar(32) DEFAULT NULL COMMENT '接诊科室编码',
  `receive_department_name` varchar(32) DEFAULT NULL COMMENT '接诊科室名字',
  `receive_doctor_id` varchar(32) DEFAULT NULL COMMENT '接诊医生id',
  `receive_doctor_name` varchar(32) DEFAULT NULL COMMENT '接诊医生的名字',
  `launch_doctor_id` varchar(32) DEFAULT NULL COMMENT '发起转诊医生的id',
  `launch_doctor_name` varchar(32) DEFAULT NULL COMMENT '发起转诊医生的姓名',
  `referral_type` int(2) DEFAULT NULL COMMENT '转诊形式（1.上转 2.下转）',
  `referral_project` int(2) DEFAULT NULL COMMENT '转诊项目（1.住院、2.门诊、3.检查）',
  `fee_type` int(2) DEFAULT NULL COMMENT '费用类别（1.医疗保险、2.公费医疗、3.新农合、4.自费、5.其他）',
  `referral_time` varchar(12) DEFAULT NULL COMMENT '转诊时间 （年月日）',
  `patient_name` varchar(32) DEFAULT NULL COMMENT '患者姓名',
  `patient_gender` int(2) DEFAULT NULL COMMENT '患者性别（1.男2.女）',
  `patient_age` int(6) DEFAULT NULL COMMENT '患者年龄',
  `patient_id_card` varchar(32) DEFAULT NULL COMMENT '患者身份证',
  `patient_phone` varchar(12) DEFAULT NULL COMMENT '患者联系方式',
  `patient_id` varchar(32) DEFAULT NULL COMMENT '患者id',
  `illness_des` varchar(5000) DEFAULT NULL COMMENT '病情描述',
  `referral_suggestion` varchar(5000) DEFAULT NULL COMMENT '转诊建议描述',
  `treatment_des` varchar(5000) DEFAULT NULL COMMENT '目前诊断描述',
  `referral_status` int(2) DEFAULT NULL COMMENT '转诊单状态（1.待签署、2.待审核、3.待接诊、4.待分配、5.已接诊、6.取消. 7.拒绝、8.审批不通过）',
  `launch_doctor_signature` text COMMENT '发起方医生的电子签名',
  `receive_doctor_signature` text COMMENT '接收方医生的电子签名',
  `patient_signature_type` int(2) DEFAULT NULL COMMENT '患者的签名类型：1电子签名2图片签名',
  `patient_electronic_signature` text COMMENT '患者电子签名',
  `patient_picture_signature` varchar(255) DEFAULT NULL COMMENT '患者图片签名',
  `reject_status` int(2) DEFAULT '0' COMMENT '拒绝状态（默认0，未拒绝，拒绝后更新为1）',
  `status` int(2) DEFAULT NULL COMMENT '0删除，1正常',
  `patient_card_no` varchar(32) DEFAULT NULL COMMENT '病人就诊卡号',
  `launch_department_id` varchar(32) DEFAULT NULL COMMENT '发起转诊方科室id',
  `launch_department_name` varchar(32) DEFAULT NULL COMMENT '发起转诊方科室名称',
  `signator_relationship` int(1) DEFAULT NULL COMMENT '签署人与病人关系',
  `app_code` varchar(32) DEFAULT NULL COMMENT 'app_code',
  `lauch_user_id` varchar(32) DEFAULT NULL COMMENT '发起方用户id',
  `receive_app_code` varchar(32) DEFAULT NULL COMMENT '接诊方appCode',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for referral_picture_info
-- ----------------------------
DROP TABLE IF EXISTS  `byh-referral-service`.`referral_picture_info`;
CREATE TABLE  `byh-referral-service`.`referral_picture_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '图片信息表主键',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `description` varchar(5000) DEFAULT NULL COMMENT '描述（包括医嘱信息、病例资料、化验资料、手术记录、康复计划、影像资料）',
  `order_seq` varchar(32) DEFAULT NULL COMMENT '转诊单号',
  `item_type_code` int(2) DEFAULT NULL COMMENT '条目类型编码:1.医嘱信息，2.病例资料 3.化验资料 4.手术记录 5.康复计划 6.影像资料',
  `url` text COMMENT '图片地址',
  `status` int(2) DEFAULT NULL COMMENT '0删除，1正常',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;


CREATE DATABASE `byh-remot-image` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- ----------------------------
-- Table structure for check_standard
-- ----------------------------
DROP TABLE IF EXISTS  `byh-remot-image`.`check_standard`;
CREATE TABLE  `byh-remot-image`.`check_standard` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `check_name` varchar(64) NOT NULL DEFAULT '' COMMENT '名称',
  `type` tinyint(6) NOT NULL DEFAULT '0' COMMENT '类别 1检查类型 2检查部位 3检查项目 4扫描类型 5病情映像',
  `check_type_parent_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '检查类型id(父)',
  `check_part_parent_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '检查部位id(父)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='检查类型相关表';

-- ----------------------------
-- Table structure for remote_image_order
-- ----------------------------
DROP TABLE IF EXISTS  `byh-remot-image`.`remote_image_order`;
CREATE TABLE  `byh-remot-image`.`remote_image_order` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `view_id` varchar(64) NOT NULL DEFAULT '',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `order_status` tinyint(6) NOT NULL DEFAULT '0' COMMENT '订单状态',
  `patient_no_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '就诊卡id',
  `patient_no_card` varchar(64) NOT NULL DEFAULT '' COMMENT '就诊卡卡号',
  `patient_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '患者id',
  `patient_name` varchar(32) NOT NULL DEFAULT '' COMMENT '患者姓名',
  `patient_id_card` varchar(32) NOT NULL DEFAULT '' COMMENT '患者身份证号',
  `patient_phone` varchar(11) NOT NULL DEFAULT '' COMMENT '患者手机号',
  `patient_age` tinyint(4) NOT NULL DEFAULT '0' COMMENT '患者年龄',
  `patient_sex` tinyint(4) NOT NULL DEFAULT '0' COMMENT '患者性别 1 男 2 女',
  `register_time` varchar(64) NOT NULL DEFAULT '' COMMENT '登记时间',
  `is_emergency` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否为急诊 0 非急诊 1 急诊',
  `check_type_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '检查类型id',
  `check_type_name` varchar(32) NOT NULL DEFAULT '' COMMENT '检查类型名称',
  `check_part_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '检查部位id',
  `check_part_name` varchar(32) NOT NULL DEFAULT '' COMMENT '检查部位名称',
  `check_item_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '检查项目id',
  `check_item_name` varchar(64) NOT NULL DEFAULT '' COMMENT '检查项目名称',
  `check_scanning_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '扫描方式',
  `check_scanning_name` varchar(32) NOT NULL DEFAULT '' COMMENT '扫描方式名称',
  `disease_image_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '疾病映像id',
  `disease_image_name` varchar(32) NOT NULL DEFAULT '' COMMENT '疾病映像名称',
  `masculine` tinyint(4) NOT NULL DEFAULT '0' COMMENT '阴阳性 1阴性 2阳性',
  `risk_value` tinyint(4) NOT NULL DEFAULT '0' COMMENT '危险性 1上报 2不上报',
  `dcm_filr_url` text NOT NULL COMMENT 'dcm文件路径',
  `dcm_pack_url` varchar(256) NOT NULL DEFAULT '' COMMENT 'dcm压缩包路径',
  `report_content` text NOT NULL COMMENT '诊断结果(文本)',
  `report_url` varchar(256) NOT NULL DEFAULT '' COMMENT '诊断结果(文件链接)',
  `doctor_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '医生id',
  `doctor_name` varchar(32) NOT NULL DEFAULT '' COMMENT '医生姓名',
  `doc_hospital_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '医生医院id',
  `doc_hospital_name` varchar(64) NOT NULL DEFAULT '' COMMENT '医生医院名称',
  `expert_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '专家id',
  `expert_name` varchar(32) NOT NULL DEFAULT '' COMMENT '专家姓名',
  `expert_hospital_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '专家医院id',
  `expert_hospital_name` varchar(64) NOT NULL DEFAULT '' COMMENT '专家医院名称',
  `expert_first_dep_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '专家一级科室id',
  `expert_first_dep_name` varchar(32) NOT NULL DEFAULT '' COMMENT '专家一级科室名称',
  `expert_second_dep_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '专家二级科室id',
  `expert_second_dep_name` varchar(32) NOT NULL DEFAULT '' COMMENT '专家二级科室名称',
  `exp_hos_dep_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '专家医院科室id',
  `exp_hos_dep_name` varchar(64) NOT NULL COMMENT '专家医院科室名称',
  `expert_signature` varchar(256) NOT NULL COMMENT '专家签名链接',
  `application_channels` tinyint(4) NOT NULL DEFAULT '0' COMMENT '下单渠道 10医联体下单',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='远程影像订单表';


CREATE DATABASE `byh-remote-lecture` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;


-- ----------------------------
-- Table structure for course_evaluate
-- ----------------------------
DROP TABLE IF EXISTS `byh-remote-lecture`.`course_evaluate`;
CREATE TABLE  `byh-remote-lecture`.`course_evaluate` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `course_id` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '课程id',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '评价人id',
  `user_name` varchar(255) NOT NULL DEFAULT '' COMMENT '评价人姓名',
  `score` tinyint(4) unsigned NOT NULL DEFAULT '0' COMMENT '评价分数',
  `comment` varchar(512) NOT NULL DEFAULT '' COMMENT '评价内容',
  `evaluate_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '评价时间',
  `status` tinyint(16) NOT NULL DEFAULT '1' COMMENT '评价状态,-1:删除,1:正常',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='课程评价表';

-- ----------------------------
-- Table structure for course_info
-- ----------------------------
DROP TABLE IF EXISTS `byh-remote-lecture`.`course_info`;
CREATE TABLE  `byh-remote-lecture`.`course_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '课程管理id',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `doctor_id` bigint(20) NOT NULL COMMENT '开课医师id',
  `course_price` decimal(20,2) NOT NULL DEFAULT '0.00' COMMENT '课程价格',
  `state` tinyint(16) NOT NULL DEFAULT '0' COMMENT '课程状态,1:可报名,2:直播中,3:可回放',
  `introduce` varchar(2048) NOT NULL DEFAULT '' COMMENT '课程介绍',
  `video_cover` varchar(560) NOT NULL DEFAULT '' COMMENT '课程封面',
  `duration` varchar(64) DEFAULT '0' COMMENT '预计课程时长',
  `actual_duration` varchar(64) NOT NULL DEFAULT '0' COMMENT '实际课程时长',
  `video_links` text NOT NULL COMMENT '课程链接',
  `room_number` varchar(36) NOT NULL DEFAULT '' COMMENT '房间号',
  `status` tinyint(16) NOT NULL DEFAULT '1' COMMENT '上下架状态,0:下架,1:正常',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  `course_name` varchar(255) NOT NULL DEFAULT '' COMMENT '课程名称',
  `opening_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '开始时间',
  `visitors_number` varchar(20) NOT NULL DEFAULT '0' COMMENT '观看人数',
  `end_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT ' 预计结束时间',
  `doctor_name` varchar(20) NOT NULL DEFAULT '' COMMENT '医生姓名',
  `course_uuid` char(32) DEFAULT '' COMMENT '创建房间所用的唯一uuid',
  `real_opening_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '真正开课时间',
  `group_id` varchar(20) DEFAULT '' COMMENT '群组ID',
  `app_code` varchar(20) NOT NULL DEFAULT '' COMMENT '医生节点信息',
  `video_type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '1:直播,2:录播',
  `course_type` tinyint(10) DEFAULT '1' COMMENT '1:不区分类型',
  `courseware` text COMMENT '课件',
  `course_ware_name` varchar(255) DEFAULT NULL COMMENT '课件名字',
  `organ_id` bigint(20) DEFAULT NULL COMMENT '医院id',
  `organ_name` varchar(255) DEFAULT NULL COMMENT '医院名称',
  `period_number` int(10) DEFAULT '0' COMMENT '课节数量',
  `timeInterval_time` datetime DEFAULT NULL COMMENT '定时发布时间',
  `release_port` tinyint(4) DEFAULT '1' COMMENT '发布端口 1 医生端 2 患者端',
  `regular_release` int(20) DEFAULT '1' COMMENT '是否是定时发布(标识列) 1:否  0:是',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for course_management
-- ----------------------------
DROP TABLE IF EXISTS `byh-remote-lecture`.`course_management`;
CREATE TABLE  `byh-remote-lecture`.`course_management` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '下架id',
  `course_id` bigint(20) NOT NULL COMMENT '课程id',
  `process_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '下架时间',
  `process_reason` varchar(255) NOT NULL COMMENT '下架原因',
  `operator` bigint(20) NOT NULL DEFAULT '0' COMMENT '操作人',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `status` tinyint(16) NOT NULL DEFAULT '0' COMMENT '状态,0:下架,1:取消下架',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for course_order
-- ----------------------------
DROP TABLE IF EXISTS `byh-remote-lecture`.`course_order`;
CREATE TABLE  `byh-remote-lecture`.`course_order` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '订单详情ID',
  `view_id` varchar(36) NOT NULL DEFAULT '' COMMENT '提交给支付接口ID',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `course_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '课程Id',
  `status` tinyint(5) NOT NULL DEFAULT '0' COMMENT '订单支付状态,-1:未支付,1:已支付',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '价格',
  `doctor_id` bigint(11) NOT NULL DEFAULT '0' COMMENT '医师ID',
  `subscriber_id` bigint(32) NOT NULL DEFAULT '0' COMMENT '订阅人ID',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  `app_code` varchar(20) NOT NULL DEFAULT '' COMMENT '节点code',
  `order_source` tinyint(5) DEFAULT '1' COMMENT '订单来源 1 医生 2 患者',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for course_permissions
-- ----------------------------
DROP TABLE IF EXISTS `byh-remote-lecture`.`course_permissions`;
CREATE TABLE  `byh-remote-lecture`.`course_permissions` (
  `permissions_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '权限Id 主键',
  `course_id` int(11) NOT NULL COMMENT '课程Id',
  `permissions_platform` longtext COMMENT '权限平台:当前课程允许的平台,存放当前平台的id,用,分割',
  `permissions_hospital` longtext NOT NULL COMMENT '权限医院:当前课程允许的医院:主要以当前医院列做主要判断,存放当前医院的organId,用,分割',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`permissions_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for course_signs
-- ----------------------------
DROP TABLE IF EXISTS `byh-remote-lecture`.`course_signs`;
CREATE TABLE  `byh-remote-lecture`.`course_signs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `states` tinyint(4) DEFAULT '1' COMMENT '状态: 1:正常,-1:删除',
  `course_id` bigint(20) DEFAULT NULL COMMENT '课程id',
  `credit_number` varchar(128) DEFAULT NULL COMMENT '学分卡号',
  `doctor_id` bigint(20) DEFAULT NULL COMMENT '听课医生id',
  `start_signs` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '课前签到',
  `middle_signs` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '课中签到',
  `end_signs` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '直播退出时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='课程签到表';

-- ----------------------------
-- Table structure for learn_time
-- ----------------------------
DROP TABLE IF EXISTS `byh-remote-lecture`.`learn_time`;
CREATE TABLE  `byh-remote-lecture`.`learn_time` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '学习时长Id',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  `subscriber_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '订阅人',
  `day_date` date DEFAULT NULL COMMENT '日期',
  `status` tinyint(5) NOT NULL DEFAULT '0' COMMENT '状态,-1:不可用,1:可用',
  `duration` varchar(20) NOT NULL DEFAULT '' COMMENT '学习时长',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for video_study_record
-- ----------------------------
DROP TABLE IF EXISTS `byh-remote-lecture`.`video_study_record`;
CREATE TABLE  `byh-remote-lecture`.`video_study_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `status` tinyint(5) DEFAULT '1' COMMENT '状态: 1:正常,-1:删除',
  `course_id` bigint(20) DEFAULT NULL COMMENT '课程id',
  `doctor_id` bigint(20) DEFAULT NULL COMMENT '医生id',
  `course_number` int(10) DEFAULT NULL COMMENT '课节编号',
  `subscriber_id` bigint(20) DEFAULT NULL COMMENT '订阅人id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='学习课程记录表';

CREATE DATABASE `byh-xxl-job` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- ----------------------------
-- Table structure for xxl_job_group
-- ----------------------------
DROP TABLE IF EXISTS `byh-xxl-job`.`xxl_job_group`;
CREATE TABLE `byh-xxl-job`.`xxl_job_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_name` varchar(64) NOT NULL COMMENT '执行器AppName',
  `title` varchar(12) NOT NULL COMMENT '执行器名称',
  `order` tinyint(4) NOT NULL DEFAULT '0' COMMENT '排序',
  `address_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '执行器地址类型：0=自动注册、1=手动录入',
  `address_list` varchar(512) DEFAULT NULL COMMENT '执行器地址列表，多地址逗号分隔',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for xxl_job_info
-- ----------------------------
DROP TABLE IF EXISTS `byh-xxl-job`.`xxl_job_info`;
CREATE TABLE `byh-xxl-job`.`xxl_job_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `job_group` int(11) NOT NULL COMMENT '执行器主键ID',
  `job_cron` varchar(128) NOT NULL COMMENT '任务执行CRON',
  `job_desc` varchar(255) NOT NULL,
  `add_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `author` varchar(64) DEFAULT NULL COMMENT '作者',
  `alarm_email` varchar(255) DEFAULT NULL COMMENT '报警邮件',
  `executor_route_strategy` varchar(50) DEFAULT NULL COMMENT '执行器路由策略',
  `executor_handler` varchar(255) DEFAULT NULL COMMENT '执行器任务handler',
  `executor_param` varchar(512) DEFAULT NULL COMMENT '执行器任务参数',
  `executor_block_strategy` varchar(50) DEFAULT NULL COMMENT '阻塞处理策略',
  `executor_timeout` int(11) NOT NULL DEFAULT '0' COMMENT '任务执行超时时间，单位秒',
  `executor_fail_retry_count` int(11) NOT NULL DEFAULT '0' COMMENT '失败重试次数',
  `glue_type` varchar(50) NOT NULL COMMENT 'GLUE类型',
  `glue_source` mediumtext COMMENT 'GLUE源代码',
  `glue_remark` varchar(128) DEFAULT NULL COMMENT 'GLUE备注',
  `glue_updatetime` datetime DEFAULT NULL COMMENT 'GLUE更新时间',
  `child_jobid` varchar(255) DEFAULT NULL COMMENT '子任务ID，多个逗号分隔',
  `trigger_status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '调度状态：0-停止，1-运行',
  `trigger_last_time` bigint(13) NOT NULL DEFAULT '0' COMMENT '上次调度时间',
  `trigger_next_time` bigint(13) NOT NULL DEFAULT '0' COMMENT '下次调度时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for xxl_job_lock
-- ----------------------------
DROP TABLE IF EXISTS `byh-xxl-job`.`xxl_job_lock`;
CREATE TABLE `byh-xxl-job`.`xxl_job_lock` (
  `lock_name` varchar(50) NOT NULL COMMENT '锁名称',
  PRIMARY KEY (`lock_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for xxl_job_log
-- ----------------------------
DROP TABLE IF EXISTS `byh-xxl-job`.`xxl_job_log`;
CREATE TABLE `byh-xxl-job`.`xxl_job_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `job_group` int(11) NOT NULL COMMENT '执行器主键ID',
  `job_id` int(11) NOT NULL COMMENT '任务，主键ID',
  `executor_address` varchar(255) DEFAULT NULL COMMENT '执行器地址，本次执行的地址',
  `executor_handler` varchar(255) DEFAULT NULL COMMENT '执行器任务handler',
  `executor_param` varchar(512) DEFAULT NULL COMMENT '执行器任务参数',
  `executor_sharding_param` varchar(20) DEFAULT NULL COMMENT '执行器任务分片参数，格式如 1/2',
  `executor_fail_retry_count` int(11) NOT NULL DEFAULT '0' COMMENT '失败重试次数',
  `trigger_time` datetime DEFAULT NULL COMMENT '调度-时间',
  `trigger_code` int(11) NOT NULL COMMENT '调度-结果',
  `trigger_msg` text COMMENT '调度-日志',
  `handle_time` datetime DEFAULT NULL COMMENT '执行-时间',
  `handle_code` int(11) NOT NULL COMMENT '执行-状态',
  `handle_msg` text COMMENT '执行-日志',
  `alarm_status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '告警状态：0-默认、1-无需告警、2-告警成功、3-告警失败',
  PRIMARY KEY (`id`),
  KEY `I_trigger_time` (`trigger_time`),
  KEY `I_handle_code` (`handle_code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for xxl_job_logglue
-- ----------------------------
DROP TABLE IF EXISTS `byh-xxl-job`.`xxl_job_logglue`;
CREATE TABLE `byh-xxl-job`.`xxl_job_logglue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `job_id` int(11) NOT NULL COMMENT '任务，主键ID',
  `glue_type` varchar(50) DEFAULT NULL COMMENT 'GLUE类型',
  `glue_source` mediumtext COMMENT 'GLUE源代码',
  `glue_remark` varchar(128) NOT NULL COMMENT 'GLUE备注',
  `add_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for xxl_job_registry
-- ----------------------------
DROP TABLE IF EXISTS `byh-xxl-job`.`xxl_job_registry`;
CREATE TABLE `byh-xxl-job`.`xxl_job_registry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `registry_group` varchar(255) NOT NULL,
  `registry_key` varchar(255) NOT NULL,
  `registry_value` varchar(255) NOT NULL,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `i_g_k_v` (`registry_group`,`registry_key`,`registry_value`),
  KEY `i_u` (`update_time`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for xxl_job_user
-- ----------------------------
DROP TABLE IF EXISTS `byh-xxl-job`.`xxl_job_user`;
CREATE TABLE `byh-xxl-job`.`xxl_job_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL COMMENT '账号',
  `password` varchar(50) NOT NULL COMMENT '密码',
  `role` tinyint(4) NOT NULL COMMENT '角色：0-普通用户、1-管理员',
  `permission` varchar(255) DEFAULT NULL COMMENT '权限：执行器ID列表，多个逗号分割',
  PRIMARY KEY (`id`),
  UNIQUE KEY `i_username` (`username`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;


CREATE DATABASE `byh_aggregation_payment` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- ----------------------------
-- Table structure for mch_chan
-- ----------------------------
DROP TABLE IF EXISTS `byh_aggregation_payment`.`mch_chan`;
CREATE TABLE `byh_aggregation_payment`.`mch_chan` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `mch_id` bigint(11) DEFAULT NULL COMMENT '商户id',
  `chan_id` bigint(11) DEFAULT NULL COMMENT '渠道id',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `status` int(4) DEFAULT NULL COMMENT '状态 1正常,-1停用',
  `type` varchar(255) DEFAULT NULL COMMENT '类型',
  `param` text COMMENT '参数',
  `merchants_mark` varchar(255) DEFAULT NULL COMMENT '支付平台商户id',
  `mch_name` varchar(255) DEFAULT NULL,
  `mch_code` varchar(255) DEFAULT NULL,
  `chan_code` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='商户渠道参数表';

-- ----------------------------
-- Table structure for pay_bill
-- ----------------------------
DROP TABLE IF EXISTS `byh_aggregation_payment`.`pay_bill`;
CREATE TABLE `byh_aggregation_payment`.`pay_bill` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `out_trade_no` varchar(255) DEFAULT NULL COMMENT '商户订单号',
  `deal_trade_no` varchar(255) DEFAULT NULL COMMENT '平台交易号',
  `trade_no` varchar(255) DEFAULT NULL COMMENT '系统流水号',
  `order_amount` decimal(10,2) DEFAULT NULL COMMENT '订单金额',
  `deal_amount` decimal(10,2) DEFAULT NULL COMMENT '交易金额',
  `trade_channel` varchar(255) DEFAULT NULL COMMENT '交易渠道',
  `trade_type` varchar(255) DEFAULT NULL COMMENT '交易类型',
  `refund_amount` decimal(10,2) DEFAULT NULL COMMENT '退款金额',
  `pay_time` timestamp NULL DEFAULT NULL COMMENT '交易时间',
  `goods_info` varchar(255) DEFAULT NULL COMMENT '商品信息',
  `mch_code` varchar(255) DEFAULT NULL COMMENT '商户号',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '订单生成时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '订单更新时间',
  `status` int(4) DEFAULT NULL COMMENT '状态 0未知，1待支付，2支付中，3已支付，4支付失败，5退款中，6已退款，7退款失败',
  `service_code` varchar(255) DEFAULT NULL COMMENT '业务编码',
  `refund_time` timestamp NULL DEFAULT NULL,
  `refund_no` varchar(255) DEFAULT NULL,
  `out_refund_no` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='账单表';

-- ----------------------------
-- Table structure for pay_callback
-- ----------------------------
DROP TABLE IF EXISTS `byh_aggregation_payment`.`pay_callback`;
CREATE TABLE `byh_aggregation_payment`.`pay_callback` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `service_code` varchar(255) DEFAULT NULL COMMENT '服务编码',
  `service_order_code` varchar(255) DEFAULT NULL COMMENT '服务订单编码',
  `service_name` varchar(255) DEFAULT NULL COMMENT '服务名',
  `pay_notify_url` text COMMENT '支付回调地址',
  `refund_notify_url` text COMMENT '退款回调地址',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` int(4) DEFAULT NULL COMMENT '状态 1正常,-1停用',
  `mch_code` varchar(255) DEFAULT NULL COMMENT '商户编码',
  `mch_name` varchar(255) DEFAULT NULL COMMENT '商户名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='服务回调通知地址';

-- ----------------------------
-- Table structure for pay_chan
-- ----------------------------
DROP TABLE IF EXISTS `byh_aggregation_payment`.`pay_chan`;
CREATE TABLE `byh_aggregation_payment`.`pay_chan` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) DEFAULT NULL COMMENT '渠道名称',
  `code` varchar(255) DEFAULT NULL COMMENT '渠道编码',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` int(4) DEFAULT NULL COMMENT '状态 1正常,-1停用',
  `logo` varchar(255) DEFAULT NULL COMMENT '支付渠道logo',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='渠道表';

-- ----------------------------
-- Table structure for pay_mch
-- ----------------------------
DROP TABLE IF EXISTS `byh_aggregation_payment`.`pay_mch`;
CREATE TABLE `byh_aggregation_payment`.`pay_mch` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) DEFAULT NULL COMMENT '商户名称',
  `code` varchar(255) DEFAULT NULL COMMENT '商户编码',
  `number` varchar(255) DEFAULT NULL COMMENT '商户号',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '新增时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `status` int(4) DEFAULT '1' COMMENT '状态 1正常,-1停用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='商户表';

-- ----------------------------
-- Table structure for payment_records
-- ----------------------------
DROP TABLE IF EXISTS `byh_aggregation_payment`.`payment_records`;
CREATE TABLE `byh_aggregation_payment`.`payment_records` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `out_trade_no` varchar(255) DEFAULT NULL COMMENT '订单号',
  `service_code` varchar(255) DEFAULT NULL COMMENT '服务编号',
  `results` int(4) DEFAULT NULL COMMENT '操作结果',
  `remark` varchar(255) DEFAULT NULL COMMENT '操作备注',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` int(4) DEFAULT NULL COMMENT '状态 0未知,1未支付,2支付完成,3取消,4退款,5回调中,6回调成功,7回调失败',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='支付记录表';

-- ----------------------------
-- Table structure for trade_no_test
-- ----------------------------
DROP TABLE IF EXISTS `byh_aggregation_payment`.`trade_no_test`;
CREATE TABLE `byh_aggregation_payment`.`trade_no_test` (
  `trade_no` varchar(225) DEFAULT NULL,
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;



CREATE DATABASE `ca_service` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- ----------------------------
-- Table structure for ca_diagnosis
-- ----------------------------
DROP TABLE IF EXISTS `ca_service`.`ca_diagnosis`;
CREATE TABLE `ca_service`.`ca_diagnosis` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `ur_id` varchar(32) DEFAULT NULL COMMENT '处方ID',
  `case_uid` varchar(50) DEFAULT NULL COMMENT '影像号',
  `depart_ment` varchar(255) DEFAULT NULL COMMENT '科室',
  `inpatient_num` varchar(50) DEFAULT NULL COMMENT '住院号',
  `bed_no` varchar(255) DEFAULT NULL COMMENT '床号',
  `mt` varchar(255) DEFAULT NULL COMMENT '设备类型',
  `body_part` varchar(255) DEFAULT NULL COMMENT '检查项目',
  `conclusion` varchar(255) DEFAULT NULL COMMENT '检查所见',
  `finding` varchar(255) DEFAULT NULL COMMENT '诊断所见',
  `audit_user` varchar(255) DEFAULT NULL COMMENT '诊断医生',
  `report_user` varchar(255) DEFAULT NULL COMMENT '报告医生',
  `report_time` varchar(255) DEFAULT NULL COMMENT '报告日期',
  `submit_time` varchar(255) DEFAULT NULL COMMENT '检查日期',
  `hosipital_address` varchar(255) DEFAULT NULL COMMENT '医院地址',
  `hosipital_name` varchar(255) DEFAULT NULL COMMENT '医院名称',
  `hosipital_phone` varchar(255) DEFAULT NULL COMMENT '医院号码',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态（1-生效 0-不生效）',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for ca_doctor
-- ----------------------------
DROP TABLE IF EXISTS `ca_service`.`ca_doctor`;
CREATE TABLE `ca_service`.`ca_doctor` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `doctor_id` varchar(50) DEFAULT NULL COMMENT '医生id',
  `doctor_name` varchar(32) DEFAULT '' COMMENT '医生姓名',
  `open_id` varchar(200) DEFAULT NULL COMMENT '医网信医师唯一标识',
  `phone` varchar(32) DEFAULT '' COMMENT '手机号',
  `user_status` tinyint(4) DEFAULT '-1' COMMENT '用户同步状态（-1：未审核 0：身份审核通过 1：证书签发 2：设置签章 3：用户注销 4：申请拒绝 5：用户停用 6：修改手机号 7：用户启用）',
  `stamp_status` tinyint(4) DEFAULT NULL COMMENT '签章状态（10：待审核 11：签章审核通过）',
  `stamp` text COMMENT '签章',
  `status_time` datetime DEFAULT NULL COMMENT '状态变更时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `organ_code` varchar(32) DEFAULT NULL COMMENT '机构编码',
  `uid` varchar(32) DEFAULT NULL COMMENT '证件号码',
  `uid_card_type` varchar(32) DEFAULT NULL COMMENT '证件类型',
  `title` varchar(255) DEFAULT '' COMMENT '医生职称',
  `department` varchar(255) DEFAULT '' COMMENT '科室',
  `department_second` varchar(255) DEFAULT NULL COMMENT '二级科室',
  `org_name` varchar(255) DEFAULT '' COMMENT '所在医院',
  `doctor_type` varchar(255) DEFAULT '' COMMENT '资格证类型',
  `issue_time` varchar(32) DEFAULT NULL COMMENT '颁发时间',
  `valid_time` varchar(32) DEFAULT NULL COMMENT '有效时间',
  `issue_org` varchar(255) DEFAULT '' COMMENT '颁发机构',
  `note` text COMMENT '审核拒绝原因/证书信息',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态（1-生效 0-不生效）',
  `platform` varchar(50) DEFAULT NULL COMMENT '区分不同的CA平台',
  `hospital_id` bigint(20) DEFAULT NULL COMMENT '医院ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for ca_doctor_notify
-- ----------------------------
DROP TABLE IF EXISTS `ca_service`.`ca_doctor_notify`;
CREATE TABLE `ca_service`.`ca_doctor_notify` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `open_id` varchar(50) DEFAULT NULL COMMENT '医网信医师唯一标识',
  `phone_num` varchar(50) DEFAULT NULL COMMENT '手机号',
  `user_status` tinyint(4) DEFAULT '-1' COMMENT '用户同步状态（-1：未审核 0：身份审核通过 1：证书签发 2：设置签章 3：用户注销 4：申请拒绝 5：用户停用 6：修改手机号 7：用户启用）',
  `note` text COMMENT '审核拒绝原因/证书信息',
  `stamp` text COMMENT '签章',
  `stamp_status` tinyint(4) DEFAULT NULL COMMENT '签章状态（10：待审核 11：签章审核通过）',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态（1-生效 0-不生效）',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for ca_free_pin_sign
-- ----------------------------
DROP TABLE IF EXISTS `ca_service`.`ca_free_pin_sign`;
CREATE TABLE `ca_service`.`ca_free_pin_sign` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `effective_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '有效时间',
  `doctor_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '医生id',
  `organ_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '医院id',
  `app_code` varchar(255) NOT NULL DEFAULT '' COMMENT '平台code',
  `pin_code` varchar(255) NOT NULL DEFAULT '' COMMENT 'pin码',
  `status` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `organ_id` (`organ_id`,`doctor_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for ca_medical_record
-- ----------------------------
DROP TABLE IF EXISTS `ca_service`.`ca_medical_record`;
CREATE TABLE `ca_service`.`ca_medical_record` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `ur_id` varchar(32) DEFAULT NULL COMMENT '处方ID',
  `visiting_time` datetime DEFAULT NULL COMMENT '就诊时间',
  `depart_ment` varchar(255) DEFAULT NULL COMMENT '科室',
  `out_num` varchar(50) DEFAULT NULL COMMENT '门诊号',
  `treatment` varchar(255) DEFAULT NULL COMMENT '费别',
  `complaint` text COMMENT '主诉',
  `history_now` text COMMENT '现病史',
  `history_disease` text COMMENT '即病史',
  `history_allergy` text COMMENT '过敏史',
  `supple_exam` text COMMENT '辅助检查',
  `diagnosis` text COMMENT '诊断',
  `opinion` text COMMENT '处理意见',
  `entrust` text COMMENT '嘱托',
  `physical_condition` text COMMENT '全身体状况及其他',
  `treat_plan` text COMMENT '治疗计划',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态（1-生效 0-不生效）',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for ca_medicine
-- ----------------------------
DROP TABLE IF EXISTS `ca_service`.`ca_medicine`;
CREATE TABLE `ca_service`.`ca_medicine` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) DEFAULT NULL COMMENT '药品名称',
  `standard` varchar(255) DEFAULT NULL COMMENT '药品规格',
  `dosage` varchar(255) DEFAULT NULL COMMENT '用量',
  `unit` varchar(255) DEFAULT NULL COMMENT '药品单位',
  `usage` text COMMENT '用法',
  `frequency` varchar(255) DEFAULT NULL COMMENT '频次',
  `days` int(10) DEFAULT NULL COMMENT '天数',
  `quantity` int(10) DEFAULT NULL COMMENT '数量',
  `unit_of` varchar(50) DEFAULT NULL COMMENT '剂量单位',
  `price` decimal(10,2) DEFAULT NULL COMMENT '药品单价',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态（1-生效 0-不生效）',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for ca_public
-- ----------------------------
DROP TABLE IF EXISTS `ca_service`.`ca_public`;
CREATE TABLE `ca_service`.`ca_public` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `ur_id` varchar(32) DEFAULT NULL COMMENT '处方id',
  `unique_id` varchar(50) DEFAULT '' COMMENT '医网签处方唯一标识',
  `open_id` varchar(50) DEFAULT '' COMMENT '医网信医师唯一标识',
  `template_id` varchar(32) DEFAULT '' COMMENT '模板id',
  `patient_id` varchar(50) DEFAULT '' COMMENT '患者id',
  `subject` varchar(255) DEFAULT '' COMMENT '第三方签名信息主题',
  `recipe_time` datetime DEFAULT NULL COMMENT '开具时间',
  `sign_status` tinyint(4) NOT NULL DEFAULT '-1' COMMENT '签名订单状态（2:已签名 6:拒绝签名 7:签名订单已过期删除 9:已签名订单作废 ）',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态（1-生效 0-不生效）',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `organ_code` varchar(32) DEFAULT NULL COMMENT '机构编码',
  `hospital_id` bigint(20) DEFAULT NULL COMMENT '医院ID',
  `client_id` varchar(30) DEFAULT NULL COMMENT '客户端标识',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for ca_recipe
-- ----------------------------
DROP TABLE IF EXISTS `ca_service`.`ca_recipe`;
CREATE TABLE `ca_service`.`ca_recipe` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `ur_id` varchar(32) DEFAULT NULL COMMENT '处方ID',
  `pathogeny` text COMMENT '患者病因',
  `diagnose` text COMMENT '医生诊断',
  `recipe_term` int(10) DEFAULT NULL COMMENT '处方时效单位：天',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态（1-生效 0-不生效）',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for ca_recipe_medicine
-- ----------------------------
DROP TABLE IF EXISTS `ca_service`.`ca_recipe_medicine`;
CREATE TABLE `ca_service`.`ca_recipe_medicine` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `recipe_id` int(11) DEFAULT NULL COMMENT '处方id',
  `medicine_id` int(11) DEFAULT NULL COMMENT '药品id',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态（1-生效 0-不生效）',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for ca_recipe_notify
-- ----------------------------
DROP TABLE IF EXISTS `ca_service`.`ca_recipe_notify`;
CREATE TABLE `ca_service`.`ca_recipe_notify` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `ur_id` varchar(32) DEFAULT NULL COMMENT '处方id',
  `unique_id` varchar(50) DEFAULT NULL COMMENT '医网签处方唯一标识',
  `open_id` varchar(50) DEFAULT NULL COMMENT '医网信医师唯一标识',
  `signed_data` text COMMENT '处方哈希的p7签名',
  `sign_pdf_base` text COMMENT 'pdf文件流',
  `reason` text COMMENT '拒绝签名原因',
  `sign_status` tinyint(4) NOT NULL DEFAULT '-1' COMMENT '签名订单状态（2:已签名 6:拒绝签名 7:签名订单已过期删除 9:已签名订单作废 ）',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态（1-生效 0-不生效）',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for ca_viewport
-- ----------------------------
DROP TABLE IF EXISTS `ca_service`.`ca_viewport`;
CREATE TABLE `ca_service`.`ca_viewport` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `ur_id` varchar(32) DEFAULT NULL COMMENT '处方ID',
  `clinical_sysmpton` text COMMENT '临床表现',
  `clinical_diagnosis` text COMMENT '临床印象',
  `exam_modality` varchar(255) DEFAULT NULL COMMENT '检查类型',
  `exam_bodypart` varchar(255) DEFAULT NULL COMMENT '检查部位',
  `exam_procedurestep_name` varchar(255) DEFAULT NULL COMMENT '检查方法',
  `consultation_status` varchar(255) DEFAULT NULL COMMENT '会诊状态',
  `clinical_memo` text COMMENT '备注/意见',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态（1-生效 0-不生效）',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for config_dic
-- ----------------------------
DROP TABLE IF EXISTS `ca_service`.`config_dic`;
CREATE TABLE `ca_service`.`config_dic` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `hospital_id` bigint(20) NOT NULL COMMENT '医院ID',
  `hospital_name` varchar(35) NOT NULL COMMENT '医院名称',
  `url` varchar(30) NOT NULL COMMENT '访问域名地址',
  `client_id` varchar(30) NOT NULL COMMENT '医网信clientId（应用标识）',
  `secret` varchar(30) NOT NULL COMMENT '医网信秘钥',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='用户关键信息表';

-- ----------------------------
-- Table structure for ht_check_face_req_log
-- ----------------------------
DROP TABLE IF EXISTS `ca_service`.`ht_check_face_req_log`;
CREATE TABLE `ca_service`.`ht_check_face_req_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `view_id` varchar(64) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `user_trans_id` varchar(64) NOT NULL,
  `name` varchar(60) NOT NULL,
  `id_number` varchar(64) NOT NULL,
  `user_photo` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='航天CA活体识别请求记录';

-- ----------------------------
-- Table structure for ht_check_face_resp_log
-- ----------------------------
DROP TABLE IF EXISTS `ca_service`.`ht_check_face_resp_log`;
CREATE TABLE `ca_service`.`ht_check_face_resp_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `view_id` varchar(64) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `result_code` int(11) DEFAULT NULL,
  `result_message` varchar(80) DEFAULT NULL,
  `identity_result` varchar(80) DEFAULT NULL,
  `face_result` varchar(80) DEFAULT NULL,
  `user_trans_id` varchar(80) DEFAULT NULL,
  `trans_id` varchar(80) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='航天CA活体识别请求返回结果记录';

-- ----------------------------
-- Table structure for ht_sign_record
-- ----------------------------
DROP TABLE IF EXISTS `ca_service`.`ht_sign_record`;
CREATE TABLE `ca_service`.`ht_sign_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `view_id` varchar(64) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `user_id` varchar(100) NOT NULL COMMENT 'userId（msspID）',
  `sign_data_id` varchar(100) NOT NULL COMMENT '添加签名任务返回的signDataId',
  `sign_data` text NOT NULL COMMENT '签名数据原文（具体业务数据）',
  `signature` text NOT NULL COMMENT '签名返回结果-signature',
  `cert` text NOT NULL COMMENT '签名返回结果-用户证书',
  `sign_id` varchar(100) NOT NULL COMMENT '签名返回结果-sign_id',
  `sign_scene_code` int(11) DEFAULT NULL COMMENT '签名场景编码',
  `sign_scene_name` varchar(10) DEFAULT NULL COMMENT '签名场景名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='用户关键信息表';


CREATE DATABASE `chdu-sdk-platform` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- ----------------------------
-- Table structure for client_account_info
-- ----------------------------
DROP TABLE IF EXISTS `chdu-sdk-platform`.`client_account_info`;
CREATE TABLE `chdu-sdk-platform`.`client_account_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `client_id` varchar(32) NOT NULL,
  `client_secret` varchar(32) NOT NULL,
  `access_token` varchar(512) DEFAULT NULL,
  `refresh_token` varchar(512) DEFAULT NULL,
  `generate_token_time` timestamp NULL DEFAULT NULL,
  `generate_token_number` int(4) DEFAULT '0',
  `status` int(2) NOT NULL DEFAULT '1' COMMENT '1代表正常 0代表删除 2代表禁用',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `access_token_unique_key` varchar(32) DEFAULT NULL,
  `refresh_token_unique_key` varchar(32) DEFAULT NULL,
  `encrypt_type` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for client_account_ip_relation
-- ----------------------------
DROP TABLE IF EXISTS `chdu-sdk-platform`.`client_account_ip_relation`;
CREATE TABLE `chdu-sdk-platform`.`client_account_ip_relation` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `client_id` varchar(32) NOT NULL,
  `extranet_ip` varchar(32) NOT NULL,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for client_account_url_relation
-- ----------------------------
DROP TABLE IF EXISTS `chdu-sdk-platform`.`client_account_url_relation`;
CREATE TABLE `chdu-sdk-platform`.`client_account_url_relation` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `client_id` varchar(32) NOT NULL,
  `url_id` bigint(20) NOT NULL,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for url_info
-- ----------------------------
DROP TABLE IF EXISTS `chdu-sdk-platform`.`url_info`;
CREATE TABLE `chdu-sdk-platform`.`url_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


CREATE DATABASE `cloud_bill` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- ----------------------------
-- Table structure for bill_detail
-- ----------------------------
DROP TABLE IF EXISTS `cloud_bill`.`bill_detail`;
CREATE TABLE `cloud_bill`.`bill_detail` (
  `x_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `x_create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `x_update_time` datetime DEFAULT NULL,
  `transaction_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '交易唯一ID',
  `object_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '账单主体ID（医生/团队/等）',
  `consumer_name` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '消费者名称',
  `organ_code` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '执业机构code',
  `serv_code` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '业务编码',
  `order_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '订单号',
  `order_money` decimal(10,4) NOT NULL DEFAULT '0.0000' COMMENT '订单金额',
  `bill_money` decimal(10,4) NOT NULL DEFAULT '0.0000' COMMENT '账单金额（不含加成费）',
  `bill_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '账单类型（收入/退款/结算/等）',
  `bill_status` tinyint(1) DEFAULT '0' COMMENT '账单状态',
  `creator` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建人',
  `doctor_name` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '医生姓名',
  `hospital_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '医院名称',
  `dept_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '科室名称',
  `app_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '平台code',
  `x_remark` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`x_id`) USING BTREE,
  KEY `FK_Reference_25` (`order_id`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='账单明细';

-- ----------------------------
-- Table structure for bill_object
-- ----------------------------
DROP TABLE IF EXISTS `cloud_bill`.`bill_object`;
CREATE TABLE `cloud_bill`.`bill_object` (
  `x_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `object_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '账单对象ID（医生/团队/等）',
  `organ_code` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '执业机构ID',
  `serv_code` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '服务编码',
  `balance_money` decimal(10,4) DEFAULT '0.0000' COMMENT '不含加成费的余额',
  `total_money` decimal(10,4) DEFAULT '0.0000' COMMENT '不含加成费的总金额',
  `sys_balance_money` decimal(10,4) DEFAULT '0.0000' COMMENT '含加成费的余额',
  `sys_total_money` decimal(10,4) DEFAULT '0.0000' COMMENT '含加成费的总金额',
  `app_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '平台code',
  PRIMARY KEY (`x_id`) USING BTREE,
  KEY `IDX_docId` (`object_id`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='账单对象';

-- ----------------------------
-- Table structure for bill_settlement
-- ----------------------------
DROP TABLE IF EXISTS `cloud_bill`.`bill_settlement`;
CREATE TABLE `cloud_bill`.`bill_settlement` (
  `x_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `x_create_time` datetime DEFAULT NULL,
  `x_update_time` datetime DEFAULT NULL,
  `object_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '账单主体ID',
  `organ_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '机构编码',
  `settlement_date` date DEFAULT NULL COMMENT '结算日期',
  `settlement_money` decimal(10,4) DEFAULT NULL COMMENT '结算给医生的金额',
  `tax_money` decimal(10,4) DEFAULT NULL COMMENT '扣税金额',
  `total_money` decimal(10,4) DEFAULT NULL COMMENT '总结算金额',
  `app_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '平台code',
  PRIMARY KEY (`x_id`) USING BTREE,
  KEY `IDX_docId` (`object_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


CREATE DATABASE `cloud_doctoruser` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;


CREATE TABLE `cloud_doctoruser`.`bd_dictionary`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `dic_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '字典类型ID 对应:bd_dictionary_type表的ID字段(外键)',
  `dic_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '字典名',
  `dic_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '字典code',
  `icon_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '图标',
  `parent_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '父级字典编码',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '备注',
  `create_time` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`bd_dictionary_type`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `type_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '字典类型名称',
  `type_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '字典类型编码',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`bd_organization`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `app_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '应用编码',
  `organ_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '机构编码',
  `organ_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院名称',
  `organ_address` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '机构地址',
  `longitude` double(20, 16) NULL DEFAULT NULL COMMENT '经度',
  `latitude` double(20, 16) NULL DEFAULT NULL COMMENT '纬度',
  `organ_type` tinyint(2) NOT NULL DEFAULT 1 COMMENT '机构类型   1 人事机构医院   2 互联网平台医院',
  `telphone` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '医院电话',
  `standard_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '机构标准编码',
  `abbreviation` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '简称',
  `used_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '曾用名',
  `level` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '机构等级',
  `organ_category` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'WS218国标类别',
  `category_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT '' COMMENT 'WS218国标类别名称',
  `bed_num` int(5) NULL DEFAULT 0 COMMENT '床位数',
  `website` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '网址',
  `profile` varchar(4096) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '简介',
  `introduction` varchar(5600) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '介绍',
  `logo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'LOGO',
  `country` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '国家-字典编码',
  `province` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '省-字典编码',
  `city` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '市-字典编码',
  `district` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '区-字典编码',
  `address` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '详细地址',
  `status` tinyint(1) NULL DEFAULT 1 COMMENT '状态',
  `dept_num` smallint(4) NULL DEFAULT 0 COMMENT '科室数量',
  `key_dept` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '重点科室名称（逗号分隔）',
  `rel_organ_id` int(11) NULL DEFAULT 0 COMMENT '关联执业机构ID',
  `level_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '机构等级名称',
  `the_weight` int(11) NULL DEFAULT 0 COMMENT '权重',
  `organ_english_name` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '医院英文名',
  `organ_background` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '医院背景图',
  `organ_on_off` tinyint(1) NULL DEFAULT 2 COMMENT '医院首页开关(0:默认,1:开通,2:关闭)',
  `morning_time` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '门诊上午时间段',
  `afternoon_time` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '门诊下午时间段',
  `calligraphy_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '医院书法名图片',
  `organ_label` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '医院标签',
  `organ_qr_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '公众号二维码',
  `official_accounts_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '公众号名称',
  `friend_display` tinyint(1) NULL DEFAULT 0 COMMENT '0:展示所有，1：展示所在医院，2：展示所在平台',
  `eval_display` tinyint(1) NULL DEFAULT 1 COMMENT '0:隐藏评价，1：展示评价',
  `unique_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '全国统一组织编码',
  `unit_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '监管平台机构id',
  `register_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '机构登记号',
  `legal_representative` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '法定代表人',
  `charge_representative` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '主要负责人',
  `pass_date` datetime(0) NULL DEFAULT NULL COMMENT '批准日期',
  `pass_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '批准文号',
  `begin_date` datetime(0) NULL DEFAULT NULL COMMENT '有效开始时间',
  `end_date` datetime(0) NULL DEFAULT NULL COMMENT '有效截止时间',
  `regulatory_status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '监管状态  1 开启  0 未开启',
  `is_public` tinyint(2) NULL DEFAULT 1 COMMENT '1 公立医院  2 私立医院',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `organ_code`(`organ_code`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`bd_organization_config`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `hospital_id` bigint(20) NOT NULL,
  `app_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '医院公众号的appId',
  `mini_app_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '小程序的appId',
  `partner_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '三方合作方id',
  `status` int(2) NOT NULL DEFAULT 1,
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_bin ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`bd_standard_department`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `display_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '名称',
  `english_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '英文名称',
  `short_name` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '简称',
  `icon_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '图标',
  `type` tinyint(1) NULL DEFAULT 0 COMMENT '科室类型 1 一级科室 2 二级科室',
  `rel_dept_id` bigint(20) NULL DEFAULT 0 COMMENT '关联一级科室ID（本表的id，递归定义的表）',
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '状态',
  `create_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`bd_std_dept_seq`  (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `organ_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '医院ID 对应:bd_organization表的ID(外键)',
  `std_dept_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '科室id 对应:doc_department表的ID字段(外键)',
  `seq` int(5) NOT NULL DEFAULT 0 COMMENT '排序',
  `status` int(5) NOT NULL DEFAULT 0 COMMENT '状态 1启用 -1 弃用',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_bin ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`classify_dept_relative`  (
  `classify_id` bigint(20) NOT NULL COMMENT '自定义分类ID 对应:dept_custom_classify表的ID字段(外键)',
  `dept_id` bigint(20) NOT NULL COMMENT '科室id 对应:doc_department表的ID字段(外键)',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`classify_id`, `dept_id`) USING BTREE,
  INDEX `index_classify_dept`(`classify_id`, `dept_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '自定义分类-科室 多对对关联表' ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`dept_custom_classify`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `organ_id` bigint(20) NULL DEFAULT NULL COMMENT '医院ID 对应:医生服务bd_organization表的ID(外键)',
  `classify_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分类名称',
  `classify_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '分类code',
  `whether_modified` int(11) NULL DEFAULT NULL COMMENT '是否可修改标识（-1 不可修改 1可以修改）',
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '-1:删除1:上线',
  `view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '科室自定义分类表' ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doc_appeal`  (
  `x_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `x_create_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP,
  `x_update_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `user_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '申诉用户ID',
  `doctor_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '医生ID',
  `user_type` tinyint(4) NULL DEFAULT NULL COMMENT '申诉用户类型 1 医生 2 患者',
  `content` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `serv_log_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务数据记录id',
  `serv_type` tinyint(4) NULL DEFAULT NULL,
  `reply` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '运营人员回复',
  `deal_explain` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '处理备注',
  `deal_user` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '处理人',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '处理状态 1 未处理 2 已处理',
  `app_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '平台code',
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`x_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doc_appeal_remark`  (
  `x_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `appeal_id` bigint(20) NULL DEFAULT NULL COMMENT '所属申述 所属申述 对应:doc_appeal表的ID字段(外键)',
  `remark` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '备注',
  `remark_user` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注人',
  `x_version` bigint(20) NULL DEFAULT NULL COMMENT '版本',
  `x_remark` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `x_create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `x_update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`x_id`) USING BTREE,
  INDEX `appeal_id`(`appeal_id`) USING BTREE,
  CONSTRAINT `doc_appeal_remark_ibfk_1` FOREIGN KEY (`appeal_id`) REFERENCES `cloud_doctoruser`.`doc_appeal` (`x_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doc_balance_log`  (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `doctor_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '医生编号 医生编号 对应:uc_doctor_info表的ID字段(外键)',
  `balance` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '当前账户余额',
  `modify_balance` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '修改后账户余额',
  `business_code` varchar(250) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT '' COMMENT '业务标识',
  `status` int(5) NOT NULL DEFAULT 0 COMMENT '状态 1启用 -1 弃用',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_bin ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doc_default_service_condition`  (
  `id` bigint(32) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `default_service_id` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '默认开通服id 对应:doc_default_service_rule表的ID字段(外键)',
  `condition_code` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '条件名称',
  `condition_value` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '条件值',
  `status` tinyint(1) NULL DEFAULT NULL COMMENT '状态',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `remark` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doc_default_service_rule`  (
  `id` bigint(32) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `service_code` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '服务编码 对应:bd_dictionary表的dic_code字段(外键)',
  `child_code` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '子服务编码 对应:bd_dictionary表的dic_code字段(外键)',
  `service_info` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '服务json',
  `sort` int(1) NULL DEFAULT NULL COMMENT '优先级',
  `status` tinyint(1) NULL DEFAULT NULL COMMENT '状态',
  `remark` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doc_department`  (
  `x_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `std_first_dept_id` bigint(20) NULL DEFAULT 0 COMMENT '标准一级科室ID 对应:主键(内关连键)',
  `std_second_dept_id` bigint(20) NULL DEFAULT 0 COMMENT '标准二级科室ID 对应:主键(内关连键)',
  `dept_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '科室名字',
  `english_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '英文名称',
  `dept_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '科室编码',
  `organ_id` bigint(20) NOT NULL COMMENT '所属机构ID',
  `is_inhos` tinyint(1) NULL DEFAULT 1 COMMENT '是否是住院科室 1 是 0 否',
  `is_popular` tinyint(1) NULL DEFAULT 0 COMMENT '是否热门科室 1 是 0 否',
  `description` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '科室介绍',
  `doctor_count` int(10) NULL DEFAULT NULL COMMENT '科室医生数量',
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '标签',
  `seq` bigint(20) NOT NULL DEFAULT 0 COMMENT '排序',
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '状态 0 下线 1 上线 -1 逻辑删除',
  `x_version` bigint(20) NULL DEFAULT NULL COMMENT '版本',
  `x_remark` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '备注',
  `x_create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `x_update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`x_id`) USING BTREE,
  INDEX `FK_Reference_4`(`organ_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doc_doctor_service_access`  (
  `x_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `working_service` bigint(20) NOT NULL COMMENT '服务id 对应:doc_organ_working_service表的ID(外键)',
  `doctor_work_id` bigint(20) NOT NULL COMMENT '人事id 对应:doc_doctor_workplace表的ID(外键)',
  `status` int(11) NULL DEFAULT NULL COMMENT '1：开启权限 0：关闭权限',
  `x_version` bigint(20) NULL DEFAULT NULL COMMENT '版本号',
  `x_remark` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `x_create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `x_update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`x_id`) USING BTREE,
  INDEX `idx_doctor_work_id_working_service`(`doctor_work_id`, `working_service`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doc_doctor_working_service`  (
  `x_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `working_service` bigint(20) NULL DEFAULT NULL COMMENT '服务id 对应:doc_organ_working_service表的ID(外键)',
  `service_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '服务code 对应:bd_dictionary表的dic_code字段(外键)',
  `doctor_work_id` bigint(20) NULL DEFAULT NULL COMMENT '人事id 对应:doc_doctor_workplace表的ID(外键)',
  `doctor_work_info_id` bigint(11) NULL DEFAULT NULL COMMENT '医生执业信息id 对应:doc_doctor_workplace_info表的ID(外键)',
  `config` varchar(560) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '服务配置内容',
  `config_id` bigint(20) NULL DEFAULT NULL COMMENT '配置ID(弃用)',
  `seq` int(11) NULL DEFAULT 0 COMMENT '排序(越大越靠前)',
  `status` int(11) NULL DEFAULT NULL COMMENT '状态 1:启用 -1:弃用',
  `x_version` bigint(20) NULL DEFAULT NULL COMMENT '版本',
  `x_remark` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `x_create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `x_update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`x_id`) USING BTREE
 ) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doc_doctor_working_service_temp`  (
  `x_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `status` int(11) NULL DEFAULT NULL,
  `working_service` bigint(20) NULL DEFAULT NULL,
  `service_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '服务code',
  `doctor_work_id` bigint(20) NULL DEFAULT NULL,
  `doctor_work_info_id` bigint(11) NULL DEFAULT NULL COMMENT '医生执业信息id',
  `config` varchar(560) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '服务配置内容',
  `config_id` bigint(20) NULL DEFAULT NULL COMMENT '配置ID',
  `seq` int(11) NULL DEFAULT 0 COMMENT '排序(越大越靠前)',
  PRIMARY KEY (`x_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doc_doctor_workplaces`  (
  `x_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `doctor_id` bigint(20) NOT NULL COMMENT '医生ID 对应:uc_doctor_info表的ID字段(外键)',
  `organ_id` bigint(20) NOT NULL COMMENT '医院ID 对应:bd_organization表的ID字段(外键)',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '医生职业账户状态',
  `x_version` bigint(20) NULL DEFAULT NULL COMMENT '版本',
  `x_remark` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `x_create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `x_update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`x_id`) USING BTREE,
  INDEX `FK_Reference_1`(`doctor_id`) USING BTREE,
  INDEX `FK_Reference_2`(`organ_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '建立医生和医院的关系' ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doc_doctor_workplaces_info`  (
  `x_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '备注',
  `x_create_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '备注时间',
  `dept_id` bigint(20) NULL DEFAULT 0 COMMENT '科室id 对应:doc_department表的ID字段(外键)',
  `doctor_workplaces` bigint(20) NOT NULL COMMENT '人事id 对应:doc_doctor_workplace表的ID(外键)',
  `profession_code` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '职称code 对应:bd_dictionary表的dic_code字段(外键)',
  `doctor_code` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '医生code',
  `profession` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '职称名称',
  `introduction` varchar(840) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '介绍',
  `share_code` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '分享链接',
  `dept_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '医院科室名称',
  `is_default` int(11) NULL DEFAULT 0 COMMENT '默认开通服务标识',
  `x_remark` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `x_version` bigint(20) NULL DEFAULT 0 COMMENT '版本',
  PRIMARY KEY (`x_id`) USING BTREE,
  INDEX `FK_Reference_3`(`doctor_workplaces`) USING BTREE,
  INDEX `FK_Reference_5`(`dept_id`) USING BTREE,
  CONSTRAINT `doc_doctor_workplaces_info_ibfk_1` FOREIGN KEY (`doctor_workplaces`) REFERENCES `cloud_doctoruser`.`doc_doctor_workplaces` (`x_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `doc_doctor_workplaces_info_ibfk_2` FOREIGN KEY (`dept_id`) REFERENCES `cloud_doctoruser`.`doc_department` (`x_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '医生执业信息' ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doc_famous_doctor`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `hospital_id` bigint(20) NOT NULL COMMENT '医院ID 对应:bd_organization表的ID字段(外键',
  `std_first_dept_id` bigint(20) NULL DEFAULT 0 COMMENT '标准一级科室ID 对应:bd_standard_department表的ID字段(外键)',
  `std_second_dept_id` bigint(20) NULL DEFAULT 0 COMMENT '标准二级科室ID 对应:bd_standard_department表的主键(外键)',
  `hospital_dept_id` bigint(20) NOT NULL COMMENT '医院科室ID 对应:doc_department表的ID字段(外键)',
  `doctor_id` bigint(20) NOT NULL COMMENT '医生ID 对应:uc_doctor_info表的ID字段(外键)',
  `sort` tinyint(4) NOT NULL COMMENT '排序',
  `app_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '平台code',
  `status` tinyint(4) NOT NULL COMMENT '数据状态 1:启用  -1:删除',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '名医榜医生表' ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doc_famous_doctor_switch`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `hospital_id` bigint(20) NOT NULL COMMENT '医院ID 对应:bd_organization表的ID字段(外键)',
  `is_show` tinyint(4) NOT NULL DEFAULT -1 COMMENT '名医榜开关  1:展示 -1:关闭',
  `status` tinyint(4) NOT NULL DEFAULT 1 COMMENT '数据状态 1:启用  -1:删除',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '名医榜开关表' ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doc_organ_working_service`  (
  `x_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `organ_id` bigint(20) NOT NULL COMMENT '医院ID 对应:bd_organization表的ID字段(外键)',
  `serv_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '服务code 对应:bd_dictionary表的dic_code字段(外键)',
  `serv_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '服务名称',
  `serv_type` tinyint(4) NOT NULL COMMENT '服务类型',
  `config` varchar(560) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '结算配置',
  `service_config` varchar(560) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '医生开通服务默认配置',
  `parent_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '父级ID',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '状态 1:启用 -1:弃用',
  `x_version` bigint(20) NULL DEFAULT NULL COMMENT '版本',
  `x_remark` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `x_create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `x_update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `organ_id`(`organ_id`, `serv_code`) USING BTREE,
  INDEX `FK_Reference_9`(`organ_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doc_patient_relation`  (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `doctor_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '医生ID 对应:uc_doctor_info表的ID字段(外键)',
  `patient_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '患者id 对应:卡服务cs_card表的patient_id字段(外键)',
  `group_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '分组列表id 对应:doc_relation_group表的ID字段(外键)',
  `user_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '用户Id 对应:用户服务uc_doctor_user的userId(外键)',
  `patient_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '患者名称',
  `app_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '所在平台code',
  `focus_type` tinyint(3) NOT NULL DEFAULT 0 COMMENT '关注类型(1.用户关注医生,2.医生关注患者)',
  `is_visited` tinyint(3) NOT NULL DEFAULT 0 COMMENT '已经就诊',
  `label` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '标签',
  `phone` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '患者电话',
  `card_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '身份证号',
  `status` tinyint(3) NOT NULL DEFAULT 0 COMMENT '状态（1.正常,-1.关闭）',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doc_patient_report_log`  (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `doctor_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '医生ID 对应:uc_doctor_info表的ID字段(外键)',
  `patient_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '患者患者id 对应:卡服务cs_card表的patient_id字段(外键)',
  `user_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '用户Id 对应:用户服务uc_doctor_user的userId(外键)',
  `patient_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '患者名称',
  `app_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '所在平台code',
  `patient_age` tinyint(3) NOT NULL DEFAULT 0 COMMENT '患者年龄',
  `patient_sex_code` tinyint(2) NOT NULL DEFAULT 0 COMMENT '患者性别code 1 男  2 女',
  `patient_sex_name` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '患者性别描述  男  , 女',
  `patient_head_portrait` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '患者头像',
  `card_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '身份证号',
  `phone` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '患者联系电话',
  `status` tinyint(3) NOT NULL DEFAULT 0 COMMENT '状态 1待处理  2已同意  -1 已拒绝',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `doctor_id`(`doctor_id`) USING BTREE,
  INDEX `patient_id`(`patient_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '患者报到记录表' ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doc_relation_group`  (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `doctor_id` bigint(11) NOT NULL COMMENT '医生ID 对应:uc_doctor_info表的ID字段(外键)',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '分组名称',
  `app_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '所在平台code',
  `is_default` tinyint(3) NULL DEFAULT 0 COMMENT '是否默认 1默认 2默认 3不是',
  `seq` tinyint(3) NOT NULL DEFAULT 3 COMMENT '排序',
  `status` tinyint(3) NOT NULL DEFAULT 0 COMMENT '状态',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doc_service_config`  (
  `x_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `source_id` bigint(20) NOT NULL COMMENT '资源ID（机构/医生/职称）',
  `type` tinyint(2) NULL DEFAULT NULL COMMENT '配置类型（1 机构 2 医生 3 职称）',
  `serv_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '业务编码',
  `content` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '配置内容',
  `x_version` bigint(20) NULL DEFAULT NULL COMMENT '版本',
  `x_remark` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '备注',
  `x_create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `x_update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`x_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doctor_card_info`  (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `doctor_id` bigint(11) NOT NULL COMMENT '医生id 对应:uc_doctor_info表的ID字段(外键)',
  `cardholder` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '持卡人',
  `card_type` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '卡类型',
  `card_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '卡号',
  `issuing_bank` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开户行',
  `bank_outlets` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '支行信息',
  `latest` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '最近使用',
  `status` tinyint(11) NULL DEFAULT 0 COMMENT '状态',
  `ID_card_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '身份证号',
  `telephone` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '预留手机号',
  `uuid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'uuid',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doctor_consultation_service_info`  (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `doctor_id` bigint(32) NULL DEFAULT NULL COMMENT '医生id 对应:uc_doctor_info表的ID字段(外键)',
  `service_info_id` bigint(32) NULL DEFAULT NULL COMMENT '服务id',
  `service_code` bigint(20) NULL DEFAULT NULL COMMENT '服务编码',
  `amount` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '价格（分）',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `group_code` bigint(20) NULL DEFAULT NULL COMMENT '群组code',
  `group_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '群组名称',
  `service_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '服务名称',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`Id`) USING BTREE,
  UNIQUE INDEX `index_doctorid_servicecode_status`(`doctor_id`, `service_code`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doctor_hospital_message`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `hospital_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '医院名称',
  `hospital_logo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '医院logo',
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '状态',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doctor_hospital_rel`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `doctor_id` bigint(20) NULL DEFAULT 0 COMMENT '医生ID 对应:uc_doctor_info表的ID字段(外键)',
  `hospital_msg_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '医院经历ID 对应:doctor_hospital_message表的ID字段(外键)',
  `std_second_dept_id` bigint(20) NULL DEFAULT 0 COMMENT '标准二级科室ID 对应:doc_department表的ID字段(外键)',
  `std_second_dept_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '标准二级科室名称',
  `start_time` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '开始时间',
  `end_time` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '结束时间',
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '状态',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doctor_school_message`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `school_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '学校名称',
  `school_logo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '学校logo',
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '状态',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doctor_school_rel`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `doctor_id` bigint(20) NULL DEFAULT 0 COMMENT '医生ID 对应:uc_doctor_info表的ID字段(外键)',
  `school_msg_id` bigint(20) NULL DEFAULT 0 COMMENT '学校经历ID 对应:doctor_school_message表的ID字段(外键)',
  `education_id` bigint(20) NULL DEFAULT 0 COMMENT '教育经历ID',
  `education_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '教育经历',
  `start_time` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '开始时间',
  `end_time` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '结束时间',
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '状态',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doctor_service_info`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `create_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `app_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '平台code',
  `doctor_id` int(64) NOT NULL COMMENT '医生ID',
  `service_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '服务编码',
  `service_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医生执业机构编码',
  `organ_id` int(11) NULL DEFAULT NULL COMMENT '医生执业机构ID',
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '医生执业机构编码',
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '服务开通状态 1 开通 0 关闭',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_doctor_id_1`(`doctor_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '医生服务设置表' ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doctor_team_info`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `organ_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '机构编号',
  `organ_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '机构编码',
  `organ_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '机构名称',
  `first_stand_dept_id` int(11) NOT NULL DEFAULT 0 COMMENT '一级科室编号',
  `first_stand_dept_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '一级科室名称',
  `hospital_dept_id` int(11) NOT NULL DEFAULT 0 COMMENT '医院科室编号',
  `hospital_dept_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '医院科室名称',
  `leader_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '团队长编号',
  `leader_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '团队长姓名',
  `leader_contact_mobile` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '团队长联系电话',
  `introduction` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '团队简介',
  `speciality` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '擅长领域',
  `team_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '团队名称',
  `profession` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '团队长职称',
  `profession_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '团队长职称编号',
  `app_code` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '平台code',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doctor_team_member`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `team_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '团队编号',
  `doctor_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '医生编号',
  `doctor_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '医生姓名',
  `status` tinyint(11) NOT NULL DEFAULT 1 COMMENT '状态',
  `team_score` int(20) NOT NULL DEFAULT 0 COMMENT '团队权重',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `member_unique`(`team_id`, `doctor_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doctor_team_service_info`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `team_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '团队编号',
  `service_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '开通服务编码',
  `service_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '开通服务名称',
  `service_info` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '开通服务信息',
  `status` tinyint(11) NOT NULL DEFAULT 1 COMMENT '状态',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `service_unique`(`team_id`, `service_code`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`doctor_withdraw_info`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `uuid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '随机Id',
  `doctor_id` bigint(11) NOT NULL COMMENT '医生Id',
  `money` decimal(10, 2) NULL DEFAULT NULL COMMENT '本次提现金额',
  `balance` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '当前账户余额',
  `card_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '卡号',
  `issuing_bank` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属银行',
  `cardholder` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '持卡人',
  `telephone` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '手机号',
  `auditor` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审核人',
  `out_trade_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '流水号',
  `taxation_money` decimal(10, 2) NULL DEFAULT NULL COMMENT '税收费用',
  `actual_money` decimal(10, 2) NULL DEFAULT NULL COMMENT '实际到账',
  `status` tinyint(1) NOT NULL DEFAULT 0 COMMENT '状态:1 待审核 2审核通过 -1审核未通过',
  `remark` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `id_card_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '身份证号',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `calculation_formula` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '空' COMMENT '提现时的税收计算公式',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_doctor_id`(`doctor_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`evaluation_tag_score`  (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `tag_id` bigint(11) NULL DEFAULT 0 COMMENT '标签id',
  `score` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT '' COMMENT '分数',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `status` int(11) NULL DEFAULT 0 COMMENT '状态码',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_bin ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`his_doctor_info`  (
  `id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '主键id',
  `empl_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '医生工号',
  `empl_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医生姓名',
  `sex_code` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '性别编码',
  `birthday` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '生日',
  `dept_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '科室名称',
  `organ_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '医院编码',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `status` int(11) NULL DEFAULT NULL COMMENT '1：可用，0：不可用',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`idcard_info`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '姓名',
  `idcard` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '身份证号',
  `address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '身份证地址',
  `birthday` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '生日',
  `sex` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '性别 M:男 F:女',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `status` int(5) NULL DEFAULT 1 COMMENT '状态(暂时没用,在代码中没有做限制)',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `idx-idcard`(`idcard`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`oss_file`  (
  `id` bigint(64) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'id',
  `view_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'view_id',
  `url` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '文件阿里云地址',
  `status` int(4) NOT NULL COMMENT '订单状态',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `view_id_index`(`view_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`supervise_hospital_detp_dic`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `organ_id` bigint(20) NULL DEFAULT NULL COMMENT '医院id',
  `mapping_dept_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '映射科室编码',
  `mapping_dept_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '映射科室名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`supervise_hospital_detp_mapping`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `supervise_hospital_detp_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '映射科室id 对应:supervise_hospital_detp_mapping的主键ID(外键)',
  `hospital_dept_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '医院科室ID',
  `organ_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`uc_account`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `account_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '账户Id  对应:uc_doctor_audit表的uc_account_id(外键)',
  `user_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户Id 对应:uc_doctor_user的userId(外键)',
  `account_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '账户名 (可以用作登录凭证)',
  `account_pw` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '密码',
  `pw_salt` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '密码盐',
  `user_type` tinyint(4) UNSIGNED NOT NULL COMMENT '用户类型：0【患者】1【医生】2【机构】3【管理员】',
  `account_type` tinyint(4) UNSIGNED NOT NULL COMMENT '账户类型：0【手机号码】1【邮箱】2【证件号码】3【自定义】',
  `status` tinyint(4) UNSIGNED NOT NULL COMMENT '账户状态：1未完善个人信息,2未完善医生信息,3资料审核中,4资料审核失败,5正常,6禁用,7注销,8未设置密码,9.二次审核中',
  `register_channel` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '注册渠道',
  `app_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属应用CODE',
  `hospital_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属医院CODE',
  `last_login_time` datetime(0) NULL DEFAULT NULL COMMENT '最后一次登陆时间',
  `last_login_ip` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '最后一次登录IP',
  `is_active` tinyint(4) NULL DEFAULT 0 COMMENT '是否激活: 0未激活  1激活',
  `real_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '真实姓名',
  `login_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '登录名  (可以用作登录凭证)',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `account_id`(`account_id`) USING BTREE,
  INDEX `FK_Reference_3`(`user_id`) USING BTREE,
  INDEX `account_no`(`account_no`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '账户表' ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`uc_account_operate`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `account_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '账户Id 对应uc_account表的account_id',
  `operate_channel` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作渠道',
  `operate_type` tinyint(4) UNSIGNED NOT NULL COMMENT '操作类型： 0注册账号, 1完善资料, 2修改资料,3账户注销, 4修改密码,5修改个人资料,6修改登录帐号',
  `operaye_content` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作内容',
  `request_parameter` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '请求参数',
  `create_time` datetime(0) NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `FK_Reference_5`(`account_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '账户操作表' ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`uc_app_client`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `client_type` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '医生APP端类型',
  `app_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '可登录平台code,逗号分隔',
  `client_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '配置名称',
  `i18n_enable` tinyint(11) NULL DEFAULT 0 COMMENT '国际化开关:0关闭，1开启',
  `wx_app_id_type` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `type`(`client_type`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`uc_configuration`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `app_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'appCode',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'sms：短信，youmengPush：友盟推送, weChatApplets:微信小程序',
  `client_code` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'clientCode',
  `create_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '修改时间',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '0：未启用，1：启用',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '配置表' ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`uc_doctor_audit`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `account_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '账户Id 对应uc_account表的account_id',
  `doctor_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '账户Id 对应uc_doctor_user表的doctor_id',
  `name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '姓名',
  `aduit_status` tinyint(4) UNSIGNED NULL DEFAULT NULL COMMENT '审核状态： 0待审核 1取消审核 2更新审核 3审核不通过 4审核成功',
  `register_mobile` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '注册手机号码',
  `contact_mobile` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系手机号码',
  `head_portrait` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '头像地址',
  `email` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮箱地址',
  `pinyin` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '姓名拼音',
  `gender` tinyint(4) UNSIGNED NULL DEFAULT NULL COMMENT '性别：1【男】2【女】',
  `cred_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证件号',
  `cred_type` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证件类型',
  `dob` date NULL DEFAULT NULL COMMENT '生日',
  `nation` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '民族',
  `realname_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '实名信息ID',
  `realname_status` tinyint(4) UNSIGNED NULL DEFAULT NULL COMMENT '实名状态：0【未实名】1【待审核】2【已实名】3【审核失败】',
  `area_code` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '省市区CODE',
  `position` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '详细地址',
  `hospital_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属医院CODE',
  `hospital_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院名称',
  `hospital_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属医院CODE',
  `std_first_dept_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标准第一科室CODE',
  `std_first_dept_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标准第一科室名称',
  `speciality` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '擅长',
  `profile` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '简介',
  `profession` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '职称',
  `profession_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '职称CODE',
  `badge_url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证书地址',
  `cred_front` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证件照正面',
  `cred_back` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证件照背面',
  `std_second_dept_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标准第二科室CODE',
  `std_second_dept_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标准第二科室名称',
  `hospital_dept_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院科室CODE',
  `hospital_dept_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院科室名称',
  `failure_reason` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '失败原因',
  `aduit_person` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审核人',
  `create_time` datetime(0) NOT NULL COMMENT '创建时间',
  `update_time` datetime(0) NOT NULL COMMENT '修改时间',
  `empl_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医生工号',
  `doctor_cert_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '资格证书编码',
  `doctor_work_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '职业证书编码',
  `doctorwork_date` date NULL DEFAULT NULL COMMENT '发证日期',
  `job` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '职业',
  `job_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '职业code',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `FK_Reference_1`(`account_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '医生审核表' ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`uc_doctor_info`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `organ_id` int(11) NOT NULL DEFAULT 0 COMMENT '机构所属ID',
  `name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '姓名',
  `gender` tinyint(4) UNSIGNED NULL DEFAULT NULL COMMENT '性别：0【男】1【女】',
  `contact_mobile` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系手机号码',
  `register_mobile` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '注册手机号码',
  `personalized_signature` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '个人简介',
  `cred_type` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证件类型',
  `cred_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证件号',
  `head_portrait` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '头像',
  `balance` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '医生提现余额',
  `balance_mark` int(10) NOT NULL DEFAULT 0 COMMENT '余额更新标识',
  `email` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮箱',
  `dob` date NULL DEFAULT NULL COMMENT '生日',
  `nation` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '民族',
  `realname_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '实名信息Id',
  `area_code` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地区编码',
  `position` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '详细地址',
  `std_first_dept_id` int(64) NULL DEFAULT NULL COMMENT '一级标准科室id',
  `std_first_dept_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标准第一科室名称',
  `speciality` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '擅长',
  `profile` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '简介',
  `profession` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '职称',
  `profession_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '职称code',
  `badge_url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证书地址',
  `cred_front` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证件照正面',
  `cred_back` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证件照背面',
  `std_second_dept_id` int(32) NULL DEFAULT NULL COMMENT '标准第二科室id',
  `std_second_dept_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标准第二科室名称',
  `hospital_dept_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院科室id',
  `hospital_dept_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院科室名称',
  `doctor_type` int(11) NOT NULL DEFAULT 1 COMMENT '用户类型: 1医生 2专家           ',
  `status` int(10) NULL DEFAULT NULL COMMENT '医生状态',
  `create_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `empl_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医生工号',
  `doctor_cert_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '资格证书编码',
  `doctor_work_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '职业证书编码',
  `doctorwork_date` datetime(0) NULL DEFAULT NULL COMMENT '发证日期',
  `credit_card` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '学分卡号',
  `post` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '职务',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '医生用户表（主表）' ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`uc_doctor_user`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `user_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户Id 对应uc_account表的userId (外键)',
  `doctor_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医生Id 对应uc_doctor_info的doctor_id(外键)',
  `nickname` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '昵称',
  `hospital_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '所属医院ID',
  `hospital_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院名称',
  `hospital_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属医院CODE',
  `personalized_signature` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '个人简介',
  `head_portrait` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '头像',
  `contact_mobile` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系手机号码',
  `register_mobile` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '注册手机号码',
  `email` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮箱',
  `name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '姓名',
  `gender` tinyint(4) UNSIGNED NULL DEFAULT NULL COMMENT '性别：0【男】1【女】',
  `cred_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证件号',
  `cred_type` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证件类型',
  `dob` date NULL DEFAULT NULL COMMENT '生日',
  `nation` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '民族',
  `realname_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '实名信息Id',
  `realname_status` tinyint(4) UNSIGNED NULL DEFAULT NULL COMMENT '实名状态：0【未实名】1【待审核】2【已实名】3【审核失败】',
  `user_status` int(10) UNSIGNED NULL DEFAULT NULL COMMENT '账户状态：0【正常】1【禁用】2【注销】3【未完善资料】4【未进行人事所属机构认证】',
  `area_code` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地区编号',
  `position` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '详细地址',
  `std_first_dept_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '一级标准科室CODE',
  `std_first_dept_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标准第一科室名称',
  `speciality` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '擅长',
  `profile` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '简介',
  `profession` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '职称',
  `profession_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '职称CODE',
  `badge_url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证书地址',
  `cred_front` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证件照正面',
  `cred_back` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证件照背面',
  `std_second_dept_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标准第二科室CODE',
  `std_second_dept_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标准第二科室名称',
  `hospital_dept_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院科室CODE',
  `hospital_dept_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院科室名称',
  `user_type` int(11) NULL DEFAULT NULL COMMENT '用户类型： 0患者 1医生 2专家        ',
  `create_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `job` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '职业：医生、护士',
  `doctor_cert_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '资格证书编码',
  `doctor_work_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '职业证书编码',
  `doctorwork_date` date NULL DEFAULT NULL COMMENT '发证日期',
  `job_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '职业code',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `user_id`(`user_id`) USING BTREE,
  INDEX `doctor_id`(`doctor_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '医生用户信息表' ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`uc_evaluation_tag`  (
  `id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '主键id',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `version` bigint(20) NULL DEFAULT NULL COMMENT '版本号',
  `remark` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '备注',
  `tag_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '标签code',
  `tag_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '标签名称',
  `status` int(4) NULL DEFAULT NULL COMMENT '状态，1：启用，0：禁用',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`uc_hospital_info`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `hospital_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '医院名称',
  `hospital_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '医院CODE',
  `prefix_userid` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '医院所属用户前缀ID',
  `req_url` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '统一请求地址',
  `app_code` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '所属应用CODE（韩鑫：CLOUDAPP是没有归属医院的编码标识）',
  `status` tinyint(4) NOT NULL COMMENT '状态: 1:正常 -1:禁用  8:待激活',
  `type` tinyint(4) NOT NULL COMMENT '医院类型：0：平台医院 1：非平台医院（韩鑫：1.有归属的医院 2.没有归属的医院）',
  `token_key` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'token的保存key(但是现在不用这个)',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `app_url` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'appUrl',
  `hospital_logo` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '诊疗平台logo',
  `manage_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '管理平台url',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '医院信息表' ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`uc_login_record`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `account_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '账户Id 对应uc_account表的account_id',
  `device_number` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备号',
  `device_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备类型',
  `login_ip` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '登录IP',
  `login_bussiness_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '登录业务CODE',
  `login_token` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '登录TOKEN',
  `login_type` tinyint(4) UNSIGNED NULL DEFAULT NULL COMMENT '登录类型：0【登录】1【退出】',
  `create_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `FK_Reference_4`(`account_id`) USING BTREE,
  INDEX `login_record_account_id`(`account_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '登录记录表' ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`uc_manage_operate`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `account_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '账户Id 对应uc_account表的account_id',
  `be_op_account_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '被操作账户Id 对应uc_account表的account_id',
  `operate_channel` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作渠道',
  `operate_type` tinyint(4) UNSIGNED NOT NULL COMMENT '操作类型：0【重置密码】1【注销帐号】2【实名审核成功】3【实名审核失败】',
  `operaye_content` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作内容',
  `request_parameter` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '请求参数',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `FK_Reference_6`(`account_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '管理员操作记录表' ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`uc_status_record`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `ceate_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `register_mobile` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '注册的手机号',
  `account_id` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '账户Id 对应uc_account表的account_id',
  `audit_status` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '多条审核记录历史状态记录',
  `user_status` tinyint(11) NULL DEFAULT NULL COMMENT '对应doctor_user表状态',
  `account_status` tinyint(11) NULL DEFAULT NULL COMMENT '账号的状态',
  `operate_content` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作纪要',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`uc_user_evaluation`  (
  `id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '主键id',
  `create_time` datetime(0) NOT NULL COMMENT '创建时间',
  `update_time` datetime(0) NOT NULL COMMENT '更新时间',
  `version` bigint(20) NULL DEFAULT NULL COMMENT '版本号',
  `remark` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '备注',
  `app_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT 'appCode',
  `organ_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '医院id',
  `doctor_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '医生id',
  `doctor_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '医生姓名',
  `paitient_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '患者id',
  `patient_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '患者姓名',
  `adm_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '订单id',
  `doctor_comment` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '医生评价',
  `doctor_score` tinyint(4) NULL DEFAULT NULL COMMENT '医生评价星级',
  `app_comment` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT 'app评价',
  `app_score` tinyint(4) NULL DEFAULT NULL COMMENT 'app评价星级',
  `team_member` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '团队成员',
  `eval_type` tinyint(4) NULL DEFAULT NULL COMMENT '1:个人，2：团队',
  `tags_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '评价标签',
  `comment_time` datetime(0) NOT NULL COMMENT '评价时间',
  `display` tinyint(4) NOT NULL COMMENT '是否显示，1：显示，0：隐藏',
  `serv_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '服务编码',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`uc_wx_applet_config`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `app_id_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配置对应的AppCode',
  `applet_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '微信对应的appId',
  `applet_secret` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '微信对应的appSecret',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`uc_wx_auth`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增长主键Id',
  `account_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '账户Id 对应uc_account表的account_id',
  `user_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户Id 对应uc_account表的user_id',
  `wx_unionid` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '微信合作商unionId',
  `wx_openid` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '微信唯一登录Id',
  `status` tinyint(4) UNSIGNED NULL DEFAULT NULL COMMENT ' 0待绑定,1正常,2禁用,3注销,解绑',
  `nickname` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '微信昵称',
  `head_portrait` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '微信头像',
  `subordinate_type` tinyint(4) NULL DEFAULT NULL COMMENT '所属类型：0【APP】1【小程序】2【公众号】',
  `app_id_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '多节点配置参数',
  `create_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `account_id`(`account_id`) USING BTREE,
  INDEX `wx_openid`(`wx_openid`, `wx_unionid`) USING BTREE,
  INDEX `wx_auth_account_id`(`account_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '微信授权表' ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`user_friend_relation`  (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `main_user_id` int(11) NULL DEFAULT NULL,
  `main_user_type` int(11) NULL DEFAULT NULL,
  `main_rong_user_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `sub_user_id` int(11) NULL DEFAULT NULL,
  `sub_user_type` int(11) NULL DEFAULT NULL,
  `sub_rong_user_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `create_time` timestamp(0) NULL DEFAULT NULL COMMENT '关系添加时间',
  `main_user_from` int(11) NULL DEFAULT NULL COMMENT '1：患者，2：医生',
  `sub_user_from` int(11) NULL DEFAULT NULL COMMENT '1：患者，2：医生',
  `status` tinyint(4) NULL DEFAULT 0,
  PRIMARY KEY (`Id`) USING BTREE,
  INDEX `index_main_user_id-user_type`(`main_user_id`, `main_user_type`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `cloud_doctoruser`.`user_friend_request`  (
  `Id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `uuid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '好友申请uuid',
  `create_time` timestamp(0) NULL DEFAULT NULL COMMENT '好友请求时间',
  `recipient_Id` int(11) NULL DEFAULT NULL COMMENT '接收者Id',
  `recipient_type` int(11) NULL DEFAULT NULL COMMENT '接收者类型',
  `applicant_id` int(11) NULL DEFAULT NULL COMMENT '申请者Id',
  `applicant_type` int(11) NULL DEFAULT NULL COMMENT '申请者类型',
  `message` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '申请留言',
  `status` int(11) NULL DEFAULT NULL COMMENT '请求状态（0：待审核；1：审核通过）',
  `audit_time` timestamp(0) NULL DEFAULT NULL COMMENT '审核通过时间',
  `recipient_from` int(11) NULL DEFAULT NULL COMMENT '接收者（1：患者，2：医生）',
  `applicant_from` int(11) NULL DEFAULT NULL COMMENT '申请者（1：患者，2：医生）',
  `detail_data` varchar(4000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;


ALTER TABLE `cloud_doctoruser`.`doc_doctor_working_service` ADD CONSTRAINT `doc_doctor_working_service_ibfk_1` FOREIGN KEY (`working_service`) REFERENCES `cloud_doctoruser`.`doc_organ_working_service` (`x_id`) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE `cloud_doctoruser`.`doc_doctor_working_service` ADD CONSTRAINT `doc_doctor_working_service_ibfk_2` FOREIGN KEY (`doctor_work_id`) REFERENCES `cloud_doctoruser`.`doc_doctor_workplaces` (`x_id`) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE `cloud_doctoruser`.`doc_doctor_working_service` ADD INDEX `FK_Reference_10`(`working_service`) USING BTREE;

ALTER TABLE `cloud_doctoruser`.`doc_doctor_working_service` ADD INDEX `FK_Reference_22`(`doctor_work_id`) USING BTREE;

ALTER TABLE `cloud_doctoruser`.`doc_doctor_working_service` ADD INDEX `idx_doc_info_id_service_code_status`(`doctor_work_info_id`, `service_code`, `status`) USING BTREE;



CREATE DATABASE `consultation` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;


CREATE TABLE `consultation`.`app_patch_info`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `version_num` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '版本号',
  `patch_num` int(5) NULL DEFAULT NULL COMMENT '补丁号',
  `patch_desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '补丁描述',
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP,
  `status` int(3) NULL DEFAULT 1,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`app_versions_info`  (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `platform` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `md5` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `version_code` int(10) NULL DEFAULT 1,
  `version_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `version_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `file_size` bigint(60) NULL DEFAULT 61440000,
  `version_desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `is_on_line` int(1) NULL DEFAULT 1 COMMENT '判断接口是否上线',
  `is_force_update` int(1) NULL DEFAULT 1,
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `status` int(3) NULL DEFAULT 1,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`bd_organization`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `create_time` datetime(0) NULL DEFAULT NULL,
  `update_time` datetime(0) NULL DEFAULT NULL,
  `app_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '应用编码',
  `organ_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '机构编码',
  `organ_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院名称',
  `organ_address` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '机构地址',
  `organ_type` tinyint(2) NOT NULL DEFAULT 1 COMMENT '机构类型   1 人事机构医院   2 互联网平台医院',
  `telphone` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '医院电话',
  `standard_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '机构标准编码',
  `abbreviation` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '简称',
  `used_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '曾用名',
  `level` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '机构等级',
  `organ_category` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'WS218国标类别',
  `category_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT '' COMMENT 'WS218国标类别名称',
  `bed_num` int(5) NULL DEFAULT 0 COMMENT '床位数',
  `website` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '网址',
  `profile` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '简介',
  `introduction` varchar(5600) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '介绍',
  `logo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'LOGO',
  `country` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '国家-字典编码',
  `province` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '省-字典编码',
  `city` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '市-字典编码',
  `district` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '区-字典编码',
  `address` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '详细地址',
  `status` tinyint(1) NULL DEFAULT 1 COMMENT '状态',
  `dept_num` smallint(4) NULL DEFAULT 0 COMMENT '科室数量',
  `key_dept` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '重点科室名称（逗号分隔）',
  `rel_organ_id` int(11) NULL DEFAULT 0 COMMENT '关联执业机构ID',
  `level_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '机构等级名称',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `organ_code`(`organ_code`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`bill_info`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `multiple_account_rule_id` bigint(20) NULL DEFAULT NULL COMMENT '多医生分账规则表id',
  `order_id` bigint(20) NULL DEFAULT NULL COMMENT '订单表ID',
  `view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '-1:删除1:上线',
  `assign_status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '划拨状态 0未划拨 1已经划拨',
  `modifier_id` bigint(20) NULL DEFAULT NULL COMMENT '最后收益修改者ID',
  `modifier_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '最后收益修改者姓名',
  `apply_doctor_id` bigint(20) NOT NULL COMMENT '申请医生ID',
  `apply_doctor_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '申请医生姓名',
  `apply_doctor_income` decimal(10, 2) NOT NULL COMMENT '申请医生收益',
  `apply_hospital_id` bigint(20) NOT NULL COMMENT '申请医院ID',
  `apply_hospital_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '申请医院名称',
  `apply_dept_id` bigint(11) NULL DEFAULT NULL COMMENT '申请医生科室id',
  `apply_dept_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '申请医生科室名称',
  `apply_second_dept_id` bigint(11) NULL DEFAULT NULL COMMENT '申请医生二级科室id',
  `apply_second_dept_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '申请医生二级科室名称',
  `receive_doctor_id` bigint(20) NOT NULL COMMENT '接诊医生ID',
  `receive_doctor_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '接诊医生姓名',
  `receive_doctor_income` decimal(10, 2) NOT NULL COMMENT '接诊医生收益',
  `receive_hospital_id` bigint(20) NOT NULL COMMENT '接诊医院ID',
  `receive_hospital_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '接诊医院名称',
  `receive_dept_id` bigint(11) NOT NULL COMMENT '接诊医生科室id',
  `receive_dept_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '接诊医生科室名称',
  `receive_second_dept_id` bigint(11) NULL DEFAULT NULL COMMENT '接诊医生二级科室id',
  `receive_second_dept_name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '接诊医生二级科室名称',
  `whether_hand` int(11) NOT NULL DEFAULT 1 COMMENT '是否处理 0不处理 1处理',
  `pay_amount` decimal(10, 2) NULL DEFAULT NULL COMMENT '订单支付金额',
  `business_code` int(11) NOT NULL COMMENT '业务编码',
  `business_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '业务名称',
  `order_view_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '订单view_id',
  `remark` varchar(80) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `settlement_operator_id` bigint(20) NULL DEFAULT NULL COMMENT '结算操作人ID',
  `settlement_operator_name` varchar(80) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '结算操作人姓名',
  `settling_time` datetime(0) NULL DEFAULT NULL COMMENT '结算时间',
  `account_rule_name` varchar(80) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '冗余存储的分账规则名称',
  `allocation_type_code` int(11) NULL DEFAULT NULL COMMENT '冗余存储的分账方式编码',
  `allocation_type_name` varchar(80) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '冗余存储的分账方式名称',
  `schedule_code` int(11) NULL DEFAULT NULL,
  `schedule_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '分账划拨记录表' ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`business_message_info`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `msg_type` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `msg_content` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `file_url` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `recv_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `recv_type` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `send_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `send_type` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `send_time` timestamp(0) NULL DEFAULT NULL,
  `msg_uuid` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `chganeel_type` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `sensitive_type` int(11) NULL DEFAULT NULL,
  `source` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `group_user_ids` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `status` tinyint(1) NULL DEFAULT 0,
  `is_read` tinyint(1) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`case_referral`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `referral_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '转诊订单id',
  `case_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '病例id',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `status` int(4) NOT NULL DEFAULT 0 COMMENT '状态',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`consultation`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'uuid',
  `status` int(11) NOT NULL COMMENT '订单状态：',
  `group_id` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `doctor_id` bigint(11) NOT NULL COMMENT '陪诊医生id',
  `doctor_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '医生名字',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `application_channels` int(2) NOT NULL COMMENT '申请渠道 10:医联体下单 20:名院专家下单30:快速分配',
  `type` int(11) NOT NULL COMMENT '订单类型4:视频会诊5图文会诊',
  `service_code` int(11) NOT NULL DEFAULT 0 COMMENT '医生服务编码',
  `case_id` bigint(11) NOT NULL COMMENT '病例id',
  `dept_type` int(11) NOT NULL COMMENT '科室类型1:医院科室2：标准科室',
  `patient_id` bigint(22) NULL DEFAULT NULL COMMENT '患者id',
  `patient_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '患者名字',
  `expert_id` bigint(11) NULL DEFAULT NULL COMMENT '接诊医生id',
  `expert_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '专家名字',
  `expert_type` int(11) NULL DEFAULT NULL COMMENT '接诊医生类型',
  `expert_dep_id` bigint(11) NULL DEFAULT NULL COMMENT '接诊医生科室id',
  `expert_dep_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '专家科室名称',
  `expert_hospital_id` bigint(11) NULL DEFAULT NULL COMMENT '接诊医生医院id',
  `expert_hos_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '专家医院名称',
  `doctor_dep_id` bigint(11) NOT NULL COMMENT '陪诊医生科室id',
  `doctor_dep_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '医生科室名称',
  `doctor_hospital_id` bigint(11) NOT NULL COMMENT '陪诊医医院id',
  `doctor_hos_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '医生医院名称',
  `consultation_date` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '视频预约日期',
  `consultation_time` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '视频预约时间',
  `closed_time` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '订单关闭时间',
  `patient_signature` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '患者签名',
  `begin_time` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '订单开始时间',
  `finish_time` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '订单完成时间',
  `patient_signer_relationship` int(11) NULL DEFAULT 1 COMMENT '患者签名者关系 301:本人302：夫妻303:父母304：子女305：其他',
  `accept_time` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `patient_informed_consent_url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '患者知情同意书路径',
  `expert_second_dept_id` bigint(11) NULL DEFAULT NULL COMMENT '专家二级科室id',
  `expert_second_dept_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '专家二级科室名称',
  `doctor_second_dept_id` bigint(11) NULL DEFAULT NULL COMMENT '医生二级科室id',
  `doctor_second_dept_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医生二级科室名称',
  `accompany_appCode` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '陪诊医生的appCode',
  `pay_time` varchar(125) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '支付时间',
  `tencent_rong` tinyint(4) NULL DEFAULT 1 COMMENT 'IM 1:融云 2：腾讯',
  `report_status` tinyint(4) NULL DEFAULT 0 COMMENT '会诊报告 -1：删除  0：未传  1：正式  2：草稿',
  `group_url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '群组头像',
  `dynamic_id` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动态病例id',
  `distribution_describe` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分配 申请地区、医院、科室',
  `is_video_ongoing` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT '订单视频状态 1：正在视频中 0：不在视频中',
  `refund_reason` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '申请退款原因',
  `refuse_reason` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '拒绝退款原因',
  `is_refund` tinyint(2) NOT NULL DEFAULT 0 COMMENT '是否申请退款 0:未申请 1:已申请',
  `apply_refund_time` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '申请退款时间',
  `refund_status` tinyint(4) NULL DEFAULT NULL COMMENT '退款状态 10待审核 20审核通过 30审核不通过 40 退款成功',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_name`(`view_id`) USING BTREE,
  INDEX `index_expert_id`(`expert_id`) USING BTREE,
  INDEX `index_doctor_id`(`doctor_id`) USING BTREE,
  INDEX `index_hospital_id`(`doctor_hospital_id`) USING BTREE,
  INDEX `index_expert_hospital_id`(`expert_hospital_id`) USING BTREE,
  INDEX `index_status_type`(`status`, `type`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`consultation_copy1`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'uuid',
  `status` int(11) NOT NULL COMMENT '订单状态：',
  `group_id` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `doctor_id` bigint(11) NOT NULL COMMENT '陪诊医生id',
  `doctor_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '医生名字',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `application_channels` int(2) NOT NULL COMMENT '申请渠道 10:医联体下单 20:名院专家下单30:快速分配',
  `type` int(11) NOT NULL COMMENT '订单类型4:视频会诊5图文会诊',
  `service_code` int(11) NOT NULL DEFAULT 0 COMMENT '医生服务编码',
  `case_id` bigint(11) NOT NULL COMMENT '病例id',
  `dept_type` int(11) NOT NULL COMMENT '科室类型1:医院科室2：标准科室',
  `patient_id` bigint(20) NULL DEFAULT NULL COMMENT '患者id',
  `patient_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '患者名字',
  `expert_id` bigint(11) NULL DEFAULT NULL COMMENT '接诊医生id',
  `expert_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '专家名字',
  `expert_type` int(11) NULL DEFAULT NULL COMMENT '接诊医生类型',
  `expert_dep_id` bigint(11) NULL DEFAULT NULL COMMENT '接诊医生科室id',
  `expert_dep_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '专家科室名称',
  `expert_hospital_id` bigint(11) NULL DEFAULT NULL COMMENT '接诊医生医院id',
  `expert_hos_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '专家医院名称',
  `doctor_dep_id` bigint(11) NOT NULL COMMENT '陪诊医生科室id',
  `doctor_dep_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '医生科室名称',
  `doctor_hospital_id` bigint(11) NOT NULL COMMENT '陪诊医医院id',
  `doctor_hos_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '医生医院名称',
  `consultation_date` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '视频预约日期',
  `consultation_time` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '视频预约时间',
  `closed_time` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '订单关闭时间',
  `patient_signature` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '患者签名',
  `begin_time` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '订单开始时间',
  `finish_time` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '订单完成时间',
  `patient_signer_relationship` int(11) NULL DEFAULT 1 COMMENT '患者签名者关系 301:本人302：夫妻303:父母304：子女305：其他',
  `accept_time` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `patient_informed_consent_url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '患者知情同意书路径',
  `expert_second_dept_id` bigint(11) NULL DEFAULT NULL COMMENT '专家二级科室id',
  `expert_second_dept_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '专家二级科室名称',
  `doctor_second_dept_id` bigint(11) NULL DEFAULT NULL COMMENT '医生二级科室id',
  `doctor_second_dept_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医生二级科室名称',
  `accompany_appCode` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '陪诊医生的appCode',
  `pay_time` varchar(125) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '支付时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_name`(`view_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`consultation_extend`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `consultation_id` bigint(20) NOT NULL COMMENT '订单id',
  `status` int(11) NOT NULL DEFAULT 1,
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `price` decimal(11, 2) NOT NULL DEFAULT 0.00 COMMENT '订单价格',
  `pay_type` int(11) NULL DEFAULT 3 COMMENT '支付类型 3.正常 1.月结',
  `amission_fee` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '接诊费用',
  `accompany_fee` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '陪诊费用',
  `service_fee` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '服务费',
  `payment_voucher` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '支付上传凭证',
  `video_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '订单视频混流ID(接诊者)',
  `video_time` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '视频时间',
  `video_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '视频地址',
  `dcm_file_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT 'dcm文件信息',
  `dcm_pack_url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'Dcm压缩包文件路径',
  `pay_state` tinyint(4) NULL DEFAULT 1 COMMENT '支付状态  1未结算 2已结算',
  `closer_id` bigint(20) NOT NULL COMMENT '关闭者id',
  `closer_type` int(11) NOT NULL COMMENT '关闭者类型',
  `close_reason` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关闭原因',
  `expert_dist_code` bigint(11) NULL DEFAULT NULL COMMENT '专家区域码',
  `expert_phone` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `expert_first_deptId` bigint(20) NULL DEFAULT 0 COMMENT '专家一级科室ID',
  `expert_first_deptName` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '专家一级科室名称',
  `doctor_dist_code` bigint(11) NULL DEFAULT NULL COMMENT '医生区域码',
  `doctor_first_dept_id` bigint(11) NULL DEFAULT NULL COMMENT '医生一级科室id',
  `doctor_first_dept_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医生一级科室名称',
  `doctor_phone` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医生手机号码',
  `patient_sex` int(11) NULL DEFAULT 0,
  `patient_age` int(11) NULL DEFAULT 0,
  `patient_id_card` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `patient_phone` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `patient_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '患者就诊卡号',
  `user_phone` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `is_image_consultation` tinyint(4) NULL DEFAULT 0 COMMENT '是否是影像会诊1:是0:否',
  `image_consultation_time` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '影像会诊时长',
  `image_price` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '影像会诊价格',
  `clinical_appCode` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接诊医生的appCode',
  `initiator_type` tinyint(4) NOT NULL COMMENT '发起者类型1：患者发起2：医生发起',
  `qualified` tinyint(4) NULL DEFAULT NULL COMMENT '是否合格 合格：1 不合格:-1',
  `wechat_receipt` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '微信实际收款',
  `alipay_receipt` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '付宝实际收款',
  `operation_remark` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作人备注',
  `operator` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `mdt_pay_type` int(11) NULL DEFAULT NULL COMMENT '2:按科室 1：叠加',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_name`(`consultation_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`consultation_mdt`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'uuid',
  `status` int(11) NOT NULL COMMENT '-1：无效，201:未接诊，205:已接诊，210:报告已上传，215:已退回',
  `order_view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '订单uuid',
  `expert_id` bigint(11) NULL DEFAULT NULL COMMENT '专家id',
  `expert_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '专家姓名',
  `expert_type` int(11) NULL DEFAULT NULL COMMENT '专家类型',
  `expert_dep_id` bigint(11) NULL DEFAULT NULL COMMENT '专家科室ID',
  `expert_dep_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '专家科室名称',
  `expert_hospital_id` bigint(11) NULL DEFAULT NULL COMMENT '专家医院ID',
  `expert_hospital_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '专家医院名称',
  `accept_time` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '专家接诊时间',
  `expert_second_dept_id` bigint(11) NULL DEFAULT NULL COMMENT '专家二级科室id',
  `expert_second_dept_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '专家二级科室名称',
  `amission_fee` decimal(11, 2) NULL DEFAULT NULL COMMENT '接诊费用',
  `expert_dist_code` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '专家区域码',
  `expert_phone` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '专家手机号',
  `expert_first_deptId` bigint(11) NULL DEFAULT NULL COMMENT '专家一级科室id',
  `expert_first_deptName` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '专家一级科室名称',
  `clinical_appCode` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接诊医生的appCode',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `INDEX_ORDER_VIEW_ID`(`order_view_id`) USING BTREE,
  INDEX `INDEX_EXPERT_ID`(`expert_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`consultation_mdt_copy`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'uuid',
  `status` int(11) NOT NULL COMMENT '-1：无效，201:未接诊，205:已接诊，210:报告已上传，215:已退回',
  `order_view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '订单uuid',
  `expert_id` bigint(11) NULL DEFAULT NULL COMMENT '专家id',
  `expert_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '专家姓名',
  `expert_type` int(11) NULL DEFAULT NULL COMMENT '专家类型',
  `expert_dep_id` bigint(11) NULL DEFAULT NULL COMMENT '专家科室ID',
  `expert_dep_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '专家科室名称',
  `expert_hospital_id` bigint(11) NULL DEFAULT NULL COMMENT '专家医院ID',
  `expert_hospital_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '专家医院名称',
  `accept_time` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '专家接诊时间',
  `expert_second_dept_id` bigint(11) NULL DEFAULT NULL COMMENT '专家二级科室id',
  `expert_second_dept_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '专家二级科室名称',
  `amission_fee` decimal(11, 2) NULL DEFAULT NULL COMMENT '接诊费用',
  `expert_dist_code` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '专家区域码',
  `expert_phone` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '专家手机号',
  `expert_first_deptId` bigint(11) NULL DEFAULT NULL COMMENT '专家一级科室id',
  `expert_first_deptName` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '专家一级科室名称',
  `clinical_appCode` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接诊医生的appCode',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`consultation_merchant_config`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'id',
  `status` tinyint(4) NOT NULL COMMENT '状态 1:有效 -1：无效',
  `app_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '节点appCode(大写)',
  `merchant_seq` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '商户编码',
  `biz_sys_seq` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '业务系统编码',
  `old_node` tinyint(4) NOT NULL COMMENT '节点基础服务是否部署了华西的服务 1：佰医汇重构的服务 2：是华西的服务',
  `byh_merchant_seq` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `byh_sys_seq` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`consultation_pay_info`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'id',
  `view_id` bigint(11) NOT NULL COMMENT '返回id',
  `order_view_id` bigint(11) NOT NULL COMMENT '业务订单viewId',
  `order_type` tinyint(11) NOT NULL COMMENT '业务订单类型',
  `status` tinyint(4) NOT NULL COMMENT '状态 1:初始状态-1:已关闭交易2:交易支付成功9:管理员删除',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `merchant_seq` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '商户编号',
  `bizsys_seq` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '业务系统编号',
  `trade_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '交易号',
  `trade_type` tinyint(11) NOT NULL COMMENT '1:微信交易2:支付宝交易',
  `total_price` decimal(10, 2) NOT NULL COMMENT '总价格',
  `pay_price` decimal(10, 2) NOT NULL COMMENT '支付价格',
  `out_refund_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '退款单号',
  `operation_user_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '退款人id：用户中心id',
  `out_refund_status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '退款状态1：退款中 2：退款成功',
  `bank_trade_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '银行流水号',
  `payment_time` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '三方系统的支付时间',
  `refund_time` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '三方支付系统的退款时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`consultation_report`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `status` int(2) NOT NULL DEFAULT 0 COMMENT '删除标识:0:未删除-1:已删除',
  `order_view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '订单uuid',
  `order_type` int(2) NOT NULL COMMENT '订单类型4:视频5:图文',
  `diagnosis` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '主要判断',
  `treat_plan` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '治疗意见',
  `attentions` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '注意事项',
  `signature` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '数字签名',
  `photo_report` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '图文报告',
  `reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `mdt_view_id` varchar(125) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '多学科子订单uuid',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `order_view_id_index`(`order_view_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`consultation_special_configuration`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `status` tinyint(4) NOT NULL COMMENT '状态 1：有效2：无效',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `hospital_id` int(11) NOT NULL COMMENT '医院id',
  `configuration` bigint(11) NOT NULL COMMENT '配置code 视频查看:1001',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`consultation_status_log`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'id',
  `consultation_id` bigint(11) NOT NULL COMMENT '订单的id',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `view_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'viewId',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `from_status` tinyint(4) NOT NULL COMMENT '初始状态',
  `to_status` tinyint(4) NOT NULL COMMENT '定时修改后的状态',
  `expert_id` bigint(11) NULL DEFAULT NULL COMMENT '定时前的订单专家id',
  `price` decimal(10, 2) NULL DEFAULT NULL COMMENT '定时前的订单价格',
  `pay_type` tinyint(4) NULL DEFAULT NULL COMMENT '定时前的支付类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`consultation_transcode_video`  (
  `id` bigint(64) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增主键',
  `order_view_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '订单编号',
  `order_type` tinyint(4) NOT NULL COMMENT '订单类型',
  `file_id` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '腾讯视频id',
  `video_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '视频格式',
  `video_url` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '视频url',
  `duration` bigint(64) NOT NULL COMMENT '视频时长',
  `status` tinyint(4) NOT NULL COMMENT '是否有效数据',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`consultation_vedio`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键Id',
  `view_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '返回id',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `consultation_id` bigint(11) NOT NULL COMMENT '订单id',
  `consultation_type` tinyint(4) NOT NULL COMMENT '订单类型',
  `vedio_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '视频url',
  `start_time` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '开始时间',
  `end_time` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '结束时间',
  `duration` bigint(11) NOT NULL COMMENT '持续时间（单位秒）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`doctor_bill_info`  (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `uuid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'uuid',
  `doctor_id` bigint(11) NULL DEFAULT NULL COMMENT '医生id',
  `sponsor` tinyint(5) NULL DEFAULT 0 COMMENT '发起者，1医生  2患者  0其他',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `source` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '来源',
  `type` tinyint(11) NULL DEFAULT NULL COMMENT '1：收入；2：支出',
  `actual_money` decimal(10, 2) NULL DEFAULT NULL COMMENT '实际收入金额/实际支出金额(收入时=账单金额+补贴-税费；支出时=到账金额+税费）',
  `audit_money` decimal(10, 2) NULL DEFAULT NULL COMMENT '超管审核时的金额',
  `original_money` decimal(10, 2) NULL DEFAULT NULL COMMENT '账单金额/实际到账金额',
  `taxation_money` decimal(10, 2) NULL DEFAULT NULL COMMENT '扣除税费金额，收入时暂不扣税，提现扣税',
  `subsidy_money` decimal(10, 2) NULL DEFAULT NULL COMMENT '平台补贴金额，平台暂时没有补贴（收入时）',
  `cur_account` decimal(10, 2) NULL DEFAULT NULL COMMENT '当前账户余额（收入时=收支前余额 +实际收入金额）（提现时 = 收支前余额-实际支出账额）',
  `pre_account` decimal(10, 2) NULL DEFAULT NULL COMMENT '收支前余额',
  `remark` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `business_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '产生记录的业务关联UUID  或提现申请记录UUID',
  `business_type` int(11) NULL DEFAULT NULL COMMENT '业务类型 （-1：提现）',
  `status` tinyint(11) NULL DEFAULT 0 COMMENT '状态',
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`Id`) USING BTREE,
  INDEX `business_id`(`business_id`, `doctor_id`, `status`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`hospital_health_alliance`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `hospital_id` bigint(11) NOT NULL COMMENT '医院id',
  `hospital_level` int(11) NULL DEFAULT 0 COMMENT '医院等级',
  `ylt_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '医联体名称',
  `type` int(11) NULL DEFAULT 0 COMMENT '类型',
  `status` int(11) NOT NULL DEFAULT 0 COMMENT '状态:0：待审核 1：上线（审核通过）  -1：删除 -2：下线\'',
  `icon_url` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '医院logo',
  `profile` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '简介',
  `speciality` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '擅长',
  `applicant_id` int(11) NOT NULL COMMENT '申请者id',
  `applicant_type` int(11) NOT NULL COMMENT '申请者类型',
  `auditor_id` int(11) NULL DEFAULT NULL COMMENT '审核人id',
  `auditor_type` int(11) NULL DEFAULT NULL COMMENT '审核人类型',
  `audit_time` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '审核时间',
  `alliance_type` int(11) NULL DEFAULT 0,
  `app_code` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`hospital_health_alliance_member`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `status` int(11) NOT NULL COMMENT '状态:0：待审核 1：上线（审核通过）  -1：删除 -2：下线\'',
  `alliance_uuid` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '医联体uuid',
  `hospital_id` bigint(11) NOT NULL COMMENT '医院id',
  `hospital_level` int(11) NULL DEFAULT 0 COMMENT '医院等级',
  `role` int(11) NOT NULL COMMENT '角色 1：核心医院 2：合作医院',
  `parent_hos_id` bigint(11) NOT NULL COMMENT '父节点id',
  `parent_hos_level` int(11) NULL DEFAULT NULL COMMENT '父医院等级',
  `applicant_id` bigint(11) NOT NULL COMMENT '申请者id',
  `applicant_type` int(11) NOT NULL COMMENT '申请者类型',
  `auditor_id` bigint(11) NOT NULL COMMENT '审核人id',
  `auditor_type` int(11) NOT NULL COMMENT '审核人类型',
  `audit_time` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '审核时间',
  `app_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`hospital_health_alliance_service`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `status` int(11) NOT NULL DEFAULT 1 COMMENT '1为开启月结-1为关闭',
  `hospital_id` bigint(11) NOT NULL COMMENT '医院id',
  `parent_hos_id` bigint(11) NOT NULL COMMENT '父节点id',
  `service_id` int(11) NOT NULL COMMENT '服务id',
  `alliance_uuid` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '医联体id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`income_modify_record`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `bill_info_id` bigint(20) NOT NULL COMMENT '分账记录表id',
  `view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '-1:删除1:上线',
  `apply_doctor_income_bak` decimal(10, 2) NOT NULL COMMENT '申请医生收益修改前备份',
  `apply_doctor_income_after` decimal(10, 2) NOT NULL COMMENT '申请医生收益修改后',
  `receive_doctor_income_bak` decimal(10, 2) NOT NULL COMMENT '接诊医生收益修改前备份',
  `receive_doctor_income_after` decimal(10, 2) NOT NULL COMMENT '接诊医生收益修改后',
  `other_partake_income_bak` varchar(800) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '其它参与方收益修改前备份',
  `other_partake_income_after` varchar(800) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '其它参与方收益修改后',
  `modifier_id` bigint(20) NOT NULL COMMENT '修改者ID',
  `modifier_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '修改者姓名',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '收益修改记录表' ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`multiple_account_rule`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `status` tinyint(4) NULL DEFAULT 0 COMMENT '-1:删除1:上线',
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '分账规则名称',
  `allocation_type_code` int(11) NULL DEFAULT NULL COMMENT '划拨方式编码（1即时到账，2人工划拨，3定时划拨）',
  `allocation_type_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '划拨方式名称',
  `apply_amount_method_code` int(11) NULL DEFAULT NULL COMMENT '申请医生分账方式编码（1固定金额，或者2比例）',
  `apply_amount_method_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '申请医生分账方式名称',
  `apply_amount_standard` decimal(10, 2) NULL DEFAULT NULL COMMENT '申请医生分账标准',
  `receive_amount_method_code` int(11) NULL DEFAULT NULL COMMENT '接诊医生分账方式编码（1固定金额，或者2比例）',
  `receive_amount_method_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '接诊医生分账方式名称',
  `receive_amount_standard` decimal(10, 2) NULL DEFAULT NULL COMMENT '接诊医生分账标准',
  `schedule_code` int(11) NULL DEFAULT NULL COMMENT '定时间隔编码',
  `schedule_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '定时间隔名称',
  `business_code` int(11) NULL DEFAULT NULL COMMENT '业务编码',
  `business_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '业务名称',
  `whether_enable` int(11) NULL DEFAULT 0 COMMENT '是否启用 0不启用 1启用',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '分账规则表' ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`multiple_sphere`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `multiple_account_rule_id` bigint(20) NULL DEFAULT NULL COMMENT '多医生分账规则表id',
  `view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `status` tinyint(4) NULL DEFAULT 0 COMMENT '-1:删除1:上线',
  `app_code` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '平台code',
  `app_name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '平台名称',
  `hospital_id` bigint(20) NULL DEFAULT NULL COMMENT '医院ID',
  `hospital_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '医院名称',
  `second_dept_id` bigint(11) NULL DEFAULT NULL COMMENT '二级科室id',
  `second_dept_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '二级科室名称',
  `position_id` bigint(11) NULL DEFAULT NULL COMMENT '职称id',
  `position_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '职称名称',
  `doctor_id` bigint(11) NULL DEFAULT NULL COMMENT '医生id',
  `doctor_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '医生名称',
  `type` int(11) NULL DEFAULT NULL COMMENT '10代表申请医生 20代表接诊医生',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '作用范围表' ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`operation_log`  (
  `id` bigint(64) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `business_code` int(6) NOT NULL COMMENT '业务编码 1001：视频记录',
  `business_desc` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '业务编码描述',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `order_view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '订单编号',
  `record_log` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '记录日志',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`other_bill_info`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `bill_info_id` bigint(20) NOT NULL COMMENT '分账记录表id',
  `view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '-1:删除1:上线',
  `partake_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '参与方名称',
  `partake_income` decimal(10, 2) NOT NULL COMMENT '参与方收益',
  `other_partake_id` bigint(20) NOT NULL COMMENT '参与方分账规则id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '参与方收益记录表' ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`other_info_referral`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `other_info_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '其他信息id',
  `referral_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '转诊订单id',
  `type` int(4) NOT NULL DEFAULT 0 COMMENT '信息类别',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `status` int(4) NOT NULL DEFAULT 0 COMMENT '状态',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`other_partake`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `multiple_account_rule_id` bigint(20) NULL DEFAULT NULL COMMENT '多医生分账规则表id',
  `view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `status` tinyint(4) NULL DEFAULT 0 COMMENT '-1:删除1:上线',
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '参与方名称',
  `amount_method_code` int(11) NULL DEFAULT NULL COMMENT '分账方式编码（1固定金额，或者2比例）',
  `amount_method_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '分账方式名称',
  `amount_standard` decimal(10, 2) NULL DEFAULT NULL COMMENT '分账标准',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '其它参与方' ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`patient_case_info`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '患者病例表唯一标识',
  `patient_id` bigint(20) NULL DEFAULT NULL COMMENT '用户id',
  `patient_view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '患者viewid',
  `case_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '疾病',
  `keywords` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关键字',
  `disease_des` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '疾病',
  `main_suit` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '主诉',
  `past_history` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '既往史',
  `family_history` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '家庭病史',
  `present_history` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '现病史/病情描述',
  `examined` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '体检',
  `assistant_result` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '辅检',
  `inital_diagnosis` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '诊断',
  `treat_advice` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '治疗意见',
  `normal_images` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '其他病例图片',
  `check_report_images` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '检查报告（图片）',
  `radio_graph_film_images` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '影像胶片（图片）',
  `ask_problem` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '咨询问题',
  `is_resouce` int(1) NULL DEFAULT NULL COMMENT '1-资料库病例',
  `status` int(1) NOT NULL COMMENT '状态',
  `hospital_id` bigint(20) NULL DEFAULT NULL COMMENT '医院id',
  `primary_diagno` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '初步诊断',
  `consult_aim` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '会诊目的',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0),
  `medication_history` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '用药史',
  `case_type` int(1) NULL DEFAULT NULL,
  `dept_common_id` bigint(11) NULL DEFAULT NULL,
  `dept_common_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `dept_detail_id` bigint(11) NULL DEFAULT NULL,
  `dept_detail_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `doctor_id` bigint(11) NULL DEFAULT NULL,
  `doctor_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `manual_date` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `patient_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `hospital_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `allergy` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '过敏史',
  `diagnosis_location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '诊断位置',
  `symptoms_size` bigint(11) NULL DEFAULT NULL COMMENT '尺寸',
  `changes_color` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '病变颜色',
  `palpability` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '可触知性',
  `probability` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '恶性概率',
  `patients_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '患者地址',
  `vitiligo_patches` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '皮损位置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`patient_other_info`  (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `patient_id` bigint(11) NOT NULL COMMENT '患者id',
  `hospital_id` bigint(11) NOT NULL COMMENT '医院id',
  `data_type` int(1) NOT NULL COMMENT '数据类型',
  `Info_type` int(1) NOT NULL COMMENT '信息类型',
  `image_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '图片id',
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '内容',
  `create_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `status` int(1) NOT NULL COMMENT '状态',
  `dept_common_id` bigint(11) NULL DEFAULT NULL COMMENT '一级科室id',
  `dept_common_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '一级科室名',
  `dept_detail_id` bigint(11) NULL DEFAULT NULL COMMENT '二级科室id',
  `dept_detail_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '二级科室名',
  `doctor_id` bigint(11) NULL DEFAULT NULL COMMENT '医生名',
  `doctor_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医生id',
  `manual_date` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '手工录入时间',
  `hospital_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`patient_surgery_info`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `patient_id` bigint(20) NOT NULL COMMENT '患者id',
  `hospital_id` bigint(20) NOT NULL COMMENT '医院id',
  `data_type` int(255) NOT NULL COMMENT '数据类型',
  `image_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '图片id',
  `the_procedure` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '手术过程',
  `preoperative_diagnosis` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '术前诊断',
  `postoperative_diagnosis` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '术后诊断',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '手术名称',
  `performer` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '术者',
  `anesthesia_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '麻醉类型',
  `start_time` datetime(0) NULL DEFAULT NULL COMMENT '开始时间',
  `end_time` datetime(0) NULL DEFAULT NULL COMMENT '结束时间',
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `status` int(1) NOT NULL COMMENT '删除状态',
  `hospital_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`referral`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `type` int(255) NOT NULL COMMENT '类型：1上转，2回转',
  `patient_id` bigint(25) NOT NULL COMMENT '患者id',
  `patient_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '患者姓名',
  `patient_age` int(3) NOT NULL COMMENT '患者年龄',
  `patient_gender` int(1) NOT NULL COMMENT '患者性别',
  `patient_phone` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '患者联系电话',
  `hospital_id` bigint(20) NOT NULL COMMENT '转出医院id',
  `hospital_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '转出医院名称',
  `dept_common_id` bigint(20) NOT NULL COMMENT '一级科室id',
  `dept_detail_id` bigint(20) NOT NULL COMMENT '二级科室id',
  `dept_common_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '一级科室名称',
  `dept_detail_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '二级科室名称',
  `doctor_id` bigint(20) NOT NULL COMMENT '转诊医生id',
  `doctor_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '转诊医生名称',
  `receive_hospital_id` bigint(20) NOT NULL COMMENT '接受医院id',
  `receive_hospital_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '接收医院名称',
  `receive_dept_common_id` bigint(20) NOT NULL COMMENT '接收一级科室id',
  `receive_dept_detail_id` bigint(20) NOT NULL COMMENT '接收医院二级科室id',
  `receive_dept_common_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '接受医院一级科室名称',
  `receive_dept_detail_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '接收医院二级科室名称',
  `receive_doctor_id` bigint(20) NULL DEFAULT NULL COMMENT '接收医生id',
  `receive_doctor_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接收医生姓名',
  `receive_date` date NOT NULL COMMENT '接收时间',
  `state` tinyint(4) NOT NULL COMMENT '状态：10待审核，20已审核，30已拒绝，',
  `reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '拒绝原因',
  `status` tinyint(4) NULL DEFAULT NULL,
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `view_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `primary_diagno` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '初步诊断',
  `referral_purpose` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '转诊目的',
  `patient_card_no` varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '身份证号',
  `app_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`rtc_room`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'id',
  `view_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'uuid',
  `order_id` int(11) NOT NULL COMMENT '订单id',
  `order_type` int(11) NOT NULL COMMENT '订单类型',
  `status` tinyint(4) NOT NULL COMMENT '数据状态',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_order_id`(`order_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`service_merchant_config`  (
  `x_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `x_create_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '备注',
  `status` int(8) NULL DEFAULT NULL COMMENT '状态',
  `merchant_seq` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '对应应用code',
  `app_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '节点code',
  `organ_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '医院首字母',
  `biz_sys_seq` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '业务系统编码',
  `apply_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '应用id',
  `apply_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '应用key',
  `apply_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '应用名称',
  PRIMARY KEY (`x_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`service_pay_bill`  (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '订单生成时间',
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '订单更新时间',
  `status` int(255) NULL DEFAULT NULL COMMENT '状态 0未知，1待支付，2支付中，3已支付，4支付失败，5退款中，6已退款，7退款失败',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '备注',
  `app_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '节点code',
  `organ_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '医院首字母',
  `work_service_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '业务code',
  `apply_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '应用code',
  `pay_channel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '支付渠道',
  `trade_time` timestamp(0) NULL DEFAULT NULL COMMENT '交易时间',
  `trade_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '交易第三方流水号',
  `out_trade_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '业务流水号',
  `trade_status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '支付状态:SUCCESS ,FAIL',
  `order_amount` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '订单金额',
  `deal_amount` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '交易金额',
  `refund_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '退款第三方流水号',
  `out_refund_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '退款业务流水号',
  `refund_time` timestamp(0) NULL DEFAULT NULL COMMENT '退款时间',
  `refund_amount` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '退款金额',
  `goods_info` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '商品信息',
  `service_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '节点code_organName_业务编码 例:BYH_LYSZX_YCHZ',
  `deal_trade_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '平台交易号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`show_department`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `view_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '-1:删除1:上线',
  `dept_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '科室名称',
  `dept_description` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '科室描述',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'show科室表' ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`show_doctor_expert`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `show_department_id` bigint(20) NOT NULL COMMENT 'show科室表id',
  `view_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '-1:删除1:上线',
  `city` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '所在省市',
  `name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '专家姓名',
  `hospital` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '所属医院',
  `position` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '职位',
  `working_years` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '从业年限',
  `expertise_areas` varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '擅长领域',
  `personal_profile` varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '个人简介',
  `achievement` varchar(800) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '成就',
  `portrait_url` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '头像url地址',
  `real_department` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '真正的所在科室',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'show医生表' ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`show_practising_experience`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `show_doctor_expert_id` bigint(20) NOT NULL COMMENT 'show医生表id',
  `view_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '-1:删除1:上线',
  `practising_experience` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '执业经历描述',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'show执业经历表' ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`super_admin_user`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `login_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `nickname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `password` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `viewId` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `token` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `role_type` int(3) NULL DEFAULT 1,
  `status` int(3) NULL DEFAULT 1,
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP,
  `mobile_number` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `consultation`.`surgery_referral`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `referral_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '转诊id',
  `surgery_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '手术记录id',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `status` int(4) NOT NULL DEFAULT 0 COMMENT '状态',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE DEFINER = `root`@`%` FUNCTION `consultation`.`getDoctor`(view_id VARCHAR(64), type tinyint(4) , param VARCHAR(256))
 RETURNS varchar(1000) CHARSET utf8mb4
  READS SQL DATA
BEGIN
SET @str= '';
IF type = 2
THEN
		SELECT
			GROUP_CONCAT( tt2 SEPARATOR '、' ) INTO @str
		FROM
		(
			SELECT
				 b.expert_name AS tt2
			FROM
				consultation_mdt AS b
			WHERE
				b.order_view_id = view_id AND
				b.expert_name IS NOT NULL AND b.expert_name <> ''
				AND b.status != -1
				group by b.order_view_id
		) t1;

			IF @str IS NULL THEN
					SELECT a.expert_name INTO @str
					FROM consultation AS a
					WHERE
					a.view_id = view_id
					group by a.view_id;
			END IF;

		IF @str IS NOT NULL AND @str <> ''
		THEN
				SET @str = CONCAT_WS('、',param, @str);
		ELSE
				SET @str = param;
		END IF;

ELSEIF type = 3
THEN
		SELECT
			GROUP_CONCAT( tt2 SEPARATOR '、') INTO @str
		FROM
		(
			SELECT
				 b.expert_name AS tt2
			FROM
				consultation_mdt AS b
			WHERE
				b.order_view_id = view_id  AND
				b.expert_name IS NOT NULL AND b.expert_name <> ''
				AND b.status != -1
				group by b.order_view_id
		) t1;

			IF @str IS NULL THEN
					SET @str = param;
			END IF;

ELSEIF type = 4
THEN
		SELECT
			GROUP_CONCAT( tt SEPARATOR '、') INTO @str
		FROM
			(
			SELECT
				CONCAT_WS(param, b.expert_hospital_name,b.expert_name ) AS tt
			FROM
				consultation_mdt AS b
			WHERE
				b.order_view_id = view_id AND
				b.expert_name IS NOT NULL AND b.expert_name <> ''
				AND b.status != -1
				group by b.order_view_id
			) t1 ;

			IF @str IS NULL THEN
					SELECT CONCAT_WS(param,
					CASE WHEN a.expert_hos_name IS NOT NULL AND a.expert_hos_name <> '' THEN a.expert_hos_name ELSE '暂定' END,
					CASE WHEN a.expert_dep_name IS NOT NULL AND a.expert_dep_name <> '' THEN a.expert_dep_name ELSE '暂定' END,
					CASE WHEN a.expert_name IS NOT NULL AND a.expert_name <> '' THEN a.expert_name ELSE '暂定' END
					) INTO @str
					FROM consultation AS a
					WHERE
					a.view_id = view_id
					group by a.view_id;
			END IF;

ELSE
		SELECT
			GROUP_CONCAT( tt SEPARATOR '、') INTO @str
		FROM
			(
			SELECT
				CONCAT_WS(param, b.expert_hospital_name,b.expert_dep_name,b.expert_name ) AS tt
			FROM
				consultation_mdt AS b
			WHERE
				b.order_view_id = view_id AND
				b.expert_name IS NOT NULL AND b.expert_name <> ''
				AND b.status != -1
			group by b.view_id
			) t1;

			IF @str IS NULL THEN
					SELECT CONCAT_WS(param,
					CASE WHEN a.expert_hos_name IS NOT NULL AND a.expert_hos_name <> '' THEN a.expert_hos_name ELSE '暂定' END,
					CASE WHEN a.expert_dep_name IS NOT NULL AND a.expert_dep_name <> '' THEN a.expert_dep_name ELSE '暂定' END,
					CASE WHEN a.expert_name IS NOT NULL AND a.expert_name <> '' THEN a.expert_name ELSE '暂定' END
					) INTO @str
					FROM consultation AS a
					WHERE
					a.view_id = view_id
					group by a.view_id;
			END IF;

END IF;

		RETURN @str;
END;



CREATE DATABASE `dispatch_center` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- ----------------------------
-- Table structure for app_server_info
-- ----------------------------
DROP TABLE IF EXISTS `dispatch_center`.`app_server_info`;
CREATE TABLE `dispatch_center`.`app_server_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `intranet_ip` varchar(16) DEFAULT NULL COMMENT '内网ip',
  `extranet_ip` varchar(128) DEFAULT NULL COMMENT '外网ip',
  `app_port` varchar(16) NOT NULL COMMENT '应用端口号',
  `status` int(4) NOT NULL COMMENT '状态',
  `remark` varchar(64) DEFAULT NULL COMMENT '备注',
  `view_id` varchar(32) NOT NULL COMMENT '唯一标识',
  `app_code` varchar(24) NOT NULL,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `application_name` varchar(64) NOT NULL,
  `ip_type` int(2) DEFAULT NULL COMMENT '1是内网ip 2是外网ip 3是域名',
  `domain_name` varchar(64) DEFAULT NULL COMMENT '域名',
  `need_prefix` int(2) DEFAULT NULL COMMENT '是否需要前缀',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for push_config
-- ----------------------------
DROP TABLE IF EXISTS `dispatch_center`.`push_config`;
CREATE TABLE `dispatch_center`.`push_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `app_code` varchar(50) DEFAULT NULL,
  `sms_client_code` varchar(50) DEFAULT NULL,
  `sign_code` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for push_url_info
-- ----------------------------
DROP TABLE IF EXISTS `dispatch_center`.`push_url_info`;
CREATE TABLE `dispatch_center`.`push_url_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `node_url` varchar(100) DEFAULT NULL,
  `cloud_url` varchar(100) DEFAULT NULL,
  `add_param` varchar(100) DEFAULT NULL,
  `del_param` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for system_param_config
-- ----------------------------
DROP TABLE IF EXISTS `dispatch_center`.`system_param_config`;
CREATE TABLE `dispatch_center`.`system_param_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `param_key` varchar(128) NOT NULL,
  `param_value` varchar(1024) NOT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;


CREATE DATABASE `ehos_im` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- ----------------------------
-- Table structure for im_account
-- ----------------------------
DROP TABLE IF EXISTS `ehos_im`.`im_account`;
CREATE TABLE `ehos_im`.`im_account` (
  `id` varchar(100) NOT NULL COMMENT '主键id',
  `create_date_time` varchar(20) DEFAULT '' COMMENT '创建时间',
  `create_user` varchar(64) DEFAULT NULL COMMENT '创建人姓名（好像没有用到）',
  `update_date_time` varchar(20) DEFAULT '' COMMENT '更新时间',
  `update_user` varchar(64) DEFAULT NULL COMMENT '更新人姓名（目前好像没有使用）',
  `app_id` varchar(16) DEFAULT NULL COMMENT 'im_application表id（外键）',
  `from_nick` varchar(50) DEFAULT NULL COMMENT '昵称',
  `line_status` int(5) DEFAULT NULL COMMENT '在线状态',
  `reseaon` varchar(100) DEFAULT NULL COMMENT '在线离线的状态描述',
  `sdk_account` varchar(60) DEFAULT NULL COMMENT '可以进行聊天的账户',
  `user_id` varchar(60) DEFAULT NULL COMMENT '用户中心的user_id（和业务系统关联的切入口）',
  `application_account` varchar(255) DEFAULT NULL COMMENT '没有用到的字段（可能已经废弃）',
  `head_url` varchar(500) DEFAULT NULL COMMENT '头像',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `userId_appId` (`app_id`,`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for im_application
-- ----------------------------
DROP TABLE IF EXISTS `ehos_im`.`im_application`;
CREATE TABLE `ehos_im`.`im_application` (
  `id` varchar(255) NOT NULL COMMENT '主键ID',
  `create_date_time` varchar(20) NOT NULL COMMENT '创建时间',
  `update_user` varchar(64) DEFAULT NULL COMMENT '更新人姓名',
  `app_code` varchar(255) NOT NULL COMMENT '平台编码',
  `app_name` varchar(255) DEFAULT NULL COMMENT '平台名称',
  `app_sdk_id` varchar(255) DEFAULT NULL COMMENT '相当于应用标识',
  `app_sdk_type` int(11) DEFAULT NULL COMMENT 'sdk类型（应该没有什么用）',
  `sys_admin` varchar(255) DEFAULT NULL COMMENT 'Im应用的管理员名称',
  `account_type` varchar(50) DEFAULT NULL COMMENT '账户类型',
  `secret_id` varchar(255) DEFAULT NULL COMMENT '腾讯云api接口访问id',
  `secret_key` varchar(255) DEFAULT NULL COMMENT '腾讯云api接口访问secret',
  `create_user` varchar(255) DEFAULT NULL COMMENT '创建人姓名',
  `update_date_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `app_code` (`app_code`) USING BTREE,
  KEY `app_sdk_id` (`app_sdk_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for im_busi_data
-- ----------------------------
DROP TABLE IF EXISTS `ehos_im`.`im_busi_data`;
CREATE TABLE `ehos_im`.`im_busi_data` (
  `id` varchar(255) NOT NULL COMMENT '主键ID',
  `create_date_time` varchar(20) NOT NULL COMMENT '创建时间',
  `create_user` varchar(64) DEFAULT NULL COMMENT '创建人',
  `update_date_time` varchar(20) DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(64) DEFAULT NULL COMMENT '更新人',
  `adm_end_date` varchar(255) DEFAULT NULL COMMENT '就诊开始日期',
  `adm_start_date` varchar(255) DEFAULT NULL COMMENT '就诊结束日期',
  `app_status` varchar(255) DEFAULT NULL COMMENT '预约状态    0 新预约状态  1 稍后状态(已结束、延时)',
  `appointment_id` varchar(255) DEFAULT NULL COMMENT '就诊ID',
  `busi_code` varchar(255) DEFAULT NULL COMMENT '业务Code',
  `user_id` varchar(255) DEFAULT NULL COMMENT '用户ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for im_busi_push_config
-- ----------------------------
DROP TABLE IF EXISTS `ehos_im`.`im_busi_push_config`;
CREATE TABLE `ehos_im`.`im_busi_push_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `push_type` varchar(64) DEFAULT NULL COMMENT '推送类型，离线消息，视频处理结果推送...',
  `busi_code` varchar(64) DEFAULT NULL COMMENT '业务Code',
  `domain` varchar(64) DEFAULT NULL COMMENT '域名',
  `uri` varchar(255) DEFAULT NULL COMMENT 'get请求uri以?结尾',
  `params` varchar(255) DEFAULT NULL COMMENT '推送到业务方参数，区分大小写，逗号分隔',
  `method` varchar(64) DEFAULT NULL COMMENT '请求类型  GET,POST...',
  `media_type` varchar(64) DEFAULT 'Json' COMMENT '数据交互类型',
  `status` smallint(11) DEFAULT '0' COMMENT '状态：0开启，1关闭',
  `enable_type` varchar(64) DEFAULT NULL COMMENT '类型，http,mq....',
  `exchange` varchar(255) DEFAULT NULL COMMENT 'mq交换机名称',
  `product_code` varchar(255) DEFAULT NULL COMMENT '产品类型',
  `route_key` varchar(255) DEFAULT NULL COMMENT 'routeKey',
  `create_user` varchar(255) DEFAULT NULL COMMENT '创建人',
  `create_date_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_date_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for im_busi_push_log
-- ----------------------------
DROP TABLE IF EXISTS `ehos_im`.`im_busi_push_log`;
CREATE TABLE `ehos_im`.`im_busi_push_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `url` varchar(255) DEFAULT NULL COMMENT '推送域名',
  `status` smallint(16) DEFAULT NULL COMMENT '状态',
  `request_params` text COMMENT '入参',
  `response_result` varchar(255) DEFAULT NULL COMMENT '结果',
  `create_date_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_date_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for im_group_msg
-- ----------------------------
DROP TABLE IF EXISTS `ehos_im`.`im_group_msg`;
CREATE TABLE `ehos_im`.`im_group_msg` (
  `id` varchar(255) NOT NULL COMMENT '主键ID',
  `create_date_time` varchar(20) NOT NULL COMMENT '创建时间',
  `create_user` varchar(64) DEFAULT NULL COMMENT '创建人',
  `update_date_time` varchar(20) DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(64) DEFAULT NULL COMMENT '更新人',
  `api_msg_id` varchar(255) DEFAULT NULL COMMENT '存储的值未知',
  `client_msg_id` varchar(255) DEFAULT NULL COMMENT '客户端自定义消息主键',
  `duration` int(11) DEFAULT NULL COMMENT '语音时长',
  `group_id` varchar(255) DEFAULT NULL COMMENT '腾讯生成的群组标识',
  `msg_content` text COMMENT '消息内容',
  `msg_time` varchar(255) DEFAULT NULL COMMENT '消息发送时间   以腾讯云推送时间为准',
  `msg_type` varchar(255) DEFAULT NULL COMMENT '消息类型',
  `opt_platform` varchar(255) DEFAULT NULL COMMENT '发送者操作平台',
  `receiver_id` varchar(255) DEFAULT NULL COMMENT '接收者id',
  `sender_id` varchar(255) DEFAULT NULL COMMENT '发送者id',
  `session_id` varchar(255) DEFAULT NULL COMMENT 'im_session表id（外键）',
  `time_stamp` bigint(20) DEFAULT NULL COMMENT '时间戳',
  `status` int(11) DEFAULT '0' COMMENT '0正常，-1撤回',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for im_group_msg_relation
-- ----------------------------
DROP TABLE IF EXISTS `ehos_im`.`im_group_msg_relation`;
CREATE TABLE `ehos_im`.`im_group_msg_relation` (
  `id` varchar(255) NOT NULL COMMENT '主键ID',
  `create_date_time` varchar(20) NOT NULL COMMENT '创建时间',
  `create_user` varchar(64) DEFAULT NULL COMMENT '创建人',
  `update_date_time` varchar(20) DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(64) DEFAULT NULL COMMENT '更新人',
  `group_msg_id` varchar(255) DEFAULT NULL COMMENT 'im_group_msg表id（外键）',
  `receiver_id` varchar(255) DEFAULT NULL COMMENT 'im_account表id（外键）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for im_live_application
-- ----------------------------
DROP TABLE IF EXISTS `ehos_im`.`im_live_application`;
CREATE TABLE `ehos_im`.`im_live_application` (
  `id` varchar(255) NOT NULL COMMENT '主键ID',
  `create_date_time` varchar(20) NOT NULL COMMENT '创建时间',
  `create_user` varchar(64) DEFAULT NULL COMMENT '创建人',
  `update_date_time` varchar(20) DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(64) DEFAULT NULL COMMENT '更新人',
  `anti_theft_chain` varchar(255) DEFAULT NULL COMMENT '推流防盗链key',
  `api_key` varchar(255) DEFAULT NULL COMMENT 'API鉴权key',
  `app_id` varchar(255) DEFAULT NULL COMMENT '直播信息:appId',
  `biz_id` varchar(255) DEFAULT NULL COMMENT 'bizid',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for im_media_process
-- ----------------------------
DROP TABLE IF EXISTS `ehos_im`.`im_media_process`;
CREATE TABLE `ehos_im`.`im_media_process` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `file_id` varchar(255) DEFAULT NULL COMMENT '文件id',
  `video_url` varchar(255) DEFAULT NULL COMMENT '视频url',
  `video_id` varchar(255) DEFAULT NULL COMMENT '视频id',
  `duration` varchar(255) DEFAULT NULL COMMENT '文件时长',
  `start_time` varchar(255) DEFAULT NULL COMMENT '视频开始时间',
  `end_time` varchar(255) DEFAULT NULL COMMENT '视频结束时间',
  `task_id` varchar(255) DEFAULT NULL COMMENT '任务id',
  `type` smallint(11) DEFAULT NULL COMMENT '处理类型',
  `size` bigint(64) DEFAULT NULL COMMENT '文件大小',
  PRIMARY KEY (`id`),
  KEY `file_id` (`file_id`(191))
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for im_member
-- ----------------------------
DROP TABLE IF EXISTS `ehos_im`.`im_member`;
CREATE TABLE `ehos_im`.`im_member` (
  `id` varchar(255) NOT NULL COMMENT '主键ID',
  `create_date_time` varchar(20) NOT NULL COMMENT '创建时间',
  `create_user` varchar(64) DEFAULT NULL COMMENT '创建人',
  `update_date_time` varchar(20) DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(64) DEFAULT NULL COMMENT '更新人',
  `account_id` varchar(60) NOT NULL COMMENT 'im_account表id（外键）',
  `doctor_id` varchar(60) DEFAULT NULL COMMENT '医生id（可能是业务服务的医生）',
  `hospital_id` varchar(60) DEFAULT NULL COMMENT '医院id（可能是业务服务的医院）',
  `pat_id_card` varchar(20) DEFAULT NULL COMMENT '患者身份证',
  `patient_id` varchar(60) DEFAULT NULL COMMENT '患者标识',
  `session_id` varchar(60) NOT NULL COMMENT 'im_session表id（外键）',
  `talk_permiss` varchar(10) DEFAULT NULL COMMENT '会话id',
  `mix_flow_type` varchar(255) DEFAULT NULL COMMENT '发言权限  0=无    1=有',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sessId_mem` (`session_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for im_message
-- ----------------------------
DROP TABLE IF EXISTS `ehos_im`.`im_message`;
CREATE TABLE `ehos_im`.`im_message` (
  `id` varchar(255) NOT NULL COMMENT '主键ID',
  `create_date_time` varchar(20) NOT NULL COMMENT '创建时间',
  `create_user` varchar(64) DEFAULT NULL COMMENT '创建人',
  `update_date_time` varchar(20) DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(64) DEFAULT NULL COMMENT '更新人',
  `api_msg_id` varchar(255) DEFAULT NULL COMMENT '腾讯云消息主键（这边描述不准确）',
  `client_msg_id` varchar(255) DEFAULT NULL COMMENT '客户端自定义消息主键',
  `duration` int(11) DEFAULT NULL COMMENT '语音时长',
  `message` text CHARACTER SET utf8mb4 COMMENT '消息内容',
  `msg_time` varchar(255) DEFAULT NULL COMMENT '消息时间',
  `msg_type` varchar(50) DEFAULT NULL COMMENT '消息类型',
  `opt_platform` varchar(20) DEFAULT NULL COMMENT '发送者操作平台',
  `receiver_id` varchar(255) DEFAULT NULL COMMENT '接收者id',
  `sender_id` varchar(255) DEFAULT NULL COMMENT '发送者id',
  `session_id` varchar(255) DEFAULT NULL COMMENT '会话id',
  `time_stamp` bigint(20) DEFAULT NULL COMMENT '时间戳',
  `status` int(11) DEFAULT '0' COMMENT '0正常，-1撤回',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sessId` (`session_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for im_mixted_flow
-- ----------------------------
DROP TABLE IF EXISTS `ehos_im`.`im_mixted_flow`;
CREATE TABLE `ehos_im`.`im_mixted_flow` (
  `id` varchar(255) NOT NULL COMMENT '主键ID',
  `create_date_time` varchar(20) NOT NULL COMMENT '创建时间',
  `create_user` varchar(64) DEFAULT NULL COMMENT '创建人',
  `update_date_time` varchar(20) DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(64) DEFAULT NULL COMMENT '更新人',
  `call_back_business` varchar(255) DEFAULT NULL COMMENT '是否已回调    0 初始化状态  1 已回调业务系统',
  `call_back_params` text COMMENT '腾讯回调的参数',
  `call_backed_tencent` varchar(255) DEFAULT NULL COMMENT '是否已回调    0 初始化状态  1 腾讯已回调',
  `event_id` varchar(255) DEFAULT NULL COMMENT '每次请求的event_id',
  `mix_stream_session_id` varchar(255) DEFAULT NULL COMMENT '每次请求混流的sessin_id',
  `product_id` varchar(255) DEFAULT NULL COMMENT '产品ID',
  `request_params` varchar(255) DEFAULT NULL COMMENT '请求参数',
  `timestamp` bigint(20) DEFAULT NULL COMMENT '时间戳',
  `tx_result` varchar(255) DEFAULT NULL COMMENT '当前请求混流腾讯返回的结果',
  `session_id` varchar(255) DEFAULT NULL COMMENT 'im_session表id（外键）',
  `sign` varchar(255) DEFAULT NULL COMMENT '签名未知',
  `stream_id` varchar(255) DEFAULT NULL COMMENT '流id未知',
  `video_id` varchar(255) DEFAULT NULL COMMENT '腾讯返回的video_id',
  `file_id` varchar(255) DEFAULT NULL COMMENT '腾讯返回的文件id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for im_online_status
-- ----------------------------
DROP TABLE IF EXISTS `ehos_im`.`im_online_status`;
CREATE TABLE `ehos_im`.`im_online_status` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `sdk_account` varchar(64) DEFAULT '' COMMENT '腾讯im账号',
  `opt_platform` varchar(64) DEFAULT NULL COMMENT '操作平台',
  `online_status` varchar(32) DEFAULT NULL COMMENT '在线状态',
  `reason` varchar(32) DEFAULT NULL COMMENT '状态更改原因',
  `sdk_appId` varchar(32) DEFAULT NULL COMMENT '腾讯那边的sdk_appId',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `sdk_account` (`sdk_account`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for im_product_type
-- ----------------------------
DROP TABLE IF EXISTS `ehos_im`.`im_product_type`;
CREATE TABLE `ehos_im`.`im_product_type` (
  `id` varchar(255) NOT NULL COMMENT '主键ID',
  `create_date_time` varchar(20) NOT NULL COMMENT '创建时间',
  `create_user` varchar(64) DEFAULT NULL COMMENT '创建人',
  `update_date_time` varchar(20) DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(64) DEFAULT NULL COMMENT '更新人',
  `enable_type` varchar(255) DEFAULT NULL COMMENT '当前启用的回调类型',
  `exchange` varchar(255) DEFAULT NULL COMMENT '交换机名称',
  `http_url` varchar(255) DEFAULT NULL COMMENT '回调地址',
  `product_code` varchar(255) DEFAULT NULL COMMENT '产品类型',
  `route_key` varchar(255) DEFAULT NULL COMMENT 'Mq的路由key',
  `busi_code` varchar(255) DEFAULT NULL COMMENT '业务code',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for im_session
-- ----------------------------
DROP TABLE IF EXISTS `ehos_im`.`im_session`;
CREATE TABLE `ehos_im`.`im_session` (
  `id` varchar(100) NOT NULL COMMENT '主键ID',
  `create_date_time` varchar(20) NOT NULL COMMENT '创建时间',
  `create_user` varchar(64) DEFAULT NULL COMMENT '创建人',
  `update_date_time` varchar(20) DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(64) DEFAULT NULL COMMENT '更新人',
  `business_code` varchar(30) DEFAULT NULL COMMENT '业务编码',
  `group_die` varchar(10) DEFAULT NULL COMMENT '该群是否已销毁   只在类型是2时生效',
  `group_id` varchar(60) DEFAULT NULL COMMENT '群组id',
  `room_num` bigint(20) DEFAULT NULL COMMENT '房间号',
  `treatment_id` varchar(100) DEFAULT NULL COMMENT '订单id',
  `type` varchar(10) DEFAULT NULL COMMENT '会话类型',
  `business_node_code` varchar(32) DEFAULT NULL COMMENT '对应业务方appcode,如ZRYH',
  `group_name` varchar(255) DEFAULT NULL COMMENT '群组名称',
  `group_logo` varchar(255) DEFAULT NULL COMMENT '群组头像',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `busi_treatid` (`business_code`,`treatment_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for im_sig
-- ----------------------------
DROP TABLE IF EXISTS `ehos_im`.`im_sig`;
CREATE TABLE `ehos_im`.`im_sig` (
  `id` varchar(255) NOT NULL COMMENT '主键ID',
  `create_date_time` varchar(20) NOT NULL COMMENT '创建时间',
  `create_user` varchar(64) DEFAULT NULL COMMENT '创建人',
  `update_date_time` varchar(20) DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(64) DEFAULT NULL COMMENT '更新人',
  `account_id` varchar(255) NOT NULL COMMENT 'im_account表id（外键）',
  `account_sig` text COMMENT '腾讯接口调用校验用的userSig',
  `close_date` varchar(255) NOT NULL COMMENT 'userSig过期时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `acc_id` (`account_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for im_single_msg_relation
-- ----------------------------
DROP TABLE IF EXISTS `ehos_im`.`im_single_msg_relation`;
CREATE TABLE `ehos_im`.`im_single_msg_relation` (
  `id` varchar(255) NOT NULL COMMENT '主键ID',
  `create_date_time` varchar(20) NOT NULL COMMENT '创建时间',
  `create_user` varchar(64) DEFAULT NULL COMMENT '创建人',
  `update_date_time` varchar(20) DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(64) DEFAULT NULL COMMENT '更新人',
  `receiver_id` varchar(255) DEFAULT NULL COMMENT '消息接收者（im_account表id）',
  `single_msg_id` varchar(255) DEFAULT NULL COMMENT '单聊消息id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_singlemsgid_receiverid` (`single_msg_id`,`receiver_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE DATABASE `logistics-service` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- ----------------------------
-- Table structure for account
-- ----------------------------
DROP TABLE IF EXISTS `logistics-service`.`account`;
CREATE TABLE `logistics-service`.`account` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `view_id` varchar(64) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `login_name` varchar(32) DEFAULT NULL COMMENT '登录名',
  `login_pwd` varchar(32) NOT NULL COMMENT '登录密码',
  `name` varchar(35) NOT NULL COMMENT '姓名',
  `id_number` varchar(18) NOT NULL COMMENT '身份证号',
  `phone` varchar(20) DEFAULT NULL COMMENT '电话',
  `mobile` varchar(15) NOT NULL COMMENT '手机号',
  `type` int(11) NOT NULL COMMENT '账号类型 10 普通账户（只能创建一个商户）  20 isv账户（可创建多个商户）',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `login_name` (`login_name`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='账户表';

-- ----------------------------
-- Table structure for business_order_info
-- ----------------------------
DROP TABLE IF EXISTS `logistics-service`.`business_order_info`;
CREATE TABLE `logistics-service`.`business_order_info` (
  `id` bigint(12) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `business_id` varchar(32) NOT NULL DEFAULT '' COMMENT '业务系统订单编号',
  `d_company` varchar(32) NOT NULL DEFAULT '' COMMENT '到件公司名称',
  `d_contact` varchar(32) NOT NULL DEFAULT '' COMMENT '到件方联系人',
  `d_tel` varchar(32) NOT NULL DEFAULT '' COMMENT '到件方联系电话',
  `d_address` varchar(32) NOT NULL DEFAULT '' COMMENT '到件方详细地址',
  `j_company` varchar(32) DEFAULT '' COMMENT '寄件方公司名称',
  `j_contact` varchar(32) DEFAULT '' COMMENT '寄件方联系人',
  `j_tel` varchar(32) DEFAULT '' COMMENT '寄件方联系电话',
  `j_mobile` varchar(32) DEFAULT '' COMMENT '寄件人手机号码',
  `j_province` varchar(32) DEFAULT '' COMMENT '寄件人所在的省份',
  `j_city` varchar(32) DEFAULT '' COMMENT '寄件人所在的城市',
  `j_county` varchar(32) DEFAULT '' COMMENT '寄件人所在的县/区',
  `j_address` varchar(32) DEFAULT '' COMMENT '寄件人详细地址',
  `d_mobile` varchar(32) DEFAULT '' COMMENT '到件方手机号码',
  `d_province` varchar(32) DEFAULT '' COMMENT '到件方所在的省份',
  `d_city` varchar(32) DEFAULT '' COMMENT '到件方所在的城市',
  `d_county` varchar(32) DEFAULT '' COMMENT '到件方所在的县区',
  `custid` varchar(20) DEFAULT '' COMMENT '顺丰月结卡号',
  `pay_method` tinyint(4) DEFAULT NULL COMMENT '1:寄方付2:收方付3:第三方付',
  `express_type` varchar(5) DEFAULT '' COMMENT '收件产品编码',
  `is_docall` tinyint(4) DEFAULT NULL COMMENT '是否要求通过手持终端通知顺丰收派员收件：1:要求 其为不要求',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  `is_unified_waybill_no` tinyint(4) DEFAULT '0' COMMENT '是否使用国家统一面单号1:是0:否',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for business_order_record
-- ----------------------------
DROP TABLE IF EXISTS `logistics-service`.`business_order_record`;
CREATE TABLE `logistics-service`.`business_order_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `request` varchar(2048) DEFAULT NULL,
  `response` varchar(2048) DEFAULT NULL,
  `mch_id` varchar(32) DEFAULT NULL,
  `business_id` varchar(128) DEFAULT NULL,
  `main_no` varchar(128) DEFAULT NULL,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for dic_channel
-- ----------------------------
DROP TABLE IF EXISTS `logistics-service`.`dic_channel`;
CREATE TABLE `logistics-service`.`dic_channel` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `view_id` varchar(64) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `channel_name` varchar(35) NOT NULL COMMENT '渠道名称',
  `channel_desc` varchar(50) NOT NULL COMMENT '渠道描述',
  `channel_icon` varchar(200) NOT NULL COMMENT '渠道图标URL',
  `is_local` int(11) NOT NULL COMMENT '10 表示local 20表示全国',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='配送渠道信息表';

-- ----------------------------
-- Table structure for mch_info
-- ----------------------------
DROP TABLE IF EXISTS `logistics-service`.`mch_info`;
CREATE TABLE `logistics-service`.`mch_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `mch_id` varchar(32) DEFAULT NULL,
  `mch_secret` varchar(32) DEFAULT NULL,
  `mch_name` varchar(64) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mch_id` (`mch_id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for merchant
-- ----------------------------
DROP TABLE IF EXISTS `logistics-service`.`merchant`;
CREATE TABLE `logistics-service`.`merchant` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `view_id` varchar(64) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `name` varchar(35) NOT NULL COMMENT '商户名称',
  `icon_url` varchar(200) NOT NULL COMMENT '头像url',
  `test_app_id` varchar(64) DEFAULT NULL COMMENT '测试环境app_id',
  `test_app_secret` varchar(64) DEFAULT NULL COMMENT '测试环境秘钥',
  `formal_app_id` varchar(64) DEFAULT NULL COMMENT '正式环境app_id',
  `formal_app_secret` varchar(64) DEFAULT NULL COMMENT '正式环境秘钥',
  `province` varchar(20) NOT NULL COMMENT '商户所在省份',
  `city` varchar(20) NOT NULL COMMENT '商户所在城市',
  `county` varchar(20) NOT NULL COMMENT '商户所在县/区',
  `detailed_address` varchar(60) DEFAULT NULL COMMENT '商户详细地址',
  `account_id` bigint(20) NOT NULL COMMENT '账户ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='商户表';

-- ----------------------------
-- Table structure for route_push_config
-- ----------------------------
DROP TABLE IF EXISTS `logistics-service`.`route_push_config`;
CREATE TABLE `logistics-service`.`route_push_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `mch_id` varchar(32) NOT NULL COMMENT '业务code',
  `push_url` varchar(1024) NOT NULL,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for sf_local_callback_url
-- ----------------------------
DROP TABLE IF EXISTS `logistics-service`.`sf_local_callback_url`;
CREATE TABLE `logistics-service`.`sf_local_callback_url` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `merchant_id` bigint(20) NOT NULL COMMENT '商户ID',
  `notify_url` varchar(256) NOT NULL COMMENT '回调URL',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='回调URL';

-- ----------------------------
-- Table structure for sf_local_order
-- ----------------------------
DROP TABLE IF EXISTS `logistics-service`.`sf_local_order`;
CREATE TABLE `logistics-service`.`sf_local_order` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `view_id` varchar(64) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `merchant_id` bigint(20) NOT NULL COMMENT '商户ID',
  `sf_order_id` varchar(20) DEFAULT NULL COMMENT '顺丰的订单Id',
  `request` text COMMENT '请求参数',
  `response` text COMMENT '返回结果',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='顺丰同城订单信息';

-- ----------------------------
-- Table structure for sf_medical_callback_url
-- ----------------------------
DROP TABLE IF EXISTS `logistics-service`.`sf_medical_callback_url`;
CREATE TABLE `logistics-service`.`sf_medical_callback_url` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `merchant_id` bigint(20) NOT NULL COMMENT '商户ID',
  `notify_url` varchar(256) NOT NULL COMMENT '回调URL',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='回调URL';

-- ----------------------------
-- Table structure for sf_medical_order
-- ----------------------------
DROP TABLE IF EXISTS `logistics-service`.`sf_medical_order`;
CREATE TABLE `logistics-service`.`sf_medical_order` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `view_id` varchar(64) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` tinyint(4) DEFAULT '0' COMMENT '-1:删除1:上线',
  `bsp_order_no` varchar(64) NOT NULL COMMENT '业务订单号',
  `pay_method` varchar(32) NOT NULL COMMENT '付款方式',
  `express_type` varchar(32) NOT NULL COMMENT '使用的顺丰产品类型',
  `patient_name` varchar(38) DEFAULT NULL COMMENT '患者姓名',
  `patient_phone` varchar(18) DEFAULT NULL COMMENT '患者电话',
  `patient_identity_card_no` varchar(20) DEFAULT NULL COMMENT '患者身份证',
  `src_name` varchar(38) NOT NULL COMMENT '寄件人姓名',
  `src_phone` varchar(20) NOT NULL COMMENT '寄件人电话',
  `src_province` varchar(18) NOT NULL COMMENT '寄件人省份',
  `src_city` varchar(18) NOT NULL COMMENT '寄件人城市',
  `src_district` varchar(32) NOT NULL COMMENT '寄件人镇/区',
  `src_address` varchar(128) NOT NULL COMMENT '寄件人详细地址',
  `dest_name` varchar(38) NOT NULL COMMENT '收件人姓名',
  `dest_phone` varchar(20) NOT NULL COMMENT '收件人电话',
  `dest_province` varchar(20) NOT NULL COMMENT '收件人省份',
  `dest_city` varchar(20) NOT NULL COMMENT '收件人城市',
  `dest_district` varchar(35) NOT NULL COMMENT '收件人镇区',
  `dest_address` varchar(128) NOT NULL COMMENT '收件人详细地址',
  `parcel_weighs` varchar(12) DEFAULT NULL COMMENT '包裹重量',
  `packages_no` int(11) NOT NULL DEFAULT '1' COMMENT '件数，不填默认1 ',
  `depositum_info` varchar(35) NOT NULL COMMENT '寄托物名称',
  `depositum_no` varchar(12) NOT NULL DEFAULT '1' COMMENT '寄托物数量，不填默认1',
  `remark` varchar(128) DEFAULT NULL COMMENT '备注',
  `monthly_card` varchar(128) DEFAULT NULL COMMENT '月结卡号 如果是月结，必须要填',
  `statement_value` bigint(20) DEFAULT NULL COMMENT '声明价值（单位：分）',
  `pack_standard_money` bigint(20) DEFAULT NULL COMMENT '标准包装金额（单位：分）',
  `pack_individuation_money` bigint(20) DEFAULT NULL COMMENT '个性化包装金额（单位：分）',
  `collection_money` bigint(20) DEFAULT NULL COMMENT '代收金额（单位：分）',
  `collection_no` varchar(64) DEFAULT NULL COMMENT '代收卡号',
  `src_company` varchar(64) DEFAULT NULL COMMENT '寄件公司',
  `sign_flag` varchar(12) DEFAULT NULL COMMENT '是否需要口令签收(默认false、需要的话填true)',
  `product_code` varchar(32) DEFAULT NULL COMMENT '产品code',
  `hospital_code` varchar(64) DEFAULT NULL COMMENT '医院code',
  `mail_no` varchar(64) DEFAULT NULL COMMENT '唯一编码什么的',
  `fail_msg` varchar(128) DEFAULT NULL COMMENT '失败原因',
  `merchant_id` bigint(20) NOT NULL COMMENT '商户ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='顺丰医疗配送订单';

-- ----------------------------
-- Table structure for sf_order
-- ----------------------------
DROP TABLE IF EXISTS `logistics-service`.`sf_order`;
CREATE TABLE `logistics-service`.`sf_order` (
  `id` bigint(12) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `status` tinyint(4) NOT NULL COMMENT '状态 1默认状态，-1订单取消',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `response_result` text COMMENT '返回字符串',
  `business_id` varchar(32) NOT NULL DEFAULT '' COMMENT '客户系统订单号码',
  `mail_no` text NOT NULL COMMENT '顺风运单号',
  `origin_code` varchar(10) DEFAULT '' COMMENT '原寄地区域代码，可用于顺丰电子运单标签打印',
  `dest_code` varchar(12) DEFAULT '' COMMENT '目的地区域代码，可用于顺丰电子运单标签打印。',
  `filter_result` tinyint(4) NOT NULL COMMENT '筛单结果：\n\n1：人工确认\n2：可收派\n3：不可以收派',
  `state_code` varchar(10) DEFAULT '' COMMENT '订单状态码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for sf_order_operator_log
-- ----------------------------
DROP TABLE IF EXISTS `logistics-service`.`sf_order_operator_log`;
CREATE TABLE `logistics-service`.`sf_order_operator_log` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `sf_order_id` bigint(11) NOT NULL COMMENT '订单表主键',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `type` tinyint(4) NOT NULL COMMENT '1:确认订单2:取消订单',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for sf_order_state_code
-- ----------------------------
DROP TABLE IF EXISTS `logistics-service`.`sf_order_state_code`;
CREATE TABLE `logistics-service`.`sf_order_state_code` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `state_code` varchar(20) NOT NULL COMMENT '订单状态码',
  `state_desc` varchar(200) NOT NULL COMMENT '订单状态描述',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for sf_waybill_route
-- ----------------------------
DROP TABLE IF EXISTS `logistics-service`.`sf_waybill_route`;
CREATE TABLE `logistics-service`.`sf_waybill_route` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `route_id` bigint(15) NOT NULL COMMENT '路由节点信息编码，每一个id代表不同的路由节点信息',
  `mailno` varchar(20) NOT NULL COMMENT '顺丰运单号',
  `orderid` varchar(32) NOT NULL COMMENT '客户订单号',
  `accept_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '路由节点产生的时间',
  `accept_address` varchar(200) NOT NULL COMMENT '路由节点发生的城市',
  `remark` varchar(300) NOT NULL COMMENT '路由节点具体描述',
  `op_code` varchar(20) DEFAULT NULL COMMENT '路由节点操作码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;





CREATE DATABASE `pushcenter_cloud` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- ----------------------------
-- Table structure for ge_send_history
-- ----------------------------
DROP TABLE IF EXISTS `pushcenter_cloud`.`ge_send_history`;
CREATE TABLE `pushcenter_cloud`.`ge_send_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_date` varchar(10) DEFAULT NULL,
  `create_time` varchar(10) DEFAULT NULL,
  `create_user` varchar(15) DEFAULT NULL,
  `enabled` smallint(6) DEFAULT NULL,
  `update_date` varchar(10) DEFAULT NULL,
  `update_time` varchar(10) DEFAULT NULL,
  `update_user` varchar(15) DEFAULT NULL,
  `busi_code` varchar(255) DEFAULT NULL,
  `ge_code` int(11) DEFAULT NULL,
  `ge_msg` varchar(255) DEFAULT NULL,
  `ge_orig_msg` text,
  `is_read` smallint(6) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for mail_record
-- ----------------------------
DROP TABLE IF EXISTS `pushcenter_cloud`.`mail_record`;
CREATE TABLE `pushcenter_cloud`.`mail_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(11) NOT NULL DEFAULT '1',
  `subject` varchar(50) NOT NULL,
  `mail_address` varchar(255) NOT NULL,
  `business_code` varchar(50) DEFAULT NULL,
  `param` varchar(1024) DEFAULT NULL,
  `content` varchar(1024) DEFAULT NULL,
  `auth_code` varchar(50) NOT NULL,
  `auth_key` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for mail_template
-- ----------------------------
DROP TABLE IF EXISTS `pushcenter_cloud`.`mail_template`;
CREATE TABLE `pushcenter_cloud`.`mail_template` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(11) NOT NULL DEFAULT '1',
  `path` varchar(255) NOT NULL,
  `business_code` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for sms_application
-- ----------------------------
DROP TABLE IF EXISTS `pushcenter_cloud`.`sms_application`;
CREATE TABLE `pushcenter_cloud`.`sms_application` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_date` varchar(10) DEFAULT NULL COMMENT '创建日期',
  `create_time` varchar(10) DEFAULT NULL COMMENT '创建时间',
  `create_user` varchar(15) DEFAULT NULL COMMENT '创建者',
  `enabled` smallint(6) DEFAULT NULL COMMENT '是否打开 0: 未打开 1：打开',
  `update_date` varchar(10) DEFAULT NULL COMMENT '更新日期',
  `update_time` varchar(10) DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(15) DEFAULT NULL COMMENT '更新人',
  `app_key` varchar(64) DEFAULT NULL COMMENT '短信app_key',
  `app_sdk_id` varchar(64) DEFAULT NULL COMMENT '短信app_sdk_id',
  `app_sdk_type` varchar(10) DEFAULT NULL COMMENT '短信app_sdk_type',
  `client_code` varchar(20) DEFAULT NULL COMMENT '应用code',
  `client_name` varchar(50) DEFAULT NULL COMMENT '平台名字',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `app_code` varchar(20) DEFAULT NULL COMMENT '平台code',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4 COMMENT='短信应用平台';

-- ----------------------------
-- Table structure for sms_application_sms_template_merge
-- ----------------------------
DROP TABLE IF EXISTS `pushcenter_cloud`.`sms_application_sms_template_merge`;
CREATE TABLE `pushcenter_cloud`.`sms_application_sms_template_merge` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `application_id` bigint(20) NOT NULL COMMENT '应用id',
  `template_fk_id` bigint(20) NOT NULL COMMENT '短信模版id',
  `template_code` varchar(64) NOT NULL DEFAULT '' COMMENT '短信模版code',
  `language_type` varchar(50) NOT NULL DEFAULT '' COMMENT '语言类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for sms_black_list
-- ----------------------------
DROP TABLE IF EXISTS `pushcenter_cloud`.`sms_black_list`;
CREATE TABLE `pushcenter_cloud`.`sms_black_list` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` tinyint(11) NOT NULL DEFAULT '1' COMMENT '状态码',
  `phone` varchar(50) NOT NULL DEFAULT '' COMMENT '电话',
  `qa_name` varchar(50) NOT NULL DEFAULT '' COMMENT '名字',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UK_phone` (`phone`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for sms_error_record
-- ----------------------------
DROP TABLE IF EXISTS `pushcenter_cloud`.`sms_error_record`;
CREATE TABLE `pushcenter_cloud`.`sms_error_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_date` varchar(10) DEFAULT NULL,
  `create_time` varchar(10) DEFAULT NULL,
  `create_user` varchar(15) DEFAULT NULL,
  `enabled` smallint(6) DEFAULT NULL,
  `update_date` varchar(10) DEFAULT NULL,
  `update_time` varchar(10) DEFAULT NULL,
  `update_user` varchar(15) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `send_params` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for sms_send_history
-- ----------------------------
DROP TABLE IF EXISTS `pushcenter_cloud`.`sms_send_history`;
CREATE TABLE `pushcenter_cloud`.`sms_send_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_date` varchar(10) DEFAULT NULL COMMENT '创建日期',
  `create_time` varchar(10) DEFAULT NULL COMMENT '创建时间',
  `create_user` varchar(15) DEFAULT NULL COMMENT '创建者',
  `enabled` smallint(6) DEFAULT NULL COMMENT '状态 0:未打开 1:打开',
  `update_date` varchar(10) DEFAULT NULL COMMENT '更新日期',
  `update_time` varchar(10) DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(15) DEFAULT NULL COMMENT '更新者',
  `send_date` varchar(10) DEFAULT NULL COMMENT '短信发送日期',
  `send_params` varchar(1024) DEFAULT NULL COMMENT '发送短信入参',
  `send_status` varchar(10) DEFAULT NULL COMMENT '短信发送状态',
  `send_time` varchar(10) DEFAULT NULL COMMENT '短信发送时间',
  `sms_type` varchar(5) DEFAULT NULL COMMENT '短信类型',
  `target_phone` varchar(13) DEFAULT NULL COMMENT '接受短信电话',
  `temp_fk_id` bigint(20) DEFAULT NULL COMMENT '短信模版主键',
  `tx_sid` varchar(255) DEFAULT NULL COMMENT '消息id',
  `user_id` varchar(255) DEFAULT NULL COMMENT '用户id',
  `tx_err_code` varchar(255) DEFAULT NULL COMMENT '错误码',
  `tx_err_msg` varchar(255) DEFAULT NULL COMMENT '错误信息',
  `ali_biz_id` varchar(255) DEFAULT NULL COMMENT '阿里业务编码',
  `ali_request_id` varchar(255) DEFAULT NULL COMMENT '请求id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `p_index_num` (`target_phone`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for sms_sign
-- ----------------------------
DROP TABLE IF EXISTS `pushcenter_cloud`.`sms_sign`;
CREATE TABLE `pushcenter_cloud`.`sms_sign` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_date` varchar(10) NOT NULL DEFAULT '' COMMENT '创建日期',
  `create_time` varchar(10) NOT NULL DEFAULT '' COMMENT '创建时间',
  `create_user` varchar(15) NOT NULL DEFAULT 'admin' COMMENT '创建人',
  `enabled` smallint(6) NOT NULL DEFAULT '1' COMMENT '状态0:未开通1:已开通',
  `update_date` varchar(10) NOT NULL DEFAULT '' COMMENT '更新日期',
  `update_time` varchar(10) NOT NULL DEFAULT '' COMMENT '更新时间',
  `update_user` varchar(15) NOT NULL DEFAULT '' COMMENT '更新者',
  `sign_code` varchar(20) NOT NULL DEFAULT '' COMMENT '签名code',
  `sign_name` varchar(50) NOT NULL DEFAULT '' COMMENT '签名平台',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for sms_template
-- ----------------------------
DROP TABLE IF EXISTS `pushcenter_cloud`.`sms_template`;
CREATE TABLE `pushcenter_cloud`.`sms_template` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_date` varchar(10) DEFAULT NULL COMMENT '创建日期',
  `create_time` varchar(10) DEFAULT NULL COMMENT '创建时间',
  `create_user` varchar(15) DEFAULT NULL COMMENT '创建人',
  `enabled` smallint(6) DEFAULT NULL COMMENT '状态0:未开通1:开通',
  `update_date` varchar(10) DEFAULT NULL COMMENT '更新日期',
  `update_time` varchar(10) DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(15) DEFAULT NULL COMMENT '更新人',
  `busi_name` varchar(20) DEFAULT NULL COMMENT '业务名',
  `temp_code` varchar(64) DEFAULT NULL COMMENT '模版code',
  `temp_content` varchar(512) DEFAULT NULL COMMENT '模版内容',
  `temp_desc` varchar(100) DEFAULT NULL COMMENT '模版描述',
  `temp_id` varchar(30) DEFAULT NULL COMMENT '模版id',
  `rule_times` int(11) DEFAULT NULL COMMENT '转换时间',
  `convert_rule` varchar(255) DEFAULT NULL COMMENT '转换规则',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for um_application
-- ----------------------------
DROP TABLE IF EXISTS `pushcenter_cloud`.`um_application`;
CREATE TABLE `pushcenter_cloud`.`um_application` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_date` varchar(10) DEFAULT NULL COMMENT '创建日期',
  `create_time` varchar(10) DEFAULT NULL COMMENT '创建时间',
  `create_user` varchar(15) DEFAULT NULL COMMENT '创建人',
  `enabled` smallint(6) DEFAULT NULL COMMENT '是否开启',
  `update_date` varchar(10) DEFAULT NULL COMMENT '更新日期',
  `update_time` varchar(10) DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(15) DEFAULT NULL COMMENT '更新人',
  `app_device_type` varchar(10) DEFAULT NULL COMMENT '设备类型',
  `app_master_secret` varchar(255) DEFAULT NULL COMMENT 'app密匙',
  `app_msg_secret` varchar(255) DEFAULT NULL COMMENT '信息密匙',
  `app_sdk_id` varchar(255) DEFAULT NULL COMMENT 'sdkId',
  `client_code` varchar(10) DEFAULT NULL COMMENT '应用编码',
  `client_name` varchar(20) DEFAULT NULL COMMENT '应用名',
  `environment` int(11) DEFAULT NULL COMMENT '使用环境',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for um_busi_msg_relation
-- ----------------------------
DROP TABLE IF EXISTS `pushcenter_cloud`.`um_busi_msg_relation`;
CREATE TABLE `pushcenter_cloud`.`um_busi_msg_relation` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_date` varchar(10) DEFAULT NULL COMMENT '创建日期',
  `create_time` varchar(10) DEFAULT NULL COMMENT '创建时间',
  `create_user` varchar(15) DEFAULT NULL COMMENT '创建人',
  `enabled` smallint(6) DEFAULT NULL COMMENT '是否打开',
  `update_date` varchar(10) DEFAULT NULL COMMENT '更新日期',
  `update_time` varchar(10) DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(15) DEFAULT NULL COMMENT '更新人',
  `section_name` varchar(60) DEFAULT NULL COMMENT '业务名字',
  `section_code` varchar(60) DEFAULT NULL COMMENT '业务编码',
  `section_desp` varchar(255) DEFAULT NULL COMMENT '业务描述',
  `parent_id` bigint(20) DEFAULT NULL COMMENT '父id',
  `byh_enum_code` varchar(255) DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='推送模版表';

-- ----------------------------
-- Table structure for um_error_record
-- ----------------------------
DROP TABLE IF EXISTS `pushcenter_cloud`.`um_error_record`;
CREATE TABLE `pushcenter_cloud`.`um_error_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_date` varchar(10) DEFAULT NULL,
  `create_time` varchar(10) DEFAULT NULL,
  `create_user` varchar(15) DEFAULT NULL,
  `enabled` smallint(6) DEFAULT NULL,
  `update_date` varchar(10) DEFAULT NULL,
  `update_time` varchar(10) DEFAULT NULL,
  `update_user` varchar(15) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `send_params` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for um_send_history
-- ----------------------------
DROP TABLE IF EXISTS `pushcenter_cloud`.`um_send_history`;
CREATE TABLE `pushcenter_cloud`.`um_send_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_date` varchar(10) DEFAULT NULL COMMENT '创建日期',
  `create_time` varchar(10) DEFAULT NULL COMMENT '创建时间',
  `create_user` varchar(15) DEFAULT NULL COMMENT '创建人',
  `enabled` smallint(6) DEFAULT NULL COMMENT '是否开启',
  `update_date` varchar(10) DEFAULT NULL COMMENT '创建日期',
  `update_time` varchar(10) DEFAULT NULL COMMENT '创建时间',
  `update_user` varchar(15) DEFAULT NULL COMMENT '创建人',
  `busi_code` varchar(255) DEFAULT NULL COMMENT '业务编码',
  `busi_style` varchar(255) DEFAULT NULL COMMENT '推送内容',
  `um_msg_type` varchar(255) DEFAULT NULL COMMENT '信息类型',
  `pro_step` varchar(255) DEFAULT NULL COMMENT '推送进度',
  `temp_fk_id` varchar(255) DEFAULT NULL COMMENT '模版外键',
  `um_device_token` varchar(255) DEFAULT NULL COMMENT '推送目标设备号',
  `um_msg_id` varchar(255) DEFAULT NULL COMMENT '消息id',
  `um_orig_msg` text COMMENT '原始消息记录',
  `um_push_msg` text COMMENT '推送消息记录',
  `um_target_client` varchar(255) DEFAULT NULL COMMENT '目标客户端',
  `um_task_id` varchar(255) DEFAULT NULL COMMENT 'um任务id',
  `user_id` varchar(255) DEFAULT NULL COMMENT '用户id',
  `err_msg` varchar(255) DEFAULT NULL COMMENT '错误信息',
  `title` varchar(255) DEFAULT NULL COMMENT '主题',
  `read_status` int(5) DEFAULT '0' COMMENT '读取状态',
  `extra_str` text COMMENT '额外信息 ',
  `account_id` varchar(255) DEFAULT NULL COMMENT '账户ID',
  `device_num` varchar(255) DEFAULT NULL COMMENT '设备号',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_userid` (`user_id`(191)) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for wx_push_application
-- ----------------------------
DROP TABLE IF EXISTS `pushcenter_cloud`.`wx_push_application`;
CREATE TABLE `pushcenter_cloud`.`wx_push_application` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_date` varchar(10) DEFAULT NULL COMMENT '创建日期',
  `create_time` varchar(10) DEFAULT NULL COMMENT '创建时间',
  `create_user` varchar(15) DEFAULT NULL COMMENT '创建人',
  `enabled` smallint(6) DEFAULT NULL COMMENT '开关状态',
  `update_date` varchar(10) DEFAULT NULL COMMENT '更新日期',
  `update_time` varchar(10) DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(15) DEFAULT NULL COMMENT '更新人',
  `access_token` varchar(521) DEFAULT NULL COMMENT '微信token',
  `grant_type` varchar(64) DEFAULT NULL COMMENT '类型',
  `appid` varchar(255) DEFAULT NULL COMMENT '微信appid',
  `secret` varchar(255) DEFAULT NULL COMMENT '微信密匙',
  `expires_in` bigint(20) DEFAULT NULL COMMENT '有效时间',
  `client_code` varchar(20) DEFAULT NULL COMMENT '应用编码',
  `client_name` varchar(50) DEFAULT NULL COMMENT '应用名',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for wx_push_history
-- ----------------------------
DROP TABLE IF EXISTS `pushcenter_cloud`.`wx_push_history`;
CREATE TABLE `pushcenter_cloud`.`wx_push_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_date` varchar(10) DEFAULT NULL COMMENT '创建日期',
  `create_time` varchar(10) DEFAULT NULL COMMENT '创建时间',
  `create_user` varchar(15) DEFAULT NULL COMMENT '创建者',
  `enabled` smallint(6) DEFAULT NULL COMMENT '开关状态',
  `update_date` varchar(10) DEFAULT NULL COMMENT '更新日期',
  `update_time` varchar(10) DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(15) DEFAULT NULL COMMENT '更新人',
  `open_id` varchar(100) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '微信openId',
  `organ_id` varchar(20) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '医院id',
  `temp_fk_id` bigint(20) DEFAULT NULL COMMENT '模版外键',
  `user_id` varchar(100) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '用户id',
  `wx_errcode` bigint(60) DEFAULT NULL COMMENT '微信状态code',
  `wx_errmsg` varchar(500) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '微信错误信息',
  `wx_push_params` varchar(500) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '推送参数',
  `wx_push_status` varchar(10) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '推送状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for wx_push_template
-- ----------------------------
DROP TABLE IF EXISTS `pushcenter_cloud`.`wx_push_template`;
CREATE TABLE `pushcenter_cloud`.`wx_push_template` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_date` varchar(10) DEFAULT NULL COMMENT '创建日期',
  `create_time` varchar(10) DEFAULT NULL COMMENT '创建时间',
  `create_user` varchar(15) DEFAULT NULL COMMENT '创建人',
  `enabled` smallint(6) DEFAULT NULL COMMENT '开关状态',
  `update_date` varchar(10) DEFAULT NULL COMMENT '更新日期',
  `update_time` varchar(10) DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(15) DEFAULT NULL COMMENT '更新人',
  `app_fk_id` bigint(20) DEFAULT NULL COMMENT '应用外键',
  `busi_name` varchar(20) DEFAULT NULL COMMENT '业务名字',
  `temp_code` varchar(64) DEFAULT NULL COMMENT '模版编码',
  `temp_content` varchar(255) DEFAULT NULL COMMENT '模版内容',
  `temp_id` varchar(150) DEFAULT NULL COMMENT '模版id',
  `temp_desp` varchar(150) DEFAULT NULL COMMENT '模版描述',
  `page` smallint(10) DEFAULT NULL COMMENT '页面',
  `emphasis_keyword` varchar(20) DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB   DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;



CREATE DATABASE `service-chat` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- ----------------------------
-- Table structure for business_message_info
-- ----------------------------
DROP TABLE IF EXISTS `service-chat`.`business_message_info`;
CREATE TABLE `service-chat`.`business_message_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `msg_type` varchar(32) DEFAULT NULL,
  `msg_content` text,
  `file_url` varchar(256) DEFAULT NULL,
  `recv_id` varchar(64) DEFAULT NULL,
  `recv_type` varchar(64) DEFAULT NULL,
  `send_id` varchar(64) DEFAULT NULL,
  `send_type` varchar(64) DEFAULT NULL,
  `send_time` timestamp NULL DEFAULT NULL,
  `msg_uuid` varchar(64) DEFAULT NULL,
  `chganeel_type` varchar(64) DEFAULT NULL,
  `sensitive_type` int(11) DEFAULT NULL,
  `source` varchar(64) DEFAULT NULL,
  `group_user_ids` varchar(256) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0',
  `is_read` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for rong_cloud_group
-- ----------------------------
DROP TABLE IF EXISTS `service-chat`.`rong_cloud_group`;
CREATE TABLE `service-chat`.`rong_cloud_group` (
  `Id` bigint(11) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `group_uuid` varchar(32) DEFAULT NULL COMMENT '群组Id：订单UUID；团队UUID；UUID：医院ID；UUID:区域代码+科室ID；UUID',
  `group_type` int(11) DEFAULT NULL COMMENT '群组类型 1:订单;2:Team;3:医院;4:区域科室;5自主创建',
  `group_name` varchar(256) DEFAULT NULL COMMENT '群组名称',
  `order_type` int(11) DEFAULT NULL COMMENT '订单类型:群组类型为1(订单)时 使用',
  `creator_id` int(11) DEFAULT NULL COMMENT '创建者',
  `creator_type` int(11) DEFAULT NULL COMMENT '创建者类型',
  `hospital_id` int(11) DEFAULT NULL COMMENT '医院ID：群组类型为3（医院）时使用',
  `dist_code` varchar(6) DEFAULT NULL COMMENT '区域代码：群组类型为4（区域科室）时使用',
  `standard_Dep_id` int(11) DEFAULT NULL COMMENT '标准科室：群组类型为4（区域科室）时使用',
  `status` int(1) DEFAULT '1' COMMENT '1：生效；0：解散',
  `logo_url` varchar(256) DEFAULT NULL COMMENT '群组成员url',
  PRIMARY KEY (`Id`),
  KEY `GroupUuid` (`group_uuid`),
  KEY `StandardDepId` (`standard_Dep_id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for rong_cloud_group_member
-- ----------------------------
DROP TABLE IF EXISTS `service-chat`.`rong_cloud_group_member`;
CREATE TABLE `service-chat`.`rong_cloud_group_member` (
  `Id` bigint(11) NOT NULL AUTO_INCREMENT,
  `group_uuid` varchar(32) NOT NULL DEFAULT '' COMMENT '群组UUID',
  `group_type` int(11) DEFAULT NULL COMMENT '群组Type 冗余数据',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '加入时间',
  `user_id` int(11) NOT NULL COMMENT '用户Id',
  `user_type` int(11) NOT NULL COMMENT '用户Type',
  `status` int(1) DEFAULT '1' COMMENT '状态',
  `role` int(11) DEFAULT NULL COMMENT '角色：1：管理员；2：普通成员',
  `user_name` varchar(32) DEFAULT NULL,
  `rong_cloud_id` varchar(32) DEFAULT NULL,
  `head_image_url` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `GroupUuid` (`group_uuid`),
  KEY `UserId` (`user_id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for rong_cloud_group_post_relation
-- ----------------------------
DROP TABLE IF EXISTS `service-chat`.`rong_cloud_group_post_relation`;
CREATE TABLE `service-chat`.`rong_cloud_group_post_relation` (
  `Id` bigint(11) NOT NULL AUTO_INCREMENT,
  `createTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `group_uuid` varchar(32) NOT NULL DEFAULT '' COMMENT '病历帖uuid',
  `post_uuid` varchar(32) NOT NULL DEFAULT '' COMMENT '病历帖uuid',
  `repaste_user_id` int(11) DEFAULT NULL COMMENT '转帖人Id',
  `status` int(1) DEFAULT '1' COMMENT '1：生效；0：解散',
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for user_friend_relation
-- ----------------------------
DROP TABLE IF EXISTS `service-chat`.`user_friend_relation`;
CREATE TABLE `service-chat`.`user_friend_relation` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `main_user_id` int(11) DEFAULT NULL,
  `main_user_type` int(11) DEFAULT NULL,
  `main_rong_user_id` varchar(64) DEFAULT NULL,
  `sub_user_id` int(11) DEFAULT NULL,
  `sub_user_type` int(11) DEFAULT NULL,
  `sub_rong_user_id` varchar(64) DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL COMMENT '关系添加时间',
  `main_user_from` int(11) DEFAULT NULL COMMENT '1：患者，2：医生',
  `sub_user_from` int(11) DEFAULT NULL COMMENT '1：患者，2：医生',
  `status` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`Id`),
  KEY `index_main_user_id-user_type` (`main_user_id`,`main_user_type`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for user_friend_request
-- ----------------------------
DROP TABLE IF EXISTS `service-chat`.`user_friend_request`;
CREATE TABLE `service-chat`.`user_friend_request` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(32) DEFAULT NULL COMMENT '好友申请uuid',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '好友请求时间',
  `recipient_Id` int(11) DEFAULT NULL COMMENT '接收者Id',
  `recipient_type` int(11) DEFAULT NULL COMMENT '接收者类型',
  `applicant_id` int(11) DEFAULT NULL COMMENT '申请者Id',
  `applicant_type` int(11) DEFAULT NULL COMMENT '申请者类型',
  `message` varchar(256) DEFAULT NULL COMMENT '申请留言',
  `status` int(11) DEFAULT NULL COMMENT '请求状态（0：待审核；1：审核通过）',
  `audit_time` timestamp NULL DEFAULT NULL COMMENT '审核通过时间',
  `recipient_from` int(11) DEFAULT NULL COMMENT '接收者（1：患者，2：医生）',
  `applicant_from` int(11) DEFAULT NULL COMMENT '申请者（1：患者，2：医生）',
  `detail_data` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for user_rong_cloud_association
-- ----------------------------
DROP TABLE IF EXISTS `service-chat`.`user_rong_cloud_association`;
CREATE TABLE `service-chat`.`user_rong_cloud_association` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL COMMENT '医生id',
  `rong_cloud_id` varchar(64) DEFAULT NULL,
  `rong_cloud_token` varchar(256) DEFAULT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;


CREATE DATABASE `sysinfo-cloud` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

CREATE TABLE `sysinfo-cloud`.`app_patch_info`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `uuid` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '唯一值',
  `version_num` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '版本号',
  `patch_num` int(5) NULL DEFAULT NULL COMMENT '补丁号',
  `patch_desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '补丁描述',
  `status` int(3) NULL DEFAULT 1 COMMENT '数据状态 1启用   -1 弃用',
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`app_versions_info`  (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `platform` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '平台code 对应:platform_node表的platform字段(外键)',
  `platform_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '平台名 对应:platform_node表的platform_name字段(外键)',
  `md5` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'md5',
  `version_code` int(10) NULL DEFAULT 1 COMMENT '版本code',
  `version_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '版本名',
  `version_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '版本地址',
  `file_size` decimal(10, 2) NULL DEFAULT 61440000.00 COMMENT '安装包大小',
  `version_desc` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '版本描述',
  `is_on_line` tinyint(1) NULL DEFAULT 1 COMMENT '判断接口是否上线 1上线 -1不上线',
  `is_force_update` tinyint(1) NULL DEFAULT 1 COMMENT '是否强制更新 1不更新 -1更新',
  `publish_time` timestamp(0) NOT NULL DEFAULT '1970-01-02 00:00:00' COMMENT '发布时间',
  `online_time` timestamp(0) NOT NULL DEFAULT '1970-01-02 00:00:00' COMMENT '上线时间',
  `status` tinyint(3) NOT NULL DEFAULT 1 COMMENT '是否删除 1否 -1是',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`bp_auth`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `auth_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '权限名称',
  `auth_level` tinyint(4) NOT NULL DEFAULT 0 COMMENT '权限等级',
  `path` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '跳转路径',
  `parent_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '父ID',
  `type` tinyint(4) NOT NULL DEFAULT 0 COMMENT '权限类型 1 一级菜单  2 二级菜单  3 按钮',
  `sort` tinyint(4) NOT NULL DEFAULT 0 COMMENT '排序',
  `auth_location` tinyint(2) NOT NULL DEFAULT 0 COMMENT '权限位置 1 左侧 2 上侧',
  `icon` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '图标',
  `status` int(11) NOT NULL COMMENT '状态',
  `view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'uuid',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '权限表' ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`bp_role`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `role_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '角色名称',
  `is_default` int(4) NOT NULL DEFAULT 3 COMMENT '是否默认 1 默认(管理员)  2 默认(普通成员)  3 不是默认',
  `status` int(11) NOT NULL COMMENT '状态',
  `view_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'uuid',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '角色表' ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`bp_role_auth`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `auth_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '权限ID 对应:bp_auth表的ID字段(外键)',
  `role_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '角色ID 对应:bp_role表的ID字段(外键)',
  `binding` tinyint(4) NOT NULL DEFAULT 0 COMMENT '是否绑定 0 未绑定 1 绑定',
  `status` int(11) NOT NULL COMMENT '状态',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '角色权限关联表' ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`bp_user_role`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `user_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户Id 对应:super_admin_user表的ID字段(外键)',
  `role_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '角色ID 对应:bp_role标的ID字段(外键)',
  `status` int(11) NOT NULL COMMENT '状态',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户角色关联表' ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`feed_back_info`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `feedback_type_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '意见类型ID 对应:feedback_back_type表的ID字段(外键)',
  `user_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '用户Id 对应:用户服务uc_doctor_user的userId(外键)',
  `app_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '平台code',
  `app_code_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '平台code名称',
  `feedback_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '意见类型名称',
  `user_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户名称',
  `user_phone` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户电话',
  `user_head_portrait` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户头像',
  `feedback_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '意见内容',
  `feedback_picture` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '意见图片',
  `is_reply` tinyint(4) NOT NULL DEFAULT 0 COMMENT '是否回复 0 未回复  1 已回复',
  `status` int(11) NOT NULL COMMENT '状态',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '意见反馈表' ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`feed_back_reply`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `user_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '用户Id 对应:用户服务uc_doctor_user的userId(外键)',
  `feed_back_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '意见反馈ID 对应:feed_back_info表的ID(外键)',
  `feedback_type_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '意见类型ID 对应:feed_back_type表的ID字段(外键)',
  `reply_type` tinyint(4) NOT NULL DEFAULT 0 COMMENT '回复类型  1 提问  2 回复',
  `user_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户名称',
  `user_phone` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户电话',
  `user_head_portrait` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户头像',
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '内容',
  `picture` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '图片',
  `feedback_type_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '反馈类型名称',
  `is_read` tinyint(4) NOT NULL DEFAULT 0 COMMENT '是否已读  0 未读  1 已读',
  `status` int(11) NOT NULL COMMENT '状态',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '意见反馈内容回复表' ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`feed_back_type`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `ovner` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '所属端code',
  `type_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '类型名称',
  `status` int(11) NOT NULL COMMENT '状态',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '意见反馈类型表' ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`feedback`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `user_id` bigint(11) NOT NULL COMMENT '用户Id 对应:用户服务uc_doctor_user的userId(外键)',
  `service_id` int(10) NULL DEFAULT 0 COMMENT '所属服务id',
  `app_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '平台code',
  `organ_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构code',
  `user_name` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '用户名',
  `phone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '手机号',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '问题描述',
  `picture` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图片',
  `status` tinyint(3) NOT NULL DEFAULT 1 COMMENT '状态 1-有效；0无效',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '意见反馈表' ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`form_content`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键，填写表单内容id',
  `patient_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '患者ID 对应:卡服务的cs_card表的patient_id(外键)',
  `form_id` bigint(20) NOT NULL COMMENT '表单id 对应:form_info表的ID字段(外键)',
  `form_type_id` bigint(20) NOT NULL COMMENT '表单类型id 对应:form_type表的ID字段(外键)',
  `form_service_id` bigint(20) NULL DEFAULT NULL COMMENT '表单关联业务表id 对应:form_service表的ID字段(外键)',
  `form_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单名称',
  `form_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单类型名称',
  `form_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '患者填写完提交后的表单内容',
  `status` int(2) NOT NULL DEFAULT 1 COMMENT '删除为0，正常为1',
  `creat_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`, `creat_time`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`form_info`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `creator_user_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '创建人的用户id 对应:用户服务uc_doctor_user的userId(外键)',
  `form_type_id` bigint(20) NULL DEFAULT NULL COMMENT '表单类型id 对应:form_type表的ID字段(外键)',
  `name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '表单名称',
  `content` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '表单内容',
  `creator` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '创建人',
  `form_status` int(2) NOT NULL COMMENT '表单状态 1、未发布2、发布3、禁用',
  `form_type` int(2) NULL DEFAULT NULL COMMENT '1.随访 2.调查问卷',
  `form_type_name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '表单类型名称',
  `status` int(2) NOT NULL COMMENT '状态 1代表正常 0代表删除',
  `app_code` varchar(12) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '诊疗平台code',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`, `create_time`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`form_service`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键,表单业务id',
  `creator_user_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人id 对应:用户服务uc_doctor_user的userId(外键)',
  `form_id` bigint(20) NOT NULL COMMENT '表单模板id 对应:form_info表的ID字段(外键)',
  `organ_id` bigint(20) NOT NULL COMMENT '关联医院id 对应:医生服务bd_organization表的ID(外键)',
  `form_type_id` bigint(32) NOT NULL COMMENT '表单类型 对应:form_type表的ID字段(外键)',
  `form_service_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '表单业务名称',
  `service_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '业务内容',
  `creator` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '创建人',
  `form_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单模板名称',
  `form_type_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表单类型名称',
  `organ_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关联医院名称',
  `app_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '平台code',
  `status` int(2) NOT NULL DEFAULT 1 COMMENT '状态(1:正常,0:删除)',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`form_type`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `form_type_name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '名称',
  `app_code` varchar(12) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '平台code',
  `status` int(2) NULL DEFAULT NULL COMMENT '数据状态',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`inquiry_medical_template`  (
  `id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hospital_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '医院ID 对应:医生服务bd_organization表的ID(外键)',
  `dept_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '科室id 对应:医生服务doc_department表的ID字段(外键)',
  `title_content` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '展示信息',
  `keywords` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '数据key信息',
  `input_type` tinyint(4) NULL DEFAULT NULL COMMENT '模块类型/1 基础信息   2 his信息  3 患者手动填写',
  `title_type` tinyint(4) NULL DEFAULT NULL COMMENT '展示信息类型',
  `title_type_content` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '展示信息类型内容',
  `title_type_limit` tinyint(4) NULL DEFAULT NULL COMMENT '展示信息长度限制',
  `background_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '背景描述',
  `patient_hint` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '患者端提示语',
  `serv_type` tinyint(4) NULL DEFAULT NULL COMMENT '业务类型/2 在线咨询  3 在线复诊',
  `is_null` tinyint(4) NULL DEFAULT NULL COMMENT '是否为空/1 必填  -1 非必填',
  `is_his` tinyint(4) NULL DEFAULT NULL COMMENT '是否和his关联/1 关联  -1 不关联',
  `is_edit` tinyint(4) NULL DEFAULT NULL COMMENT '是否可编辑/1 可编辑  -1 不可编辑',
  `is_card` tinyint(4) NULL DEFAULT NULL COMMENT '是否展示在患者病例卡片/1 展示  -1 不展示',
  `is_show` tinyint(4) NULL DEFAULT NULL COMMENT '是否展示',
  `sort` tinyint(4) NULL DEFAULT NULL COMMENT '展示顺序',
  `unit_range` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '单位区间',
  `max_unit` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '最大单位',
  `min_unit` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '最小单位',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '数据状态',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '描述',
  `version` bigint(11) NULL DEFAULT NULL COMMENT '版本',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`inquiry_medical_template_data`  (
  `id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title_content` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '展示信息',
  `keywords` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '数据key信息',
  `input_type` tinyint(4) NULL DEFAULT NULL COMMENT '模块类型/1 基础信息   2 his信息  3 患者手动填写',
  `title_type` tinyint(4) NULL DEFAULT NULL COMMENT '展示信息类型',
  `title_type_content` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '展示信息类型内容',
  `title_type_limit` tinyint(4) NULL DEFAULT NULL COMMENT '展示信息长度限制',
  `background_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '背景描述',
  `patient_hint` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '患者端提示语',
  `serv_type` tinyint(4) NULL DEFAULT NULL COMMENT '业务类型/2 在线咨询  3 在线复诊',
  `is_null` tinyint(4) NULL DEFAULT NULL COMMENT '是否为空/1 必填  -1 非必填',
  `is_his` tinyint(4) NULL DEFAULT NULL COMMENT '是否和his关联/1 关联  -1 不关联',
  `is_edit` tinyint(4) NULL DEFAULT NULL COMMENT '是否可编辑/1 可编辑  -1 不可编辑',
  `is_card` tinyint(4) NULL DEFAULT NULL COMMENT '是否展示在患者病例卡片/1 展示  -1 不展示',
  `is_show` tinyint(4) NULL DEFAULT NULL COMMENT '是否展示',
  `sort` tinyint(4) NULL DEFAULT NULL COMMENT '展示顺序',
  `version` bigint(11) NULL DEFAULT NULL,
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`inquiry_medical_template_tags`  (
  `id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '主键ID',
  `hospital_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '医院ID 对应:医生服务bd_organization表的ID(外键)',
  `dept_id` int(11) NULL DEFAULT NULL COMMENT '科室id 对应:医生服务doc_department表的ID字段(外键)',
  `tag_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '标签名称',
  `serv_type` tinyint(4) NULL DEFAULT NULL COMMENT '服务类型',
  `version` bigint(11) NULL DEFAULT NULL COMMENT '版本',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '描述',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`inquiry_medical_template_tags_record`  (
  `id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '主键ID',
  `dept_id` int(11) NULL DEFAULT NULL COMMENT '医院ID 对应:医生服务bd_organization表的ID(外键)',
  `hospital_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '科室id 对应:医生服务doc_department表的ID字段(外键)',
  `template_tags_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门id 对应:inquiry_medical_template_tags表的ID字段(外键)',
  `tag_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '标签名称',
  `serv_type` tinyint(4) NULL DEFAULT NULL COMMENT '服务类型',
  `version` bigint(11) NULL DEFAULT NULL COMMENT '版本',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '描述',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `K_Reference_15`(`template_tags_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`inquiry_patient_dynamic_medical`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '主键ID',
  `hospital_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '患者ID 对应:卡服务的cs_card表的patient_id(外键)',
  `dept_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '科室id 对应:医生服务doc_department表的ID字段(外键)',
  `patient_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '患者ID 对应:卡服务的cs_card表的patient_id(外键)',
  `serv_type` tinyint(4) NULL DEFAULT NULL COMMENT '服务类型  2 咨询  3 复诊',
  `app_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '平台code',
  `status` tinyint(4) NULL DEFAULT 1 COMMENT '状态 1正常 2 删除',
  `medical_user_fills` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL COMMENT '患者填写的病例',
  `tags` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL COMMENT '疾病标签',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL COMMENT '病情描述',
  `medical_detail` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL COMMENT '病例详情',
  `adm_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '就诊ID',
  `main_suit` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL COMMENT '主诉',
  `primary_diagno` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL COMMENT '诊断',
  `hospital_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '医院名称',
  `dept_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '科室名称',
  `doctor_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '医生名字',
  `x_remark` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '描述',
  `x_version` bigint(20) NULL DEFAULT 0 COMMENT '版本',
  `x_create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`x_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`login_log`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `ip` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'ip',
  `user_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户名',
  `login_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '登录名',
  `status` int(11) NOT NULL DEFAULT 1 COMMENT '状态',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '登录记录表' ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`platform_node`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `platform` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '平台code',
  `platform_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '平台名称' COMMENT '平台名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '平台节点表' ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`popup_manage`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `push_type` tinyint(11) NULL DEFAULT NULL COMMENT '推送类型0系统维护，1活动推送',
  `push_start_time` datetime(0) NULL DEFAULT NULL COMMENT '开始时间',
  `push_end_time` datetime(0) NULL DEFAULT NULL COMMENT '结束时间',
  `is_redirect` tinyint(11) NULL DEFAULT NULL COMMENT '是否跳转 0跳转(默认)，1不跳转',
  `redirect_type` int(11) NULL DEFAULT NULL COMMENT '跳转方式  0外链跳转  1系统内页面',
  `redirect_url` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '跳转路径',
  `img_url` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '图片链接',
  `text` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '推送文案，300字以内',
  `title` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '标题',
  `push_platform` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '推送平台, DOC_IOS_NCEFY (大写) 字符串拼接，逗号隔开',
  `status` int(11) NULL DEFAULT NULL COMMENT '生效状态：0待生效,1生效中，2已失效',
  `create_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `id`(`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`service_label`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '标签名',
  `parent_id` bigint(1) NOT NULL DEFAULT 0 COMMENT '父ID',
  `level` tinyint(4) NOT NULL DEFAULT 1 COMMENT '标签等级',
  `describe` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '描述',
  `status` int(11) NOT NULL DEFAULT 1 COMMENT '状态',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统标签库表' ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`super_admin_user`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `login_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '账号',
  `nickname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '用户名',
  `password` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '密码',
  `viewId` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '唯一值',
  `token` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'token',
  `role_type` int(3) NULL DEFAULT 1 COMMENT '角色类型(无用)',
  `mobile_number` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '手机号',
  `status` int(3) NULL DEFAULT 1 COMMENT '状态 1启用 -1弃用',
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`sys_home_page`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `type` tinyint(4) UNSIGNED NOT NULL DEFAULT 1 COMMENT '0:系统,1自定义',
  `app_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '平台code',
  `organ_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '医院id',
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '模板内容json字符串',
  `sync_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '模板同步时间',
  `template_url` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '模板链接地址',
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '状态（-1:删除，0:未启用, 1:启用）',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '首页可配置化' ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`sys_operation_log`  (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '名字',
  `phone` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '电话',
  `ip` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ip地址',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `app_code` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '平台编码',
  `channel_source` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '请求来源',
  `operation_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作说明',
  `req_url` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '请求地址',
  `req_params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '请求入参',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统操作日志表' ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`sys_operation_log_mapping`  (
  `req_url` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'url',
  `operation_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '操作名称',
  `status` tinyint(1) NOT NULL DEFAULT 1 COMMENT '状态',
  PRIMARY KEY (`req_url`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统日志url操作映射表' ROW_FORMAT = Compact;

CREATE TABLE `sysinfo-cloud`.`sys_page_path`  (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `page_type` tinyint(4) NOT NULL DEFAULT 0 COMMENT '0:页面跳转',
  `page_path` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '页面跳转路径',
  `page_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '页面标题',
  `app_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '平台code',
  `organ_id` bigint(11) NOT NULL DEFAULT 0 COMMENT '医院id',
  `app_id` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '小程序id',
  `status` tinyint(4) NOT NULL DEFAULT 1 COMMENT '状态（-1:未启用，1:启用）',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;


CREATE DATABASE `video_service` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- ----------------------------
-- Table structure for teleconference_user_room
-- ----------------------------
DROP TABLE IF EXISTS `video_service`.`teleconference_user_room`;
CREATE TABLE `video_service`.`teleconference_user_room` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `phone` varchar(11) DEFAULT '' COMMENT '视讯手机号',
  `room_num` varchar(12) DEFAULT '0' COMMENT '佰医房间号',
  `presenter_avatar` varchar(255) DEFAULT '',
  `presenter_name` varchar(20) DEFAULT '',
  `ysx_room_id` varchar(50) DEFAULT '' COMMENT '云视讯会议ID',
  `ysx_room_num` varchar(20) DEFAULT '' COMMENT '云视讯会议num',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` tinyint(11) NOT NULL DEFAULT '0' COMMENT '状态',
  `type` varchar(20) DEFAULT NULL COMMENT '视频类型',
  `tx_room_id` varchar(50) NOT NULL DEFAULT '' COMMENT '腾讯会议id',
  `tx_room_num` varchar(50) NOT NULL COMMENT '腾讯会议num',
  `tx_room_name` varchar(50) NOT NULL COMMENT '腾讯会议室名称',
  `tx_group_id` varchar(50) NOT NULL COMMENT '腾讯聊天室编号',
  PRIMARY KEY (`id`),
  UNIQUE KEY `index_phone` (`phone`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for tx_video_user
-- ----------------------------
DROP TABLE IF EXISTS `video_service`.`tx_video_user`;
CREATE TABLE `video_service`.`tx_video_user` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` tinyint(11) NOT NULL DEFAULT '1' COMMENT '状态',
  `room_num` varchar(20) NOT NULL COMMENT '房间编号',
  `user_id` varchar(50) NOT NULL COMMENT '用户编号',
  `user_name` varchar(20) NOT NULL COMMENT '用户名称',
  `phone` varchar(20) NOT NULL COMMENT '用户电话',
  `type` varchar(20) NOT NULL COMMENT '参与人类型',
  `sdk_type` varchar(20) NOT NULL COMMENT '参与人群',
  `sdk_account` varchar(64) NOT NULL COMMENT '参与人账号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for ysx_video_user
-- ----------------------------
DROP TABLE IF EXISTS `video_service`.`ysx_video_user`;
CREATE TABLE `video_service`.`ysx_video_user` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` varchar(36) DEFAULT '0' COMMENT '用户id',
  `phone` varchar(11) DEFAULT '' COMMENT '视讯手机号',
  `rec_id` varchar(36) DEFAULT '0' COMMENT 'rec_id',
  `uc_id` varchar(36) DEFAULT '0' COMMENT '云视讯设备ID',
  `uc_username` varchar(20) DEFAULT '' COMMENT '视讯用户名',
  `uc_password` varchar(100) DEFAULT '' COMMENT '视讯密码',
  `uc_email` varchar(100) DEFAULT '' COMMENT '视讯邮箱',
  `uc_token` varchar(255) DEFAULT '' COMMENT '视讯token',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` tinyint(11) DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`),
  UNIQUE KEY `index_user_id` (`user_id`),
  UNIQUE KEY `index_phone` (`phone`)
) ENGINE=InnoDB   DEFAULT CHARSET=utf8mb4;


CREATE DATABASE `byh_mylt_service` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- ----------------------------
-- Table structure for business_account_rule
-- ----------------------------
DROP TABLE IF EXISTS `byh_mylt_service`.`business_account_rule`;
CREATE TABLE `byh_mylt_service`.`business_account_rule` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `view_id` varchar(64) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `business_code` int(11) NOT NULL COMMENT '业务编码',
  `business_name` varchar(50) CHARACTER SET utf8mb4 NOT NULL COMMENT '业务名称',
  `name` varchar(50) CHARACTER SET utf8mb4 NOT NULL COMMENT '分账规则名称',
  `amount_method_code` int(11) NOT NULL COMMENT '分账方式编码',
  `amount_method_name` varchar(50) CHARACTER SET utf8mb4 NOT NULL COMMENT '分账方式名称',
  `amount_standard` decimal(10,2) NOT NULL COMMENT '分账标准',
  `min_amount` decimal(10,2) NOT NULL COMMENT '最低分账金额',
  `max_amount` decimal(10,2) DEFAULT NULL COMMENT '最高分账金额-null代表无穷大',
  `whether_enable` int(11) NOT NULL DEFAULT '0' COMMENT '是否启用 0不启用 1启用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='业务分账规则表';

-- ----------------------------
-- Table structure for expert_visit_order
-- ----------------------------
DROP TABLE IF EXISTS `byh_mylt_service`.`expert_visit_order`;
CREATE TABLE `byh_mylt_service`.`expert_visit_order` (
  `id` bigint(20) NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` int(4) NOT NULL,
  `view_id` varchar(64) NOT NULL DEFAULT '',
  `apply_hospital_id` bigint(11) NOT NULL COMMENT '申请医院id',
  `apply_hospital_name` varchar(20) NOT NULL DEFAULT '' COMMENT '申请医院名称',
  `apply_first_dep_id` bigint(11) NOT NULL COMMENT '申请一级科室id',
  `apply_first_dep_name` varchar(20) NOT NULL DEFAULT '' COMMENT '申请一级科室名称',
  `apply_second_dep_id` bigint(11) NOT NULL COMMENT '专家二级科室id',
  `apply_second_dep_name` varchar(20) NOT NULL DEFAULT '' COMMENT '专家二级科室名称',
  `intention_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '意向时间',
  `visit_hospital_id` bigint(11) DEFAULT NULL COMMENT '出诊医院id',
  `visit_hospital_name` varchar(20) NOT NULL DEFAULT '' COMMENT '出诊医院名称',
  `hospital_contact` varchar(10) NOT NULL DEFAULT '' COMMENT '医院联系人',
  `contact_phone` varchar(20) NOT NULL DEFAULT '' COMMENT '联系电话',
  `address` varchar(100) NOT NULL DEFAULT '' COMMENT '详细地址',
  `area` varchar(30) NOT NULL DEFAULT '' COMMENT '所在地区',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '付款金额',
  `payment_time` timestamp NULL DEFAULT NULL COMMENT '付款时间',
  `visit_time` timestamp NULL DEFAULT NULL COMMENT '出诊时间',
  `patient_refund_reason` text COMMENT '患者退款原因',
  `refund_refuse_reason` text COMMENT '管理端拒绝退款原因',
  `service_progress` int(4) DEFAULT NULL COMMENT '服务进度状态',
  `current_user_id` bigint(20) DEFAULT NULL COMMENT '当前用户id',
  `deal_trade_no` varchar(64) DEFAULT NULL COMMENT '平台订单号',
  `modified_by` varchar(50) DEFAULT NULL COMMENT '最后操作人',
  `open_id` varchar(64) DEFAULT NULL,
  `organ_code` varchar(20) DEFAULT NULL,
  `app_code` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for mylt_hospital
-- ----------------------------
DROP TABLE IF EXISTS `byh_mylt_service`.`mylt_hospital`;
CREATE TABLE `byh_mylt_service`.`mylt_hospital` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` int(4) DEFAULT NULL COMMENT '是否开通名医宝业务',
  `view_id` varchar(20) DEFAULT NULL,
  `hospital_id` bigint(20) DEFAULT NULL COMMENT '医院id',
  `hospital_name` varchar(20) DEFAULT NULL COMMENT '医院名称',
  `city_code` int(4) DEFAULT NULL COMMENT '城市编码',
  `city_name` varchar(60) DEFAULT NULL COMMENT '城市名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for mylt_merchant_config
-- ----------------------------
DROP TABLE IF EXISTS `byh_mylt_service`.`mylt_merchant_config`;
CREATE TABLE `byh_mylt_service`.`mylt_merchant_config` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` int(4) DEFAULT NULL,
  `view_id` varchar(20) DEFAULT '',
  `merchant_seq` varchar(64) DEFAULT '' COMMENT '商户编码',
  `biz_sys_seq` varchar(20) DEFAULT '' COMMENT '业务系统编码',
  `organ_code` varchar(20) DEFAULT '' COMMENT '机构编码',
  `client_code` varchar(20) DEFAULT NULL COMMENT '短信推送code',
  `sign_code` varchar(20) DEFAULT NULL COMMENT '短信推送(签名)',
  `app_code` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for mylt_order
-- ----------------------------
DROP TABLE IF EXISTS `byh_mylt_service`.`mylt_order`;
CREATE TABLE `byh_mylt_service`.`mylt_order` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` int(4) NOT NULL,
  `view_id` varchar(64) DEFAULT '',
  `patient_no_id` bigint(11) DEFAULT NULL COMMENT '就诊卡id',
  `patient_no_card` varchar(32) DEFAULT '' COMMENT '就诊卡卡号',
  `patient_id` bigint(11) DEFAULT NULL COMMENT '患者id',
  `patient_name` varchar(20) DEFAULT '' COMMENT '患者姓名',
  `patient_phone` varchar(20) NOT NULL DEFAULT '' COMMENT '患者手机号',
  `patient_card` varchar(32) DEFAULT '' COMMENT '身份证号',
  `card_url` text COMMENT '身份证照片路径',
  `disease_id` bigint(11) DEFAULT NULL COMMENT '病历id',
  `disease_describe` text COMMENT '病历描述',
  `disease_data_url` text COMMENT '病历资料',
  `hospital_id` bigint(11) DEFAULT NULL COMMENT '就诊医院id',
  `hospital_name` varchar(20) DEFAULT '' COMMENT '就诊医院名称',
  `expert_first_dep_id` bigint(11) DEFAULT NULL COMMENT '专家一级科室id',
  `expert_first_dep_name` varchar(20) DEFAULT '' COMMENT '专家一级科室名称',
  `expert_second_dep_id` bigint(11) DEFAULT NULL COMMENT '专家二级科室id',
  `expert_second_dep_name` varchar(20) DEFAULT '' COMMENT '专家二级科室名称',
  `intention_time` timestamp NULL DEFAULT NULL COMMENT '意向时间',
  `price` decimal(10,2) DEFAULT '0.00' COMMENT '付款金额',
  `payment_time` timestamp NULL DEFAULT NULL COMMENT '付款时间',
  `patient_refund_reasion` text COMMENT '患者退款原因',
  `user_refund_reasion` text COMMENT '管理员取消原因',
  `service_progress` int(4) DEFAULT NULL COMMENT '服务进度状态',
  `type` int(4) DEFAULT NULL COMMENT '服务类型',
  `hospitalization_url` text COMMENT '住院单路径',
  `current_user_id` bigint(20) DEFAULT NULL COMMENT '当前用户id',
  `deal_trade_no` varchar(64) DEFAULT NULL COMMENT '平台订单号',
  `reser_time` varchar(64) DEFAULT NULL COMMENT '预约时间',
  `finish_time` timestamp NULL DEFAULT NULL COMMENT '结束时间',
  `modified_by` varchar(50) DEFAULT NULL COMMENT '最后操作人',
  `open_id` varchar(64) DEFAULT NULL,
  `organ_code` varchar(20) DEFAULT NULL,
  `app_code` varchar(20) DEFAULT NULL,
  `organ_id` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for mylt_service_price
-- ----------------------------
DROP TABLE IF EXISTS `byh_mylt_service`.`mylt_service_price`;
CREATE TABLE `byh_mylt_service`.`mylt_service_price` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` int(4) DEFAULT NULL COMMENT '状态-1删除',
  `type` int(4) DEFAULT NULL COMMENT '服务类型',
  `view_id` varchar(20) DEFAULT NULL,
  `price` decimal(10,2) DEFAULT '0.00' COMMENT '价格',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for mylt_service_progress
-- ----------------------------
DROP TABLE IF EXISTS `byh_mylt_service`.`mylt_service_progress`;
CREATE TABLE `byh_mylt_service`.`mylt_service_progress` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` int(4) NOT NULL,
  `type` int(4) NOT NULL,
  `order_id` bigint(11) NOT NULL COMMENT '订单id',
  `service_progress` int(4) DEFAULT NULL COMMENT '服务进度状态',
  `hospital_name` varchar(20) DEFAULT '' COMMENT '医院名称',
  `hospital_id` bigint(11) DEFAULT NULL COMMENT '医院id',
  `expert_first_dep_id` bigint(11) DEFAULT NULL COMMENT '专家一级科室id',
  `expert_first_dep_name` varchar(20) DEFAULT '' COMMENT '专家一级科室名称',
  `expert_second_dep_id` bigint(11) DEFAULT NULL COMMENT '专家二级科室id',
  `expert_second_dep_name` varchar(20) DEFAULT '' COMMENT '专家二级科室名称',
  `doctor_id` bigint(11) DEFAULT NULL COMMENT '医生id',
  `doctor_name` varchar(20) DEFAULT '' COMMENT '医生名称',
  `Intention_time` timestamp NULL DEFAULT NULL COMMENT '意向时间',
  `user_type` int(4) DEFAULT NULL COMMENT '操作者类型',
  `operator_id` int(11) DEFAULT NULL COMMENT '操作者id',
  `remark_content` text COMMENT '备注内容',
  `operator_name` varchar(50) DEFAULT NULL COMMENT '操作者姓名',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for order_account_rule
-- ----------------------------
DROP TABLE IF EXISTS `byh_mylt_service`.`order_account_rule`;
CREATE TABLE `byh_mylt_service`.`order_account_rule` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '订单id',
  `view_id` varchar(64) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `business_code` int(11) NOT NULL COMMENT '业务编码',
  `business_name` varchar(50) CHARACTER SET utf8mb4 NOT NULL COMMENT '业务名称',
  `name` varchar(50) CHARACTER SET utf8mb4 NOT NULL COMMENT '分账规则名称',
  `amount_method_code` int(11) NOT NULL COMMENT '分账方式编码',
  `amount_method_name` varchar(50) CHARACTER SET utf8mb4 NOT NULL COMMENT '分账方式名称',
  `amount_standard` decimal(10,2) NOT NULL COMMENT '分账标准',
  `min_amount` decimal(10,2) NOT NULL COMMENT '最低分账金额',
  `max_amount` decimal(10,2) DEFAULT NULL COMMENT '最高分账金额',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='订单分账规则表';

-- ----------------------------
-- Table structure for settle_result
-- ----------------------------
DROP TABLE IF EXISTS `byh_mylt_service`.`settle_result`;
CREATE TABLE `byh_mylt_service`.`settle_result` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) DEFAULT NULL COMMENT '订单id',
  `view_id` varchar(64) NOT NULL DEFAULT '' COMMENT 'view_id主键外的唯一标识',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1:删除1:上线',
  `platform_income` decimal(10,3) DEFAULT NULL COMMENT '平台收益',
  `doctor_income` decimal(10,3) DEFAULT NULL COMMENT '医生收益',
  `operator_id` bigint(20) NOT NULL COMMENT '操作人id',
  `operator_name` varchar(60) NOT NULL COMMENT '操作人姓名',
  `account_rule_code` int(11) NOT NULL COMMENT '分账规则编码',
  `account_rule_name` varchar(30) NOT NULL COMMENT '分账规则名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='订单分账结果';


CREATE DATABASE `byh_medicalcloud_service` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;


CREATE TABLE `byh_medicalcloud_service`.`mos_app_organ_rel`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '主键Id',
  `app_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'appCode',
  `organ_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'organCode',
  `sms_sign_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `x_create_time` datetime(0) NOT NULL COMMENT '创建时间',
  `x_update_time` datetime(0) NOT NULL COMMENT '更新时间',
  `x_version` bigint(12) NULL DEFAULT NULL COMMENT '版本',
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '备注',
  `organ_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '互联网医院名称',
  `province` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '省份',
  `pres_pdf_icon` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '处方笺PDF的icon',
  `client_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '小程序推送code',
  `sms_client_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  PRIMARY KEY (`x_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'appCode和oraganCode关联关系' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_arc_alias`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `arcim_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'HIS医嘱项ID',
  `arcim_name` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'HIS医嘱项名称',
  `mnemonic_code` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '助记码',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `idx_mnemonic_code_1`(`mnemonic_code`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_arc_item`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构ID',
  `arcim_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS医嘱ID',
  `arcim_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS医嘱编号',
  `arcim_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS医嘱名称',
  `arcim_generic_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS药品通用名',
  `arcim_base_unit` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS医嘱基本单位',
  `arcim_pack_unit` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS医嘱包装单位',
  `arcim_price` decimal(10, 4) NULL DEFAULT NULL COMMENT 'HIS医嘱单价',
  `category_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS医嘱大类编码',
  `category_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS医嘱大类名称',
  `item_category_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS医嘱子类编码',
  `item_category_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS医嘱子类名称',
  `enable_start_time` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '生效开始时间',
  `enable_end_time` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '生效结束时间',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `idx_arcim_id_1`(`arcim_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_arc_specimen`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构编码',
  `arcim_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS医嘱项ID',
  `specimen_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'HIS标本代码',
  `specimen_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'HIS标本名称',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_area_price_config`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `area_id` int(5) NULL DEFAULT NULL,
  `area_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编码',
  `area_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '名称',
  `parent_id` int(5) NULL DEFAULT NULL COMMENT '父级ID',
  `price_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '价格id',
  `level` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '省；市；区；',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `idx_alias_1`(`parent_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_bookin`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `book_in_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS入院证ID',
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构编码',
  `doctor_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS医生工号',
  `doctor_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医生姓名',
  `dept_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'HIS医生科室编码',
  `book_dept_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'HIS入院科室编码',
  `book_dept_name` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '入院科室名称',
  `book_hos` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收治院区',
  `icd_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ICD诊断编码',
  `icd_name` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ICD诊断名称',
  `diag_desc` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '诊断描述',
  `admiple` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '入院原则',
  `doc_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医生备注',
  `disease_type` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '病种类型（1 普通，2 特殊病种，3 病房日间，4 优先收治病种，5 肿瘤复住病人）',
  `book_time_type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '预入院时间类型(亚专业或医疗组)',
  `clinic_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '亚专业类型',
  `group_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医疗组类型（根据预入院时间类型选填）',
  `first_hospital` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '首诊医院',
  `in_days` int(8) NULL DEFAULT NULL COMMENT '预计住院时间',
  `pre_pay` decimal(10, 4) NULL DEFAULT NULL COMMENT '预交金',
  `patient_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '患者ID',
  `patient_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '患者姓名',
  `patient_gender` tinyint(4) NULL DEFAULT NULL COMMENT '患者性别 1 男 2 女',
  `patient_idcard` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '患者身份证号',
  `patient_phone` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '患者电话号码',
  `patient_age` int(4) NULL DEFAULT NULL COMMENT '患者年龄',
  `papmi` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS患者ID',
  `adm_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '就诊ID',
  `his_adm_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS就诊ID',
  `book_status` tinyint(4) NULL DEFAULT NULL COMMENT '入院证状态',
  `transaction_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '调用HIS流水号',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '已同步/未同步',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_bookin_group`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关联机构编码',
  `dept_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关联科室编码',
  `group_type` tinyint(20) NOT NULL COMMENT '组类型 1 医疗组 2 亚专业',
  `group_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'HIS医疗组/亚专业名称',
  `group_dr` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'HIS医疗组/亚专业ID',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_clinic_group`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构编码',
  `dept_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS科室编码',
  `data_type` tinyint(4) NULL DEFAULT NULL COMMENT '数据类型 1 医疗组 2 亚专业',
  `data_dr` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS亚专业/医疗组ID',
  `data_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS亚专业/医疗组编码',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_diagnostic`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `diag_dr` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS诊断ID',
  `doctor_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `doctor_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `dept_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '当前科室编码',
  `adm_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `his_adm_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `diagnostic` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '诊断描述',
  `icd_code` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ICD诊断编码',
  `icd_name` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ICD诊断名称',
  `tcm_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '中医诊断编码',
  `tcm_name` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '中医诊断',
  `transaction_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '调用HIS流水号',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '数据状态',
  `adm_type` tinyint(4) NULL DEFAULT 0 COMMENT '是否真实就诊id 0-否 1-是',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '诊断信息表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_dictionary`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `dic_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `dic_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `dic_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '所属地区',
  `parent_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '父级字典编码',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '药品字典表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_alias`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构编码',
  `drug_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品项ID',
  `drug_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品编码',
  `drug_alias` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品别名',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '状态:删除:0',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `fk_mos_drug_alias_mos_drug_item_1`(`drug_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '药品别名表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_comment`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `main_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '医嘱ID',
  `status` tinyint(1) NOT NULL DEFAULT 1 COMMENT '删除标识',
  `commenter` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '点评医师',
  `opinion` tinyint(1) NOT NULL DEFAULT 1 COMMENT '0不合理,1合理',
  `comment_info` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '不合理意见',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '处方点评表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_detail`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `drug_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品ID',
  `drug_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品名称',
  `arcim_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS医嘱编码',
  `frequency_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '频次ID',
  `frequency_desc` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '频次描述',
  `frequency_rate` decimal(6, 4) NULL DEFAULT NULL COMMENT '频次换算率',
  `usage_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用法ID',
  `usage_desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用法描述',
  `reason_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '理由ID',
  `reason_desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '理由描述',
  `drug_spec` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品规格',
  `main_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医嘱主表ID',
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `store_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `single_dose` decimal(12, 4) NULL DEFAULT NULL COMMENT '单次剂量',
  `duration` int(10) NULL DEFAULT NULL COMMENT '疗程（天）',
  `amount` decimal(12, 4) NULL DEFAULT NULL COMMENT '取药量',
  `whole_packing_unit` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '整包装单位',
  `min_bill_packing_unit` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '最小计费包装单位',
  `min_bill_packing_num` decimal(12, 4) NULL DEFAULT NULL COMMENT '最小计费包装单位数量',
  `measure_unit` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '计量单位',
  `measure_num` decimal(12, 4) NULL DEFAULT NULL COMMENT '计量单位数量',
  `doc_remark` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医生备注',
  `verify_remark` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审单药师备注',
  `pres_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '处方id',
  `manufacturer` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '生产企业',
  `unit_price` decimal(12, 4) NULL DEFAULT NULL COMMENT '单价',
  `total_price` decimal(12, 4) NULL DEFAULT NULL COMMENT '总价',
  `verifier_phone` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '审核药师手机号',
  `verifier_dept_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '审核药师科室名称',
  `verifier_organ_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '审核药师医院名称',
  `amount_unit` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '取药量单位',
  `drug_common_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品通用编码',
  `pres_details_his_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT 'HIS处方明细id',
  `fee_name_code` tinyint(4) NULL DEFAULT 0 COMMENT '医嘱类型编码',
  `hh_code` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '海虹码',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `fk_mos_drug_detail_mos_drug_detail_2`(`main_id`) USING BTREE,
  INDEX `fk_mos_drug_detail_mos_drug_detail_1`(`pres_id`) USING BTREE,
  INDEX `fk_mos_drug_detail_mos_drug_frequency_1`(`frequency_id`) USING BTREE,
  INDEX `fk_mos_drug_detail_mos_drug_usage_1`(`usage_id`) USING BTREE,
  INDEX `fk_mos_drug_detail_mos_drug_reason_1`(`reason_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '处方药品详情表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_extend`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `main_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品医嘱主表ID',
  `verifier` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '审单药师',
  `verifier_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审单药师工号',
  `verify_time` datetime(0) NULL DEFAULT NULL COMMENT '审单时间',
  `verify_remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审单备注',
  `verify_sign` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审单师签名',
  `audit_status` tinyint(4) NULL DEFAULT NULL COMMENT '是否审核通过',
  `deployer` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '调配药师',
  `deploy_time` datetime(0) NULL DEFAULT NULL COMMENT '调配时间',
  `deploy_remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '调配备注',
  `courier_company` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '快递公司',
  `courier_company_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '快递公司编码',
  `courier_num` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '快递编号',
  `courier_price` decimal(6, 2) NULL DEFAULT NULL COMMENT '快递费用',
  `sender` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发货药师',
  `send_time` datetime(0) NULL DEFAULT NULL COMMENT '发货时间',
  `send_remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发货备注',
  `receipt_time` datetime(0) NULL DEFAULT NULL COMMENT '收货时间',
  `verifier_phone` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `verifier_dept_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `verifier_organ_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `fk_mos_drug_extend_mos_drug_extend`(`main_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '处方扩展表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_frequency`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `frequency_desc` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '频次名称',
  `frequency_code` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '频次编码',
  `frequency_rate` decimal(8, 6) NULL DEFAULT NULL COMMENT '换算率',
  `hospital_name_first_letter` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院名称的首字母',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '药品服务频次表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_group`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `doctor_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '医生ID',
  `group_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '组套名称',
  `status` tinyint(2) NULL DEFAULT 1 COMMENT '删除标志 0 删除',
  `drug_type` tinyint(4) NULL DEFAULT 1,
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '处方模板表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_group_item_rel`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '组套ID',
  `usage_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '用药途径ID',
  `reason_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '理由ID',
  `frequency_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '频次ID',
  `drug_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '药品项ID',
  `common_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '药品通用名编码',
  `drug_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '药品名称',
  `drug_specs` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '药品规格',
  `drug_dosage` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '取药量',
  `usage_desc` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '用法用量',
  `drug_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '药品备注',
  `single_dose` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '单次剂量',
  `cycle` int(10) NOT NULL COMMENT '周期',
  `status` tinyint(1) NULL DEFAULT 1 COMMENT '删除标志 0 删除',
  `min_bill_packing_unit` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '最小计费包装单位',
  `whole_packing_unit` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '整包装单位',
  `drug_usage_desc` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '给药途径',
  `frequency_desc` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '频次',
  `reason` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '用药理由',
  `measure_num` decimal(8, 2) NULL DEFAULT 0.00 COMMENT '最小包装剂量',
  `min_bill_packing_num` decimal(10, 4) NULL DEFAULT 0.0000 COMMENT '最小计费包装数量',
  `measure_unit` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '计量单位',
  `add_type` tinyint(1) NULL DEFAULT 0 COMMENT '药品添加类型 （0自动添加 1手动添加)',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '处方模板详情表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_item`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP,
  `x_update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `product_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '商品名',
  `product_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品商品编号',
  `type` tinyint(4) NULL DEFAULT NULL COMMENT '1西药2中成药3中药',
  `common_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '通用名',
  `common_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品通用名编码',
  `stock_packing_unit_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '库存包装单位ID',
  `whole_packing_unit_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '整包装单位ID',
  `whole_packing_num` decimal(10, 2) NULL DEFAULT NULL COMMENT '整包装数量',
  `spec_packing_unit_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规格包装单位ID',
  `spec_packing_num` int(4) NULL DEFAULT NULL COMMENT '规格包装数量',
  `min_bill_packing_unit_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '最小计费包装单位ID',
  `min_bill_packing_num` decimal(10, 2) NULL DEFAULT NULL COMMENT '最小计费包装数量',
  `measure_unit_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '计量单位ID',
  `measure_num` decimal(12, 4) NULL DEFAULT NULL COMMENT '计量单位数量',
  `manufacturer` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '生产企业',
  `dosage_form` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '剂型',
  `social_security_class` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '社保分类',
  `storage_conditions` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '贮存条件',
  `status` tinyint(1) NULL DEFAULT 1 COMMENT '删除标志 0 删除',
  `drug_spec` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品规格',
  `app_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `drug_approval_number` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品批准文号',
  `drug_property` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品性质',
  `price` decimal(8, 2) NULL DEFAULT NULL COMMENT '药品价格',
  `stock_packing_unit_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '库存包装单位',
  `whole_packing_unit_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '整包装单位',
  `spec_packing_unit_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规格包装单位',
  `min_bill_packing_unit_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '最小计费包装单位',
  `measure_unit_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '最小计费包装单位',
  `drug_dept_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品部门编码',
  `qyt` int(11) NULL DEFAULT NULL COMMENT '药品库存',
  `hospital_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院id',
  `hospital_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院名称',
  `hospital_drug_spec` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '医院药品规格',
  `special_drug_flag` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '特殊药品标识【STZS-新特药注射药】',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid`(`x_rowid`) USING BTREE,
  INDEX `fk_mos_drug_item_mos_drug_unit_1`(`stock_packing_unit_id`) USING BTREE,
  INDEX `fk_mos_drug_item_mos_drug_unit_2`(`whole_packing_unit_id`) USING BTREE,
  INDEX `fk_mos_drug_item_mos_drug_unit_3`(`spec_packing_unit_id`) USING BTREE,
  INDEX `fk_mos_drug_item_mos_drug_unit_4`(`min_bill_packing_unit_id`) USING BTREE,
  INDEX `fk_mos_drug_item_mos_drug_unit_5`(`measure_unit_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '药品表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_item_usage_rel`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `usage_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用法ID',
  `drug_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '药品ID',
  `status` tinyint(1) NOT NULL COMMENT '标记状态 1 已读 0 未读',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `fk_mos_drug_item_usage_rel_mos_drug_usage_1`(`usage_id`) USING BTREE,
  INDEX `fk_mos_drug_item_usage_rel_mos_drug_item_1`(`drug_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '药品用法关联表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_logistics_order`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP,
  `order_seq` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务订单号',
  `deal_seq` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '支付平台订单号',
  `bank_trade_no` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三方流水号',
  `pay_time` varchar(24) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `pay_method` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `mch_id` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `logistics_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '物流类型',
  `refund_time` varchar(24) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `main_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '物流单号',
  `logistics_basis_amount` decimal(6, 2) NULL DEFAULT NULL COMMENT '物流基础费',
  `overweight_amount` decimal(6, 2) NULL DEFAULT NULL COMMENT '超重费用',
  `package_amout` decimal(6, 2) NULL DEFAULT NULL,
  `pay_amount` decimal(6, 2) NULL DEFAULT NULL,
  `invoice_title` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发票抬头',
  `invoice_num` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发票号',
  `src_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '寄件人姓名',
  `src_phone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '寄件人电话',
  `src_province` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '寄件省',
  `src_city` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '寄件市',
  `src_district` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收件区（县）',
  `src_detail_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '寄件详细地址',
  `src_address` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '寄件地址',
  `dest_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收件人',
  `dest_phone` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收件人电话（手机）',
  `dest_province` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收件省',
  `dest_city` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收件市',
  `dest_district` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收件区（县）',
  `dest_detail_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '详细地址',
  `dest_address` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '全地址',
  `dest_latitude` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '经度',
  `dest_longitude` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '纬度',
  `dest_delivery_distance` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '距离寄件地址的距离',
  `dest_address_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址id',
  `parcel_weighs` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '包裹重量',
  `package_no` int(2) NULL DEFAULT NULL COMMENT '件数',
  `depositum_info` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '物品信息',
  `depositum_no` int(2) NULL DEFAULT NULL COMMENT '物品数量',
  `remark` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `monthly_card` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '月付卡号',
  `pack_standard_money` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '包裹标准包装金额 ',
  `product_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '\"病案寄递\" ：MEDICAL_CHART\"，   \"中药寄递\"：CHINESE_HERBAL\"，\"其他\"：\"OTHER\"',
  `logistics_pay_method` int(2) NULL DEFAULT NULL COMMENT '1（注：1为寄付，2为到付，3为0元，寄付月结的payMethod传1,再传月结卡号即可）',
  `express_type` int(2) NULL DEFAULT NULL COMMENT '使用的顺丰产品类型  标快 1',
  `channel_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `hospital_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `hospital_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `app_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `order_status` tinyint(4) NULL DEFAULT NULL,
  `biz_sys_seq` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '支付业务系统编码',
  `medical_device_fee` decimal(8, 2) NULL DEFAULT 0.00 COMMENT '医保设备服务费',
  `distribution_type` tinyint(4) NULL DEFAULT NULL COMMENT '配送方式 1-串点模式 2-同城急送模式',
  `send_type` tinyint(4) NULL DEFAULT 0 COMMENT '发货类型【1-手动 2-自动】',
  `distributor` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配送员',
  `distributor_phone` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配送员联系电话',
  `delivery_store_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '物流订单表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_logistics_order_reg`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `main_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `logistics_order_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `main_id`(`main_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '物流订单处方关联表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_logistics_route`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `logistics_order_id` bigint(20) NOT NULL,
  `mail_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `accept_address` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `accept_date` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `accept_time` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `accept_total_time` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `op_code` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `remark` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `delivery_name` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `delivery_phone` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '物流路由信息表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_main`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `x_update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `pres_organ` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开单机构编码',
  `item_status` tinyint(4) NULL DEFAULT NULL COMMENT '医嘱状态',
  `pres_organ_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开单机构名称',
  `pres_doctor_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开单医生ID',
  `pres_doctor_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开单医生工号',
  `pres_doctor_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开单医生姓名',
  `pres_doctor_phone` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开单医生手机号码',
  `pres_dept_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开单科室编码',
  `pres_dept_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开单科室名称',
  `adm_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '就诊记录ID',
  `his_adm_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS就诊记录ID',
  `patient_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '患者ID',
  `patient_user_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开单时的患者ID',
  `patient_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '患者姓名',
  `patient_phone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '患者电话',
  `patient_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '患者就诊卡号',
  `patient_gender` tinyint(4) NULL DEFAULT NULL COMMENT '患者性别',
  `patient_age` tinyint(4) NULL DEFAULT NULL COMMENT '患者年龄',
  `rec_dept_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医嘱接收科室编码',
  `rec_dept_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医嘱接收科室名称',
  `status` tinyint(4) NULL DEFAULT 0 COMMENT '数据是否有效 1：有效 -1：无效',
  `refund_status` tinyint(4) NULL DEFAULT 0 COMMENT '退款状态 1 默认 3 退款成功',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医嘱备注',
  `transaction_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS交易号',
  `his_message` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'his返回信息',
  `failure_time` datetime(0) NULL DEFAULT NULL COMMENT '在线门诊失效时间',
  `doctor_sign` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '开单医生签名',
  `sign_type` tinyint(4) NULL DEFAULT NULL COMMENT '签名类型 （0:手动签名 1:CA签名）',
  `complement_drug` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '补充药品',
  `pres_type` tinyint(4) NULL DEFAULT 1 COMMENT '处方类型 1-西药 2-中成药 3-中药',
  `drug_amount` int(12) NULL DEFAULT NULL,
  `use_method` int(12) NULL DEFAULT NULL,
  `decoction` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `organ_id` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `drug_species_num` int(10) NULL DEFAULT 0 COMMENT '药品种类数量',
  `serv_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '复诊科室Code',
  `serv_code_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '复诊科室名称',
  `patient_cred_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '患者身份证号',
  `std_first_dept_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '一级科室名称',
  `std_second_dept_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '二级科室名称',
  `app_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `patient_no_type` int(10) NULL DEFAULT NULL COMMENT '就诊卡类型 1 自费 2 医保',
  `prescription_source` int(2) NULL DEFAULT NULL COMMENT '处方来源 1.his 2app',
  `express_flag` int(2) NULL DEFAULT NULL COMMENT 'his返回的配送方式',
  `drug_flag` int(2) NULL DEFAULT 1 COMMENT '药品标识1、药品。 2非药品',
  `hospital_name_first_letter` varchar(24) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院名称的首字母',
  `fetch_medical_code` varchar(6) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '取药码',
  `store_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `order_type` int(2) NULL DEFAULT NULL COMMENT '订单类型 1 自取订单2 快递订单',
  `payment_type` int(2) NULL DEFAULT NULL,
  `obtain_time` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开药时间',
  `medical_record_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `diagnostic` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '诊断说明',
  `oss_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '处方笺url',
  `html_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '处方笺htmlurl',
  `patient_his_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT 'his患者Id',
  `pres_his_dept_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT ' his科室code',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '处方主信息表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_order`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0),
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `main_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品医嘱主表ID',
  `order_type` tinyint(2) NULL DEFAULT NULL COMMENT '订单类型 1 药品订单 2 快递订单',
  `merchant_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商户编码',
  `deal_seq` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '支付系统单号',
  `order_seq` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务系统订单号',
  `bank_trade_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '银行流水号',
  `pay_time` datetime(0) NULL DEFAULT NULL COMMENT '支付时间',
  `pay_method` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `pay_amount` decimal(10, 4) NULL DEFAULT NULL COMMENT '支付总金额',
  `organ_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构编码',
  `biz_sys_seq` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务系统编码',
  `mch_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '支付回调商户号',
  `refund_time` datetime(0) NULL DEFAULT NULL COMMENT '成功退款时间',
  `channel_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `status` int(10) NULL DEFAULT NULL COMMENT '订单状态',
  `drug_money` decimal(6, 4) NULL DEFAULT NULL,
  `fund_amount` decimal(6, 2) NULL DEFAULT NULL,
  `physician_service_amount` decimal(6, 2) NULL DEFAULT NULL,
  `total_drug_amount` decimal(10, 2) NULL DEFAULT NULL COMMENT '处方药品总金额',
  `self_amount` decimal(6, 2) NULL DEFAULT NULL COMMENT '处方药品自费金额',
  `invoice_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发票号',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `fk_mos_drug_order_mos_drug_main_1`(`main_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '处方订单信息表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_prescription`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `main_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医嘱主表ID',
  `oss_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `unique_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关联医网签同步信息唯一ID',
  `adm_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '就诊记录ID',
  `price` decimal(12, 2) NULL DEFAULT NULL COMMENT '处方药价',
  `html_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `store_price` decimal(12, 4) NULL DEFAULT 0.0000 COMMENT '存储价格',
  `pres_type` tinyint(4) NULL DEFAULT 4 COMMENT '处方类型 1-西药 2-中成药 3-中药 4-西药和中成药',
  `recipe_date` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开处方时间',
  `his_recipe_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'his处方号',
  `drug_kind_count` int(10) NULL DEFAULT NULL COMMENT '药品种类数',
  `own_flag` int(2) NULL DEFAULT NULL COMMENT '自费标识 0-医保 1-自费',
  `fee_type` tinyint(4) NULL DEFAULT 0 COMMENT '处方类型 0-普通 1-生育 2-门特 3-混合',
  `status` tinyint(4) NULL DEFAULT 1 COMMENT '1-有效 0-无效',
  `creat_flag` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '煎药方式',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '处方信息表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_prescription_ca`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `pres_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '处方ID',
  `pres_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '处方号',
  `unique_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医网签唯一ID',
  `pres_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `sign_status` tinyint(2) NULL DEFAULT NULL COMMENT '处方签名状态标志',
  `sign_status_des` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `syn_time` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '同步时间',
  `sign_result` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '签名结果',
  `sign_time` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '签名时间',
  `sign_stamp` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '回调接口签章值',
  `reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '拒绝签名原因',
  `type` tinyint(2) NULL DEFAULT NULL COMMENT '认证类型 1 医师开单 2 药师审核',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `fk_mos_drug_prescription_ca_mos_drug_prescription_1`(`pres_id`) USING BTREE,
  CONSTRAINT `fk_mos_drug_prescription_ca_mos_drug_prescription_1` FOREIGN KEY (`pres_id`) REFERENCES `byh_medicalcloud_service`.`mos_drug_prescription` (`x_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_price`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `drug_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品项ID',
  `store_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药房ID',
  `price` decimal(8, 2) NULL DEFAULT NULL COMMENT '状态 1 启用 0 禁用',
  `enable_start_time` datetime(0) NULL DEFAULT NULL COMMENT '价格生效开始时间',
  `enable_end_time` datetime(0) NULL DEFAULT NULL COMMENT '价格生效结束时间',
  `organ_drug_rel_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `fk_mos_drug_price_mos_drug_item_1`(`drug_id`) USING BTREE,
  INDEX `fk_mos_drug_price_mos_drugstore_1`(`store_id`) USING BTREE,
  INDEX `organ_drug_rel_id`(`organ_drug_rel_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '药品价格表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_reason`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `reason_desc` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '理由描述',
  `reason_code` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '理由编码',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '药品用药理由' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_recipe_info`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `x_update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `pres_organ` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开单机构编码',
  `item_status` tinyint(4) NULL DEFAULT NULL COMMENT '医嘱状态',
  `pres_organ_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开单机构名称',
  `pres_doctor_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开单医生ID',
  `pres_doctor_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开单医生工号',
  `pres_doctor_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开单医生姓名',
  `pres_doctor_phone` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开单医生手机号码',
  `pres_dept_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开单科室编码',
  `pres_dept_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开单科室名称',
  `adm_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '就诊记录ID',
  `his_adm_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS就诊记录ID',
  `patient_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '患者ID',
  `patient_user_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开单时的患者ID',
  `patient_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '患者姓名',
  `patient_phone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '患者电话',
  `patient_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '患者就诊卡号',
  `patient_gender` tinyint(4) NULL DEFAULT NULL COMMENT '患者性别',
  `patient_age` tinyint(4) NULL DEFAULT NULL COMMENT '患者年龄',
  `rec_dept_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医嘱接收科室编码',
  `rec_dept_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医嘱接收科室名称',
  `status` tinyint(4) NULL DEFAULT 0 COMMENT '数据是否有效 1：有效 -1：无效',
  `refund_status` tinyint(4) NULL DEFAULT 0 COMMENT '退款状态 1 默认 3 退款成功',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医嘱备注',
  `transaction_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS交易号',
  `his_message` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'his返回信息',
  `failure_time` datetime(0) NULL DEFAULT NULL COMMENT '在线门诊失效时间',
  `doctor_sign` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '开单医生签名',
  `sign_type` tinyint(4) NULL DEFAULT NULL COMMENT '签名类型 （0:手动签名 1:CA签名）',
  `complement_drug` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '补充药品',
  `pres_type` tinyint(4) NULL DEFAULT 1 COMMENT '处方类型 1-西药 2-中成药 3-中药',
  `drug_amount` int(12) NULL DEFAULT NULL,
  `use_method` int(12) NULL DEFAULT NULL,
  `decoction` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `organ_id` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `drug_species_num` int(10) NULL DEFAULT 0 COMMENT '药品种类数量',
  `serv_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '复诊科室Code',
  `serv_code_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '复诊科室名称',
  `patient_cred_no` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '患者身份证号',
  `std_first_dept_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '一级科室名称',
  `std_second_dept_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '二级科室名称',
  `app_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `patient_no_type` int(10) NULL DEFAULT NULL COMMENT '就诊卡类型 1 自费 2 医保',
  `prescription_source` int(2) NULL DEFAULT NULL COMMENT '处方来源 1.his 2app',
  `express_flag` int(2) NULL DEFAULT NULL COMMENT 'his返回的配送方式',
  `drug_flag` int(2) NULL DEFAULT 1 COMMENT '药品标识1、药品。 2非药品',
  `hospital_name_first_letter` varchar(24) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院名称的首字母',
  `fetch_medical_code` varchar(6) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '取药码',
  `store_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `order_type` int(2) NULL DEFAULT NULL COMMENT '订单类型 1 自取订单2 快递订单',
  `payment_type` int(2) NULL DEFAULT NULL,
  `obtain_time` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开药时间',
  `medical_record_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `diagnostic` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '诊断说明',
  `oss_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '处方笺url',
  `html_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '处方笺htmlurl',
  `patient_his_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT 'his患者Id',
  `pres_his_dept_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT ' his科室code',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '处方主信息表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_remark`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `main_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品医嘱主表ID',
  `remark_user` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注人',
  `remark_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '备注内容',
  `remark_type` tinyint(2) NULL DEFAULT NULL COMMENT '备注类型 1 调配备注 2 下账备注',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `fk_mos_drug_remark_mos_drug_main_1`(`main_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '处方操作备注表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_unit`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `unit_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单位编码',
  `unit_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单位名称',
  `unit_type` tinyint(2) NULL DEFAULT NULL COMMENT '单位类型（库存/整包装/最小计费/剂量）',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '药品单位表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_usage`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `usage_desc` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用法描述',
  `usage_code` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用法编码',
  `hospital_name_first_letter` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院名称的首字母',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '药品用法表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drug_verifier`  (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `app_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '诊疗平台code',
  `organ_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院ID',
  `doctor_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审核药师ID',
  `verifier` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审核药师姓名',
  `phone` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审核药师电话',
  `drug_type` tinyint(4) NULL DEFAULT NULL COMMENT '药师类型 1:全部 2:西药/中成药 3:中草药',
  `status` tinyint(4) NULL DEFAULT 1 COMMENT '数据是否有效 1:有效 -1：无效',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '审核药师信息表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_drugstore`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `store_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药房名称',
  `store_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '药房编码',
  `store_address` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药房地址',
  `status` tinyint(2) NULL DEFAULT 1 COMMENT '状态 1 启用 0 禁用',
  `store_telephone` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系电话',
  `business_day` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '营业日期',
  `business_time` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '营业时间',
  `online_status` tinyint(4) NULL DEFAULT NULL COMMENT '是否上线（1:上线 0:下线）',
  `distribution_status` tinyint(4) NULL DEFAULT NULL COMMENT '是否支持配送（1:是 0:否）',
  `express_fee` decimal(8, 2) NULL DEFAULT 0.00 COMMENT '快递费',
  `service_fee` decimal(8, 2) NULL DEFAULT 0.00 COMMENT '服务费',
  `app_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'appCode',
  `pharmaceutical_company_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药商id',
  `pharmaceutical_company_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药商名称',
  `organ_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `shop_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '顺丰同城店铺ID',
  `dev_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '顺丰同城开发者ID',
  `cross_shop_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '顺丰同城串点模式店铺ID',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '药房表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_his_autotask`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构编码',
  `interface_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '接口名称',
  `task_type` tinyint(4) NULL DEFAULT NULL COMMENT '任务类型',
  `request` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '接口请求数据',
  `times` tinyint(4) NULL DEFAULT NULL COMMENT '重试次数',
  `status` tinyint(4) NOT NULL COMMENT '接口调用状态',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_his_log`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构编码',
  `interface_name` varchar(550) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '接口名称',
  `request` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '接口请求数据',
  `response` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '接口响应数据',
  `status` tinyint(4) NOT NULL COMMENT '接口调用状态',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_his_sync_config`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '机构编码',
  `sync_task_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '同步任务编码',
  `sync_task_desc` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '同步任务描述',
  `frequency` int(11) NOT NULL COMMENT '执行频率 秒/次',
  `next_time` datetime(0) NULL DEFAULT NULL COMMENT '下次执行时间',
  `current_id` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '任务当前执行ID',
  `status` tinyint(4) NOT NULL COMMENT '同步状态 1 已完成 2 执行中',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_hospital_config`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `app_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `hospital_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `latitude` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '维度',
  `longitude` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '经度',
  `province` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '省',
  `city` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '市',
  `district` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '区',
  `detail_address` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '详细地址',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '寄件人姓名',
  `phone` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '寄件人电话',
  `monthly_card` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '月付卡号',
  `pack_standard_money` decimal(6, 2) NULL DEFAULT NULL COMMENT '包装费 ',
  `overweight_amount` decimal(6, 2) NULL DEFAULT NULL COMMENT '超重费用',
  `wm_template` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '西药和中成药模板',
  `cm_template` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '中药模板',
  `medical_device_fee` decimal(8, 2) NULL DEFAULT 0.00 COMMENT '医保设备服务费',
  `base_kilometer` decimal(6, 2) NULL DEFAULT 0.00 COMMENT '基础公里数',
  `base_kilometer_fee` decimal(6, 2) NULL DEFAULT 0.00 COMMENT '基础公里费用',
  `per_kilometer_fee` decimal(6, 2) NULL DEFAULT 0.00 COMMENT '每公里计费',
  `cross_base_kilometer` decimal(6, 2) NULL DEFAULT 0.00 COMMENT '串点基础公里数',
  `cross_base_kilometer_fee` decimal(6, 2) NULL DEFAULT 0.00 COMMENT '串点基础公里费用',
  `cross_per_kilometer_fee` decimal(6, 2) NULL DEFAULT 0.00 COMMENT '串点每公里计费',
  `city_pack_standard_money` decimal(6, 2) NULL DEFAULT 0.00 COMMENT '同城急送包装费',
  `hospital_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '顺丰医院CODE',
  `secret_key` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '顺丰医院秘钥',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '医院配置表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_icd_alias`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构编码',
  `icd_dr` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ICD诊断HIS ID',
  `icd_alias` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ICD诊断别名',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `idx_alias_1`(`icd_alias`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_icd_item`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构编码',
  `icd_dr` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ICD诊断HIS ID',
  `icd_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'ICD诊断编码',
  `icd_encode` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'ICD诊断副编码',
  `icd_name` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'ICD诊断名称',
  `icd_mnemonic` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'ICD助记码',
  `status` tinyint(2) NULL DEFAULT 1 COMMENT '状态 0-删除 1-正常',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `idx_organ_code_icd_dr_1`(`organ_code`, `icd_dr`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'icd信息表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_icd_item_back11`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构编码',
  `icd_dr` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ICD诊断HIS ID',
  `icd_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'ICD诊断编码',
  `icd_encode` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'ICD诊断副编码',
  `icd_name` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'ICD诊断名称',
  `icd_mnemonic` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'ICD助记码',
  `status` tinyint(2) NULL DEFAULT 1 COMMENT '状态 0-删除 1-正常',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `idx_organ_code_icd_dr_1`(`organ_code`, `icd_dr`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_icd_item_bak20200521`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构编码',
  `icd_dr` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ICD诊断HIS ID',
  `icd_code` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ICD诊断编码',
  `icd_name` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ICD诊断名称',
  `icd_mnemonic` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `icd_encode` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `status` tinyint(4) NULL DEFAULT 1,
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `idx_organ_code_icd_dr_1`(`organ_code`, `icd_dr`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_icd_item_beijing`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构编码',
  `icd_dr` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ICD诊断HIS ID',
  `icd_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'ICD诊断编码',
  `icd_encode` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'ICD诊断副编码',
  `icd_name` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'ICD诊断名称',
  `icd_mnemonic` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'ICD助记码',
  `status` tinyint(2) NULL DEFAULT 1 COMMENT '状态 0-删除 1-正常',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `idx_organ_code_icd_dr_1`(`organ_code`, `icd_dr`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'icd信息表(北京)' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_mark`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `doctor_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医生ID',
  `mark_type` tinyint(3) NOT NULL COMMENT '标记类型',
  `mark_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '标记记录ID',
  `status` tinyint(1) NOT NULL COMMENT '标记状态 1 已读 0 未读',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_medica_records`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `diag_dr` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS诊断ID',
  `doctor_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `doctor_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `dept_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '当前科室编码',
  `adm_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `his_adm_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `diagnostic` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '诊断描述',
  `icd_code` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ICD诊断编码',
  `icd_name` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ICD诊断名称',
  `tcm_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '中医诊断编码',
  `tcm_name` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '中医诊断',
  `transaction_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '调用HIS流水号',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '数据状态',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '诊断信息表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_merchant_config`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `x_update_time` datetime(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `merchant_seq` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商户编码',
  `biz_sys_seq` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务系统编码',
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构编码（药房编码）',
  `merchant_type` tinyint(2) NULL DEFAULT NULL COMMENT '商户类型 1 药房 2 快递 (废弃)',
  `app_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `apply_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `apply_key` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '商户号信息表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_oeorder_item`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `doctor_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `doctor_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `dept_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开单科室编码',
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `adm_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `his_adm_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `arcim_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS医嘱项ID',
  `arcim_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医嘱项编码',
  `arcim_name` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS医嘱项名称',
  `oeord_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIS医嘱记录ID',
  `unit` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单位',
  `amount` int(10) NULL DEFAULT NULL COMMENT '数量',
  `unit_price` decimal(10, 4) NULL DEFAULT NULL COMMENT '医嘱单价',
  `price` decimal(10, 4) NULL DEFAULT NULL COMMENT '医嘱总金额',
  `specimen_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `specimen_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标本名称',
  `his_start_time` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT 'HIS开医嘱时间',
  `bill_status` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '账单状态（未付款/付款/记账）',
  `rec_dept_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医嘱接收科室编码',
  `rec_dept_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医嘱接收科室名称',
  `his_end_time` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT 'HIS停医嘱时间',
  `instructions` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用法（药品）',
  `frequency` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '频次（药品）',
  `duration` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '疗程（药品）',
  `urgent` tinyint(4) NULL DEFAULT NULL COMMENT '是否紧急 1 是 2 否',
  `item_status` tinyint(4) NULL DEFAULT NULL COMMENT '医嘱状态（核实/停止/未激活/作废/执行）',
  `transaction_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '调用HIS流水号',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '数据状态（未同步/已同步）',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_organ_drug_rel`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构编码',
  `drug_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品项ID',
  `arcim_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品医嘱ID',
  `arcim_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品医嘱编码',
  `arcim_price` decimal(10, 4) NULL DEFAULT NULL COMMENT 'HIS医嘱价格',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '关联状态 1 可用 0 停用',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `fk_mos_organ_drug_rel_mos_drug_item_1`(`drug_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '医院药品关联表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_organ_store_rel`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `organ_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构编码',
  `store_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药房ID',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '关联状态 1 生效 0 失效',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `fk_mos_organ_store_mos_drugstore_1`(`store_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '药房医院关联表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_outpatient_main_rel`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '主键Id',
  `main_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '医嘱id',
  `disease_lable` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '疾病标签',
  `disease_description` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '病情描述',
  `need_help` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '需要得到的帮助',
  `order_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '在线门诊订单id',
  `admission_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '就诊id',
  `app_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'appCode',
  `tags` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `x_create_time` datetime(0) NOT NULL COMMENT '创建时间',
  `x_update_time` datetime(0) NOT NULL COMMENT '更新时间',
  `x_version` bigint(12) NULL DEFAULT NULL COMMENT '版本',
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '备注',
  `medical_record_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '病历号',
  `his_reg_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'HIS挂号交易流水号',
  `order_seq` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`x_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '在线门诊开处方记录表/复诊处方关联表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_pdf_address`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `app_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `oss_host` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'oss域名',
  `html_path` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'html路径',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '处方地址配置表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_pharmaceutical_company`  (
  `id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `pharmaceutical_company_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药商名称',
  `status` tinyint(2) NULL DEFAULT 1 COMMENT '状态 1 启用 0 禁用',
  `app_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'appCode',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '药商表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_pharmaceutical_company_drug_rel`  (
  `id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `pharmaceutical_company_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药商ID',
  `drug_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品项ID',
  `status` tinyint(2) NULL DEFAULT 1 COMMENT '关联状态 1 可用 0 停用',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fk_mos_store_drug_rel_mos_drugstore_1`(`pharmaceutical_company_id`) USING BTREE,
  INDEX `fk_mos_store_drug_rel_mos_drug_item_1`(`drug_id`) USING BTREE,
  CONSTRAINT `mos_pharmaceutical_company_drug_rel_ibfk_1` FOREIGN KEY (`drug_id`) REFERENCES `byh_medicalcloud_service`.`mos_drug_item` (`x_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '药商药品关联表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_price_config`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `price` decimal(10, 4) NULL DEFAULT NULL COMMENT '价格',
  `s_time` datetime(0) NULL DEFAULT NULL COMMENT '开始时间',
  `e_time` datetime(0) NULL DEFAULT NULL COMMENT '结束时间',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '价格配置表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_standard_code_library`  (
  `id` bigint(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `standard_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '新编码',
  `drug_approval_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品批准文号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '北京监管平台所要编码表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_standard_code_library_hyt`  (
  `id` bigint(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `standard_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '新编码',
  `drug_approval_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品批准文号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '北京监管平台所要编码表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_standard_code_library_zr`  (
  `id` bigint(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `standard_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '新编码',
  `drug_approval_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品批准文号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '北京中日友好医院编码表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_store_doctor_rel`  (
  `x_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药房ID',
  `doctor_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医生ID',
  `doctor_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '医生姓名',
  `status` tinyint(4) NULL DEFAULT 1 COMMENT '关联状态 1 可用 0 停用',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '药房医生关联表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_store_drug_rel`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药房ID',
  `drug_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药品项ID',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '关联状态 1 可用 0 停用',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `fk_mos_store_drug_rel_mos_drugstore_1`(`store_id`) USING BTREE,
  INDEX `fk_mos_store_drug_rel_mos_drug_item_1`(`drug_id`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '药品药品关联表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_store_hospital_rel`  (
  `x_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '药房ID',
  `hospital_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院ID',
  `hospital_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '医院名称',
  `status` tinyint(4) NULL DEFAULT 1 COMMENT '关联状态 1 可用 0 停用',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '药房医院关联表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_store_stock_rel`  (
  `x_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `x_update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NULL DEFAULT NULL,
  `store_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '药房ID',
  `drug_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '药品项ID',
  `stock_status` tinyint(4) NULL DEFAULT 1 COMMENT '库存状态 1 有 0 没有',
  `status` tinyint(4) NULL DEFAULT 1 COMMENT '关联状态 1 可用 0 停用',
  PRIMARY KEY (`store_id`, `drug_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '药房库存表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_synch_pres_record`  (
  `id` bigint(14) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `main_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '处方id',
  `response_message` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '返回消息',
  `response_data` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '返回值',
  `request_body` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '请求参数',
  `doctor_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '医生姓名',
  `patient_phone` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '患者电话号码',
  `patient_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '患者姓名',
  `patient_id_card` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '患者身份证号',
  `response_code` int(11) NOT NULL COMMENT '返回状态码',
  `compensate_times` int(4) NOT NULL DEFAULT 0 COMMENT '尝试次数',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`mos_user_address`  (
  `x_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `x_create_time` datetime(0) NULL DEFAULT NULL,
  `x_update_time` datetime(0) NULL DEFAULT NULL,
  `x_version` bigint(20) NULL DEFAULT NULL,
  `x_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_date_sign` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `x_rowid` int(11) NOT NULL AUTO_INCREMENT,
  `main_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医嘱主表ID',
  `receiver` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收件人',
  `telephone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系电话',
  `area_info` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地区信息（省市区）',
  `comma_area_info` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '省市区逗号隔开',
  `detail_address` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '详细地址',
  `courier_price` decimal(6, 2) NULL DEFAULT NULL COMMENT '快递费用',
  `invoice_title` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `invoice_num` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '',
  `address_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '地址ID',
  `latitude` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '维度',
  `longitude` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '经度',
  `delivery_distance` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '配送距离',
  PRIMARY KEY (`x_id`) USING BTREE,
  UNIQUE INDEX `idx_x_rowid_1`(`x_rowid`) USING BTREE,
  INDEX `fk_mos_user_address_mos_drug_main_1`(`main_id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户地址信息表' ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`pres_roam_process_reg`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `process_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程code',
  `app_code` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点code',
  `hospital_name_first_letter` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '医院名称的首字母',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`service_pay_bill`  (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '订单生成时间',
  `update_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '订单更新时间',
  `status` int(11) NULL DEFAULT NULL COMMENT '状态 0未知，1待支付，2支付中，3已支付，4支付失败，5退款中，6已退款，7退款失败',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '备注',
  `app_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '节点code',
  `organ_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '医院首字母',
  `work_service_code` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '业务code',
  `apply_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '应用code',
  `pay_channel` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '支付渠道',
  `trade_time` timestamp(0) NULL DEFAULT NULL COMMENT '交易时间',
  `trade_no` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '交易第三方流水号',
  `out_trade_no` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '业务流水号',
  `trade_status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '支付状态:SUCCESS ,FAIL',
  `order_amount` decimal(10, 2) NULL DEFAULT NULL COMMENT '订单金额',
  `deal_amount` decimal(10, 2) NULL DEFAULT NULL COMMENT '交易金额',
  `refund_no` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '退款第三方流水号',
  `out_refund_no` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '退款业务流水号',
  `refund_time` timestamp(0) NULL DEFAULT NULL COMMENT '退款时间',
  `refund_amount` decimal(10, 2) NULL DEFAULT NULL COMMENT '退款金额',
  `goods_info` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '商品信息',
  `service_code` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '节点code_医院id_业务编码 例:BYH_661_YCHZ',
  `deal_trade_no` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '平台交易号',
  `organ_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '医院id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`shedlock`  (
  `name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `lock_until` timestamp(3) NULL DEFAULT NULL,
  `locked_at` timestamp(3) NULL DEFAULT NULL,
  `locked_by` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

CREATE TABLE `byh_medicalcloud_service`.`table_test`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB   CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compact;

CREATE DEFINER = `syt`@`%` PROCEDURE `byh_medicalcloud_service`.`UP_CHANGE_UTF8MB4`()
  COMMENT '将当前数据库中所有表的字符集转换成utf8mb4'
BEGIN
  DECLARE $i INT;
  DECLARE $cnt INT;
  DECLARE $NAME VARCHAR(64);

  #创建临时表，代替游标
  DROP TABLE IF EXISTS tmp_Table_name;
  CREATE TEMPORARY TABLE tmp_Table_name (
    id INT NOT NULL AUTO_INCREMENT,
    table_name VARCHAR(64) NOT NULL,
    PRIMARY KEY (`id`)
  );

  # 插入要处理的表名到临时表中
  INSERT INTO tmp_Table_name (table_name)
    SELECT
      table_name
    FROM information_schema.`TABLES`
    WHERE TABLE_TYPE = 'BASE TABLE'
    AND TABLE_SCHEMA = DATABASE();

  #循环处理每一张表，改表的字符集
  SET $i = 1;
  SELECT
    COUNT(1) INTO $cnt
  FROM tmp_Table_name;
  WHILE $i <= $cnt DO
    SELECT
      table_name INTO $NAME
    FROM tmp_Table_name
    WHERE id = $i;

   SET @asql = CONCAT('ALTER TABLE ', $NAME, '  CHARSET utf8mb4 COLLATE utf8mb4_unicode_ci; ');
    PREPARE asql FROM @asql;
    EXECUTE asql;

    SET @asql = CONCAT('ALTER TABLE ', $NAME, ' CONVERT TO CHARSET utf8mb4 COLLATE utf8mb4_unicode_ci; ');
    PREPARE asql FROM @asql;
    SELECT @asql;
    EXECUTE asql;

    SET $i = $i + 1;
  END WHILE;
  DEALLOCATE PREPARE asql;
  DROP TABLE tmp_Table_name;
END;


INSERT INTO `pushcenter_cloud`.`sms_application` (`id`, `create_date`, `create_time`, `create_user`, `enabled`, `update_date`, `update_time`, `update_user`, `app_key`, `app_sdk_id`, `app_sdk_type`, `client_code`, `client_name`, `remark`, `app_code`)
VALUES
	(1, '2019-12-09', '15:34:22', NULL, 1, NULL, NULL, NULL, 'GTKrBOaSbIEaaPBEJU94ETltZ08YuX', 'LTAI4FwMYWcJsdYRTJEuSbya', 'ali', 'EHOS_BY', '佰医汇', NULL, 'BYH');


INSERT INTO `pushcenter_cloud`.`sms_sign` ( `create_date`, `create_time`, `create_user`, `enabled`, `update_date`, `update_time`, `update_user`, `sign_code`, `sign_name`)
VALUES
	( '2019-11-21', '15:46:00', 'admin', 1, '', '', '', 'BYH_BY', '佰医');

INSERT INTO `pushcenter_cloud`.`wx_push_application` (`id`, `create_date`, `create_time`, `create_user`, `enabled`, `update_date`, `update_time`, `update_user`, `access_token`, `grant_type`, `appid`, `secret`, `expires_in`, `client_code`, `client_name`)
VALUES
	(1, '2019-11-22', '17:24:00', NULL, 1, NULL, NULL, NULL, NULL, 'client_credential', 'wx4fb6c44748663d4d', '783e0068660328a061169f89048ef77b', NULL, 'WX_BYH', '佰医汇');

INSERT INTO `pushcenter_cloud`.`sms_application_sms_template_merge` ( `application_id`, `template_fk_id`, `template_code`, `language_type`)
VALUES
	(1, 8, 'ys_reg_authcode', 'CN'),
	(1, 79, 'dz_back_pwd_authcode', 'CN'),
	(1, 14, 'dz_edit_phone_authcode', 'CN'),
	(1, 15, 'dz_wx_login_authcode', 'CN'),
	(1, 16, 'ys_back_pwd_authcode', 'CN'),
	(1, 17, 'ys_edit_phone_authcode', 'CN'),
	(1, 18, 'ys_wx_login_authcode', 'CN'),
	(1, 19, 'dz_zxwz_doc_refuse', 'CN'),
	(1, 20, 'ys_zxwz_notice', 'CN'),
	(1, 21, 'SMS_152213161', 'CN'),
	(1, 22, 'SMS_152289907', 'CN'),
	(1, 23, 'SMS_152505054', 'CN'),
	(1, 24, 'SMS_152213163', 'CN'),
	(1, 25, 'SMS_152505059', 'CN'),
	(1, 26, 'SMS_152208306', 'CN'),
	(1, 27, 'SMS_152505063', 'CN'),
	(1, 28, 'SMS_152505067', 'CN'),
	(1, 29, 'SMS_152289922', 'CN'),
	(1, 30, 'SMS_159490317', 'CN'),
	(1, 31, 'SMS_152505111', 'CN'),
	(1, 32, 'SMS_152289964', 'CN'),
	(1, 33, 'SMS_152289969', 'CN'),
	(1, 34, 'SMS_152505116', 'CN'),
	(1, 35, 'SMS_152289971', 'CN'),
	(1, 36, 'SMS_152505120', 'CN'),
	(1, 37, 'SMS_152505121', 'CN'),
	(1, 38, 'SMS_152505125', 'CN'),
	(1, 39, 'SMS_155370905', 'CN'),
	(1, 40, 'SMS_152505073', 'CN'),
	(1, 41, 'SMS_156895842', 'CN'),
	(1, 42, 'SMS_152208307', 'CN'),
	(1, 43, 'SMS_152213169', 'CN'),
	(1, 44, 'SMS_112470358', 'CN'),
	(1, 45, 'SMS_112465230', 'CN'),
	(1, 46, 'SMS_105685071', 'CN'),
	(1, 47, 'SMS_101990013', 'CN'),
	(1, 48, 'SMS_101990009', 'CN'),
	(1, 49, 'SMS_101990010', 'CN'),
	(1, 50, 'SMS_154500331', 'CN'),
	(1, 51, 'SMS_153995512', 'CN'),
	(1, 53, 'SMS_156465082', 'CN'),
	(1, 54, 'SMS_153990171', 'CN'),
	(1, 55, 'SMS_153995162', 'CN'),
	(1, 56, 'SMS_153990172', 'CN'),
	(1, 57, 'SMS_153995163', 'CN'),
	(1, 58, 'SMS_153995164', 'CN'),
	(1, 59, 'SMS_153990178', 'CN'),
	(1, 60, 'SMS_153990176', 'CN'),
	(1, 61, 'SMS_155355980', 'CN'),
	(1, 62, 'SERVICE_PACAKAGE_2', 'CN'),
	(1, 63, 'SERVICE_PACAKAGE_1', 'CN'),
	(1, 71, 'SMS_145595379', 'CN'),
	(1, 72, 'SERVICE_PACAKAGE_2', 'CN'),
	(1, 73, 'SERVICE_PACAKAGE_1', 'CN'),
	(1, 74, 'dz_zxwz_doc_refuse', 'CN'),
	(1, 75, 'dz_group_refuse', 'CN'),
	(1, 76, 'ys_zxwz_notice', 'CN'),
	(1, 77, 'dz_wx_fast_login', 'CN'),
	(1, 78, 'dz_edit_phone_authcode', 'CN'),
	(1, 79, 'dz_back_pwd_authcode', 'CN'),
	(1, 80, 'dz_reg_authcode', 'CN'),
	(1, 81, 'ys_transfer', 'CN'),
	(1, 82, 'ys_wx_fast_login', 'CN'),
	(1, 83, 'ys_edit_phone_authcode', 'CN'),
	(1, 84, 'ys_back_pwd_authcode', 'CN'),
	(1, 85, 'ys_reg_authcode', 'CN'),
	(1, 111, 'dz_back_pwd_authcode', 'CN'),
	(1, 117, 'dz_miniProgram_login_authCode', 'CN'),
	(1, 122, 'SMS_153995160', 'CN'),
	(1, 123, 'SMS_174025740', 'CN'),
	(1, 124, 'SMS_174025743', 'CN'),
	(1, 125, 'SMS_174020702', 'CN'),
	(1, 132, 'SMS_175531595', 'CN'),
	(1, 133, 'SMS_175531595', 'CN'),
	(1, 134, 'SMS_175531595', 'CN'),
	(1, 135, 'SMS_175532330', 'CN'),
	(1, 136, 'SMS_175571571', 'CN'),
	(1, 137, 'SMS_164155640', 'CN'),
	(1, 144, 'jkgl_shwc', 'CN'),
	(1, 145, 'jkgl_zfcg', 'CN'),
	(1, 146, 'jkgl_sqtk', 'CN'),
	(1, 147, 'jkgl_ddgq', 'CN'),
	(1, 148, 'jkgl_ddytk', 'CN'),
	(1, 149, 'jkgl_ddyqx', 'CN'),
	(1, 150, 'jkgl_dddsh', 'CN'),
	(1, 151, 'jkgl_tksqfs', 'CN'),
	(1, 152, 'SMS_175400014', 'CN'),
	(1, 153, 'SMS_175400027', 'CN'),
	(1, 154, 'SMS_175400034', 'CN'),
	(1, 155, 'SMS_175405010', 'CN'),
	(1, 156, 'SMS_175400002', 'CN'),
	(1, 157, 'SMS_175582286', 'CN'),
	(1, 158, 'mylt_ddsc', 'CN'),
	(1, 159, 'mylt_yyjz', 'CN'),
	(1, 160, 'mylt_ysjz', 'CN'),
	(1, 161, 'mylt_zjqr', 'CN'),
	(1, 162, 'mylt_jzwc', 'CN'),
	(1, 232, 'SMS_175400014', 'CN'),
	(1, 233, 'SMS_175400027', 'CN'),
	(1, 234, 'SMS_175400034', 'CN'),
	(1, 235, 'SMS_175405010', 'CN'),
	(1, 236, 'SMS_175531595', 'CN'),
	(1, 237, 'SMS_175531595', 'CN'),
	(1, 238, 'SMS_175531595', 'CN'),
	(1, 239, 'SMS_175532330', 'CN'),
	(1, 240, 'SMS_175571571', 'CN'),
	(1, 241, 'SMS_175400002', 'CN'),
	(1, 242, 'SMS_175582286', 'CN'),
	(1, 243, 'mylt_ddsc', 'CN'),
	(1, 244, 'mylt_yyjz', 'CN'),
	(1, 245, 'mylt_ysjz', 'CN'),
	(1, 246, 'mylt_zjqr', 'CN'),
	(1, 247, 'mylt_jzwc', 'CN'),
	(1, 248, 'jkgl_shwc', 'CN'),
	(1, 249, 'jkgl_zfcg', 'CN'),
	(1, 250, 'jkgl_sqtk', 'CN'),
	(1, 251, 'jkgl_ddgq', 'CN'),
	(1, 252, 'jkgl_ddytk', 'CN'),
	(1, 253, 'jkgl_ddyqx', 'CN'),
	(1, 254, 'jkgl_dddsh', 'CN'),
	(1, 255, 'jkgl_tksqfs', 'CN'),
	(1, 264, 'ty_ghbdsj', 'CN'),
	(1, 265, 'ty_sfyz', 'CN'),
	(1, 277, 'SMS_182669503', 'CN'),
	(1, 280, 'yyy_cfshwtg', 'CN'),
	(1, 281, 'yyy_cfshtg', 'CN'),
	(1, 282, 'yyy_yssdcf', 'CN'),
	(1, 283, 'yyy_hzxzzg', 'CN'),
	(1, 284, 'yyy_hzxzps', 'CN'),
	(1, 285, 'yyy_yppszkdd', 'CN'),
	(1, 286, 'yyy_pswc', 'CN'),
	(1, 287, 'yyy_yfgq', 'CN'),
	(1, 288, 'yyy_hzsdcf', 'CN'),
	(1, 289, 'yyy_hzzfcf', 'CN'),
	(1, 290, 'yyy_yppszshsm', 'CN'),
	(1, 304, 'xzxwz_sfzwhftx', 'CN'),
	(1, 305, 'xzxwz_lxswhftx', 'CN'),
	(1, 319, 'czmm', 'CN'),
	(1, 321, 'sfjh_confirm', 'CN'),
	(1, 322, 'sfjh_start', 'CN'),
	(1, 323, 'sfjh_end', 'CN'),
	(1, 330, 'sfbd_wait', 'CN'),
	(1, 329, 'jkxj', 'CN'),
	(1, 336, 'sfjh_submit', 'CN'),
	(1, 361, 'yyy_hzypzfcg', 'CN'),
	(1, 360, 'yyy_hzcfshwtg', 'CN'),
	(1, 359, 'yyy_hzxxgy', 'CN'),
	(1, 358, 'yyy_hzckqy', 'CN'),
	(1, 357, 'yyy_hzapps', 'CN'),
	(1, 356, 'yyy_hzfxgy', 'CN'),
	(1, 355, 'yyy_yscfshwtg', 'CN'),
	(1, 370, 'myb_zffwfy', 'CN'),
	(1, 371, 'myb_dddcl', 'CN'),
	(1, 372, 'myb_lxkf', 'CN'),
	(1, 373, 'myb_qryyzj', 'CN'),
	(1, 379, 'yyy-cfht', 'CN'),
	(1, 385, 'xzxwz-kjfzbltx', 'CN'),
	(1, 386, 'xzxwz-kjzlyjtx', 'CN'),
	(1, 393, 'pay_der_authcode', 'CN');



INSERT INTO `pushcenter_cloud`.`sms_template` (`id`, `create_date`, `create_time`, `create_user`, `enabled`, `update_date`, `update_time`, `update_user`, `busi_name`, `temp_code`, `temp_content`, `temp_desc`, `temp_id`, `rule_times`, `convert_rule`)
VALUES
	(8, '2019-01-21', '18:14:53', NULL, 1, NULL, NULL, NULL, '医生注册验证码', 'ys_reg_authcode', '您的注册验证码是{1}，请在5分钟内输入，若非您操作请忽略。', '医生注册验证码', '269051', 3, NULL),
	(13, '2019-01-22', '18:14:53', NULL, 1, NULL, NULL, NULL, '大众找回密码验证码', 'dz_back_pwd_authcode', '您找回密码的验证码是{1}，请在{2}分钟内输入，若非您操作请忽略。', '大众找回密码验证码', '270574', 3, NULL),
	(14, '2019-01-22', '18:14:53', NULL, 1, NULL, NULL, NULL, '大众修改手机号验证码', 'dz_edit_phone_authcode', '您正在修改登录手机号，验证码是{1}，请在{2}分钟内输入，若非您操作请忽略', '大众修改手机号验证码', '270576', 3, NULL),
	(15, '2019-01-22', '18:14:53', NULL, 1, NULL, NULL, NULL, '大众微信快捷登陆验证码', 'dz_wx_login_authcode', '您正在使用微信快捷登录绑定手机号，验证码是{1}，请在{2}分钟内输入，若非您操作请忽略。', '大众微信快捷登陆验证码', '270577', 3, NULL),
	(16, '2019-01-22', '18:14:53', NULL, 1, NULL, NULL, NULL, '医生找回密码验证码', 'ys_back_pwd_authcode', '您找回密码的验证码是{1}，请在{2}分钟内输入，若非您操作请忽略。', '医生找回密码验证码', '270574', 3, NULL),
	(17, '2019-01-22', '18:14:53', NULL, 1, NULL, NULL, NULL, '医生修改手机号验证码', 'ys_edit_phone_authcode', '您正在修改登录手机号，验证码是{1}，请在{2}分钟内输入，若非您操作请忽略', '医生修改手机号验证码', '270576', 3, NULL),
	(18, '2019-01-22', '18:14:53', NULL, 1, NULL, NULL, NULL, '医生微信快捷登陆验证码', 'ys_wx_login_authcode', '您正在使用微信快捷登录绑定手机号，验证码是{1}，请在{2}分钟内输入，若非您操作请忽略。', '医生微信快捷登陆验证码', '270577', 3, NULL),
	(19, '2019-01-29', '14:54:20', NULL, 1, NULL, NULL, NULL, '医生拒绝患者申请短信', 'dz_zxwz_doc_refuse', '{1}拒绝了您的申请，请您登录APP前往咨询记录中查看拒绝理由。', '医生拒绝患者申请短信', '274451', 3, NULL),
	(20, '2019-01-30', '14:54:20', NULL, 1, NULL, NULL, NULL, '提醒医生有人申请了他的在线问诊业务', 'ys_zxwz_notice', '{1}申请了您在{2}的在线问诊，请您及时登录APP处理。', '提醒医生有人申请了他的在线问诊业务', '274444', 3, NULL),
	(21, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '新申请消息', 'SMS_152213161', '患者${patientname}，性别${sex}，${age} 岁，向您发来一个会诊申请，邀请您帮忙申请并一同参与专家会诊，请立即处理。', '新申请消息', 'SMS_152213161', 3, NULL),
	(22, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '视频会诊已接诊通知', 'SMS_152289907', '您好，${expertname}专家已接受您的视频会诊邀请，请于${time}准时进行会诊。', '视频会诊已接诊通知', 'SMS_152289907', 3, NULL),
	(23, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '图文会诊已接诊通知', 'SMS_152505054', '您好，${expertname}专家已接受您的图文会诊邀请，将于${time}结束。会诊已开始，请⽴立即参加。', '图文会诊已接诊通知', 'SMS_152505054', 3, NULL),
	(24, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '会诊专家更换通知', 'SMS_152213163', '尊敬的${doctorname}医生，非常抱歉，由于专家${expertname}24小时内未接受您的会诊申请，将由管理员为您分配合适的专家进行会诊。', '会诊专家更换通知', 'SMS_152213163', 3, NULL),
	(25, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '会诊提醒通知', 'SMS_152505059', '与患者${patientname}、专家${expertname}的视频会诊将于1小时后开始，请准时参加会诊，并保证网络状况良好。', '会诊提醒通知', 'SMS_152505059', 3, NULL),
	(26, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '视频会诊开始通知', 'SMS_152208306', '您与患者${patientname}、专家${expertname}的视频会诊已开始，请登录佰医汇APP或官网立即进入会诊聊天室参与会诊。', '视频会诊开始通知', 'SMS_152208306', 3, NULL),
	(27, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '视频会诊已分配通知', 'SMS_152505063', '【佰医汇】您申请的视频会诊管理员已分配专家，请登录查看详情。', '视频会诊已分配通知', 'SMS_152505063', 3, NULL),
	(28, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '图文会诊已分配通知', 'SMS_152505067', '【佰医汇】您申请的图文会诊管理员已分配专家，请登录查看详情。', '图文会诊已分配通知', 'SMS_152505067', 3, NULL),
	(29, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '专家上传报告通知', 'SMS_152289922', '${expertname}专家已完成会诊报告的填写，请您及时登录进行查看确认。', '专家上传报告通知', 'SMS_152289922', 3, NULL),
	(30, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '双向转诊转诊申请通知', 'SMS_159490317', '【佰医汇】管理员为您分配了一个转诊订单,请联系医院管理员查看详情。', '双向转诊转诊申请通知', 'SMS_159490317', 3, NULL),
	(31, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '视频会诊申请通知', 'SMS_152505111', '您有一个新的视频会诊申请，请登录系统及时处理。', '视频会诊申请通知', 'SMS_204986045', 3, NULL),
	(32, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '图⽂文会诊接诊通知', 'SMS_152289964', '【佰医汇】您有一个新的图文会诊申请，请登录佰医汇APP或官网及时处理。', '图⽂文会诊接诊通知', 'SMS_152289964', 3, NULL),
	(33, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '会诊转出通知', 'SMS_152289969', '【佰医汇】非常抱歉，由于24小时内您未接受医生$ {doctorname}的会诊申请，该订单已转至管理员处理。', '会诊转出通知', 'SMS_152289969', 3, NULL),
	(34, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '会诊提醒通知', 'SMS_152505116', '【佰医汇】与患者${patientname}、医生${doctorname}的视频会诊将于1小时后开始，请准时参加会诊，并保证网络状况良好。', '会诊提醒通知', 'SMS_152505116', 3, NULL),
	(35, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '视频会诊开始通知', 'SMS_152289971', '【佰医汇】您与患者${patientname}、医生${doctorname}的视频会诊已到开始时间，请立即登录参加。', '视频会诊开始通知', 'SMS_152289971', 3, NULL),
	(36, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '视频会诊分配通知', 'SMS_152505120', '【佰医汇】管理员为您分配了一个视频会诊，请登录查看详情。', '视频会诊分配通知', 'SMS_152505120', 3, NULL),
	(37, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '图⽂文会诊分配通知', 'SMS_152505121', '【佰医汇】管理员为您分配了一个图文会诊，请登录查看详情。', '图⽂文会诊分配通知', 'SMS_152505121', 3, NULL),
	(38, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '提交报告通知', 'SMS_152505125', '【佰医汇】您与患者${patientname}、${doctorname}医生的会诊已完成，请及时填写并提交会诊报告。', '提交报告通知', 'SMS_152505125', 3, NULL),
	(39, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '会诊报告审核失败', 'SMS_155370905', '【佰医汇】很抱歉，您有一个会诊报告审核未通过，原因：${reason}。请您及时查看报告详情。', '会诊报告审核失败', 'SMS_155370905', 3, NULL),
	(40, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '认证通过通知', 'SMS_152505073', '【佰医汇】您的认证已审核通过，医生服务已自动开启。如果您在使用中遇到了任何问题，可以随时联系客服。', '认证通过通知', 'SMS_152505073', 3, NULL),
	(41, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '认证失败通知', 'SMS_156895842', '【佰医汇】抱歉，您的认证审核失败。原因：${reason}如有问题请与佰医汇客服联系：400-631-9377。', '认证失败通知', 'SMS_156895842', 3, NULL),
	(42, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '入账通知', 'SMS_152208307', '【佰医汇】您有一笔新的入账，共计${money}元，登录佰医汇APP点击账户管理查看入账详情。', '入账通知', 'SMS_152208307', 3, NULL),
	(43, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '排班更新通知', 'SMS_152213169', '【佰医汇】您的排班信息已更新，登录佰医汇APP或官网点击排班管理查看详情。', '排班更新通知', 'SMS_152213169', 3, NULL),
	(44, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '注册验证码', 'SMS_112470358', '验证码:${code}（10分钟有效）该验证码仅用于核实手机号码或密码找回，如非本人操作请忽略。', '注册验证码', 'SMS_183760187', 3, NULL),
	(45, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '非注册验证码', 'SMS_112465230', '【佰医汇】您的短信验证码是${code}。', '非注册验证码', 'SMS_112465230', 3, NULL),
	(46, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '注册绑定验证码', 'SMS_105685071', '【佰医汇】验证码为${code}，佰医汇提醒您，您正在绑定微信公众平台。', '注册绑定验证码', 'SMS_105685071', 3, NULL),
	(47, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '登录确认验证码', 'SMS_101990013', '【佰医汇】验证码${code}，您正在登录，若非本人操作，请勿泄露。', '登录确认验证码', 'SMS_101990013', 3, NULL),
	(48, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '信息变更验证码', 'SMS_101990009', '【佰医汇】验证码${code}，您正在尝试变更重要信息，请妥善保管账户信息。', '信息变更验证码', 'SMS_101990009', 3, NULL),
	(49, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '修改密码验证码', 'SMS_101990010', '【佰医汇】验证码${code}，您正在尝试修改登录密码，请妥善保管账户信息。', '修改密码验证码', 'SMS_101990010', 3, NULL),
	(50, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '注册成功 ', 'SMS_154500331', '【佰医汇】恭喜您成功注册佰医汇！您的账号为${phone}，认证审核通过后，即刻享受更多优质服务。', '注册成功 ', 'SMS_154500331', 3, NULL),
	(51, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '绑定就诊人', 'SMS_153995512', '【佰医汇】您好，用户（${phone}）已将您绑定为他的就诊人，如有疑问请拨打客服电话400-631-9377咨询详情。 ', '绑定就诊人', 'SMS_153995512', 3, NULL),
	(53, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '医⽣生成功递交申请', 'SMS_156465082', '【佰医汇】您好，医生${doctorName}已帮您申请${expertName}专家会诊，请至佰医汇公众号搜索${hospitalName}医院登录支付。', '医⽣生成功递交申请', 'SMS_156465082', 3, NULL),
	(54, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '专家已接诊', 'SMS_153990171', '【佰医汇】您好,$ {expertname}专家已接受您的申请，将于${date}与医生会诊，请耐心等待会诊结果。 ', '专家已接诊', 'SMS_180951878', 3, NULL),
	(55, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '会诊结束提醒查看会诊报告', 'SMS_153995162', '【佰医汇】您好，医生与${expertname}专家会诊已结束，专家已完成会诊报告的填写，请前去查看和确认。', '会诊结束提醒查看会诊报告', 'SMS_153995162', 3, NULL),
	(56, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '待签署订单提醒签字', 'SMS_153990172', '【佰医汇】您好，医生已接收到您的会诊申请，您有一个会诊申请知情同意书待签署，请前去佰医汇公众号签署。 ', '待签署订单提醒签字', 'SMS_153990172', 3, NULL),
	(57, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '取消申请', 'SMS_153995163', '【佰医汇】很抱歉，您有一个会诊申请已取消，原因：${reason}。 ', '取消申请', 'SMS_153995163', 3, NULL),
	(58, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '名医挂号挂号成功 ', 'SMS_153995164', '【佰医汇】您好，您预约的${hospitalname},${date}时间${departname}科室${doctorname}医生的号，医事服务费${money}元已缴纳成功，请您按时到院取号就诊，祝您平安!', '名医挂号挂号成功 ', 'SMS_153995164', 3, NULL),
	(59, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '取消挂号 ', 'SMS_153990178', '【佰医汇】您预约的$ {hospitalname}，时间${date}，${departname}科室${doctorname}医生的号，已经成功取消，谢谢您的支持。', '取消挂号 ', 'SMS_153990178', 3, NULL),
	(60, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '未按时缴费取消订单', 'SMS_153990176', '【佰医汇】您预约的${hospitalname}，时间 ${date}，${departname}科室$ {doctorname}医生的号，由于三十分钟没有支付，已经被释放，谢谢您的使用。', '未按时缴费取消订单', 'SMS_153990176', 3, NULL),
	(61, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '双向转诊订单接收通知', 'SMS_155355980', '【佰医汇】您的转诊\r\n申请${hospitalName}\r\n已审核通过，接诊\r\n⼈人：$\r\n{receiverName}。请\r\n于${date}前往医院就\r\n诊。（其中⽇日期是转\r\n诊⽇日期)', '双向转诊订单接收通知', 'SMS_155355980', 3, NULL),
	(62, '2019-04-01', '15:02:26', NULL, 1, NULL, NULL, NULL, '服务包提醒医生', 'SERVICE_PACAKAGE_2', '{1}收到了新的服务包申请，请您尽快前往{2}app处理，48小时内未处理将会自动退款；', '服务包提醒医生', '304071', 3, NULL),
	(63, '2019-04-01', '15:02:26', NULL, 1, NULL, NULL, NULL, '服务包提醒医生', 'SERVICE_PACAKAGE_1', '您收到了新的服务包申请，请您尽快前往{1}app处理，48小时内未处理将会自动退款；', '服务包提醒医生', '304069', 3, NULL),
	(71, '2019-04-26', '10:00:00', NULL, 1, NULL, NULL, NULL, '会诊订单取消通知医生', 'SMS_145595379', '您的会诊申请已取消。请及时登录佰医汇平台查看确认。（如有问题请致电佰医汇客服：400-631-9377）', '会诊订单取消通知医生', 'SMS_145595379', 3, NULL),
	(72, '2019-05-05', '16:54:55', NULL, 1, NULL, NULL, NULL, '1.服务包提醒-1', 'SERVICE_PACAKAGE_2', '【佰医汇】${teamName}收到了新的服务包申请，请您尽快前往app处理，48小时内未处理将会自动退款；', '1.服务包提醒-1', 'SMS_164508989', 3, '{\"teamName\":0}'),
	(73, '2019-05-05', '16:54:55', NULL, 1, NULL, NULL, NULL, '2.服务包提醒-2', 'SERVICE_PACAKAGE_1', '【佰医汇】您收到了新的服务包申请，请您尽快前往app处理，48小时内未处理将会自动退款；', '2.服务包提醒-2', 'SMS_164508991', 3, NULL),
	(74, '2019-05-05', '16:54:55', NULL, 1, NULL, NULL, NULL, '3.医生拒绝申请提示短信--个人', 'dz_zxwz_doc_refuse', '${serviceName}医生拒绝了您的申请，请您登录APP前往咨询记录中查看拒绝理由。', '3.医生拒绝申请提示短信--个人', 'SMS_164514036', 3, NULL),
	(75, '2019-05-05', '16:54:55', NULL, 1, NULL, NULL, NULL, '4.医生拒绝申请提示短信--团队', 'dz_group_refuse', '${serviceName}拒绝了您的申请，请您登录APP前往咨询记录中查看拒绝理由。', '4.医生拒绝申请提示短信--团队', 'SMS_164509026', 3, NULL),
	(76, '2019-05-05', '16:54:55', NULL, 1, NULL, NULL, NULL, '5.提示医生的短信', 'ys_zxwz_notice', '【佰医汇】${patName}申请了您在${organName}的${bizName}服务，请您及时登录APP处理。', '5.提示医生的短信', 'SMS_164514047', 3, '{\"patName\":0,\"organName\":1,\"bizName\":2}'),
	(77, '2019-05-05', '16:54:55', NULL, 1, NULL, NULL, NULL, '6.大众wx快捷登陆时yzm', 'dz_wx_fast_login', '您正在使用微信快捷登录绑定手机号，验证码${authCode}，请在10分钟内输入，若非您操作请忽略。', '6.wx快捷登陆时yzm', 'SMS_164514054', 3, NULL),
	(78, '2019-05-05', '16:54:55', NULL, 1, NULL, NULL, NULL, '7.大众修改登陆手机号yzm	', 'dz_edit_phone_authcode', '您正在修改登录手机号，验证码是${authCode}，请在10分钟内输入，若非您操作请忽略。', '7.修改登陆手机号yzm	', 'SMS_164509042', 3, NULL),
	(79, '2019-05-05', '16:54:55', NULL, 1, NULL, NULL, NULL, '8.大众找回密码yzm', 'dz_back_pwd_authcode', '您找回密码的验证码是${authCode}，请在10分钟内输入，若非您操作请忽略。', '8.找回密码yzm', 'SMS_164514059', 3, NULL),
	(80, '2019-05-05', '16:54:55', NULL, 1, NULL, NULL, NULL, '9.大众端注册时yzm', 'dz_reg_authcode', '您的注册验证码是${authCode}，请在10分钟内输入，若非您操作请忽略。', '9.大众端注册时yzm', 'SMS_164514065', 3, NULL),
	(81, '2019-05-05', '16:54:55', NULL, 1, NULL, NULL, NULL, '15.医生移交提醒短信-团队', 'ys_transfer', '【佰医汇】${teamName}的${doctorName}医生已将患者${patName}移交给您，请您及时登录APP处理。', '15.移交提醒短信-团队', 'SMS_164509050', 3, NULL),
	(82, '2019-05-05', '16:54:55', NULL, 1, NULL, NULL, NULL, '6.医生wx快捷登陆时yzm', 'ys_wx_fast_login', '【佰医汇】您正在使用微信快捷登录绑定手机号，验证码${authCode}，请在10分钟内输入，若非您操作请忽略。', '6.wx快捷登陆时yzm', 'SMS_164514054', 3, NULL),
	(83, '2019-05-05', '16:54:55', NULL, 1, NULL, NULL, NULL, '7.医生修改登陆手机号yzm	', 'ys_edit_phone_authcode', '【佰医汇】您正在修改登录手机号，验证码是${authCode}，请在10分钟内输入，若非您操作请忽略。', '7.修改登陆手机号yzm	', 'SMS_164509042', 3, NULL),
	(84, '2019-05-05', '16:54:55', NULL, 1, NULL, NULL, NULL, '8.医生找回密码yzm', 'ys_back_pwd_authcode', '【佰医汇】您找回密码的验证码是${authCode}，请在10分钟内输入，若非您操作请忽略。', '8.找回密码yzm', 'SMS_164514059', 3, NULL),
	(85, '2019-05-05', '16:54:55', NULL, 1, NULL, NULL, NULL, '9.医生端注册时yzm', 'ys_reg_authcode', '【佰医汇】您的注册验证码是${authCode}，请在10分钟内输入，若非您操作请忽略。', '9.大众端注册时yzm', 'SMS_164514065', 3, NULL),
	(111, '2019-05-05', '16:54:55', NULL, 1, NULL, NULL, NULL, '8.大众找回密码yzm', 'dz_back_pwd_authcode', '您找回密码的验证码是${authCode}，请在10分钟内输入，若非您操作请忽略。', '8.找回密码yzm', 'SMS_164514059', 3, NULL),
	(117, '2019-07-17', '14:20:37', NULL, 0, NULL, NULL, NULL, '大众端-小程序快捷登录验证码', 'dz_miniProgram_login_authCode', '您登录的验证码是${authCode}，请在10分钟内输入，若非您本人操作请忽略。', '大众端小程序登录认证验证码', 'SMS_170840413', 3, '333'),
	(122, '2019-03-19', '18:14:53', NULL, 1, NULL, NULL, NULL, '用户提交新申请', 'SMS_153995160', '您已成功向${doctorName}医生发送了会诊申请，请耐心等待医生回复。', '用户提交新申请', 'SMS_153995160', 3, NULL),
	(123, '2019-11-08', '14:59', NULL, 1, NULL, NULL, NULL, '患者端-远程影像申请成功', 'SMS_174025740', '您的远程影像申请成功，请耐心等待。（如有问题请致电佰医汇客服：400-631-9377）', '患者端-远程影像申请成功', 'SMS_174025740', 3, NULL),
	(124, '2019-11-08', '14:59', NULL, 1, NULL, NULL, NULL, '患者端-接受远程影像邀请', 'SMS_174025743', '您好，您已经接受来自${doctorName}医生的影像诊断邀请，请于${date}进行诊断。（如有问题请致电佰医汇客服：400-631-9377）', '患者端-接受远程影像邀请', 'SMS_174025743', 3, NULL),
	(125, '2019-11-08', '14:59', NULL, 1, NULL, NULL, NULL, '患者端-远程影像取消通知', 'SMS_174020702', '您好，您的影像诊断申请已取消。请及时登录佰医汇平台查看确认。（如有问题请致电佰医汇客服：400-631-9377）', '患者端-远程影像取消通知', 'SMS_174020702', 3, NULL),
	(132, '2019-10-17', '13:53', NULL, 1, NULL, NULL, NULL, '医生端-登录验证码', 'SMS_175531595', '您的账号正在进行登录/重置密码校验，验证码${code}，10分钟内有效，请勿泄露于他人。', '医生端-登录验证码', 'SMS_206736973', 3, NULL),
	(133, '2019-10-17', '13:53', NULL, 1, NULL, NULL, NULL, '管理端-登录验证码', 'SMS_175531595', '您的账号正在进行登录/重置密码校验，验证码${code}，10分钟内有效，请勿泄露于他人。', '管理端-登录验证码', 'SMS_206736973', 3, NULL),
	(134, '2019-10-17', '13:53', NULL, 1, NULL, NULL, NULL, '超管端-登录验证码', 'SMS_175531595', '您的账号正在进行登录/重置密码校验，验证码${code}，10分钟内有效，请勿泄露于他人。', '超管端-登录验证码', 'SMS_206736973', 3, NULL),
	(135, '2019-10-17', '13:53', NULL, 1, NULL, NULL, NULL, '医药云-药师发货完成', 'SMS_175532330', '您好，您的处方订单已于${date}使用${expressname}发货啦！快递单号：${expressid}。', '医药云-药师发货完成', 'SMS_175532330', 3, NULL),
	(136, '2019-10-17', '13:53', NULL, 1, NULL, NULL, NULL, '医药云-药师审核未通过', 'SMS_175571571', '您好，您的处方订单审核未通过，可登陆佰医汇APP查看详情', '医药云-药师审核未通过', 'SMS_175571571', 3, NULL),
	(137, '2019-11-05', '17:32', NULL, 1, NULL, NULL, NULL, '远程会诊-提醒专家填写会诊报告', 'SMS_164155640', '您与患者${patientName}、${doctorName}医生的会诊已完成，请及时填写并提交会诊报告。', '远程会诊-提醒专家填写会诊报告', 'SMS_164155640', 3, NULL),
	(144, '2019-11-15', '13:46', NULL, 1, NULL, NULL, NULL, '健康管理-审核完成', 'jkgl_shwc', '您的健康管理订单已经完成审核，请查看服务详情，使用您购买的服务。', '健康管理-审核完成', 'SMS_184815793', 3, NULL),
	(145, '2019-11-15', '13:46', NULL, 1, NULL, NULL, NULL, '健康管理-支付成功', 'jkgl_zfcg', '您的健康管理订单已支付成功，请耐心等待审核通过，订单审核通过后，即可使用您购买的服务。', '健康管理-支付成功', 'SMS_184825735', 3, NULL),
	(146, '2019-11-15', '13:46', NULL, 1, NULL, NULL, NULL, '健康管理-申请退款', 'jkgl_sqtk', '您的健康管理订单已申请退款，请查看服务详情，等待管理员审核，审核完成后即可退款。', '健康管理-申请退款', 'SMS_184820764', 3, NULL),
	(147, '2019-11-15', '13:46', NULL, 1, NULL, NULL, NULL, '健康管理-订单过期', 'jkgl_ddgq', '您的健康管理订单已过期，请查看服务详情，如需再次申请，请重新下单。', '健康管理-订单过期', 'SMS_184830770', 3, NULL),
	(148, '2019-11-15', '13:46', NULL, 1, NULL, NULL, NULL, '健康管理-订单已退款', 'jkgl_ddytk', '您的健康管理订单已退款，请查看服务详情，如需再次申请，请重新下单。', '健康管理-订单已退款', 'SMS_184825736', 3, NULL),
	(149, '2019-11-15', '13:46', NULL, 1, NULL, NULL, NULL, '健康管理-订单已取消', 'jkgl_ddyqx', '您的健康管理订单已取消，请查看服务详情，如需再次申请，请重新下单。', '健康管理-订单已取消', 'SMS_184830771', 3, NULL),
	(150, '2019-11-15', '13:46', NULL, 1, NULL, NULL, NULL, '健康管理-订单待审核', 'jkgl_dddsh', '您有一个健康管理订单待审核，请查看订单详情。', '健康管理-订单待审核', 'SMS_184815796', 3, NULL),
	(151, '2019-11-15', '13:46', NULL, 1, NULL, NULL, NULL, '健康管理-退款申请发送', 'jkgl_tksqfs', '您的健康管理订单退款申请已发送，请查看订单详情，等待管理员审核。', '健康管理-退款申请发送', 'SMS_184830773', 3, NULL),
	(152, '2019-10-12', '10:00', NULL, 1, NULL, NULL, NULL, '名医绿通-匹配结果', 'SMS_175400014', '【佰医汇】您好，客服已向您推荐并确认匹配结果：${hospitalname}、科室-${departname}、医生-${doctorname}，运营人员正在努力协调资源，请您保持手机畅通，24小时内将致电反馈预约结果\n', '名医绿通-匹配结果', 'SMS_175400014', 3, NULL),
	(153, '2019-10-12', '10:00', NULL, 1, NULL, NULL, NULL, '名医绿通-住院确认', 'SMS_175400027', '【佰医汇】您好，已预约到${hospitalname}、科室-${departname}、医生-${doctorname}，请你于${date}准时入院就诊\n', '名医绿通-住院确认', 'SMS_177537393', 3, NULL),
	(154, '2019-10-12', '10:00', NULL, 1, NULL, NULL, NULL, '名医绿通-入院就诊', 'SMS_175400034', '【佰医汇】您好，您已完成入院就诊，2-3日内回访人员将致电向您了解健康状况以及服务满意度\n', '名医绿通-入院就诊', 'SMS_175400034', 3, NULL),
	(155, '2019-10-12', '10:00', NULL, 1, NULL, NULL, NULL, '名医绿通-患者回访', 'SMS_175405010', '【佰医汇】您好，回访人员已经致电咨询您的健康情况以及服务满意度，本次订单服务已完成，祝您身体健康', '名医绿通-患者回访', 'SMS_175405010', 3, NULL),
	(156, '2019-10-12', '10:00', NULL, 1, NULL, NULL, NULL, '名医绿通-快速面诊', 'SMS_175400002', '【佰医汇】您好，您的服务订单已生成，10分钟内客服将致电确认订单金额，确认并支付成功后您将可享受诊前提醒、诊中指导、诊后咨询等服务', '名医绿通-快速面诊', 'SMS_175400002', 3, NULL),
	(157, '2019-10-12', '10:00', NULL, 1, NULL, NULL, NULL, '名医绿通-预约挂号', 'SMS_175582286', '【佰医汇】您好，您的服务订单已经支付完成，客服将向您了解病情与就医需求，准确告知您需要就诊的医院与科室，并推荐合适的专家，请保持手机畅通', '名医绿通-预约挂号', 'SMS_175582286', 3, NULL),
	(158, '2019-11-08', '18:00', NULL, 1, NULL, NULL, NULL, '名医绿通-订单生成', 'mylt_ddsc', '您好，您的服务订单已生成，10分钟内客服将致电确认预约医生与订单金额，确认并支付成功后您将可享受预约挂号服务', '名医绿通-订单生成', 'SMS_176914608', 3, NULL),
	(159, '2019-11-08', '18:00', NULL, 1, NULL, NULL, NULL, '名医绿通-预约就诊', 'mylt_yyjz', '您好，已预约到${hospitalname}、科室-${departname}、医生-${doctorname}，请你于${date}准时入院就诊，本次订单服务已完成，祝您身体健康', '名医绿通-预约就诊', 'SMS_177542342', 3, NULL),
	(160, '2019-11-08', '18:00', NULL, 1, NULL, NULL, NULL, '名医绿通-医生接诊', 'mylt_ysjz', '您好，您的咨询订单已生成，10分钟内客服将致电确认预约医生与订单金额，确认并支付成功后将直接与医生交流', '名医绿通-医生接单', 'SMS_176929538', 3, NULL),
	(161, '2019-11-08', '18:00', NULL, 1, NULL, NULL, NULL, '名医绿通-专家确认', 'mylt_zjqr', '您好，客服已向您推荐并确认接诊专家：${hospitalname}、科室-${departname}、医生-${doctorname}，专家将于${date}与您联系，请耐心等待', '名医绿通-专家确认', 'SMS_176929945', 3, NULL),
	(162, '2019-11-08', '18:00', NULL, 1, NULL, NULL, NULL, '名医绿通-接诊完成', 'mylt_jzwc', '您好，接诊专家已经与您完成电话沟通，本次订单服务已完成，祝您身体健康', '名医绿通-接诊完成', 'SMS_176939676', 3, NULL),
	(232, '2019-10-12', '10:00', NULL, 0, NULL, NULL, NULL, '洛医通-名医绿通-匹配结果', 'SMS_175400014', '【佰医汇】您好，客服已向您推荐并确认匹配结果：${hospitalname}、科室-${departname}、医生-${doctorname}，运营人员正在努力协调资源，请您保持手机畅通，24小时内将致电反馈预约结果\n', '洛医通-名医绿通-匹配结果', 'SMS_176929041', 3, '333'),
	(233, '2019-10-12', '10:00', NULL, 0, NULL, NULL, NULL, '洛医通-名医绿通-住院确认', 'SMS_175400027', '【佰医汇】您好，运营人员已预约到${hospitalname}、科室-${departname}、医生-${doctorname}，请你于${date}准时入院就诊\n', '洛医通-名医绿通-住院确认', 'SMS_176944145', 3, '333'),
	(234, '2019-10-12', '10:00', NULL, 0, NULL, NULL, NULL, '洛医通-名医绿通-入院就诊', 'SMS_175400034', '【佰医汇】您好，您已完成入院就诊，2-3日内回访人员将致电向您了解健康状况以及服务满意度\n', '洛医通-名医绿通-入院就诊', 'SMS_176929044', 3, '333'),
	(235, '2019-10-12', '10:00', NULL, 0, NULL, NULL, NULL, '洛医通-名医绿通-患者回访', 'SMS_175405010', '【佰医汇】您好，回访人员已经致电咨询您的健康情况以及服务满意度，本次订单服务已完成，祝您身体健康', '洛医通-名医绿通-患者回访', 'SMS_176944146', 3, '333'),
	(236, '2019-10-17', '13:53', NULL, 0, NULL, NULL, NULL, '洛医通-医生端-登录验证码', 'SMS_175531595', '你的验证码是${code}，此验证码用于登录佰医/医生web端或重置密码，10分钟内有效。', '洛医通-医生端-登录验证码', 'SMS_205126655', 3, '333'),
	(237, '2019-10-17', '13:53', NULL, 0, NULL, NULL, NULL, '洛医通-管理端-登录验证码', 'SMS_175531595', '【佰医汇】你的验证码是${code}，此验证码用于登录佰医汇或重置密码。10 分钟内有效。', '洛医通-管理端-登录验证码', 'SMS_176914100', 3, '333'),
	(238, '2019-10-17', '13:53', NULL, 0, NULL, NULL, NULL, '洛医通-超管端-登录验证码', 'SMS_175531595', '【佰医汇】你的验证码是${code}，此验证码用于登录佰医汇或重置密码。10 分钟内有效。', '洛医通-超管端-登录验证码', 'SMS_176914100', 3, '333'),
	(239, '2019-10-17', '13:53', NULL, 0, NULL, NULL, NULL, '洛医通-医药云-药师发货完成', 'SMS_175532330', '您好，您的处方订单已于${date}使用${expressname}发货啦！快递单号：${expressid}。', '洛医通-医药云-药师发货完成', 'SMS_176939169', 3, '333'),
	(240, '2019-10-17', '13:53', NULL, 0, NULL, NULL, NULL, '洛医通-医药云-药师审核未通过', 'SMS_175571571', '您好，您的处方订单审核未通过，可登陆佰医汇APP查看详情', '洛医通-医药云-药师审核未通过', 'SMS_176939170', 3, '333'),
	(241, '2019-10-12', '10:00', NULL, 0, NULL, NULL, NULL, '洛医通-名医绿通-快速面诊', 'SMS_175400002', '【佰医汇】您好，您的服务订单已生成，10分钟内客服将致电确认订单金额，确认并支付成功后您将可享受诊前提醒、诊中指导、诊后咨询等服务', '洛医通-名医绿通-快速面诊', 'SMS_176944280', 3, '333'),
	(242, '2019-10-12', '10:00', NULL, 0, NULL, NULL, NULL, '洛医通-名医绿通-预约挂号', 'SMS_175582286', '【佰医汇】您好，您的服务订单已经支付完成，客服将向您了解病情与就医需求，准确告知您需要就诊的医院与科室，并推荐合适的专家，请保持手机畅通', '洛医通-名医绿通-预约挂号', 'SMS_176914224', 3, '333'),
	(243, '2019-11-08', '13:00', NULL, 0, NULL, NULL, NULL, '洛医通-名医绿通-订单生成', 'mylt_ddsc', '您好，您的服务订单已生成，10分钟内客服将致电确认预约医生与订单金额，确认并支付成功后您将可享受预约挂号服务', '洛医通-名医绿通-订单生成', 'SMS_176939870', 3, '333'),
	(244, '2019-11-08', '13:00', NULL, 0, NULL, NULL, NULL, '洛医通-名医绿通-预约就诊', 'mylt_yyjz', '您好，运营人员已预约到${hospitalname}、科室-${departname}、医生-${doctorname}，请你于${date}准时入院就诊，本次订单服务已完成，祝您身体健康', '洛医通-名医绿通-预约就诊', 'SMS_176944849', 3, '333'),
	(245, '2019-11-08', '13:00', NULL, 0, NULL, NULL, NULL, '洛医通-名医绿通-医生接诊', 'mylt_ysjz', '您好，您的咨询订单已生成，10分钟内客服将致电确认预约医生与订单金额，确认并支付成功后将直接与医生交流', '洛医通-名医绿通-医生接单', 'SMS_176914813', 3, '333'),
	(246, '2019-11-08', '13:00', NULL, 0, NULL, NULL, NULL, '洛医通-名医绿通-专家确认', 'mylt_zjqr', '您好，客服已向您推荐并确认接诊专家：${hospitalname}、科室-${departname}、医生-${doctorname}，专家将于${date}与您联系，请耐心等待', '洛医通-名医绿通-专家确认', 'SMS_176914814', 3, '333'),
	(247, '2019-11-08', '13:00', NULL, 0, NULL, NULL, NULL, '洛医通-名医绿通-接诊完成', 'mylt_jzwc', '您好，接诊专家已经与您完成电话沟通，本次订单服务已完成，祝您身体健康', '洛医通-名医绿通-接诊完成', 'SMS_176944854', 3, '333'),
	(248, '2019-11-15', '13:46', NULL, 0, NULL, NULL, NULL, '健康管理-审核完成', 'jkgl_shwc', '您的健康管理订单已经完成审核，请查看服务详情，使用您购买的服务。', '健康管理-审核完成', 'SMS_184815793', 3, '333'),
	(249, '2019-11-15', '13:46', NULL, 0, NULL, NULL, NULL, '健康管理-支付成功', 'jkgl_zfcg', '您的健康管理订单已支付成功，请耐心等待审核通过，订单审核通过后，即可使用您购买的服务。', '健康管理-支付成功', 'SMS_184825735', 3, '333'),
	(250, '2019-11-15', '13:46', NULL, 0, NULL, NULL, NULL, '健康管理-申请退款', 'jkgl_sqtk', '您的健康管理订单已申请退款，请查看服务详情，等待管理员审核，审核完成后即可退款。', '健康管理-申请退款', 'SMS_184820764', 3, '333'),
	(251, '2019-11-15', '13:46', NULL, 0, NULL, NULL, NULL, '健康管理-订单过期', 'jkgl_ddgq', '您的健康管理订单已过期，请查看服务详情，如需再次申请，请重新下单。', '健康管理-订单过期', 'SMS_184830770', 3, '333'),
	(252, '2019-11-15', '13:46', NULL, 0, NULL, NULL, NULL, '健康管理-订单已退款', 'jkgl_ddytk', '您的健康管理订单已退款，请查看服务详情，如需再次申请，请重新下单。', '健康管理-订单已退款', 'SMS_184825736', 3, '333'),
	(253, '2019-11-15', '13:46', NULL, 0, NULL, NULL, NULL, '健康管理-订单已取消', 'jkgl_ddyqx', '您的健康管理订单已取消，请查看服务详情，如需再次申请，请重新下单。', '健康管理-订单已取消', 'SMS_184830771', 3, '333'),
	(254, '2019-11-15', '13:46', NULL, 0, NULL, NULL, NULL, '健康管理-订单待审核', 'jkgl_dddsh', '您有一个健康管理订单待审核，请查看订单详情。', '健康管理-订单待审核', 'SMS_184815796', 3, '333'),
	(255, '2019-11-15', '13:46', NULL, 0, NULL, NULL, NULL, '健康管理-退款申请发送', 'jkgl_tksqfs', '您的健康管理订单退款申请已发送，请查看订单详情，等待管理员审核。', '健康管理-退款申请发送', 'SMS_184830773', 3, '333'),
	(256, '2019-12-21', '12:55', NULL, 0, NULL, NULL, NULL, '洛医通-找回密码', 'dz_back_pwd_authcode', '您找回密码的验证码是${authCode}，请在10分钟内输入，若非您操作请忽略。', '洛医通-找回密码', 'SMS_171851109', 3, '333'),
	(257, '2019-12-21', '12:55', NULL, 0, NULL, NULL, NULL, '洛医通-注册验证码', 'dz_reg_authcode', '您的注册验证码是${authCode}，请在10分钟内输入，若非您操作请忽略。', '洛医通-注册验证码', 'SMS_171856108', 3, '333'),
	(258, '2019-12-21', '12:55', NULL, 0, NULL, NULL, NULL, '洛医通-登录验证码', 'dz_miniProgram_login_authCode', '您登录的验证码是${authCode}，请在10分钟内输入，若非您本人操作请忽略。', '洛医通-登录验证码', 'SMS_171856089', 3, '333'),
	(259, '2019-12-21', '12:55', NULL, 0, NULL, NULL, NULL, '洛医通-专家上传报告通知', 'SMS_152289922', '${expertname}专家已完成会诊报告的填写，请您及时登录进行查看确认。', '洛医通-专家上传报告通知', 'SMS_180960961', 3, '333'),
	(260, '2019-12-23', '12:55', NULL, 0, NULL, NULL, NULL, '洛医通-取消会诊', 'SMS_155275066', '很抱歉，您有一个会诊申请已取消，原因：${reason}。', '洛医通-取消会诊', 'SMS_171856192', 3, '333'),
	(261, '2019-12-23', '14:46', NULL, 0, NULL, NULL, NULL, '洛医通-更换绑定手机', 'ty_ghbdsj', '您正在更换账户所绑定的手机号，验证码为${code}，请在十分钟内完成输入，若非您操作请忽略。', '洛医通-更换绑定手机', 'SMS_180956780', 3, '333'),
	(262, '2019-12-23', '14:48', NULL, 0, NULL, NULL, NULL, '洛医通-身份验证', 'ty_sfyz', '您正在进行身份验证，验证码为${code}，请在十分钟内完成输入，若非您操作请忽略。', '洛医通-身份验证', 'SMS_180956781', 3, '333'),
	(263, '2019-12-23', '15:36', NULL, 0, NULL, NULL, NULL, '洛医通-会诊申请成功', 'lyt_hzsqcg', '您好,${expertName}专家已接受您的申请，将于${date}与医生会诊，请耐心等待会诊结果。', '洛医通-会诊申请成功', 'SMS_180956856', 3, '333'),
	(264, '2019-12-23', '18:30', NULL, 0, NULL, NULL, NULL, '更换绑定手机', 'ty_ghbdsj', '您正在更换账户所绑定的手机号，验证码为${code}，请在十分钟内完成输入，若非您操作请忽略。', '更换绑定手机', 'SMS_180952121', 3, '333'),
	(265, '2019-12-23', '18:30', NULL, 0, NULL, NULL, NULL, '身份验证', 'ty_sfyz', '您正在进行身份验证，验证码为${code}，请在十分钟内完成输入，若非您操作请忽略。', '身份验证', 'SMS_206835011', 3, '333'),
	(266, '2019-12-26', '10:28', NULL, 0, NULL, NULL, NULL, '洛医通-会诊结束提醒查看会诊报告', 'SMS_153995162', '您好，医生与${expertname}专家会诊已结束，专家已完成会诊报告的填写，请前去查看和确认。', '洛医通-会诊结束提醒查看会诊报告', 'SMS_171856217', 3, '333'),
	(267, '2019-12-26', '10:49', NULL, 0, NULL, NULL, NULL, '洛医通-提醒专家填写会诊报告', 'SMS_164155640', '您与患者${patientName}、${doctorName}医生的会诊已完成，请及时填写并提交会诊报告。', '洛医通-提醒专家填写会诊报告', 'SMS_176912813', 3, '333'),
	(268, '2019-12-26', '11:58', NULL, 0, NULL, NULL, NULL, '洛医通-新申请消息', 'SMS_152213161', '患者${patientname}，性别${sex}，${age} 岁，向您发来一个会诊申请，邀请您帮忙申请并一同参与专家会诊，请立即处理。', '洛医通-新申请消息', 'SMS_181191908', 3, '333'),
	(269, '2019-12-26', '11:58', NULL, 0, NULL, NULL, NULL, '洛医通-视频会诊申请通知', 'SMS_152505111', '您有一个新的视频会诊申请，请登录佰医汇APP或官网及时处理。', '洛医通-视频会诊申请通知', 'SMS_181211868', 3, '333'),
	(270, '2019-12-26', '11:58', NULL, 0, NULL, NULL, NULL, '洛医通-入账通知', 'SMS_152208307', '您有一笔新的入账，共计${money}元，登录佰医汇APP点击账户管理查看入账详情。', '洛医通-入账通知', 'SMS_181196972', 3, '333'),
	(271, '2019-12-26', '11:58', NULL, 0, NULL, NULL, NULL, '洛医通-用户提交新申请', 'SMS_153995160', '您已成功向${doctorName}医生发送了会诊申请，请耐心等待医生回复。', '洛医通-用户提交新申请', 'SMS_181191914', 3, '333'),
	(272, '2019-12-31', '10:52', NULL, 0, NULL, NULL, NULL, '洛医通-签署会诊同意书', 'SMS_153990172', '您好，医生已接收到您的会诊申请，您有一个会诊申请知情同意书待签署，请前去佰医汇公众号签署。', '洛医通-签署会诊同意书', 'SMS_205126638', 3, '333'),
	(273, '2019-12-31', '10:52', NULL, 0, NULL, NULL, NULL, '洛医通-医生会诊支付', 'SMS_156465082', '您好，医生${doctorName}已帮您申请${expertName}专家会诊，请微信搜索“洛医通”小程序登录查看远程会诊。', '洛医通-医生会诊支付', 'SMS_205136622', 3, '333'),
	(274, '2019-12-21', '12:55', NULL, 0, NULL, NULL, NULL, '洛医通-web注册验证码', 'SMS_112470358', '验证码:${code}（10分钟有效）该验证码仅用于核实手机号码或密码找回，如非本人操作请忽略。', '洛医通-注册验证码', 'SMS_183790577', 3, '333'),
	(277, '2019-12-21', '12:55', NULL, 0, NULL, NULL, NULL, '佰医汇-问诊申请医生APP推送', 'SMS_182669503', '${name}患者向您发起了问诊，打开APP-在线咨询接待患者。', '佰医汇-问诊申请医生APP推送', 'SMS_184815294', 3, '333'),
	(278, '2020-02-01', '12:07', NULL, 0, NULL, NULL, NULL, '洛医通-问诊申请医生APP推送', 'SMS_182669503', '${name}患者向您发起了问诊，打开APP-在线咨询接待患者。', '洛医通-问诊申请医生APP推送', 'SMS_205136607', 3, '333'),
	(279, '2020-02-07', '20:03', NULL, 0, NULL, NULL, NULL, '中日友好-在线问诊医生通知', 'SMS_182669503', '${patientName}患者向您发起了问诊，点击中日远程医疗APP-在线咨询接待患者', '中日友好-在线问诊医生通知', 'SMS_183245553', 3, '333'),
	(280, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '医药云-处方审核未通过', 'yyy_cfshwtg', '您的电子处方审核未通过，请您前往app查看详情。', '医药云-处方审核未通过', 'SMS_184110584', 3, '333'),
	(281, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '医药云-处方审核通过', 'yyy_cfshtg', '您的处方已通过审核，请您前往app查看详情。', '医药云-处方审核通过', 'SMS_184110585', 3, '333'),
	(282, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '医药云-药师收到处方', 'yyy_yssdcf', '您有一个新的处方审核申请，请前往app查看详情。', '医药云-药师收到处方', 'SMS_184105660', 3, '333'),
	(283, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '医药云-患者选择自购', 'yyy_hzxzzg', '您选择了自购的配药方式，您可凭此电子处方到附近药房自行购药，您可前往小程序查看处方详情。', '医药云-患者选择自购', 'SMS_184115622', 3, '333'),
	(284, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '医药云-患者选择配送', 'yyy_hzxzps', '您选择了专员配送的配药方式，我们会尽快安排配送人员完成配送，请您耐心等待，您可前往小程序查看处方详情。', '医药云-患者选择配送', 'SMS_184115624', 3, '333'),
	(285, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '医药云-药品配送中(快递点)', 'yyy_yppszkdd', '您的药品配送员已经完成了药品配送，您可凭取货码${pickCode}前往${location}地方完成取药。配送员：${courierName}，电话：${phone}', '医药云-药品配送中(快递点)', 'SMS_184105663', 3, '333'),
	(286, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '医药云-配送完成', 'yyy_pswc', '您的药品配送已完成，收到药品后，请您仔细核对医生开具处方与所配药品是否一致。如有疑问请拨打客服：${hotline}', '医药云-配送完成', 'SMS_184120585', 3, '333'),
	(287, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '医药云-药方过期', 'yyy_yfgq', '您的电子处方已过期，您可前往小程序查看处方详情。', '医药云-药方过期', 'SMS_184120893', 3, '333'),
	(288, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '医药云-患者收到处方', 'yyy_hzsdcf', '您的电子处方已开具，请您前往小程序查看处方信息。', '医药云-患者收到处方', 'SMS_184110592', 3, '333'),
	(289, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '医药云-患者支付处方', 'yyy_hzzfcf', '您的药品已购买成功，您可以在小程序-我的药品中查看订单详情。', '医药云-患者支付处方', 'SMS_184105664', 3, '333'),
	(290, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '医药云-药品配送中(送货上门)', 'yyy_yppszshsm', '您的药品配送员正在将药品送到您手中，请您保持手机畅通，等待配送员与您联系。配送员：${courierName}，电话：${phone}', '医药云-药品配送中(送货上门)', 'SMS_184115668', 3, '333'),
	(293, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '洛医通-医药云-处方审核未通过', 'yyy_cfshwtg', '您的电子处方审核未通过，请您前往app查看详情。', '洛医通-医药云-处方审核未通过', 'SMS_184215134', 3, '333'),
	(294, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '洛医通-医药云-处方审核通过', 'yyy_cfshtg', '您的处方已通过审核，请您前往app查看详情。', '洛医通-医药云-处方审核通过', 'SMS_184210159', 3, '333'),
	(295, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '洛医通-医药云-药师收到处方', 'yyy_yssdcf', '您有一个新的处方审核申请，请前往app查看详情。', '洛医通-医药云-药师收到处方', 'SMS_184210161', 3, '333'),
	(296, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '洛医通-医药云-患者选择自购', 'yyy_hzxzzg', '您选择了自购的配药方式，您可凭此电子处方到附近药房自行购药，您可前往小程序查看处方详情。', '洛医通-医药云-患者选择自购', 'SMS_184210162', 3, '333'),
	(297, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '洛医通-医药云-患者选择配送', 'yyy_hzxzps', '您选择了专员配送的配药方式，我们会尽快安排配送人员完成配送，请您耐心等待，您可前往小程序查看处方详情。', '洛医通-医药云-患者选择配送', 'SMS_184220156', 3, '333'),
	(298, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '洛医通-医药云-药品配送中(快递点)', 'yyy_yppszkdd', '您的药品配送员已经完成了药品配送，您可凭取货码${pickCode}前往${location}地方完成取药。配送员：${courierName}，电话：${phone}', '洛医通-医药云-药品配送中(快递点)', 'SMS_184215136', 3, '333'),
	(299, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '洛医通-医药云-配送完成', 'yyy_pswc', '您的药品配送已完成，收到药品后，请您仔细核对医生开具处方与所配药品是否一致。如有疑问请拨打客服：${hotline}', '洛医通-医药云-配送完成', 'SMS_184220160', 3, '333'),
	(300, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '洛医通-医药云-药方过期', 'yyy_yfgq', '您的电子处方已过期，您可前往小程序查看处方详情。', '洛医通-医药云-药方过期', 'SMS_184205154', 3, '333'),
	(301, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '洛医通-医药云-患者收到处方', 'yyy_hzsdcf', '您的电子处方已开具，请您前往小程序查看处方信息。', '洛医通-医药云-患者收到处方', 'SMS_184205157', 3, '333'),
	(302, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '医洛医通-药云-患者支付处方', 'yyy_hzzfcf', '您的药品已购买成功，您可以在小程序-我的药品中查看订单详情。', '洛医通-医药云-患者支付处方', 'SMS_184205159', 3, '333'),
	(303, '2020-02-22', '15:27', NULL, 0, NULL, NULL, NULL, '洛医通-医药云-药品配送中(送货上门)', 'yyy_yppszshsm', '您的药品配送员正在将药品送到您手中，请您保持手机畅通，等待配送员与您联系。配送员：${courierName}，电话：${phone}', '洛医通-医药云-药品配送中(送货上门)', 'SMS_184205160', 3, '333'),
	(304, '2020-02-26', '16:10', NULL, 0, NULL, NULL, NULL, '新版在线问诊-十分钟未回复提醒', 'xzxwz_sfzwhftx', '${doctorName}医生正在等待您的回复，点击小程序-诊疗进行回复。', '新版在线问诊-十分钟未回复提醒', 'SMS_184221017', 3, '333'),
	(305, '2020-02-26', '16:10', NULL, 0, NULL, NULL, NULL, '新版在线问诊-两小时未回复提醒', 'xzxwz_lxswhftx', '${patientName}患者已经等待您的回复超过两小时，请您尽快点击佰医汇APP-在线问诊进行回复。', '新版在线问诊-两小时未回复提醒', 'SMS_184211041', 3, '333'),
	(306, '2020-02-26', '16:10', NULL, 0, NULL, NULL, NULL, '洛医通-新版在线问诊-十分钟未回复提醒', 'xzxwz_sfzwhftx', '${doctorName}医生正在等待您的回复，点击小程序-诊疗进行回复。', '洛医通-新版在线问诊-十分钟未回复提醒', 'SMS_184221060', 3, '333'),
	(307, '2020-02-26', '16:10', NULL, 0, NULL, NULL, NULL, '洛医通-新版在线问诊-两小时未回复提醒', 'xzxwz_lxswhftx', '${patientName}患者已经等待您的回复超过两小时，请您尽快点击佰医汇APP-在线问诊进行回复。', '洛医通-新版在线问诊-两小时未回复提醒', 'SMS_184211079', 3, '333'),
	(308, '2019-11-15', '13:55', NULL, 1, NULL, NULL, NULL, '洛医通-健康管理-审核完成', 'jkgl_shwc', '您的健康管理订单已经完成审核，请查看服务详情，使用您购买的服务。', '洛医通-健康管理-审核完成', 'SMS_184815788', 3, NULL),
	(309, '2019-11-15', '13:46', NULL, 1, NULL, NULL, NULL, '洛医通-健康管理-支付成功', 'jkgl_zfcg', '您的健康管理订单已支付成功，请耐心等待审核通过，订单审核通过后，即可使用您购买的服务。', '洛医通-健康管理-支付成功', 'SMS_184830767', 3, NULL),
	(310, '2020-04-14', '13:46', NULL, 1, NULL, NULL, NULL, '洛医通-健康管理-申请退款', 'jkgl_sqtk', '您的健康管理订单已申请退款，请查看服务详情，等待管理员审核，审核完成后即可退款。', '洛医通-健康管理-申请退款', 'SMS_184825729', 3, NULL),
	(311, '2019-11-15', '13:46', NULL, 1, NULL, NULL, NULL, '洛医通-健康管理-订单过期', 'jkgl_ddgq', '您的健康管理订单已过期，请查看服务详情，如需再次申请，请重新下单。', '洛医通-健康管理-订单过期', 'SMS_184830768', 3, NULL),
	(312, '2019-11-15', '13:46', NULL, 1, NULL, NULL, NULL, '洛医通-健康管理-订单已退款', 'jkgl_ddytk', '您的健康管理订单已退款，请查看服务详情，如需再次申请，请重新下单。', '洛医通-健康管理-订单已退款', 'SMS_184815791', 3, NULL),
	(313, '2019-11-15', '13:46', NULL, 1, NULL, NULL, NULL, '洛医通-健康管理-订单已取消', 'jkgl_ddyqx', '您的健康管理订单已取消，请查看服务详情，如需再次申请，请重新下单。', '洛医通-健康管理-订单已取消', 'SMS_184825731', 3, NULL),
	(314, '2019-11-15', '13:46', NULL, 1, NULL, NULL, NULL, '洛医通-健康管理-订单待审核', 'jkgl_dddsh', '您有一个健康管理订单待审核，请查看订单详情。', '洛医通-健康管理-订单待审核', 'SMS_184825733', 3, NULL),
	(315, '2019-11-15', '13:46', NULL, 1, NULL, NULL, NULL, '洛医通-健康管理-退款申请发送', 'jkgl_tksqfs', '您的健康管理订单退款申请已发送，请查看订单详情，等待管理员审核。', '洛医通-健康管理-退款申请发送', 'SMS_184815792', 3, NULL),
	(319, '2020-03-11', '10:56', NULL, 1, NULL, NULL, NULL, '佰医重置密码', 'czmm', '您的初始密码为${password}，请妥善管理您的密码。', '佰医重置密码', 'SMS_185811042', 3, '333'),
	(320, '2020-03-11', '10:56', NULL, 1, NULL, NULL, NULL, '洛阳重置密码', 'czmm', '您的初始密码为${password}，请妥善管理您的密码。', '洛医通-重置密码', 'SMS_185846059', 3, '333'),
	(321, '2020-04-07', '10:56', NULL, 1, NULL, NULL, NULL, '随访计划确认', 'sfjh_confirm', '您有待开始的随访计划需要确认，请您前往app查看详情。', '随访计划确认', 'SMS_187225625', NULL, NULL),
	(322, '2020-04-07', '09:10', NULL, 1, NULL, NULL, NULL, '随访计划开始', 'sfjh_start', '您的随访计划已开始，您可前往小程序/APP查看随访详情。', '随访计划开始', 'SMS_187270574', NULL, NULL),
	(323, '2020-04-07', '09:10', NULL, 1, NULL, NULL, NULL, '随访计划结束', 'sfjh_end', '您的随访计划已结束，请您前往小程序/APP查看随访详情。', '随访计划结束', 'SMS_187270577', NULL, NULL),
	(324, '2020-04-07', '09:10', NULL, 1, NULL, NULL, NULL, '洛医通-随访计划结束', 'sfjh_end', '您的随访计划已结束，请您前往小程序/APP查看随访详情。', '洛医通-随访计划结束', 'SMS_187240625', NULL, NULL),
	(325, '2020-04-07', '09:10', NULL, 1, NULL, NULL, NULL, '洛医通-随访计划开始', 'sfjh_start', '您的随访计划已开始，您可前往小程序/APP查看随访详情。', '洛医通-随访计划开始', 'SMS_187270636', NULL, NULL),
	(326, '2020-04-07', '09:10', NULL, 1, NULL, NULL, NULL, '洛医通-随访计划确认', 'sfjh_confirm', '您有待开始的随访计划需要确认，请您前往app查看详情。', '洛医通-随访计划确认', 'SMS_187260633', NULL, NULL),
	(327, '2020-04-07', '09:10', NULL, 1, NULL, NULL, NULL, '洛医通-随访表单待填写', 'sfbd_wait', '您有随访表单待填写，请您前往小程序/APP查看随访详情。', '洛医通-随访表单待填写', 'SMS_187465325', NULL, NULL),
	(328, '2020-04-07', '09:10', NULL, 1, NULL, NULL, NULL, '洛医通-健康宣教', 'jkxj', '您的健康宣教已推送，请您前往小程序/APP查看随访详情。', '洛医通-健康宣教', 'SMS_187242069', NULL, NULL),
	(329, '2020-04-07', '09:10', NULL, 1, NULL, NULL, NULL, '健康宣教', 'jkxj', '您的健康宣教已推送，请您前往小程序/APP查看随访详情。', '健康宣教', 'SMS_187465274', NULL, NULL),
	(330, '2020-04-07', '09:10', NULL, 1, NULL, NULL, NULL, '随访表单待填写', 'sfbd_wait', '您有随访表单待填写，请您前往小程序/APP查看随访详情。', '随访表单待填写', 'SMS_187460298', NULL, NULL),
	(331, '2020-04-09', '11:16', NULL, 1, NULL, NULL, NULL, 'EN_新待接诊订单', 'SMS_182669503', '${patientName} patient apply to you for consultation, please click “CJFH Telemedicine App\" App - online consultation to consult with the patient.', 'EN_新待接诊订单', 'SMS_187541365', 3, '333'),
	(332, '2020-04-09', '11:16', NULL, 1, NULL, NULL, NULL, 'EN_2小时未回复提醒', 'xzxwz_lxswhftx', '${patientName} patient has been waiting for your reply for more than two hours. Please click the CJFH Telemedicine App - Online revisit for reply as soon as possible. If the follow-up visit has been completed, please take the initiative to end the order.', 'EN_2小时未回复提醒', 'SMS_187571389', 3, '333'),
	(333, '2020-04-09', '11:16', NULL, 1, NULL, NULL, NULL, 'EN_10分钟未回复消息', 'xzxwz_sfzwhftx', 'Dr. ${doctorName} is waiting for you online, please enter the consulting room on your WeChat applet.', 'EN_10分钟未回复消息', 'SMS_187590958', 3, '333'),
	(335, '2020-04-14', '18:26', NULL, 1, NULL, NULL, NULL, '洛医通-随访计划提交', 'sfjh_submit', '您有患者已经提交随访计划，请您前往app查看详情。', '洛医通-随访计划提交', 'SMS_187930020', NULL, NULL),
	(336, '2020-04-14', '13:55', NULL, 1, NULL, NULL, NULL, '随访计划提交', 'sfjh_submit', '您有患者已经提交随访计划，请您前往app查看详情。', '随访计划提交', 'SMS_187930031', NULL, NULL),
	(337, '2020-04-14', '18:26', NULL, 1, NULL, NULL, NULL, '医药云-处方审核未通过', 'yyy_yscfshwtg', '您为患者${patientName}开具的处方经药师审核未通过，处方编号：${orderId}，请前往app电子处方中查看，并重新为患者开具处方。', '处方审核未通过', 'SMS_187935432', NULL, NULL),
	(338, '2020-04-14', '18:27', NULL, 1, NULL, NULL, NULL, '医药云-处方审核申请', 'yyy-cfshsq', '您有一个新的处方审核申请，请前往佰医app查看详情。', '药师收到处方', 'SMS_187950377', NULL, NULL),
	(339, '2019-11-15', '18:30', NULL, 1, NULL, NULL, NULL, '医药云-处方审核通过发送患者', 'yyy-cfshtgfsghz', '${doctorName}医生给您开具的的处方经药师审核通过，已发送给您，请前往小程序查看。', '处方审核通过发送患者', 'SMS_187940395', NULL, NULL),
	(340, '2020-04-14', '18:30', NULL, 1, NULL, NULL, NULL, '医药云-药师完成药品调配', 'yyy-yswcyptp', '${doctorName}医生给您开具的处方，药师已配药完成，请尽快前往医院药房进行取药，取药时请打开小程序出示电子处方，您也可以在电子处方中查看详细的取药信息。', '药师完成药品调配', 'SMS_187930447', NULL, NULL),
	(341, '2020-04-14', '18:30', NULL, 1, NULL, NULL, NULL, '医药云-患者到达医院取药', 'yyy-hzdyyqy', '${doctorName}医生给您开具的处方，已成功在药房完成取药 ，可在小程序电子处方中查看药品详细的用法用量；感谢您的配合希望您早日康复。', '患者到达医院取药', 'SMS_187935450', NULL, NULL),
	(342, '2020-04-14', '18:30', NULL, 1, NULL, NULL, NULL, '医药云-安排配送', 'yyy-apps', '${doctorName}医生给您开具的处方，药房已配药完成，即将为您安排配送，您可以前往小程序电子处方中持续关注运送详情。', '安排配送', 'SMS_187935455', NULL, NULL),
	(343, '2020-04-14', '18:28', NULL, 1, NULL, NULL, NULL, '医药云-患者签收货物', 'yyy-hzqshw', '${doctorName}医生给您开具的处方，已完成配送，收到药品后请您仔细核对，希望您早日康复。', '患者签收货物', 'SMS_187937161', NULL, NULL),
	(344, '2020-04-14', '18:27', NULL, 1, NULL, NULL, NULL, '医药云-选择取药方式', 'yyy-xzqyfs', '${doctorName}医生给您开具的处方，尚未选择取药方式，请尽快前往小程序-电子处方，在处方详情中选择取药方式。', '选择取药方式额外情况', 'SMS_187950456', NULL, NULL),
	(345, '2020-04-14', '18:27', NULL, 1, NULL, NULL, NULL, '医药云-患者申请退款', 'yyy-hzsqtk', '${doctorName}医生给您开具的处方已进行了退款，退款将在24小时内退回您的原支付账户请注意查收。', '患者申请退款', 'SMS_187935469', NULL, NULL),
	(346, '2020-04-22', '13:50:00', NULL, 1, '2020-04-22', '13:50:00', NULL, '登陆验证码', 'dz_miniProgram_login_authCode', 'your login verification code:${code}, please type in within 10 minutes.Please ignore if this is not your request.', '登陆验证码', 'SMS_188630889', NULL, NULL),
	(347, '2020-04-22', '13:50:00', NULL, 1, '2020-04-22', '13:50:00', NULL, '注册验证码', 'dz_reg_authcode', 'your registration verification code:${code}, please type in within 10 minutes. Please ignore if this is not your request.', '注册验证码', 'SMS_188635886', NULL, NULL),
	(348, '2020-04-22', '13:50:00', NULL, 1, '2020-04-22', '13:50:00', NULL, '身份验证', 'ty_sfyz', 'your authentication verification code:${code}, please type in within 10 minutes. Please ignore if this is not your request.', '身份验证', 'SMS_188640896', NULL, NULL),
	(349, '2020-04-22', '13:50:00', NULL, 1, '2020-04-22', '13:50:00', NULL, '找回密码验证码', 'dz_back_pwd_authcode', 'your authentication verification code:${code}, please type in within 10 minutes. Please ignore if this is not operated by yourself.', '找回密码验证码', 'SMS_188625903', NULL, NULL),
	(350, '2020-04-22', '13:50:00', NULL, 1, '2020-04-22', '13:50:00', NULL, '更换手机号验证码', 'ty_ghbdsj', 'You are changing the cellphone number linked to this account, the verification code is ${code}, please type in within 10mins, please ignore if this is not your request.', '更换手机号验证码', 'SMS_188640902', NULL, NULL),
	(351, '2020-04-22', '13:50:00', NULL, 1, '2020-04-22', '13:50:00', NULL, '10分钟未回复消息', 'hlzd_sfzwhftx', '${nurse}护士正在等待您的回复，点击小程序-诊疗进行回复。', '10分钟未回复消息', 'SMS_188626137', NULL, NULL),
	(352, '2020-04-22', '13:50:00', NULL, 1, '2020-04-22', '13:50:00', NULL, '2小时未回复提醒', 'hlzd_lxswhftx', '${nurse}护士已经等待您的回复超过两小时，请您尽快进行回复，若本次护理指导已完成请您主动结束订单。', '2小时未回复提醒', 'SMS_188636112', NULL, NULL),
	(353, '2020-04-22', '13:50:00', NULL, 1, '2020-04-22', '13:50:00', NULL, '患者候诊成功', 'xzxwz_hzhzcg', '${patientName}患者向您申请护理指导，点击医生APP-护理指导接待患者。', '患者候诊成功', 'SMS_188641145', NULL, NULL),
	(355, '2020-04-27', '11:27:00', NULL, 1, '2020-04-27', '11:27:00', NULL, '医药云-医生处方审核未通过', 'yyy_yscfshwtg', '您为${patientName}患者开具的处方经药师审核未通过，处方号：${orderId}，请前往HIS工作站重新为患者开具处方。', '医药云-处方审核未通过', 'SMS_189027430', NULL, NULL),
	(356, '2020-04-27', '11:27:00', NULL, 1, '2020-04-27', '11:27:00', NULL, '医药云-放心购药', 'yyy_hzfxgy', '${doctorName}医生给你开具的的处方经药师审核已通过，请前往小程序放心购药。', '医药云-放心购药', 'SMS_188992904', NULL, NULL),
	(357, '2020-04-27', '11:27:00', NULL, 1, '2020-04-27', '11:27:00', NULL, '医药云-安排配送', 'yyy_hzapps', '${name}医生给你开具的处方经药师审核已通过，医院药房将为您安排配送，药品货到付款，支持医保支付。', '医药云-安排配送', 'SMS_205392310', NULL, NULL),
	(358, '2020-04-27', '11:27:00', NULL, 1, '2020-04-27', '11:27:00', NULL, '医药云-窗口取药', 'yyy_hzckqy', '${name}医生给你开具的处方经药师审核已通过，请尽快前往中日友好医院院外药房${address}完成取药.', '医药云-窗口取药', 'SMS_205397338', NULL, NULL),
	(359, '2020-04-27', '11:27:00', NULL, 1, '2020-04-27', '11:27:00', NULL, '医药云-线下购药', 'yyy_hzxxgy', '${doctorName}医生给你开具的的处方经药师审核已通过，你可前往中日友好医院附近的东樱花药房线下购药。', '医药云-线下购药', 'SMS_188992925', NULL, NULL),
	(360, '2020-04-27', '11:27:00', NULL, 1, '2020-04-27', '11:27:00', NULL, '医药云-处方审核未通过', 'yyy_hzcfshwtg', '${doctorName}医生给你开具的的处方经药师审核未通过，请等待医生重新为您开具处方。如有疑问请拨打客服：${phoneNumber}。', '医药云-处方审核未通过', 'SMS_189027512', NULL, NULL),
	(361, '2020-04-27', '11:27:00', NULL, 1, '2020-04-27', '11:27:00', NULL, '医药云-药品支付成功', 'yyy_hzypzfcg', '您的药品已支付成功，药品将在1-3天内配送到家，偏远地区除外，如有疑问请拨打客服：${phoneNumber}。', '医药云-药品支付成功', 'SMS_189027515', NULL, NULL),
	(362, '2020-04-27', '11:27:00', NULL, 1, '2020-04-27', '11:27:00', NULL, '洛医通-医药云-药品支付成功', 'yyy_hzypzfcg', '您的药品已支付成功，药品将在1-3天内配送到家，偏远地区除外，如有疑问请拨打客服：${phoneNumber}。', '洛医通-医药云-药品支付成功', 'SMS_189017902', NULL, NULL),
	(363, '2020-04-27', '11:27:00', NULL, 1, '2020-04-27', '11:27:00', NULL, '洛医通-医药云-处方审核未通过', 'yyy_hzcfshwtg', '${doctorName}医生给你开具的的处方经药师审核未通过，请等待医生重新为您开具处方。如有疑问请拨打客服：${phoneNumber}。', '洛医通-医药云-处方审核未通过', 'SMS_189017897', NULL, NULL),
	(364, '2020-04-27', '11:27:00', NULL, 1, '2020-04-27', '11:27:00', NULL, '洛医通-医药云—线下购药', 'yyy_hzxxgy', '${doctorName}医生给你开具的的处方经药师审核已通过，你可前往中日友好医院附近的东樱花药房线下购药。', '洛医通-医药云—线下购药', 'SMS_189017895', NULL, NULL),
	(365, '2020-04-27', '11:27:00', NULL, 1, '2020-04-27', '11:27:00', NULL, '洛医通-医药云-窗口取药', 'yyy_hzckqy', '${doctorName}医生给你开具的处方经药师审核已通过，取药码：${code}，请尽快前往中日友好医院二楼送药到家窗口凭此取药码取药。', '洛医通-医药云-窗口取药', 'SMS_189027775', NULL, NULL),
	(366, '2020-04-27', '11:27:00', NULL, 1, '2020-04-27', '11:27:00', NULL, '洛医通-医药云-安排配送', 'yyy_hzapps', '${doctor}医生给你开具的处方经药师审核已通过，医院药房将为您安排配送，药品货到付款，支持医保支付。取药码：${code}，收到药品后请出示取药码，完成取药。', '洛医通-医药云-安排配送', 'SMS_189017888', NULL, NULL),
	(367, '2020-04-27', '11:27:00', NULL, 1, '2020-04-27', '11:27:00', NULL, '洛医通-医药云-医生处方审核未通过', 'yyy_hzapps', '您为${patientName}患者开具的处方经药师审核未通过，处方号：${orderId}，请前往HIS工作站重新为患者开具处方。', '洛医通-医药云-医生处方审核未通过', 'SMS_189017886', NULL, NULL),
	(368, '2020-05-06', '11:27:00', NULL, 1, '2020-05-06', '11:27:00', NULL, '医药云-患者端审核通过', 'yyy_hzshtg', '${doctorName}医生给你开具的的处方经${medical}审核已通过，请前往小程序放心购药。', '医药云-患者端审核通过', 'SMS_189622220', NULL, NULL),
	(369, '2020-05-06', '11:27:00', NULL, 1, '2020-05-06', '11:27:00', NULL, '医药云-患者取药', 'yyy_hzqy', '${doctorName}医生给你开具的处方经${medical}审核已通过，取药码：${fetchMedicalCode}，请尽快前往中日友好医院二楼送药到家窗口凭此取药码取药。', '医药云-患者取药', 'SMS_191802768', NULL, NULL),
	(370, '2020-05-22', '16:38:00', NULL, 1, '2020-05-22', '16:38:00', NULL, '名医宝-支付服务费用', 'myb_zffwfy', '您好，您的订单已生成，10分钟内客服将致电确认预约专家与订单金额，确认预约专家后您将可以支付服务费用。', '名医宝-支付服务费用', 'SMS_190792303', NULL, NULL),
	(371, '2020-05-22', '16:38:00', NULL, 1, '2020-05-22', '16:38:00', NULL, '名医宝-订单待处理', 'myb_dddcl', '您有新的${expert}订单待处理，订单号：${order}，请及时登录超管端查看处理订单。', '名医宝-订单待处理', 'SMS_191832160', NULL, NULL),
	(372, '2020-05-22', '16:38:00', NULL, 1, '2020-05-22', '16:38:00', NULL, '名医宝-联系客服', 'myb_lxkf', '您好，您已支付复诊费用，专家将按照预约时间前往医院进行坐诊，如有变动请及时联系客服', '名医宝-联系客服', 'SMS_190787444', NULL, NULL),
	(373, '2020-05-22', '16:38:00', NULL, 1, '2020-05-22', '16:38:00', NULL, '名医宝-确认预约专家', 'myb_qryyzj', '您好，客服已向您推荐并确认预约专家：医院-${hospitalName} 科室-${departName} 医生-${doctorName}，专家将于${time}到达出诊医院，请您及时支付出诊费用。', '名医宝-确认预约专家', 'SMS_190792455', NULL, NULL),
	(374, '2020-05-22', '16:38:00', NULL, 1, '2020-05-22', '16:38:00', NULL, '洛医通-名医宝-联系客服', 'myb_lxkf', '您好，您已支付复诊费用，专家将按照预约时间前往医院进行坐诊，如有变动请及时联系客服', '洛医通-名医宝-联系客服', 'SMS_190787510', NULL, NULL),
	(375, '2020-05-22', '16:38:00', NULL, 1, '2020-05-22', '16:38:00', NULL, '洛医通-名医宝-订单待处理', 'myb_dddcl', '您有新的${expert}订单待处理，订单号：${order}，请及时登录超管端查看处理订单。', '洛医通-名医宝-订单待处理', 'SMS_191832175', NULL, NULL),
	(376, '2020-05-22', '16:38:00', NULL, 1, '2020-05-22', '16:38:00', NULL, '洛医通-名医宝-支付服务费用', 'myb_zffwfy', '您好，您的订单已生成，10分钟内客服将致电确认预约专家与订单金额，确认预约专家后您将可以支付服务费用。', '洛医通-名医宝-支付服务费用', 'SMS_190787513', NULL, NULL),
	(377, '2020-05-22', '16:38:00', NULL, 1, '2020-05-22', '16:38:00', NULL, '洛医通-名医宝-确认预约专家', 'myb_qryyzj', '您好，客服已向您推荐并确认预约专家：医院-${hospitalName} 科室-${departName} 医生-${doctorName}，专家将于${time}到达出诊医院，请您及时支付出诊费用。', '洛医通-名医宝-确认预约专家', 'SMS_190792421', NULL, NULL),
	(378, '2020-05-29', '11:27:00', NULL, 1, '2020-05-29', '11:27:00', NULL, '医药云-完成支付', 'yyy_wczz', '您的药品已支付成功，药品将在1-3天内配送到家，偏远地区除外。如有疑问请拨打客服：${phone}。', '医药云-完成支付', 'SMS_205402322', NULL, NULL),
	(379, '2020-06-04', '11:27:00', NULL, 1, '2020-06-04', '11:27:00', NULL, '医药云-处方回退', 'yyy-cfht', '您为${patientName}患者开具的处方中包含特殊管理的药品:${medicalName}，不允许线上开具，处方已退回，处方号：${order}，请前往HIS工作站重新为患者开具处方。', '医药云-处方回退', 'SMS_192370706', NULL, NULL),
	(380, '2020-06-04', '11:27:00', NULL, 1, '2020-06-04', '11:27:00', NULL, '医药云-处方回退', 'yyy-cfht', '您为${patientName}患者开具的处方中包含特殊管理的药品:${medicalName}，不允许线上开具，处方已退回，处方号：${order}，请前往HIS工作站重新为患者开具处方。', '医药云-处方回退', 'SMS_192370706', NULL, NULL),
	(381, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '医药云-开具处方失败', 'yyy_kjcfsb', '您在HIS工作站${time}为${name}患者开具的处方未成功发送给患者，失败原因：您未在APP给患者开具处方。请在中日远程医疗APP开具处方后，再重新前往HIS工作站为患者补录处方。', '医药云-开具处方失败', 'SMS_195721899', NULL, NULL),
	(382, '2020-07-29', '11:27:00', NULL, 1, '2020-07-29', '11:27:00', NULL, '医药云-订单退款', 'yyy_ddtk', '您的药品订单已完成退款，您所支付的物流费用将会返回到您原有支付账户。', '医药云-订单退款', 'SMS_198345625', NULL, NULL),
	(384, '2020-10-27', '11:27:00', NULL, 1, '2020-10-27', '11:27:00', NULL, '缴费通知', 'jftz', '您的新特药：${drugName}已开具，请前往微信搜索小程序“南昌大学二附院”进行缴费。', '缴费通知', 'SMS_205400651', NULL, NULL),
	(385, '2020-11-04', '11:27:00', NULL, 1, '2020-11-04', '11:27:00', NULL, '在线咨询-开具复诊病例提醒', 'xzxwz-kjfzbltx', '您与${name}患者的复诊即将结束，请及时为患者开具复诊病例。', '在线咨询-开具复诊病例提醒', 'SMS_205408158', NULL, NULL),
	(386, '2020-11-04', '11:27:00', NULL, 1, '2020-11-04', '11:27:00', NULL, '在线咨询-开具诊疗意见提醒', 'xzxwz-kjzlyjtx', '您与${name}患者的咨询即将结束，请及时为患者开具诊疗意见。', '在线咨询-开具诊疗意见提醒', 'SMS_205403220', NULL, NULL),
	(387, '2020-11-04', '11:27:00', NULL, 1, '2020-11-04', '11:27:00', NULL, '洛医通-在线咨询-开具复诊病例提醒', 'xzxwz-kjfzbltx', '您与${name}患者的复诊即将结束，请及时为患者开具复诊病例。', '洛医通-在线咨询-开具复诊病例提醒', 'SMS_205393718', NULL, NULL),
	(388, '2020-11-04', '11:27:00', NULL, 1, '2020-11-04', '11:27:00', NULL, '洛医通-在线咨询-开具诊疗意见提醒', 'xzxwz-kjzlyjtx', '您与${name}患者的咨询即将结束，请及时为患者开具诊疗意见。', '洛医通-在线咨询-开具诊疗意见提醒', 'SMS_205408644', NULL, NULL),
	(389, NULL, NULL, NULL, 1, NULL, NULL, NULL, '南大二附院-药房取药', 'ndefy-yfqy', '您所开具的互联网医院药品：${medicalName}（新特），医生已为您开具药品处方，请扫描南昌大学第二附属医院互联网医院小程序“南昌大学二附院”二维码，在首页点击右下角“我的”里面的“电子处方”完成缴费。为了保障您的用药安全，请勿到其他药房购药，如到其他药房购药产生的安全问题自行负责，祝您早日康复！咨询热线${phone}。', '南大二附院-药房取药', 'SMS_205580769', NULL, NULL),
	(390, '2019-01-21', '18:14:53', NULL, 1, NULL, NULL, NULL, '南大二附院取药码', 'ndefy-qym', '您的取药码是：${fetchMedicalCode}，请在${storeName}取药时出示该码提取药品。祝您早日康复！咨询热线${phone}。', 'ndefy-qym', 'SMS_205617476', 3, NULL),
	(391, '2020-12-15', '18:14:53', NULL, 1, NULL, NULL, NULL, '南大二附院-撤销处方', 'ndefy-cxsb', '${presCode}处方撤销失败，如有问题请联系咨询热线${phone}。', '南大二附院-撤销处方', 'SMS_206835023', 3, NULL),
	(392, '2021-01-11', '18:14:53', NULL, 1, NULL, NULL, NULL, '医生停诊通知', 'hyt_ystz', '抱歉，您预约的${doctorName}停诊。就诊患者：${patientName}，预约时间：${time}，费用：未缴费，此次预约挂号自动退号，您可打开“航医通”小程序选择其他时间或医生重新挂号。给您带来不便敬请谅解！', '医生停诊通知', 'SMS_209171914', 3, NULL),
	(393, '2021-02-05', '18:14:53', NULL, 1, NULL, NULL, NULL, '支付中台支付通知', 'pay_der_authcode', '您好，您的${mchName}商户,于${endTime}时发生业务回调异常,业务单号${outTradeNo}，请尽快处理。', '支付中台支付通知', 'SMS_211485171', 3, NULL),
	(394, '2021-04-14', '18:53', NULL, 1, NULL, NULL, NULL, '航医通医患关系验证码', 'hyt_yhgxyzm', '您本次的验证码是${authCode}，请在10分钟内输入，若非您本人操作请忽略。', '航医通医患关系验证码', 'SMS_215350105', 3, NULL),
	(395, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '医药云-药师审核未通过', 'yyy-yssh', '您的处方未通过药师审核，请核对原因后重新开具处方。', '医药云-药师审核未通过', 'SMS_215820650', NULL, NULL),
	(396, '2021-05-21', '10:00:00', NULL, 1, NULL, NULL, NULL, '预约检查成功', 'yyjc', '尊敬的用户，您已为${patientName}成功预约${organName}机构的项目：${projectName}。请携带有效证件，于${subscribeTime}，前往${time}。', '预约检查成功通知', 'SMS_217416082', NULL, NULL),
	(397, NULL, NULL, NULL, 1, NULL, NULL, NULL, '订单退款通知', 'zxfz_tk', '您向${doctorName}医生申请的咨询/复诊订单已为您全额退款，请通过患者端-诊疗-聊天页面查看具体退款原因。', '订单退款通知', 'SMS_218033107', NULL, NULL),
	(398, NULL, NULL, NULL, 1, NULL, NULL, NULL, '药品发货通知', 'ypfhtz', '您的药品已发出，请收到包裹后仔细检查，如有问题，及时联系客服，祝您早日康复！', '药品发货通知', 'SMS_218024224', NULL, NULL),
	(399, NULL, NULL, NULL, 1, NULL, NULL, NULL, '护理照护退款通知', 'hlzh_refund', '您申请的护理照护服务已为您退款，点击患者端个人中心-护理照护查看退款状态及原因。', '护理照护退款通知', 'SMS_218155792', NULL, NULL),
	(400, NULL, NULL, NULL, 1, NULL, NULL, NULL, '预约检查成功(新院区)', 'new_yyjccg', '${name}先生/女士您好，您预约的普通胃镜/普通肠镜检查时间快到了，请安排好时间，在预约检查当日来院门诊楼2楼消化内镜中心，凭借预约二维码就诊检查，逾期作废。医院地址：苏州市平海路899号，如有问题请致电：0512-67973138，祝您生活愉快！', '预约检查成功(新院区)', 'SMS_218279969', NULL, NULL),
	(401, NULL, NULL, NULL, 1, NULL, NULL, NULL, '预约检查成功(老院区)', 'old_yyjccg', '${name}先生/女士您好，您预约的普通胃镜/普通肠镜检查时间快到了，请安排好时间，在预约检查当日来院门诊楼3楼消化内镜中心，凭借预约二维码就诊检查，逾期作废。医院地址：苏州市十梓街188号，如有问题请致电：0512-67780455，祝您生活愉快！', '预约检查成功(老院区)', 'SMS_218289794', NULL, NULL),
	(402, NULL, NULL, NULL, 1, NULL, NULL, NULL, '云医海棠图文会诊', 'yyht_twhz', '您有一个新的图文会议申请，请登录云医海棠APP或官网及时处理。', '云医海棠图文会诊', 'SMS_219748878', NULL, NULL),
	(403, NULL, NULL, NULL, 1, NULL, NULL, NULL, '云医海棠视频会诊', 'yyht_sphz', '您有一个新的视频会议申请，请登录云医海棠APP或官网及时处理。', '云医海棠视频会诊', 'SMS_219748880', NULL, NULL),
	(404, NULL, NULL, NULL, 1, NULL, NULL, NULL, '云医海棠预约时间', 'yyht_yysj', '您与患者${patientname}、医生${doctorname}的视频会议已到开始时间，请立即登录参加。', '云医海棠预约时间', 'SMS_219753749', NULL, NULL),
	(405, NULL, NULL, NULL, 1, NULL, NULL, NULL, '云医海棠会诊开始提醒', 'yyht_kstx', '您与患者${patientname}、专家${expertname}的视频会议已开始，请登录云医海棠APP或官网立即进入会议聊天室参与会议。', '云医海棠会诊开始提醒', 'SMS_219738958', NULL, NULL),
	(406, NULL, NULL, NULL, 1, NULL, NULL, NULL, '云医海棠结束会诊', 'yyht_jshz', '您与患者${patientName}、${doctorName}医生的会议已完成，请及时填写并提交会议报告。', '云医海棠结束会诊', 'SMS_219748883', NULL, NULL);






INSERT INTO `sysinfo-cloud`.`super_admin_user` (`id`, `login_name`, `nickname`, `password`, `viewId`, `token`, `role_type`, `mobile_number`, `status`, `update_time`, `create_time`)
VALUES
	(4, 'leiqihua', 'leiqihua', 'e10adc3949ba59abbe56e057f20f883e', 'leiqihua', 'eyJhbGciOiJIUzI1NiJ9.eyJqdGkiOiJzdXBlcl9hZG1pbl9sb2dpbmxlaXFpaHVhIiwiaWF0IjoxNjI5NDQ0MjQ1LCJzdWIiOiJ7XCJ1c2VySWRcIjpudWxsLFwiYWNjb3VudElkXCI6XCJsZWlxaWh1YVwiLFwidXNlclR5cGVcIjowLFwiYXBwQ29kZVwiOm51bGwsXCJjaGFubmVsQ29kZVwiOm51bGwsXCJkZXZpY2VudW1iZXJcIjpcImEwMzc4YjFmOWM4ODQ3MmRiNjYxYmQ3MGU4M2Q1NTRhXCIsXCJkZXZpY2VUeXBlXCI6bnVsbCxcImFjY291bnROb1wiOlwiMTgyOTE5NDUzMzJcIixcIm5hbWVcIjpcImxlaXFpaHVhXCIsXCJhY2NvdW50U3RhdHVzXCI6MCxcInJvbGVzXCI6bnVsbH0ifQ.EyteTFwDubcp5Vmki5QxgRYPfnrdqPyMmbWOArscMdE', 1, '18291945332', 1, '2021-08-20 15:24:05', '2019-03-12 11:52:37');


INSERT INTO `sysinfo-cloud`.`bp_role` (`id`, `role_name`, `is_default`, `status`, `view_id`, `create_time`, `update_time`)
VALUES
	(1, '超级管理员', 1, 1, '1573454667119791782', '2019-11-11 14:44:46', '2019-11-11 14:44:46');


INSERT INTO `sysinfo-cloud`.`bp_user_role` (`id`, `user_id`, `role_id`, `status`, `create_time`, `update_time`)
VALUES
	(4, '4', 1, 1, '2019-11-11 14:51:04', '2019-11-11 14:51:57');

INSERT INTO `sysinfo-cloud`.`bp_role_auth` (`id`, `auth_id`, `role_id`, `binding`, `status`, `create_time`, `update_time`)
VALUES
	(1, 1, 1, 1, 1, '2019-11-11 14:45:00', '2019-11-11 14:46:12'),
	(2, 2, 1, 1, 1, '2019-11-11 14:45:00', '2019-11-11 14:46:13'),
	(3, 3, 1, 1, 1, '2019-11-11 14:45:01', '2019-11-11 14:46:13'),
	(4, 4, 1, 1, 1, '2019-11-11 14:45:01', '2019-11-11 14:46:13'),
	(5, 5, 1, 1, 1, '2019-11-11 14:45:02', '2019-11-11 14:46:14'),
	(6, 6, 1, 1, 1, '2019-11-11 14:45:02', '2019-11-11 14:46:14'),
	(7, 7, 1, 1, 1, '2019-11-11 14:45:02', '2019-11-11 14:46:14'),
	(8, 8, 1, 1, 1, '2019-11-11 14:45:03', '2019-11-11 14:46:15'),
	(9, 9, 1, 1, 1, '2019-11-11 14:45:03', '2019-11-11 14:46:15'),
	(10, 10, 1, 1, 1, '2019-11-11 14:45:03', '2019-11-11 14:46:16'),
	(11, 11, 1, 1, 1, '2019-11-11 14:45:04', '2019-11-11 14:46:16'),
	(12, 12, 1, 1, 1, '2019-11-11 14:45:04', '2019-11-11 14:46:16'),
	(13, 13, 1, 1, 1, '2019-11-11 14:45:04', '2019-11-11 14:46:17'),
	(14, 14, 1, 1, 1, '2019-11-11 14:45:05', '2019-11-11 14:46:17'),
	(15, 15, 1, 1, 1, '2019-11-11 14:45:05', '2019-11-11 14:46:18'),
	(16, 16, 1, 1, 1, '2019-11-11 14:45:05', '2019-11-11 14:46:18'),
	(17, 17, 1, 1, 1, '2019-11-11 14:45:06', '2019-11-11 14:46:18'),
	(18, 18, 1, 1, 1, '2019-11-11 14:45:07', '2019-11-11 14:46:19'),
	(19, 19, 1, 1, 1, '2019-11-11 14:45:07', '2019-11-11 14:46:19'),
	(20, 20, 1, 1, 1, '2019-11-11 14:45:08', '2019-11-11 14:46:19'),
	(21, 21, 1, 1, 1, '2019-11-11 14:45:08', '2019-11-11 14:46:20'),
	(22, 22, 1, 1, 1, '2019-11-11 14:45:09', '2019-11-11 14:46:20'),
	(23, 23, 1, 1, 1, '2019-11-11 14:45:09', '2019-11-11 14:46:21'),
	(24, 24, 1, 1, 1, '2019-11-11 14:45:09', '2019-11-11 14:46:21'),
	(25, 25, 1, 1, 1, '2019-11-11 14:45:10', '2019-11-11 14:46:21'),
	(26, 26, 1, 1, 1, '2019-11-11 14:45:10', '2019-11-11 14:46:22'),
	(27, 27, 1, 1, 1, '2019-11-11 14:45:11', '2019-11-11 14:46:22'),
	(28, 28, 1, 1, 1, '2019-11-11 14:45:12', '2019-11-11 14:46:25'),
	(85, 29, 1, 1, 1, '2019-11-14 11:13:41', '2019-11-14 11:13:41'),
	(88, 30, 1, 1, 1, '2019-11-14 13:57:16', '2019-11-14 13:57:42'),
	(89, 31, 1, 1, 1, '2019-11-14 13:57:17', '2019-11-14 13:57:42'),
	(94, 32, 1, 1, 1, '2019-11-20 14:56:27', '2019-11-20 14:56:45'),
	(97, 33, 1, 1, 1, '2019-12-02 10:35:57', '2019-12-02 10:36:24'),
	(98, 34, 1, 1, 1, '2019-12-02 10:35:58', '2019-12-02 10:37:10'),
	(103, 36, 1, 1, 1, '2019-12-09 10:49:30', '2019-12-09 10:49:57'),
	(106, 37, 1, 1, 1, '2019-12-11 16:22:01', '2019-12-11 16:22:15'),
	(109, 38, 1, 1, 1, '2020-01-02 16:36:25', '2020-01-02 16:37:01'),
	(110, 39, 1, 1, 1, '2020-01-02 16:36:26', '2020-01-02 16:37:01'),
	(111, 40, 1, 1, 1, '2020-01-02 16:36:26', '2020-01-02 16:37:01'),
	(112, 41, 1, 1, 1, '2020-01-02 16:36:26', '2020-01-02 16:37:13'),
	(121, 42, 1, 1, 1, '2020-01-07 13:53:59', '2020-01-07 13:54:13'),
	(124, 43, 1, 1, 1, '2020-01-09 17:17:03', '2020-01-09 17:17:33'),
	(127, 44, 1, 1, 1, '2020-03-02 13:38:54', '2020-03-02 13:39:04'),
	(130, 45, 1, 1, 1, '2020-03-23 10:18:20', '2020-03-23 10:18:38'),
	(133, 46, 1, 1, 1, '2020-05-21 10:21:12', '2020-05-21 10:21:49'),
	(136, 47, 1, 1, 1, '2020-06-10 14:28:15', '2020-06-10 14:28:26'),
	(139, 48, 1, 1, 1, '2020-06-22 13:43:56', '2020-06-22 13:43:56'),
	(142, 49, 1, 1, 1, '2020-08-11 10:11:44', '2020-08-11 10:12:10'),
	(143, 50, 1, 1, 1, '2020-08-11 10:11:44', '2020-08-11 10:12:11'),
	(148, 51, 1, 1, 1, '2020-09-23 16:15:33', '2020-09-23 16:15:49');


INSERT INTO `sysinfo-cloud`.`bp_auth` (`id`, `auth_name`, `auth_level`, `path`, `parent_id`, `type`, `sort`, `auth_location`, `icon`, `status`, `view_id`, `create_time`, `update_time`)
VALUES
	(1, '就诊管理', 1, '/visit', 0, 1, 1, 1, '&#xe622;', 1, '1573452816994180146', '2019-11-11 14:14:10', '2019-11-11 15:00:11'),
	(2, '医生管理', 1, '/doctor', 0, 1, 2, 1, '&#xe639;', 1, '1573452860029978284', '2019-11-11 14:14:43', '2019-11-13 14:55:42'),
	(3, '数据管理', 1, '/data', 0, 1, 3, 1, '&#xe632;', 1, '1573452890726253601', '2019-11-11 14:15:12', '2019-11-19 13:51:21'),
	(4, '财务管理', 1, '/finance', 0, 1, 4, 1, '&#xe62c;', 1, '1573452921080472036', '2019-11-11 14:15:44', '2019-11-13 14:55:54'),
	(5, '配置信息', 1, '/configure', 0, 1, 5, 1, '&#xe638;', 1, '1573452949691142431', '2019-11-11 14:15:58', '2019-11-13 14:55:59'),
	(6, '运营数据', 1, '/businessData', 0, 1, 6, 1, '&#xe635;', 1, '1573452976826468878', '2019-11-11 14:17:12', '2019-12-09 10:48:11'),
	(7, '内容管理', 1, '/articles', 0, 1, 7, 1, '&#xe630;', 1, '1573453047826172138', '2019-11-11 14:17:48', '2019-11-13 14:56:11'),
	(8, '支付平台', 1, '/merchant', 0, 1, 8, 1, '&#xe63e;', 1, '1573453075620661517', '2019-11-11 14:18:28', '2019-11-13 14:56:17'),
	(9, '名医宝', 1, '/famous', 0, 1, 9, 1, '&#xe637;', 1, '1573453113450462744', '2019-11-11 14:18:58', '2019-11-13 14:56:20'),
	(10, '会诊订单', 2, '/visit/consultationOrder', 1, 2, 1, 1, '', 1, '1573453238066798835', '2019-11-11 14:21:12', '2019-11-11 14:21:12'),
	(11, '医生导入', 2, '/doctor/import', 2, 2, 2, 1, '', 1, '1573453325050213621', '2019-11-11 14:22:37', '2019-11-14 11:13:31'),
	(12, '会诊数据', 2, '/data/consultation', 3, 2, 1, 1, '', 1, '1573453363970758615', '2019-11-11 14:23:11', '2019-11-11 14:23:11'),
	(13, '提现审核', 2, '/finance/cashAudit', 4, 2, 1, 1, '', 1, '1573453397570901985', '2019-11-11 14:23:48', '2019-11-11 14:23:48'),
	(14, '医生收入', 2, '/finance/docInquiry', 4, 2, 2, 1, '', -1, '1573453431987334606', '2019-11-11 14:24:13', '2020-07-16 15:21:31'),
	(15, '账单管理', 2, '/finance/billList', 4, 2, 3, 1, '', 1, '1573453457968220236', '2019-11-11 14:24:39', '2019-11-11 14:24:39'),
	(16, '平台对账', 2, '/finance/platformreconciliationbatcnlist', 4, 2, 4, 1, '', 1, '1573453483298909843', '2019-11-11 14:25:05', '2019-11-11 14:25:05'),
	(17, '智慧就医对账', 2, '/finance/HISplatformreconciliationbatcnlist', 4, 2, 5, 1, '', 1, '1573453509677350507', '2019-11-11 14:25:35', '2019-11-11 14:25:35'),
	(18, '科室管理', 2, '/configure/department', 5, 2, 1, 1, '', 1, '1573453548707233192', '2019-11-11 14:36:05', '2019-11-11 14:36:32'),
	(19, '名医宝', 2, '/businessData/famousdoc', 6, 2, 1, 1, '', 1, '1573454362064464389', '2019-11-11 14:39:45', '2019-12-09 10:48:52'),
	(20, '文章管理', 2, '/articles/list', 7, 2, 1, 1, '', 1, '1573454406566049784', '2019-11-11 14:40:50', '2019-11-11 14:40:50'),
	(21, '商户管理', 2, '/merchant/merchantmannager', 8, 2, 1, 1, '', 1, '1573454454365448053', '2019-11-11 14:41:12', '2019-11-11 14:47:14'),
	(22, '支付渠道', 2, '/merchant/paychannel', 8, 2, 2, 1, '', 1, '1573454485718838130', '2019-11-11 14:41:45', '2019-11-11 14:47:28'),
	(23, '支付业务', 2, '/merchant/payment', 8, 2, 3, 1, '', 1, '1573454508697952294', '2019-11-11 14:41:56', '2019-11-11 14:47:37'),
	(24, '商户支付渠道', 2, '/merchant/merchantPayChannel', 8, 2, 4, 1, '', 1, '1573454530575493964', '2019-11-11 14:42:28', '2019-11-11 14:47:43'),
	(25, '支付账户', 2, '/merchant/paymentBills', 8, 2, 5, 1, '', 1, '1573454551830739139', '2019-11-11 14:42:50', '2019-11-11 14:47:44'),
	(26, '预约挂号', 2, '/famous/registration', 9, 2, 1, 1, '', 1, '1573454573668451634', '2019-11-11 14:43:18', '2019-12-09 10:47:56'),
	(27, '住院服务', 2, '/famous/inpatientService', 9, 2, 3, 1, '', 1, '1573454602904326518', '2019-11-11 14:43:41', '2019-11-14 13:55:36'),
	(28, '专家飞刀', 2, '/famous/expertflying', 9, 2, 4, 1, '', 1, '1573454625410800877', '2019-11-11 14:44:15', '2019-11-14 13:55:37'),
	(29, '医生管理', 2, '/doctor/info', 2, 2, 1, 1, '', 1, '1573701177355249596', '2019-11-14 11:13:19', '2019-12-25 18:37:10'),
	(30, '快速面诊', 2, '/famous/fastFaceConsolution', 9, 2, 2, 1, '', 1, '1573710735925358703', '2019-11-14 13:55:11', '2019-11-14 13:55:11'),
	(31, '电话咨询', 2, '/famous/teleConsulation', 9, 2, 5, 1, '', 1, '1573710773561367484', '2019-11-14 13:55:30', '2019-11-14 13:55:30'),
	(32, '分账管理', 2, '/finance/separatebill', 4, 2, 6, 1, '', 1, '1574232338300772756', '2019-11-20 14:46:13', '2019-11-20 14:46:13'),
	(33, '系统管理', 1, '/system', 0, 1, 10, 1, '&#xe608;', 1, '1575253996451013551', '2019-12-02 10:35:19', '2019-12-02 10:35:19'),
	(34, '版本管理', 2, '/system/version', 33, 2, 1, 1, '', 1, '1575254163806648688', '2019-12-02 10:35:48', '2019-12-02 10:35:48'),
	(36, '小程序指标', 2, '/businessData/smallProgram', 6, 2, 2, 1, '', 1, '', '2019-12-09 10:48:28', '2019-12-09 10:48:28'),
	(37, '线下推广数据', 2, '/extendData/list', 6, 2, 3, 1, '', 1, '', '2019-12-11 16:21:45', '2019-12-11 16:21:45'),
	(38, '诊疗平台', 1, '/consultingPlatform', 0, 1, 11, 1, '&#xe645;', 1, '1577670839794206893', '2019-12-30 09:53:53', '2019-12-30 11:27:41'),
	(39, '平台管理', 2, '/consultingPlatform/platformManagement', 38, 2, 1, 1, '', 1, '1577670853134599404', '2019-12-30 09:54:06', '2019-12-30 09:55:04'),
	(40, '医院管理', 1, '/hosManagament', 0, 1, 12, 1, '&#xe646;', 1, '1577677267030901205', '2019-12-30 11:40:34', '2019-12-30 11:41:38'),
	(41, '医院信息', 2, '/hosManagament/hosInfo', 40, 2, 1, 1, '', 1, '1577677275876279299', '2019-12-30 11:40:57', '2019-12-30 11:42:06'),
	(42, '评论管理', 2, '/articles/commentlist', 7, 2, 2, 1, '', 1, '', '2020-01-07 13:53:48', '2020-01-07 13:53:48'),
	(43, '评价管理', 2, '/data/evaluationManage', 3, 2, 2, 1, '', 1, '1578561287874148574', '2020-01-09 17:16:55', '2020-01-10 10:23:30'),
	(44, '意见反馈', 2, '/data/feedback', 3, 2, 3, 1, '', 1, '', '2020-03-02 13:38:47', '2020-03-02 13:38:47'),
	(45, '会诊分账', 2, '/finance/docIncome', 4, 2, 7, 1, '', 1, '', '2020-03-23 10:18:03', '2020-03-23 10:18:08'),
	(46, '专家出诊', 2, '/famous/expertVisit', 9, 2, 6, 1, '', 1, '', '2020-05-21 10:20:57', '2020-05-21 10:20:57'),
	(47, '意见反馈', 2, '/articles/feedback', 7, 2, 3, 1, '', 1, '', '2020-06-10 14:27:59', '2020-06-10 14:28:06'),
	(48, '推送管理', 2, '/system/pushList', 33, 2, 2, 1, '', 1, '', '2020-06-22 13:43:29', '2020-06-22 13:43:34'),
	(49, '云课堂', 1, '/cloudClassroom', 0, 1, 13, 1, '&#xe646;', 1, '', '2020-08-11 10:10:25', '2020-08-11 10:11:04'),
	(50, '课程管理', 2, '/cloudClassroom/index', 49, 2, 1, 1, '', 1, '', '2020-08-11 10:10:43', '2020-08-11 10:10:59'),
	(51, '操作日志', 2, '/data/operationLog', 33, 2, 3, 1, '', 1, '', '2020-09-23 16:15:08', '2021-08-17 16:05:45');


INSERT INTO `sysinfo-cloud`.`inquiry_medical_template` (`id`, `hospital_id`, `dept_id`, `title_content`, `keywords`, `input_type`, `title_type`, `title_type_content`, `title_type_limit`, `background_description`, `patient_hint`, `serv_type`, `is_null`, `is_his`, `is_edit`, `is_card`, `is_show`, `sort`, `unit_range`, `max_unit`, `min_unit`, `status`, `remark`, `version`, `create_time`, `update_time`)
VALUES
	('07a3e4a4e30e409eb252f32977ac0507', '0', NULL, '上传资料', 'uploadData', 3, 71, '', 0, '患者可手动上传与病情相关的资料', NULL, 2, -1, -1, -1, -1, 1, 5, NULL, NULL, NULL, 1, '', 0, '2020-05-11 19:56:43', '2020-06-17 18:27:11'),
	('10dd281654354781998c25756ba7e1a9', '0', NULL, '上次就诊医生', 'doctName', 2, 10, '', 0, NULL, '请填写上次就诊医生', 3, 1, -1, -1, 1, 1, 2, NULL, NULL, NULL, 1, '', 0, '2020-05-21 19:10:15', '2020-12-17 15:20:30'),
	('13d564bfb7d34eed8d82e7811d4fb7a5', '0', NULL, '患病时间', 'sickTime', 3, 80, '', NULL, '', '', 2, 1, -1, 1, -1, 1, 4, '标准', '', '', 1, NULL, NULL, '2020-05-20 15:26:28', '2020-08-14 18:49:18'),
	('150aab6910724059be783a2da7cd8524', '0', NULL, '用药史', 'medicationHistory', 3, 11, '', 0, '请填写用药史', '', 4, -1, -1, 1, -1, 1, 6, NULL, NULL, NULL, -1, '', 0, '2020-07-22 21:35:07', '2020-07-22 21:40:46'),
	('22d94919cb9b4904a9380c729116f867', '0', NULL, '初步诊断', 'primaryDiagno', 3, 11, '', 0, '请填写初步诊断', '', 4, 1, -1, 1, -1, 1, 3, NULL, NULL, NULL, 1, '', 0, '2020-07-22 21:35:07', '2020-07-22 21:35:07'),
	('27b9fbaad7cf47e0b286e769759a0d2b', '0', NULL, '会诊目的', 'consultAim', 1, 11, '', 0, '请填写会诊目的', '', 4, 1, -1, 1, 1, 1, 2, NULL, NULL, NULL, 1, '', 0, '2020-07-22 21:35:07', '2020-07-22 21:35:07'),
	('2aee994ba530422baeed1d6da91369ac', '0', NULL, '现病史', 'presentHistory', 3, 11, '', 0, '请填写现病史', '', 4, -1, -1, 1, -1, 1, 7, NULL, NULL, NULL, -1, '', 0, '2020-07-22 21:35:07', '2020-07-22 21:41:19'),
	('2b03b780db9148ad94831c959ba3acd1', '0', NULL, '患者姓名', 'patientName', 1, 12, '', 0, NULL, '记录患者的个人信息', 2, 1, -1, -1, -1, 1, 1, NULL, NULL, NULL, 1, '', 0, '2020-05-11 19:56:44', '2020-06-17 18:27:11'),
	('2b743aa9a8654790bec8651c9116f5c6', '0', NULL, '现病史', 'presentHistory', 3, 11, '', 0, '请填写现病史', '', 4, -1, -1, 1, -1, 1, 7, NULL, NULL, NULL, 1, '', 0, '2020-07-22 21:35:07', '2020-07-22 21:35:07'),
	('2c787d94645949af92e946a54cace6cf', '0', NULL, '影像资料', 'dcmFileUrl', 3, 101, '', 0, 'DICOM', '', 4, -1, -1, 1, -1, 1, 9, NULL, NULL, NULL, 1, '', 0, '2020-07-22 21:35:07', '2020-07-22 21:35:07'),
	('2e680c942d4f423093f9f5d18c1ab180', '0', NULL, '用药记录', 'redicalRecords', 3, 10, '', NULL, '', '', 2, -1, -1, 1, -1, 1, 5, '', '', '', -1, NULL, NULL, '2020-07-03 18:18:07', '2020-07-03 18:29:29'),
	('323a196623e645b88aa8cda9ba1c1c4c', '0', NULL, '病历资料', 'normalImages', 3, 71, '', 0, '请完整上传入院记录与病例附件', '', 4, 1, -1, 1, -1, 1, 8, NULL, NULL, NULL, 1, '', 0, '2020-07-22 21:35:07', '2021-07-27 14:52:57'),
	('35056c2daeaa4dd38db4e1d77aa568e6', '0', NULL, '患者年龄', 'patientAge', 1, 12, '', 0, NULL, '记录患者的个人信息', 2, 1, -1, -1, -1, 1, 3, NULL, NULL, NULL, 1, '', 0, '2020-05-11 19:56:43', '2020-06-17 18:27:11'),
	('3dd40f030a3b4e7da1ef62270bb5438a', '0', NULL, '患者性别', 'patientSex', 1, 12, '', 0, NULL, '记录患者的个人信息', 2, 1, -1, -1, -1, 1, 1, NULL, NULL, NULL, 1, '', 0, '2020-05-11 19:56:44', '2020-06-17 18:27:11'),
	('47688e1bc9784d30a2f2db7eed6c12ad', '0', NULL, '上次诊断结果', 'diagnose', 2, 11, '', 0, '供患者快速选择的疾病标签,可由后台配置', '请填写上次诊断结果', 3, 1, -1, 1, 1, 1, 5, NULL, NULL, NULL, 1, '', 0, '2020-05-21 19:10:15', '2020-12-17 15:23:06'),
	('4cf3bcb7e1034c78a8967c094bff17ba', '0', NULL, '病情描述', 'conditionDescription', 3, 11, '', 0, '患者填写关于病情的简要描述,以便与医生诊断', NULL, 2, 1, -1, -1, 1, 1, 3, NULL, NULL, NULL, 1, '', 0, '2020-05-11 19:56:44', '2020-06-17 18:27:11'),
	('54b2e415f71545888ce862f5037038ad', '0', NULL, '病历标签', 'medicalRecordLabel', 3, 50, '', 0, '供患者快速选择的疾病标签,可由后台配置', NULL, 2, -1, -1, 1, 1, -1, 2, NULL, NULL, NULL, 1, '', 0, '2020-05-11 19:56:43', '2020-07-17 11:45:50'),
	('619223bd0b6a4e7f8a695467e84b936a', '0', NULL, '用药史', 'medicationHistory', 3, 11, '', 0, '请填写用药史', '', 4, -1, -1, 1, -1, 1, 6, NULL, NULL, NULL, 1, '', 0, '2020-07-22 21:35:07', '2020-07-22 21:35:07'),
	('6585fca984a94666becebba71e62acfe', '0', NULL, '既往史', 'pastHistory', 3, 11, '', 0, '请填写病情主诉', '', 4, -1, -1, 1, -1, 1, 4, NULL, NULL, NULL, 1, '', 0, '2020-07-22 21:35:07', '2020-07-22 21:35:07'),
	('75ae04016fb9416fa76191aae90a090d', '0', NULL, '患者姓名', 'patientName', 1, 12, '', 0, NULL, '记录患者的个人信息', 3, 1, -1, -1, -1, 1, 1, NULL, NULL, NULL, 1, '', 0, '2020-05-21 19:10:15', '2020-06-17 18:27:11'),
	('7c7e6709e6d84e2e84bbd16156dd8c53', '0', NULL, '病案号', 'cardNo', 2, 10, NULL, NULL, NULL, '请填写病案号', 3, 1, -1, 1, 1, 1, 4, NULL, NULL, NULL, 1, NULL, 0, '2020-05-21 19:10:15', '2020-12-17 15:22:15'),
	('8617d32114294a60aaaedf3059baef3c', '0', NULL, '上次就诊时间', 'regDate', 2, 60, NULL, NULL, NULL, '请填写上次就诊时间', 3, 1, -1, 1, 1, 1, 3, NULL, NULL, NULL, 1, NULL, 0, '2020-05-21 19:10:15', '2020-12-17 15:24:27'),
	('891ca84721914a1183b0e514ebaead0f', '0', NULL, '上次就诊科室', 'deptName', 2, 10, '', 0, NULL, '请填写上次就诊科室', 3, 1, -1, -1, 1, 1, 1, NULL, NULL, NULL, 1, '', 0, '2020-05-21 19:10:15', '2020-12-17 15:26:53'),
	('98a276c475b74159b58c37210655ac64', '0', NULL, '患者年龄', 'patientAge', 1, 12, '', 0, NULL, '记录患者的个人信息', 3, 1, -1, -1, -1, 1, 3, NULL, NULL, NULL, 1, '', 0, '2020-05-21 19:10:15', '2020-06-17 18:27:11'),
	('9c92141522394f85a92c0e6410004bed', '0', NULL, '患者性别', 'patientSex', 1, 12, '', 0, NULL, '记录患者的个人信息', 3, 1, -1, -1, -1, 1, 2, NULL, NULL, NULL, 1, '', 0, '2020-05-21 19:10:15', '2020-06-17 18:27:11'),
	('a343b1b00b6449d38a7c4922eb6883d3', '0', NULL, '上传资料', 'uploadData', 3, 71, '', 0, '患者可手动上传与病情相关的资料', NULL, 3, -1, -1, -1, -1, 1, 3, NULL, NULL, NULL, 1, '', 0, '2020-05-21 19:10:15', '2020-06-17 18:27:11'),
	('aa2ebe62dbee4d72abb8093c09f9a228', '0', NULL, '病情主诉', 'mainSuit', 3, 11, '', 0, '请填写病情主诉', '', 4, 1, -1, -1, -1, 1, 2, NULL, NULL, NULL, 1, '', 0, '2020-07-22 21:35:07', '2020-07-22 21:35:07'),
	('aa64b92959c24e85946a97fc1726de50', '0', NULL, '会诊要求', 'yaoqoiu', 1, 41, '1|2', NULL, '', '', 4, 1, -1, 1, -1, 1, 2, '', '', '', -1, NULL, NULL, '2020-07-23 00:18:30', '2020-07-23 00:19:24'),
	('b10e7fe8fa744adb9ebe209c39e2b00d', '0', NULL, '家族史', 'familyHistory', 3, 11, '', 0, '请填写家族史', '', 4, -1, -1, 1, -1, 1, 5, NULL, NULL, NULL, 1, '', 0, '2020-07-22 21:35:07', '2020-07-22 21:35:07'),
	('b41d762b228140bfb5278e57b5b981d1', '0', NULL, '影像压缩包', 'dcmPackUrl', 3, 70, '', 0, '请上传影像压缩包', '', 4, -1, -1, 1, -1, 1, 10, NULL, NULL, NULL, 1, '', 0, '2020-07-22 21:35:07', '2020-08-20 13:52:32'),
	('b887053d50bf4032b008d83b6c8e52c1', '0', NULL, '既往史', 'pastHistory', 3, 11, '', 0, '请填写病情主诉', '', 4, -1, -1, 1, -1, 1, 4, NULL, NULL, NULL, 1, '', 0, '2020-07-22 21:35:07', '2020-07-22 21:35:07'),
	('c4bff26a03f3471ea898e6c578386110', '0', NULL, '影像资料', 'dcmFileUrl', 3, 101, '', 0, 'DICOM', '', 4, -1, -1, 1, -1, 1, 9, NULL, NULL, NULL, -1, '', 0, '2020-07-22 21:35:07', '2020-07-22 21:42:17'),
	('c83a8c3e981b41a084f4393f1db235ce', '0', NULL, '需要咨询的问题', 'question', 3, 11, '', 0, '供患者快速选择的咨询目的标签,可由后台配置', NULL, 2, 1, -1, 1, 1, 1, 2, NULL, NULL, NULL, -1, '', 0, '2020-05-21 19:10:15', '2020-06-17 18:27:11'),
	('c83a8c3e981b41a084f4393f1db885ce', '0', NULL, '需要咨询的问题', 'question', 3, 11, '', 0, '供患者快速选择的咨询目的标签,可由后台配置', NULL, 3, 1, -1, 1, 1, 1, 2, NULL, NULL, NULL, 1, '', 0, '2020-05-21 19:10:15', '2020-06-17 18:27:11'),
	('c881cd8887da4ffca6bbf568610178c1', '0', NULL, '家族史', 'familyHistory', 3, 11, '', 0, '请填写家族史', '', 4, -1, -1, 1, -1, 1, 5, NULL, NULL, NULL, -1, '', 0, '2020-07-22 21:35:07', '2020-07-22 21:42:09'),
	('ccc543fcd4c646c9b3fe369d1571e082', '0', NULL, '会诊目的', 'consultAim', 1, 11, '', 0, '请填写会诊目的', '', 4, 1, -1, 1, 1, 1, 2, NULL, NULL, NULL, -1, '', 0, '2020-07-22 21:35:07', '2020-07-22 21:42:08'),
	('cf9a9391d09440f298676f2a09059d66', '0', NULL, '影像压缩包', 'dcmPackUrl', 3, 70, '', 0, '请上传影像压缩包', '', 4, -1, -1, 1, -1, 1, 10, NULL, NULL, NULL, -1, '', 0, '2020-07-22 21:35:07', '2020-08-20 13:52:36'),
	('d54501a5a7724551be0b11da97d01f16', '0', NULL, '病历资料', 'normalImages', 3, 71, '', 0, '请完整上传入院记录与病例附件', '', 4, 1, -1, 1, -1, 1, 8, NULL, NULL, NULL, -1, '', 0, '2020-07-22 21:35:07', '2021-07-27 14:52:57'),
	('d7074129fad94e328714eafa8aff3f87', '0', NULL, '初步诊断', 'primaryDiagno', 3, 11, '', 0, '请填写初步诊断', '', 4, 1, -1, 1, -1, 1, 3, NULL, NULL, NULL, -1, '', 0, '2020-07-22 21:35:07', '2020-07-22 21:41:39'),
	('e73731b06b0a43209a33ee340c797233', '0', NULL, '用药记录', 'medicalRecords', 3, 10, '', NULL, '', '', 2, -1, -1, 1, -1, 1, 5, '', '', '', -1, NULL, NULL, '2020-07-03 18:32:04', '2020-07-03 18:32:33'),
	('eef09f6cf56040e5b063daf98f8d3a9c', '0', NULL, '病情描述', 'conditionDescription', 3, 11, '', 0, '患者填写关于病情的简要描述,以便与医生诊断', NULL, 3, 1, -1, -1, 1, 1, 1, NULL, NULL, NULL, 1, '', 0, '2020-05-21 19:10:15', '2020-06-17 18:27:11'),
	('f6f717c7a5d644d8aa0d07cf0d2c1615', '0', NULL, '病情主诉', 'mainSuit', 3, 11, '', 0, '请填写病情主诉', '', 4, 1, -1, -1, -1, 1, 2, NULL, NULL, NULL, -1, '', 0, '2020-07-22 21:35:07', '2020-07-22 21:41:36');



	INSERT INTO `cloud_doctoruser`.`uc_configuration` ( `app_code`, `type`, `client_code`, `create_time`, `update_time`, `status`)
VALUES
	('BYH', 'sms', '{\"clientCode\":\"EHOS_BY\",\"signCode\":{\"doctorCode\":\"BYH_BY\",\"patientCode\":\"BYH_BY\"}}', '2019-12-11 11:51:52', '2019-12-11 11:51:52', 1),
	( 'BYH', 'youmengPush', '[{\n		\"userType\": \"doctor\",\n		\"deviceType\": \"Android\",\n		\"clientCode\": \"BYH_YS_A\"\n	},\n	{\n		\"userType\": \"doctor\",\n		\"deviceType\": \"IOS\",\n		\"clientCode\": \"BYH_YS_I\"\n	},\n	{\n		\"userType\": \"patient\",\n		\"deviceType\": \"Android\",\n		\"clientCode\": \"BYH_DZ_A\"\n	},\n	{\n		\"userType\": \"patient\",\n		\"deviceType\": \"IOS\",\n		\"clientCode\": \"BYH_DZ_I\"\n	}\n]\n', '2019-12-11 11:51:52', '2019-12-11 11:51:52', 1),
	( 'BYH', 'weChatApplets', '{\"clientCode\":\"WX_CHDU\"}', '2019-12-19 14:04:52', '2019-12-19 14:04:58', 1);


INSERT INTO `cloud_doctoruser`.`bd_dictionary_type` (`id`, `type_name`, `type_code`, `create_time`, `update_time`)
VALUES
	(1, '性别', 'gender', '2019-01-23 00:00:00', '2019-01-23 00:00:00'),
	(2, '民族', 'ethnic', '2019-01-23 00:00:00', '2019-01-23 00:00:00'),
	(3, '国家', 'country', '2019-01-23 00:00:00', '2019-01-23 00:00:00'),
	(4, '省', 'province', '2019-01-23 00:00:00', '2019-01-23 00:00:00'),
	(5, '市', 'city', '2019-01-23 00:00:00', '2019-01-23 00:00:00'),
	(6, '区', 'district', '2019-01-23 00:00:00', '2019-01-23 00:00:00'),
	(7, '职业', 'profession', '2019-01-23 00:00:00', '2019-01-23 00:00:00'),
	(8, '渠道编码', 'channel', '2019-01-23 00:00:00', '2019-01-23 00:00:00'),
	(9, '婚姻状况', 'marriage', '2019-01-23 00:00:00', '2019-01-23 00:00:00'),
	(10, '证件类型', 'type_of_credentials', '2019-01-23 00:00:00', '2019-01-23 00:00:00'),
	(11, '远程角色类型', 'remote_role', '2019-01-23 00:00:00', '2019-01-23 00:00:00'),
	(13, '医院级别', '200', '2019-01-23 00:00:00', '2019-01-23 00:00:00'),
	(14, '管理类别', '300', '2019-01-23 00:00:00', '2019-01-23 00:00:00'),
	(15, '医生服务类型', '400', '2019-01-23 00:00:00', '2019-01-23 00:00:00'),
	(16, '转诊资料', '500', '2019-01-23 00:00:00', '2019-01-23 00:00:00'),
	(17, '麻醉种类', '600', '2019-01-23 00:00:00', '2019-01-23 00:00:00'),
	(18, '问题分类', '700', '2019-01-23 00:00:00', '2019-01-23 00:00:00'),
	(19, '产品分类', '800', '2019-01-23 00:00:00', '2019-01-23 00:00:00'),
	(21, '亲属关系', '1000', '2019-04-17 14:46:29', '2019-04-17 14:46:33'),
	(22, '会诊服务类型', '1100', '2019-04-17 15:03:53', '2019-04-17 15:03:57'),
	(23, '医联体类型', '1200', '2019-04-17 15:03:53', '2019-04-17 15:03:57'),
	(24, 'WS218国标类别大类', '1300', '2019-04-18 13:48:59', '2019-04-18 13:49:04'),
	(25, 'WS218国标类别中类', '1400', '2019-04-18 13:48:59', '2019-04-18 13:49:04'),
	(26, 'WS218国标类别小类', '1500', '2019-04-18 13:48:59', '2019-04-18 13:49:04'),
	(27, '热门城市', '900', '2019-04-22 10:53:17', '2019-04-22 10:53:21'),
	(30, '系统服务配置', '1800', '2020-01-07 11:30:00', '2020-01-07 11:30:00'),
	(36, '默认科室分类', '12600', '2020-04-27 17:32:00', '2020-04-27 17:32:00'),
	(49, '职业类型', '5000', '2020-05-12 04:21:00', '2020-05-12 04:21:00'),
	(50, '职称级别', '100', '2020-05-12 04:21:00', '2020-05-12 04:21:00'),
	(51, '黑名单业务配置', 'blacklist', '2020-12-25 09:46:09', '2020-12-25 09:46:14');

	INSERT INTO `cloud_doctoruser`.`bd_standard_department` (`id`, `display_name`, `english_name`, `short_name`, `icon_url`, `type`, `rel_dept_id`, `status`, `create_time`, `update_time`)
VALUES
	(1, '内科', 'Internal medicine', '内科', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2019/0/14/1547438456595_a6300219d14a472c80ee49c50bb9a52c.png', 1, 0, 1, '2019-01-10 13:34:29', '2020-04-29 10:11:56'),
	(2, '外科', 'surgical', '外科', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2019/0/14/1547438446570_39df1843ef66463ba655ae5300661eca.png', 1, 0, 1, '2019-01-10 13:34:29', '2020-04-29 10:14:14'),
	(3, '妇产科', 'Obstetrics and Gynecology', '妇儿科', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2019/0/14/1547438426074_f9e15ed061454d10b9a53476607ebff4.png', 1, 0, 1, '2019-01-10 13:34:29', '2020-04-29 10:14:22'),
	(4, '肿瘤科', 'Oncology', '肿瘤科', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2019/0/14/1547439031965_c34fe9c7f6954e5180c913c3be13eccd.png', 1, 0, 1, '2019-01-10 13:34:29', '2020-04-29 10:14:29'),
	(5, '综合科', 'Integrated Branch', '综合科', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2019/0/14/1547438891214_76ff22db14df4f758e1a5c91fbc0602b.png', 1, 0, 1, '2019-01-10 13:34:29', '2020-04-29 10:14:36'),
	(7, '骨科', 'orthopedics', '', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2019/0/14/1547438506878_a57e33331f994e3fbef6230aca80c66e.png', 1, 0, 1, '2019-01-14 12:01:48', '2020-04-29 10:14:42'),
	(9, '眼科', 'Ophthalmology', '', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2019/0/14/1547438526938_82f81065f4314e24b4e9c66c32327128.png', 1, 0, 1, '2019-01-14 12:02:08', '2020-04-29 10:15:40'),
	(11, '五官科', 'Facial features', '', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2019/0/14/1547438543361_4cc8e48603854ae295e54757b643c657.png', 1, 0, 1, '2019-01-14 12:02:25', '2020-04-29 10:15:47'),
	(13, '中医科', 'Chinese Medicine Department', '', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2019/0/14/1547438632179_c3f0759cb8e743f28f101fdd6fbf4670.png', 1, 0, 1, '2019-01-14 12:03:53', '2020-06-01 14:30:47'),
	(15, '康复科', 'recovery unit', '', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2019/0/14/1547438649316_993fbf2d551e48f9b8cc4aca94eefb77.png', 1, 0, 1, '2019-01-14 12:04:10', '2020-04-29 10:16:13'),
	(17, '皮肤性病科', 'Dermatology and Venereology', '', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2019/0/14/1547438704193_50f4e0757a6042ffb87164743d9fecc3.png', 1, 0, 1, '2019-01-14 12:05:07', '2020-04-29 10:16:19'),
	(21, '医疗美容科', 'Medical Aesthetic Department', '', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2019/0/14/1547438765347_cb74c997868a47c0b257099f631fbfa3.png', 1, 0, 1, '2019-01-14 12:06:06', '2020-04-29 10:16:25'),
	(23, '精神心理科', 'Department of Psychology', '', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2019/0/14/1547438960219_cf5e3bcf5bd54f9780b91b0f782d3c38.png', 1, 0, 1, '2019-01-14 12:06:54', '2020-04-29 10:16:33'),
	(25, '麻醉科', 'Anesthesiology', '', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2019/0/14/1547438840637_9a345924814e4cd48c6f8285ab544b11.png', 1, 0, 1, '2019-01-14 12:07:21', '2020-04-29 10:16:39'),
	(30, '远程会诊中心', 'Remote consultation center', '', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/15/1592205301651_7dbb3f24cea244f194605b8095a84e60.png', 1, 0, 1, '2019-03-29 16:39:34', '2020-06-15 15:15:52'),
	(10001, '儿童营养保健', '', '', '', 2, 10158, 1, '2019-01-10 13:34:39', '2020-01-17 10:06:17'),
	(10002, '骨科', '', '', '', 2, 7, 1, '2019-01-10 13:34:39', '2020-01-17 10:07:48'),
	(10003, '心血管内科', '', '', '', 2, 1, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10004, '泌尿外科', '', '', '', 2, 2, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10005, '神经外科', '', '', '', 2, 2, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10006, '神经内科', '', '', '', 2, 1, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10008, '普外科', '', '', '', 2, 2, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10009, '放射科', '', '', '', 2, 5, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10012, '胸外科', '', '', '', 2, 2, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10013, '皮肤科', '', '', '', 2, 17, 1, '2019-01-10 13:34:39', '2020-01-17 14:53:01'),
	(10015, '妇科', '', '', '', 2, 3, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10016, '耳鼻咽喉科', '', '', '', 2, 11, 1, '2019-01-10 13:34:39', '2020-01-17 10:11:18'),
	(10017, '变态反应科', '', '', '', 2, 10289, 1, '2019-01-10 13:34:39', '2020-01-17 10:13:20'),
	(10019, '眼科', '', '', '', 2, 9, 1, '2019-01-10 13:34:39', '2020-01-17 10:15:37'),
	(10021, '消化内科', '', '', '', 2, 1, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10022, '血液内科', '', '', '', 2, 1, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10023, '烧伤科', '', '', '', 2, 10291, 1, '2019-01-10 13:34:39', '2020-01-17 10:20:33'),
	(10024, '风湿免疫科', '', '', '', 2, 1, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10025, '头颈外科', '', '', '', 2, 11, 1, '2019-01-10 13:34:39', '2020-01-17 10:24:02'),
	(10028, '手外科', '', '', '', 2, 7, 1, '2019-01-10 13:34:39', '2020-01-17 13:58:44'),
	(10029, '内分泌科', '', '', '', 2, 1, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10030, '肾脏内科', '', '', '', 2, 1, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10031, '儿内科', '', '', '', 2, 10158, 1, '2019-01-10 13:34:39', '2020-01-17 10:25:49'),
	(10033, '心外科', '', '', '', 2, 2, 1, '2019-01-10 13:34:39', '2020-02-05 12:10:22'),
	(10034, '脊柱外科', '', '', '', 2, 7, 1, '2019-01-10 13:34:39', '2020-01-17 10:29:35'),
	(10036, '运动学科', '', '', '', 2, 2, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10037, '肿瘤科', '', '', '', 2, 4, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10038, '妇产科', '', '', '', 2, 3, 1, '2019-01-10 13:34:39', '2019-01-16 22:14:38'),
	(10039, '小儿普外科', '', '', '', 2, 10158, 1, '2019-01-10 13:34:39', '2020-01-17 14:01:34'),
	(10043, '口腔科', '', '', '', 2, 10209, 1, '2019-01-10 13:34:39', '2020-01-17 10:09:44'),
	(10044, '呼吸内科', '', '', '', 2, 1, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10045, '姑息关怀科', '', '', '', 2, 1, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10046, '血管外科', '', '', '', 2, 2, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10048, '乳腺科', '', '', '', 2, 2, 1, '2019-01-10 13:34:39', '2020-01-02 18:50:56'),
	(10049, '职业病科', '', '', '', 2, 5, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10050, '老年病科', '', '', '', 2, 10272, 1, '2019-01-10 13:34:39', '2020-01-17 10:11:11'),
	(10051, '整形外科', '', '', '', 2, 2, 1, '2019-01-10 13:34:39', '2020-01-02 16:08:04'),
	(10052, '疼痛科', '', '', '', 2, 25, 1, '2019-01-10 13:34:39', '2020-01-17 10:12:07'),
	(10053, '男科', '', '', '', 2, 10288, 1, '2019-01-10 13:34:39', '2020-01-17 10:12:58'),
	(10054, '传染科', '', '', '', 2, 1, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10055, '心理科', '', '', '', 2, 23, 1, '2019-01-10 13:34:39', '2020-01-02 19:18:57'),
	(10056, '生殖中心', '', '', '', 2, 3, 1, '2019-01-10 13:34:39', '2020-01-17 10:15:39'),
	(10057, '精神科', '', '', '', 2, 23, 1, '2019-01-10 13:34:39', '2020-01-17 14:09:09'),
	(10058, '康复科', '', '', '', 2, 15, 1, '2019-01-10 13:34:39', '2020-01-17 10:24:00'),
	(10059, '足踝外科', '', '', '', 2, 2, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10061, '麻醉科', '', '', '', 2, 25, 1, '2019-01-10 13:34:39', '2020-01-17 10:25:28'),
	(10062, '肛肠科', '', '', '', 2, 2, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10063, '骨质疏松科', '', '', '', 2, 7, 1, '2019-01-10 13:34:39', '2020-01-17 10:26:23'),
	(10065, '肝胆外科', '', '', '', 2, 2, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10066, '重症监护', '', '', '', 2, 10295, 1, '2019-01-10 13:34:39', '2020-01-17 10:27:23'),
	(10067, '感染科', '', '', '', 2, 1, 1, '2019-01-10 13:34:39', '2020-01-17 10:28:07'),
	(10068, '急诊科', '', '', '', 2, 10295, 1, '2019-01-10 13:34:39', '2020-01-17 10:31:15'),
	(10069, '超声科', '', '', '', 2, 10281, 1, '2019-01-10 13:34:39', '2020-01-17 14:25:56'),
	(10071, '药事部', '', '', '', 2, 10295, 1, '2019-01-10 13:34:39', '2020-01-17 14:29:21'),
	(10072, '全科', '', '', '', 2, 5, 1, '2019-01-10 13:34:39', '2019-01-10 13:34:39'),
	(10073, '儿科', '', '', '', 2, 10158, 1, '2019-01-16 22:15:58', '2020-01-17 10:33:46'),
	(10085, '普通内科', '', '', '', 2, 1, 1, '2019-01-16 22:18:12', '2019-01-16 22:18:15'),
	(10089, '病理科', '', '', '', 2, 10295, 1, '2019-01-16 22:19:01', '2020-01-17 10:35:03'),
	(10091, '医技科', '', '', '', 2, 10295, 1, '2019-01-16 22:19:11', '2020-01-17 10:35:43'),
	(10093, '体检中心', '', '', '', 2, 5, 1, '2019-01-16 22:19:22', '2020-01-03 18:27:51'),
	(10095, '营养科', '', '', '', 2, 5, 1, '2019-01-16 22:19:33', '2019-01-16 22:19:33'),
	(10097, '重症医学科', '', '', '', 2, 10295, 1, '2019-01-16 22:19:43', '2020-01-17 10:36:22'),
	(10099, '肠胃外科', '', '', '', 2, 2, 1, '2019-01-16 22:20:30', '2019-01-16 22:20:30'),
	(10105, '皮肤与医疗美容科', '', '', '', 2, 21, 1, '2019-01-16 22:23:13', '2020-01-02 19:06:24'),
	(10107, '中医科', '', '', '', 2, 13, 1, '2019-01-16 22:23:34', '2019-01-16 22:23:34'),
	(10109, '血液肿瘤科', '', '', '', 2, 4, 1, '2019-01-18 15:20:26', '2020-01-17 10:32:39'),
	(10111, '医务科', '', '', '', 2, 5, 1, '2019-01-18 15:20:56', '2019-01-18 15:20:56'),
	(10113, '综合科', '', '', '', 2, 5, 1, '2019-01-18 15:22:02', '2019-01-18 15:22:02'),
	(10115, '信息科', '', '', '', 2, 10295, 1, '2019-01-18 15:24:00', '2020-01-17 10:33:49'),
	(10117, '推拿针灸科', '', '', '', 2, 5, 1, '2019-01-18 15:26:12', '2019-01-18 15:26:12'),
	(10119, '其他', '', '', '', 2, 10295, 1, '2019-01-18 15:28:14', '2020-01-17 10:34:50'),
	(10120, '总院办', '', '', '', 2, 10295, 1, '2019-01-18 15:42:34', '2020-01-17 10:35:53'),
	(10123, '消化外科', '', '', '', 2, 2, 1, '2019-01-18 18:15:29', '2019-01-18 18:15:29'),
	(10124, '放疗科', '', '', '', 2, 5, 1, '2019-01-24 14:34:54', '2019-01-24 14:34:54'),
	(10125, '内科', '', '', '', 2, 1, 1, '2019-02-13 11:10:57', '2019-02-13 11:10:57'),
	(10126, '外科', '', '', '', 2, 2, 1, '2019-02-13 11:12:53', '2019-02-13 11:12:53'),
	(10128, '会诊中心', '', '', '', 2, 30, 1, '2019-03-29 16:39:47', '2019-03-29 16:39:47'),
	(10129, '影像科', '', '', '', 2, 5, 1, '2019-05-20 15:10:44', '2019-05-20 15:11:39'),
	(10133, '超声科', 'To be divided', '', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/15/1592205366336_c7313c80a183448192ea75b2debd7c1d.png', 1, 0, 1, '2019-07-18 15:55:53', '2020-06-15 15:16:57'),
	(10134, '超声科', '', NULL, NULL, 2, 10133, 1, '2019-07-18 15:56:10', '2020-06-01 11:28:35'),
	(10147, '脑外科', '', NULL, NULL, 2, 2, 1, '2019-09-20 10:32:04', '2019-09-20 10:32:04'),
	(10156, 'MDT联合门诊', '', '', '', 2, 5, 1, '2019-12-25 11:55:37', '2019-12-25 11:56:41'),
	(10158, '儿科', 'Pediatrics', '', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/15/1592205131859_5696a5d0bfa642d6a7083e064b6b71a8.png', 1, 0, 1, '2020-01-02 18:36:38', '2020-06-15 15:12:13'),
	(10160, '新生儿科', '', NULL, NULL, 2, 10158, 1, '2020-01-02 18:37:19', '2020-01-02 18:37:19'),
	(10161, '小儿皮肤科', '', NULL, NULL, 2, 10158, 1, '2020-01-02 18:37:47', '2020-01-02 18:37:47'),
	(10162, '小儿保健科', '', NULL, NULL, 2, 10158, 1, '2020-01-02 18:38:18', '2020-01-02 18:38:18'),
	(10163, '小儿呼吸内科', '', NULL, NULL, 2, 10158, 1, '2020-01-02 18:38:44', '2020-01-02 18:38:44'),
	(10164, '小儿骨科', '', NULL, NULL, 2, 10158, 1, '2020-01-02 18:39:02', '2020-01-02 18:39:02'),
	(10165, '小儿消化内科', '', NULL, NULL, 2, 10158, 1, '2020-01-02 18:39:31', '2020-01-02 18:39:31'),
	(10166, '小儿泌尿外科', '', NULL, NULL, 2, 10158, 1, '2020-01-02 18:39:54', '2020-01-02 18:39:54'),
	(10167, '小儿五官科', '', NULL, NULL, 2, 10158, 1, '2020-01-02 18:40:12', '2020-01-02 18:40:12'),
	(10168, '小儿心血管内科', '', NULL, NULL, 2, 10158, 1, '2020-01-02 18:40:32', '2020-01-02 18:40:32'),
	(10169, '小儿内科', '', NULL, NULL, 2, 10158, 1, '2020-01-02 18:40:45', '2020-01-02 18:40:45'),
	(10171, '小儿肾内科', '', NULL, NULL, 2, 10158, 1, '2020-01-02 18:41:25', '2020-01-02 18:41:25'),
	(10172, '小儿心外科', '', NULL, NULL, 2, 10158, 1, '2020-01-02 18:41:46', '2020-01-02 18:41:46'),
	(10173, '小儿血液科', '', NULL, NULL, 2, 10158, 1, '2020-01-02 18:42:05', '2020-01-02 18:42:05'),
	(10174, '小儿胸外科', '', NULL, NULL, 2, 10158, 1, '2020-01-02 18:42:27', '2020-01-02 18:42:27'),
	(10175, '小儿神经内科', '', NULL, NULL, 2, 10158, 1, '2020-01-02 18:42:47', '2020-01-02 18:42:47'),
	(10176, '小儿内分泌科', '', NULL, NULL, 2, 10158, 1, '2020-01-02 18:43:23', '2020-01-02 18:43:23'),
	(10177, '小儿感染科', '', NULL, NULL, 2, 10158, 1, '2020-01-02 18:43:41', '2020-01-02 18:43:41'),
	(10178, '小儿风湿免疫科', '', NULL, NULL, 2, 10158, 1, '2020-01-02 18:44:00', '2020-01-02 18:44:00'),
	(10179, '肝病科', '', NULL, NULL, 2, 1, 1, '2020-01-02 18:47:08', '2020-01-02 18:47:08'),
	(10180, '血液科', '', NULL, NULL, 2, 1, 1, '2020-01-02 18:47:36', '2020-01-02 18:47:36'),
	(10181, '结核病科', '', NULL, NULL, 2, 1, 1, '2020-01-02 18:48:39', '2020-01-02 18:48:39'),
	(10183, '血液透析室', '', NULL, NULL, 2, 1, 1, '2020-01-02 18:49:05', '2020-01-02 18:49:05'),
	(10184, '功能神经外科', '', NULL, NULL, 2, 2, 1, '2020-01-02 18:52:33', '2020-01-02 18:52:33'),
	(10185, '屈光中心', '', NULL, NULL, 2, 9, 1, '2020-01-02 18:54:01', '2020-01-02 18:54:01'),
	(10186, '眼底科', '', NULL, NULL, 2, 9, 1, '2020-01-02 18:54:15', '2020-01-02 18:54:15'),
	(10187, '角膜科', '', NULL, NULL, 2, 9, 1, '2020-01-02 18:54:27', '2020-01-02 18:54:27'),
	(10188, '青光眼', '', NULL, NULL, 2, 9, 1, '2020-01-02 18:54:40', '2020-01-02 18:54:40'),
	(10189, '白内障', '', NULL, NULL, 2, 9, 1, '2020-01-02 18:54:51', '2020-01-02 18:54:51'),
	(10190, '眼肌科', '', NULL, NULL, 2, 9, 1, '2020-01-02 18:55:01', '2020-01-02 18:55:01'),
	(10191, '眼外伤科', '', NULL, NULL, 2, 9, 1, '2020-01-02 18:55:16', '2020-01-02 18:55:16'),
	(10193, '眼整形科', '', NULL, NULL, 2, 9, 1, '2020-01-02 18:55:54', '2020-01-02 18:55:54'),
	(10194, '眼肿瘤科', '', NULL, NULL, 2, 9, 1, '2020-01-02 18:56:09', '2020-01-02 18:56:09'),
	(10196, '创伤骨科', '', NULL, NULL, 2, 7, 1, '2020-01-02 18:57:14', '2020-01-02 18:57:14'),
	(10197, '关节外科', '', NULL, NULL, 2, 7, 1, '2020-01-02 18:57:26', '2020-01-02 18:57:26'),
	(10198, '运动损伤', '', NULL, NULL, 2, 7, 1, '2020-01-02 18:57:46', '2020-01-02 18:57:46'),
	(10199, '矫形骨科', '', NULL, NULL, 2, 7, 1, '2020-01-02 18:57:57', '2020-01-02 18:57:57'),
	(10203, '产科', '', NULL, NULL, 2, 3, 1, '2020-01-02 18:59:43', '2020-01-02 18:59:43'),
	(10204, '生殖科', '', NULL, NULL, 2, 3, 1, '2020-01-02 19:00:04', '2020-01-15 14:38:04'),
	(10205, '妇科内分泌科', '', NULL, NULL, 2, 3, 1, '2020-01-02 19:00:19', '2020-01-02 19:00:19'),
	(10206, '妇科泌尿外科', '', NULL, NULL, 2, 3, 1, '2020-01-02 19:00:37', '2020-01-02 19:00:37'),
	(10207, '计划生育', '', NULL, NULL, 2, 3, 1, '2020-01-02 19:00:53', '2020-01-02 19:00:53'),
	(10208, '妇产保健科', '', NULL, NULL, 2, 3, 1, '2020-01-02 19:01:04', '2020-01-02 19:01:04'),
	(10209, '口腔科', 'Department of Stomatology', '', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/15/1592205493197_84f084ff03194806b5587410aa3bf9cf.png', 1, 0, 1, '2020-01-02 19:01:45', '2020-06-15 15:18:13'),
	(10211, '老年口腔科', '', NULL, NULL, 2, 10209, 1, '2020-01-02 19:02:14', '2020-01-02 19:02:14'),
	(10212, '牙体牙髓科', '', NULL, NULL, 2, 10209, 1, '2020-01-02 19:02:28', '2020-01-02 19:02:28'),
	(10213, '牙周科', '', NULL, NULL, 2, 10209, 1, '2020-01-02 19:02:39', '2020-01-02 19:02:39'),
	(10214, '口腔黏膜科', '', NULL, NULL, 2, 10209, 1, '2020-01-02 19:03:01', '2020-01-02 19:03:01'),
	(10215, '唾液腺', '', NULL, NULL, 2, 10209, 1, '2020-01-02 19:03:25', '2020-01-02 19:03:25'),
	(10216, '口腔修复科', '', NULL, NULL, 2, 10209, 1, '2020-01-02 19:03:39', '2020-01-02 19:03:39'),
	(10217, '正畸科', '', NULL, NULL, 2, 10209, 1, '2020-01-02 19:03:59', '2020-01-02 19:03:59'),
	(10218, '牙种植', '', NULL, NULL, 2, 10209, 1, '2020-01-02 19:04:10', '2020-01-02 19:04:10'),
	(10219, '口腔美容科', '', NULL, NULL, 2, 10209, 1, '2020-01-02 19:04:23', '2020-01-02 19:04:23'),
	(10220, '口腔肿瘤科', '', NULL, NULL, 2, 10209, 1, '2020-01-02 19:04:36', '2020-01-02 19:04:36'),
	(10221, '口腔急诊综合科', '', NULL, NULL, 2, 10209, 1, '2020-01-02 19:04:55', '2020-01-02 19:04:55'),
	(10222, '皮肤性病科', '', NULL, NULL, 2, 17, 1, '2020-01-02 19:05:35', '2020-01-02 19:05:35'),
	(10223, '性病科', '', NULL, NULL, 2, 17, 1, '2020-01-02 19:05:45', '2020-01-02 19:05:45'),
	(10224, '整形美容科', '', NULL, NULL, 2, 21, 1, '2020-01-02 19:06:48', '2020-01-02 19:06:48'),
	(10225, '胸部肿瘤', '', NULL, NULL, 2, 4, 1, '2020-01-02 19:07:09', '2020-01-02 19:07:09'),
	(10226, '消化肿瘤', '', NULL, NULL, 2, 4, 1, '2020-01-02 19:07:22', '2020-01-02 19:07:22'),
	(10227, '乳腺肿瘤', '', NULL, NULL, 2, 4, 1, '2020-01-02 19:07:35', '2020-01-02 19:07:35'),
	(10228, '血液肿瘤', '', NULL, NULL, 2, 4, 1, '2020-01-02 19:07:51', '2020-01-02 19:07:51'),
	(10229, '妇科肿瘤', '', NULL, NULL, 2, 4, 1, '2020-01-02 19:08:04', '2020-01-02 19:08:04'),
	(10230, '头颈肿瘤', '', NULL, NULL, 2, 4, 1, '2020-01-02 19:08:18', '2020-01-02 19:08:18'),
	(10231, '泌尿肿瘤', '', NULL, NULL, 2, 4, 1, '2020-01-02 19:08:37', '2020-01-02 19:08:37'),
	(10232, '肾癌黑色素瘤科', '', NULL, NULL, 2, 4, 1, '2020-01-02 19:09:06', '2020-01-02 19:09:06'),
	(10233, '骨肿瘤', '', NULL, NULL, 2, 4, 1, '2020-01-02 19:09:41', '2020-01-02 19:09:41'),
	(10234, '肿瘤内科', '', NULL, NULL, 2, 4, 1, '2020-01-02 19:09:58', '2020-01-02 19:09:58'),
	(10235, '肿瘤外科', '', NULL, NULL, 2, 4, 1, '2020-01-02 19:10:10', '2020-01-02 19:10:10'),
	(10236, '肿瘤放疗科', '', NULL, NULL, 2, 4, 1, '2020-01-02 19:10:59', '2020-01-02 19:10:59'),
	(10237, '肿瘤介入科', '', NULL, NULL, 2, 4, 1, '2020-01-02 19:11:13', '2020-01-02 19:11:13'),
	(10238, '肿瘤疼痛科', '', NULL, NULL, 2, 4, 1, '2020-01-02 19:11:33', '2020-01-02 19:11:33'),
	(10239, '肿瘤科其他', '', NULL, NULL, 2, 4, 1, '2020-01-02 19:11:58', '2020-01-02 19:11:58'),
	(10240, '中医儿科', '', NULL, NULL, 2, 13, 1, '2020-01-02 19:12:19', '2020-01-02 19:12:19'),
	(10241, '针灸科', '', NULL, NULL, 2, 13, 1, '2020-01-02 19:12:28', '2020-01-02 19:12:28'),
	(10242, '推拿科', '', NULL, NULL, 2, 13, 1, '2020-01-02 19:12:39', '2020-01-02 19:12:39'),
	(10243, '心神医学科', '', NULL, NULL, 2, 13, 1, '2020-01-02 19:12:58', '2020-01-02 19:12:58'),
	(10244, '中医妇科', '', NULL, NULL, 2, 13, 1, '2020-01-02 19:13:12', '2020-01-02 19:13:12'),
	(10245, '中医脾胃病科', '', NULL, NULL, 2, 13, 1, '2020-01-02 19:13:29', '2020-01-02 19:13:29'),
	(10246, '中医风湿病科', '', NULL, NULL, 2, 13, 1, '2020-01-02 19:13:45', '2020-01-02 19:13:45'),
	(10247, '中医肾病科', '', NULL, NULL, 2, 13, 1, '2020-01-02 19:14:41', '2020-01-02 19:14:41'),
	(10248, '中医心血管科', '', NULL, NULL, 2, 13, 1, '2020-01-02 19:14:55', '2020-01-02 19:14:55'),
	(10249, '中医呼吸科', '', NULL, NULL, 2, 13, 1, '2020-01-02 19:15:21', '2020-01-02 19:15:21'),
	(10250, '中医神经科', '', NULL, NULL, 2, 13, 1, '2020-01-02 19:15:33', '2020-01-02 19:15:33'),
	(10251, '中医内分泌科', '', NULL, NULL, 2, 13, 1, '2020-01-02 19:15:52', '2020-01-02 19:15:52'),
	(10252, '中医皮肤性病科', '', NULL, NULL, 2, 13, 1, '2020-01-02 19:16:15', '2020-01-02 19:16:15'),
	(10253, '中医肿瘤科', '', NULL, NULL, 2, 13, 1, '2020-01-02 19:16:27', '2020-01-02 19:16:27'),
	(10254, '中医乳腺科', '', NULL, NULL, 2, 13, 1, '2020-01-02 19:16:44', '2020-01-02 19:16:44'),
	(10255, '中医肝病科', '', NULL, NULL, 2, 13, 1, '2020-01-02 19:16:55', '2020-01-02 19:16:55'),
	(10256, '中医骨科', '', NULL, NULL, 2, 13, 1, '2020-01-02 19:17:07', '2020-01-02 19:17:07'),
	(10257, '中医男科', '', NULL, NULL, 2, 13, 1, '2020-01-02 19:17:17', '2020-01-02 19:17:17'),
	(10258, '耳鼻咽喉头颈外科', '', NULL, NULL, 2, 11, 1, '2020-01-02 19:18:06', '2020-01-02 19:18:06'),
	(10259, '鼻过敏科', '', NULL, NULL, 2, 11, 1, '2020-01-02 19:18:20', '2020-01-02 19:18:20'),
	(10261, '焦虑抑郁门诊', '', NULL, NULL, 2, 23, 1, '2020-01-02 19:19:25', '2020-01-02 19:19:25'),
	(10262, '记忆门诊', '', NULL, NULL, 2, 23, 1, '2020-01-02 19:19:36', '2020-01-02 19:19:36'),
	(10263, '慢病中心', '', NULL, NULL, 2, 5, 1, '2020-01-02 19:21:42', '2020-01-02 19:21:42'),
	(10264, '眩晕门诊', '', NULL, NULL, 2, 5, 1, '2020-01-02 19:21:55', '2020-01-02 19:21:55'),
	(10265, '发热门诊', '', NULL, NULL, 2, 5, 1, '2020-01-02 19:22:07', '2020-01-02 19:22:07'),
	(10266, '睡眠门诊', '', NULL, NULL, 2, 5, 1, '2020-01-02 19:22:18', '2020-01-02 19:22:18'),
	(10267, '全科医疗科', '', NULL, NULL, 2, 5, 1, '2020-01-02 19:22:50', '2020-01-02 19:22:50'),
	(10268, '中西药结合科', '', NULL, NULL, 2, 5, 1, '2020-01-02 19:23:06', '2020-01-02 19:23:06'),
	(10269, '高压氧科', '', NULL, NULL, 2, 5, 1, '2020-01-02 19:23:28', '2020-01-02 19:23:28'),
	(10271, '预防保健科', '', NULL, NULL, 2, 5, 1, '2020-01-02 19:24:01', '2020-01-02 19:24:01'),
	(10272, '老年病科', 'Geriatrics', '', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/15/1592205483047_0ed3ad40664d43bcb3e2d886634c150b.png', 1, 0, 1, '2020-01-02 19:24:50', '2020-06-15 15:18:51'),
	(10274, '老年精神科', '', NULL, NULL, 2, 10272, 1, '2020-01-02 19:25:17', '2020-01-02 19:25:17'),
	(10275, '介入科', 'Intervention', '', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/15/1592205503565_6edfa8e12a744e00b5e968091fe85748.png', 1, 0, 1, '2020-01-02 19:25:51', '2020-06-15 15:19:12'),
	(10276, '介入科', '', NULL, NULL, 2, 10275, 1, '2020-01-02 19:26:12', '2020-01-02 19:26:12'),
	(10277, '神经介入科', '', NULL, NULL, 2, 10275, 1, '2020-01-02 19:26:34', '2020-01-02 19:26:34'),
	(10278, '康复理疗科', '', NULL, NULL, 2, 15, 1, '2020-01-02 19:27:04', '2020-01-02 19:27:04'),
	(10279, '精神康复科', '', NULL, NULL, 2, 15, 1, '2020-01-02 19:27:17', '2020-01-02 19:27:17'),
	(10281, '医学影像科', 'medical imaging', '', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/15/1592205754673_0b16311b10f3485fb2d7cf5167141790.png', 1, 0, 1, '2020-01-02 19:28:04', '2020-06-15 15:23:23'),
	(10283, '医学影像科', '', NULL, NULL, 2, 10281, 1, '2020-01-02 19:28:34', '2020-01-02 19:28:34'),
	(10285, '核医学科', '', NULL, NULL, 2, 10281, 1, '2020-01-02 19:29:01', '2020-01-02 19:29:01'),
	(10286, '核磁共振室', '', NULL, NULL, 2, 10281, 1, '2020-01-02 19:29:21', '2020-01-02 19:29:21'),
	(10287, 'ECT门诊', '', NULL, NULL, 2, 10281, 1, '2020-01-02 19:29:36', '2020-01-02 19:29:36'),
	(10288, '男科', 'Andrology', '', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/15/1592205592439_021bc38f866c4cce821ddade40d23cbb.png', 1, 0, 1, '2020-01-02 19:29:56', '2020-06-15 15:19:52'),
	(10289, '变态反应科', 'Department of Allergy', '', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/15/1592205606764_0a369462d6fa4b15a84f3fc82f98f949.png', 1, 0, 1, '2020-01-02 19:30:19', '2020-06-15 15:20:07'),
	(10290, '变态反应', '', NULL, NULL, 2, 10289, 1, '2020-01-02 19:30:32', '2020-01-02 19:30:32'),
	(10291, '烧伤科', 'Burns Department', '', 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/15/1592205570729_ae9fa6e791284799b78f106b73c95005.png', 1, 0, 1, '2020-01-02 19:30:53', '2020-06-15 15:20:19'),
	(10293, '热带病科', '', NULL, 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/15/1592205584349_e51cb278d78448fab1087b80e5af114e.png', 1, NULL, 1, '2020-01-02 19:31:30', '2020-06-15 15:20:32'),
	(10295, '其它', 'other Department', '', 'https://tupian201805.oss-cn-beijing.aliyuncs.com/%E5%85%B6%E4%BB%96%E7%A7%91%E5%AE%A4.png', 1, 0, 1, '2020-01-02 19:32:14', '2020-04-29 10:18:12'),
	(10298, '职工门诊', '', NULL, NULL, 2, 10295, 1, '2020-01-02 19:33:06', '2020-01-02 19:33:06'),
	(10299, '护理咨询门诊', '', NULL, NULL, 2, 10295, 1, '2020-01-02 19:33:20', '2020-01-02 19:33:20'),
	(10301, '远程中心', '', NULL, 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/15/1592205958530_cb3c38c0bd414da0b6e4e09c8cadb856.png', 1, NULL, -1, '2020-02-13 21:25:38', '2020-06-15 15:25:59'),
	(10302, '国际部', 'International Department', NULL, 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/1/13/1581600382788_e2d9fe0fd04a41aebfa4155d6051883f.png', 1, 0, 1, '2020-02-13 21:26:27', '2020-05-11 20:36:10'),
	(10304, '医技', 'Medical technology', NULL, 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/1/13/1581600455411_387c99534522428cb6c062a9bd90156c.png', 1, 0, 1, '2020-02-13 21:27:39', '2020-05-11 20:35:14'),
	(10305, '保健医疗部', 'Department of health care', NULL, 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/15/1592205989292_05e20229d6654e0f97b253e40af90007.png', 1, 0, 1, '2020-02-13 21:28:26', '2020-06-15 15:26:33'),
	(10306, '国际部全科医学', '', NULL, NULL, 2, 10302, 1, '2020-02-13 21:28:48', '2020-02-13 21:28:48'),
	(10307, '远程中心', '', NULL, NULL, 2, 10301, 1, '2020-02-13 21:28:55', '2020-02-13 21:28:55'),
	(10308, '呼吸与危重症医学科', '', NULL, NULL, 2, 1, 1, '2020-02-13 21:30:48', '2020-02-13 21:30:48'),
	(10309, '烟草病学及戒烟中心', '', NULL, NULL, 2, 1, 1, '2020-02-13 21:31:16', '2020-02-13 21:31:16'),
	(10310, '心脏科', '', NULL, NULL, 2, 1, 1, '2020-02-13 21:32:09', '2020-02-13 21:32:09'),
	(10311, '儿科', '', NULL, NULL, 2, 1, 1, '2020-02-13 21:33:20', '2020-02-13 21:33:20'),
	(10312, '急诊科', '', NULL, NULL, 2, 1, 1, '2020-02-13 21:33:35', '2020-02-13 21:33:35'),
	(10313, '放射肿瘤科', '', NULL, NULL, 2, 1, 1, '2020-02-13 21:34:09', '2020-02-13 21:34:09'),
	(10314, '心脏血管外科', '', NULL, NULL, 2, 2, 1, '2020-02-13 21:35:58', '2020-02-13 21:35:58'),
	(10315, '疼痛科', '', NULL, NULL, 2, 2, 1, '2020-02-13 21:36:48', '2020-02-13 21:36:48'),
	(10316, '骨科', '', NULL, NULL, 2, 2, 1, '2020-02-13 21:37:15', '2020-02-13 21:37:15'),
	(10317, '妇产科', '', NULL, NULL, 2, 2, 1, '2020-02-13 21:37:37', '2020-02-13 21:37:37'),
	(10318, '眼科', '', NULL, NULL, 2, 2, 1, '2020-02-13 21:38:06', '2020-02-13 21:38:06'),
	(10319, '耳鼻喉科', '', NULL, NULL, 2, 2, 1, '2020-02-13 21:38:14', '2020-02-13 21:38:14'),
	(10320, '口腔医学中心', '', NULL, NULL, 2, 2, 1, '2020-02-13 21:38:29', '2020-02-13 21:38:29'),
	(10321, '皮肤科', '', NULL, NULL, 2, 2, 1, '2020-02-13 21:38:58', '2020-02-13 21:38:58'),
	(10322, '手术麻醉科', '', NULL, NULL, 2, 2, 1, '2020-02-13 21:39:08', '2020-02-13 21:39:08'),
	(10323, '外科重症医学科', '', NULL, NULL, 2, 2, 1, '2020-02-13 21:39:35', '2020-02-13 21:39:35'),
	(10324, '介入超声医学科', '', NULL, NULL, 2, 2, 1, '2020-02-13 21:39:42', '2020-02-13 21:39:42'),
	(10325, '中西医结合心脏内科', '', NULL, NULL, 2, 13, 1, '2020-02-13 21:43:07', '2020-02-13 21:43:07'),
	(10326, '中医肺病', '', NULL, NULL, 2, 13, 1, '2020-02-13 21:44:41', '2020-02-13 21:44:41'),
	(10327, '中医内分泌科', '', NULL, NULL, 2, 13, 1, '2020-02-13 21:50:09', '2020-02-13 21:50:09'),
	(10329, '中医外科', '', NULL, NULL, 2, 13, 1, '2020-02-13 21:50:58', '2020-02-13 21:50:58'),
	(10331, '肛肠科', '', NULL, NULL, 2, 13, 1, '2020-02-13 21:52:12', '2020-02-13 21:52:12'),
	(10332, '检验科', '', NULL, NULL, 2, 10304, 1, '2020-02-13 21:52:29', '2020-02-13 21:52:29'),
	(10333, '输血科', '', NULL, NULL, 2, 10304, 1, '2020-02-13 21:52:43', '2020-02-13 21:52:43'),
	(10334, '病理科', '', NULL, NULL, 2, 10304, 1, '2020-02-13 21:52:57', '2020-02-13 21:52:57'),
	(10335, '放射诊断科', '', NULL, NULL, 2, 10304, 1, '2020-02-13 21:53:10', '2020-02-13 21:53:10'),
	(10336, '核医学科', '', NULL, NULL, 2, 10304, 1, '2020-02-13 21:53:26', '2020-02-13 21:53:26'),
	(10337, '超声医学科', '', NULL, NULL, 2, 10304, 1, '2020-02-13 21:53:36', '2020-02-13 21:53:36'),
	(10338, '药学科', '', NULL, NULL, 2, 10304, 1, '2020-02-13 21:53:48', '2020-02-13 21:53:48'),
	(10339, '营养科', '', NULL, NULL, 2, 10304, 1, '2020-02-13 21:53:59', '2020-02-13 21:53:59'),
	(10340, '康复医学科', '', NULL, NULL, 2, 10304, 1, '2020-02-13 21:54:09', '2020-02-13 21:54:09'),
	(10341, '医疗美容科', '', NULL, NULL, 2, 10295, 1, '2020-02-13 21:55:05', '2020-02-13 21:55:05'),
	(10342, '美容外科', '', NULL, NULL, 2, 10295, 1, '2020-02-13 21:56:03', '2020-02-13 21:56:03'),
	(10343, '美容牙科', '', NULL, NULL, 2, 10295, 1, '2020-02-13 21:56:11', '2020-02-13 21:56:11'),
	(10344, '美容皮肤科', '', NULL, NULL, 2, 10295, 1, '2020-02-13 21:56:20', '2020-02-13 21:56:20'),
	(10345, '体检中心', '', NULL, NULL, 2, 10295, 1, '2020-02-13 21:56:41', '2020-02-13 21:56:41'),
	(10346, '心理咨询门诊', '', NULL, NULL, 2, 10295, 1, '2020-02-13 21:56:53', '2020-02-13 21:56:53'),
	(10347, '国家中医药管理局重点研究室', '', NULL, NULL, 2, 10295, 1, '2020-02-13 21:57:19', '2020-02-13 21:57:19'),
	(10348, '中心供应室', '', NULL, NULL, 2, 10295, 1, '2020-02-13 21:57:30', '2020-02-13 21:57:30'),
	(10349, '门诊护理单元', '', NULL, NULL, 2, 10295, 1, '2020-02-13 21:57:41', '2020-02-13 21:57:41'),
	(10350, '床位调配中心', '', NULL, NULL, 2, 10295, 1, '2020-02-13 21:57:52', '2020-02-13 21:57:52'),
	(10351, '中日医院药物临床试验研究中心', '', NULL, NULL, 2, 10295, 1, '2020-02-13 21:58:16', '2020-02-13 21:58:16'),
	(10352, '保健部', '', NULL, NULL, 2, 10305, 1, '2020-02-13 21:58:27', '2020-02-13 21:58:27'),
	(10354, '五官科', '', NULL, NULL, 2, 11, 1, '2020-02-17 15:21:45', '2020-02-17 15:21:45'),
	(10355, '全科医学科', '', NULL, NULL, 2, 1, 1, '2020-02-18 21:40:07', '2020-02-18 21:40:25'),
	(10356, '肾病风湿免疫科', '', NULL, NULL, 2, 1, 1, '2020-02-18 21:43:47', '2020-02-18 21:43:47'),
	(10357, '社区医疗科', '', NULL, NULL, 2, 1, 1, '2020-02-18 21:44:29', '2020-02-18 21:44:29'),
	(10367, '第二门诊部', '', NULL, 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/15/1592206003762_cfc4246878b34d2d969c5185bd1ba339.png', 1, NULL, 1, '2020-03-13 15:47:15', '2020-06-15 15:26:43'),
	(10368, '第二门诊部', '', NULL, NULL, 2, 10367, 1, '2020-03-13 15:48:08', '2020-03-13 15:48:08'),
	(10369, '疼痛科', '', NULL, 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/4/19/1589874368819_22ceabe8ffe141869dde118c8327b8c2.png', 1, NULL, 1, '2020-05-19 15:45:54', '2020-05-19 15:45:54'),
	(10370, '疼痛科', '', NULL, NULL, 2, 10369, 1, '2020-05-19 15:46:15', '2020-05-19 15:46:15'),
	(10371, '感染科', '', NULL, 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/1/1590982348943_ba05d92d9c9e4e98925699d0cbf8db23.png', 1, NULL, 1, '2020-06-01 11:32:10', '2020-06-01 11:32:10'),
	(10372, '营养科', '', NULL, NULL, 2, 1, 1, '2020-06-01 11:48:58', '2020-06-01 11:48:58'),
	(10373, '老年一科', '', NULL, NULL, 2, 1, 1, '2020-06-01 12:07:56', '2020-06-01 12:07:56'),
	(10374, '老年二科', '', NULL, NULL, 2, 1, 1, '2020-06-01 12:08:07', '2020-06-01 12:08:07'),
	(10376, '外周血管介入科', '', NULL, 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/1/1590993724413_528474f12c06405096ffacbe453be9f4.png', 1, NULL, 1, '2020-06-01 14:41:51', '2020-06-01 14:41:51'),
	(10377, '外周血管介入科', '', NULL, NULL, 2, 10376, 1, '2020-06-01 14:41:57', '2020-06-01 14:41:57'),
	(10378, '病理科', '', NULL, 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/1/1590994406180_4c502925a6cc4810a6aa3df18f835432.png', 1, NULL, 1, '2020-06-01 14:53:07', '2020-06-01 14:53:07'),
	(10379, '病理科', '', NULL, NULL, 2, 10378, 1, '2020-06-01 14:53:14', '2020-06-01 14:53:14'),
	(10380, '药剂科', '', NULL, 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/1/1590995637339_b9998d0bceb847ada567118b5cf136a4.png', 1, NULL, 1, '2020-06-01 15:13:44', '2020-06-01 15:13:44'),
	(10381, '药剂科', '', NULL, NULL, 2, 10380, 1, '2020-06-01 15:13:51', '2020-06-01 15:13:51'),
	(10382, '急诊科', '', NULL, 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/1/1590997501108_dab2077b1a7044cfbcc8f04592fba205.png', 1, NULL, 1, '2020-06-01 15:44:48', '2020-06-01 15:44:48'),
	(10383, '急诊科', '', NULL, NULL, 2, 10382, 1, '2020-06-01 15:47:56', '2020-06-01 15:47:56'),
	(10384, '感染科', '', NULL, NULL, 2, 10371, 1, '2020-06-01 16:22:26', '2020-06-01 16:22:26'),
	(10385, '健康管理部', '', NULL, 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/2/1591080668173_8cde8fc00a7843488654b5e8562ac580.png', 1, NULL, 1, '2020-06-02 14:50:49', '2020-06-02 14:50:49'),
	(10386, '健康管理部', '', NULL, NULL, 2, 10385, 1, '2020-06-02 14:51:00', '2020-06-02 14:51:00'),
	(10387, '体检化验结果解读门诊', '', NULL, NULL, 2, 10385, 1, '2020-06-02 14:51:23', '2020-06-02 14:51:23'),
	(10388, '永定路社区服务中心', '', NULL, 'http://tupian201805.oss-cn-beijing.aliyuncs.com/2020/5/2/1591080725332_cce2f1bcce2f42fe862e8dcf51adc1e3.png', 1, NULL, 1, '2020-06-02 14:51:46', '2020-06-02 14:51:46'),
	(10389, '永定路社区服务中心', '', NULL, NULL, 2, 10388, 1, '2020-06-02 14:51:58', '2020-06-02 14:51:58'),
	(10390, '老年心血管内科门诊', '', NULL, NULL, 2, 1, 1, '2020-06-20 13:25:33', '2020-06-20 13:25:33'),
	(10391, '冠心病', '', NULL, NULL, 2, 1, 1, '2020-06-23 13:56:49', '2020-06-23 13:56:49');


INSERT INTO `ehos_im`.`im_application` (`id`, `create_date_time`, `update_user`, `app_code`, `app_name`, `app_sdk_id`, `app_sdk_type`, `sys_admin`, `account_type`, `secret_id`, `secret_key`, `create_user`, `update_date_time`)
VALUES
	('1', '2019-02-11 17:29:05', NULL, 'EHOS_DOCTOR', '互联网医院医生端', '1400088738', 2, 'administrator', '26187', 'AKIDSnwteh1VAdw3yh7dpqeGgvypUwCrsflf', 'qUvAC261kKVoxxlOr15b4MSM7g4GHcrw', NULL, NULL),
	('2', '2019-02-11 17:29:05', NULL, 'EHOS_PATIENT', '互联网医院大众端', '1400088738', 2, 'administrator', '26187', 'AKIDSnwteh1VAdw3yh7dpqeGgvypUwCrsflf', 'qUvAC261kKVoxxlOr15b4MSM7g4GHcrw', NULL, NULL),
	('3', '2019-02-11 17:29:05', NULL, 'EHOS_ORG', '互联网医院机构端', '1400088738', 2, 'administrator', '26187', 'AKIDSnwteh1VAdw3yh7dpqeGgvypUwCrsflf', 'qUvAC261kKVoxxlOr15b4MSM7g4GHcrw', NULL, NULL),
	('4', '2019-02-11 17:29:05', NULL, 'EHOS_MANAGE', '互联网医院管理端', '1400088738', 2, 'administrator', '26187', 'AKIDSnwteh1VAdw3yh7dpqeGgvypUwCrsflf', 'qUvAC261kKVoxxlOr15b4MSM7g4GHcrw', NULL, NULL),
	('5', '2019-02-19 17:29:05', NULL, 'HYT_DOCTOR', '华医通医生端', '1400088738', 2, 'administrator', '26187', 'AKIDSnwteh1VAdw3yh7dpqeGgvypUwCrsflf', 'qUvAC261kKVoxxlOr15b4MSM7g4GHcrw', NULL, NULL),
	('6', '2019-02-19 17:29:05', NULL, 'HYT_PATIENT', '华医通大众端', '1400088738', 2, 'administrator', '26187', 'AKIDSnwteh1VAdw3yh7dpqeGgvypUwCrsflf', 'qUvAC261kKVoxxlOr15b4MSM7g4GHcrw', NULL, NULL),
	('7', '2019-02-19 17:29:05', NULL, 'YC_REMOTE', '远程平台', '1400088738', 2, 'administrator', '26187', 'AKIDSnwteh1VAdw3yh7dpqeGgvypUwCrsflf', 'qUvAC261kKVoxxlOr15b4MSM7g4GHcrw', NULL, NULL),
	('8', '2019-02-19 17:29:05', NULL, 'YD_DRUG', '健康站药店', '1400088738', 2, 'administrator', '26187', 'AKIDSnwteh1VAdw3yh7dpqeGgvypUwCrsflf', 'qUvAC261kKVoxxlOr15b4MSM7g4GHcrw', NULL, NULL);

INSERT INTO `ehos_im`.`im_busi_push_config` (`id`, `push_type`, `busi_code`, `domain`, `uri`, `params`, `method`, `media_type`, `status`, `enable_type`, `exchange`, `product_code`, `route_key`, `create_user`, `create_date_time`, `update_date_time`)
VALUES
	(1, 'transcode_to_mp4', 'ychz', NULL, NULL, NULL, NULL, '', 0, 'mq', 'ehos-video-topic', 'BYH_VIDEO', 'video.trtc', NULL, '2019-02-15 15:02:43', NULL),
	(2, NULL, 'ycjx', NULL, NULL, NULL, NULL, '', 0, 'mq', 'ehos-im-topic', 'BYH_VIDEO_YCJX', 'video.ycjx', NULL, '2019-02-15 15:02:43', NULL),
	(3, 'media_edit', 'ychy', NULL, NULL, NULL, NULL, '', 0, 'mq', 'ehos-im-topic', 'BYH_VIDEO_YCHY', 'video.ychy', NULL, '2019-10-23 14:32:43', NULL),
	(4, 'msg_interval_120_min', 'hlzd', 'https://ihos.chinachdu.com', '/nursingguidance/inform/seekMedicalAdvice', 'treatmentId,pushType', 'post', 'Json', 0, 'http', NULL, NULL, NULL, NULL, '2020-05-14 17:06:49', NULL),
	(5, 'msg_interval_10_min', 'hlzd', 'https://ihos.chinachdu.com', '/nursingguidance/inform/seekMedicalAdvice', 'treatmentId,pushType', 'post', 'Json', 0, 'http', NULL, NULL, NULL, NULL, '2020-05-14 17:06:54', NULL),
	(6, 'transcode_to_mp4', 'zxzx', 'https://ihos.chinachdu.com', '/netinquiry/admvideo/insertVideo', '', 'post', 'Json', 0, 'http', NULL, NULL, NULL, NULL, '2020-05-11 17:52:18', NULL),
	(7, 'wx_offline_3_min', 'hlzd', 'https://ihos.chinachdu.com', '/nursingguidance/inform/seekMedicalAdvice', 'treatmentId,pushType', 'post', 'Json', 0, 'http', NULL, NULL, NULL, NULL, '2020-05-14 10:24:42', NULL),
	(8, 'c2cToTest', 'im_test', 'https://testapi.chinachdu.com', '/imsys/test/save/c2c/callback', NULL, 'post', 'Json', 0, NULL, NULL, NULL, NULL, NULL, '2020-05-15 11:22:25', NULL),
	(9, 'mediaToTest', 'im_test', 'https://testapi.chinachdu.com', '/imsys/test/save/media/callback', NULL, 'post', 'Json', 0, NULL, NULL, NULL, NULL, NULL, '2020-05-15 11:26:09', NULL),
	(10, '0', 'zxzx', 'https://ihos.chinachdu.com', NULL, NULL, NULL, 'Json', 0, NULL, NULL, NULL, NULL, NULL, '2020-05-19 21:27:13', NULL),
	(11, '1', 'zxzx', NULL, NULL, NULL, NULL, 'Json', 0, NULL, NULL, NULL, NULL, NULL, '2020-05-19 21:30:45', NULL),
	(12, '2', 'zxzx', NULL, NULL, NULL, NULL, 'Json', 0, NULL, NULL, NULL, NULL, NULL, '2020-05-19 21:31:01', NULL),
	(13, 'transcodeToTest', 'im_test', 'https://testapi.chinachdu.com', '/imsys/media/process/tencent/callBack/processvideo', NULL, 'post', 'Json', 0, NULL, NULL, NULL, NULL, NULL, '2020-06-04 14:24:52', NULL),
	(14, 'transcode_to_mp4', 'ychz', NULL, NULL, NULL, NULL, 'Json', 0, 'mq', 'ehos-video-topic', 'BYH_VIDEO', 'video.trtc', NULL, '2020-07-28 11:43:00', NULL),
	(15, 'transcode_to_mp4', 'ycjx', NULL, NULL, NULL, NULL, 'Json', 0, 'mq', 'ehos-im-topic', 'BYH_VIDEO_YCJX', 'video.ycjx', NULL, '2020-07-28 11:49:26', NULL);

INSERT INTO `ehos_im`.`im_live_application` (`id`, `create_date_time`, `create_user`, `update_date_time`, `update_user`, `anti_theft_chain`, `api_key`, `app_id`, `biz_id`)
VALUES
	('1', '2019-04-08 19:51:23', NULL, NULL, NULL, '2ba9d43204ee2ed6568958e3942112b2', 'c109853afe60e0922f25042ed0b990c4', '1256351405', '26052');

INSERT INTO `ehos_im`.`im_product_type` (`id`, `create_date_time`, `create_user`, `update_date_time`, `update_user`, `enable_type`, `exchange`, `http_url`, `product_code`, `route_key`, `busi_code`)
VALUES
	('1', '2019-02-15 15:02:43', NULL, NULL, NULL, 'mq', 'ehos-video-topic', NULL, 'BYH_VIDEO', 'video.trtc', NULL),
	('2', '2019-02-15 15:02:43', NULL, NULL, NULL, 'mq', 'ehos-im-topic', NULL, 'BYH_VIDEO_YCJX', 'video.ycjx', 'ycjx'),
	('3', '2019-10-23 14:32:43', NULL, NULL, NULL, 'mq', 'ehos-im-topic', NULL, 'BYH_VIDEO_YCHY', 'video.ychy', 'ychy'),
	('4', '2020-03-17 11:32:43', NULL, NULL, NULL, 'mq', 'ehos-im-topic', NULL, 'BYH_VIDEO_ZXZX', 'video.zxzx', 'zxzx');
