/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.model.base.FrontRequest;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.newHis.HisBaseReqParamDTO;
import com.ebaiyihui.his.model.newHis.appoint.GetAppointCallbackResVO;
import com.ebaiyihui.his.model.newHis.openInspect.ConfirmOpenInspectReqVO;
import com.ebaiyihui.his.model.newHis.openInspect.ConfirmOpenInspectResVO;
import com.ebaiyihui.his.model.newHis.openInspect.InspectDateReqVO;
import com.ebaiyihui.his.model.newHis.openInspect.InspectDateResVO;
import com.ebaiyihui.his.model.newHis.openInspect.InspectProItemResVO;
import com.ebaiyihui.his.model.newHis.openInspect.InspectProReqVO;
import com.ebaiyihui.his.model.newHis.openInspect.InspectProResVO;
import com.ebaiyihui.his.model.newHis.openInspect.InspectTimeReqVO;
import com.ebaiyihui.his.model.newHis.openInspect.InspectTimeResVO;
import com.ebaiyihui.his.model.newHis.pres.AddCheckoutPresReqVO;
import com.ebaiyihui.his.service.AutoOpenInspectService;
import com.ebaiyihui.his.service.HisRemoteService;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutoOpenInspectServiceImpl
implements AutoOpenInspectService {
    private static final Logger log = LoggerFactory.getLogger(AutoOpenInspectServiceImpl.class);
    public static final String SUCCESS_FLAG = "0";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<List<InspectProItemResVO>> getOpenInspectList(FrontRequest<InspectProReqVO> param) {
        log.info("\u83b7\u53d6\u5f00\u653e\u7684\u68c0\u67e5\u68c0\u9a8c\u9879\u76ee\u5165\u53c2\uff1a" + param);
        try {
            InspectProReqVO body = (InspectProReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.OPEN_INSPECT_PROJECT.getValue(), (HisBaseReqParamDTO)body, InspectProResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            if (!Objects.equals(resDTO.getCode(), "1")) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u5f00\u653e\u7684\u68c0\u67e5\u68c0\u9a8c\u9879\u76ee\u5f02\u5e38");
            }
            InspectProResVO resBody = (InspectProResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u5f00\u653e\u7684\u68c0\u67e5\u68c0\u9a8c\u9879\u76ee\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody.getItems(), (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u5f00\u653e\u7684\u68c0\u67e5\u68c0\u9a8c\u9879\u76ee\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u83b7\u53d6\u5f00\u653e\u7684\u68c0\u67e5\u68c0\u9a8c\u9879\u76ee\u5b58\u5728\u5f02\u5e38");
        }
    }

    public FrontResponse<InspectDateResVO> getInspectDate(FrontRequest<InspectDateReqVO> param) {
        log.info("\u83b7\u53d6\u68c0\u67e5\u68c0\u9a8c\u9879\u76ee\u9884\u7ea6\u65e5\u671f\u5165\u53c2\uff1a" + param);
        try {
            InspectDateReqVO body = (InspectDateReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.OPEN_INSPECT_DATE.getValue(), (HisBaseReqParamDTO)body, InspectDateResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            if (Objects.equals(resDTO.getCode(), "1")) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u8c03\u7528his\u83b7\u53d6\u68c0\u9a8c\u68c0\u67e5\u9879\u76ee\u5f00\u5355\u65e5\u671f\u5f02\u5e38");
            }
            InspectDateResVO resBody = (InspectDateResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u8c03\u7528his\u83b7\u53d6\u68c0\u9a8c\u68c0\u67e5\u9879\u76ee\u5f00\u5355\u65e5\u671f\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u8c03\u7528his\u83b7\u53d6\u68c0\u9a8c\u68c0\u67e5\u9879\u76ee\u5f00\u5355\u65e5\u671f\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u8c03\u7528his\u83b7\u53d6\u68c0\u9a8c\u68c0\u67e5\u9879\u76ee\u5f00\u5355\u65e5\u671f\u5f02\u5e38");
        }
    }

    public FrontResponse<InspectTimeResVO> getInspectTime(FrontRequest<InspectTimeReqVO> param) {
        log.info("\u83b7\u53d6\u5f00\u653e\u7684\u68c0\u67e5\u68c0\u9a8c\u9879\u76ee\u5177\u4f53\u65f6\u95f4\u5165\u53c2\uff1a" + param);
        try {
            InspectTimeReqVO body = (InspectTimeReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.OPEN_INSPECT_TIME.getValue(), (HisBaseReqParamDTO)body, InspectTimeResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            if (Objects.equals(resDTO.getCode(), "1")) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u8c03\u7528his\u83b7\u53d6\u68c0\u9a8c\u68c0\u67e5\u9879\u76ee\u5f00\u5355\u65f6\u95f4\u5f02\u5e38");
            }
            InspectTimeResVO resBody = (InspectTimeResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u8c03\u7528his\u83b7\u53d6\u68c0\u9a8c\u68c0\u67e5\u9879\u76ee\u5f00\u5355\u65f6\u95f4\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u8c03\u7528his\u83b7\u53d6\u68c0\u9a8c\u68c0\u67e5\u9879\u76ee\u5f00\u5355\u65f6\u95f4\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u8c03\u7528his\u83b7\u53d6\u68c0\u9a8c\u68c0\u67e5\u9879\u76ee\u5f00\u5355\u65f6\u95f4\u5f02\u5e38");
        }
    }

    public FrontResponse<ConfirmOpenInspectResVO> comfirmOpenInspect(FrontRequest<ConfirmOpenInspectReqVO> param) {
        log.info("\u81ea\u52a9\u5f00\u68c0\u67e5\u68c0\u9a8c\u5355\u786e\u8ba4\u5165\u53c2\uff1a" + param);
        try {
            ConfirmOpenInspectReqVO body = (ConfirmOpenInspectReqVO)param.getBody();
            ConfirmOpenInspectReqVO openInspectReqVO = new ConfirmOpenInspectReqVO();
            BeanUtil.copyProperties((Object)body, (Object)openInspectReqVO);
            openInspectReqVO.setDeptCode("0701");
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.APPOINTMENT_CALLBACK.getValue(), (HisBaseReqParamDTO)openInspectReqVO, GetAppointCallbackResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            GetAppointCallbackResVO resBody = (GetAppointCallbackResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u81ea\u52a9\u5f00\u5355\u8c03\u7528his\u590d\u8bca\u6302\u53f7\u56de\u4f20\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            String methodEnum = MethodCodeEnum.OBTAIN_CHECKOUT_PRES.getValue();
            if (Objects.equals(body.getInspectType(), "2")) {
                methodEnum = MethodCodeEnum.OBTAIN_INSPECT_PRES.getValue();
            }
            AddCheckoutPresReqVO presReqVO = new AddCheckoutPresReqVO();
            presReqVO.setClinicNo(resBody.getClinicCode());
            presReqVO.setItems(body.getItems());
            FrontResponse openInspectRes = this.hisRemoteService.requestHisJson(param.getTransactionId(), methodEnum, (HisBaseReqParamDTO)presReqVO, ConfirmOpenInspectResVO.class);
            log.info("openInspectRes={}", (Object)resDTO);
            ConfirmOpenInspectResVO openInspectResVO = (ConfirmOpenInspectResVO)openInspectRes.getBody();
            if (null == openInspectRes) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u68c0\u67e5\u5f00\u5355\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(openInspectResVO.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            openInspectResVO.setClinicCode(resBody.getClinicCode());
            return FrontResponse.success((String)param.getTransactionId(), (Object)openInspectResVO, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u8c03\u7528his\u786e\u8ba4\u81ea\u52a9\u5f00\u68c0\u67e5\u68c0\u9a8c\u5355\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u8c03\u7528his\u786e\u8ba4\u81ea\u52a9\u5f00\u5355\u5f02\u5e38");
        }
    }

    @Autowired
    public AutoOpenInspectServiceImpl() {
    }
}

