/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.model.base.FrontRequest;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.newHis.HisBaseReqParamDTO;
import com.ebaiyihui.his.model.newHis.criticalValue.CriticalValueDealReqVO;
import com.ebaiyihui.his.model.newHis.criticalValue.CriticalValueDealResVO;
import com.ebaiyihui.his.model.newHis.criticalValue.CriticalValueItemResVO;
import com.ebaiyihui.his.model.newHis.criticalValue.CriticalValueReqVO;
import com.ebaiyihui.his.model.newHis.criticalValue.CriticalValueResVO;
import com.ebaiyihui.his.service.CriticalValueService;
import com.ebaiyihui.his.service.HisRemoteService;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CriticalValueServiceImpl
implements CriticalValueService {
    private static final Logger log = LoggerFactory.getLogger(CriticalValueServiceImpl.class);
    public static final String SUCCESS_FLAG = "0";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<List<CriticalValueItemResVO>> getCriticalValueList(FrontRequest<CriticalValueReqVO> param) {
        log.info("\u5371\u6025\u503c\u67e5\u8be2\u5165\u53c2\uff1a" + param);
        try {
            CriticalValueReqVO body = (CriticalValueReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.CRITICAL_VALUE.getValue(), (HisBaseReqParamDTO)body, CriticalValueResVO.class);
            log.info("\u5371\u6025\u503c\u67e5\u8be2resDTO={}", (Object)resDTO);
            if (!Objects.equals(resDTO.getCode(), "1")) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u5371\u6025\u503c\u67e5\u8be2\u5f02\u5e38");
            }
            CriticalValueResVO resBody = (CriticalValueResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u5371\u6025\u503c\u67e5\u8be2\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody.getItems(), (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u5371\u6025\u503c\u67e5\u8be2\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u5371\u6025\u503c\u67e5\u8be2\u5f02\u5e38");
        }
    }

    public FrontResponse<String> dealCriticalValue(FrontRequest<CriticalValueDealReqVO> param) {
        log.info("\u5371\u6025\u503c\u5904\u7406\u5165\u53c2\uff1a" + param);
        try {
            CriticalValueDealReqVO body = (CriticalValueDealReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.CRITICAL_VALUE_DEAL.getValue(), (HisBaseReqParamDTO)body, CriticalValueDealResVO.class);
            log.info("\u5371\u6025\u503c\u5904\u7406resDTO={}", (Object)resDTO);
            CriticalValueDealResVO resBody = (CriticalValueDealResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u5371\u6025\u503c\u5904\u7406\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)"\u5371\u6025\u503c\u5904\u7406\u6210\u529f\uff01", (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u5371\u6025\u503c\u5904\u7406\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u5371\u6025\u503c\u5904\u7406\u5f02\u5e38");
        }
    }

    @Autowired
    public CriticalValueServiceImpl() {
    }
}

