/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.model.base.FrontRequest;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.newHis.HisBaseReqParamDTO;
import com.ebaiyihui.his.model.newHis.dict.QueryDictItemResVO;
import com.ebaiyihui.his.model.newHis.dict.QueryDictReqVO;
import com.ebaiyihui.his.model.newHis.dict.QueryDictResVO;
import com.ebaiyihui.his.service.DictService;
import com.ebaiyihui.his.service.HisRemoteService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictServiceImpl
implements DictService {
    private static final Logger log = LoggerFactory.getLogger(DictServiceImpl.class);
    public static final String SUCCESS_FLAG = "0";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<List<QueryDictItemResVO>> getDict(FrontRequest<QueryDictReqVO> param) {
        log.info("\u67e5\u8be2\u5b57\u5178\u5165\u53c2\uff1a" + param);
        try {
            QueryDictReqVO body = (QueryDictReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.QUERY_DICT.getValue(), (HisBaseReqParamDTO)body, QueryDictResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            QueryDictResVO resBody = (QueryDictResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u67e5\u8be2\u5b57\u5178\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            List itemResVOS = resBody.getItems().stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getItemCode())).collect(Collectors.toList());
            return FrontResponse.success((String)param.getTransactionId(), itemResVOS, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u5b57\u5178\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u5b57\u5178\u5f02\u5e38");
        }
    }

    @Autowired
    public DictServiceImpl() {
    }
}

