/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.model.base.FrontRequest;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.newHis.HisBaseReqParamDTO;
import com.ebaiyihui.his.model.newHis.openInspect.InspectProItemResVO;
import com.ebaiyihui.his.model.newHis.openInspect.InspectProReqVO;
import com.ebaiyihui.his.model.newHis.openInspect.InspectProResVO;
import com.ebaiyihui.his.model.newHis.report.CheckoutItemResVO;
import com.ebaiyihui.his.model.newHis.report.CheckoutReqVO;
import com.ebaiyihui.his.model.newHis.report.CheckoutResVO;
import com.ebaiyihui.his.model.newHis.report.InspectItemResVO;
import com.ebaiyihui.his.model.newHis.report.InspectReqVO;
import com.ebaiyihui.his.model.newHis.report.InspectResVO;
import com.ebaiyihui.his.service.ElectronicReportService;
import com.ebaiyihui.his.service.HisRemoteService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElectronicReportServiceImpl
implements ElectronicReportService {
    private static final Logger log = LoggerFactory.getLogger(ElectronicReportServiceImpl.class);
    public static final String SUCCESS_FLAG = "0";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<List<InspectItemResVO>> inspectList(FrontRequest<InspectReqVO> param) {
        log.info("\u68c0\u9a8c\u9879\u76ee\u5165\u53c2\uff1a" + param);
        try {
            InspectReqVO body = (InspectReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.INSPECT_PROJECT.getValue(), (HisBaseReqParamDTO)body, InspectResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            InspectResVO resBody = (InspectResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u68c0\u9a8c\u9879\u76ee\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody.getItems(), (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u68c0\u9a8c\u9879\u76ee\u5f02\u5e38\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u68c0\u9a8c\u9879\u76ee\u5b58\u5728\u5f02\u5e38");
        }
    }

    public FrontResponse<List<CheckoutItemResVO>> checkoutList(FrontRequest<CheckoutReqVO> param) {
        log.info("\u68c0\u67e5\u9879\u76ee\u5165\u53c2\uff1a" + param);
        try {
            CheckoutReqVO body = (CheckoutReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.CHECKOUT_PROJECT.getValue(), (HisBaseReqParamDTO)body, CheckoutResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            CheckoutResVO resBody = (CheckoutResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u68c0\u67e5\u9879\u76ee\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody.getItems(), (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u68c0\u67e5\u9879\u76ee\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u68c0\u67e5\u9879\u76ee\u5b58\u5728\u5f02\u5e38");
        }
    }

    public FrontResponse<List<InspectProItemResVO>> openInspectList(FrontRequest<InspectProReqVO> param) {
        log.info("\u83b7\u53d6\u5f00\u653e\u7684\u68c0\u67e5\u68c0\u9a8c\u9879\u76ee\u5165\u53c2\uff1a" + param);
        try {
            InspectProReqVO body = (InspectProReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.OPEN_INSPECT_PROJECT.getValue(), (HisBaseReqParamDTO)body, InspectProResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            InspectProResVO resBody = (InspectProResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u5f00\u653e\u7684\u68c0\u67e5\u68c0\u9a8c\u9879\u76ee\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody.getItems(), (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u5f00\u653e\u7684\u68c0\u67e5\u68c0\u9a8c\u9879\u76ee\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u83b7\u53d6\u5f00\u653e\u7684\u68c0\u67e5\u68c0\u9a8c\u9879\u76ee\u5b58\u5728\u5f02\u5e38");
        }
    }

    @Autowired
    public ElectronicReportServiceImpl() {
    }
}

