/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.newHis.HisBaseReqDTO;
import com.ebaiyihui.his.model.newHis.HisBaseReqParamDTO;
import com.ebaiyihui.his.model.newHis.HisBaseResVO;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.utils.CxfClientUtil;
import com.ebaiyihui.his.utils.HttpUtils;
import com.ebaiyihui.his.utils.ProxyClient;
import com.ebaiyihui.his.utils.XmlTemplateKit;
import com.ebaiyihui.his.utils.XmlUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class HisRemoteServiceImpl
implements HisRemoteService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${debug}")
    private Boolean debug;
    @Value(value="${hisNewUrl}")
    private String hisNewUrl;
    @Autowired
    private CxfClientUtil cxfClientUtil;

    public <T> FrontResponse<T> requestHisNew(String transactionId, String methodStr, Map map, Class<T> c) {
        try {
            String requestHisXml = XmlTemplateKit.process((String)methodStr, (Map)map);
            if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            String responseHisXml = "";
            if (this.debug.booleanValue()) {
                responseHisXml = XmlTemplateKit.processDebug((String)methodStr);
            } else {
                responseHisXml = this.cxfClientUtil.sendHisNew(this.hisNewUrl, methodStr, requestHisXml, "Process");
                this.logger.info("url---->" + this.hisNewUrl);
                this.logger.info("method---->" + methodStr);
                this.logger.info("\u8bf7\u6c42his----> \u51fa\u53c2\uff1a" + responseHisXml);
            }
            if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            Object resHisDTO = XmlUtil.convertToJavaBean((String)responseHisXml.replace(";<", "&lt;").replace("&", "&amp;"), c);
            this.logger.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resHisDTO));
            if (null == resHisDTO) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            return FrontResponse.success((String)transactionId, (Object)resHisDTO);
        }
        catch (Exception e) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u6267\u884c\u5f02\u5e38");
        }
    }

    public <T> FrontResponse<T> requestHis(String methodStr, String requestXML, Class<T> clazz) {
        String responseHisXml = "";
        responseHisXml = this.debug != false ? XmlTemplateKit.processDebug((String)methodStr) : new ProxyClient().send(methodStr, requestXML);
        if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
            return FrontResponse.error((String)methodStr, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        Object resHisDTO = XmlUtil.convertToJavaBean((String)responseHisXml, clazz);
        this.logger.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resHisDTO));
        if (null == resHisDTO) {
            return FrontResponse.error((String)methodStr, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
        }
        return FrontResponse.success((String)methodStr, (Object)resHisDTO);
    }

    public <I extends HisBaseReqParamDTO, T> FrontResponse<T> requestHisJson(String transactionId, String methodStr, I input, Class<T> clazz) {
        try {
            HisBaseReqDTO hisBaseReqDTO = new HisBaseReqDTO();
            input.setMethod(Integer.valueOf(Integer.parseInt(methodStr)));
            hisBaseReqDTO.setRequest(input);
            String requestHisJson = JSONObject.toJSONString((Object)hisBaseReqDTO);
            this.logger.info("url---->" + this.hisNewUrl);
            this.logger.info("method---->" + methodStr);
            this.logger.info("\u8bf7\u6c42his---->\u5165\u53c2\uff1a" + requestHisJson);
            if (StringUtils.isEmpty((CharSequence)requestHisJson)) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String responseHisJson = HttpUtils.post((String)this.hisNewUrl, (String)requestHisJson);
            this.logger.info("\u8bf7\u6c42his----> \u51fa\u53c2\uff1a" + responseHisJson);
            if (StringUtils.isEmpty((CharSequence)responseHisJson)) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            HisBaseResVO resBaseHisVO = new HisBaseResVO();
            resBaseHisVO.setResponse(clazz.newInstance());
            resBaseHisVO = (HisBaseResVO)JSONObject.parseObject((String)responseHisJson, HisBaseResVO.class);
            this.logger.info("\u8bf7\u6c42\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resBaseHisVO));
            if (null == resBaseHisVO) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            Object resHisResVO = JSONObject.parseObject((String)JSONObject.toJSONString((Object)resBaseHisVO.getResponse()), clazz);
            this.logger.info("\u8f6c\u6362\u6210\u5bf9\u8c61\uff1a" + resHisResVO);
            return FrontResponse.success((String)transactionId, (Object)resHisResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u6267\u884c\u5f02\u5e38");
        }
    }

    static {
        XmlTemplateKit.init();
    }
}

