/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.model.base.FrontRequest;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.dto.UpdateInHospitalStatusReqVO;
import com.ebaiyihui.his.model.dto.UpdateInHospitalStatusResVO;
import com.ebaiyihui.his.model.hospitalization.DepositReq;
import com.ebaiyihui.his.model.hospitalization.GetIPDepositRecordsReq;
import com.ebaiyihui.his.model.hospitalization.GetIPDepositRecordsRes;
import com.ebaiyihui.his.model.hospitalization.GetInpAdmissionReq;
import com.ebaiyihui.his.model.hospitalization.GetInpAdmissionRes;
import com.ebaiyihui.his.model.hospitalization.GetOrdItemsReq;
import com.ebaiyihui.his.model.hospitalization.GetOrdItemsRes;
import com.ebaiyihui.his.model.hospitalization.HisDepositReq;
import com.ebaiyihui.his.model.hospitalization.HisDepositRes;
import com.ebaiyihui.his.model.hospitalization.HisInpAdmissionReq;
import com.ebaiyihui.his.model.hospitalization.InHospAppointReq;
import com.ebaiyihui.his.model.hospitalization.InHospAppointRes;
import com.ebaiyihui.his.model.hospitalization.IssueInHospCertReq;
import com.ebaiyihui.his.model.hospitalization.IssueInHospCertRes;
import com.ebaiyihui.his.model.hospitalization.QueryHospCertReq;
import com.ebaiyihui.his.model.hospitalization.QueryHospCertRes;
import com.ebaiyihui.his.model.hospitalization.items.DepositRecordsItem;
import com.ebaiyihui.his.model.hospitalization.items.GetInpAdmissionResItems;
import com.ebaiyihui.his.model.hospitalization.items.GetOrdItemsResItems;
import com.ebaiyihui.his.model.hospitalization.items.QueryHospCertItemRes;
import com.ebaiyihui.his.model.newHis.HisBaseReqParamDTO;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.InHospitalService;
import com.ebaiyihui.his.utils.HttpUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InHospitalServiceImpl
implements InHospitalService {
    private static final Logger log = LoggerFactory.getLogger(InHospitalServiceImpl.class);
    private final HisRemoteService hisRemoteService;

    public UpdateInHospitalStatusResVO updateStatus(UpdateInHospitalStatusReqVO reqVo) {
        log.info("\u66f4\u65b0\u4f4f\u9662\u9884\u7ea6\u72b6\u6001\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqVo));
        String url = "https://cdfenet.cn/api/CDFY/zhjy/hospitalAppointment/v1/cdfy/updateStatus";
        String result = null;
        try {
            result = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)reqVo.getRequest()));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u66f4\u65b0\u4f4f\u9662\u9884\u7ea6\u72b6\u6001\u5f02\u5e38\u62a5\u9519\uff1a{}", (Object)e.getMessage());
            UpdateInHospitalStatusResVO vo = new UpdateInHospitalStatusResVO();
            vo.setResultCode("1");
            vo.setResultMsg("\u5904\u7406\u5f02\u5e38");
        }
        return (UpdateInHospitalStatusResVO)JSONObject.parseObject((String)result, UpdateInHospitalStatusResVO.class);
    }

    public FrontResponse<List<GetInpAdmissionResItems>> queryPatientInHospitalInfo(FrontRequest<GetInpAdmissionReq> param) {
        log.info("\u60a3\u8005\u4f4f\u9662\u4fe1\u606f\u4e1a\u52a1\u5165\u53c2\uff1a" + param);
        try {
            HisInpAdmissionReq params = new HisInpAdmissionReq();
            params.setPatientId(((GetInpAdmissionReq)param.getBody()).getCardNo());
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.INPATIENT_PATIENT_INFO.getValue(), (HisBaseReqParamDTO)params, GetInpAdmissionRes.class);
            GetInpAdmissionRes resBody = (GetInpAdmissionRes)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"his\u60a3\u8005\u4f4f\u9662\u4fe1\u606f\u5b9e\u4f53\u4e3a\u7a7a");
            }
            if (!"0".equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)resBody.getResultMsg());
            }
            if (null == resBody.getItems() || resBody.getItems().isEmpty()) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"his\u60a3\u8005\u4f4f\u9662\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody.getItems(), (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u60a3\u8005\u4f4f\u9662\u4fe1\u606f\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u60a3\u8005\u4f4f\u9662\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public FrontResponse<HisDepositRes> renewalDeposit(FrontRequest<DepositReq> param) {
        log.info("\u60a3\u8005\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u4e1a\u52a1\u5165\u53c2\uff1a" + param);
        try {
            HisDepositReq hisDepositReq = new HisDepositReq();
            hisDepositReq.setInHospNo(((DepositReq)param.getBody()).getInHospNo());
            hisDepositReq.setOrderId(((DepositReq)param.getBody()).getFlowNo());
            hisDepositReq.setAmount(((DepositReq)param.getBody()).getAmount());
            HisDepositReq.TransInfo transInfo = new HisDepositReq.TransInfo();
            transInfo.setTransFlag("SECCESS");
            transInfo.setPayChannel(((DepositReq)param.getBody()).getPayChannel());
            transInfo.setPayTime(((DepositReq)param.getBody()).getPatTime());
            transInfo.setPayAmount(((DepositReq)param.getBody()).getAmount());
            transInfo.setTradNo(((DepositReq)param.getBody()).getTradeNo());
            hisDepositReq.setTransInfo(transInfo);
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.HOSPITAL_RENEWAL_DEPOSIT.getValue(), (HisBaseReqParamDTO)hisDepositReq, HisDepositRes.class);
            HisDepositRes resBody = (HisDepositRes)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"his\u8fd4\u56de\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u4fe1\u606f\u5b9e\u4f53\u4e3a\u7a7a");
            }
            if (!"0".equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u60a3\u8005\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u60a3\u8005\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u4e1a\u52a1\u5f02\u5e38");
        }
    }

    public FrontResponse<List<DepositRecordsItem>> inpatientGetPrepayRecord(FrontRequest<GetIPDepositRecordsReq> param) {
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u8bb0\u5f55\u5165\u53c2\uff1a" + param);
        try {
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.GET_IP_DEPOSIT_RECORDS.getValue(), (HisBaseReqParamDTO)param.getBody(), GetIPDepositRecordsRes.class);
            GetIPDepositRecordsRes resBody = (GetIPDepositRecordsRes)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"his\u8fd4\u56de\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u8bb0\u5f55\u4fe1\u606f\u5b9e\u4f53\u4e3a\u7a7a");
            }
            if (!"0".equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)resBody.getResultMsg());
            }
            if (null == resBody.getItems() || resBody.getItems().isEmpty()) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u8bb0\u5f55\u96c6\u5408\u4e3a\u7a7a");
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody.getItems(), (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u60a3\u8005\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u8bb0\u5f55\u67e5\u8be2\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u60a3\u8005\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u5f02\u5e38");
        }
    }

    public FrontResponse<List<GetOrdItemsResItems>> getDailyBill(FrontRequest<GetOrdItemsReq> param) {
        log.info("\u4f4f\u9662\u65e5\u6e05\u5355\u8bb0\u5f55\u5165\u53c2\uff1a" + param);
        try {
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.HOSPITALIZATION_LIST_INQUIRY.getValue(), (HisBaseReqParamDTO)param.getBody(), GetOrdItemsRes.class);
            GetOrdItemsRes resBody = (GetOrdItemsRes)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"his\u8fd4\u56de\u4f4f\u9662\u65e5\u6e05\u5355\u8bb0\u5f55\u4fe1\u606f\u5b9e\u4f53\u4e3a\u7a7a");
            }
            if (!"0".equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)resBody.getResultMsg());
            }
            if (null == resBody.getItem() || resBody.getItem().isEmpty()) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u4f4f\u9662\u65e5\u6e05\u5355\u8bb0\u5f55\u96c6\u5408\u4e3a\u7a7a");
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody.getItem(), (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u60a3\u8005\u4f4f\u9662\u65e5\u6e05\u5355\u67e5\u8be2\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u60a3\u8005\u4f4f\u9662\u65e5\u6e05\u5355\u67e5\u8be2\u4e1a\u52a1\u5f02\u5e38");
        }
    }

    public FrontResponse<List<QueryHospCertItemRes>> queryHospCert(FrontRequest<QueryHospCertReq> param) {
        log.info("\u5165\u9662\u8bc1\u67e5\u8be2\u5165\u53c2\uff1a{}", param);
        try {
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.HOSPITAL_CERT_QUERY.getValue(), (HisBaseReqParamDTO)param.getBody(), QueryHospCertRes.class);
            QueryHospCertRes resBody = (QueryHospCertRes)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"his\u8fd4\u56de\u5165\u9662\u8bc1\u67e5\u8be2\u4fe1\u606f\u5b9e\u4f53\u4e3a\u7a7a");
            }
            if (!"0".equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)resBody.getResultMsg());
            }
            if (null == resBody.getItems() || resBody.getItems().isEmpty()) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u5165\u9662\u8bc1\u8bb0\u5f55\u96c6\u5408\u4e3a\u7a7a");
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody.getItems(), (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u5165\u9662\u8bc1\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u5165\u9662\u8bc1\u67e5\u8be2\u4e1a\u52a1\u5f02\u5e38");
        }
    }

    public FrontResponse<InHospAppointRes> inHospAppoint(FrontRequest<InHospAppointReq> param) {
        log.info("\u5165\u9662\u9884\u7ea6\u5165\u53c2\uff1a{}", param);
        try {
            InHospAppointReq body = (InHospAppointReq)param.getBody();
            body.setRegisterDate(body.getConfirmDate());
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.HOSPITALIZATION_APPOINTMENT.getValue(), (HisBaseReqParamDTO)body, InHospAppointRes.class);
            InHospAppointRes resBody = (InHospAppointRes)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"his\u8fd4\u56de\u5165\u9662\u9884\u7ea6\u4fe1\u606f\u5b9e\u4f53\u4e3a\u7a7a");
            }
            if (!"0".equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u5165\u9662\u9884\u7ea6\u5f02\u5e38:{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u5165\u9662\u9884\u7ea6\u4e1a\u52a1\u5f02\u5e38");
        }
    }

    public FrontResponse<IssueInHospCertRes> issueInHospCert(FrontRequest<IssueInHospCertReq> param) {
        log.info("\u5f00\u5177\u5165\u9662\u8bc1\u5165\u53c2\uff1a{}", param);
        try {
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.HOSPITAL_CERT_ISSUE.getValue(), (HisBaseReqParamDTO)param.getBody(), IssueInHospCertRes.class);
            IssueInHospCertRes body = (IssueInHospCertRes)resDTO.getBody();
            if (null == body) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"his\u8fd4\u56de\u5165\u9662\u8bc1\u53d1\u653e\u4fe1\u606f\u5b9e\u4f53\u4e3a\u7a7a");
            }
            if (!"0".equals(body.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)body.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)body, (String)body.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u5f00\u5177\u5165\u9662\u8bc1\u5f02\u5e38:{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u5f00\u5177\u5165\u9662\u8bc1\u4e1a\u52a1\u5f02\u5e38");
        }
    }

    @Autowired
    public InHospitalServiceImpl(HisRemoteService hisRemoteService) {
        this.hisRemoteService = hisRemoteService;
    }
}

