/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.utils.DateUtil;
import com.ebaiyihui.his.dto.JhResDto;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.wait.GetWaitingQueueReqVO;
import com.ebaiyihui.his.model.wait.GetWaitingQueueResVO;
import com.ebaiyihui.his.model.wait.items.GetWaitingQueueResItems;
import com.ebaiyihui.his.service.JiaoHaoService;
import com.ebaiyihui.his.utils.HttpUtils;
import com.ebaiyihui.his.vo.RegisterInfo;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class JiaoHaoServcieImpl
implements JiaoHaoService {
    private static final Logger log = LoggerFactory.getLogger(JiaoHaoServcieImpl.class);
    @Value(value="${hisNewUrl}")
    private String hisNewUrl;
    static final String TAG = "\u6392\u961f\u53eb\u53f7";
    @Value(value="${byUrl}")
    String url;

    public FrontResponse<GetWaitingQueueResVO> query(GetWaitingQueueReqVO req) {
        JaxWsDynamicClientFactory dcflient = JaxWsDynamicClientFactory.newInstance();
        Client client = dcflient.createClient(this.url);
        String commandID = "JH1001";
        String hospitalID = "1001";
        String message = "<Body><jh1001><ym></ym><yc></yc><mzh>" + req.getCardNo() + "</mzh></jh1001></Body>";
        JhResDto response = new JhResDto();
        try {
            Object[] objects = client.invoke("syncInvoke", new Object[]{commandID, hospitalID, message});
            String result = objects[0].toString();
            int startIndex = result.indexOf("<jh1001Result>");
            String endTag = "</jh1001Result>";
            int endIndex = result.indexOf("</jh1001Result>");
            result = result.substring(startIndex, endIndex + endTag.length());
            log.info("result{}", (Object)result);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{JhResDto.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(result);
            response = (JhResDto)unmarshaller.unmarshal((Reader)reader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        GetWaitingQueueResVO getWaitingQueueResVO = new GetWaitingQueueResVO();
        ArrayList<GetWaitingQueueResItems> resItems = new ArrayList<GetWaitingQueueResItems>();
        List queues = response.getQueues();
        if (queues.isEmpty()) {
            return FrontResponse.success((String)"", (Object)getWaitingQueueResVO);
        }
        RegisterInfo registerInfo = this.queryRegisterInfo(req.getPatientId());
        List itemList = registerInfo.getResponse().getItem();
        if (itemList.isEmpty()) {
            return FrontResponse.success((String)"", (Object)getWaitingQueueResVO);
        }
        for (RegisterInfo.Response.Items item : itemList) {
            for (JhResDto.Queues queues1 : queues) {
                if (!item.getDeptName().equals(queues1.getKsmc())) continue;
                GetWaitingQueueResItems resItem = new GetWaitingQueueResItems();
                resItem.setDeptName(item.getDeptName());
                resItem.setDoctorName(item.getDocName());
                resItem.setNowSeqNo(queues1.getDqh());
                resItem.setCallSeqNo(queues1.getGhxh());
                resItem.setAdmId(item.getClinicNo());
                resItem.setTimeFlag(item.getTimeFlag());
                resItem.setDoctorTitleName(item.getDoctorTitle());
                resItem.setPatientName(item.getPatientName());
                Integer dqh = Integer.parseInt(queues1.getDqh());
                Integer ghxh = Integer.parseInt(queues1.getGhxh());
                if (dqh > ghxh) {
                    resItem.setWaitingStatus("3");
                }
                if (dqh < ghxh) {
                    resItem.setWaitingStatus("2");
                    resItem.setWaitingNum(dqh - ghxh + "");
                }
                if (dqh.equals(ghxh)) {
                    resItem.setWaitingStatus("1");
                }
                resItems.add(resItem);
            }
        }
        getWaitingQueueResVO.setItems(resItems);
        return FrontResponse.success((String)"", (Object)getWaitingQueueResVO);
    }

    public RegisterInfo queryRegisterInfo(String patientId) {
        String str = "{\n\t\"Request\": {\n\t\t\"method\": 2211,\n\t\t\"cardNo\": \"patientId\",\n\t\t\"startDate\": \"time\",\n\t\t\"endDate\": \"time\"\n\t}\n}";
        String requestHisJson = str.replace("patientId", patientId);
        String date = DateUtil.getCurrentTime();
        requestHisJson = requestHisJson.replace("time", date);
        log.info("url---->" + this.hisNewUrl);
        log.info("\u8bf7\u6c42his---->\u5165\u53c2\uff1a" + requestHisJson);
        String responseHisJson = null;
        try {
            responseHisJson = HttpUtils.post((String)this.hisNewUrl, (String)requestHisJson);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        log.info("\u8bf7\u6c42his----> \u51fa\u53c2\uff1a" + responseHisJson);
        RegisterInfo registerInfo = (RegisterInfo)JSON.parseObject((String)responseHisJson, RegisterInfo.class);
        return registerInfo;
    }
}

