/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.dto.AdmissionRecordResDTO;
import com.ebaiyihui.his.dto.DrugDetailData;
import com.ebaiyihui.his.dto.PatientListResultDTO;
import com.ebaiyihui.his.dto.PrescriptionRecordReqVo;
import com.ebaiyihui.his.dto.RegisteredRecordReqVo;
import com.ebaiyihui.his.model.appoint.RegisteredRecordResVo;
import com.ebaiyihui.his.model.base.FrontRequest;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.newHis.HisBaseReqParamDTO;
import com.ebaiyihui.his.model.newHis.medicalRecord.AdmissionRecordReqVO;
import com.ebaiyihui.his.model.newHis.medicalRecord.AdmissionRecordResVO;
import com.ebaiyihui.his.model.newHis.medicalRecord.MedicalRecordCallbackReqVO;
import com.ebaiyihui.his.model.newHis.medicalRecord.MedicalRecordCallbackResVO;
import com.ebaiyihui.his.model.newHis.medicalRecord.MedicalRecordPresDrugResVO;
import com.ebaiyihui.his.model.newHis.medicalRecord.MedicalRecordPresResVO;
import com.ebaiyihui.his.model.newHis.medicalRecord.MedicalRecordRegisterResVO;
import com.ebaiyihui.his.model.newHis.medicalRecord.MedicalRecordReqVO;
import com.ebaiyihui.his.model.newHis.medicalRecord.MedicalRecordResVO;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.MedicalRecordService;
import com.ebaiyihui.his.utils.DateUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MedicalRecordServiceImpl
implements MedicalRecordService {
    private static final Logger log = LoggerFactory.getLogger(MedicalRecordServiceImpl.class);
    public static final String SUCCESS_FLAG = "0";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<List<RegisteredRecordResVo>> getAdmissionRecordList(FrontRequest<RegisteredRecordReqVo> param) {
        log.info("\u67e5\u8be2\u5c31\u8bca\u8bb0\u5f55\u5217\u8868\u5165\u53c2\uff1a" + param);
        try {
            RegisteredRecordReqVo registeredRecordReqVo = (RegisteredRecordReqVo)param.getBody();
            AdmissionRecordReqVO body = new AdmissionRecordReqVO();
            body.setPatientId(registeredRecordReqVo.getCardNo());
            body.setStartDate(registeredRecordReqVo.getBgDate());
            body.setEndDate(registeredRecordReqVo.getEdDate());
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.ADMISSION_RECORD.getValue(), (HisBaseReqParamDTO)body, AdmissionRecordResDTO.class);
            log.info("resDTO={}", (Object)resDTO);
            AdmissionRecordResDTO resBody = (AdmissionRecordResDTO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u67e5\u8be2\u5c31\u8bca\u8bb0\u5f55\u5217\u8868\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            List list = resBody.getItems();
            ArrayList<RegisteredRecordResVo> resList = new ArrayList<RegisteredRecordResVo>();
            if (list.isEmpty()) {
                return FrontResponse.success((String)param.getTransactionId(), resList, (String)resBody.getResultMsg());
            }
            for (AdmissionRecordResVO vo : list) {
                RegisteredRecordResVo registeredRecordResVo = new RegisteredRecordResVo();
                BeanUtils.copyProperties((Object)vo, (Object)registeredRecordResVo);
                registeredRecordResVo.setDoctCode(vo.getDoctorCode());
                registeredRecordResVo.setDocName(vo.getDoctorName());
                resList.add(registeredRecordResVo);
            }
            return FrontResponse.success((String)param.getTransactionId(), resList, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u5c31\u8bca\u8bb0\u5f55\u5217\u8868\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u5c31\u8bca\u8bb0\u5f55\u5217\u8868\u5b58\u5728\u5f02\u5e38");
        }
    }

    public FrontResponse<List<PatientListResultDTO>> getPrescriptionRecordList(FrontRequest<PrescriptionRecordReqVo> param) throws ParseException {
        PrescriptionRecordReqVo prescriptionRecordReqVo = (PrescriptionRecordReqVo)param.getBody();
        AdmissionRecordReqVO body = new AdmissionRecordReqVO();
        body.setPatientId(prescriptionRecordReqVo.getCardNo());
        body.setStartDate(prescriptionRecordReqVo.getBgDate());
        body.setEndDate(prescriptionRecordReqVo.getEdDate());
        FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.ADMISSION_RECORD.getValue(), (HisBaseReqParamDTO)body, AdmissionRecordResDTO.class);
        log.info("resDTO={}", (Object)resDTO);
        AdmissionRecordResDTO resBody = (AdmissionRecordResDTO)resDTO.getBody();
        if (null == resBody) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u67e5\u8be2\u5c31\u8bca\u8bb0\u5f55\u5217\u8868\u5f02\u5e38");
        }
        if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
        }
        List list = resBody.getItems();
        ArrayList<PatientListResultDTO> patientListResultDTOS = new ArrayList<PatientListResultDTO>();
        for (AdmissionRecordResVO admissionRecordResVO : list) {
            MedicalRecordReqVO medicalRecordReqVO = new MedicalRecordReqVO();
            medicalRecordReqVO.setClinicNo(admissionRecordResVO.getClinicNo());
            FrontResponse frontResponse = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.MEDICAL_RECORD.getValue(), (HisBaseReqParamDTO)medicalRecordReqVO, MedicalRecordRegisterResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            MedicalRecordRegisterResVO medicalRecordRegisterResVO = (MedicalRecordRegisterResVO)frontResponse.getBody();
            if (null == medicalRecordRegisterResVO) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u67e5\u8be2\u75c5\u5386\u8be6\u60c5\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(medicalRecordRegisterResVO.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            List medicalRecordPresResVOList = medicalRecordRegisterResVO.getRegister().getPrescription();
            if (medicalRecordPresResVOList.isEmpty()) continue;
            for (MedicalRecordPresResVO medicalRecordPresResVO : medicalRecordPresResVOList) {
                PatientListResultDTO patientListResultDTO = new PatientListResultDTO();
                patientListResultDTO.setMainId(medicalRecordPresResVO.getPrescriptionCode());
                patientListResultDTO.setCreateTime(medicalRecordPresResVO.getOpenTime());
                patientListResultDTO.setDrugOrderTime(DateUtil.strToDate((String)medicalRecordPresResVO.getOpenTime(), (String)DateUtil.FULL_FORMAT));
                patientListResultDTO.setPresOrgan("CDFY");
                patientListResultDTO.setPresOrganName("\u6210\u90fd\u5e02\u5987\u5973\u513f\u7ae5\u4e2d\u5fc3\u533b\u9662");
                patientListResultDTO.setPresDoctorName(admissionRecordResVO.getDoctorName());
                patientListResultDTO.setPresDeptName(admissionRecordResVO.getDeptName());
                patientListResultDTO.setDrugSpeciesNum(Integer.valueOf(medicalRecordPresResVO.getDrug().size()));
                patientListResultDTO.setPresType(Integer.valueOf(4));
                patientListResultDTO.setMainType(Integer.valueOf(1));
                patientListResultDTO.setHisRecipeNo(medicalRecordPresResVO.getPrescriptionCode());
                patientListResultDTO.setDiagnostic(admissionRecordResVO.getDiagnose());
                patientListResultDTO.setDrugName(((MedicalRecordPresDrugResVO)medicalRecordPresResVO.getDrug().get(0)).getDrugName());
                patientListResultDTO.setDrugDesc("\u542b" + ((MedicalRecordPresDrugResVO)medicalRecordPresResVO.getDrug().get(0)).getDrugName() + "\u5171" + medicalRecordPresResVO.getDrug().size() + "\u79cd\u836f\u54c1");
                List drugs = medicalRecordPresResVO.getDrug();
                ArrayList<DrugDetailData> drugDetailDatas = new ArrayList<DrugDetailData>();
                for (MedicalRecordPresDrugResVO medicalRecordPresDrugResVO : drugs) {
                    DrugDetailData drugDetailData = new DrugDetailData();
                    drugDetailData.setPresDetailId(medicalRecordPresDrugResVO.getDrugCode());
                    drugDetailData.setDrugName(medicalRecordPresDrugResVO.getDrugName());
                    drugDetailData.setDosage("\u6bcf\u6b21" + medicalRecordPresDrugResVO.getDrugNum() + "," + medicalRecordPresDrugResVO.getDrugUse() + "," + medicalRecordPresDrugResVO.getDrugFrequence());
                    drugDetailData.setDuration(Integer.valueOf(Integer.parseInt(medicalRecordPresDrugResVO.getDrugDay())));
                    drugDetailDatas.add(drugDetailData);
                }
                patientListResultDTO.setDrugDetailData(drugDetailDatas);
                patientListResultDTO.setMainStatus("\u5df2\u5b8c\u6210");
                patientListResultDTOS.add(patientListResultDTO);
            }
        }
        return FrontResponse.success((String)"", patientListResultDTOS);
    }

    public FrontResponse<MedicalRecordResVO> getMedicalRecordDetail(FrontResponse<MedicalRecordReqVO> param) {
        log.info("\u67e5\u8be2\u75c5\u5386\u8be6\u60c5\u5165\u53c2\uff1a" + param);
        try {
            MedicalRecordReqVO body = (MedicalRecordReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.MEDICAL_RECORD.getValue(), (HisBaseReqParamDTO)body, MedicalRecordRegisterResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            MedicalRecordRegisterResVO resBody = (MedicalRecordRegisterResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u67e5\u8be2\u75c5\u5386\u8be6\u60c5\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody.getRegister(), (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u75c5\u5386\u8be6\u60c5\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u75c5\u5386\u8be6\u60c5\u5b58\u5728\u5f02\u5e38");
        }
    }

    public FrontResponse<MedicalRecordCallbackResVO> medicalRecordCallback(FrontResponse<MedicalRecordCallbackReqVO> param) {
        log.info("\u75c5\u5386\u56de\u4f20\u5165\u53c2\uff1a" + param);
        try {
            MedicalRecordCallbackReqVO body = (MedicalRecordCallbackReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.MEDICAL_RECORD_CALLBACK.getValue(), (HisBaseReqParamDTO)body, MedicalRecordCallbackResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            MedicalRecordCallbackResVO resBody = (MedicalRecordCallbackResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u75c5\u5386\u56de\u4f20\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u75c5\u5386\u56de\u4f20\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u75c5\u5386\u56de\u4f20\u5b58\u5728\u5f02\u5e38");
        }
    }

    @Autowired
    public MedicalRecordServiceImpl() {
    }
}

