/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodNameEnum;
import com.ebaiyihui.his.dto.AdmRegisterResDTO;
import com.ebaiyihui.his.dto.AmdRegisteredResDTO;
import com.ebaiyihui.his.dto.GetAdmListReqDTO;
import com.ebaiyihui.his.dto.GetAdmListResDTO;
import com.ebaiyihui.his.model.appoint.AmdRegisteredReqVo;
import com.ebaiyihui.his.model.appoint.RegisteredRecordReqVo;
import com.ebaiyihui.his.model.base.FrontRequest;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.newHis.HisBaseReqParamDTO;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.AdmFeeRefundsReqVO;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.AdmFeeRefundsResVO;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.AdmissionOrCancellationReqVo;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.AdmissionOrCancellationResVo;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.AdvicePayOrCancelReqVO;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.AdvicePayOrCancelResVO;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.CancelAdviceReqVO;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.CancelAdviceResVO;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.DoctorReceiveCancelReqVO;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.DoctorReceiveCancelResVO;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.IssuedUpdateAdviceReqVO;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.IssuedUpdateAdviceResVO;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.IssuingDiagnosticReqVO;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.IssuingDiagnosticResVO;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.QueryCheckLabProjectReqVO;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.QueryCheckLabProjectResVO;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.QueryDrugListReqVO;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.QueryDrugListResVO;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.QueryStoreListReqVO;
import com.ebaiyihui.his.model.newHis.onlineOutpatient.QueryStoreListResVO;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.OnlineOutpatientService;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OnlineOutpatientImpl
implements OnlineOutpatientService {
    private static final Logger log = LoggerFactory.getLogger(OnlineOutpatientImpl.class);
    public static final String SUCCESS_FLAG = "0";
    private final HisRemoteService hisRemoteService;

    public FrontResponse<List<AdmRegisterResDTO>> admList(FrontRequest<RegisteredRecordReqVo> param) {
        log.info("\u95e8\u8bca\u8bb0\u5f55\u8bf7\u6c42\u5165\u53c2\uff1a" + param);
        try {
            RegisteredRecordReqVo body = (RegisteredRecordReqVo)param.getBody();
            GetAdmListReqDTO request = new GetAdmListReqDTO();
            request.setMethod("3101");
            request.setCardNo(body.getCardNo());
            request.setEndDate(body.getEdDate());
            request.setStartDate(body.getBgDate());
            request.setIdNo(body.getPatientIdCard());
            request.setPatientName(body.getPatientName());
            HashMap<String, GetAdmListReqDTO> map = new HashMap<String, GetAdmListReqDTO>(1);
            map.put(EntityKeyEnum.ADM_LIST.getValue(), request);
            FrontResponse resDTO = this.hisRemoteService.requestHisNew(param.getTransactionId(), MethodNameEnum.ADM_LIST.getValue(), map, GetAdmListResDTO.class);
            GetAdmListResDTO response = (GetAdmListResDTO)resDTO.getBody();
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)response.getRegisterResDTO());
        }
        catch (Exception e) {
            log.info("\u95e8\u8bca\u8bb0\u5f55\u8bf7\u6c42\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u95e8\u8bca\u8bb0\u5f55\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<AmdRegisteredResDTO> admRegistration(FrontRequest<AmdRegisteredReqVo> param) {
        log.info("\u590d\u8bca\u6302\u53f7\u56de\u4f20\u8bf7\u6c42\u5165\u53c2\uff1a" + param);
        try {
            ((AmdRegisteredReqVo)param.getBody()).setMethod("3102");
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put(EntityKeyEnum.ADM_REGISTRATION.getValue(), param.getBody());
            FrontResponse resDTO = this.hisRemoteService.requestHisNew(param.getTransactionId(), MethodNameEnum.ADM_REGISTRATION.getValue(), map, AmdRegisteredResDTO.class);
            AmdRegisteredResDTO response = (AmdRegisteredResDTO)resDTO.getBody();
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)response);
        }
        catch (Exception e) {
            log.info("\u590d\u8bca\u6302\u53f7\u56de\u4f20\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u590d\u8bca\u6302\u53f7\u56de\u4f20\u5f02\u5e38");
        }
    }

    public FrontResponse<AdmFeeRefundsResVO> admFeeRefunds(FrontRequest<AdmFeeRefundsReqVO> param) {
        log.info("\u7ebf\u4e0a\u9000\u53f7\u9000\u8d39\u56de\u4f20\u5165\u53c2\uff1a" + param);
        try {
            AdmFeeRefundsReqVO body = (AdmFeeRefundsReqVO)param.getBody();
            body.setMethod("3103");
            HashMap<String, AdmFeeRefundsReqVO> map = new HashMap<String, AdmFeeRefundsReqVO>(1);
            map.put(EntityKeyEnum.ADM_FEE_REFUNDS.getValue(), body);
            FrontResponse resDTO = this.hisRemoteService.requestHisNew(param.getTransactionId(), MethodNameEnum.ADM_FEE_REFUNDS.getValue(), map, AdmFeeRefundsResVO.class);
            AdmFeeRefundsResVO response = (AdmFeeRefundsResVO)resDTO.getBody();
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)response);
        }
        catch (Exception e) {
            log.info("\u7ebf\u4e0a\u9000\u53f7\u9000\u8d39\u8bf7\u6c42\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u7ebf\u4e0a\u9000\u53f7\u9000\u8d39\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<AdmissionOrCancellationResVo> doctorReceiveCancel(FrontRequest<AdmissionOrCancellationReqVo> param) {
        log.info("\u533b\u751f\u63a5\u8bca/\u53d6\u6d88\u63a5\u8bca\u5165\u53c2\uff1a" + param);
        try {
            AdmissionOrCancellationReqVo body = (AdmissionOrCancellationReqVo)param.getBody();
            DoctorReceiveCancelReqVO doctorReceiveCancelReqVO = new DoctorReceiveCancelReqVO();
            doctorReceiveCancelReqVO.setMethod("3301");
            doctorReceiveCancelReqVO.setClinicNo(body.getClinicCode());
            doctorReceiveCancelReqVO.setOperateType("1".equals(body.getYnSee()) ? "1" : "2");
            HashMap<String, DoctorReceiveCancelReqVO> map = new HashMap<String, DoctorReceiveCancelReqVO>(1);
            map.put(EntityKeyEnum.DOCTOR_RECEIVE_CANCEL.getValue(), doctorReceiveCancelReqVO);
            FrontResponse resDTO = this.hisRemoteService.requestHisNew(param.getTransactionId(), MethodNameEnum.DOCTOR_RECEIVE_CANCEL.getValue(), map, DoctorReceiveCancelResVO.class);
            DoctorReceiveCancelResVO response = (DoctorReceiveCancelResVO)resDTO.getBody();
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            AdmissionOrCancellationResVo resVo = new AdmissionOrCancellationResVo();
            resVo.setId(response.getResultCode());
            resVo.setErr(response.getResultMsg());
            resVo.setResult(response.getResultMsg());
            return FrontResponse.success((String)param.getTransactionId(), (Object)resVo);
        }
        catch (Exception e) {
            log.info("\u533b\u751f\u63a5\u8bca/\u53d6\u6d88\u63a5\u8bca\u8bf7\u6c42\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u533b\u751f\u63a5\u8bca/\u53d6\u6d88\u63a5\u8bca\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<IssuingDiagnosticResVO> issuingDiagnostic(FrontRequest<IssuingDiagnosticReqVO> param) {
        log.info("\u5f00\u5177\u8bca\u65ad\u4fe1\u606f\u5165\u53c2\uff1a" + param);
        try {
            IssuingDiagnosticReqVO body = (IssuingDiagnosticReqVO)param.getBody();
            body.setMethod("3302");
            HashMap<String, IssuingDiagnosticReqVO> map = new HashMap<String, IssuingDiagnosticReqVO>(1);
            map.put(EntityKeyEnum.ISSUING_DIAGNOSTIC.getValue(), body);
            FrontResponse resDTO = this.hisRemoteService.requestHisNew(param.getTransactionId(), MethodNameEnum.ISSUING_DIAGNOSTIC.getValue(), map, IssuingDiagnosticResVO.class);
            IssuingDiagnosticResVO response = (IssuingDiagnosticResVO)resDTO.getBody();
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)response);
        }
        catch (Exception e) {
            log.info("\u5f00\u5177\u8bca\u65ad\u4fe1\u606f\u8bf7\u6c42\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u5f00\u5177\u8bca\u65ad\u4fe1\u606f\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<IssuedUpdateAdviceResVO> issuedUpdateAdvice(FrontRequest<IssuedUpdateAdviceReqVO> param) {
        log.info("\u5f00\u5177\u6216\u53d8\u66f4\u533b\u5631\u5165\u53c2\uff1a" + param);
        try {
            IssuedUpdateAdviceReqVO body = (IssuedUpdateAdviceReqVO)param.getBody();
            body.setMethod(Integer.valueOf(4103));
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodNameEnum.ISSUED_UPDATE_ADVICE.getValue(), (HisBaseReqParamDTO)body, IssuedUpdateAdviceResVO.class);
            IssuedUpdateAdviceResVO response = (IssuedUpdateAdviceResVO)resDTO.getBody();
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u75c5\u5386\u56de\u4f20\u6267\u884c\u5931\u8d25");
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)response);
        }
        catch (Exception e) {
            log.info("\u5f00\u5177\u6216\u53d8\u66f4\u533b\u5631\u8bf7\u6c42\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u5f00\u5177\u6216\u53d8\u66f4\u533b\u5631\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<CancelAdviceResVO> cancelAdvice(FrontRequest<CancelAdviceReqVO> param) {
        log.info("\u64a4\u9500\u533b\u5631\u5165\u53c2\uff1a" + param);
        try {
            CancelAdviceReqVO body = (CancelAdviceReqVO)param.getBody();
            body.setMethod("4103");
            HashMap<String, CancelAdviceReqVO> map = new HashMap<String, CancelAdviceReqVO>(1);
            map.put(EntityKeyEnum.CANCEL_ADVICE.getValue(), body);
            FrontResponse resDTO = this.hisRemoteService.requestHisNew(param.getTransactionId(), MethodNameEnum.CANCEL_ADVICE.getValue(), map, CancelAdviceResVO.class);
            CancelAdviceResVO response = (CancelAdviceResVO)resDTO.getBody();
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)response);
        }
        catch (Exception e) {
            log.info("\u64a4\u9500\u533b\u5631\u8bf7\u6c42\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u64a4\u9500\u533b\u5631\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<AdvicePayOrCancelResVO> advicePayOrCancel(FrontRequest<AdvicePayOrCancelReqVO> param) {
        log.info("\u533b\u5631\u652f\u4ed8\u53ca\u9000\u6b3e\u63a5\u53e3\u5165\u53c2\uff1a" + param);
        try {
            AdvicePayOrCancelReqVO body = (AdvicePayOrCancelReqVO)param.getBody();
            body.setMethod("4107");
            HashMap<String, AdvicePayOrCancelReqVO> map = new HashMap<String, AdvicePayOrCancelReqVO>(1);
            map.put(EntityKeyEnum.ADVICE_PAY_OR_CANCEL.getValue(), body);
            FrontResponse resDTO = this.hisRemoteService.requestHisNew(param.getTransactionId(), MethodNameEnum.ADVICE_PAY_OR_CANCEL.getValue(), map, AdvicePayOrCancelResVO.class);
            AdvicePayOrCancelResVO response = (AdvicePayOrCancelResVO)resDTO.getBody();
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)response);
        }
        catch (Exception e) {
            log.info("\u533b\u5631\u652f\u4ed8\u53ca\u9000\u6b3e\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u533b\u5631\u652f\u4ed8\u53ca\u9000\u6b3e\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<QueryCheckLabProjectResVO> queryCheckLabProject(FrontRequest<QueryCheckLabProjectReqVO> param) {
        log.info("\u533b\u5631\u652f\u4ed8\u53ca\u9000\u6b3e\u63a5\u53e3\u5165\u53c2\uff1a" + param);
        try {
            QueryCheckLabProjectReqVO body = (QueryCheckLabProjectReqVO)param.getBody();
            body.setMethod("4107");
            HashMap<String, QueryCheckLabProjectReqVO> map = new HashMap<String, QueryCheckLabProjectReqVO>(1);
            map.put(EntityKeyEnum.QUERY_CHECK_LAB_PROJECT.getValue(), body);
            FrontResponse resDTO = this.hisRemoteService.requestHisNew(param.getTransactionId(), MethodNameEnum.QUERY_CHECK_LAB_PROJECT.getValue(), map, QueryCheckLabProjectResVO.class);
            QueryCheckLabProjectResVO response = (QueryCheckLabProjectResVO)resDTO.getBody();
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)response);
        }
        catch (Exception e) {
            log.info("\u533b\u5631\u652f\u4ed8\u53ca\u9000\u6b3e\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u533b\u5631\u652f\u4ed8\u53ca\u9000\u6b3e\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<QueryDrugListResVO> queryDrugList(FrontRequest<QueryDrugListReqVO> param) {
        log.info("\u67e5\u8be2\u836f\u54c1\u76ee\u5f55(\u542b\u5e93\u5b58)\u63a5\u53e3\u5165\u53c2\uff1a" + param);
        try {
            QueryDrugListReqVO body = (QueryDrugListReqVO)param.getBody();
            body.setMethod("4302");
            HashMap<String, QueryDrugListReqVO> map = new HashMap<String, QueryDrugListReqVO>(1);
            map.put(EntityKeyEnum.QUERY_DRUG_LIST.getValue(), body);
            FrontResponse resDTO = this.hisRemoteService.requestHisNew(param.getTransactionId(), MethodNameEnum.QUERY_DRUG_LIST.getValue(), map, QueryDrugListResVO.class);
            QueryDrugListResVO response = (QueryDrugListResVO)resDTO.getBody();
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)response);
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u836f\u54c1\u76ee\u5f55(\u542b\u5e93\u5b58)\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u836f\u54c1\u76ee\u5f55(\u542b\u5e93\u5b58)\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<QueryStoreListResVO> queryStoreList(FrontRequest<QueryStoreListReqVO> param) {
        log.info("\u67e5\u8be2\u836f\u623f\u63a5\u53e3\u5165\u53c2\uff1a" + param);
        try {
            QueryStoreListReqVO body = (QueryStoreListReqVO)param.getBody();
            body.setMethod("4303");
            HashMap<String, QueryStoreListReqVO> map = new HashMap<String, QueryStoreListReqVO>(1);
            map.put(EntityKeyEnum.QUERY_STORE_LIST.getValue(), body);
            FrontResponse resDTO = this.hisRemoteService.requestHisNew(param.getTransactionId(), MethodNameEnum.QUERY_STORE_LIST.getValue(), map, QueryStoreListResVO.class);
            QueryStoreListResVO response = (QueryStoreListResVO)resDTO.getBody();
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)response);
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u836f\u623f\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u836f\u623f\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    @Autowired
    public OnlineOutpatientImpl(HisRemoteService hisRemoteService) {
        this.hisRemoteService = hisRemoteService;
    }
}

