/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.dto.QueryIsRefundReq;
import com.ebaiyihui.his.dto.QueryIsRefundRes;
import com.ebaiyihui.his.model.base.FrontRequest;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.newHis.HisBaseReqParamDTO;
import com.ebaiyihui.his.model.newHis.HisBaseResultVO;
import com.ebaiyihui.his.model.newHis.outpatient.QueryOutpatientPaymentRecordsFeeResVO;
import com.ebaiyihui.his.model.newHis.outpatient.QueryOutpatientPaymentRecordsReqVO;
import com.ebaiyihui.his.model.newHis.outpatient.QueryOutpatientPaymentRecordsResVO;
import com.ebaiyihui.his.model.outpatient.GetOutpatientPaymentSettlementListRcpRes;
import com.ebaiyihui.his.model.outpatient.GetOutpatientPaymentSettlementListReqVO;
import com.ebaiyihui.his.model.outpatient.GetOutpatientPaymentSettlementListResVO;
import com.ebaiyihui.his.model.outpatient.GetPendPaymentRecordReqVO;
import com.ebaiyihui.his.model.outpatient.GetPendPaymentRecordResVO;
import com.ebaiyihui.his.model.outpatient.OutpatientPaymentSettlementReqVO;
import com.ebaiyihui.his.model.outpatient.OutpatientPaymentSettlementResVO;
import com.ebaiyihui.his.model.outpatient.datas.OutpatientPaymentSettlementRcpt;
import com.ebaiyihui.his.model.outpatient.items.GetPendPaymentRecordCharge;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.OutpatientPaymentService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutpatientPaymentServiceImpl
implements OutpatientPaymentService {
    private static final Logger log = LoggerFactory.getLogger(OutpatientPaymentServiceImpl.class);
    public static final String SUCCESS_FLAG = "0";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<List<GetPendPaymentRecordCharge>> queryPendPaymentRecords(FrontRequest<GetPendPaymentRecordReqVO> param) {
        log.info("\u67e5\u8be2\u5f85\u7f34\u8d39\u8bb0\u5f55\u5165\u53c2\uff1a" + param);
        try {
            GetPendPaymentRecordReqVO body = (GetPendPaymentRecordReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.PEND_PAYMENT_RECORDS.getValue(), (HisBaseReqParamDTO)body, GetPendPaymentRecordResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            GetPendPaymentRecordResVO resBody = (GetPendPaymentRecordResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u67e5\u8be2\u5f85\u7f34\u8d39\u8bb0\u5f55\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody.getChargeList(), (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u5f85\u7f34\u8d39\u8bb0\u5f55\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u5f85\u7f34\u8d39\u8bb0\u5f55\u5f02\u5e38");
        }
    }

    public FrontResponse<List<OutpatientPaymentSettlementRcpt>> outpatientPaymentSettlement(FrontRequest<OutpatientPaymentSettlementReqVO> param) {
        log.info("\u67e5\u8be2\u95e8\u8bca\u7f34\u8d39\u5165\u53c2\uff1a" + param);
        try {
            OutpatientPaymentSettlementReqVO body = (OutpatientPaymentSettlementReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.PAYMENT_CONFIRMATION.getValue(), (HisBaseReqParamDTO)body, OutpatientPaymentSettlementResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            OutpatientPaymentSettlementResVO resBody = (OutpatientPaymentSettlementResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u67e5\u8be2\u95e8\u8bca\u7f34\u8d39\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody.getRcpts(), (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u95e8\u8bca\u7f34\u8d39\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u95e8\u8bca\u7f34\u8d39\u5f02\u5e38");
        }
    }

    public FrontResponse<List<GetOutpatientPaymentSettlementListRcpRes>> queryOutpatientPaymentSettlementList(FrontRequest<GetOutpatientPaymentSettlementListReqVO> param) {
        log.info("\u67e5\u8be2\u95e8\u8bca\u7f34\u8d39\u8bb0\u5f55\u5217\u8868\u5165\u53c2\uff1a" + param);
        try {
            GetOutpatientPaymentSettlementListReqVO body = (GetOutpatientPaymentSettlementListReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.PAYMENT_CONFIRMATION_LIST.getValue(), (HisBaseReqParamDTO)body, GetOutpatientPaymentSettlementListResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            GetOutpatientPaymentSettlementListResVO resBody = (GetOutpatientPaymentSettlementListResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u67e5\u8be2\u95e8\u8bca\u7f34\u8d39\u8bb0\u5f55\u5217\u8868\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody.getRcptList(), (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u95e8\u8bca\u7f34\u8d39\u8bb0\u5f55\u5217\u8868\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u95e8\u8bca\u7f34\u8d39\u8bb0\u5f55\u5217\u8868\u5f02\u5e38");
        }
    }

    public FrontResponse<List<QueryOutpatientPaymentRecordsFeeResVO>> queryOutpatientPaymentRecords(FrontRequest<QueryOutpatientPaymentRecordsReqVO> param) {
        log.info("\u67e5\u8be2\u5df2\u7f34\u8d39\u8be6\u60c5\u5165\u53c2\uff1a" + param);
        try {
            QueryOutpatientPaymentRecordsReqVO body = (QueryOutpatientPaymentRecordsReqVO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.PAYMENT_CONFIRMATION_DETAIL.getValue(), (HisBaseReqParamDTO)body, QueryOutpatientPaymentRecordsResVO.class);
            log.info("resDTO={}", (Object)resDTO);
            QueryOutpatientPaymentRecordsResVO resBody = (QueryOutpatientPaymentRecordsResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u67e5\u8be2\u5df2\u7f34\u8d39\u8be6\u60c5\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody.getFeeList(), (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u5df2\u7f34\u8d39\u8be6\u60c5\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u5df2\u7f34\u8d39\u8be6\u60c5\u5f02\u5e38");
        }
    }

    public FrontResponse<QueryIsRefundRes> isRefund(FrontRequest<QueryIsRefundReq> param) {
        log.info("\u67e5\u8be2\u662f\u5426\u53ef\u4ee5\u9000\u6b3e:{}", (Object)JSON.toJSONString(param));
        try {
            QueryIsRefundReq body = (QueryIsRefundReq)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.PAYMENT_CONFIRMATION_ISREFUND.getValue(), (HisBaseReqParamDTO)body, QueryIsRefundRes.class);
            log.info("resDTO={}", (Object)resDTO);
            QueryIsRefundRes resBody = (QueryIsRefundRes)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u8c03\u7528\u67e5\u8be2\u662f\u5426\u53ef\u4ee5\u9000\u6b3e");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u662f\u5426\u53ef\u4ee5\u9000\u6b3e\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u662f\u5426\u53ef\u4ee5\u9000\u6b3e\u5f02\u5e38");
        }
    }

    public FrontResponse<HisBaseResultVO> refund(FrontRequest<QueryIsRefundReq> param) {
        log.info("\u95e8\u8bca\u7f34\u8d39\u9000\u6b3e:{}", (Object)JSON.toJSONString(param));
        try {
            QueryIsRefundReq body = (QueryIsRefundReq)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.PAYMENT_CONFIRMATION_REFUND.getValue(), (HisBaseReqParamDTO)body, HisBaseResultVO.class);
            log.info("resDTO={}", (Object)resDTO);
            HisBaseResultVO resBody = (HisBaseResultVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u95e8\u8bca\u7f34\u8d39\u9000\u6b3e\u5f02\u5e38");
            }
            if (!SUCCESS_FLAG.equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u95e8\u8bca\u7f34\u8d39\u9000\u6b3e\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u95e8\u8bca\u7f34\u8d39\u9000\u6b3e\u5f02\u5e38");
        }
    }

    @Autowired
    public OutpatientPaymentServiceImpl() {
    }
}

