/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.his.common.enums.MethodNameEnum;
import com.ebaiyihui.his.model.base.FrontRequest;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.newHis.HisBaseReqParamDTO;
import com.ebaiyihui.his.model.newHis.report.GetReportListReqDTO;
import com.ebaiyihui.his.model.newHis.report.GetReportListResDTO;
import com.ebaiyihui.his.model.newHis.report.InspectReportDetailsResDTO;
import com.ebaiyihui.his.model.newHis.report.ReportDetailsReqDTO;
import com.ebaiyihui.his.model.report.GetReportListsReq;
import com.ebaiyihui.his.model.report.GetReportListsRes;
import com.ebaiyihui.his.model.report.LisReportListRes;
import com.ebaiyihui.his.model.report.PacsReportListRes;
import com.ebaiyihui.his.model.report.datas.GetReportListsData;
import com.ebaiyihui.his.model.report.datas.LisReportListResData;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.ReportService;
import com.ebaiyihui.his.utils.StringUtils;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceImpl
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(ReportServiceImpl.class);
    private final HisRemoteService hisRemoteService;
    public static final String SUCCESS_FLAG = "0";
    public static final String JY = "1";
    public static final String JC = "2";

    public FrontResponse<GetReportListsRes> getReportList(FrontRequest<GetReportListsReq> param) {
        GetReportListsReq reqBody = (GetReportListsReq)param.getBody();
        log.info("reqBody\uff1a" + reqBody.getReportType());
        if (JY.equals(reqBody.getReportType())) {
            reqBody.setReportType(JC);
        } else if (JC.equals(reqBody.getReportType())) {
            reqBody.setReportType(JY);
        }
        log.info("\u68c0\u67e5/\u68c0\u9a8c\u7533\u8bf7\u5355\u5217\u8868his\u5165\u53c2\uff1a" + reqBody);
        try {
            GetReportListReqDTO reqDTO = new GetReportListReqDTO();
            reqDTO.setReportType(reqBody.getReportType());
            reqDTO.setCardNo(reqBody.getCardNo());
            reqDTO.setStartDate(reqBody.getBeginTime());
            reqDTO.setEndDate(reqBody.getEndTime());
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodNameEnum.GET_REPORT_LIST.getValue(), (HisBaseReqParamDTO)reqDTO, GetReportListResDTO.class);
            log.info("resDTO{}", (Object)JSON.toJSONString((Object)resDTO));
            GetReportListResDTO response = (GetReportListResDTO)resDTO.getBody();
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            if (response.getItem().size() == 0) {
                return FrontResponse.success((String)param.getTransactionId(), (Object)new GetReportListsRes());
            }
            GetReportListsRes listsRes = new GetReportListsRes();
            listsRes.setPatientID(((GetReportListResDTO.ItemDTO)response.getItem().get(0)).getPatientId());
            listsRes.setPatientName(((GetReportListResDTO.ItemDTO)response.getItem().get(0)).getPatientName());
            listsRes.setPatientNo(((GetReportListResDTO.ItemDTO)response.getItem().get(0)).getCardNo());
            ArrayList<GetReportListsData> rList = new ArrayList<GetReportListsData>();
            for (GetReportListResDTO.ItemDTO itemDTO : response.getItem()) {
                GetReportListsData listsData = new GetReportListsData();
                listsData.setReportNo(itemDTO.getReportNo());
                String reportType = "";
                if (JY.equals(reqBody.getReportType())) {
                    reportType = JC;
                } else if (JC.equals(reqBody.getReportType())) {
                    reportType = JY;
                }
                JSONArray patientNameJsonArry = JSONObject.parseArray((String)itemDTO.getReportName());
                JSONObject reprotTimeJson = patientNameJsonArry.getJSONObject(0);
                String reportDate = reprotTimeJson.getString("reportTime");
                listsData.setReportType(reportType);
                String reportName = reprotTimeJson.getString("#text");
                listsData.setReportName(reportName);
                listsData.setApplyType(itemDTO.getApplyType());
                listsData.setApplyStatus(itemDTO.getApplyStatus());
                listsData.setReportTime(reportDate);
                listsData.setReportDate(reportDate);
                rList.add(listsData);
            }
            listsRes.setDatas(rList);
            return FrontResponse.success((String)param.getTransactionId(), (Object)listsRes);
        }
        catch (Exception e) {
            log.info("\u68c0\u67e5/\u68c0\u9a8c\u7533\u8bf7\u5355\u5217\u8868\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u68c0\u67e5/\u68c0\u9a8c\u7533\u8bf7\u5355\u5217\u8868\u5f02\u5e38");
        }
    }

    public FrontResponse<PacsReportListRes> inspectReportDetails(FrontRequest<ReportDetailsReqDTO> param) {
        log.info("\u68c0\u67e5\u62a5\u544a\u8be6\u60c5his\u5165\u53c2\uff1a" + param);
        try {
            ReportDetailsReqDTO body = (ReportDetailsReqDTO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodNameEnum.INSPECT_REPORT_DETAILS.getValue(), (HisBaseReqParamDTO)body, InspectReportDetailsResDTO.class);
            log.info("resDTO{}", (Object)JSON.toJSONString((Object)resDTO));
            InspectReportDetailsResDTO response = (InspectReportDetailsResDTO)resDTO.getBody();
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            PacsReportListRes listRes = new PacsReportListRes();
            listRes.setPatientName(response.getPatientName());
            listRes.setReportName(response.getItemName());
            listRes.setReportNo(response.getReportNo());
            listRes.setPatientNo(response.getPatientId());
            listRes.setSex(response.getSex());
            listRes.setAge(response.getAge());
            listRes.setDoctorName(response.getApplyDoctor());
            listRes.setWardName(response.getNursingUnit());
            listRes.setBed(response.getBed());
            listRes.setRoom(response.getRoom());
            listRes.setAuthTime(response.getReportDate());
            listRes.setAuthUser(response.getReportAutitor());
            listRes.setPrint(response.getPrint());
            listRes.setPatientDOB("");
            listRes.setAdmType(response.getAdmType());
            listRes.setCheckDesc(response.getMedicalAdvice());
            listRes.setCheckResult(response.getCheckResult());
            listRes.setDiagnosis(response.getDiagnosis());
            listRes.setRecUser(response.getCheckOper());
            listRes.setCheckDate(response.getCheckDate());
            listRes.setDeptName(response.getApplyDeptName());
            return FrontResponse.success((String)param.getTransactionId(), (Object)listRes);
        }
        catch (Exception e) {
            log.info("\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u5f02\u5e38");
        }
    }

    public FrontResponse<LisReportListRes> checkoutReportDetails(FrontRequest<ReportDetailsReqDTO> param) {
        log.info("\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5his\u5165\u53c2\uff1a" + param);
        try {
            ReportDetailsReqDTO body = (ReportDetailsReqDTO)param.getBody();
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodNameEnum.CHECKOUT_REPORT_DETAILS.getValue(), (HisBaseReqParamDTO)body, InspectReportDetailsResDTO.class);
            log.info("resDTO{}", (Object)JSON.toJSONString((Object)resDTO));
            InspectReportDetailsResDTO response = (InspectReportDetailsResDTO)resDTO.getBody();
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            LisReportListRes res = new LisReportListRes();
            ArrayList<LisReportListResData> list = new ArrayList<LisReportListResData>();
            res.setPatientName(response.getPatientName());
            res.setReportName(response.getItemName());
            res.setReportNo(response.getReportNo());
            res.setPatientNo(response.getCardNo());
            res.setSex(response.getSex());
            res.setAge(response.getAge());
            res.setDeptName(response.getApplyDeptName());
            res.setDoctorName(response.getApplyDoctor());
            res.setWardName(response.getNursingUnit());
            res.setBed(response.getBed());
            res.setRoom(response.getRoom());
            res.setSpecName(response.getSample());
            res.setSpecNo("");
            res.setRecTime(response.getReceiveDate());
            res.setRecUser(response.getReceiveAutitor());
            res.setAuthTime(response.getReportDate());
            res.setAuthUser(response.getReportAutitor());
            res.setColTime(response.getSampleDate());
            res.setPatientDOB("");
            res.setAdmType(response.getAdmType());
            res.setDiagnosis(response.getDiagnosis());
            if (response.getItems() != null) {
                for (InspectReportDetailsResDTO.ItemDTO itemDTO : response.getItems()) {
                    LisReportListResData lisReportListResData = new LisReportListResData();
                    lisReportListResData.setItmCode(itemDTO.getItemCode());
                    lisReportListResData.setItmName(itemDTO.getItemName());
                    lisReportListResData.setItmRes(itemDTO.getItemRes());
                    lisReportListResData.setItmUnit(itemDTO.getItemUnit());
                    lisReportListResData.setItmRanges(itemDTO.getItemRanges());
                    if (StringUtils.isNotBlank((CharSequence)itemDTO.getItemCrises())) {
                        String crises = itemDTO.getItemCrises();
                        if (crises.toUpperCase().equals("H")) {
                            lisReportListResData.setItmCrises("\u504f\u9ad8");
                        }
                        if (crises.toUpperCase().equals("L")) {
                            lisReportListResData.setItmCrises("\u504f\u4f4e");
                        }
                    }
                    list.add(lisReportListResData);
                }
            }
            res.setDatas(list);
            return FrontResponse.success((String)param.getTransactionId(), (Object)res);
        }
        catch (Exception e) {
            log.info("\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u5f02\u5e38");
        }
    }

    @Autowired
    public ReportServiceImpl(HisRemoteService hisRemoteService) {
        this.hisRemoteService = hisRemoteService;
    }
}

