/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.dto.DeptQueryReqVo;
import com.ebaiyihui.his.dto.DoctorQueryReqVo;
import com.ebaiyihui.his.dto.DoctorQueryResVo;
import com.ebaiyihui.his.dto.GetScheduleReqDTO;
import com.ebaiyihui.his.dto.GetScheduleResDTO;
import com.ebaiyihui.his.model.base.FrontRequest;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.newHis.HisBaseReqParamDTO;
import com.ebaiyihui.his.model.schedule.GetDeptDoctorInfoReqVO;
import com.ebaiyihui.his.model.schedule.GetDeptDoctorInfoResVO;
import com.ebaiyihui.his.model.schedule.GetDeptScheduleReqVO;
import com.ebaiyihui.his.model.schedule.GetDeptScheduleResVO;
import com.ebaiyihui.his.model.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.model.schedule.GetScheduleResVO;
import com.ebaiyihui.his.model.schedule.items.GetDeptDoctorInfoResItems;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.ScheduledService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScheduledServiceImpl
implements ScheduledService {
    private static final Logger log = LoggerFactory.getLogger(ScheduledServiceImpl.class);
    private final HisRemoteService hisRemoteService;

    public FrontResponse<GetDeptScheduleResVO> getDeptList(FrontRequest<GetDeptScheduleReqVO> param) {
        log.info("\u67e5\u8be2\u79d1\u5ba4his\u5165\u53c2\uff1a" + param);
        try {
            GetDeptScheduleReqVO getDeptScheduleReqVO = (GetDeptScheduleReqVO)param.getBody();
            DeptQueryReqVo deptQueryReqVo = new DeptQueryReqVo();
            deptQueryReqVo.setSourceType("ONLINE");
            deptQueryReqVo.setAreaName(getDeptScheduleReqVO.getAreaName());
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.QUERY_DEPT_INFO.getValue(), (HisBaseReqParamDTO)deptQueryReqVo, GetDeptScheduleResVO.class);
            GetDeptScheduleResVO resBody = (GetDeptScheduleResVO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"his\u67e5\u8be2\u79d1\u5ba4\u5f02\u5e38");
            }
            if (!"0".equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)resBody.getResultMsg());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)resBody, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2his\u79d1\u5ba4\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2his\u79d1\u5ba4\u5f02\u5e38");
        }
    }

    public FrontResponse<GetDeptDoctorInfoResVO> getDoctorList(FrontRequest<GetDeptDoctorInfoReqVO> param) {
        log.info("\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5165\u53c2\uff1a" + param);
        try {
            GetDeptDoctorInfoReqVO body = (GetDeptDoctorInfoReqVO)param.getBody();
            DoctorQueryReqVo doctorQueryReqVo = new DoctorQueryReqVo();
            doctorQueryReqVo.setSourceType("ONLINE");
            doctorQueryReqVo.setDocCode(body.getDocCode());
            doctorQueryReqVo.setDeptCode(body.getDeptCode());
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.QUERY_DOCTOR_INFO.getValue(), (HisBaseReqParamDTO)doctorQueryReqVo, DoctorQueryResVo.class);
            DoctorQueryResVo resBody = (DoctorQueryResVo)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"his\u67e5\u8be2\u533b\u751f\u5f02\u5e38");
            }
            if (!"0".equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)resBody.getResultMsg());
            }
            GetDeptDoctorInfoResVO getDeptDoctorInfoResVO = new GetDeptDoctorInfoResVO();
            ArrayList items = new ArrayList();
            List doctorItems = resBody.getItems();
            doctorItems.forEach(doctorItem -> {
                GetDeptDoctorInfoResItems getDeptDoctorInfoResItems = new GetDeptDoctorInfoResItems();
                getDeptDoctorInfoResItems.setDoctorCode(doctorItem.getDoctorCode());
                getDeptDoctorInfoResItems.setDoctorName(doctorItem.getDoctorName());
                getDeptDoctorInfoResItems.setDoctorTitleCode(doctorItem.getDoctorTitleCode());
                getDeptDoctorInfoResItems.setDoctorTitle(doctorItem.getDoctorTitle());
                items.add(getDeptDoctorInfoResItems);
            });
            getDeptDoctorInfoResVO.setItems(items);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getDeptDoctorInfoResVO, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2his\u533b\u751f\u4fe1\u606f\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2his\u533b\u751f\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public FrontResponse<GetScheduleResVO> getMorningAndAfternoonDocSchedule(FrontRequest<GetScheduleReqVO> param) {
        log.info("\u67e5\u8be2\u533b\u751f\u4e0a\u4e0b\u5348\u6392\u73ed\u63a5\u53e3\u5165\u53c2\uff1a" + param);
        try {
            GetScheduleReqVO body = (GetScheduleReqVO)param.getBody();
            GetScheduleReqDTO getScheduleReqDTO = new GetScheduleReqDTO();
            getScheduleReqDTO.setEndDate(body.getEndDate());
            getScheduleReqDTO.setStartDate(body.getStartDate());
            getScheduleReqDTO.setDeptCode(body.getDeptCode());
            getScheduleReqDTO.setDocCode(body.getDocCode());
            getScheduleReqDTO.setSourceType("ONLINE");
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.M_AND_A_SOURCE_LIST.getValue(), (HisBaseReqParamDTO)getScheduleReqDTO, GetScheduleResDTO.class);
            GetScheduleResDTO resBody = (GetScheduleResDTO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"his\u67e5\u8be2\u533b\u751f\u4e0a\u4e0b\u5348\u6392\u73ed\u5f02\u5e38");
            }
            if (!"0".equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)resBody.getResultMsg());
            }
            GetScheduleResVO getScheduleResVO = new GetScheduleResVO();
            BeanUtils.copyProperties((Object)resBody, (Object)getScheduleResVO);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getScheduleResVO, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u533b\u751f\u4e0a\u4e0b\u5348\u6392\u73ed\u4fe1\u606f\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u533b\u751f\u4e0a\u4e0b\u5348\u6392\u73ed\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public FrontResponse<GetScheduleResVO> getSchedule(FrontRequest<GetScheduleReqVO> param) {
        log.info("\u67e5\u8be2\u533b\u751f\u5206\u65f6\u6bb5\u6392\u73ed\u63a5\u53e3\u5165\u53c2\uff1a" + param);
        try {
            GetScheduleReqVO body = (GetScheduleReqVO)param.getBody();
            GetScheduleReqDTO getScheduleReqDTO = new GetScheduleReqDTO();
            getScheduleReqDTO.setEndDate(body.getEndDate());
            getScheduleReqDTO.setStartDate(body.getStartDate());
            getScheduleReqDTO.setDeptCode(body.getDeptCode());
            getScheduleReqDTO.setDocCode(body.getDocCode());
            getScheduleReqDTO.setSourceType("ONLINE");
            FrontResponse resDTO = this.hisRemoteService.requestHisJson(param.getTransactionId(), MethodCodeEnum.I_T_SOURCE_LIST.getValue(), (HisBaseReqParamDTO)getScheduleReqDTO, GetScheduleResDTO.class);
            GetScheduleResDTO resBody = (GetScheduleResDTO)resDTO.getBody();
            if (null == resBody) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"his\u67e5\u8be2\u533b\u751f\u5206\u65f6\u6bb5\u6392\u73ed\u5f02\u5e38");
            }
            if (!"0".equals(resBody.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)resBody.getResultMsg());
            }
            GetScheduleResVO getScheduleResVO = new GetScheduleResVO();
            BeanUtils.copyProperties((Object)resBody, (Object)getScheduleResVO);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getScheduleResVO, (String)resBody.getResultMsg());
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u533b\u751f\u5206\u65f6\u6bb5\u6392\u73ed\u4fe1\u606f\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u533b\u751f\u5206\u65f6\u6bb5\u6392\u73ed\u4fe1\u606f\u5f02\u5e38");
        }
    }

    @Autowired
    public ScheduledServiceImpl(HisRemoteService hisRemoteService) {
        this.hisRemoteService = hisRemoteService;
    }
}

