/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.his.dto.SyncDeptReqDTO;
import com.ebaiyihui.his.dto.SyncDoctorReqDTO;
import com.ebaiyihui.his.dto.SyncEvaluateReqDTO;
import com.ebaiyihui.his.dto.SyncInquiryReqDTO;
import com.ebaiyihui.his.dto.SyncLisRisInfoReqDTO;
import com.ebaiyihui.his.dto.SyncMsgRemindReqDTO;
import com.ebaiyihui.his.dto.SyncPrescriptionReqDTO;
import com.ebaiyihui.his.model.base.FrontRequest;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.service.SyncHospitalService;
import com.ebaiyihui.his.utils.HttpUtils;
import com.ebaiyihui.his.vo.ReturnVo;
import com.wondersgroup.common.decrypt.utils.Sm4HexDe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SyncHospitalServiceImpl
implements SyncHospitalService {
    private static final Logger log = LoggerFactory.getLogger(SyncHospitalServiceImpl.class);
    @Value(value="${provincePlatformSyncUrl}")
    private String syncUrlPrefix;
    @Value(value="${syncDeptSign}")
    private String syncDeptSign;
    @Value(value="${syncDoctorSign}")
    private String syncDoctorSign;
    @Value(value="${syncInquirySign}")
    private String syncInquirySign;
    @Value(value="${syncPrescriptionSign}")
    private String syncPrescriptionSign;
    @Value(value="${syncEvaluateSign}")
    private String syncEvaluateSign;
    @Value(value="${syncLisRisInfoSign}")
    private String syncLisRisInfoSign;
    @Value(value="${syncMsgRemindSign}")
    private String syncMsgRemindSign;

    public FrontResponse<String> syncDept(FrontRequest<SyncDeptReqDTO> param) {
        try {
            log.info("\u540c\u6b65\u79d1\u5ba4\u4fe1\u606f\u5165\u53c2\u4fe1\u606f={}", param);
            String body = JSONObject.toJSONString((Object)param.getBody());
            String url = this.syncUrlPrefix + "deptSync";
            String result = HttpUtils.cdfyPost((String)this.syncDeptSign, (String)url, (String)body);
            ReturnVo returnVo = (ReturnVo)JSONObject.parseObject((String)result, ReturnVo.class);
            log.info("returnVo={}", (Object)returnVo);
            if (ReturnVo.SUCCESS_CODE == returnVo.getReturnCode()) {
                String data = Sm4HexDe.decode((String)((String)returnVo.getData()));
                return FrontResponse.success((String)param.getTransactionId(), (Object)data);
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)returnVo.getErrorMessage());
        }
        catch (Exception e) {
            log.info("\u8c03\u7528\u5e02\u5e73\u53f0\u540c\u6b65\u79d1\u5ba4\u4fe1\u606f\u51fa\u9519\uff01", (Throwable)e);
            return FrontResponse.error((String)"\u8c03\u7528\u5e02\u5e73\u53f0\u540c\u6b65\u79d1\u5ba4\u4fe1\u606f\u51fa\u9519\uff01");
        }
    }

    public FrontResponse<String> syncDoctor(FrontRequest<SyncDoctorReqDTO> param) {
        try {
            log.info("\u540c\u6b65\u533b\u751f\u4fe1\u606f\u5165\u53c2\u4fe1\u606f={}", param);
            String body = JSONObject.toJSONString((Object)param.getBody());
            String url = this.syncUrlPrefix + "doctorSync";
            String result = HttpUtils.cdfyPost((String)this.syncDoctorSign, (String)url, (String)body);
            ReturnVo returnVo = (ReturnVo)JSONObject.parseObject((String)result, ReturnVo.class);
            log.info("returnVo={}", (Object)returnVo);
            if (ReturnVo.SUCCESS_CODE == returnVo.getReturnCode()) {
                String data = Sm4HexDe.decode((String)((String)returnVo.getData()));
                return FrontResponse.success((String)param.getTransactionId(), (Object)data);
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)returnVo.getErrorMessage());
        }
        catch (Exception e) {
            log.info("\u8c03\u7528\u5e02\u5e73\u53f0\u540c\u6b65\u533b\u751f\u4fe1\u606f\u51fa\u9519\uff01", (Throwable)e);
            return FrontResponse.error((String)"\u8c03\u7528\u5e02\u5e73\u53f0\u540c\u6b65\u533b\u751f\u4fe1\u606f\u51fa\u9519\uff01");
        }
    }

    public FrontResponse<String> syncInquiry(FrontRequest<SyncInquiryReqDTO> param) {
        try {
            log.info("\u540c\u6b65\u95ee\u8bca\u4fe1\u606f\u5165\u53c2\u4fe1\u606f={}", param);
            String body = JSONObject.toJSONString((Object)param.getBody());
            String url = this.syncUrlPrefix + "saveInquiry";
            String result = HttpUtils.cdfyPost((String)this.syncInquirySign, (String)url, (String)body);
            ReturnVo returnVo = (ReturnVo)JSONObject.parseObject((String)result, ReturnVo.class);
            log.info("returnVo={}", (Object)returnVo);
            if (ReturnVo.SUCCESS_CODE == returnVo.getReturnCode()) {
                String data = Sm4HexDe.decode((String)((String)returnVo.getData()));
                return FrontResponse.success((String)param.getTransactionId(), (Object)data);
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)returnVo.getErrorMessage());
        }
        catch (Exception e) {
            log.info("\u8c03\u7528\u5e02\u5e73\u53f0\u540c\u6b65\u95ee\u8bca\u4fe1\u606f\u51fa\u9519\uff01", (Throwable)e);
            return FrontResponse.error((String)"\u8c03\u7528\u5e02\u5e73\u53f0\u540c\u6b65\u95ee\u8bca\u4fe1\u606f\u51fa\u9519\uff01");
        }
    }

    public FrontResponse<String> syncPrescription(FrontRequest<SyncPrescriptionReqDTO> param) {
        try {
            log.info("\u540c\u6b65\u5904\u65b9\u4fe1\u606f\u5165\u53c2\u4fe1\u606f={}", param);
            String body = JSONObject.toJSONString((Object)param.getBody());
            String url = this.syncUrlPrefix + "savePrescription";
            String result = HttpUtils.cdfyPost((String)this.syncPrescriptionSign, (String)url, (String)body);
            ReturnVo returnVo = (ReturnVo)JSONObject.parseObject((String)result, ReturnVo.class);
            log.info("returnVo={}", (Object)returnVo);
            if (ReturnVo.SUCCESS_CODE == returnVo.getReturnCode()) {
                String data = Sm4HexDe.decode((String)((String)returnVo.getData()));
                return FrontResponse.success((String)param.getTransactionId(), (Object)data);
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)returnVo.getErrorMessage());
        }
        catch (Exception e) {
            log.info("\u8c03\u7528\u5e02\u5e73\u53f0\u540c\u6b65\u5904\u65b9\u4fe1\u606f\u51fa\u9519\uff01", (Throwable)e);
            return FrontResponse.error((String)"\u8c03\u7528\u5e02\u5e73\u53f0\u540c\u6b65\u5904\u65b9\u4fe1\u606f\u51fa\u9519\uff01");
        }
    }

    public FrontResponse<String> syncEvaluate(FrontRequest<SyncEvaluateReqDTO> param) {
        try {
            log.info("\u540c\u6b65\u8bc4\u4ef7\u4fe1\u606f\u5165\u53c2\u4fe1\u606f={}", param);
            String body = JSONObject.toJSONString((Object)param.getBody());
            String url = this.syncUrlPrefix + "saveEvaluate";
            String result = HttpUtils.cdfyPost((String)this.syncEvaluateSign, (String)url, (String)body);
            ReturnVo returnVo = (ReturnVo)JSONObject.parseObject((String)result, ReturnVo.class);
            log.info("returnVo={}", (Object)returnVo);
            if (ReturnVo.SUCCESS_CODE == returnVo.getReturnCode()) {
                String data = Sm4HexDe.decode((String)((String)returnVo.getData()));
                return FrontResponse.success((String)param.getTransactionId(), (Object)data);
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)returnVo.getErrorMessage());
        }
        catch (Exception e) {
            log.info("\u8c03\u7528\u5e02\u5e73\u53f0\u540c\u6b65\u8bc4\u4ef7\u4fe1\u606f\u51fa\u9519\uff01", (Throwable)e);
            return FrontResponse.error((String)"\u8c03\u7528\u5e02\u5e73\u53f0\u540c\u6b65\u8bc4\u4ef7\u4fe1\u606f\u51fa\u9519\uff01");
        }
    }

    public FrontResponse<String> syncLisRisInfo(FrontRequest<SyncLisRisInfoReqDTO> param) {
        try {
            log.info("\u540c\u6b65\u68c0\u9a8c\u68c0\u67e5\u4fe1\u606f\u5165\u53c2\u4fe1\u606f={}", param);
            String body = JSONObject.toJSONString((Object)param.getBody());
            String url = this.syncUrlPrefix + "lisRisInfo";
            String result = HttpUtils.cdfyPost((String)this.syncLisRisInfoSign, (String)url, (String)body);
            ReturnVo returnVo = (ReturnVo)JSONObject.parseObject((String)result, ReturnVo.class);
            log.info("returnVo={}", (Object)returnVo);
            if (ReturnVo.SUCCESS_CODE == returnVo.getReturnCode()) {
                String data = Sm4HexDe.decode((String)((String)returnVo.getData()));
                return FrontResponse.success((String)param.getTransactionId(), (Object)data);
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)returnVo.getErrorMessage());
        }
        catch (Exception e) {
            log.info("\u8c03\u7528\u5e02\u5e73\u53f0\u540c\u6b65\u68c0\u9a8c\u68c0\u67e5\u4fe1\u606f\u51fa\u9519\uff01", (Throwable)e);
            return FrontResponse.error((String)"\u8c03\u7528\u5e02\u5e73\u53f0\u540c\u6b65\u68c0\u9a8c\u68c0\u67e5\u4fe1\u606f\u51fa\u9519\uff01");
        }
    }

    public FrontResponse<String> syncMsgRemind(FrontRequest<SyncMsgRemindReqDTO> param) {
        try {
            log.info("\u540c\u6b65\u6d88\u606f\u4fe1\u606f\u5165\u53c2\u4fe1\u606f={}", param);
            String body = JSONObject.toJSONString((Object)param.getBody());
            String url = this.syncUrlPrefix + "msgRemind";
            String result = HttpUtils.cdfyPost((String)this.syncMsgRemindSign, (String)url, (String)body);
            ReturnVo returnVo = (ReturnVo)JSONObject.parseObject((String)result, ReturnVo.class);
            log.info("returnVo={}", (Object)returnVo);
            if (ReturnVo.SUCCESS_CODE == returnVo.getReturnCode()) {
                String data = Sm4HexDe.decode((String)((String)returnVo.getData()));
                return FrontResponse.success((String)param.getTransactionId(), (Object)data);
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)returnVo.getErrorMessage());
        }
        catch (Exception e) {
            log.info("\u8c03\u7528\u5e02\u5e73\u53f0\u540c\u6b65\u6d88\u606f\u4fe1\u606f\u51fa\u9519\uff01", (Throwable)e);
            return FrontResponse.error((String)"\u8c03\u7528\u5e02\u5e73\u53f0\u540c\u6b65\u6d88\u606f\u4fe1\u606f\u51fa\u9519\uff01");
        }
    }
}

