/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.utils;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtil {
    public static final String FORMAT = "yyyyMMddHHmmss";
    public static String FULL_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static String TIME_FORMAT = "HH:mm:ss";
    public static String DATE_FORMAT = "yyyy-MM-dd";

    public static String getCurrentTimeStr() {
        Date currentDate = new Date();
        SimpleDateFormat format = new SimpleDateFormat(TIME_FORMAT);
        return format.format(currentDate);
    }

    public static String getCurrentDateStr() {
        Date currentDate = new Date();
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        return format.format(currentDate);
    }

    public static String dateStrToStamp(String s) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FULL_FORMAT);
        Date date = simpleDateFormat.parse(s);
        long ts = date.getTime();
        String res = String.valueOf(ts);
        return res;
    }

    public static Date parseDate(String str, String parsePatterns) throws ParseException {
        if (str == null || parsePatterns == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        SimpleDateFormat parser = null;
        ParsePosition pos = new ParsePosition(0);
        parser = new SimpleDateFormat(parsePatterns);
        pos.setIndex(0);
        Date date = parser.parse(str, pos);
        if (date != null && pos.getIndex() == str.length()) {
            return date;
        }
        throw new ParseException("Unable to parse the date: " + str, -1);
    }

    public static Date getAfterCurrentDay(int days) {
        Date result = null;
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.add(7, days);
            result = calendar.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getPastDate(int past) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(6, calendar.get(6) - past);
        Date today = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        String result = format.format(today);
        return result;
    }

    public static Date getSubtractMonth(Date date, int month) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(2, -month);
        return now.getTime();
    }

    public static String dateToSimpleString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        return df.format(date);
    }

    public static String dateToSimple(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(FULL_FORMAT);
        return df.format(date);
    }

    public static boolean checkTimeRange(String startTime, String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            Date startDate = sdf.parse(startTime);
            Date endDate = sdf.parse(DateTimeFormatter.ofPattern(format).format(LocalDateTime.now()));
            return startDate.after(endDate);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean timeRange(String startTime, String endTime) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            Date endDate = sdf.parse(endTime);
            Date startDate = sdf.parse(startTime);
            return startDate.after(endDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Date strToDate(String str, String parsePatterns) throws ParseException {
        return DateUtil.parseDate((String)str, (String)parsePatterns);
    }

    public static int getAgeByBirth(Date birthDay) throws ParseException {
        int age = 0;
        Calendar cal = Calendar.getInstance();
        if (cal.before(birthDay)) {
            throw new IllegalArgumentException("The birthDay is before Now.It's unbelievable!");
        }
        int yearNow = cal.get(1);
        int monthNow = cal.get(2);
        int dayOfMonthNow = cal.get(5);
        cal.setTime(birthDay);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2);
        int dayOfMonthBirth = cal.get(5);
        age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }
}

