/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.dfs.pojo;

import com.ebaiyihui.dfs.enums.ErrorEnum;

public class BaseResponse<T> {
    public static final String DEFAULT_SUCCESS_MESSAGE = "\u64cd\u4f5c\u6210\u529f";
    public static final String DEFAULT_ERROR_MESSAGE = "\u64cd\u4f5c\u5931\u8d25";
    public static final String DEFAULT_SUCCESS_CODE = "1";
    public static final String DEFAULT_ERROR_CODE = "0";
    private String code;
    private String errCode = "0";
    private String msg;
    private T data;

    public BaseResponse() {
    }

    public BaseResponse(String code, String msg, T data) {
        this.code = code;
        this.data = data;
        this.msg = msg;
    }

    public static <T> BaseResponse<T> success(T t) {
        BaseResponse<T> res = new BaseResponse<T>();
        res.setCode(DEFAULT_SUCCESS_CODE);
        res.setMsg(DEFAULT_SUCCESS_MESSAGE);
        res.setData(t);
        return res;
    }

    public static <T> BaseResponse<T> success() {
        BaseResponse<T> res = new BaseResponse<T>();
        res.setCode(DEFAULT_SUCCESS_CODE);
        res.setMsg(DEFAULT_SUCCESS_MESSAGE);
        res.setData(null);
        return res;
    }

    public static <T> BaseResponse<T> error(ErrorEnum error) {
        BaseResponse<T> res = new BaseResponse<T>();
        res.setCode(DEFAULT_ERROR_CODE);
        res.setErrCode(error.getErrCode());
        res.setMsg(error.getMsg());
        res.setData(null);
        return res;
    }

    public static <T> BaseResponse<T> error(ErrorEnum error, String msg) {
        BaseResponse<T> res = new BaseResponse<T>();
        res.setCode(DEFAULT_ERROR_CODE);
        res.setErrCode(error.getErrCode());
        res.setMsg(msg);
        res.setData(null);
        return res;
    }

    public String getCode() {
        return this.code;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseResponse)) {
            return false;
        }
        BaseResponse other = (BaseResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$errCode = this.getErrCode();
        String other$errCode = other.getErrCode();
        if (this$errCode == null ? other$errCode != null : !this$errCode.equals(other$errCode)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $errCode = this.getErrCode();
        result = result * 59 + ($errCode == null ? 43 : $errCode.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "BaseResponse(code=" + this.getCode() + ", errCode=" + this.getErrCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }
}

