/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.dfs.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtils {
    private RestTemplateUtils() {
    }

    public static RestTemplate getResttemplate() {
        RestTemplate restTemplate = new RestTemplate();
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(1000);
        requestFactory.setReadTimeout(1000);
        restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler());
        return restTemplate;
    }

    private static class DefaultResponseErrorHandler
    implements ResponseErrorHandler {
        private DefaultResponseErrorHandler() {
        }

        public boolean hasError(ClientHttpResponse response) throws IOException {
            return response.getStatusCode().value() != 200;
        }

        public void handleError(ClientHttpResponse response) throws IOException {
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getBody()));
            StringBuilder sb = new StringBuilder();
            String str = null;
            while ((str = br.readLine()) != null) {
                sb.append(str);
            }
            try {
                throw new Exception(sb.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

