/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.config;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitMqConfig {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqConfig.class);
    public static final String ORDER_DELAY_QUEUE_1 = "byh-family-doctor-delay-queue";
    public static final String ORDER_DELAY_EXCHANGE = "byh-family-doctor-delay-exchange";
    public static final String ORDER_ROUTING_KEY_5 = "family-doctor-order-key";
    public static final String INQUIRY_END_PRE_QUEUE_NAME = "family.doctor.end.pre";
    public static final String INQUIRY_END_PRE_KEY = "family.doctor-end-pre-key";

    @Bean
    public Queue queue() {
        return new Queue("family-doctor", true);
    }

    @Bean
    DirectExchange exchange() {
        return new DirectExchange("family-doctor-exchange", false, false);
    }

    @Bean
    public Binding binding() {
        return BindingBuilder.bind((Queue)this.queue()).to(this.exchange()).with("family-doctor");
    }

    @Bean
    public Queue delayedQueue() {
        return new Queue(ORDER_DELAY_QUEUE_1, true);
    }

    @Bean
    public CustomExchange orderDelayExchange1() {
        HashMap<String, String> param = new HashMap<String, String>(10);
        param.put("x-delayed-type", "direct");
        return new CustomExchange(ORDER_DELAY_EXCHANGE, "x-delayed-message", true, false, param);
    }

    @Bean
    public Binding orderBinding5() {
        return BindingBuilder.bind((Queue)this.delayedQueue()).to((Exchange)this.orderDelayExchange1()).with(ORDER_ROUTING_KEY_5).noargs();
    }

    @Bean
    public Queue familyDoctorEndPreQueue() {
        return new Queue(INQUIRY_END_PRE_QUEUE_NAME, true);
    }

    @Bean
    public Binding familyDoctorEndPreBinding() {
        return BindingBuilder.bind((Queue)this.familyDoctorEndPreQueue()).to((Exchange)this.orderDelayExchange1()).with(INQUIRY_END_PRE_KEY).noargs();
    }
}

