/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.config;

import com.ebaiyihui.family.doctor.server.config.JedisProperties;
import com.ebaiyihui.family.doctor.server.config.RedisProperties;
import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class RedisConfig {
    @Autowired
    private RedisProperties redisProperties;
    @Autowired
    private JedisProperties jedisProperties;

    @Bean
    public JedisCluster getJedisCluster() {
        String[] cluster = this.redisProperties.getCluster().getNodes().toArray(new String[0]);
        HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
        for (String node : cluster) {
            String[] host = node.split(":");
            nodes.add(new HostAndPort(host[0], Integer.parseInt(host[1])));
        }
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxIdle(this.jedisProperties.getMaxIdle().intValue());
        jedisPoolConfig.setMaxWaitMillis((long)this.jedisProperties.getMaxWait().intValue());
        JedisCluster jedisCluster = new JedisCluster(nodes, this.redisProperties.getTimeout(), (GenericObjectPoolConfig)jedisPoolConfig);
        return jedisCluster;
    }
}

