/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.family.doctor.common.bo.ImMessageDTO;
import com.ebaiyihui.family.doctor.common.dto.SendImMsgDTO;
import com.ebaiyihui.family.doctor.server.service.ImMsgTemplateService;
import com.ebaiyihui.family.doctor.server.util.RedisUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/imMsgTemplate"})
@Api(tags={"\u6d88\u606f\u53d1\u9001API"})
public class ImMsgTemplateController {
    private static final Logger log = LoggerFactory.getLogger(ImMsgTemplateController.class);
    @Autowired
    private ImMsgTemplateService imMsgTemplateService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String JTYS_SEND_IM_MESSAGE = "jtys_send_im_message_";
    private static final Integer OUT_TIME = 600;

    @RequestMapping(value={"/sendImMsg"}, method={RequestMethod.POST})
    public BaseResponse<String> sendImMsg(@RequestBody SendImMsgDTO reqVo, BindingResult bindingResult) {
        String response = null;
        try {
            String key = JTYS_SEND_IM_MESSAGE + reqVo.getAdmId() + "_" + reqVo.getType();
            String sendImMsgKeyValue = this.redisUtil.get(key);
            log.info("sendImMsgKeyValue={}", (Object)String.valueOf(sendImMsgKeyValue));
            if (Objects.isNull(sendImMsgKeyValue)) {
                response = this.imMsgTemplateService.sendImMsg(reqVo);
                this.redisUtil.set(String.valueOf(key), JSONObject.toJSONString((Object)reqVo), (long)OUT_TIME.intValue());
            }
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success(response);
    }

    @RequestMapping(value={"/unReadMsgCount"}, method={RequestMethod.POST})
    public BaseResponse<String> unReadMsgCount(@RequestBody ImMessageDTO imMessageDTO, BindingResult bindingResult) {
        BaseResponse response = null;
        try {
            response = this.imMsgTemplateService.unReadMsgCount(imMessageDTO);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)"\u6d88\u606f\u63a8\u9001\u6210\u529f");
    }
}

