/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.controller;

import com.ebaiyihui.family.doctor.common.dto.ImAccountReqDTO;
import com.ebaiyihui.family.doctor.common.dto.ImInfoDetailDocReqDTO;
import com.ebaiyihui.family.doctor.common.dto.ImInfoListDocReqDTO;
import com.ebaiyihui.family.doctor.common.dto.MasterUrlDTO;
import com.ebaiyihui.family.doctor.common.dto.RequestGetDoctorOfficeStatusDTO;
import com.ebaiyihui.family.doctor.common.dto.RequestServiceConfigDTO;
import com.ebaiyihui.family.doctor.common.vo.ImAccountVo;
import com.ebaiyihui.family.doctor.common.vo.ImInfoDetailDocResVo;
import com.ebaiyihui.family.doctor.common.vo.ImInfoListResVo;
import com.ebaiyihui.family.doctor.common.vo.ImInfoResVo;
import com.ebaiyihui.family.doctor.common.vo.RequestOnlineOrOfflineVo;
import com.ebaiyihui.family.doctor.server.service.PatientSignService;
import com.ebaiyihui.family.doctor.server.service.ServiceConfigService;
import com.ebaiyihui.family.doctor.server.util.PageUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.IMQueryMsgReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryUserLoginReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryUserLoginRspVO;
import com.ebaiyihui.imforward.client.vo.IMSingleMsgResultVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/patientSign"})
@Api(tags={"\u60a3\u8005\u7b7e\u540dAPI"})
public class PatientSignController {
    private static final Logger log = LoggerFactory.getLogger(PatientSignController.class);
    @Autowired
    private PatientSignService patientSignService;
    @Autowired
    private ServiceConfigService serviceConfigService;

    @ApiOperation(value="\u67e5\u8be2im\u804a\u5929\u6d88\u606f\u8bb0\u5f55", httpMethod="POST", notes="\u67e5\u8be2im\u6d88\u606f\u8bb0\u5f55")
    @RequestMapping(value={"/getMsg"}, method={RequestMethod.POST})
    public BaseResponse<List<IMSingleMsgResultVO>> getAllMsgContent(@RequestBody IMQueryMsgReqVO reqVO) {
        return this.patientSignService.getAllMsgContent(reqVO);
    }

    @ApiOperation(value="\u67e5\u8be2IM\u76f8\u5173\u4fe1\u606f")
    @GetMapping(value={"/v1/queryImInfo"})
    public BaseResponse<ImInfoResVo> queryImInfo(@RequestParam(value="admId") String admId) {
        return this.patientSignService.queryImInfo(admId);
    }

    @ApiOperation(value="\u533b\u751fAppIM\u5217\u8868")
    @PostMapping(value={"/v1/queryImInfoList"})
    public BaseResponse<PageUtil<ImInfoListResVo>> queryImInfoList(@RequestBody ImInfoListDocReqDTO param) {
        return this.patientSignService.queryImInfoList(param);
    }

    @ApiOperation(value="\u533b\u751fIM\u8be6\u60c5")
    @PostMapping(value={"/v1/queryImInfoDetail"})
    public BaseResponse<ImInfoDetailDocResVo> queryImInfoDetail(@RequestBody ImInfoDetailDocReqDTO param) {
        return this.patientSignService.queryImInfoDetail(param);
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u751f\u4e0a\u4e0b\u7ebf\u72b6\u6001", notes="\u67e5\u8be2\u533b\u751f\u4e0a\u4e0b\u7ebf\u72b6\u6001")
    @RequestMapping(value={"/v1/getDoctorOfficeStatus"}, method={RequestMethod.POST})
    public BaseResponse<RequestOnlineOrOfflineVo> getDoctorOfficeStatus(@RequestBody RequestGetDoctorOfficeStatusDTO requestGetDoctorOfficeStatusDTO) {
        RequestOnlineOrOfflineVo onlineOrOfflineVo = new RequestOnlineOrOfflineVo();
        try {
            onlineOrOfflineVo = this.serviceConfigService.getDoctorOfficeStatus(requestGetDoctorOfficeStatusDTO);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)onlineOrOfflineVo);
    }

    @ApiOperation(value="\u533b\u751f\u4e0a\u4e0b\u7ebf", notes="\u533b\u751f\u4e0a\u7ebf\u4e0b\u7ebf\u64cd\u4f5c")
    @RequestMapping(value={"/v2/officeOnlineOrOffline"}, method={RequestMethod.POST})
    public BaseResponse<RequestOnlineOrOfflineVo> officeOnlineOrOffline(@RequestBody RequestOnlineOrOfflineVo requestOnlineOrOfflineVo) {
        RequestOnlineOrOfflineVo onlineOrOfflineVo = new RequestOnlineOrOfflineVo();
        try {
            onlineOrOfflineVo = this.serviceConfigService.officeOnlineOrOffline(requestOnlineOrOfflineVo);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)onlineOrOfflineVo);
    }

    @ApiOperation(value="\u6dfb\u52a0/\u4fee\u6539\u533b\u751f\u670d\u52a1\u4fe1\u606f")
    @RequestMapping(value={"/saveServiceInfo"}, method={RequestMethod.POST})
    public BaseResponse<Object> saveServiceInfo(@RequestBody @Validated RequestServiceConfigDTO serviceConfigDTO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.serviceConfigService.saveServiceInfo(serviceConfigDTO);
    }

    @ApiOperation(value="\u83b7\u53d6im\u8d26\u53f7,==\u804a\u5929\u754c\u9762", notes="\u83b7\u53d6\u533b\u751f\u548c\u75c5\u4eba\u7684im\u8d26\u53f7")
    @RequestMapping(value={"/queryImAccount"}, method={RequestMethod.POST})
    public BaseResponse<ImAccountVo> queryImAccount(@RequestBody @Validated ImAccountReqDTO param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.patientSignService.queryImAccount(param);
    }

    @ApiOperation(value="\u67e5\u8be2APP\u5ba2\u6237\u7aef\u662f\u6216\u5426\u9700\u8981\u767b\u9646IM", httpMethod="POST", notes="\u67e5\u8be2APP\u5ba2\u6237\u7aef\u662f\u6216\u5426\u9700\u8981\u767b\u9646IM")
    @RequestMapping(value={"/querysdklogin"}, method={RequestMethod.POST})
    public BaseResponse<IMQueryUserLoginRspVO> querySdkLogin(@RequestBody IMQueryUserLoginReqVO reqVO) {
        return this.patientSignService.querySdkLogin(reqVO);
    }

    @RequestMapping(value={"/queryMasterUrl"}, method={RequestMethod.POST})
    public BaseResponse<String> queryMasterUrl(@RequestBody MasterUrlDTO reqVo, BindingResult bindingResult) {
        BaseResponse response = null;
        try {
            response = this.patientSignService.queryMasterUrl(reqVo);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return response;
    }
}

