/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.rabbitmq;

import com.ebaiyihui.family.doctor.common.dto.NotifyConsultDataDTO;
import com.ebaiyihui.family.doctor.server.common.enums.StatusEnum;
import com.ebaiyihui.family.doctor.server.entity.MobileBenefitPackageEntity;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.mapper.MobileBenefitPackageMapper;
import com.ebaiyihui.family.doctor.server.mapper.PatientSignMapper;
import com.ebaiyihui.family.doctor.server.util.DateUtils;
import com.ebaiyihui.family.doctor.server.util.ThirdOrderPushUtil;
import com.ebaiyihui.family.doctor.server.vo.OrderTaskVo;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class RabbitConsumer {
    private static final Logger log = LoggerFactory.getLogger(RabbitConsumer.class);
    @Autowired
    private PatientSignMapper patientSignMapper;
    @Autowired
    private MobileBenefitPackageMapper mobileBenefitPackageMapper;
    @Autowired
    private ThirdOrderPushUtil thirdOrderPushUtil;

    @RabbitListener(queues={"byh-family-doctor-delay-queue"})
    public void orderDelayQueue1(@Payload OrderTaskVo orderTaskVo) {
        log.info("\u5b9a\u65f6\u4efb\u52a1\u76d1\u542c\u7ed3\u679c\uff1a{}", (Object)orderTaskVo.toString());
        try {
            String id = orderTaskVo.getId();
            log.info("\u3010orderDelayQueue \u76d1\u542c\u7684\u6d88\u606f\u3011 - \u3010\u6d88\u8d39\u65f6\u95f4\u3011 - [{}]- \u3010\u8ba2\u5355ID\u3011 - [{}]", (Object)new Date(), (Object)id);
            PatientSignEntity patientSignEntity = (PatientSignEntity)this.patientSignMapper.selectById((Serializable)((Object)id));
            if (null == patientSignEntity) {
                return;
            }
            if (StatusEnum.IN_CONSULTATION.getValue().equals(patientSignEntity.getStatus())) {
                patientSignEntity.setStatus(StatusEnum.FINISH_APPLY.getValue());
                this.patientSignMapper.updateById((Object)patientSignEntity);
                MobileBenefitPackageEntity entity = this.mobileBenefitPackageMapper.queryByPhone(patientSignEntity.getPatientPhone(), patientSignEntity.getPackageOrderId(), "1");
                if (!ObjectUtils.isEmpty((Object)entity)) {
                    NotifyConsultDataDTO notifyConsultDataDTO = new NotifyConsultDataDTO();
                    notifyConsultDataDTO.setActivateOrderId(patientSignEntity.getPackageOrderId());
                    notifyConsultDataDTO.setConsultOrderNo(patientSignEntity.getAdmId());
                    notifyConsultDataDTO.setStatus(String.valueOf(StatusEnum.FINISH_APPLY.getValue()));
                    notifyConsultDataDTO.setProductId(entity.getProductId());
                    notifyConsultDataDTO.setPatientId(entity.getUserId());
                    notifyConsultDataDTO.setExpertName(patientSignEntity.getDoctorName());
                    notifyConsultDataDTO.setOrderDate(DateUtils.dateToFullString((Date)patientSignEntity.getCreateTime()));
                    notifyConsultDataDTO.setSupplierCode("zhongkang_mfd");
                    this.thirdOrderPushUtil.syncBenefitUsedOrder(notifyConsultDataDTO, null);
                }
            }
        }
        catch (Exception e) {
            log.info("orderDelayQueue\u76d1\u542c\u5f02\u5e38", (Throwable)e);
            return;
        }
    }
}

